<?php
ob_start();
session_start();
require_once('admin/db/config.php');
if( !empty($_POST['email']) && !empty($_POST['newpassword']) && !empty($_POST['confirmnewpassword'])){
	$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) ;
	$newpassword = filter_var($_POST['newpassword'], FILTER_SANITIZE_STRING);
	$confirmnewpassword = filter_var($_POST['confirmnewpassword'], FILTER_SANITIZE_STRING) ;
	$uppercase = preg_match('@[A-Z]@', $newpassword);
	$lowercase = preg_match('@[a-z]@', $newpassword);
	$number    = preg_match('@[0-9]@', $newpassword);
	//validate password
	if(!$uppercase || !$lowercase || !$number || strlen($newpassword) < 8) {
		$_SESSION['error_message'] = 'Password must contain 8 characters, an uppercase character, a lowercase character & atleast 1 number. Try Again';
		 header("location: index.php");
	} else {
		//check password and confirm password are same
		if($newpassword == $confirmnewpassword) {
			$update_user_otp = $pdo->prepare("UPDATE customer_active SET user_authpass=? WHERE user_email=?");
			$update_user_otp->execute(array(password_hash($newpassword, PASSWORD_DEFAULT),$email));
			$_SESSION['error_message'] = 'Password changed successfully. Login Now';
		 	header("location: index.php");
		
		} else {
			$_SESSION['error_message'] = 'New Password & Confirm New Password are not same. Try Again';
		 	header("location: index.php");
		}
	
	}

} else {
	$_SESSION['error_message'] = 'Unauthorized Access Denied.';
	header("location: index.php");
}
?>