<?php
ob_start();
session_start();
require_once('admin/db/config.php');
if(!isset($_SESSION['customer'])) {
	header('location: index.php');
	exit;
}
if( !empty($_POST['email']) && !empty($_POST['newpassword']) && !empty($_POST['confirmnewpassword'])){
	$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) ;
	$newpassword = filter_var($_POST['newpassword'], FILTER_SANITIZE_STRING);
	$confirmnewpassword = filter_var($_POST['confirmnewpassword'], FILTER_SANITIZE_STRING) ;
	$uppercase = preg_match('@[A-Z]@', $newpassword);
	$lowercase = preg_match('@[a-z]@', $newpassword);
	$number    = preg_match('@[0-9]@', $newpassword);
	//validate password
	if(!$uppercase || !$lowercase || !$number || strlen($newpassword) < 8) {
		$_SESSION['password_message'] = 'Password must contain 8 characters, an uppercase character, a lowercase character & atleast 1 number. Try Again';
		 header("location: user_password.php");
	} else {
		//check password and confirm password are same
		if($newpassword == $confirmnewpassword) {
			$update_user_otp = $pdo->prepare("UPDATE customer_active SET user_authpass=? WHERE user_email=?");
			$update_user_otp->execute(array(password_hash($newpassword, PASSWORD_DEFAULT),$email));
			$_SESSION['password_message'] = 'Password change successfully.';
		 	header("location: user_password.php");
		
		} else {
			$_SESSION['password_message'] = 'New Password & Confirm New Password are not same. Try Again';
		 	header("location: user_password.php");
		}
	
	}

} else {
	$_SESSION['password_message'] = 'Unauthorized Access Denied.';
	header("location: user_password.php");
}
?>