<?php
ob_start();
session_start();
include("admin/db/config.php");
include('admin/db/api_otp_generate.php');
include("admin/db/CSRF_Protect.php");
include("admin/db/function_xss.php");
$csrf = new CSRF_Protect();
// Checking User is logged in or not
if(!isset($_SESSION['customer'])) {
	header('location: index.php');
	exit;
}
//session Id
$id = _e($_SESSION['customer']['user_id']);
// fetch customer all data
$customerStatement = $pdo->prepare("SELECT * FROM customer_active WHERE user_id=? and active_status=?");
$customerStatement->execute(array($id,_e(1)));
$total = $customerStatement->rowCount();
//if customer deactivated 
if($total == '0'){
	header('location: logout.php');
	exit;
}
$customer = $customerStatement->fetchAll(PDO::FETCH_ASSOC);
	foreach($customer as $cus)
	{
		$customer_name = _e($cus['user_fullname']);
		$customer_email = _e($cus['user_email']);
		$customer_country = _e($cus['user_country']);
		$customer_address = _e($cus['user_address']);
		$customer_state = _e($cus['user_state']);
		$customer_city = _e($cus['user_city']);
		$customer_zipcode = _e($cus['user_zipcode']);
	}
$admin = $pdo->prepare("SELECT * FROM ot_admin WHERE admin_status=?");
$admin->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT)));   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
foreach($admin_result as $adm) {
//escape admin email
	$admin_email   = _e($adm['email']);
}
$admin_announcement = $pdo->prepare("SELECT * FROM admin_announcement WHERE announcement_status=? order by announcement_id desc");
$admin_announcement->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT))); 
$announcement = $admin_announcement->fetchAll(PDO::FETCH_ASSOC);
$total_read = 1;
$total_announcement = $admin_announcement->rowCount();
if($total_announcement > 0) {
	$user_read = $pdo->prepare("select * from user_announcement_read where user_id = '".$id."' and read_announcement='1'");
	$user_read->execute();
	$total_read = $user_read->rowCount();
}
$admin = $pdo->prepare("SELECT * FROM show_announce WHERE show_announcement=?");
$admin->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT)));   
$admin_result = $admin->rowCount();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Dashboard</title>

	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/all.min.css">
	<link rel="stylesheet" href="css/admin_index.css">
</head>
<body>
<div class="page-wrapper chiller-theme toggled">
  <a id="show-sidebar" class="btn btn-sm btn-dark" href="#">
    <i class="fa fa-bars"></i>
  </a>
  <nav id="sidebar" class="sidebar-wrapper">
    <div class="sidebar-content">
      <div class="sidebar-brand">
        <a href="dashboard.php"><span> <img src="images/siteLogo.png" class="img-fluid" alt="Logo"></a></span>
        <div id="close-sidebar">
          <i class="fas fa-times"></i>
        </div>
      </div>
      <div class="sidebar-header">
        <div class="user-pic">
           <i class="fa fa-user-circle fa-3x text-white"></i>
        </div>
        <div class="user-info">
          <span class="user-name">
           <strong><?php echo $customer_name ; ?></strong>
          </span>
          <span class="user-role"><?php echo $customer_email ; ?></span>
        </div>
      </div>
      <!-- sidebar-header  -->
      <div class="sidebar-menu">
        <ul>
          <li class="header-menu">
            <span>General</span>
          </li>
		  <li>
		  	<a href="dashboard.php">
              <i class="fa fa-home"></i>
              <span>Home</span>
            </a>
		  </li>
		  <?php if($admin_result > 0){ ?>
		  <li>
		  	<a href="announcement.php">
              <i class="fa fa-bullhorn"></i>
              <span>Announcement <?php if($total_read == ''){ ?><span class="badge badge-warning">!</span><?php } ?></span>
			  
            </a>
		  </li>
		  <?php } ?>
		  <li>
		  	<a href="update.php">
              <i class="fa fa-info"></i>
              <span>Manage Details</span>
            </a>
		  </li>
          <li>
		  	<a href="manage_email.php">
              <i class="fa fa-envelope"></i>
              <span>Manage Email</span>
            </a>
		  </li>
		  <li>
		  	<a href="user_password.php">
              <i class="fa fa-key"></i>
              <span>Manage Password</span>
            </a>
		  </li>
        </ul>
      </div>
      <!-- sidebar-menu  -->
    </div>
    <!-- sidebar-content  -->
    <div class="sidebar-footer">
      <a href="logout.php">
        <i class="fa fa-power-off"></i>
      </a>
    </div>
  </nav>
  <!-- sidebar-wrapper  -->
 
