<?php
ob_start();
session_start();
require_once('admin/db/config.php');
require_once("admin/db/function_xss.php");
require_once("admin/db/CSRF_Protect.php");
$csrf = new CSRF_Protect();
unset($_SESSION['LastRequest']);
$admin = $pdo->prepare("SELECT * FROM ot_admin WHERE admin_status=?");
$admin->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT)));   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
foreach($admin_result as $adm) {
//escape admin email
	$admin_email   = _e($adm['email']);
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Two Factor Email Login & Registration</title>
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name="description" content="Two Factor Email Login & Registration">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/all.min.css">
	<link rel="stylesheet" href="css/custom.css" />
</head>

<body>
<div id="logreg-forms">
			<?php 
					if(! empty($_SESSION['error_message'])){ ?>
						<div  class="alert alert-danger errorMessage">
						<button type="button" class="close float-right" aria-label="Close" >
						  <span aria-hidden="true" id="hide">&times;</span>
						</button>
				<?php
						echo $_SESSION['error_message'] ;
						unset($_SESSION['error_message']);
				?>
						</div>
			<?php } ?>
        	<form action="verify_login.php" class="form-signin" method="post">
				<h4 class="d-flex justify-content-center"> Sign In</h4>
				<input type="hidden" name="admin_email" value="<?php echo $admin_email ; ?>" />
				<input type="email" name="email" id="inputEmail" class="form-control" placeholder="Email address" maxlength="50" required autofocus>
				<input type="password" name="password" id="inputPassword" class="form-control" placeholder="Password" required>
				<button class="btn btn-success btn-block" type="submit"><i class="fas fa-sign-in"></i> Sign in</button>
				<a href="#" id="forgot_pswd">Forgot password?</a>
				<hr>
				<button class="btn btn-primary btn-block" type="button" id="btn-signup"><i class="fas fa-user-plus"></i> Sign up New Account</button>
            </form>
			<form action="verify_email.php" class="form-reset" method="post">
				<h4 class="d-flex justify-content-center"> Forgot Password ?</h4>
                <input type="email" name="email" id="resetEmail" class="form-control" placeholder="Email address" maxlength="50" required autofocus>
                <button class="btn btn-primary btn-block" type="submit">Reset Password</button>
                <a href="#" id="cancel_reset"><i class="fas fa-angle-left"></i> Back</a>
            </form>
            <form action="verify_registration.php" class="form-signup" method="post">
				<?php $csrf->echoInputField(); ?>
                <h4 class="d-flex justify-content-center"> Sign Up</h4>
				<input type="hidden" name="admin_email" value="<?php echo $admin_email ; ?>" />
                <input type="text" id="user-name" name="fullname" class="form-control" placeholder="Full name" required autofocus>
                <input type="email" id="user-email" name="email" class="form-control" placeholder="Email address" required autofocus>
				<small>Password must contain minimum 8 characters, 1 Uppercase character, 1 Lowercase character & 1 number.</small>
                <input type="password" id="user-pass" name="password" class="form-control" placeholder="Password" required autofocus>
                <input type="text" id="user-repeatpass" name="repassword" class="form-control" placeholder="Repeat Password" required autofocus>
				
				<button class="btn btn-primary btn-block" type="submit"><i class="fas fa-user-plus"></i> Sign Up</button>
                <a href="#" id="cancel_signup"><i class="fas fa-angle-left"></i> Back</a>
            </form>
            <br>
            
    </div>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/jquery-3.5.0.min.js"></script>
<script type="text/javascript" src="js/custom.js"></script>
</body>
</html>
