<?php
ob_start();
session_start();
require_once('admin/db/config.php');
require_once("admin/db/function_xss.php");
require_once('admin/db/api_otp_generate.php');
require_once("admin/db/CSRF_Protect.php");
$csrf = new CSRF_Protect();
$admin = $pdo->prepare("SELECT * FROM ot_admin WHERE admin_status=?");
$admin->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT)));   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
foreach($admin_result as $adm) {
//escape admin email
	$admin_email   = _e($adm['email']);
}
//if page refreshed
$RequestSignature = md5($_SERVER['REQUEST_URI'].$_SERVER['QUERY_STRING'].print_r($_POST, true));
if ($_SESSION['LastRequest'] == $RequestSignature){
	$_SESSION['error_message'] = 'Sorry, You have Refreshed the Page. Try Again';
	header("location: index.php");
}
else {
	$_SESSION['LastRequest'] = $RequestSignature;
	if( !empty($_POST['email']) ) {
		$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) ;
		//first we check mobile is registered and active
		$checkUser =  $pdo->prepare("SELECT * FROM customer_active WHERE user_email = ? and active_status = ?");
		$checkUser->execute(array($email,filter_var("1", FILTER_SANITIZE_NUMBER_INT)));
		$user_ok = $checkUser->rowCount();
		$user_data = $checkUser->fetchAll(PDO::FETCH_ASSOC);
		if($user_ok > 0) {
			$otp = filter_var(code(4), FILTER_SANITIZE_NUMBER_INT);
			$to = $email ;
			$from = $admin_email ;
			$from = "Verification Email From : ".$from ;
			$headers .= 'MIME-Version: 1.0' . "\r\n" ;
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
			$headers .= $from . "\r\n" ; 
			$subject = "Forgot Password OTP" ;
			$body = "<br>Forgot Password OTP is <br><h3>".$otp."</h3><br>Please Do not share with anyone at any cost.";
			if (mail($to, $subject, $body, $headers)){
				$update_user_otp = $pdo->prepare("UPDATE customer_active SET user_otp=? WHERE user_email=?");
				$update_user_otp->execute(array($otp,$email));
			} else {
				$_SESSION['error_message'] = 'Sorry, Email not send. Try Again.';
				header("location: index.php");
			}
		} else {
			$_SESSION['error_message'] = 'Sorry, Either Email is not Registered or Deactivated.';
			header("location: index.php");
		}
	
	} else {
		$_SESSION['error_message'] = 'Email cannot be empty. Try Again';
		header("location: index.php");
	}

}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Verify Forgot Password OTP</title>
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name="description" content="Verify Forgot Password OTP">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/all.min.css">
</head>

<body>
	<div id="login-overlay" class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header" align="center">
				<img src="images/siteLogo.png" class="img-fluid"  alt="Logo">
		  	</div>
          	<div class="modal-body">
              	<div class="row">
                  	<div class="col-lg-12">
                      	<div class="well">
                          	<form method="POST" action="verify_password_otp.php">
								<?php $csrf->echoInputField(); ?>
						  	  	<div class="form-group">
                                  	<label for="email" class="control-label">Email*</label>
                                  	<input type="text" class="form-control" name="email"  value="<?php echo $email ; ?>" readonly="readonly">
							  	</div>
                              	<div class="form-group">
                                  	<label for="otp" class="control-label">OTP*</label>
                                  	<input type="password" class="form-control" name="otp" maxlength="10" required>
                              	</div>
							  	<button type="submit" class="btn btn-success btn-block"><i class="fa fa-hand-point-right"></i> Verify OTP</button>
                          	</form>
                      	</div>
                  	</div>
              	</div>
          	</div>
      	</div>
	</div>

<script type="text/javascript" src="js/bootstrap.min.js"></script>
</body>
</html>