<?php
ob_start();
session_start();
require_once('admin/db/config.php');
require_once("admin/db/function_xss.php");
require_once('admin/db/api_otp_generate.php');
require_once("admin/db/CSRF_Protect.php");
$csrf = new CSRF_Protect();
//if page refreshed
$RequestSignature = md5($_SERVER['REQUEST_URI'].$_SERVER['QUERY_STRING'].print_r($_POST, true));
if (isset($_SESSION['LastRequest']) == $RequestSignature){
	$_SESSION['error_message'] = 'Sorry, You have Refreshed the Page. Try Again';
	header("location: index.php");
}
else {
	$_SESSION['LastRequest'] = $RequestSignature;
	if( !empty($_POST['email']) && !empty($_POST['password']) && !empty($_POST['admin_email']) ){
		 $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) ;
		 $admin_email = filter_var($_POST['admin_email'], FILTER_SANITIZE_EMAIL) ;
		 $password = filter_var($_POST['password'], FILTER_SANITIZE_STRING);
		 $checkUser =  $pdo->prepare("SELECT * FROM customer_active WHERE user_email=? and active_status=?");
		 $checkUser->execute(array($email,filter_var("1", FILTER_SANITIZE_NUMBER_INT)));
		 $user_ok = $checkUser->rowCount();
		 $user_data = $checkUser->fetchAll(PDO::FETCH_ASSOC);
		 //check mobile & password is correct and user is active
		 if($user_ok > 0){
			$otp = filter_var(code(4), FILTER_SANITIZE_NUMBER_INT);
			$to = $email ;
			$from = $admin_email ;
			$from = "Verification OTP: ".$from ;
			$headers .= 'MIME-Version: 1.0' . "\r\n" ;
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
			$headers .= $from . "\r\n" ; 
			$subject = "Sign In OTP" ;
			$body = "<br>Sign In OTP is <br><h3>".$otp."</h3><br>Please Do not share with anyone at any cost.";
			foreach($user_data as $row){
				$auth_pass = _e($row['user_authpass']);
			}
			if(password_verify($password, $auth_pass)) {
				if (mail($to, $subject, $body, $headers)){
					$update_otp = $pdo->prepare("UPDATE customer_active SET user_otp=? WHERE user_email=?");
					$update_otp->execute(array($otp,$email));
				} else {
					$_SESSION['error_message'] = 'Sorry, Email not send. Try Again.';
					header("location: index.php");
				}
			} else {
				$_SESSION['error_message'] = 'Email / Password is wrong. Try Again';
				header("location: index.php");
			}
					
		} else {
			$_SESSION['error_message'] = 'Email / Password is wrong or Deactivated. Try Again';
			header("location: index.php");
		}
	
	} else {
		$_SESSION['error_message'] = 'Email / Password cannot be Empty';
		header("location: index.php");
	
	}
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Verify Login OTP</title>
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name="description" content="Verify Login OTP">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/all.min.css">
</head>

<body>
	<div id="login-overlay" class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
              <img src="images/siteLogo.png" class="img-fluid" alt="Logo">
          	</div>
          	<div class="modal-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="well">
							<form method="POST" action="verify_login_otp.php">
								<?php $csrf->echoInputField(); ?>
								<div class="form-group">
									<label for="mobile" class="control-label">Email*</label>
                                  	<input type="text" class="form-control" name="email"  value="<?php echo $email ; ?>" readonly="readonly">
                              	</div>
                              	<div class="form-group">
                                  	<label for="otp" class="control-label">OTP*</label>
                                  	<input type="password" class="form-control" name="otp" required>
                                  	<span class="help-block"></span>
                              	</div>
							  	<button type="submit" class="btn btn-success btn-block" name="verify_login"><i class="fa fa-hand-point-right"></i> Verify OTP</button>
                          	</form>
                      	</div>
                  	</div>
              	</div>
          	</div>
      </div>
  </div>

<script type="text/javascript" src="js/bootstrap.min.js"></script>
</body>
</html>