<?php
ob_start();
session_start();
require_once('admin/db/config.php');
require_once("admin/db/CSRF_Protect.php");
$csrf = new CSRF_Protect();
//if page refreshed
$RequestSignature = md5($_SERVER['REQUEST_URI'].$_SERVER['QUERY_STRING'].print_r($_POST, true));
if ($_SESSION['LastRequest'] == $RequestSignature){
	$_SESSION['error_message'] = 'Sorry, You have Refreshed the Page. Try Again';
	header("location: index.php");
}
else {
	$_SESSION['LastRequest'] = $RequestSignature;
	if( !empty($_POST['email']) && !empty($_POST['otp']) ){
		$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) ;
		$otp = filter_var($_POST['otp'], FILTER_SANITIZE_NUMBER_INT) ;
		$otpAuthentication =  $pdo->prepare("SELECT * FROM customer_active WHERE user_email=? and user_otp=? and active_status=?");
		$otpAuthentication->execute(array($email,$otp,filter_var("1", FILTER_SANITIZE_NUMBER_INT)));
		$otp_ok = $otpAuthentication->rowCount();
		$userData = $otpAuthentication->fetchAll(PDO::FETCH_ASSOC);
		if($otp_ok > 0) {
			?>
			<!DOCTYPE html>
			<html>
			<head>
				<meta charset="utf-8">
				<meta http-equiv="X-UA-Compatible" content="IE=edge">
				<title>Change Password</title>
				<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
				<meta name="description" content="Change Password">
				<link rel="stylesheet" href="css/bootstrap.min.css">
				<link rel="stylesheet" href="css/all.min.css">
			</head>
			
			<body>
			<div id="login-overlay" class="modal-dialog">
				  <div class="modal-content">
					  <div class="modal-header" align="center">
						  <img src="images/siteLogo.png" class="img-fluid"  alt="Logo">
					  </div>
					  <div class="modal-body">
						  <div class="row">
							  <div class="col-lg-12 col-md-12">
								  <div class="well">
									  <form method="POST" action="change_forgot_password.php">
									  	  <?php $csrf->echoInputField(); ?>
										  <div class="form-group">
											  <label for="mobile" class="control-label">Email*</label>
											  <input type="text" class="form-control" name="email"  value="<?php echo $email ; ?>" readonly="readonly">
										  </div>
										  <div class="form-group">
											  <label for="newpassword" class="control-label">New Password*</label>
											  <input type="password" class="form-control" name="newpassword" maxlength="50" required>
										  </div>
										  <div class="form-group">
											  <label for="confirmnewpassword" class="control-label">Confirm New Password*</label>
											  <input type="text" class="form-control" name="confirmnewpassword" maxlength="50" autocomplete="off" required>
										  </div>
										  <button type="submit" class="btn btn-success btn-block"><i class="fa fa-hand-point-right"></i> Change Password</button>
									  </form>
								  </div>
							  </div>
						  </div>
					  </div>
				  </div>
			  </div>
			
			<script type="text/javascript" src="js/bootstrap.min.js"></script>
			</body>
			</html>
			<?php
		}
		else {
			$_SESSION['error_message'] = 'Wrong OTP entered. Try Again.';
			header("location: index.php");
		}
	
	} else {
		$_SESSION['error_message'] = 'OTP cannot be Empty.';
		header("location: index.php");
	}
}
?>