<?php
ob_start();
session_start();
require_once('admin/db/config.php');
require_once("admin/db/function_xss.php");
require_once('admin/db/api_otp_generate.php');
require_once("admin/db/CSRF_Protect.php");
$csrf = new CSRF_Protect();
//if page refreshed
$RequestSignature = md5($_SERVER['REQUEST_URI'].$_SERVER['QUERY_STRING'].print_r($_POST, true));
if ($_SESSION['LastRequest'] == $RequestSignature){
	$_SESSION['error_message'] = 'Sorry, You have Refreshed the Page. Try Again';
	header("location: index.php");
}
else {
	$_SESSION['LastRequest'] = $RequestSignature;
	//check fullname, mobile, password & confirm password should not be empty
	if( !empty($_POST['fullname']) && !empty($_POST['email']) && !empty($_POST['password']) && !empty($_POST['repassword']) && !empty($_POST['admin_email']) ){
		$fullname = filter_var($_POST['fullname'], FILTER_SANITIZE_STRING) ;
		$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) ;
		$admin_email = filter_var($_POST['admin_email'], FILTER_SANITIZE_EMAIL) ;
		$password = filter_var($_POST['password'], FILTER_SANITIZE_STRING) ;
		$repassword = filter_var($_POST['repassword'], FILTER_SANITIZE_STRING) ;
		$uppercase = preg_match('@[A-Z]@', $password);
		$lowercase = preg_match('@[a-z]@', $password);
		$number    = preg_match('@[0-9]@', $password);
		//validate password
		if(!$uppercase || !$lowercase || !$number || strlen($password) < 8) {
		  $_SESSION['error_message'] = 'Password must contain 8 characters, an uppercase character, a lowercase character & atleast 1 number. Try Again';
		  header("location: index.php");
		} else {
			//check password and confirm password are same
			if($password == $repassword) {
				//checking database for already registered mobile
				$checkUser =  $pdo->prepare("SELECT * FROM customer_active WHERE user_email=?");
		 		$checkUser->execute(array($email));
		 		$user_ok = $checkUser->rowCount();
				if($user_ok > 0) {
					$_SESSION['error_message'] = 'Sorry, This Email is already registered. Try Again with Other Email.';
					header("location: index.php");
				} else {
					$otp = filter_var(code(4), FILTER_SANITIZE_NUMBER_INT) ;
					$to = $email ;
					$from = $admin_email ;
					$from = "Verification OTP: ".$from ;
					$headers .= 'MIME-Version: 1.0' . "\r\n" ;
					$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
					$headers .= $from . "\r\n" ; 
					$subject = "SignUp OTP" ;
					$body = "<br>Sign Up OTP is <br><h3>".$otp."</h3><br>Please Do not share with anyone at any cost.";
					if (mail($to, $subject, $body, $headers))
					{
						//first we insert/update user into temp table until they verify OTP
						$chkUserTmp = $pdo->prepare("SELECT * FROM customer_tmp WHERE user_email=?");
						$chkUserTmp->execute(array($email));
						$tmp_user = $chkUserTmp->rowCount();
						if($tmp_user > 0) {
							$update_tmp_user = $pdo->prepare("UPDATE customer_tmp SET user_fullname=? , user_authpass=? , user_otp=? WHERE user_email=?");
							$update_tmp_user->execute(array($fullname,password_hash($password, PASSWORD_DEFAULT),$otp,$email));
						} else {
							$ins_in_tmp = $pdo->prepare("INSERT INTO customer_tmp (user_fullname, user_email, user_authpass, user_otp) VALUES (?,?,?,?)");
							$ins_in_tmp->execute(array($fullname,$email,password_hash($password, PASSWORD_DEFAULT),$otp));
						}
					} else {
						$_SESSION['error_message'] = 'Sorry, Email not send. Try Again.';
						header("location: index.php");
					}
				}
			} else {
				$_SESSION['error_message'] = 'Sorry, Password & Confirm Password does not match. Try Again';
				header("location: index.php");
			}
		}
	
	} else {
		$_SESSION['error_message'] = 'All Mandatory fields are required. Try Again';
		header("location: index.php");
	}

}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Verify Registration OTP</title>
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name="description" content="Verify Registration OTP">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/all.min.css">
</head>

<body>
	<div id="login-overlay" class="modal-dialog">
      	<div class="modal-content">
          	<div class="modal-header">
              	<img src="images/siteLogo.png" class="img-fluid"  alt="Logo">
          	</div>
          	<div class="modal-body">
              	<div class="row">
                  	<div class="col-lg-12">
                      	<div class="well">
                          	<form method="POST" action="verify_registration_otp.php">
								<?php $csrf->echoInputField(); ?>
                              	<div class="form-group">
                                  	<label for="mobile" class="control-label">Email*</label>
                                  	<input type="text" class="form-control" name="email"  value="<?php echo $email ; ?>" readonly="readonly">
								  	<input type="hidden" name="password" value="<?php echo $password ; ?>" />
								  	<input type="hidden" name="fullname" value="<?php echo $fullname ; ?>" />
                              	</div>
                              	<div class="form-group">
                                  	<label for="otp" class="control-label">OTP*</label>
                                  	<input type="password" class="form-control" name="otp" required>
                              	</div>
							  	<button type="submit" class="btn btn-success btn-block" name="verify_login"><i class="fa fa-hand-point-right"></i> Verify OTP</button>
                          	</form>
                      	</div>
                  	</div>
              	</div>
          	</div>
     	</div>
  	</div>

<script type="text/javascript" src="js/bootstrap.min.js"></script>
</body>
</html>