<?php
ob_start();
session_start();
include("admin/db/config.php");
include("admin/db/CSRF_Protect.php");
include("admin/db/function_xss.php");
include("userfunction.php");
$csrf = new CSRF_Protect();
// Checking User is logged in or not
if( ($_SESSION['type']['customer_id'] == '')){
	header('location: '.BASE_URL.'index.php');
	exit;
}
$id = _e($_SESSION['type']['customer_id']) ; 
$user = $pdo->prepare("SELECT * FROM billing_user WHERE customer_status=? and customer_id = ?");
$user->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT),$id));   
$user_result = $user->fetchAll(PDO::FETCH_ASSOC);
$total = $user->rowCount();
//if user is deactivated 
if($total == '0'){
	header('location: logout.php');
	exit;
}
foreach($user_result as $adm) {
//escape all  data
	$customer_username = _e($adm['customer_username']) ;
	$customer_email = _e($adm['customer_email']) ;
	$customer_phone = _e($adm['customer_phone']) ;
	$customer_password = _e($adm['customer_password']) ;
	$customer_name = _e($adm['customer_name']) ;
	$customer_tax_no = _e($adm['customer_tax_no']) ;
	$customer_name = _e($adm['customer_name'])  ;
}
?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Dashboard</title>

	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/css/main.css">
	<link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/css/bootstrap-select.min.css">
	<link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/css/all.min.css">
	<link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/css/datepicker.css">
	<link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/css/Latofont.css">
	<link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/css/Niconnefont.css">
</head>
<body class="app sidebar-mini">
<!-- Navbar-->
    <header class="app-header"><a class="app-header__logo" href="<?php echo BASE_URL; ?>dashboard.php"><img src="<?php echo ADMIN_URL; ?>/images/siteLogo.png" class="img-fluid" alt="Logo"></a>
      <!-- Sidebar toggle button--><a class="app-sidebar__toggle" href="#" data-toggle="sidebar" aria-label="Hide Sidebar"><i class="fa fa-bars fa-2x"></i></a>
      <!-- Navbar Right Menu-->
      <ul class="app-nav">
        <!-- User Menu-->
        <li class="dropdown"><a class="app-nav__item" href="#" data-toggle="dropdown" aria-label="Open Profile Menu"><i class="fa fa-user fa-lg"></i></a>
          <ul class="dropdown-menu settings-menu dropdown-menu-right">
            <li>
			<a class="dropdown-item" href="userdetail.php"><i class="fa fa-fax"></i> Details</a>
			</li>
            <li><a class="dropdown-item"  href="<?php echo BASE_URL; ?>user_change_password.php"><i class="fa fa-key"></i> Password</a></li>
            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>logout.php"><i class="fa fa-sign-out-alt fa-lg"></i> Logout</a></li>
          </ul>
        </li>
      </ul>
    </header>
	 <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
      <div class="app-sidebar__user"><i class="fa fa-user fa-2x text-warning"></i>
        <div>
          <p class="app-sidebar__user-name"><?php echo $customer_name ; ?></p>
          <p class="app-sidebar__user-designation"><?php echo $customer_username ; ?></p>
        </div>
      </div>
	   <ul class="app-menu">
        <li><a class="app-menu__item" href="<?php echo BASE_URL; ?>dashboard.php"><i class="app-menu__icon fa fa-laptop"></i><span class="app-menu__label">Dashboard</span></a></li>
		</ul>
	 </aside>
	   <main class="app-content">
  <!-- sidebar-wrapper  -->
<?php
$temp_password = '123456' ; 
if(password_verify($temp_password,$customer_password)) {
?>
<!-- Add Change Temporary Password Modal -->
	<div id="changepassModal" class="modal fade"  data-backdrop="static" data-keyboard="false">
    	<div class="modal-dialog">
    		<form method="post" id="changepass_form">
    			<div class="modal-content">
    				<div class="modal-header">
						<h4 class="modal-title"><i class="fa fa-plus"></i> Change Temporary Password</h4>
    				</div>
    				<div class="modal-body">
						<div class="remove-messages"></div>
						<div class="form-group">
						<small>Password must contain minimum 8 characters, 1 Uppercase character, 1 Lowercase character & 1 number.</small><br>
							<label>New Password*</label>
							<input type="password" name="changetemppassword" id="changetemppassword" class="form-control" required />
						</div>
						<div class="form-group">
							<label>Confirm New Password*</label>
							<input type="text" name="changetemprepassword" id="changetemprepassword" class="form-control" required />
						</div>
    				</div>
    				<div class="modal-footer">
						<input type="hidden" name="useruid" id="useruid"  value="<?php echo $id ; ?>">
						<input type="hidden" name="btn_action_change_temp_pass" id="btn_action_change_temp_pass"  value="Submit"/>
    					<input type="submit" name="action_change_temp_pass" id="action_change_temp_pass" class="btn btn-info" value="Change Password" />
    				</div>
    			</div>
    		</form>
    	</div>
 </div>
<?php
} 
?>

