<?php
function fetch_currency($pdo){
	$currency = $pdo->prepare("select * from world_currencies where currency_status = '1'");
	$currency->execute();
	$result_currency = $currency->fetchAll(PDO::FETCH_ASSOC);
	foreach($result_currency as $cur) {
		$c = _e($cur['symbol_hex']);
		$chunks = str_split($c, 5);
		$res= implode('&#x', $chunks);
		echo "&#X".$res ;
	}
}
function count_total_order_value_curday($pdo)
{	
	$curday = date('Y-m-d');
	$query = "SELECT sum(order_total) as total_order_value FROM billing_order WHERE order_status='1' and order_date = '".$curday."' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	foreach($result as $row)
	{
		if($row['total_order_value'] == '' || $row['total_order_value'] == '0'){
			$row['total_order_value'] = 0 ;
		}
		return number_format(_e($row['total_order_value']), 2);
	}
}
function count_total_orderwithouttax_value_curday($pdo)
{	
	$curday = date('Y-m-d');
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_date = '".$curday."'  and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	$total_ordervaluewithout_tax = 0;
	if($total > 0) {
		foreach($result as $row)
		{
			$productId = _e($row['order_id']);
			$sub_row = $pdo->prepare("select product_price_beforetax from billing_order_detail where billing_order_id = '".$productId."'");
			$sub_row->execute();
			$result_sub_row = $sub_row->fetchAll();
			foreach($result_sub_row as $order_price) {
				$b = str_replace(',', '', _e($order_price['product_price_beforetax']));
				$total_ordervaluewithout_tax = (float)$total_ordervaluewithout_tax + (float)$b;
				if($total_ordervaluewithout_tax == '' || $total_ordervaluewithout_tax == '0'){
					$total_ordervaluewithout_tax = 0.00;
				}
			}
		}
		return number_format($total_ordervaluewithout_tax,2) ;
	} else {
		return number_format(0, 2);
	}
}
function count_total_ordertax_value_curday($pdo)
{	
	$curday = date('Y-m-d');
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_date = '".$curday."'  and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	$total_tax_amt = 0;
	if($total > 0) {
		foreach($result as $row)
		{
			$productId = _e($row['order_id']);
			$sub_row = $pdo->prepare("select product_price_taxamount from billing_order_detail where billing_order_id = '".$productId."'");
			$sub_row->execute();
			$result_sub_row = $sub_row->fetchAll();
			foreach($result_sub_row as $order_tax) {
				$a = str_replace(',', '', _e($order_tax['product_price_taxamount']));
				$total_tax_amt =  (float)$total_tax_amt + (float)$a;
			}
		}
		return number_format($total_tax_amt,2) ;
	} else {
		return number_format(0, 2);
	}
}
function count_total_order_curday($pdo)
{	
	$curday = date('Y-m-d');
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_date = '".$curday."'  and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_order_value_curmonth($pdo)
{	
	$firstday = date('Y-m-01');
	$lastday = date('Y-m-t') ;
	$query = "SELECT sum(order_total) as total_order_value_month FROM billing_order WHERE order_status='1' and order_date between '$firstday' and '$lastday' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	$result = $statement->fetchAll();
	if($total > 0) {
		foreach($result as $row)
		{
			if($row['total_order_value_month'] == '' || $row['total_order_value_month'] == '0'){
			$row['total_order_value_month'] = 0 ;
			}
			return number_format(_e($row['total_order_value_month']), 2);
		}
	} else {
		return number_format(0,2);
	}
}
function count_total_order_curmonth($pdo)
{	
	$firstday = date('Y-m-01');
	$lastday = date('Y-m-t') ;
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_date between '$firstday' and '$lastday' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_orderwithouttax_value_curmonth($pdo)
{	
	$firstday = date('Y-m-01');
	$lastday = date('Y-m-t') ;
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_date between '$firstday' and '$lastday' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	if($total > 0) {
	$total_ordervaluewithout_tax = 0;
		foreach($result as $row)
		{
			
			$productId = _e($row['order_id']);
			$sub_row = $pdo->prepare("select product_price_beforetax from billing_order_detail where billing_order_id = '".$productId."'");
			$sub_row->execute();
			$result_sub_row = $sub_row->fetchAll();
			foreach($result_sub_row as $order_price) {
				$b = str_replace(',', '', _e($order_price['product_price_beforetax']));
				$total_ordervaluewithout_tax = (float)$total_ordervaluewithout_tax + (float)$b;
				if($total_ordervaluewithout_tax == '' || $total_ordervaluewithout_tax == '0'){
					$total_ordervaluewithout_tax = 0.00;
				}
			}
		}
		return number_format($total_ordervaluewithout_tax,2) ;
	} else {
		return number_format(0, 2);
	}
}
function count_total_ordertax_value_curmonth($pdo)
{	
	$firstday = date('Y-m-01');
	$lastday = date('Y-m-t') ;
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_date between '$firstday' and '$lastday' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	$total_tax_amt = 0;
	if($total > 0) {
		foreach($result as $row)
		{
			$productId = _e($row['order_id']);
			$sub_row = $pdo->prepare("select product_price_taxamount from billing_order_detail where billing_order_id = '".$productId."'");
			$sub_row->execute();
			$result_sub_row = $sub_row->fetchAll();
			foreach($result_sub_row as $order_tax) {
				$a = str_replace(',', '', _e($order_tax['product_price_taxamount']));
				$total_tax_amt =  (float)$total_tax_amt + (float)$a;
			}
		}
		return number_format($total_tax_amt,2) ;
	} else {
		return number_format(0, 2);
	}
}
function count_total_order_value($pdo)
{	
	$query = "SELECT sum(order_total) as total_order_value_month FROM billing_order WHERE order_status='1' and order_customer_id = '".$_SESSION['type']['customer_id']."' ";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	if($total > 0) {
		foreach($result as $row)
		{
			if($row['total_order_value_month'] == '' || $row['total_order_value_month'] == '0'){
			$row['total_order_value_month'] = 0 ;
			}
			return number_format(_e($row['total_order_value_month']), 2);
		}
	} else {
		return number_format(0,2);
	}
}
function count_total_order($pdo)
{	
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_orderwithouttax_value($pdo)
{	
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	if($total > 0) {
	$total_ordervaluewithout_tax = 0;
		foreach($result as $row)
		{
			
			$productId = _e($row['order_id']);
			$sub_row = $pdo->prepare("select product_price_beforetax from billing_order_detail where billing_order_id = '".$productId."'");
			$sub_row->execute();
			$result_sub_row = $sub_row->fetchAll();
			foreach($result_sub_row as $order_price) {
				$b = str_replace(',', '', _e($order_price['product_price_beforetax']));
				$total_ordervaluewithout_tax = (float)$total_ordervaluewithout_tax + (float)$b;
				if($total_ordervaluewithout_tax == '' || $total_ordervaluewithout_tax == '0'){
					$total_ordervaluewithout_tax = 0.00;
				}
			}
		}
		return number_format($total_ordervaluewithout_tax,2) ;
	} else {
		return number_format(0, 2);
	}
}
function count_total_ordertax_value($pdo)
{	
	$query = "SELECT * FROM billing_order WHERE order_status='1' and order_customer_id = '".$_SESSION['type']['customer_id']."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	$total = $statement->rowCount();
	$total_tax_amt = 0;
	if($total > 0) {
		foreach($result as $row)
		{
			$productId = _e($row['order_id']);
			$sub_row = $pdo->prepare("select product_price_taxamount from billing_order_detail where billing_order_id = '".$productId."'");
			$sub_row->execute();
			$result_sub_row = $sub_row->fetchAll();
			foreach($result_sub_row as $order_tax) {
				$a = str_replace(',', '', _e($order_tax['product_price_taxamount']));
				$total_tax_amt =  (float)$total_tax_amt + (float)$a;
			}
		}
		return number_format($total_tax_amt,2) ;
	} else {
		return number_format(0, 2);
	}
}
?>