<?php
ob_start();
session_start();
include("db/config.php");
include("db/function_xss.php");
// Checking Admin is logged in or not
if( empty($_SESSION['admin']['id'])  ){
	header('location: '.ADMIN_URL.'/index.php');
	exit;
}
$admin = $pdo->prepare("SELECT * FROM subscription_admin WHERE  id = '1'");
$admin->execute();   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
foreach($admin_result as $adm) {
//escape all  data
	$c_name = _e($adm['c_name']) ;
	$c_email = _e($adm['c_email']) ;
	$c_phone = _e($adm['c_phone']) ;
	$c_tax = _e($adm['c_tax']) ;
}
$headers = "";
if(isset($_POST['btn_action_payment']))
{
	if($_POST['btn_action_payment'] == 'AddBill')
	{
		if( isset($_POST['cname']) && isset($_POST['cemail']) && isset($_POST['purpose']) && isset($_POST['sdate']) && !empty($_POST['price'])){
			$cname = filter_var($_POST['cname'], FILTER_SANITIZE_STRING);
			$cemail = filter_var($_POST['cemail'], FILTER_SANITIZE_EMAIL);
			$sdate = filter_var(date($_POST['sdate']), FILTER_SANITIZE_STRING) ;
			$price = filter_var($_POST['price'], FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
			$purpose = filter_var($_POST['purpose'], FILTER_SANITIZE_STRING);
			$cphone = filter_var($_POST['cphone'], FILTER_SANITIZE_NUMBER_INT);
			$ctax = filter_var($_POST['ctax'], FILTER_SANITIZE_STRING);
			$hex = base64_encode($cemail) ;
			$ins = $pdo->prepare("insert into payments (customer_name, customer_email, customer_phone, customer_tax_number, payment_purpose, txn_id, txn_type, address_country, total_amt, payer_email, payment_status, pay_date, bill_date) values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$ins->execute(array($cname, $cemail, $cphone, $ctax, $purpose, '', '', '', $price, '', '', NULL, $sdate));
			
			$orderstatement = $pdo->query("SELECT LAST_INSERT_ID()");
			$order_id = $orderstatement->fetchColumn();
			$to = $cemail ;
			$subject = "Due Payment." ;
			$headers .= 'MIME-Version: 1.0' . "\r\n" ;
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
			$headers .= "X-Priority: 1 (Highest)\n";
			$headers .= "X-MSMail-Priority: High\n";
			$headers .= "Importance: High\n";
			include("send_bill_email.php");
			$mail_result = mail($to, $subject, $body, $headers);
			if($mail_result) {
				echo "Bill Added & Email sent Successfully to Customer.";
			} else {
				echo "Error in sending email.Try again.";
			}
		} else {
			echo "Customer Name, Email, Date, Purpose of Payment & Price fields are mandatory. Try Again.";
		}
	}
	if($_POST['btn_action_payment'] == 'EditBill')
	{
		if( isset($_POST['sid']) && isset($_POST['cname']) && isset($_POST['cemail']) && isset($_POST['purpose']) && isset($_POST['sdate']) && !empty($_POST['price']) ){
			$sid = filter_var($_POST['sid'], FILTER_SANITIZE_NUMBER_INT);
			$cname = filter_var($_POST['cname'], FILTER_SANITIZE_STRING);
			$cemail = filter_var($_POST['cemail'], FILTER_SANITIZE_EMAIL);
			$sdate = filter_var(date($_POST['sdate']), FILTER_SANITIZE_STRING) ;
			$price = filter_var($_POST['price'], FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
			$purpose = filter_var($_POST['purpose'], FILTER_SANITIZE_STRING);
			$cphone = filter_var($_POST['cphone'], FILTER_SANITIZE_NUMBER_INT);
			$ctax = filter_var($_POST['ctax'], FILTER_SANITIZE_STRING);
			$ins = $pdo->prepare("update payments set customer_name =? , customer_email=? , customer_phone=? , customer_tax_number = ? , bill_date = ? , total_amt = ? , payment_purpose = ? where id= ?");
			$ins->execute(array($cname, $cemail, $cphone, $ctax, $sdate, $price, $purpose, $sid));
			echo "Bill Edited Successfully.";
		} else {
			echo "All Fields are Mandatory. Try Again.";
		}
	}
	
	if($_POST['btn_action_payment'] == 'fetch_bill')
	{	
		$billId = filter_var($_POST['billId'], FILTER_SANITIZE_NUMBER_INT) ;
		$fetch_bill = $pdo->prepare("select * from payments where id = ?");
		$fetch_bill->execute(array($billId));
		$billData = $fetch_bill->fetchAll(PDO::FETCH_ASSOC);
		foreach($billData as $row) {
			$output['sid'] = _e($row['id']) ;
			$output['cname'] = _e($row['customer_name']) ;
			$output['cemail'] = _e($row['customer_email']) ;
			$output['cphone'] = _e($row['customer_phone']) ;
			$output['ctax'] = _e($row['customer_tax_number']) ;
			$output['sdate'] = _e($row['bill_date']) ;
			$output['purpose'] = _e($row['payment_purpose']) ;
			$output['price'] = _e($row['total_amt']) ;
		}
		echo json_encode($output);
	}
	if($_POST['btn_action_payment'] == 'changeBillStatus')
	{
		$billId = filter_var($_POST['billId'], FILTER_SANITIZE_NUMBER_INT);
		$status = filter_var($_POST['status'], FILTER_SANITIZE_NUMBER_INT);
		$statement = $pdo->prepare("select * from payments where id = '".$billId."' and payment_status = 'Completed'");
		$statement->execute();
		$ok = $statement->rowCount();
		if($ok > 0){
			echo "Sorry, This Bill is already paid. So you cannot change status of this Bill.";
		} else {
			
			if($billId) { 
				$update = $pdo->prepare("UPDATE payments SET bill_status=?   WHERE id=?");
				$result_new = $update->execute(array($status,$billId));
				if($result_new) {
					echo 'Success : Bill status changed .' ;		
				}
			}
		}
	}
	if($_POST['btn_action_payment'] == 'resendEmail')
	{
		if( isset($_POST['billId'])){
			$billId = filter_var($_POST['billId'], FILTER_SANITIZE_NUMBER_INT);
			$rstatement = $pdo->prepare("select * from payments where id = '".$billId."' and payment_status = 'Completed'");
			$rstatement->execute();
			$ok = $rstatement->rowCount();
			if($ok > 0){
				echo "Sorry, This Bill is already paid. So you cannot resend Email of this Bill. You can send Payment Status Email in Completed Payment Option.";
			} else {
				$statement = $pdo->prepare("select * from payments where id = '".$billId."'");
				$statement->execute();
				$reEmail = $statement->fetchAll(PDO::FETCH_ASSOC);
				foreach($reEmail as $re) {
				//escape all  data
					$cemail = _e($re['customer_email']) ;
					$cname = _e($re['customer_name']) ;
					$cphone = _e($re['customer_phone']) ;
					$ctax = _e($re['customer_tax_number']) ;
					$purpose = _e($re['payment_purpose']) ;
					$price = _e($re['total_amt']) ;
					$order_id = _e($re['id']) ;
					
				}
				$hex  = base64_encode($cemail) ;
				$to = $cemail ;
				$subject = "Due Payment." ;
				$headers .= 'MIME-Version: 1.0' . "\r\n" ;
				$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
				$headers .= "X-Priority: 1 (Highest)\n";
				$headers .= "X-MSMail-Priority: High\n";
				$headers .= "Importance: High\n";
				include("send_bill_email.php");
				$mail_result = mail($to, $subject, $body, $headers);
				if($mail_result) {
					echo "Resend Email for Due Payment sent Successfully to Customer.";
				} else {
					echo "Error in sending email.Try again.";
				}
				
			}
		}
	}
	if($_POST['btn_action_payment'] == 'resendTransactionEmail')
	{
		if( isset($_POST['billId'])){
			$billId = filter_var($_POST['billId'], FILTER_SANITIZE_NUMBER_INT);
			
				$statement = $pdo->prepare("select * from payments where id = '".$billId."'");
				$statement->execute();
				$reEmail = $statement->fetchAll(PDO::FETCH_ASSOC);
				foreach($reEmail as $re) {
				//escape all  data
					$cemail = _e($re['customer_email']) ;
					$cname = _e($re['customer_name']) ;
					$cphone = _e($re['customer_phone']) ;
					$ctax = _e($re['customer_tax_number']) ;
					$purpose = _e($re['payment_purpose']) ;
					$price = _e($re['total_amt']) ;
					$order_id = _e($re['id']) ;
					$payment_status = _e($re['payment_status']) ;
					$txn_id = _e($re['txn_id']) ;
					
				}
				$hex  = base64_encode($cemail) ;
				$to = $cemail ;
				$subject = "Paypal Transaction is ".$payment_status ;
				$headers .= 'MIME-Version: 1.0' . "\r\n" ;
				$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
				$headers .= "X-Priority: 1 (Highest)\n";
				$headers .= "X-MSMail-Priority: High\n";
				$headers .= "Importance: High\n";
				include("send_transaction_email.php");
				$mail_result = mail($to, $subject, $body, $headers);
				if($mail_result) {
					echo "Resend Email for Transaction Details sent Successfully to Customer.";
				} else {
					echo "Error in sending Transaction email.Try again.";
				}
				
		}
	}
}
?>