<?php
function _e($string) {
	return htmlentities(strip_tags($string), ENT_QUOTES, 'UTF-8');
}

function count_total_bill($pdo)
{	
	$query = "SELECT * FROM payments WHERE 1";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_active_bill($pdo)
{	
	$query = "SELECT * FROM payments WHERE bill_status='1'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total__deactive_bill($pdo)
{	
	$query = "SELECT * FROM payments WHERE bill_status='0'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_completed_bill($pdo)
{	
	$query = "SELECT * FROM payments WHERE payment_status='Completed'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_due_bill($pdo)
{	
	$query = "SELECT * FROM payments WHERE payment_status!='Completed'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$total = $statement->rowCount();
	return _e($total) ;
	
}
function count_total_purchase_value_curday($pdo)
{	
	$curday = date('Y-m-d');
	$query = "SELECT sum(total_amt) as total_order_value FROM payments WHERE payment_status='Completed' and pay_date = '".$curday."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	foreach($result as $row)
	{
		if($row['total_order_value'] == '' || $row['total_order_value'] == '0'){
			$row['total_order_value'] = 0.00 ;
		}
		return _e($row['total_order_value']);
	}
}
function count_total_purchase_value_curmonth($pdo)
{	
	$firstday = date('Y-m-01');
	$lastday = date('Y-m-t') ;
	$query = "SELECT sum(total_amt) as total_order_value FROM payments WHERE payment_status='Completed' and pay_date between '".$firstday."' and '".$lastday."'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	foreach($result as $row)
	{
		if($row['total_order_value'] == '' || $row['total_order_value'] == '0'){
			$row['total_order_value'] = 0.00 ;
		}
		return _e($row['total_order_value']);
	}
}
function count_total_purchase_value($pdo)
{	
	$query = "SELECT sum(total_amt) as total_order_value FROM payments WHERE payment_status='Completed'";
	$statement = $pdo->prepare($query);
	$statement->execute();
	$result = $statement->fetchAll();
	foreach($result as $row)
	{
		if($row['total_order_value'] == '' || $row['total_order_value'] == '0'){
			$row['total_order_value'] = 0.00 ;
		}
		return _e($row['total_order_value']);
	}
}
?>