<?php
// For Live payments we want to disable the sandbox mode i.e. false. If you want to put Sanbox Mode
// payments through then this setting needs changing to `true`.
$enableSandbox = false;

require_once("admin/db/config.php");
require_once("admin/db/function_xss.php");

$admin = $pdo->prepare("SELECT * FROM subscription_admin WHERE  id = '1'");
$admin->execute();   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
foreach($admin_result as $adm) {
//escape all  data
	$c_name = _e($adm['c_name']) ;
	$c_tagline = _e($adm['c_tagline']) ;
	$c_email = _e($adm['c_email']) ;
	$c_phone = _e($adm['c_phone']) ;
	$c_tax = _e($adm['c_tax']) ;
}
$headers = "";

$paypalURL = $enableSandbox ? 'https://www.sandbox.paypal.com/cgi-bin/webscr' : 'https://www.paypal.com/cgi-bin/webscr';

$raw_post_data = file_get_contents('php://input');
$raw_post_array = explode('&', $raw_post_data);
$myPost = array();
foreach ($raw_post_array as $keyval) {
    $keyval = explode ('=', $keyval);
    if (count($keyval) == 2)
        $myPost[$keyval[0]] = urldecode($keyval[1]);
}

// Read the post from PayPal system and add 'cmd'
$req = 'cmd=_notify-validate';
if(function_exists('get_magic_quotes_gpc')) {
    $get_magic_quotes_exists = true;
}
foreach ($myPost as $key => $value) {
    if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
        $value = urlencode(stripslashes($value));
    } else {
        $value = urlencode($value);
    }
    $req .= "&$key=$value";
}

// Post IPN data back to PayPal to validate the IPN data is genuine Without this step anyone can fake IPN data

$ch = curl_init($paypalURL);
if ($ch == FALSE) {
    return FALSE;
}
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
curl_setopt($ch, CURLOPT_SSLVERSION, 6);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close', 'User-Agent: company-name'));
$res = curl_exec($ch);
$tokens = explode("\r\n\r\n", trim($res));
$res = trim(end($tokens));
if (strcmp($res, "VERIFIED") == 0 || strcasecmp($res, "VERIFIED") == 0) {
	
	$txn_id = filter_var($_POST['txn_id'], FILTER_SANITIZE_STRING) ;
	$payer_email = filter_var($_POST['payer_email'], FILTER_SANITIZE_EMAIL) ;
	$item_id = filter_var($_POST['item_number'], FILTER_SANITIZE_NUMBER_INT) ;
	$txn_type = filter_var($_POST['txn_type'], FILTER_SANITIZE_STRING) ;
	$country = filter_var($_POST['address_country'], FILTER_SANITIZE_STRING) ;
	$total_amt = filter_var($_POST['mc_gross'], FILTER_SANITIZE_STRING) ;
	$payment_status = filter_var($_POST['payment_status'], FILTER_SANITIZE_STRING) ;
	$payDate = filter_var(date("Y-m-d"), FILTER_SANITIZE_STRING) ;
	$check_transaction = $pdo->prepare("select * from payments where txn_id = '".$txn_id."'");
	$check_transaction->execute();
	$numRow = $check_transaction->rowCount();
	
	if($numRow == 0){
		$statement = $pdo->prepare("update payments set txn_id = ? , txn_type = ?, address_country = ?, total_amt = ?, payer_email = ?, payment_status = ?, pay_date = ? where id = ? ");
		$sql = $statement->execute(array($txn_id,$txn_type,$country,$total_amt,$payer_email,$payment_status,$payDate,$item_id));
		if($sql){
			$cust = $pdo->prepare("select * from payments where id='".$item_id."'");
			$cust->execute();
			$custData = $cust->fetchAll(PDO::FETCH_ASSOC);
			foreach($custData as $user){
			$cemail = _e($user['customer_email']) ;
			$cname = _e($user['customer_name']) ;
			$cphone = _e($user['customer_phone']) ;
			$ctax = _e($user['customer_tax_number']) ;
			$purpose = _e($user['payment_purpose']) ;
			$price = _e($user['total_amt']) ;
			$order_id = _e($user['id']) ;
			}
			$to = $cemail ;
			$subject = "Paypal Transaction is ".$payment_status ;
			$headers .= 'MIME-Version: 1.0' . "\r\n" ;
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
			$headers .= "X-Priority: 1 (Highest)\n";
			$headers .= "X-MSMail-Priority: High\n";
			$headers .= "Importance: High\n";
			include("send_email.php");
			$toAdmin = $c_email ;
			$adminSubject = "Congratulations! New Paypal Transaction from User.";
			mail($to, $subject, $body, $headers);
			mail($toAdmin, $adminSubject, $body, $headers);
		}
	}

}
?>