// JavaScript Document
jQuery(function ($) {
	
	"use strict";
	
	var base_url = location.protocol + '//' + location.host + location.pathname ;
	base_url = base_url.substring(0, base_url.lastIndexOf("/") + 1);
	
	var manageBillsTable = $('#manageBillsTable').DataTable({
		'ajax': base_url+'fetchBills.php',
		'order': []
	});
	var manageactiveBillsTable = $('#manageactiveBillsTable').DataTable({
		'ajax': base_url+'fetchactiveBill.php',
		'order': []
	});
	var managedeactiveBillsTable = $('#managedeactiveBillsTable').DataTable({
		'ajax': base_url+'fetchdeactiveBill.php',
		'order': []
	});
	var managePaymentTable = $('#managePaymentTable').DataTable({
		'ajax': base_url+'fetchPayments.php',
		'order': []
	});
	var managedueBillsTable = $('#managedueBillsTable').DataTable({
		'ajax': base_url+'fetchduePayments.php',
		'order': []
	});
  	$(document).on("click","#hide", function() {
		$(".errorMessage").hide();
	});
	$(document).ready(function(){
		$('.order_date').datepicker({
			format: "yyyy-mm-dd",
			autoclose: true,
			orientation: "top",
			endDate: "today"
		});
	});
	$(document).on('click', '#add_bill', function(){
		$('#paymentModal').modal('show');
		$('#payment_form')[0].reset();
		$('.modal-title').html("<i class='fa fa-plus'></i> Add Bill & Send Email");
		$('#action_payment').val('Save & Send Email');
		$('#btn_action_payment').val('AddBill');
	});
	$(document).on('submit','#payment_form', function(event){
		event.preventDefault();
		$('#action_payment').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url: base_url+"action_payment.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				$('#payment_form')[0].reset();
				$('#paymentModal').modal('hide');
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#action_payment').attr('disabled', false);
				manageBillsTable.ajax.reload();
				manageactiveBillsTable.ajax.reload();
				managedeactiveBillsTable.ajax.reload();
				managedueBillsTable.ajax.reload();
			}
		})
	});
	$(document).on('click', '.editBill', function(){
		var billId = $(this).attr("id");
		var btn_action_payment = 'fetch_bill';
		$.ajax({
			url: base_url+"action_payment.php",
			method:"POST",
			data:{billId:billId, btn_action_payment:btn_action_payment},
			dataType:"json",
			success:function(data)
			{
				$('#paymentModal').modal('show');
				$('#sid').val(data.sid);
				$('#cname').val(data.cname);
				$('#cemail').val(data.cemail);
				$('#ctax').val(data.ctax);
				$('#cphone').val(data.cphone);
				$('#purpose').val(data.purpose);
				$('#price').val(data.price);
				$('#sdate').val(data.sdate);
				$('.modal-title').html("<i class='fa fa-pencil-alt'></i> Edit Bill");
				$('#action_payment').val('Edit Bill');
				$('#btn_action_payment').val('EditBill');
			}
		})
	});
	$(document).on('click', '.changeBillStatus', function(){
			var billId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action_payment = "changeBillStatus";
			if(confirm("Are you sure you want to change Bill Status?"))
			{
				$.ajax({
					url: base_url+"action_payment.php",
					method:"POST",
					data:{billId:billId, status:status, btn_action_payment:btn_action_payment},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageBillsTable.ajax.reload();
						manageactiveBillsTable.ajax.reload();
						managedeactiveBillsTable.ajax.reload();
						managedueBillsTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	$(document).on('click', '.resendEmail', function(){
			var billId = $(this).attr("id");
			var btn_action_payment = "resendEmail";
			if(confirm("Click Ok to Resend Email"))
			{
				$.ajax({
					url: base_url+"action_payment.php",
					method:"POST",
					data:{billId:billId, btn_action_payment:btn_action_payment},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
						manageBillsTable.ajax.reload();
						manageactiveBillsTable.ajax.reload();
						managedueBillsTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	$(document).on('click', '.resendTransactionEmail', function(){
			var billId = $(this).attr("id");
			var btn_action_payment = "resendTransactionEmail";
			if(confirm("Click Ok to Resend Email"))
			{
				$.ajax({
					url: base_url+"action_payment.php",
					method:"POST",
					data:{billId:billId, btn_action_payment:btn_action_payment},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
						managePaymentTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	$(document).on('submit','.msgForm', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: base_url+"action_message.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#successmsg').val(data.successmsg) ;
			}
		})
	});
	$(document).on('submit','.password_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: base_url+"action_password_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#password_validation')[0].reset();
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
	
	$(document).on('submit','.email_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: base_url+"action_email_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#email_validation')[0].reset();
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
	
	$(document).on('submit','.company_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: base_url+"action_company_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
	
	$(document).on('submit','.paypalemail_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: base_url+"action_paypal_email.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#passw').val('');
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				
				$('#newemail').val(data.email) ;
			}
		})
	});
	
	
	
});