<?php 
require_once('header.php'); 
$clickatellStatement = $pdo->prepare("SELECT * FROM key_clickatell WHERE clickatell_id = ?");
$clickatellStatement->execute(array(filter_var("5", FILTER_SANITIZE_NUMBER_INT))); 
$total = $clickatellStatement->rowCount();    
$clickatell = $clickatellStatement->fetchAll(PDO::FETCH_ASSOC); 
foreach($clickatell as $ctell) {
	$apikey = _e($ctell['clickatell_apikey']);
	$username   = _e($ctell['clickatell_username']);
	$password = _e($ctell['clickatell_password']);
}
if(isset($_POST['submit'])){
	$clickatellid  = filter_var($_POST['clickatellid'], FILTER_SANITIZE_NUMBER_INT) ;
	$clickatell_api_key = filter_var($_POST['clickatell_api_key'], FILTER_SANITIZE_STRING) ;
	$username = filter_var($_POST['username'], FILTER_SANITIZE_STRING) ;
	$password = filter_var($_POST['password'], FILTER_SANITIZE_STRING);
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if($total == 0) {
		$ins = $pdo->prepare("INSERT INTO key_clickatell (clickatell_id, clickatell_apikey, clickatell_username, clickatell_password) VALUES (?,?,?,?)");
		$ins->execute(array($clickatellid,$clickatell_api_key,$username,$password));
	} else {
		$upd = $pdo->prepare("UPDATE key_clickatell SET clickatell_apikey=? , clickatell_username=? , clickatell_password=? WHERE clickatell_id=?");
		$upd->execute(array($clickatell_api_key,$username,$password,$clickatellid));			
	}
	header("location:".$actual_link."");
}
?>
<main class="page-content">
    <div class="container-fluid">
      <h2>Clickatell Details</h2>
      <hr>
      <div class="row">
	  	<div class="col-lg-12 col-md-12">
		   	<div class="row">
		   		<div class="col-md-3 col-lg-3"></div>
				<div class="col-md-6 col-lg-6">
					<form action="" method="post" >
					  <?php $csrf->echoInputField(); ?>
					  <div class="form-group">
						<label>Clickatell API Key*</label>
						<input type="text" class="form-control"   placeholder="Clickatell API Key" name="clickatell_api_key" value="<?php echo $apikey ; ?>" required>
					  </div>
					  <div class="form-group">
						<label>Clickatell Username</label>
						<input type="text" class="form-control"  placeholder="Clickatell Username" name="username" value="<?php echo $username; ?>" required >
					  </div>
					  <div class="form-group">
						<label>Clickatell Password</label>
						<input type="text" class="form-control"  placeholder="Clickatell Password" name="password" value="<?php echo $password; ?>" >
					  </div>
					  <div class="form-group" align="center">
					  <input type="hidden" name="clickatellid" value="<?php echo filter_var("5", FILTER_SANITIZE_NUMBER_INT) ; ?>" />
					  <input type="submit" class="btn btn-primary" name="submit" value="Save">
					  </div>
					</form>
				</div>
				<div class="col-md-3 col-lg-3"></div>
			 </div>
		 </div>
	  </div>
   </div>
</main>  <!-- page-content" -->
<?php require_once('footer.php'); ?>
