<?php 
require_once('header.php'); 
$customStatement = $pdo->prepare("SELECT * FROM key_customapi_v3 WHERE customapivthree_id = ?");
$customStatement->execute(array(filter_var("9", FILTER_SANITIZE_NUMBER_INT))); 
$total = $customStatement->rowCount();    
$custom = $customStatement->fetchAll(PDO::FETCH_ASSOC); 
foreach($custom as $cvthree) {
	$api_url = _e($cvthree['customapivthree_url']);
}
if(isset($_POST['submit'])){
	$customapi_id = filter_var($_POST['customapi_id'], FILTER_SANITIZE_NUMBER_INT);
	$apiurl  = filter_var($_POST['apiurl'], FILTER_SANITIZE_URL) ;
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if($total == 0) {
		$ins = $pdo->prepare("INSERT INTO key_customapi_v3 (customapivthree_id, customapivthree_url) VALUES (?,?)");
		$ins->execute(array($customapi_id,$apiurl));
	} else {
		$upd = $pdo->prepare("UPDATE key_customapi_v3 SET customapivthree_url=? WHERE customapivthree_id=?");
		$upd->execute(array($apiurl,$customapi_id));
	}
	header("location:".$actual_link."");
}
?>
<main class="page-content">
	<div class="container-fluid">
		<h2>Custom API (with International Code & with "+" sign.)</h2>
	  	<br />
	  	<h5>Means your SMS service provider supports International SMS & also support "+" sign before country code.</h5>
      	<hr>
      	<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="row">
		   			<div class="col-md-12 col-lg-12">
						<form action="" method="post" >
							<?php $csrf->echoInputField(); ?>
					  		<div class="form-group">
								<small class="form-text text-muted">
								<b>Example</b>
								<br /><br />
								<p> http://api.clickatell.com/http/sendmsg?api_id=clickatell_apikey&user=clickatell_username&password=clickatell_password&to=user_phone_abcd&text=user_message_abcd </p>
								<br /><br />
								<b>Note : Do not change value of phone/mobile/to = user_phone_abcd and content/text/message = user_message_abcd </b>
								</small>
								<br />
								<label>Custom Http API URL* (Must Be Curl Supported)</label>
								<textarea class="form-control" name="apiurl"><?php echo $api_url ; ?></textarea>
					 		 </div>
					 		 <div class="form-group" align="center">
					  			<input type="hidden" name="customapi_id" value="<?php echo filter_var("9", FILTER_SANITIZE_NUMBER_INT) ; ?>" />
					  			<input type="submit" class="btn btn-primary" name="submit" value="Save">
					  		</div>
						</form>
					</div>
				</div>
		   </div>
	  </div>
   </div>
</main><!-- page-content" -->
<?php require_once('footer.php'); ?>
