<?php
ob_start();
session_start();
include("db/config.php");
include("db/CSRF_Protect.php");
include("db/function_xss.php");
$csrf = new CSRF_Protect();
// Checking Admin is logged in or not
if(!isset($_SESSION['admin'])) {
	header('location: login.php');
	exit;
} 
$admin = $pdo->prepare("SELECT * FROM ot_admin WHERE admin_status=?");
$admin->execute(array(filter_var("1", FILTER_SANITIZE_NUMBER_INT)));   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
foreach($admin_result as $adm) {
//escape all admin data
	$id = _e($adm['id']);
	$full_name = _e($adm['fullname']);
	$email_old   = _e($adm['email']);
	$old_password = _e($adm['password']);
	$show_announcement = _e($adm['show_announcement']) ;
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Dashboard</title>

	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/all.min.css">
	<link rel="stylesheet" href="css/datatables.min.css">
	<link rel="stylesheet" href="css/datepicker.css">
	<link rel="stylesheet" href="css/admin_index.css">
</head>
<body>
	<div class="page-wrapper chiller-theme toggled">
		<a id="show-sidebar" class="btn btn-sm btn-dark" href="#"><i class="fas fa-bars"></i></a>
		<nav id="sidebar" class="sidebar-wrapper">
			<div class="sidebar-content">
				<div class="sidebar-brand">
					<a href="index.php"><span> <img src="../images/siteLogo.png" class="img-fluid" alt="Logo"></a>
					<div id="close-sidebar">
						<i class="fas fa-times"></i>
					</div>
				</div>
				<div class="sidebar-header">
					<div class="user-pic">
						<i class="fa fa-user-secret fa-3x text-white"></i>
					</div>
					<div class="user-info">
						<span class="user-name">
						<strong><?php echo $full_name ; ?></strong>
						</span>
						<span class="user-role">Administrator</span>
					</div>
				</div> <!-- sidebar-header  -->
				<div class="sidebar-menu">
					<ul>
						<li class="header-menu">
							<span>General</span>
						</li>
						<li>
							<a href="index.php">
								<i class="fa fa-home"></i>
								<span>Home</span>
							</a>
						</li>
						<li>
							<a href="addAnnouncement.php">
							  <i class="fa fa-bullhorn"></i>
							  <span>Add Announcement</span>
							</a>
						</li>
						<li>
						<li>
							<a href="selected_country.php">
								<i class="fa fa-crosshairs"></i>
								<span>Manage Country</span>
							</a>
						</li>
						<li>
							<a href="edit_user.php">
								<i class="fa fa-ban"></i>
								<span>Activate / Deactivate User</span>
							</a>
						</li>
						<li class="sidebar-dropdown">
							<a href="#">
								<i class="fa fa-code"></i>
								<span>API</span>
								<span class="badge badge-pill badge-warning">New</span>
							</a>
							<div class="sidebar-submenu">
								<ul>
									<?php
									$activeAPI = $pdo->prepare("SELECT * FROM api_active WHERE 1");
									$activeAPI->execute();   
									$result = $activeAPI->fetchAll(PDO::FETCH_ASSOC); 
									foreach($result as $row)
									{
									?>
										<li>
											<a href="<?php echo _e($row['api_url']); ?>">
												<?php echo _e($row['api_name']) ; if(_e($row['api_active']) == '1'){?>
												<span class="badge badge-pill badge-success">Active</span>
												<?php } ?>
											</a>
										</li>
									<?php
									}
									?>
								 </ul>
							</div>
						</li>
					</ul>
				</div> <!-- sidebar-menu  -->
			</div> <!-- sidebar-content  -->
			<div class="sidebar-footer">
				<a href="settings.php">
					<i class="fa fa-cog"></i>
					<span class="badge-sonar"></span>
				</a>
				<a href="logout.php">
					<i class="fa fa-power-off"></i>
				</a>
			</div>
		</nav><!-- sidebar-wrapper  -->
 
