jQuery(document).ready(function($) {
	
	 "use strict";
	
	var mainDocument = $(document);
	
	var manageCustomerTable = $('#manageCustomerTable').DataTable({
		'ajax': 'fetchUser.php',
		'order': []
	});
	
	var manageCountryTable = $('#manageCountryTable').DataTable({
		'ajax': 'fetchCountry.php',
		'order': []
	});
	var manageAnnouncementTable = $('#manageAnnouncementTable').DataTable({
		'ajax': 'fetchAnnouncement.php',
		'order': []
	});
		mainDocument.on('click', '.changeCountryStatus', function(){
			var countryId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeCountryStatus";
			if(confirm("Are you sure you want to change status?"))
			{
				$.ajax({
					url:"change_country_status.php",
					method:"POST",
					data:{countryId:countryId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageCountryTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
		
		mainDocument.on('click', '.changeUserStatus', function(){
			var customerId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeUserStatus";
			if(confirm("Are you sure you want to change User status?"))
			{
				$.ajax({
					url:"change_status.php",
					method:"POST",
					data:{customerId:customerId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageCustomerTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
		
		mainDocument.on('click', '.delUserStatus', function(){
			var customerId = $(this).attr("id");
			var btn_action = "delUserStatus";
			if(confirm("Are you sure you want to Delete this User Permanently? It cannot be undone."))
			{
				$.ajax({
					url:"delete_user.php",
					method:"POST",
					data:{customerId:customerId, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageCustomerTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
		mainDocument.on('click', '.changeAnnounceStatus', function(){
			var announceId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeAnnounceStatus";
			if(confirm("Are you sure you want to change Announcement status?"))
			{
				$.ajax({
					url:"change_announcement_status.php",
					method:"POST",
					data:{announceId:announceId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageAnnouncementTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
		mainDocument.on('click', '#add_announce', function(){
		$('#announcementModal').modal('show');
		$('#announcement_form')[0].reset();
		$('.modal-title').html("<i class='fa fa-bullhorn'></i> Add Announcement");
		$('#action').val('Add Announcement');
		$('#btn_action').val('AddAnnouncement');
	});
	mainDocument.on('submit','#announcement_form', function(event){
		event.preventDefault();
		$('#action').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"add_announcement_action.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				$('#announcement_form')[0].reset();
				$('#announcementModal').modal('hide');
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#action').attr('disabled', false);
				manageAnnouncementTable.ajax.reload();
			}
		})
	});
	mainDocument.on('click', '.editAnnounceStatus', function(){												
		var announceId = $(this).attr("id");
		var btn_action = 'fetch_announcement';
		$('#announcement_form')[0].reset();
		$.ajax({
			url:"change_announcement_status.php",
			method:"POST",
			data:{announceId:announceId, btn_action:btn_action},
			dataType:"json",
			success:function(data)
			{	
				$('#announcementModal').modal('show');
				$('.modal-title').html("<i class='fa fa-bullhorn'></i> Edit Announcement");
				$('#announce_date').val(data.announcementDate);
				$('#announceText').val(data.announcementText);
				$('#announcement_id').val(data.announcementId);
				$('#action').val('Edit Announcement');
				$('#btn_action').val('EditAnnouncement');
			}
		})
	});
	mainDocument.ready(function(){
		$('.announce_date').datepicker({
			format: "yyyy-mm-dd",
			autoclose: true,
			orientation: "top"
		});
	});
});
