<?php 
require_once('header.php'); 
$msgoneStatement = $pdo->prepare("SELECT * FROM key_msgone WHERE msgone_id = ?");
$msgoneStatement->execute(array(filter_var("3", FILTER_SANITIZE_NUMBER_INT))); 
$total = $msgoneStatement->rowCount();    
$msgone = $msgoneStatement->fetchAll(PDO::FETCH_ASSOC); 
foreach($msgone as $mone) {
	$authkey = _e($mone['msgone_auth_key']);
	$senderid   = _e($mone['msgone_senderid']);
	$route = _e($mone['msgone_route']);
	$country = _e($mone['msgone_country']);
	$template = _e($mone['msgone_template']);
}
if(isset($_POST['submit'])){
	$msgoneid  = filter_var($_POST['msgoneid'], FILTER_SANITIZE_NUMBER_INT) ;
	$msgone_authkey = filter_var($_POST['msgone_authkey'], FILTER_SANITIZE_STRING) ;
	$msgone_senderid = filter_var($_POST['senderid'], FILTER_SANITIZE_STRING) ;
	$route = filter_var($_POST['route'], FILTER_SANITIZE_NUMBER_INT) ;
	$country = filter_var($_POST['country'], FILTER_SANITIZE_NUMBER_INT);
	$template_id = filter_var($_POST['template'], FILTER_SANITIZE_STRING);
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if($total == 0) {
		$ins = $pdo->prepare("INSERT INTO key_msgone (msgone_id, msgone_auth_key, msgone_senderid, msgone_route,msgone_country , msgone_template) VALUES (?,?,?,?,?,?)");
		$ins->execute(array($msgoneid,$msgone_authkey,$msgone_senderid,$route,$country,$template_id));
	} else {
		$upd = $pdo->prepare("UPDATE key_msgone SET msgone_auth_key=?, msgone_senderid=? , msgone_route=? , msgone_country=? , msgone_template = ? WHERE msgone_id=?");
		$upd->execute(array($msgone_authkey,$msgone_senderid,$route,$country,$template_id,$msgoneid));
	}
	header("location:".$actual_link."");
}
?>
<main class="page-content">
	<div class="container-fluid">
		<h2>MSG91 Details</h2>
		<hr>
    	<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="row">
					<div class="col-md-3 col-lg-3"></div>
					<div class="col-md-6 col-lg-6">
						<form action="" method="post" >
							<?php $csrf->echoInputField(); ?>
					  		<div class="form-group">
								<label>Msg91 Authentication Key*</label>
								<input type="text" class="form-control"   placeholder="Msg91 Authentication Key" name="msgone_authkey" value="<?php echo $authkey ; ?>" required>
					  		</div>
					  		<div class="form-group">
								<label>Msg91 SenderID*</label>
								<input type="text" class="form-control"  placeholder="Msg91 SenderID" name="senderid" value="<?php echo $senderid; ?>" required >
					  		</div>
					  		<div class="form-group">
								<label>Msg91 route*<small class="form-text text-muted">route=1 for promotional, route=4 for transactional SMS</small></label>
								<input type="text" class="form-control"  placeholder="Msg91 route" name="route" value="<?php echo $route; ?>" required >
					  		</div>
					  		<div class="form-group">
								<label>Msg91 Country*<small class="form-text text-muted">0 for international, 1 for USA, 91 for India</small></label>
								<input type="text" class="form-control"  placeholder="Msg91 Country" name="country" value="<?php echo $country; ?>" required >
					  		</div>
					  		<div class="form-group">
								<label>Msg91 Template ID (Optional)</label>
								<input type="text" class="form-control"  placeholder="Msg91 Template ID (Optional)" name="template" value="<?php echo $template; ?>" >
					  		</div>
					  		<div class="form-group" align="center">
					  			<input type="hidden" name="msgoneid" value="<?php echo filter_var("3", FILTER_SANITIZE_NUMBER_INT)  ; ?>" />
					  			<input type="submit" class="btn btn-primary" name="submit" value="Save">
					  		</div>
						</form>
					</div>
					<div class="col-md-3 col-lg-3"></div>
				</div>
			</div>
		</div>
	</div>
</main> <!-- page-content" -->
<?php require_once('footer.php'); ?>
