<?php 
require_once('header.php');  
$textlocalStatement = $pdo->prepare("SELECT * FROM key_textlocal WHERE textlocal_id = ?");
$textlocalStatement->execute(array(filter_var("4", FILTER_SANITIZE_NUMBER_INT))); 
$total = $textlocalStatement->rowCount();    
$textlocal = $textlocalStatement->fetchAll(PDO::FETCH_ASSOC); 
foreach($textlocal as $tlocal) {
	$apikey = _e($tlocal['textlocal_api_key']);
	$senderid   = _e($tlocal['textlocal_senderid']);
}
if(isset($_POST['submit'])){
	$textlocalid  = filter_var($_POST['textlocalid'], FILTER_SANITIZE_NUMBER_INT) ;
	$textlocal_apikey = filter_var($_POST['textlocal_apikey'], FILTER_SANITIZE_STRING) ;
	$textlocal_senderid = filter_var($_POST['senderid'], FILTER_SANITIZE_STRING) ;
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if($total == 0) {
		$ins = $pdo->prepare("INSERT INTO key_textlocal (textlocal_id, textlocal_api_key, textlocal_senderid) VALUES (?,?,?)");
		$ins->execute(array($textlocalid,$textlocal_apikey,$textlocal_senderid));
	} else {
		$upd = $pdo->prepare("UPDATE key_textlocal SET textlocal_api_key=?, textlocal_senderid=? WHERE textlocal_id=?");
		$upd->execute(array($textlocal_apikey,$textlocal_senderid,$textlocalid));
	}
	header("location:".$actual_link."");
}
?>
<main class="page-content">
	<div class="container-fluid">
		<h2>TextLocal Details</h2>
		<hr>
      	<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="row">
		   			<div class="col-md-3 col-lg-3"></div>
					<div class="col-md-6 col-lg-6">
						<form action="" method="post" >
							<?php $csrf->echoInputField(); ?>
					  		<div class="form-group">
								<label>TextLocal API Key*</label>
								<input type="text" class="form-control"   placeholder="TextLocal API Key" name="textlocal_apikey" value="<?php echo $apikey ; ?>" required>
					  		</div>
					  		<div class="form-group">
								<label>TextLocal SenderID*<small class="form-text text-muted">TXTLCL or Your_SENDER_ID</small></label></label>
								<input type="text" class="form-control"  placeholder="TextLocal SenderID" name="senderid" value="<?php echo $senderid; ?>" required >
					  		</div>
					  		<div class="form-group" align="center">
					  			<input type="hidden" name="textlocalid" value="<?php echo filter_var("4", FILTER_SANITIZE_NUMBER_INT) ; ?>" />
					  			<input type="submit" class="btn btn-primary" name="submit" value="Save">
					  		</div>
						</form>
					</div>
					<div class="col-md-3 col-lg-3"></div>
			  	</div>
		   	</div>
	  	</div>
	</div>
  </div>
</main> <!-- page-content" -->
<?php require_once('footer.php'); ?>
