<?php 
require_once('header.php'); 
$twofactorStatement = $pdo->prepare("SELECT * FROM key_twofactor WHERE twofactor_id = ?");
$twofactorStatement->execute(array(filter_var("6", FILTER_SANITIZE_NUMBER_INT))); 
$total = $twofactorStatement->rowCount();    
$twofactor = $twofactorStatement->fetchAll(PDO::FETCH_ASSOC); 
foreach($twofactor as $two) {
	$apikey = _e($two['twofactor_apikey']);
	$s_id   = _e($two['twofactor_senderid']);
	$template = _e($two['twofactor_templatename']);
}
if(isset($_POST['submit'])){
	$twofactorid  = filter_var($_POST['twofactorid'], FILTER_SANITIZE_NUMBER_INT) ;
	$twofactor_api_key = filter_var($_POST['twofactor_api_key'], FILTER_SANITIZE_STRING) ;
	$senderid = filter_var($_POST['senderid'], FILTER_SANITIZE_STRING) ;
	$template_name = filter_var($_POST['template_name'], FILTER_SANITIZE_STRING);
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if($total == 0) {
		$ins = $pdo->prepare("INSERT INTO key_twofactor (twofactor_id, twofactor_apikey, twofactor_senderid, twofactor_templatename) VALUES (?,?,?,?)");
		$ins->execute(array($twofactorid,$twofactor_api_key,$senderid,$template_name));
	} else {
		$upd = $pdo->prepare("UPDATE key_twofactor SET twofactor_apikey=? , twofactor_senderid=? , twofactor_templatename=? WHERE twofactor_id=?");
		$upd->execute(array($twofactor_api_key,$senderid,$template_name,$twofactorid));
	}
	header("location:".$actual_link."");
}
?>
<main class="page-content">
	<div class="container-fluid">
		<h2>2Factor.in Details</h2>
      	<hr>
      	<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="row">
		   			<div class="col-md-3 col-lg-3"></div>
					<div class="col-md-6 col-lg-6">
						<form action="" method="post" >
							<?php $csrf->echoInputField(); ?>
					  		<div class="form-group">
								<label>2Factor.in API Key*</label>
								<input type="text" class="form-control"   placeholder="2Factor.in API Key" name="twofactor_api_key" value="<?php echo $apikey ; ?>" required>
					  		</div>
					  		<div class="form-group">
								<label>2Factor.in Sender ID (Optional)</label>
								<input type="text" class="form-control"  placeholder="Sender ID" name="senderid" value="<?php echo $s_id; ?>" >
					  		</div>
					  		<div class="form-group">
								<label>2Factor.in Template Name(Optional)</label>
								<input type="text" class="form-control"  placeholder="Template Name" name="template_name" value="<?php echo $template; ?>" >
					  		</div>
					  		<div class="form-group" align="center">
					  			<input type="hidden" name="twofactorid" value="<?php echo filter_var("6", FILTER_SANITIZE_NUMBER_INT) ; ?>" />
						  		<input type="submit" class="btn btn-primary" name="submit" value="Save">
					  		</div>
						</form>
					</div>
					<div class="col-md-3 col-lg-3"></div>
			  	</div>
		   	</div>
	  	</div>
	</div>
</main> <!-- page-content" -->
<?php require_once('footer.php'); ?>
