// JavaScript Document
jQuery(function ($) {
	
	"use strict";
	
	var mainDocument = $(document);
	
	
	var manageAnnouncementTable = $('#manageAnnouncementTable').DataTable({
		'ajax': 'fetchAnnouncement.php',
		'order': []
	});
	var manageSubscriberTable = $('#manageSubscriberTable').DataTable({
		'ajax': 'fetchSubscriber.php',
		'order': []
	});
	mainDocument.on('click', '.changePinnedStatus', function(){
			var announceId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changePinnedStatus";
			if(confirm("Are you sure you want to change Pinned Status of Announcement ?"))
			{
				$.ajax({
					url:"change_announcement_status.php",
					method:"POST",
					data:{announceId:announceId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageAnnouncementTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	mainDocument.on('click', '.changeAnnounceStatus', function(){
			var announceId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeAnnounceStatus";
			if(confirm("Are you sure you want to change Announcement status?"))
			{
				$.ajax({
					url:"change_announcement_status.php",
					method:"POST",
					data:{announceId:announceId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageAnnouncementTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	var manageCommentTable = $('#manageCommentTable').DataTable({
		'ajax': 'fetchComment.php',
		'order': []
	});
	var manageApproveCommentTable = $('#manageApproveCommentTable').DataTable({
		'ajax': 'fetch_approvecomments.php',
		'order': []
	});
	var manageUnapproveCommentTable = $('#manageUnapproveCommentTable').DataTable({
		'ajax': 'fetch_unapprovecomments.php',
		'order': []
	});
	
	mainDocument.on('click', '.changeCommentStatus', function(){
			var commentId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeCommentStatus";
			if(confirm("Are you sure you want to change Comment status?"))
			{
				$.ajax({
					url:"change_comment_status.php",
					method:"POST",
					data:{commentId:commentId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageCommentTable.ajax.reload();
						manageApproveCommentTable.ajax.reload();
						manageUnapproveCommentTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	mainDocument.on('click', '.changeComStatus', function(){
			var announceId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeComStatus";
			if(confirm("Are you sure you want to change Adding New Comment status to this Announcement?"))
			{
				$.ajax({
					url:"change_announcement_status.php",
					method:"POST",
					data:{announceId:announceId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageAnnouncementTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
		mainDocument.on('click', '.viewVideo', function(){
		var yid = $(this).attr("id");									
		$('.youtubeModal').modal('show');
		$('.modal-title').html('<i class="fa fa-video"></i> Youtube Video');
		$('.modal-body1').html('<iframe  allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen"  msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen"  webkitallowfullscreen="webkitallowfullscreen" width="420" height="315" src="https://www.youtube.com/embed/'+yid+'?autoplay=1"></iframe>');
		});
		
		$(".youtubeModal").on("hidden.bs.modal", function(){
			$(".modal-body1").html("");
		});
		
		mainDocument.on('click', '#add_announce', function(){
		$('#announcementModal').modal('show');
		$('#announcement_form')[0].reset();
		$('.modal-title').html("<i class='fa fa-bullhorn'></i> Add Announcement");
		$('#action').val('Add Announcement');
		$('#btn_action').val('AddAnnouncement');
		
	});
	mainDocument.on('submit','#announcement_form', function(event){
		event.preventDefault();
		$('#action').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"add_announcement_action.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				
				$('#announcement_form')[0].reset();
				$('#announcementModal').modal('hide');
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#action').attr('disabled', false);
				manageAnnouncementTable.ajax.reload();
			}
		})
	});
	mainDocument.on('click', '.editAnnounceStatus', function(){												
		var announceId = $(this).attr("id");
		var btn_action = 'fetch_announcement';
		$('#announcement_form')[0].reset();
		$.ajax({
			url:"change_announcement_status.php",
			method:"POST",
			data:{announceId:announceId, btn_action:btn_action},
			dataType:"json",
			success:function(data)
			{	
				$('#announcementModal').modal('show');
				$('.modal-title').html("<i class='fa fa-bullhorn'></i> Edit Announcement");
				$('#announce_date').val(data.announcementDate);
				$('#announceText').val(decodeEntities(data.announcementText));
				$('#announcement_id').val(data.announcementId);
				$('#you_vid').val(data.you_vid);
				$('#twitter_status').val(data.twitter_status);
				$('#fb_status').val(data.fb_status);
				$('#insta_status').val(data.insta_status);
				$('#action').val('Edit Announcement');
				$('#btn_action').val('EditAnnouncement');
			}
		})
	});
	mainDocument.on('click', '.editCommentStatus', function(){												
		var commentId = $(this).attr("id");
		var btn_action = 'fetch_comment';
		$('#comment_form')[0].reset();
		$.ajax({
			url:"change_comment_status.php",
			method:"POST",
			data:{commentId:commentId, btn_action:btn_action},
			dataType:"json",
			success:function(data)
			{	
				$('#commentModal').modal('show');
				$('#comment_date').val(data.commentDate);
				$('#commentText').val(decodeEntities(data.commentText));
				$('#comment_id').val(data.commentId);
				$('#comment_name').val(data.commentName);
				$('#comment_email').val(data.commentEmail);
				$('#replyText').val(decodeEntities(data.replyText));
				$('#action').val('Edit Comment');
				$('#btn_action').val('EditComment');
			}
		})
	});
	mainDocument.on('submit','#comment_form', function(event){
		event.preventDefault();
		$('#action').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"change_comment_status.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				$('#comment_form')[0].reset();
				$('#commentModal').modal('hide');
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#action').attr('disabled', false);
				manageCommentTable.ajax.reload();
				manageApproveCommentTable.ajax.reload();
				manageUnapproveCommentTable.ajax.reload();
			}
		})
	});
	mainDocument.ready(function(){
		$('.announce_date ,.comment_date').datepicker({
			format: "yyyy-mm-dd",
			autoclose: true,
			orientation: "top",
			endDate: "today"
		});
	});
	mainDocument.on('submit','.password_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url:"action_password_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#password_validation')[0].reset();
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
	
	mainDocument.on('submit','.email_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url:"action_email_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#email_validation')[0].reset();
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
	
	mainDocument.on('submit','.limit_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url:"action_limit_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
				$('#startLimit').val(data.startLimit);
				$('#loadLimit').val(data.loadLimit);
			}
		})
	});
	
	$(document).on('click', '.subscribe', function(){
		var btn_action_sb = 'add_code';
		 $.ajax({
            url:"add_subscriber.php",
            method:"POST",
            data:{btn_action_sb:btn_action_sb},
            success:function(data)
            {
				
				data = JSON.parse(data);
				$('#firstno').val(data.first_no);
				$('#secondno').val(data.second_no);
				$('#newfirst').html(data.first_no);
				$('#newsecond').html(data.second_no);
				$('#subscribeModal').modal('show');
				$('.subscribe_form')[0].reset();
				$('.modal-title').html("<i class='fa fa-bell'></i> Susbcribe Now");
				$('#action_sb').val('Subscribe');
			}
		});
	});
	$(document).on('submit','.subscribe_form', function(event){
		event.preventDefault();
		$('#action_sb').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"add_subscriber.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				data = JSON.parse(data);
				if(data.err == 0) {
					$('#action_sb').attr('disabled',false);
					$('#firstno').val(data.first_no);
					$('#secondno').val(data.second_no);
					$('#newfirst').html(data.first_no);
					$('#newsecond').html(data.second_no);
					$('.remove-messagess').fadeIn().html('<div  class="alert alert-danger errorMessage">'+data.form_msg+'<button type="button" class="close float-right" aria-label="Close" > <span aria-hidden="true" id="hide">&times;</span></button></div>');
				} else {
					$('.subscribe_form')[0].reset();
					$('#firstno').val(data.first_no);
					$('#secondno').val(data.second_no);
					$('#newfirst').html(data.first_no);
					$('#newsecond').html(data.second_no);
					$('#action_sb').attr('disabled', false);
					$('.remove-messagess').fadeIn().html('<div  class="alert alert-success errorMessage">'+data.form_msg+'<button type="button" class="close float-right" aria-label="Close" > <span aria-hidden="true" id="hide">&times;</span></button></div>');
					manageSubscriberTable.ajax.reload();
				}
			}
		})
	});
	
		mainDocument.on('click', '.deleteSubscriber', function(){
			var delId = $(this).attr("id");
			var btn_action = "deleteSubscriber";
			if(confirm("Are you sure you want to Delete this subscriber ? It cannot be undone."))
			{
				$.ajax({
					url:"delete_subscriber.php",
					method:"POST",
					data:{delId:delId, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageSubscriberTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
		mainDocument.on('submit','.email_settings', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url:"action_email_setting.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
		
	mainDocument.on('click', '.show-46', function(){
		$('#embedModal46').modal('show');
	});
	mainDocument.on('click', '.show-64', function(){
		$('#embedModal64').modal('show');
	});
	mainDocument.on('click', '.show-66', function(){
		$('#embedModal66').modal('show');
	});
	mainDocument.on('click', '.show-100', function(){
		$('#embedModal100').modal('show');
	});
		
	$(document).on("click","#hide", function() {
		$(".errorMessage").hide();
	});
	
	function decodeEntities(encodedString) {
	  var textArea = document.createElement('textarea');
	  textArea.innerHTML = encodedString;
	  return textArea.value;
	}
	
});