<?php
ob_start();
session_start();
require_once('db/config.php');
require_once("db/function_xss.php");
require_once('db/api_otp_generate.php');
$err = '0' ;
$headers = '0' ;
	//check fullname, email, password should not be empty
	if( !empty($_POST['user_name']) && !empty($_POST['user_email']) && !empty($_POST['user_pass']) && !empty($_POST['adm_email']) && !empty($_POST['login_url']) ){
		$fullname = filter_var($_POST['user_name'], FILTER_SANITIZE_STRING) ;
		$email = filter_var($_POST['user_email'], FILTER_SANITIZE_EMAIL) ;
		$admin_email = filter_var($_POST['adm_email'], FILTER_SANITIZE_EMAIL) ;
		$password = filter_var($_POST['user_pass'], FILTER_SANITIZE_STRING) ;
		$login_url = filter_var($_POST['login_url'], FILTER_SANITIZE_URL) ;
		$uppercase = preg_match('@[A-Z]@', $password);
		$lowercase = preg_match('@[a-z]@', $password);
		$number    = preg_match('@[0-9]@', $password);
		//validate password
		if(!$uppercase || !$lowercase || !$number || strlen($password) < 8) {
		  $err = 1 ;
		  echo $err ;
		} else {
				//checking database for already registered mobile
				$checkUser =  $pdo->prepare("SELECT * FROM customer_active WHERE user_email=?");
		 		$checkUser->execute(array($email));
		 		$user_ok = $checkUser->rowCount();
				if($user_ok > 0) {
					$err = 2 ;
		 		    echo $err ;
				} else {
					$otp = filter_var(code(4), FILTER_SANITIZE_NUMBER_INT) ;
					$to = $email ;
					$from = $admin_email ;
					$from = "Verification OTP: ".$from ;
					$headers .= 'MIME-Version: 1.0' . "\r\n" ;
					$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
					$headers .= $from . "\r\n" ; 
					$subject = "Congratulations! You are Active User Now." ;
					$body = "<br>Email : <br><h3>".$email."</h3><br>Password : <br><h3>".$password."</h3><br>Login Link : <br><h3>".$login_url."</h3><br>Please Do not share with anyone at any cost.";
					if (mail($to, $subject, $body, $headers))
					{
						//first we insert/update user into temp table until they verify OTP
						
							$ins_in_tmp = $pdo->prepare("INSERT INTO customer_active (user_fullname, user_email, user_authpass, user_otp) VALUES (?,?,?,?)");
							$ins_in_tmp->execute(array($fullname,$email,password_hash($password, PASSWORD_DEFAULT),$otp));
						
						$output = array( 
									'error' => 0
								) ;
						echo json_encode($output);
					} else {
						$_SESSION['error_message'] = 'Sorry, Email not send. Try Again.';
						header("location: index.php");
					}
				}
			
		}
	
	} else {
		header("location: index.php");
	}

?>
