<?php
ob_start();
session_start();
include("db/config.php");
include("db/function_xss.php");
// Checking Admin is logged in or not
if(!isset($_SESSION['admin'])) {
	header('location: login.php');
	exit;
}
if(isset($_POST['btn_action']))
{
	if($_POST['btn_action'] == 'fetch_ticket')
	{
		$ticket_id = filter_var($_POST['ticket_id'], FILTER_SANITIZE_NUMBER_INT) ;
		$statement = $pdo->prepare("select * from ticket_system where ticket_id = ?");
		$statement->execute(array($ticket_id)) ;
		$userData = $statement->fetchAll(PDO::FETCH_ASSOC);
		foreach($userData as $row) {
			$output['user_name'] = _e($row['ticket_name']);
			$output['user_email'] = _e($row['ticket_email']) ;
			$output['user_subject'] = _e($row['ticket_subject']) ;
			$output['user_message'] = _e($row['ticket_body']) ;
			$output['ticket_id'] = _e($row['ticket_id']) ;
		}
		echo json_encode($output);
	}
}
if(isset($_POST['btn_action_send_email']))
{
	if($_POST['btn_action_send_email'] == 'Submit')
	{
		$ticket_id = filter_var($_POST['ticketid'], FILTER_SANITIZE_NUMBER_INT) ;
		$admin_email = filter_var($_POST['admin_email'], FILTER_SANITIZE_EMAIL) ;
		$user_email = filter_var($_POST['user_email'], FILTER_SANITIZE_EMAIL) ;
		$admin_reply = filter_var($_POST['admin_reply'], FILTER_SANITIZE_STRING) ;
		$subject = filter_var($_POST['user_subject'], FILTER_SANITIZE_STRING) ;
		$user_msg = filter_var($_POST['user_message'], FILTER_SANITIZE_STRING) ;
		$date = filter_var(date("Y-m-d"), FILTER_SANITIZE_STRING) ;
		if(!empty($admin_reply)) {
			$to = $user_email ;
			$from = $admin_email ;
			$from = "Email: ".$from ;
			$headers = '';
			$headers .= 'MIME-Version: 1.0' . "\r\n" ;
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n" ; 
			$headers .= $from . "<br>" ;
			$body = "Your Query : ".$user_msg."<br><br><br>Admin Reply : ".$admin_reply ;
			if(mail($to, $subject, $body, $headers)) {
				$ins = $pdo->prepare("insert into send_message (message_ticket_id , admin_message, message_date) values (?,?,?)");
				$ins->execute(array($ticket_id,$admin_reply,$date));
				$upd = $pdo->prepare("update ticket_system set ticket_status = '1' where ticket_id = ?"); 
				$upd->execute(array($ticket_id)) ;
				echo "Email has been sent, You can check your reply in Sent Email Option." ;
			} else {
				echo "Email not sent. Try Again." ;
			}
		} else {
			echo "Admin Reply is mandatory." ;
		}
		
	}
}
?>
