jQuery(document).ready(function($) {
	
	 "use strict";
	
	var mainDocument = $(document);
	
	var manageCustomerTable = $('#manageCustomerTable').DataTable({
		'ajax': 'fetchUser.php',
		'order': []
	});
	var manageEmailTable = $('#manageEmailTable').DataTable({
		'ajax': 'fetchUserEmail.php',
		'order': []
	});
	var managesentEmailTable = $('#managesentEmailTable').DataTable({
		'ajax': 'fetch_sent_mail.php',
		'order': []
	});
	var manageFormOptionTable = $('#manageFormOptionTable').DataTable({
		'ajax': 'fetch_select_option.php',
		'order': []
	});
	mainDocument.on("click","#hide", function() {
		$(".errorMessage").hide();
	});
	
		mainDocument.on('click', '.changeUserStatus', function(){
			var customerId = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeUserStatus";
			if(confirm("Are you sure you want to change User status?"))
			{
				$.ajax({
					url:"change_status.php",
					method:"POST",
					data:{customerId:customerId, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageCustomerTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	$(document).on('click', '#add_select_option', function(){
		$('#selectoptionModal').modal('show');
		$('#selectoption_form')[0].reset();
		$('.modal-title').html("<i class='fa fa-plus'></i> Add Contact Form Subject Option");
		$('#action_option').val('Add');
		$('#btn_action_option').val('Submit');
	});	
	$(document).on('submit','#selectoption_form', function(event){
		event.preventDefault();
		$('#action_option').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"ins_select_option.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				$('#selectoption_form')[0].reset();
				$('#selectoptionModal').modal('hide');
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#action_option').attr('disabled', false);
				manageFormOptionTable.ajax.reload();
			}
		})
	});
	$(document).on('click', '.changeSelectOption', function(){
			var subject_id = $(this).attr("id");
			var status = $(this).data("status");
			var btn_action = "changeSelectOption";
			if(confirm("Are you sure you want to change Option status?"))
			{
				$.ajax({
					url:"ins_select_option.php",
					method:"POST",
					data:{subject_id:subject_id, status:status, btn_action:btn_action},
					success:function(data)
					{
						$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
						manageFormOptionTable.ajax.reload();
					}
				})
			}
			else
			{
				return false;
			}
		
		});
	$(document).on('click', '.sendEmailUser', function(){
		var ticket_id = $(this).attr("id");
		var btn_action = 'fetch_ticket';
		$.ajax({
			url:"fetch_ticket_action.php",
			method:"POST",
			data:{ticket_id:ticket_id, btn_action:btn_action},
			dataType:"json",
			success:function(data)
			{
				$('#emailModal').modal('show');
				$('#user_message').prop('readonly',true);
				$('#user_name').val(data.user_name);
				$('#user_email').val(data.user_email);
				$('#user_subject').val(data.user_subject);
				$('#user_message').val(data.user_message);
				$('.modal-title').html("<i class='fa fa-pencil-square-o'></i> Send Email");
				$('#ticketid').val(data.ticket_id);
				$('#action_reply').val('Send Reply');
				$('#btn_action_send_email').val('Submit');
			}
		})
	});
	$(document).on('submit','#email_form', function(event){
		event.preventDefault();
		$('#action_reply').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"fetch_ticket_action.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				$('#emailModal').modal('hide');
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+data+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				$('#action_reply').attr('disabled', false);
				manageEmailTable.ajax.reload();
			}
		})
	});
	$(document).on('click', '#add_user', function(){
		$('#selectuserModal').modal('show');
		$('#selectuser_form')[0].reset();
		$('.modal-title').html("<i class='fa fa-plus'></i> Add User");
		$('#action_user').val('Add User & Send Email');
		$('#btn_action_user').val('Submit');
	});	
	$(document).on('submit','#selectuser_form', function(event){
		event.preventDefault();
		$('#action_user').attr('disabled','disabled');
		var form_data = $(this).serialize();
		$.ajax({
			url:"action_add_user.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{
				
				
				if(data == 1) {
					$('.removeuser-messages').fadeIn().html('<div  class="alert alert-danger errorMessage">Password must contain minimum 8 characters, 1 Uppercase character, 1 Lowercase character & 1 number.<button type="button" class="close float-right" aria-label="Close" > <span aria-hidden="true" id="hide">&times;</span></button></div>');
				} 
				if(data == 2) {
					$('.removeuser-messages').fadeIn().html('<div  class="alert alert-danger errorMessage">This Email is already Exist.<button type="button" class="close float-right" aria-label="Close" > <span aria-hidden="true" id="hide">&times;</span></button></div>');
				}
				data = JSON.parse(data);
				if(data.error == 0){
					$('#selectuser_form')[0].reset();
					$('#selectuserModal').modal('hide');
					$('.remove-messages').fadeIn().html('<div class="alert alert-info">User Added & Email Sent Successfully.</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},2000);
				}
				$('#action_user').attr('disabled', false);
				manageCustomerTable.ajax.reload();
			}
		})
	});
	$(document).on('submit','.password_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: "action_password_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#password_validation')[0].reset();
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
	
	$(document).on('submit','.email_validation', function(event){
		event.preventDefault();
		var form_data = $(this).serialize();
		$.ajax({
			url: "action_email_detail.php",
			method:"POST",
			data:form_data,
			success:function(data)
			{	
				$('#email_validation')[0].reset();
				data = JSON.parse(data);
				$('.remove-messages').fadeIn().html('<div class="alert alert-info">'+(data.form_message)+'</div>');
						setTimeout(function(){
							$(".remove-messages").fadeOut("slow");
						},3000);
			}
		})
	});
});
