<?php
ob_start();
session_start();
include("db/config.php");
include("db/CSRF_Protect.php");
include("db/function_xss.php");
$csrf = new CSRF_Protect();
$login_error_message='';
if(isset($_POST['admin_login'])) {
        
    if(empty($_POST['email']) || empty($_POST['password'])) {
        $login_error_message = 'Email or Password can not be empty<br>';
    } else {
		
		$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
		$password = filter_var($_POST['password'], FILTER_SANITIZE_STRING);

    	$statement = $pdo->prepare("SELECT * FROM ot_admin WHERE email=? AND admin_status=?");
    	$statement->execute(array($email,filter_var("1", FILTER_SANITIZE_NUMBER_INT)));
    	$total = $statement->rowCount();    
        $result = $statement->fetchAll(PDO::FETCH_ASSOC);    
        if($total==0) {
            $login_error_message .= 'Email Address does not match<br>';
        } else {       
            foreach($result as $row) { 
                $row_password = _e($row['password']);
            }
        
            if(password_verify($password, $row_password)) {
                $_SESSION['admin'] = $row;
                header("location: index.php");
            } else {       
            	$login_error_message .= 'Email / Password does not match<br>';
            }
        }
    }

    
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Admin Login</title>

	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

	<link rel="stylesheet" href="css/main.css">
	<link rel="stylesheet" href="css/all.min.css">
	
</head>

<body>
	<div id="login-overlay" class="modal-dialog shadow-lg">
		<div class="modal-content">
			<div class="modal-header justify-content-center bg-secondary">
				<img src="../images/siteLogo.png" class="img-fluid"  alt="Logo">
          	</div>
          	<div class="modal-body">
				<div class="row">
					<div class="col-lg-12 col-md-12">
						<div class="well">
							<form method="POST" action="">
								<?php $csrf->echoInputField(); ?> 
								<div class="form-group">
									<label for="email" class="control-label">Admin Email*</label>
                                  	<input type="text" class="form-control" name="email" required  placeholder="Admin Email" maxlength="25" required >
                              	</div>
                              	<div class="form-group">
									<label for="password" class="control-label">Admin Password*</label>
                                  	<input type="password" class="form-control" name="password" required>
                                  	<span class="help-block"></span>
                              	</div>
								  <?php 
									if( (isset($login_error_message)) && ($login_error_message!='') ):
										echo '<div class="alert alert-danger" >'.$login_error_message.'</div>';
									endif;
								  ?>
								  <div class="text-center">
							  	<button type="submit" class="btn btn-success btn-md shadow-lg " name="admin_login"><i class="fa fa-sign-in"></i> Login</button>
								</div>
                          	</form>
                      	</div>
                  	</div>
                 </div>
          	</div>
      	</div>
  	</div>

<script type="text/javascript" src="js/bootstrap.min.js"></script>
</body>
</html>
