<?php
ob_start();
session_start();
include("db/config.php");
include("db/function_xss.php");
// Checking Admin is logged in or not
if($_SESSION['admin'] == '' ){
	header('location: index.php');
	exit;
}
if(isset($_POST['btn_action_plan']))
{
	if($_POST['btn_action_plan'] == 'AddPlan')
	{
		if( isset($_POST['sname']) && isset($_POST['sdate']) && isset($_POST['price']) && isset($_POST['announce']) ){
			$sname = filter_var($_POST['sname'], FILTER_SANITIZE_STRING);
			$sdate = filter_var(date($_POST['sdate']), FILTER_SANITIZE_STRING) ;
			$price = filter_var($_POST['price'], FILTER_SANITIZE_NUMBER_INT);
			$announce = filter_var($_POST['announce'], FILTER_SANITIZE_NUMBER_INT);
			if($price != '0' && $announce != '0') {
				$ins = $pdo->prepare("insert into create_package (package_name, package_date, package_price, announcement_number) values (?,?,?,?)");
				$ins->execute(array($sname, $sdate, $price, $announce));
				echo "New Package Added Successfully and Live Now.";
			} else {
				echo "Error : Price & Announcement should not be 0. Try again";
			}
		} else {
			echo "All Fields are Mandatory. Try Again.";
		}
	}
	if($_POST['btn_action_plan'] == 'EditPlan')
	{
		if( isset($_POST['sid']) && isset($_POST['sname']) && isset($_POST['sdate']) && isset($_POST['price']) && isset($_POST['announce'])){
			$sid = filter_var($_POST['sid'], FILTER_SANITIZE_NUMBER_INT);
			$sname = filter_var($_POST['sname'], FILTER_SANITIZE_STRING);
			$sdate = filter_var(date($_POST['sdate']), FILTER_SANITIZE_STRING) ;
			$price = filter_var($_POST['price'], FILTER_SANITIZE_NUMBER_INT);
			$announce = filter_var($_POST['announce'], FILTER_SANITIZE_NUMBER_INT);
			if($price != '0' && $announce != '0') {
				$ins = $pdo->prepare("update create_package set package_name =? , package_date=? , package_price=?, announcement_number = ? where package_id= ?");
				$ins->execute(array($sname, $sdate, $price, $announce, $sid));
				echo "Package Edited Successfully.";
			} else {
				echo "Error : Price & Announcement should not be 0. Try again";
			}
		} else {
			echo "All Fields are Mandatory. Try Again.";
		}
	}
	
	if($_POST['btn_action_plan'] == 'fetch_plan')
	{	
		$planId = filter_var($_POST['planId'], FILTER_SANITIZE_NUMBER_INT) ;
		$fetch_plan = $pdo->prepare("select * from create_package where package_id = ?");
		$fetch_plan->execute(array($planId));
		$planData = $fetch_plan->fetchAll(PDO::FETCH_ASSOC);
		foreach($planData as $row) {
			$output['sid'] = _e($row['package_id']) ;
			$output['sname'] = strip_tags($row['package_name']) ;
			$output['sdate'] = _e($row['package_date']) ;
			$output['price'] = _e($row['package_price']) ;
			$output['announce'] = _e($row['announcement_number']) ;
		}
		echo json_encode($output);
	}
	if($_POST['btn_action_plan'] == 'changePlanStatus')
	{
		$planId = filter_var($_POST['planId'], FILTER_SANITIZE_NUMBER_INT);
		$status = filter_var($_POST['status'], FILTER_SANITIZE_NUMBER_INT);
		 
			$update = $pdo->prepare("UPDATE create_package SET package_status=?   WHERE package_id=?");
			$result_new = $update->execute(array($status,$planId));
			if($result_new) {
				echo 'Success : Package status changed .' ;		
		}
	}
}
?>