<?php
ob_start();
session_start();
include("db/config.php");
include("db/function_xss.php");
// Checking Admin is logged in or not
if(!isset($_SESSION['admin'])) {
	header('location: login.php');
	exit;
}
$Statement = $pdo->prepare("SELECT * FROM admin_announcement WHERE 1 order by announcement_id desc ");
$Statement->execute(); 
$total = $Statement->rowCount();    
$result = $Statement->fetchAll(PDO::FETCH_ASSOC); 
$output = array('data' => array());
if($total > 0) {
	$active = "";
	foreach($result as $row) {
		$announceId = _e($row['announcement_id']) ;
		$announceText = strip_tags($row['announcement_text']);
		$announceDate = _e($row['announcement_date']);
		$announceDate =  date('d F, Y',strtotime($announceDate));
		$yid = _e($row['youtube_id']) ;
		$twitter_status = _e($row['twitter_url']) ;
		$fb_status = _e($row['fb_url']) ;
		$insta_status = _e($row['insta_url']) ;
		$commentDisable = _e($row['comment_active']) ;
		$status = _e($row['announcement_status']);
		$pinned = _e($row['pinned']);
		$like = _e($row['like_count']) ;
		if($pinned == 0){
			$pinned_icon = '';
			$pinAnnounce = '<button type="button" name="changePinnedStatus" id="'.$announceId.'" class="btn btn-success btn-sm changePinnedStatus" data-status="1">Pinned</button>';
		} else {
			$pinned_icon = '<i class="fa fa-thumb-tack text-success fa-2x"></i>';
			$pinAnnounce = '<button type="button" name="changePinnedStatus" id="'.$announceId.'" class="btn btn-danger btn-sm changePinnedStatus" data-status="0">Unpinned</button>';
		}
		if(!empty($yid)){
			$video = '<button type="button" name="viewVideo" id="'.$yid.'" class="btn btn-light btn-sm viewVideo"><i class="fa fa-video text-danger fa-2x"></i></button>'; 
		} else {
			$video = "" ;
		}
		if(!empty($twitter_status)){
			$twitter_status = '<a href="'.$twitter_status.'" class="btn btn-light btn-sm" target="_blank"><i class="fab fa-twitter-square text-info fa-2x"></i></a>' ;
		} else {
			$twitter_status = "" ;
		}
		if(!empty($fb_status)){
			$fb_status = '<a href="'.$fb_status.'" class="btn btn-light btn-sm" target="_blank"><i class="fab fa-facebook-square text-info fa-2x"></i></a>' ;
		} else {
			$fb_status = "" ;
		}
		if(!empty($insta_status)){
			$insta_status = '<a href="'.$insta_status.'" class="btn btn-light btn-sm" target="_blank"><i class="fab fa-instagram text-success fa-2x"></i></a>' ;
		} else {
			$insta_status = "" ;
		}
		if($commentDisable== 1) {
			// deactivate announcement
			$comment ="<b>No</b>";
			$comBtn = '<button type="button" name="changeComStatus" id="'.$announceId.'" class="btn btn-danger btn-sm changeComStatus" data-status="0">Disable</button>';
		} else {
			// activate announcement
			$comment ="Yes";
			$comBtn = '<button type="button" name="changeComStatus" id="'.$announceId.'" class="btn btn-success btn-sm changeComStatus" data-status="1">Enable</button>';
		} 
		if($status== 1) {
			// deactivate announcement
			$active ="<b>Active</b>";
			$banAnnounce = '<button type="button" name="changeAnnounceStatus" id="'.$announceId.'" class="btn btn-danger btn-sm changeAnnounceStatus" data-status="0">Deactivate</button>';
			
		} else {
			// activate announcement
			$active ="Deactive";
			$banAnnounce = '<button type="button" name="changeAnnounceStatus" id="'.$announceId.'" class="btn btn-success btn-sm changeAnnounceStatus" data-status="1">Activate</button>';
			
		} 
		$editAnnounce = '<button type="button" name="editAnnounceStatus" id="'.$announceId.'" class="btn btn-light btn-sm editAnnounceStatus" ><i class="fa fa-pencil-alt"></i></button>'; 
		$output['data'][] = array( 		
		$announceId,
		$announceDate,
		$announceText,
		$video,
		$twitter_status,
		$fb_status,
		$insta_status,
		$pinned_icon,
		$like,
		$active,
		$editAnnounce,
		$comment,
		$comBtn,
		$pinAnnounce,
		$banAnnounce
		); 	
	}
}
echo json_encode($output);
?>