<?php 
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Expires: 0"); 
require_once('../admin/db/config.php') ;
require_once('../admin/db/function_xss.php') ;

$username = filter_var($_GET['username'], FILTER_SANITIZE_STRING) ;
$check = $pdo->prepare("select * from user_saas where u_username = '".$username."'");
$check->execute();
$chkResult = $check->fetchAll(PDO::FETCH_ASSOC);
foreach($chkResult as $uid){
	$userId = _e($uid['uid']) ;
	$startLim = _e($uid['start_lim']);
	$endLim = _e($uid['load_lim']);
	$design = _e($uid['alignment']);
	$logoUrl = _e($uid['logo_url']) ;
	$logoAlt = strip_tags($uid['logo_alt']) ;
}
if($logoAlt == '') {
		$logoAlt = "Logo";
	}
$chk = $check->rowCount();

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title><?php echo $username ; ?> Announcements</title>
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name="description" content="<?php echo $username ; ?> Announcements">
	<link rel="stylesheet" href="css/main.css">
	<link rel="stylesheet" href="css/all.min.css">
	<link rel="stylesheet" href="css/Latofont.css">
	<link rel="stylesheet" href="css/Niconnefont.css">
	<link rel="stylesheet" href="css/link.css">
</head>
<body class="myColor">
<?php
if($chk > 0){
$sql = "SELECT * FROM user_announcement WHERE user_id = '".$userId."' and announcement_status='1' and pinned = '0' order by announcement_id desc LIMIT $startLim" ;
$admin_announcement = $pdo->prepare($sql);
$admin_announcement->execute(); 
$announcement = $admin_announcement->fetchAll(PDO::FETCH_ASSOC);
$total = $admin_announcement->rowCount();

$sqlPinned = "SELECT * FROM user_announcement WHERE user_id = '".$userId."' and announcement_status='1' and pinned = '1' order by announcement_id desc LIMIT $startLim" ;
$admin_announcement_pinned = $pdo->prepare($sqlPinned);
$admin_announcement_pinned->execute(); 
$announcement_pinned = $admin_announcement_pinned->fetchAll(PDO::FETCH_ASSOC);
$total_pinned = $admin_announcement_pinned->rowCount();

function displayTextWithLinks($s) {
  return preg_replace('@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@', '<a href="$1">$1</a>', $s);
}
$first_no = '';
$second_no = '';

?>
<!-- Navbar-->
    <header class="app-header"><a class="app-header__logo" href=""><img src="<?php echo $logoUrl ; ?>" class="img-fluid" alt="<?php echo $logoAlt ; ?>"></a>
     
      <!-- Navbar Right Menu-->
      <ul class="app-nav">
        <!-- User Menu-->
        <li class="dropdown"><a class="app-nav__item" href="#!" data-toggle="dropdown" aria-label="Open Profile Menu"><i class="fa fa-bars fa-lg"></i></a>
          <ul class="dropdown-menu settings-menu dropdown-menu-right">
            <li><a class="dropdown-item subscribe" href="#!"><i class="fa fa-handshake fa-lg"></i> Subscribe Now</a></li>
          </ul>
        </li>
      </ul>
    </header>
<main class="">
    <div class="container-fluid mt-5">
		<div class="row">
	  	<div class="col-lg-12 col-md-12">
			<?php 
			if($total > 0 || $total_pinned > 0){
				require_once("alignCenter.php") ;
			} else {
			?>
				<div class="row">
	  			<div class="col-lg-12 col-md-12 text-center mt-4">
				<h3 class="text-danger">Sorry, This page does not have any Announcements.</h3>
				</div>
				</div>
			<?php
			}
			?>
		</div>
	  </div>
	 
   </div>
</main> <!-- page-content" -->
<!-- Add Subscribe Modal -->
<div id="subscribeModal" class="modal fade subscribeModal">
	<div class="modal-dialog">
		<form method="post" class="subscribe_form">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-success"><i class="fa fa-bell"></i> Subscribe Now</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="form-group mb-3">
						<input type="email" name="subemail" id="subemail" class="form-control" placeholder="Email Address*" maxlength="50" required autofocus>
						
					</div> 
					<div class="form-group text-left">
						<label for="message"><i class="fa fa-user-circle text-success"></i> Prove, You are Human*</label>
						<div class="input-group mb-3">
							<div class="input-group-prepend">
								<span class="input-group-text" id="basic-addon1"><span id="newfirst"></span>+<span id="newsecond"></span>
							</div>
							<input type="text" class="form-control" placeholder="Sum & Enter Value" name="sumvalue" id="sumvalue" autocomplete="off" >
						</div>
					</div>
					<br>
					<small class="text-muted">You will never miss New Announcements. We'll Notified you via Email.</small>
					<br>
					<div class="remove-messages"></div>
				</div> 
				<div class="modal-footer"> 
					<input type="hidden" name="uId" value="<?php echo $userId ; ?>" >
					<input type="hidden" name="firstno"  id="firstno" />
					<input type="hidden" name="secondno" id="secondno" />
					<input type="hidden" name="btn_action_sb" id="btn_action_sb" value="Subscribe" />
					<input type="submit" name="action_sb" id="action_sb" class="btn btn-info" value="Subscribe" />
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			</div>
		</form>
	</div>
</div>
<!--Success Comment Modal -->
<div id="commentSuccessModal" class="modal fade">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title text-success"><i class="fa fa-comment"></i> Comment Message</h4>
				
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<h5 class="text-muted"> Your comment has been sent to Admin for Approval. Thanks.</h5>
			</div> 
			<div class="modal-footer"> 
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>
<!--Success Subscriber Modal -->
<div id="sbSuccessModal" class="modal fade">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title text-success"><i class="fa fa-bell"></i> Subscriber</h4>
				
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<h5 class="text-muted"> Thanks for Subscribing Us. We'll Notified you via Email whenever New Announcement Posts.</h5>
			</div> 
			<div class="modal-footer"> 
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>
<script type="text/javascript" src="js/jquery-3.5.1.min.js"></script>
<script type="text/javascript" src="js/popper.min.js"></script>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script async src="js/twitterWidget.js" charset="utf-8"></script>
<script type="text/javascript" src="user.js"></script>
<?php
} else {
	?>
	<?php
if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
         $url = "https://";   
   } else  {
         $url = "http://";  
	} 
    // Append the host(domain name, ip) to the URL.   
    $url.= $_SERVER['HTTP_HOST'];   
    
    // Append the requested resource location to the URL   
    $url.= $_SERVER['REQUEST_URI'];
	$url = $url."index.php"; 
?>
	<meta http-equiv="refresh" content="0;url=<?php echo $url ; ?>" /> 
<?php
}
?>
</body>
</html>
