<?php
ob_start();
session_start();
include("../admin/db/config.php");
include("../admin/db/CSRF_Protect.php");
include("../admin/db/function_xss.php");
include("countAnnouncementFunction.php") ; 
$csrf = new CSRF_Protect();
// Checking User is logged in or not
if($_SESSION['user'] == '' ){
	header('location: index.php');
	exit;
}
$id = _e($_SESSION['user']['uid']) ; 
$admin = $pdo->prepare("SELECT * FROM user_saas WHERE uid = ? and u_blocked = '0'");
$admin->execute(array($id));   
$admin_result = $admin->fetchAll(PDO::FETCH_ASSOC);
$total = $admin->rowCount();
foreach($admin_result as $adm) {
//escape all  data
	$id = _e($adm['uid']);
	$email   = _e($adm['u_email']);
	$username = _e($adm['u_username']) ;
	$old_password = _e($adm['u_pass']);
	$rec_email = _e($adm['u_rec_email']);
	$email_subscriber = _e($adm['u_email_subscriber']);
	$email_comment = _e($adm['u_email_comment']);
	$rec_email_comment = _e($adm['u_rec_email_comment']);
	$announcement_left = _e($adm['announcement_left']);
	$startLim = _e($adm['start_lim']);
	$endLim = _e($adm['load_lim']);
	$logoUrl = _e($adm['logo_url']);
	$altUrl = _e($adm['logo_alt']);
	$userStatus = _e($adm['u_status']);
	$u_chance = _e($adm['u_chance']) ;
	$purchase_announcements = _e($adm['purchase_announcements']) ;
}

if($total == '0'){
	header('location: logout.php');
	exit;
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>User Panel</title>

	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<link rel="stylesheet" href="css/main.css">
	<link rel="stylesheet" href="css/bootstrap-select.min.css">
	<link rel="stylesheet" href="css/all.min.css">
	<link rel="stylesheet" href="css/datepicker.css">
	<link rel="stylesheet" href="css/Latofont.css">
	<link rel="stylesheet" href="css/Niconnefont.css">
</head>
<body class="app sidebar-mini">
    <!-- Navbar-->
    <header class="app-header"><a class="app-header__logo" href="dashboard.php"><img src="images/siteLogo.png" class="img-fluid" alt="Logo"></a>
      <!-- Sidebar toggle button--><a class="app-sidebar__toggle" href="#" data-toggle="sidebar" aria-label="Hide Sidebar"><i class="fa fa-bars fa-2x"></i></a>
      <!-- Navbar Right Menu-->
      <ul class="app-nav">
        <!-- User Menu-->
        <li class="dropdown"><a class="app-nav__item" href="#" data-toggle="dropdown" aria-label="Open Profile Menu"><i class="fa fa-user fa-lg"></i></a>
          <ul class="dropdown-menu settings-menu dropdown-menu-right">
		  	<li><a class="dropdown-item"  href="change_email.php"><i class="fa fa-envelope"></i> Email</a></li>
            <li><a class="dropdown-item"  href="change_password.php"><i class="fa fa-key"></i> Password</a></li>
            <li><a class="dropdown-item" href="logout.php"><i class="fa fa-sign-out-alt fa-lg"></i> Logout</a></li>
          </ul>
        </li>
      </ul>
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
      <div class="app-sidebar__user"><i class="fa fa-user fa-2x text-warning"></i>
        <div>
          <p class="app-sidebar__user-name"><small><?php echo $email ;?></small></p>
          <p class="app-sidebar__user-designation"><small><?php echo $username ; ?></small></p>
        </div>
      </div>
      <ul class="app-menu">
        <li><a class="app-menu__item" href="dashboard.php"><i class="app-menu__icon fa fa-laptop"></i><span class="app-menu__label">Dashboard</span></a></li>
		<li><a class="app-menu__item" href="<?php echo $username ; ?>" target="_blank"><i class="app-menu__icon fa fa-bookmark text-warning"></i><span class="app-menu__label text-warning"><b>Your Page</b></span></a></li>
		<li><a class="app-menu__item" href="buyAnnouncement.php"><i class="app-menu__icon fa fa-shopping-cart"></i><span class="app-menu__label">Buy Announcements</span></a></li>
		<li><a class="app-menu__item" href="payHistory.php"><i class="app-menu__icon fa fa-history"></i><span class="app-menu__label">Payment History</span></a></li>
		<li><a class="app-menu__item" href="iframeLogo.php"><i class="app-menu__icon fa fa-file-image"></i><span class="app-menu__label">Iframe Logo</span></a></li>
		<li><a class="app-menu__item" href="iframePreview.php"><i class="app-menu__icon fa fa-eye"></i><span class="app-menu__label">Iframe Preview</span></a></li>
		<li><a class="app-menu__item" href="emailSetting.php"><i class="app-menu__icon fa fa-cog"></i><span class="app-menu__label">Email Settings</span></a></li>
		 <li><a class="app-menu__item" href="setLimit.php"><i class="app-menu__icon fa fa-cubes"></i><span class="app-menu__label">Set Limits</span></a></li>
		<li><a href="addAnnouncement.php" class="app-menu__item"><i class="app-menu__icon fa fa-pencil-alt"></i><span class="app-menu__label"> Announcements</span></a></li>
		<li><a href="subscribers.php" class="app-menu__item"><i class="app-menu__icon fa fa-chart-bar"></i><span class="app-menu__label"> Subscribers</span></a></li>
		<li><a href="comments.php" class="app-menu__item"><i class="app-menu__icon fa fa-comment"></i><span class="app-menu__label"> Comments</span></a></li>
		<li><a href="approvecomments.php" class="app-menu__item"><i class="app-menu__icon fa fa-check"></i><span class="app-menu__label"> Approved Comments</span></a></li>
		<li><a href="unapprovecomments.php" class="app-menu__item"><i class="app-menu__icon fa fa-times"></i><span class="app-menu__label"> Unapproved Comments</span></a></li>
	  </ul>
    </aside>
    <main class="app-content">
	<?php
	if($userStatus == '0') {
	?>
	<div id="signupModal" class="modal fade " data-backdrop="static" data-keyboard="false">
    	<div class="modal-dialog">
    		<form method="post" class="signup_otpform">
    			<div class="modal-content">
    				<div class="modal-header">
						<div class="row">
						<div class="col-lg-12">
						<h4 class="modal-title"><i class='fa fa-eye'></i> Verify Sign Up OTP</h4>
						</div>
						<div class="col-lg-12">
						<small>You've <?php echo $u_chance ; ?> Chance to verify your account. After that You'll be Permanently Blocked.</small>
						</div>
						</div>
    				</div>
    				<div class="modal-body">
						<div class="row">
							<div class="col-lg-12 col-md-12">
								<div class="form-group">
									<label>Email*</label>
									<input type="text" name="email" id="email" class="form-control" readonly="readonly" required value="<?php echo $email ; ?>" />
								</div>
								<div class="form-group">
									<label>OTP*</label>
									<input type="password" name="otp" id="otp" class="form-control" required />
								</div>
							</div>
							<div class="col-lg-12 text-center">
							<div class="remove-messages"></div>
							</div>
						</div>						
					</div>
					
					
    				<div class="modal-footer">
						<input type="hidden" name="verify_otp" value="Submit" />
    					<input type="submit" name="action_sign" id="action_sign" class="btn btn-info" value="Verify OTP"  />
    				</form>
					<form method="post" class="resend_otpform">
						<input type="hidden" name="resend_email" value="Submit" />
						<input type="hidden" name="resendEmail" id="resendemail" value="<?php echo $email ; ?>" >
						<input type="submit" name="action_resend" id="action_resend" class="btn btn-success" value="Resend OTP"  />
					</form>
    				</div>
    			</div>
    		
    	</div>
    </div>
	<?php 
	}
	?>