<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta property="og:title" content="ItsLink - 404 Error Page">
    <meta name="description" content="404 Error Page">
    <meta property="og:description" content="404 Error Page">
    <meta property="og:url" content="">
    <meta name="twitter:card" content="summary_large_image">
    <title>ItsLink - 404 Error Page</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/app.css" rel="stylesheet">
    <link rel="shortcut icon" href="assets/img/favicon.svg">
    <style>
	  html {
		display : none;
	  }
    </style>
  </head>
  <body>
  
  <section class="vh-100 py-20 d-flex align-items-center">
  <div class="container-fluid cw-85">
    <div class="row g-5 d-flex align-items-center">
      <div class="col-xl-5 col-xxl-5 col-lg-6 col-md-6 col-sm-12">
        <p class="lh-base mt-35 mb-35 text-muted fs-24">404 · Page not found</p>
       <h1 class="fw-bold lh-sm fs-32 mb-30">The page you are looking for, does not exist.</h1>
        <a class="fs-18 lh-lg btn rounded-pill fw-bold btn-primary" href="index.php">Return to Homepage</a>
      </div>
      <div class="mx-auto ok-column col-xl-7 col-xxl-7 col-lg-6 col-md-6 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center">
        <img src="assets/img/404-error.svg" class="w-100" alt="ItsLink 404 error page">
      </div>
    </div>
  </div>
</section>
<script>
  if (self == top) {
    // Everything checks out, show the page.
    document.documentElement.style.display = 'block';
  } else {
    // Break out of the frame.
    top.location = self.location;
  }
</script>
  </body>
</html>