/*
The MIT License (MIT)

Copyright (c) 2015 jayedul

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
$.fn.minify=function()
{
	val=$(this).val();
	
	return val.replace(/\t/ig, "").replace(/\n/ig, "").replace(/\s\s+/ig, "");
}

$.prettify_code=function(el)
{
	function prettify(el)
	{
		if(el.parent().length>0 && el.parent().data('assign'))
		{
			el.data('assign', el.parent().data('assign')+1);
		}
		else
		{
			el.data('assign', 1);
		}
		
		if(el.children().length>0)
		{
			el.children().each
			(
				function()
				{
					tbc='';
					
					for(i=0; i<$(this).parent().data('assign'); i++)
					{
						tbc+='\t';
					}
					$(this).before('\n'+tbc);
					$(this).prepend('\t');
					$(this).append('\n'+tbc);
					prettify($(this));
					
				}
			);
		}
		else
		{
			tbc='';
					
			for(i=0; i<el.parent().data('assign'); i++)
			{
				tbc+='\t';
			}
			el.prepend('\n'+tbc);
		}
	}
	prettify(el);
}

$.fn.show_code=function(gethtmlcode)
{
	$(this).val((gethtmlcode));
}

$.replace_tag=function(val)
{
	val=val.replace(/<html/i, '<div id="replace_html"');
	val=val.replace(/<\/html>/i, '</div>*-html-*');
	
	val=val.replace(/<head/i, '<div id="replace_head"');
	val=val.replace(/<\/head>/i, '</div>*-head-*');
	
	val=val.replace(/<body/i, '<div id="replace_body"');
	val=val.replace(/<\/body>/i, '</div>*-body-*');
	
	//val=val.replace(/<header/i, '<div id="replace_header"');
	//val=val.replace(/<\/header>/i, '</div>*-header-*');
	return val;
}

$.undo_tag=function(val)
{
	val=val.replace('<div id="replace_html"', '<html');
	val=val.replace('</div>*-html-*', '</html>');
	
	val=val.replace('<div id="replace_head"', '<head');
	val=val.replace('</div>*-head-*', '</head>');
	
	val=val.replace('<div id="replace_body"', '<body');
	val=val.replace('</div>*-body-*', '</body>');
	
	//val=val.replace('<div id="replace_header"', '<header');
	//val=val.replace('</div>*-header-*', '</header>');
	return val;
}
/* uses
$(document).ready
(
	function()
	{
		gethtmlcode=$("textarea").eq(0);
		
		$("button").eq(0).click
		(
			function()
			{
				gethtmlcode.css('white-space', 'normal').show_code(gethtmlcode.minify());
			}
		);
		
		$("button").eq(1).click
		(
			function()
			{
				val=$.replace_tag(gethtmlcode.minify());
				el=$("<div></div>").html(val);
				$.prettify_code(el);
				gethtmlcode.css('white-space', 'pre').show_code($.undo_tag(el.html()));
			}
		);
	}
);
*/