/*!
 * iblize v2.0.3
 * Simple Javascript Code Editor Library
 * https://mcanam.github.io/iblize
 * MIT license by mcanam
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).Iblize=t()}(this,(function(){"use strict";function e(t){return e="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},e(t)}function t(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function n(e,t){for(var n=0;n<t.length;n++){var a=t[n];a.enumerable=a.enumerable||!1,a.configurable=!0,"value"in a&&(a.writable=!0),Object.defineProperty(e,a.key,a)}}function a(e,t,a){return t&&n(e.prototype,t),a&&n(e,a),e}function r(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null==n)return;var a,r,i=[],s=!0,l=!1;try{for(n=n.call(e);!(s=(a=n.next()).done)&&(i.push(a.value),!t||i.length!==t);s=!0);}catch(e){l=!0,r=e}finally{try{s||null==n.return||n.return()}finally{if(l)throw r}}return i}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return i(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return i(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function i(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,a=new Array(t);n<t;n++)a[n]=e[n];return a}var s="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{},l={exports:{}};!function(e){var t=function(e){var t=/\blang(?:uage)?-([\w-]+)\b/i,n=0,a={},r={manual:e.Prism&&e.Prism.manual,disableWorkerMessageHandler:e.Prism&&e.Prism.disableWorkerMessageHandler,util:{encode:function e(t){return t instanceof i?new i(t.type,e(t.content),t.alias):Array.isArray(t)?t.map(e):t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/\u00a0/g," ")},type:function(e){return Object.prototype.toString.call(e).slice(8,-1)},objId:function(e){return e.__id||Object.defineProperty(e,"__id",{value:++n}),e.__id},clone:function e(t,n){var a,i;switch(n=n||{},r.util.type(t)){case"Object":if(i=r.util.objId(t),n[i])return n[i];for(var s in a={},n[i]=a,t)t.hasOwnProperty(s)&&(a[s]=e(t[s],n));return a;case"Array":return i=r.util.objId(t),n[i]?n[i]:(a=[],n[i]=a,t.forEach((function(t,r){a[r]=e(t,n)})),a);default:return t}},getLanguage:function(e){for(;e&&!t.test(e.className);)e=e.parentElement;return e?(e.className.match(t)||[,"none"])[1].toLowerCase():"none"},currentScript:function(){if("undefined"==typeof document)return null;if("currentScript"in document)return document.currentScript;try{throw new Error}catch(a){var e=(/at [^(\r\n]*\((.*):[^:]+:[^:]+\)$/i.exec(a.stack)||[])[1];if(e){var t=document.getElementsByTagName("script");for(var n in t)if(t[n].src==e)return t[n]}return null}},isActive:function(e,t,n){for(var a="no-"+t;e;){var r=e.classList;if(r.contains(t))return!0;if(r.contains(a))return!1;e=e.parentElement}return!!n}},languages:{plain:a,plaintext:a,text:a,txt:a,extend:function(e,t){var n=r.util.clone(r.languages[e]);for(var a in t)n[a]=t[a];return n},insertBefore:function(e,t,n,a){var i=(a=a||r.languages)[e],s={};for(var l in i)if(i.hasOwnProperty(l)){if(l==t)for(var o in n)n.hasOwnProperty(o)&&(s[o]=n[o]);n.hasOwnProperty(l)||(s[l]=i[l])}var u=a[e];return a[e]=s,r.languages.DFS(r.languages,(function(t,n){n===u&&t!=e&&(this[t]=s)})),s},DFS:function e(t,n,a,i){i=i||{};var s=r.util.objId;for(var l in t)if(t.hasOwnProperty(l)){n.call(t,l,t[l],a||l);var o=t[l],u=r.util.type(o);"Object"!==u||i[s(o)]?"Array"!==u||i[s(o)]||(i[s(o)]=!0,e(o,n,l,i)):(i[s(o)]=!0,e(o,n,null,i))}}},plugins:{},highlightAll:function(e,t){r.highlightAllUnder(document,e,t)},highlightAllUnder:function(e,t,n){var a={callback:n,container:e,selector:'code[class*="language-"], [class*="language-"] code, code[class*="lang-"], [class*="lang-"] code'};r.hooks.run("before-highlightall",a),a.elements=Array.prototype.slice.apply(a.container.querySelectorAll(a.selector)),r.hooks.run("before-all-elements-highlight",a);for(var i,s=0;i=a.elements[s++];)r.highlightElement(i,!0===t,a.callback)},highlightElement:function(n,a,i){var s=r.util.getLanguage(n),l=r.languages[s];n.className=n.className.replace(t,"").replace(/\s+/g," ")+" language-"+s;var o=n.parentElement;o&&"pre"===o.nodeName.toLowerCase()&&(o.className=o.className.replace(t,"").replace(/\s+/g," ")+" language-"+s);var u={element:n,language:s,grammar:l,code:n.textContent};function c(e){u.highlightedCode=e,r.hooks.run("before-insert",u),u.element.innerHTML=u.highlightedCode,r.hooks.run("after-highlight",u),r.hooks.run("complete",u),i&&i.call(u.element)}if(r.hooks.run("before-sanity-check",u),(o=u.element.parentElement)&&"pre"===o.nodeName.toLowerCase()&&!o.hasAttribute("tabindex")&&o.setAttribute("tabindex","0"),!u.code)return r.hooks.run("complete",u),void(i&&i.call(u.element));if(r.hooks.run("before-highlight",u),u.grammar)if(a&&e.Worker){var p=new Worker(r.filename);p.onmessage=function(e){c(e.data)},p.postMessage(JSON.stringify({language:u.language,code:u.code,immediateClose:!0}))}else c(r.highlight(u.code,u.grammar,u.language));else c(r.util.encode(u.code))},highlight:function(e,t,n){var a={code:e,grammar:t,language:n};return r.hooks.run("before-tokenize",a),a.tokens=r.tokenize(a.code,a.grammar),r.hooks.run("after-tokenize",a),i.stringify(r.util.encode(a.tokens),a.language)},tokenize:function(e,t){var n=t.rest;if(n){for(var a in n)t[a]=n[a];delete t.rest}var r=new o;return u(r,r.head,e),l(e,r,t,r.head,0),function(e){var t=[],n=e.head.next;for(;n!==e.tail;)t.push(n.value),n=n.next;return t}(r)},hooks:{all:{},add:function(e,t){var n=r.hooks.all;n[e]=n[e]||[],n[e].push(t)},run:function(e,t){var n=r.hooks.all[e];if(n&&n.length)for(var a,i=0;a=n[i++];)a(t)}},Token:i};function i(e,t,n,a){this.type=e,this.content=t,this.alias=n,this.length=0|(a||"").length}function s(e,t,n,a){e.lastIndex=t;var r=e.exec(n);if(r&&a&&r[1]){var i=r[1].length;r.index+=i,r[0]=r[0].slice(i)}return r}function l(e,t,n,a,o,p){for(var h in n)if(n.hasOwnProperty(h)&&n[h]){var d=n[h];d=Array.isArray(d)?d:[d];for(var g=0;g<d.length;++g){if(p&&p.cause==h+","+g)return;var f=d[g],m=f.inside,v=!!f.lookbehind,b=!!f.greedy,y=f.alias;if(b&&!f.pattern.global){var k=f.pattern.toString().match(/[imsuy]*$/)[0];f.pattern=RegExp(f.pattern.source,k+"g")}for(var x=f.pattern||f,w=a.next,A=o;w!==t.tail&&!(p&&A>=p.reach);A+=w.value.length,w=w.next){var F=w.value;if(t.length>e.length)return;if(!(F instanceof i)){var j,S=1;if(b){if(!(j=s(x,A,e,v)))break;var E=j.index,T=j.index+j[0].length,C=A;for(C+=w.value.length;E>=C;)C+=(w=w.next).value.length;if(A=C-=w.value.length,w.value instanceof i)continue;for(var z=w;z!==t.tail&&(C<T||"string"==typeof z.value);z=z.next)S++,C+=z.value.length;S--,F=e.slice(A,C),j.index-=A}else if(!(j=s(x,0,F,v)))continue;E=j.index;var L=j[0],$=F.slice(0,E),_=F.slice(E+L.length),O=A+F.length;p&&O>p.reach&&(p.reach=O);var N=w.prev;if($&&(N=u(t,N,$),A+=$.length),c(t,N,S),w=u(t,N,new i(h,m?r.tokenize(L,m):L,y,L)),_&&u(t,w,_),S>1){var P={cause:h+","+g,reach:O};l(e,t,n,w.prev,A,P),p&&P.reach>p.reach&&(p.reach=P.reach)}}}}}}function o(){var e={value:null,prev:null,next:null},t={value:null,prev:e,next:null};e.next=t,this.head=e,this.tail=t,this.length=0}function u(e,t,n){var a=t.next,r={value:n,prev:t,next:a};return t.next=r,a.prev=r,e.length++,r}function c(e,t,n){for(var a=t.next,r=0;r<n&&a!==e.tail;r++)a=a.next;t.next=a,a.prev=t,e.length-=r}if(e.Prism=r,i.stringify=function e(t,n){if("string"==typeof t)return t;if(Array.isArray(t)){var a="";return t.forEach((function(t){a+=e(t,n)})),a}var i={type:t.type,content:e(t.content,n),tag:"span",classes:["token",t.type],attributes:{},language:n},s=t.alias;s&&(Array.isArray(s)?Array.prototype.push.apply(i.classes,s):i.classes.push(s)),r.hooks.run("wrap",i);var l="";for(var o in i.attributes)l+=" "+o+'="'+(i.attributes[o]||"").replace(/"/g,"&quot;")+'"';return"<"+i.tag+' class="'+i.classes.join(" ")+'"'+l+">"+i.content+"</"+i.tag+">"},!e.document)return e.addEventListener?(r.disableWorkerMessageHandler||e.addEventListener("message",(function(t){var n=JSON.parse(t.data),a=n.language,i=n.code,s=n.immediateClose;e.postMessage(r.highlight(i,r.languages[a],a)),s&&e.close()}),!1),r):r;var p=r.util.currentScript();function h(){r.manual||r.highlightAll()}if(p&&(r.filename=p.src,p.hasAttribute("data-manual")&&(r.manual=!0)),!r.manual){var d=document.readyState;"loading"===d||"interactive"===d&&p&&p.defer?document.addEventListener("DOMContentLoaded",h):window.requestAnimationFrame?window.requestAnimationFrame(h):window.setTimeout(h,16)}return r}("undefined"!=typeof window?window:"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?self:{});
/**
   * Prism: Lightweight, robust, elegant syntax highlighting
   *
   * @license MIT <https://opensource.org/licenses/MIT>
   * @author Lea Verou <https://lea.verou.me>
   * @namespace
   * @public
   */e.exports&&(e.exports=t),void 0!==s&&(s.Prism=t),t.languages.markup={comment:{pattern:/<!--(?:(?!<!--)[\s\S])*?-->/,greedy:!0},prolog:{pattern:/<\?[\s\S]+?\?>/,greedy:!0},doctype:{pattern:/<!DOCTYPE(?:[^>"'[\]]|"[^"]*"|'[^']*')+(?:\[(?:[^<"'\]]|"[^"]*"|'[^']*'|<(?!!--)|<!--(?:[^-]|-(?!->))*-->)*\]\s*)?>/i,greedy:!0,inside:{"internal-subset":{pattern:/(^[^\[]*\[)[\s\S]+(?=\]>$)/,lookbehind:!0,greedy:!0,inside:null},string:{pattern:/"[^"]*"|'[^']*'/,greedy:!0},punctuation:/^<!|>$|[[\]]/,"doctype-tag":/^DOCTYPE/i,name:/[^\s<>'"]+/}},cdata:{pattern:/<!\[CDATA\[[\s\S]*?\]\]>/i,greedy:!0},tag:{pattern:/<\/?(?!\d)[^\s>\/=$<%]+(?:\s(?:\s*[^\s>\/=]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+(?=[\s>]))|(?=[\s/>])))+)?\s*\/?>/,greedy:!0,inside:{tag:{pattern:/^<\/?[^\s>\/]+/,inside:{punctuation:/^<\/?/,namespace:/^[^\s>\/:]+:/}},"special-attr":[],"attr-value":{pattern:/=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+)/,inside:{punctuation:[{pattern:/^=/,alias:"attr-equals"},/"|'/]}},punctuation:/\/?>/,"attr-name":{pattern:/[^\s>\/]+/,inside:{namespace:/^[^\s>\/:]+:/}}}},entity:[{pattern:/&[\da-z]{1,8};/i,alias:"named-entity"},/&#x?[\da-f]{1,8};/i]},t.languages.markup.tag.inside["attr-value"].inside.entity=t.languages.markup.entity,t.languages.markup.doctype.inside["internal-subset"].inside=t.languages.markup,t.hooks.add("wrap",(function(e){"entity"===e.type&&(e.attributes.title=e.content.replace(/&amp;/,"&"))})),Object.defineProperty(t.languages.markup.tag,"addInlined",{value:function(e,n){var a={};a["language-"+n]={pattern:/(^<!\[CDATA\[)[\s\S]+?(?=\]\]>$)/i,lookbehind:!0,inside:t.languages[n]},a.cdata=/^<!\[CDATA\[|\]\]>$/i;var r={"included-cdata":{pattern:/<!\[CDATA\[[\s\S]*?\]\]>/i,inside:a}};r["language-"+n]={pattern:/[\s\S]+/,inside:t.languages[n]};var i={};i[e]={pattern:RegExp(/(<__[^>]*>)(?:<!\[CDATA\[(?:[^\]]|\](?!\]>))*\]\]>|(?!<!\[CDATA\[)[\s\S])*?(?=<\/__>)/.source.replace(/__/g,(function(){return e})),"i"),lookbehind:!0,greedy:!0,inside:r},t.languages.insertBefore("markup","cdata",i)}}),Object.defineProperty(t.languages.markup.tag,"addAttribute",{value:function(e,n){t.languages.markup.tag.inside["special-attr"].push({pattern:RegExp(/(^|["'\s])/.source+"(?:"+e+")"+/\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+(?=[\s>]))/.source,"i"),lookbehind:!0,inside:{"attr-name":/^[^\s=]+/,"attr-value":{pattern:/=[\s\S]+/,inside:{value:{pattern:/(^=\s*(["']|(?!["'])))\S[\s\S]*(?=\2$)/,lookbehind:!0,alias:[n,"language-"+n],inside:t.languages[n]},punctuation:[{pattern:/^=/,alias:"attr-equals"},/"|'/]}}}})}}),t.languages.html=t.languages.markup,t.languages.mathml=t.languages.markup,t.languages.svg=t.languages.markup,t.languages.xml=t.languages.extend("markup",{}),t.languages.ssml=t.languages.xml,t.languages.atom=t.languages.xml,t.languages.rss=t.languages.xml,function(e){var t=/(?:"(?:\\(?:\r\n|[\s\S])|[^"\\\r\n])*"|'(?:\\(?:\r\n|[\s\S])|[^'\\\r\n])*')/;e.languages.css={comment:/\/\*[\s\S]*?\*\//,atrule:{pattern:/@[\w-](?:[^;{\s]|\s+(?![\s{]))*(?:;|(?=\s*\{))/,inside:{rule:/^@[\w-]+/,"selector-function-argument":{pattern:/(\bselector\s*\(\s*(?![\s)]))(?:[^()\s]|\s+(?![\s)])|\((?:[^()]|\([^()]*\))*\))+(?=\s*\))/,lookbehind:!0,alias:"selector"},keyword:{pattern:/(^|[^\w-])(?:and|not|only|or)(?![\w-])/,lookbehind:!0}}},url:{pattern:RegExp("\\burl\\((?:"+t.source+"|"+/(?:[^\\\r\n()"']|\\[\s\S])*/.source+")\\)","i"),greedy:!0,inside:{function:/^url/i,punctuation:/^\(|\)$/,string:{pattern:RegExp("^"+t.source+"$"),alias:"url"}}},selector:{pattern:RegExp("(^|[{}\\s])[^{}\\s](?:[^{};\"'\\s]|\\s+(?![\\s{])|"+t.source+")*(?=\\s*\\{)"),lookbehind:!0},string:{pattern:t,greedy:!0},property:{pattern:/(^|[^-\w\xA0-\uFFFF])(?!\s)[-_a-z\xA0-\uFFFF](?:(?!\s)[-\w\xA0-\uFFFF])*(?=\s*:)/i,lookbehind:!0},important:/!important\b/i,function:{pattern:/(^|[^-a-z0-9])[-a-z0-9]+(?=\()/i,lookbehind:!0},punctuation:/[(){};:,]/},e.languages.css.atrule.inside.rest=e.languages.css;var n=e.languages.markup;n&&(n.tag.addInlined("style","css"),n.tag.addAttribute("style","css"))}(t),t.languages.clike={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:!0,greedy:!0},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:!0,greedy:!0}],string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:!0},"class-name":{pattern:/(\b(?:class|interface|extends|implements|trait|instanceof|new)\s+|\bcatch\s+\()[\w.\\]+/i,lookbehind:!0,inside:{punctuation:/[.\\]/}},keyword:/\b(?:if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/,boolean:/\b(?:true|false)\b/,function:/\b\w+(?=\()/,number:/\b0x[\da-f]+\b|(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:e[+-]?\d+)?/i,operator:/[<>]=?|[!=]=?=?|--?|\+\+?|&&?|\|\|?|[?*/~^%]/,punctuation:/[{}[\];(),.:]/},t.languages.javascript=t.languages.extend("clike",{"class-name":[t.languages.clike["class-name"],{pattern:/(^|[^$\w\xA0-\uFFFF])(?!\s)[_$A-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\.(?:prototype|constructor))/,lookbehind:!0}],keyword:[{pattern:/((?:^|\})\s*)catch\b/,lookbehind:!0},{pattern:/(^|[^.]|\.\.\.\s*)\b(?:as|assert(?=\s*\{)|async(?=\s*(?:function\b|\(|[$\w\xA0-\uFFFF]|$))|await|break|case|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally(?=\s*(?:\{|$))|for|from(?=\s*(?:['"]|$))|function|(?:get|set)(?=\s*(?:[#\[$\w\xA0-\uFFFF]|$))|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)\b/,lookbehind:!0}],function:/#?(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\s*(?:\.\s*(?:apply|bind|call)\s*)?\()/,number:/\b(?:(?:0[xX](?:[\dA-Fa-f](?:_[\dA-Fa-f])?)+|0[bB](?:[01](?:_[01])?)+|0[oO](?:[0-7](?:_[0-7])?)+)n?|(?:\d(?:_\d)?)+n|NaN|Infinity)\b|(?:\b(?:\d(?:_\d)?)+\.?(?:\d(?:_\d)?)*|\B\.(?:\d(?:_\d)?)+)(?:[Ee][+-]?(?:\d(?:_\d)?)+)?/,operator:/--|\+\+|\*\*=?|=>|&&=?|\|\|=?|[!=]==|<<=?|>>>?=?|[-+*/%&|^!=<>]=?|\.{3}|\?\?=?|\?\.?|[~:]/}),t.languages.javascript["class-name"][0].pattern=/(\b(?:class|interface|extends|implements|instanceof|new)\s+)[\w.\\]+/,t.languages.insertBefore("javascript","keyword",{regex:{pattern:/((?:^|[^$\w\xA0-\uFFFF."'\])\s]|\b(?:return|yield))\s*)\/(?:\[(?:[^\]\\\r\n]|\\.)*\]|\\.|[^/\\\[\r\n])+\/[dgimyus]{0,7}(?=(?:\s|\/\*(?:[^*]|\*(?!\/))*\*\/)*(?:$|[\r\n,.;:})\]]|\/\/))/,lookbehind:!0,greedy:!0,inside:{"regex-source":{pattern:/^(\/)[\s\S]+(?=\/[a-z]*$)/,lookbehind:!0,alias:"language-regex",inside:t.languages.regex},"regex-delimiter":/^\/|\/$/,"regex-flags":/^[a-z]+$/}},"function-variable":{pattern:/#?(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\s*[=:]\s*(?:async\s*)?(?:\bfunction\b|(?:\((?:[^()]|\([^()]*\))*\)|(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*)\s*=>))/,alias:"function"},parameter:[{pattern:/(function(?:\s+(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*)?\s*\(\s*)(?!\s)(?:[^()\s]|\s+(?![\s)])|\([^()]*\))+(?=\s*\))/,lookbehind:!0,inside:t.languages.javascript},{pattern:/(^|[^$\w\xA0-\uFFFF])(?!\s)[_$a-z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\s*=>)/i,lookbehind:!0,inside:t.languages.javascript},{pattern:/(\(\s*)(?!\s)(?:[^()\s]|\s+(?![\s)])|\([^()]*\))+(?=\s*\)\s*=>)/,lookbehind:!0,inside:t.languages.javascript},{pattern:/((?:\b|\s|^)(?!(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)(?![$\w\xA0-\uFFFF]))(?:(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*\s*)\(\s*|\]\s*\(\s*)(?!\s)(?:[^()\s]|\s+(?![\s)])|\([^()]*\))+(?=\s*\)\s*\{)/,lookbehind:!0,inside:t.languages.javascript}],constant:/\b[A-Z](?:[A-Z_]|\dx?)*\b/}),t.languages.insertBefore("javascript","string",{hashbang:{pattern:/^#!.*/,greedy:!0,alias:"comment"},"template-string":{pattern:/`(?:\\[\s\S]|\$\{(?:[^{}]|\{(?:[^{}]|\{[^}]*\})*\})+\}|(?!\$\{)[^\\`])*`/,greedy:!0,inside:{"template-punctuation":{pattern:/^`|`$/,alias:"string"},interpolation:{pattern:/((?:^|[^\\])(?:\\{2})*)\$\{(?:[^{}]|\{(?:[^{}]|\{[^}]*\})*\})+\}/,lookbehind:!0,inside:{"interpolation-punctuation":{pattern:/^\$\{|\}$/,alias:"punctuation"},rest:t.languages.javascript}},string:/[\s\S]+/}}}),t.languages.markup&&(t.languages.markup.tag.addInlined("script","javascript"),t.languages.markup.tag.addAttribute(/on(?:abort|blur|change|click|composition(?:end|start|update)|dblclick|error|focus(?:in|out)?|key(?:down|up)|load|mouse(?:down|enter|leave|move|out|over|up)|reset|resize|scroll|select|slotchange|submit|unload|wheel)/.source,"javascript")),t.languages.js=t.languages.javascript,function(){if(void 0!==t&&"undefined"!=typeof document){Element.prototype.matches||(Element.prototype.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector);var e={js:"javascript",py:"python",rb:"ruby",ps1:"powershell",psm1:"powershell",sh:"bash",bat:"batch",h:"c",tex:"latex"},n="data-src-status",a="loading",r="loaded",i='pre[data-src]:not([data-src-status="loaded"]):not([data-src-status="loading"])',s=/\blang(?:uage)?-([\w-]+)\b/i;t.hooks.add("before-highlightall",(function(e){e.selector+=", "+i})),t.hooks.add("before-sanity-check",(function(s){var l=s.element;if(l.matches(i)){s.code="",l.setAttribute(n,a);var u=l.appendChild(document.createElement("CODE"));u.textContent="Loading…";var c=l.getAttribute("data-src"),p=s.language;if("none"===p){var h=(/\.(\w+)$/.exec(c)||[,"none"])[1];p=e[h]||h}o(u,p),o(l,p);var d=t.plugins.autoloader;d&&d.loadLanguages(p);var g=new XMLHttpRequest;g.open("GET",c,!0),g.onreadystatechange=function(){var e,a;4==g.readyState&&(g.status<400&&g.responseText?(l.setAttribute(n,r),u.textContent=g.responseText,t.highlightElement(u)):(l.setAttribute(n,"failed"),g.status>=400?u.textContent=(e=g.status,a=g.statusText,"✖ Error "+e+" while fetching file: "+a):u.textContent="✖ Error: File does not exist or is empty"))},g.send(null)}})),t.plugins.fileHighlight={highlight:function(e){for(var n,a=(e||document).querySelectorAll(i),r=0;n=a[r++];)t.highlightElement(n)}};var l=!1;t.fileHighlight=function(){l||(console.warn("Prism.fileHighlight is deprecated. Use `Prism.plugins.fileHighlight.highlight` instead."),l=!0),t.plugins.fileHighlight.highlight.apply(this,arguments)}}function o(e,t){var n=e.className;n=n.replace(s," ")+" language-"+t,e.className=n.replace(/\s+/g," ").trim()}}()}(l);var o=l.exports,u={select:function(e){return document.querySelector(e)},selectAll:function(e){return document.querySelectorAll(e)},create:function(e,t){var n=this,a=document.createElement(e),i=Object.entries(t);return 0==i.length||i.forEach((function(e){var t=r(e,2),i=t[0],s=t[1];return"parent"==i?s.appendChild(a):"attr"==i?n.setAttr(a,s):"event"==i?n.addEvent(a,s):"style"==i?n.addStyle(a,s):void(a[i]=s)})),a},setAttr:function(e,t){return Object.entries(t).forEach((function(t){var n=r(t,2),a=n[0],i=n[1];e.setAttribute(a,i)})),this},addEvent:function(e,t){return(Array.isArray(t)?t:[t]).forEach((function(t){var n=t.name,a=t.callback;e.addEventListener(n,a,!1)})),this},addStyle:function(e,t){return Object.entries(t).forEach((function(t){var n=r(t,2),a=n[0],i=n[1];e.style[a]=i})),this}},c=function(){function e(n){t(this,e),this.editor=n,this.stack=[],this.level=0,this.record(0,"")}return a(e,[{key:"record",value:function(e,t){this.stack.length>1e3&&this.stack.shift();var n=JSON.stringify,a={cursor:e,value:t};n(this.stack.slice(-1)[0])!=n(a)&&this.stack.push(a),this.level=this.stack.length-1}},{key:"undo",value:function(){this.level>0&&(this.level-=1,this.restore())}},{key:"redo",value:function(){this.level<this.stack.length-1&&(this.level+=1,this.restore())}},{key:"restore",value:function(){var e=this.stack[this.level],t=e.cursor,n=e.value;this.editor.setValue(n,!1),this.editor.setCursor(t)}}]),e}(),p={javascript:"clike",actionscript:"javascript",apex:["clike","sql"],arduino:"cpp",aspnet:["markup","csharp"],birb:"clike",bison:"c",c:"clike",csharp:"clike",cpp:"c",cfscript:"clike",chaiscript:["clike","cpp"],coffeescript:"javascript",crystal:"ruby","css-extras":"css",d:"clike",dart:"clike",django:"markup-templating",ejs:["javascript","markup-templating"],etlua:["lua","markup-templating"],erb:["ruby","markup-templating"],fsharp:"clike","firestore-security-rules":"clike",flow:"javascript",ftl:"markup-templating",gml:"clike",glsl:"c",go:"clike",groovy:"clike",haml:"ruby",handlebars:"markup-templating",haxe:"clike",hlsl:"c",idris:"haskell",java:"clike",javadoc:["markup","java","javadoclike"],jolie:"clike",jsdoc:["javascript","javadoclike","typescript"],"js-extras":"javascript",json5:"json",jsonp:"json","js-templates":"javascript",kotlin:"clike",latte:["clike","markup-templating","php"],less:"css",lilypond:"scheme",liquid:"markup-templating",markdown:"markup","markup-templating":"markup",mongodb:"javascript",n4js:"javascript",objectivec:"c",opencl:"c",parser:"markup",php:"markup-templating",phpdoc:["php","javadoclike"],"php-extras":"php",plsql:"sql",processing:"clike",protobuf:"clike",pug:["markup","javascript"],purebasic:"clike",purescript:"haskell",qsharp:"clike",qml:"javascript",qore:"clike",racket:"scheme",jsx:["markup","javascript"],tsx:["jsx","typescript"],reason:"clike",ruby:"clike",sass:"css",scss:"css",scala:"java","shell-session":"bash",smarty:"markup-templating",solidity:"clike",soy:"markup-templating",sparql:"turtle",sqf:"clike",squirrel:"clike",swift:"clike","t4-cs":["t4-templating","csharp"],"t4-vb":["t4-templating","vbnet"],tap:"yaml",tt2:["clike","markup-templating"],textile:"markup",twig:"markup",typescript:"javascript",v:"clike",vala:"clike",vbnet:"basic",velocity:"markup",wiki:"markup",xeora:"markup","xml-doc":"markup",xquery:"markup"},h={html:"markup",xml:"markup",svg:"markup",mathml:"markup",ssml:"markup",atom:"markup",rss:"markup",js:"javascript",g4:"antlr4",adoc:"asciidoc",shell:"bash",shortcode:"bbcode",rbnf:"bnf",oscript:"bsl",cs:"csharp",dotnet:"csharp",cfc:"cfscript",coffee:"coffeescript",conc:"concurnas",jinja2:"django","dns-zone":"dns-zone-file",dockerfile:"docker",gv:"dot",eta:"ejs",xlsx:"excel-formula",xls:"excel-formula",gamemakerlanguage:"gml",hbs:"handlebars",hs:"haskell",idr:"idris",gitignore:"ignore",hgignore:"ignore",npmignore:"ignore",webmanifest:"json",kt:"kotlin",kts:"kotlin",kum:"kumir",tex:"latex",context:"latex",ly:"lilypond",emacs:"lisp",elisp:"lisp","emacs-lisp":"lisp",md:"markdown",moon:"moonscript",n4jsd:"n4js",nani:"naniscript",objc:"objectivec",qasm:"openqasm",objectpascal:"pascal",px:"pcaxis",pcode:"peoplecode",pq:"powerquery",mscript:"powerquery",pbfasm:"purebasic",purs:"purescript",py:"python",qs:"qsharp",rkt:"racket",rpy:"renpy",robot:"robotframework",rb:"ruby","sh-session":"shell-session",shellsession:"shell-session",smlnj:"sml",sol:"solidity",sln:"solution-file",rq:"sparql",t4:"t4-cs",trig:"turtle",ts:"typescript",tsconfig:"typoscript",uscript:"unrealscript",uc:"unrealscript",url:"uri",vb:"visual-basic",vba:"visual-basic",mathematica:"wolfram",nb:"wolfram",wl:"wolfram",xeoracube:"xeora",yml:"yaml"},d=function(){function e(){t(this,e),this.baseURL="https://unpkg.com/iblize/dist/",this.themes=[]}return a(e,[{key:"loadLanguage",value:function(e,t,n){var a=p;if(e in h&&(e=h[e]),e in Prism.languages)return n();function r(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:function(){},a=u.create("script",{parent:document.body,src:t+e+".js",onload:function(){a.remove(),n()}})}""==t&&(t=this.baseURL+"languages/"),e in a&&(Array.isArray(a[e])||(a[e]=[a[e]]),a[e].forEach((function(e){e in Prism.languages||r(e)}))),r(e,n)}},{key:"loadTheme",value:function(e,t){if(""==t&&(t=this.baseURL+"themes/"),this.themes.includes(e))return u.select('link[theme="'.concat(e,'"]')).href=t+e+".css";u.select("#iblize-base").after(u.create("link",{rel:"stylesheet",href:t+e+".css",attr:{theme:e}})),this.themes.push(e)}}]),e}(),g=[],f=[];!function(e,t){if(e&&"undefined"!=typeof document){var n,a=!0===t.prepend?"prepend":"append",r=!0===t.singleTag,i="string"==typeof t.container?document.querySelector(t.container):document.getElementsByTagName("head")[0];if(r){var s=g.indexOf(i);-1===s&&(s=g.push(i)-1,f[s]={}),n=f[s]&&f[s][a]?f[s][a]:f[s][a]=l()}else n=l();65279===e.charCodeAt(0)&&(e=e.substring(1)),n.styleSheet?n.styleSheet.cssText+=e:n.appendChild(document.createTextNode(e))}function l(){var e=document.createElement("style");if(e.setAttribute("type","text/css"),t.attributes)for(var n=Object.keys(t.attributes),r=0;r<n.length;r++)e.setAttribute(n[r],t.attributes[n[r]]);var s="prepend"===a?"afterbegin":"beforeend";return i.insertAdjacentElement(s,e),e}}(".iblize{font:14px/1.75 Consolas,Monaco,Andale Mono,Ubuntu Mono,monospace;color:#3d525c;width:100%;height:100%;display:flex;position:relative;overflow:hidden}.iblize,.iblize *{box-sizing:border-box}.iblize *{font:inherit}.iblize_linenumber{display:flex;flex-direction:column}.iblize_linenumber_child{text-align:right;width:100%}.iblize_content{flex-grow:1;height:100%;position:relative;overflow:hidden}.iblize_pre,.iblize_textarea{width:100%;height:100%;padding:0;margin:0}.iblize_textarea{color:transparent;caret-color:#3d525c;white-space:pre;border:none;outline:none;background-color:transparent;position:relative;z-index:2;resize:none}.iblize_pre{position:absolute;top:0;left:0;pointer-events:none}",{prepend:!0,attributes:{id:"iblize-base"}});var m=function(){function n(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t(this,n),this.version="2.0.3",this.history=new c(this),this.loader=new d,e instanceof HTMLElement?this.elementRoot=e:this.elementRoot=u.select(e),!this.elementRoot)throw Error("Iblize can't find the editor containers");this.options={language:"javascript",languagesPath:"",lineNumber:!0,readOnly:!1,tabSize:2,theme:"iblize-dark",themesPath:""},this.setupEditor(),this.setValue(null),this.loadTheme(),this.loadLanguage(),this.setOptions(a)}return a(n,[{key:"setupEditor",value:function(){this.createEditorElement(),this.attachTextareaEvent()}},{key:"createEditorElement",value:function(){this.elementWrapper=u.create("div",{parent:this.elementRoot,className:"iblize ".concat(this.options.theme)}),this.elementLinenumber=u.create("div",{parent:this.elementWrapper,className:"iblize_linenumber"}),this.elementContent=u.create("div",{parent:this.elementWrapper,className:"iblize_content"}),this.elementPre=u.create("pre",{parent:this.elementContent,className:"iblize_pre"}),this.elementCode=u.create("code",{parent:this.elementPre,className:"iblize_code"}),this.elementTextarea=u.create("textarea",{parent:this.elementContent,className:"iblize_textarea",attr:{spellcheck:"false",autocorrect:"off",autocomplete:"off",autocapitalize:"off"}})}},{key:"attachTextareaEvent",value:function(){u.addEvent(this.elementTextarea,[{name:"input",callback:this.handleInput.bind(this)},{name:"keydown",callback:this.handleKeydown.bind(this)},{name:"scroll",callback:this.handleScroll.bind(this)}])}},{key:"handleScroll",value:function(){var e=this.elementTextarea,t=e.scrollWidth,n=e.scrollHeight,a=e.scrollTop,r=e.scrollLeft;u.addStyle(this.elementLinenumber,{height:n+"px",transform:"translateY(".concat(-1*a,"px)")}),u.addStyle(this.elementPre,{width:t+"px",height:n+"px",transform:"translate(".concat(-1*r,"px, ").concat(-1*a,"px)")})}},{key:"handleInput",value:function(){var e=this;null!=this.typingTimeout&&clearTimeout(this.typingTimeout),this.typingTimeout=setTimeout((function(){e.recordHistory()}),150),null!=this.onUpdateCallback&&this.onUpdateCallback(this.getValue()),this.closeCharacter(),this.updateEditor()}},{key:"handleKeydown",value:function(e){"Tab"==e.key&&(e.preventDefault(),this.insertTab()),13!=e.keyCode&&"Enter"!=e.key||(e.preventDefault(),this.addLineIndent()),e.ctrlKey&&"z"==e.key&&(e.preventDefault(),this.undo()),e.ctrlKey&&e.shiftKey&&"Z"==e.key&&(e.preventDefault(),this.redo())}},{key:"updateEditor",value:function(){this.countLinenumber(),this.highlightSyntax()}},{key:"countLinenumber",value:function(){var e=this.getTotalLine();if(e!=this.elementLinenumber.childElementCount&&this.options.lineNumber){for(var t="",n=0;n<e;n++)t+='<span class="iblize_linenumber_child">'.concat(n+1,"</span>");this.elementLinenumber.innerHTML=t}}},{key:"highlightSyntax",value:function(){var e=this.getValue(),t=this.options.language,n=o.languages[t];null==n&&(n=o.languages.plaintext);var a=o.highlight(e,n,t);this.elementCode.innerHTML=a}},{key:"addLineIndent",value:function(){var e=this.getCursor(),t=this.getValue(),n=this.getActiveLine(),a=this.getLineValue(n).match(/^\s{1,}/),r=t.charAt(e-1),i=t.charAt(e),s=null==a?0:a[0].length;if("("==r&&")"==i||"{"==r&&"}"==i||"["==r&&"]"==i||">"==r&&"<"==i){var l=this.options.tabSize,o="\n"+" ".repeat(s+l)+"\n"+" ".repeat(s);this.insertText(e,o,{moveCursor:e+s+l+1,recordHistory:"both"})}else this.insertText(e,"\n"+" ".repeat(s),{moveCursor:e+s+1,recordHistory:"both"})}},{key:"closeCharacter",value:function(){var e=this,t=this.getCursor(),n=this.getValue(),a=n.charAt(t-1),r=n.charAt(t),i=[{open:"(",close:")"},{open:"{",close:"}"},{open:"[",close:"]"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'},{open:"`",close:"`"}];if(this.valueLengthReminder||(this.valueLengthReminder=0),n.length>this.valueLengthReminder)i.forEach((function(n){a!=n.close||r!=n.close?a==n.open&&e.insertText(t,n.close,{moveCursor:t}):e.removeText(t,t+1)}));else{var s=this.history.stack.slice(-1)[0].value.charAt(t);i.forEach((function(n){s==n.open&&r==n.close&&e.removeText(t,t+1)}))}this.valueLengthReminder=n.length}},{key:"valueFromComment",value:function(){var e=this.elementRoot,t=NodeFilter.SHOW_COMMENT,n=document.createNodeIterator(e,t).nextNode();return null!=n?n.nodeValue.replace(/\r?\n/,""):""}},{key:"recordHistory",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};null==e.cursor&&(e.cursor=this.getCursor()),null==e.value&&(e.value=this.getValue()),this.history.record(e.cursor,e.value)}},{key:"optionsValidator",value:function(t){var n=this;Object.entries(t).forEach((function(t){var a=r(t,2),i=a[0],s=a[1];if(!n.options.hasOwnProperty(i))throw Error("Invalid Iblize option! unknown option {".concat(i,"}"));var l=e(n.options[i]);if(e(s)!=l)throw Error("Invalid Iblize option! {".concat(i,"} value must be a ").concat(l))}))}},{key:"loadLanguage",value:function(){var e=this.options.language,t=this.options.languagesPath,n=this.highlightSyntax;this.loader.loadLanguage(e,t,n.bind(this))}},{key:"loadTheme",value:function(){var e=this.options.theme,t=this.options.themesPath;this.loader.loadTheme(e,t)}},{key:"onUpdate",value:function(e){if("function"!=typeof e)throw Error("Invalid `onUpdate()` callback parameter! callback must be a function.");this.onUpdateCallback=e}},{key:"getValue",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=this.elementTextarea.value;return null!=e&&null!=t?n.substring(e,t):null!=e&&null==t?n.substring(e):n}},{key:"setValue",value:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];this.elementTextarea.value=null!=e?e:this.valueFromComment(),this.updateEditor(),t&&this.recordHistory()}},{key:"getOptions",value:function(){return this.options}},{key:"setOptions",value:function(e){this.optionsValidator(e),Object.assign(this.options,e),null==e.theme&&null==e.themesPath||(this.elementWrapper.className="iblize ".concat(this.options.theme),this.loadTheme()),null==e.language&&null==e.languagesPath||this.loadLanguage(),null!=e.readOnly&&(this.elementTextarea.readOnly=this.options.readOnly),null!=e.lineNumber&&(this.elementLinenumber.style.display=this.options.lineNumber?"":"none",this.countLinenumber())}},{key:"getSelection",value:function(){var e=this.elementTextarea;return{start:e.selectionStart,end:e.selectionEnd,dir:e.selectionDirection}}},{key:"setSelection",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"none";this.elementTextarea.setSelectionRange(e,t,n)}},{key:"getCursor",value:function(){return this.getSelection().start}},{key:"setCursor",value:function(e){this.setSelection(e,e)}},{key:"getActiveLine",value:function(){var e=this.getCursor();return this.getValue(0,e).split("\n").length}},{key:"getTotalLine",value:function(){return this.getValue().split("\n").length}},{key:"getLineValue",value:function(e){return this.getValue().split("\n")[e-1]}},{key:"insertTab",value:function(){var e=this.getCursor(),t=this.options.tabSize;this.insertText(e," ".repeat(t),{recordHistory:"both"})}},{key:"insertText",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=this.getValue(0,e),r=this.getValue(e),i=n.recordHistory||"after",s=n.moveCursor||e+t.length;"before"!=i&&"both"!=i||this.recordHistory(),this.setValue(a+t+r,!1),this.setCursor(s),"after"!=i&&"both"!=i||this.recordHistory()}},{key:"removeText",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=this.getValue(0,e),r=this.getValue(t),i=n.recordHistory||"after",s=n.moveCursor||e;"before"!=i&&"both"!=i||this.recordHistory(),this.setValue(a+r,!1),this.setCursor(s),"after"!=i&&"both"!=i||this.recordHistory()}},{key:"undo",value:function(){this.history.undo()}},{key:"redo",value:function(){this.history.redo()}}]),n}();return m}));
//# sourceMappingURL=iblize.min.js.map
