(function($){ 
'use strict';

//For iFrame blocking
if (self == top) {
  // Everything checks out, show the page.
  document.documentElement.style.display = 'block';
} else {
  // Break out of the frame.
  top.location = self.location;
}

//START:: Show dialog on closing browser's window
window.onbeforeunload = () => {return '';};//END:: Closing dialog

//START:: Disable Clicks
let preventClick = false;
$(document).on('click', '#body-data a:not(.dropdown-toggle), #main-textinput-field a, #body-data iframe', function(e) {
    if (!preventClick) {
        $(this).html($(this).html());
    }
    preventClick = true;
    return false;
});//END:: Disable Clicks

//User ID
let pathoul = window.location.pathname;
let finalpt = pathoul.substring(0, pathoul.lastIndexOf("/"));
let domainName = window.location.origin+finalpt;
let filenamef = pathoul.replace(/^.*[\\\/]/, '');

//Unique user id
let uniqueUser = document.getElementById('unique-user').innerText;

//For current user check
if(document.getElementById('cid-user')){
let cUser = document.getElementById('cid-user').innerText;
	if (uniqueUser === cUser) {
	} else {
	$('body').html('<div style="width:100%;height:0;padding-bottom:75%;position:relative;"><iframe src="https://giphy.com/embed/l0OXWXUHdp4K9nitq" width="100%" height="100%" style="position:absolute" frameBorder="0" class="giphy-embed" allowFullScreen></iframe></div><p><a href="https://giphy.com/gifs/converse-l0OXWXUHdp4K9nitq">via GIPHY</a></p>');
	}
}

//console.log(domainName+filenamef);

//START:: Remove duplicate script src and link href css
function removejscssfile(filename, filetype){
    var targetelement=(filetype=="js")? "script" : (filetype=="css")? "link" : "none" //determine element type to create nodelist from
    var targetattr=(filetype=="js")? "src" : (filetype=="css")? "href" : "none" //determine corresponding attribute to test for
    var allsuspects=document.getElementsByTagName(targetelement)
    for (var i=allsuspects.length; i>=0; i--){ //search backwards within nodelist for matching elements to remove
    if (allsuspects[i] && allsuspects[i].getAttribute(targetattr)!=null && allsuspects[i].getAttribute(targetattr).indexOf(filename)!=-1)
        allsuspects[i].parentNode.removeChild(allsuspects[i]) //remove element by calling parentNode.removeChild()
    }
}
// removejscssfile("somescript.js", "js") //remove all occurences of "somescript.js" on page
// removejscssfile("somestyle.css", "css") //remove all occurences "somestyle.css" on page
//END:: Remove duplicate script src and link href css

$('#body-data').removeClass('scaledown-main-content').addClass('scaledown-main-content');
//START:: Add dynamic Block Elements
//Add Block option if empty
if ($('#ok-sortable-section').html().trim() == '') {
	$('#ok-sortable-section').html(`
		<div class="ok-section empty-section" dir="ltr"> 
			<div class="empty-section-wrap">
				<button class="add-section empty-button" title="Add Section">Blank Website <br> <span style="font-size: 32px;">Get Started by <strong>Dragging and Dropping</strong> New Elements or Blocks</span></button>
			</div>
		</div>
	`);
}

//START:: Dynamic Wrapper and Script
//For User Saved Library
if($('#user-section-library').length > 0){
} else {
	$('<div id="user-section-library"></div>').insertAfter('#body-data');
}
//For DataBase
if($('#ok-db').length > 0){
} else {
$(`<div id="ok-db" style="display: none!important">
<style id="font-a-db" data-fa-value="13">
body,.font-a {font-family: 'Lora', serif !important;} 
</style>
<style id="font-b-db" data-fb-value="12">
.font-b {font-family: 'Lato', sans-serif !important;}
</style>
<style id="db-clr-a">
  ::selection {background: #f44336; color: #ffffff;}
  ::-moz-selection {background: #f44336; color: #ffffff;}
  a {color: #f44336;}
  .active {color: #f44336 !important;}
  .sticky .active {color: #f44336 !important;}
  .color-a {color: #f44336;}
  .bg-a {background: #f44336;}
  .bg-a.open {background: #f44336;}
  .bdr-a {border-color: #f44336 !important;}
  .hov-bdr-a:hover {border-color: #f44336 !important;}
  .hov-color-a:hover {color: #f44336;}
  .hov-bg-a:hover {background: #f44336;}
  .ds-a {filter: drop-shadow(0px 0px 5px #f44336);}
  .hov-ds-a:hover {filter: drop-shadow(0px 0px 5px #f44336);}
</style>
<style id="db-clr-b">
  .color-b {color: #2196f3;}
  .bg-b {background: #2196f3;}
  .bg-b.open {background: #2196f3;}
  .bdr-b {border-color: #2196f3 !important;}
  .hov-bdr-b:hover {border-color: #2196f3 !important;}
  .hov-color-b:hover {color: #2196f3;}
  .hov-bg-b:hover {background: #2196f3;}
  .ds-b {filter: drop-shadow(0px 0px 5px #2196f3);}
  .hov-ds-b:hover {filter: drop-shadow(0px 0px 5px #2196f3);}
</style>
<style id="db-clr-c">
  .color-c {color: #4caf50;}
  .bg-c {background: #4caf50;}
  .bg-c.open {background: #4caf50;}
  .bdr-c {border-color: #4caf50 !important;}
  .hov-bdr-c:hover {border-color: #4caf50 !important;}
  .hov-color-c:hover {color: #4caf50;}
  .hov-bg-c:hover {background: #4caf50;}
  .ds-c {filter: drop-shadow(0px 0px 5px #4caf50);}
  .hov-ds-c:hover {filter: drop-shadow(0px 0px 5px #4caf50);}
</style>
<style id="db-clr-d">
  .color-d {color: #ffc107;}
  .bg-d {background: #ffc107;}
  .bg-d.open {background: #ffc107;}
  .bdr-d {border-color: #ffc107 !important;}
  .hov-bdr-d:hover {border-color: #ffc107 !important;}
  .hov-color-d:hover {color: #ffc107;}
  .hov-bg-d:hover {background: #ffc107;}
  .ds-d {filter: drop-shadow(0px 0px 5px #ffc107);}
  .hov-ds-d:hover {filter: drop-shadow(0px 0px 5px #ffc107);}
</style>
<style id="db-clr-e">
  .color-e {color: #212121;}
  .bg-e {background: #212121;}
  .bg-e.open {background: #212121;}
  .bdr-e {border-color: #212121 !important;}
  .hov-bdr-e:hover {border-color: #212121 !important;}
  .hov-color-e:hover {color: #212121;}
  .hov-bg-e:hover {background: #212121;}
  .ds-e {filter: drop-shadow(0px 0px 5px #212121);}
  .hov-ds-e:hover {filter: drop-shadow(0px 0px 5px #212121);}
</style>
<style id="db-clr-f">
  .color-f {color: #ffffff;}
  .bg-f {background: #ffffff;}
  .bg-f.open {background: #ffffff;}
  .bdr-f {border-color: #ffffff !important;}
  .hov-bdr-f:hover {border-color: #ffffff !important;}
  .hov-color-f:hover {color: #ffffff;}
  .hov-bg-f:hover {background: #ffffff;}
  .ds-f {filter: drop-shadow(0px 0px 5px #ffffff);}
  .hov-ds-f:hover {filter: drop-shadow(0px 0px 5px #ffffff);}
</style>
<style id="db-clr-g">
  .color-g {color: #ffcdd2;}
  .bg-g {background: #ffcdd2;}
  .bg-g.open {background: #ffcdd2;}
  .bdr-g {border-color: #ffcdd2 !important;}
  .hov-bdr-g:hover {border-color: #ffcdd2 !important;}
  .hov-color-g:hover {color: #ffcdd2;}
  .hov-bg-g:hover {background: #ffcdd2;}
  .ds-g {filter: drop-shadow(0px 0px 5px #ffcdd2);}
  .hov-ds-g:hover {filter: drop-shadow(0px 0px 5px #ffcdd2);}
</style>
<style id="db-clr-h">
  .color-h {color: #bbdefb;}
  .bg-h {background: #bbdefb;}
  .bg-h.open {background: #bbdefb;}
  .bdr-h {border-color: #bbdefb !important;}
  .hov-bdr-h:hover {border-color: #bbdefb !important;}
  .hov-color-h:hover {color: #bbdefb;}
  .hov-bg-h:hover {background: #bbdefb;}
  .ds-h {filter: drop-shadow(0px 0px 5px #bbdefb);}
  .hov-ds-h:hover {filter: drop-shadow(0px 0px 5px #bbdefb);}
</style>
<style id="db-clr-i">
  .color-i {color: #c8e6c9;}
  .bg-i {background: #c8e6c9;}
  .bg-i.open {background: #c8e6c9;}
  .bdr-i {border-color: #c8e6c9 !important;}
  .hov-bdr-i:hover {border-color: #c8e6c9 !important;}
  .hov-color-i:hover {color: #c8e6c9;}
  .hov-bg-i:hover {background: #c8e6c9;}
  .ds-i {filter: drop-shadow(0px 0px 5px #c8e6c9);}
  .hov-ds-i:hover {filter: drop-shadow(0px 0px 5px #c8e6c9);}
</style>
<style id="db-clr-j">
  .color-j {color: #eeeeee;}
  .bg-j {background: #eeeeee;}
  .bg-j.open {background: #eeeeee;}
  .bdr-j {border-color: #eeeeee !important;}
  .hov-bdr-j:hover {border-color: #eeeeee !important;}
  .hov-color-j:hover {color: #eeeeee;}
  .hov-bg-j:hover {background: #eeeeee;}
  .ds-j {filter: drop-shadow(0px 0px 5px #eeeeee);}
  .hov-ds-j:hover {filter: drop-shadow(0px 0px 5px #eeeeee);}
</style>
<style id="db-clr-k">
  .color-k {color: #616161;}
  .bg-k {background: #616161;}
  .bg-k.open {background: #616161;}
  .bdr-k {border-color: #616161 !important;}
  .hov-bdr-k:hover {border-color: #616161 !important;}
  .hov-color-k:hover {color: #616161;}
  .hov-bg-k:hover {background: #616161;}
  .ds-k {filter: drop-shadow(0px 0px 5px #616161);}
  .hov-ds-k:hover {filter: drop-shadow(0px 0px 5px #616161);}
</style>
<style id="db-sticky-color">
.sticky .navbar-nav a {color: #000000;}
@media (max-width: 991.98px) {.navbar-nav a {color: #000000;}}
</style>
<style id="db-sticky-hover-color">
.sticky .navbar-nav a:hover {color: #fd4343;}
@media (max-width: 991.98px) {.navbar-nav a:hover {color: #fd4343;}}
</style>
<style id="db-sticky-bg">
.sticky {background: #ffffff!important;}
.sticky .dropdown-menu {background: #ffffff!important;}
</style>
</div>`).insertAfter('#body-data');
}
//CSS for Builder
$('#ok-css').remove();
$('<div id="ok-css"></div>').insertBefore('#body-data');
let builderCss = [];
builderCss.push(`
<style rel="stylesheet">
/* General Style */
body {
	overflow-x: hidden!important;
}
iframe:not(#mobile-device) {
	pointer-events: none;
}
.hidden-form,
#main-image-iframe,
#main-cardbgimage-iframe,
#main-bgimage-iframe,
#main-smimage-iframe,
#main-favimage-iframe,
#ltr-rtl-panel,
.ok-hide-element,
.overlay-opt-wrap,
#hide-null-object,
#drop-ele-classes,
#upload-file {
	display: none;
}
.drag-temp-col {
	padding-top: 20px!important;
	padding-bottom: 20px!important;
}
.float-right {
	float: right;
}
.pcolor,
.phover:hover {
	color: #6200EA!important;
}
.pbgcolor,
.pbghover:hover {
	background: #6200EA!important;
}
.scolor,
.shover:hover {
	color: #F50057!important;
}
.sbgcolor,
.sbghover:hover {
	background: #F50057!important;
	border: 1px solid #F50057!important;
}
.green {
	color: #4CAF50;
}
.bggreen {
	background: #4CAF50;
}
.blue {
	color: #6200EA!important;
}
.bg-blue,
.bgblue {
	background: #6200EA!important;
}
.red {
	color: #f44336!important;
}
.bgred {
	background: #f44336!important;
}
.white {
	color: #ffffff!important;
}
.bgwhite {
	background: #ffffff!important;
}
.no-border {
	border: none!important;
}
.ok-column:hover {
	border: 1px dotted #6200EA!important;
}
.ok-select-opt {
	padding: 10px 20px;
	width: 100%;
}
.ok-w100 {
	padding: 10px 10px;
	width: 100%;
	text-align: center;
	border-radius: 5px 5px;
}
.ok-p20 {
	padding: 10px 20px;
}
.button-25-wrap {
	margin-bottom: 60px;
}
.button-20,
.button-25,
.button-33,
.button-50 {
	float: left;
	height: 40px;
	line-height: 35px;
	text-align: center;
	color: #333333;
	background: #ffffff;
	border: 1px solid #dddddd;
	outline: none;
}
.button-20 {
	width: 20%;
}
.button-25 {
	width: 25%;
}
.button-33 {
	width: 33%;
}
.button-50 {
	width: 50%;
}
.button-20:hover,
.button-25:hover,
.button-33:hover,
.button-50:hover {
	color: #ffffff;
	background: #6200EA;
}
.tools-icon {
	width: 20px!important;
}
.ok-text:empty:before,
.ok-link-text:empty:before,
.ok-link:empty:before,
div.ok-icode:empty:before {
  content: attr(data-placeholder);
  color: #e53935;
}
.ok-text:focus {
	outline: none;
}
button.ok-main-btn {
	cursor: pointer!important;
}
#main-menu-btn img,
.download-popup-wrap img {
	width: 25px;
}
.close-link-modal img {
	width: 20px;
}
.dragme-panel .float-right,
button.float-right {
	float: right!important;
}
.dragme-panel .float-left {
	float: left;
}
.dragme-panel .clear-both,
.code-editor-panel .clear-both {
	clear: both;
}
#text-link-panel .d-cursor,
.dragme-panel .d-cursor {
	cursor: pointer!important;
}
.d-cursor {
	cursor: pointer!important;
}
.dragme-panel .mt-10 {
	margin-top: 10px;
}
.dragme-panel .mb-10 {
	margin-bottom: 10px;
}
.dragme-panel .w-100 {
	width: 100%!important;
}
.dragme-panel .o-hidden {
	overflow: hidden!important;
}
.dragme-panel .input,
.dragme-panel .input-50,
.ok-main-tools .input,
.download-popup-box .input-50,
.urlbox .input {
	padding: 5px 5px!important;
	width: 100%!important;
	font-size: 16px!important;
}
.ok-main-tools .input,
.download-popup-box .input-50,
.urlbox .input {
	border: 1px solid #333333!important;
}
.dragme-panel .input,
.dragme-panel .input-50 {
	border: 1px solid silver!important;
}
.dragme-panel .input,
.ok-main-tools .input,
.urlbox .input,
.ok-seo-wrap input.input {
	width: 100%!important;
}
.dragme-panel .input-50,
.download-popup-box .input-50 {
	width: 50%!important;
}
.dragme-panel .added-icon {
	margin-left: -10px!important;
	font-size: 12px!important;
}
.ok-hide-name-field,
.ok-youtube iframe,
.ok-vimeo iframe {
	display: none!important;
}
.ok-youtube i,
.ok-vimeo i {
	margin: 0;
	position: absolute;
	top: 50%;
	left: 50%;
	transform: translate(-50%, -50%);
	font-size: 70px;
}
/* Drop block element classes */
#page-source,
#theme-source,
#page-css-source,
#page-js-source,
#page-php-source,
#filenamedy,
#uniqueuser,
.image-cropping,
#sec-image-cropping,
.ok-group-container .image-element,
.ok-group-container .icon-element,
.ok-group-container .video-element,
.card-body .video-element,
.card-body .card-element,
.ok-group-container .card-element,
.card-body .card-top-image-element,
.card-body .card-bottom-image-element,
.ok-group-container .card-top-image-element,
.ok-group-container .card-bottom-image-element,
.card-body .card-overlay-image-element,
.ok-group-container .card-overlay-image-element,
.ok-group-container .rounded-image-element,
.ok-group-container .gallery-pop-element,
.ok-group-container .gallery-2-element,
.card-body .gallery-2-element,
.ok-group-container .video-image-element,
.card-body .video-image-element,
.ok-group-container .custom-code-element,
.ok-group-container .container-element,
.ok-group-container .map-element,
.ok-group-container .contact-element,
.ok-group-container .optin-form1-element,
.ok-group-container .optin-form2-element,
.card-body .slider-1-element,
.ok-group-container .slider-1-element,
.card-body .slider-2-element,
.card-body .slider-4-element,
.ok-group-container .slider-2-element,
.ok-group-container .slider-4-element,
.card-body .slider-3-element,
.ok-group-container .slider-3-element {
	display: none!important;
}
/* Hidden Elements */
#hide-hidden-elements {
	display: none;
}
.d-xxl-none.ok-display-block  {
	display: inline-block!important;
	position: relative!important;
	border: 1px dotted red;
}
.d-xxl-none.ok-display-block:before {
	content: 'Hidden on Desktop';
	position: absolute!important;
	padding-top: 0px;
	padding-left: 5px;
	color: red;
	font-size: 11px;
}
ul .paste-element,
ul .copy-element,
.paste-element,
.ok-deleted-elements {
	display: none!important;	
}
#copy-db,
.hide-this-db,
.ok-handle.setting-menu-btn,
#add-row-bgimage,
#add-column-bgimage,
#add-sm-image,
#add-fav-image,
#add-bgimage,
#image-lightbox-link,
#delete-section-alt,
#icon-info-text,
#video-opt-wrap,
#vm-vid-url,
#vimeo-format,
.ok-seo-wrap,
#cleanhtml,
#head-html,
#body-html {
	display: none;
}
button#ok-hide-hidden-ele-btn {
	display: none;
}
.ok-temp-show-deleted-elements {
	border: solid 1px red;
}
.ok-temp-show-deleted-elements:before {
	content: 'Temporary Hidden Element';
	position: absolute;
	padding-top: 0px;
	padding-left: 5px;
	color: red;
	font-size: 11px;
}
/* On Hover Elements */
.row-border {	
	border: 1px solid #FFB300!important;
	outline: none;
}
.column-border {	
	border: 1px solid #000000!important;
	outline: none;
}
.ok-slider-border {	
	border: 1px solid #0D47A1!important;
	outline: none;
}
.ok-card-border {	
	border: 1px solid #388E3C!important;
	outline: none;
}
.ok-border {
	border: 1px dotted #6200EA!important;
	outline: none;
}
.ok-column-handle {
	position: relative;
}
div.setting-menu {
	z-index: 999999!important;
	position: absolute;
	overflow: hidden;
	display: flex;
	text-align: center;
	margin-left: -2.5px!important;
	margin-right: -2.5px!important;
	padding: 0px!important;
	color: #ffffff;
	background: #6200EA;
	border: none;
	cursor: pointer;
}
.setting-menu div {
	margin-right: -5px!important;
}
div.setting-menu img {
	width: 15px!important;
}
#row-setting-tools.setting-menu {
	top: -30px;
	left: 0px!important;
	background: #FFB300;
}
#ok-row-wrap {
	position: relative;
}
#column-setting-tools.restore-btn {
	width: 35px;
}
#column-setting-tools.setting-menu {
	position: relative;
	float: right;
	margin-top: -30px;
	background: #000000;
	transform: none;
}
#column-setting-tools.setting-menu.restore-btn {
	position: absolute;
	width: 30px;
}
#ok-slider-wrap {
	width: 100%;
}
#slider-setting-tools.setting-menu {
	top: -10px;
	left: 35%;
	transform: translateY(-35%);
	background: #0D47A1;
}
#card-setting-tools.setting-menu {
	top: -10px;
	left: 35%;
	transform: translateY(-35%);
	background: #388E3C;
}
#ok-card-wrap.swiper-slide #card-setting-tools {
	top: 0px;
	left: 10%;
	transform: translateY(-10%);
	background: #388E3C;
}
#ok-card-wrap.swiper-slide {
	width:auto;
}
#ok-group-container-wrap.ok-border {
	border-color: #4E342E!important;
}
#container-setting-tools.setting-menu {
	top: -20px;
	left: 35%;
	transform: translateY(-35%);
	background: #4E342E;
}
.setting-menu.icode-control {
	top: 0px;
	left: 10px;
}
.setting-menu.brand-logo,
.setting-menu.restore-btn {
	left: 35%;
	transform: translateY(-35%);
}
#ok-text-wrap .setting-menu {
	top: -30px;
	left: 5%;
	transform: translateY(-5%);
}
#ok-link-wrap .setting-menu,
#ok-img-wrap .setting-menu {
	left: 35%;
	transform: translateY(-35%);
}
.overlay-container #ok-link-wrap {
  position: absolute!important;
  top: 50%!important;
  left: 50%!important;
  transform: translate(-50%, -50%)!important;
  -ms-transform: translate(-50%, -50%)!important;
}
.ok-card #ok-img-wrap .move-up-btn:not(.card-body .move-up-btn),
.ok-card #ok-img-wrap .move-down-btn:not(.card-body .move-down-btn),
.ok-card #ok-img-wrap #duplicate-image:not(.card-body #duplicate-image),
.ok-card #ok-img-wrap #copy-image:not(.card-body #copy-image),
.ok-card #ok-img-wrap #delete-image:not(.card-body #delete-image),
.overlay-container #ok-link-wrap .move-up-btn,
.overlay-container #ok-img-wrap .move-up-btn,
.overlay-container #ok-link-wrap .move-down-btn,
.overlay-container #ok-img-wrap .move-down-btn,
.overlay-container #ok-link-wrap #duplicate-link,
.overlay-container #ok-img-wrap #duplicate-image,
.overlay-container #ok-link-wrap #copy-link,
.overlay-container #ok-img-wrap #copy-image,
.overlay-container #ok-link-wrap #delete-link,
.overlay-container #ok-img-wrap #delete-image {
	display: none!important;
}
#ok-img-wrap .setting-menu {
	top: 20px;
}
.setting-menu-btn {
	display: inline-block;
	padding: 5px 10px;
}
.setting-menu-btn:hover {
	color: #ffffff;
	background: #F50057;
}
.ok-selector-line {
	display: inline-block!important;
	position: relative!important;
}
.ok-selector-block {
	display: block!important;
	position: relative!important;
}
.null-text {
	outline: none;	
}
/* Hide Setting Elements */
.nav-end #ok-link-wrap #copy-link {
	display: none!important;
}
/* Draggable Panel */
.active-panel {
	z-index:999999999!important;
	position: fixed;
	top: 0;
	width:100%;
	height: 100vh;
	background: transparent;
}
.dragme-panel {
	display: none;
	overflow: hidden;
	z-index: 999999999;
	position: fixed;
	top: 7%;
	left: 0%;
	width: 300px;
	height: 70%;
	font-family: "Arial", Helvetica, sans-serif;
	text-align: center!important;
	background: #FAFAFA!important;
	box-shadow: 0 19px 38px rgba(0,0,0,0.30), 0 15px 12px rgba(0,0,0,0.22);
	border-radius: 10px 10px 2px 2px;
}
.settings p {
	margin-top: 10px!important;
	margin-bottom: 0px!important;
	font-family: "Arial", Helvetica, sans-serif;
	text-align: left!important;
	font-size: 14px!important;
	color: #333333!important;
}
.dragme-panel .dragme-header {
	z-index: 999999999;
	height: 50px!important;
	background-color: #6200EA!important;
	cursor: move;
}
.dragme-header img {
	width: 20px;
}
.dragme-panel .dragme-header p.dht {
	padding: 10px 10px!important;
	font-size: 18px!important;
	font-family: "Arial", Helvetica, sans-serif;
	color: #ffffff!important;
	text-align: left!important;
}
.draggable-wrap {
	margin: 0 auto;
	padding: 0px 0px;
}
.draggable-content {
	position: absolute;
	overflow: auto;
	width: 100%;
	height: 89%;
}
.dragme-panel .setting-title {
	padding-left: 10px;
	height: 50px;
	font-family: "Arial", Helvetica, sans-serif;
	font-size: 18px;
	line-height: 50px;
	text-transform: capitalize!important;
	text-align: left;
	color: #333333;
	background: #ffffff;
	border-top: 1px solid #dddddd;
	border-bottom: 1px solid #dddddd;
	cursor: pointer;
}
.dragme-panel .settings {
	margin: 0 auto!important;
	padding: 20px 10px!important;
	font-family: "Arial", Helvetica, sans-serif;
	text-align: left!important;
}
.dragme-panel .settings {
	display: none;
}
.dragme-panel .settings.default {
	display: block;
}
/* Text Panel */
.main-text-tools {
	position: relative;
	margin-top: -10px!important;
	margin-bottom: 10px!important;
	margin-left: -15px!important;
	margin-right: -15px!important;
	padding-left: 10px!important;
	width: 285px!important;
	text-align: left;
}
.main-text-tools .button {
	float: left;
	width: 20%!important;
	height: 30px;
	font-size: 14px!important;
	font-weight: bold!important;
	color: #333333!important;
	background: #ffffff!important;
	border-radius: 0px!important;
	outline: none!important;
	border: 1px solid #333333!important;
	cursor: pointer;
}
.main-text-tools .button:hover {
	color: #ffffff!important;
	background: skyBlue!important;
}
.main-text-tools img {
	width: 20px;
}
#main-textinput-field,
.icode-input {
	display: inline-block!important;
	overflow: auto;
	overflow-x: hidden;
	margin-left: -5px;
	margin-right: -10px;
	padding: 5px;
	height: 300px;
	width: 275px!important;
	font-size: 14px!important;
	text-align: left;
	color: #000000;
	background: #ffffff;
	border: 1px solid #333333;
	outline: none;
	user-select: text;
	-webkit-user-select: text;
	/*white-space: pre-wrap;*/
	overflow-wrap: break-word;
}
#main-textinput-field sub,
#main-textinput-field sup {
  font-size: 75%;
  line-height: 0;
  position: relative;
  vertical-align: baseline;
}
#main-textinput-field sub {
  vertical-align: sub;
}
#main-textinput-field sup {
  vertical-align: super;
}
/* ::: Tool Add Link Style ::: */
.urlbox-wrap,
.url {
	display: none;
}
.active-urlbox {
	z-index: 9999999999; 	
	display: block;
	position: fixed;
	overflow: auto;
	top: 0px;
	margin: 0 auto;
	width: 100%;
	height: 100%;
	background-color: rgba(0,0,0,0.9);
	font-family: "Arial", Helvetica, sans-serif;
	font-size: 18px!important;
}
.urlbox {	
	position: absolute;
	top: 30%;
	left: 50%;
	padding: 10px 30px;
	width: 50%;
	background-color: #ffffff;
	border-radius: 5px;
	-webkit-transform: translate(-50%, -30%);
	-moz-transform: translate(-50%, -30%);
	-ms-transform: translate(-50%, -30%);
	-o-transform: translate(-50%, -30%);
	transform: translate(-50%, -30%);
	
}
.urlbox p {	
	margin-bottom: 10px!important;
	font-family: "Arial", Helvetica, sans-serif;
	font-size: 18px!important;	
}
#link-web-tab.button,
#link-email-tab.button {
	margin-right: -10px;
	padding: 10px 20px;
	width: 50%!important;
	font-size: 14px!important;
	font-weight: bold!important;
	color: #333333;
	background: #ffffff;
	border-radius: 0px!important;
	outline: none!important;
	border: 1px solid #333333!important;
	cursor: pointer;
}
#link-web-tab.button:hover,
#link-email-tab.button:hover {
	color: #ffffff!important;
	background: skyBlue!important;
}
.urlForm {
	padding-bottom: 20px;
}
.insert-url-wrap {
	position: relative;
	margin: 0 auto;
	padding: 20px;
}
.insert-url {
	float: right;
	margin-top: -1px;
	padding: 7px 20px;
	font-size: 18px!important;
	font-weight: bold!important;
	color: #333333!important;
	background: #ffffff!important;
	border: 1px solid #333333!important;
	cursor: pointer;
}
.insert-url:hover {
	color: #ffffff!important;
	background: skyBlue!important;
}	
.link-option-wrap {
	padding: 30px 20px;
	width: 99.3%!important;	
	border: 1px solid #333333!important;
}
div.ok-select {
	margin-top: -10px!important;
}
/* Image Panel */
.image-upload-iframe {
	width: 270px;
	height: 25px;
}
.upload-image {
	display: block;
	padding: 5px 10px;
	width: 100%;
	text-align: center;
	border: 1px solid silver;
	cursor: pointer;
}
.upload-image:hover {
	color: #ffffff;
	background: skyBlue;
}
.upload-image img {
	width: 25px;
}
.upload-image input[type="file"] {
    display: none;
}
#row-bgimage-preview,
#column-bgimage-preview,
#card-bgimage-preview,
#content-image-preview,
#card-image-preview,
#logob-image-preview,
#web-img-preview,
#fav-img-preview,
#bgimage-preview,
#sec-bgimage-preview,
.preview-bgimage,
#col-bgimage-preview {
	margin: 10px auto;
	width: 100%!important;
	height: 200px;
	background: #dddddd;
	border: 1px solid silver;
}
/* Main Tools */
.ok-main-tools {
	z-index: 99999999;
	position: fixed;
	top: 10%;
	left: -5px;
}
button.close-download-box {
	color: #333333;
	background: #ffffff;
	border: 1px solid #333333;
	outline: none;
	font-family: "Arial", Helvetica, sans-serif;
}
button.close-download-box {
	margin-top: -30px;
	margin-right: -30px;
	height: 30px;
	width: 30px;
	text-align: center;
	border-radius: 50%;
}
#close-section {
	font-family: "Arial", Helvetica, sans-serif;
}
#close-section img {
	width: 25px!important;
}
button.full-width {
	display: block;
	width: 100%;
	color: #333333;
	background: #dddddd;
	border: 1px solid #333333;
	outline: none;
}
#main-menu-panel {
	background: #ffffff;
	border-radius: 5px;
	box-shadow: 0px 0px 5px 3px rgba(0, 0, 0, 0.3);
}
.drag-btn.ok-main-btn {
	border-top-left-radius: 5px;
	border-top-right-radius: 5px;
}
#convert-file {
	border-bottom-left-radius: 5px;
	border-bottom-right-radius: 5px;
}
button.ok-main-btn {
	display: block;
	width: 50px;
	height: 50px;
	line-height: 45px;
	font-size: 18px!important;
	text-align: center;
	border: none!important;
	background: #ffffff;
}
button.ok-main-btn:hover {
	color: #ffffff;
	background: #6200EA;
}
.drag-btn {
	cursor: move!important;
}
.ok-seo-wrap p.sp {
	margin-top: 20px!important;
	margin-bottom: 5px!important;
	font-family: "Arial", Helvetica, sans-serif;
	font-size: 16px!important;
	line-height: 18px!important;
	color: #333333!important;
}
div.ok-seo-wrap-on {
	z-index: 999999999;
	display: block;
	position: fixed;
	overflow: auto;
	top: -10px;
	left: 0;
	margin: 10px auto;
	padding-left: 10px;
	padding-right: 10px;
	padding-bottom: 5%!important;
	width: 300px;
	height: 100%!important;
	font-family: "Arial", Helvetica, sans-serif;
	font-size: 16px;
	line-height: 16px;
	color: #333333;
	background: #ffffff;
	border: 2px solid #333333;
	box-shadow: -1px 2px 32px 0px rgba(0,0,0,0.75);
	-webkit-box-shadow: -1px 2px 32px 0px rgba(0,0,0,0.75);
	-moz-box-shadow: -1px 2px 32px 0px rgba(0,0,0,0.75);
}
span.close-seo {
	position: fixed;
	top: 10px;
	margin-left: 5px;
	padding: 5px 5px;
	left: 250px!important;
	cursor: pointer;
}
textarea.seo-input-style {
	padding: 5px 5px;
	width: 99%;
	height: 100px;
	font-family: 'Source Code Pro', monospace;
	font-size: 16px;
}
textarea.seo-input-style {
	border: 1px solid #333333!important;
}
.dragme-panel textarea.seo-input-style {
	border: 1px solid silver!important;
}
.glightbox-desc-input {
	width: 100%;
	height: 150px;
}
#hide-name-field,
#show-name-field {
	float: right;
	cursor: pointer;
}
/* Code Editor Style */
.CodeMirror {
	position: absolute;
	width: 100%;
	height: 100%;
	font-family: 'Source Code Pro', monospace;
	font-size: 14px;
	line-height: 24px;
	font-weight: normal;
	border: 2px solid #0b0a10;
}
.body-scale {
	-moz-transform: scale(0.5);
	-webkit-transform: scale(0.5);
	transform: scale(0.5);
	transform-origin: top left;
}
.full-overlay {
	display: none;
}
.ok-overlay {
	z-index: 999999999!important;
	display: block!important;
	position: fixed!important;
	top: 0px!important;
	left: 0px!important;
	width: 100%!important;
	height: 100%!important;
	background: transparent!important;
}
.ok-layer {
	z-index: 2;
	position: absolute;
	width: 100%;
	height: 100%;
}
/* Download Style */
.download-popup-wrap,
#download-box-section {
	display: none;
}
.download-popup-on {
	z-index: 999999999!important;
	display: block;
	position: fixed;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
	background: rgba(0,0,0,0.7);
	font-family: "Arial", Helvetica, sans-serif;
}
.download-popup-box {
	position: absolute;
	top: 50%;
	left: 50%;
	padding: 20px 20px;
	width: 35%;
	text-align: center!important;
	color: #333333!important;
	background: #ffffff!important;
	-webkit-transform: translate(-50%, -50%);
	-moz-transform: translate(-50%, -50%);
	-ms-transform: translate(-50%, -50%);
	-o-transform: translate(-50%, -50%);
	transform: translate(-50%, -50%);
	border: 2px solid #333333;
	border-radius: 10px;
	box-shadow: -1px 2px 32px 0px rgba(0,0,0,0.75);
	-webkit-box-shadow: -1px 2px 32px 0px rgba(0,0,0,0.75);
	-moz-box-shadow: -1px 2px 32px 0px rgba(0,0,0,0.75);
}
.download-popup-box p {
	margin: 20px auto!important;
	color: #333333!important;
	font-size: 18px;
}
.download-popup-box p i {
	color: #F44336!important;
}
.upload-project-btn {
	padding: 10px 20px;
	color: #ffffff;
	background-color: #000000;
	border: none;
	outline: none;
	border-radius: 5px;
}
.upload-project-btn:hover {
	background-color: #333333;
}
.upload-project-btn img {
	margin-right: 10px;
}
#save-files {
	margin-right: 1%;
}
#save-files,
#update-files {
	display: inline-block;
	margin-bottom: 20px;
	padding: 10px 20px;
	width: 45%;
	background-color: #1565C0;
	font-size: 18px;
	color: #ffffff;
	border-radius: 5px;
	outline: none;
	border: none;
}
#save-files:hover,
#update-files:hover {
	background-color: #2196F3;
}
#project-frame {
	display: none;
	width: 100%;
	height: 50px;
}
/* ::: Color Panel Style ::: */
.global-clr-btn {
	display: inline-block;
	margin-right: 2px;
	width: 35px;
	height: 35px;
	border-radius: 50%;
	outline: none;
	border-style: groove;
	border-width: 1px;
	cursor: pointer;	
}
.ban-clr-btn { 
	background: transparent!important;
	border: 2px solid red!important;
}
.color-palettes {
	margin: 0 auto;
	text-align: left;
}
.color-palettes-box {
	margin: 0 auto;
	padding: 10px 2px;
	background: #ffffff;
	border: 1px solid #dddddd;
}
.color-ul {
	margin: 0 auto;
}
.solid-btn, .gd-btn,
.bg-solid-btn, .bg-gd-btn,
.hover-solid-btn, .hover-gd-btn,
.shadow-color-title,
.drop-shadow-color-title {
	margin-right: -4px;
	padding-top: 5px;
	border: none;
	cursor: pointer;
}
.shadow-color-title,
.drop-shadow-color-title {
	cursor: default;
}
.color-title,
.solid-btn,
.bg-solid-btn,
.hover-solid-btn,
.shadow-color-title,
.drop-shadow-color-title {
	color: #ffffff;
	background: #6200ea;
}
.gd-btn, 
.bg-gd-btn,
.hover-gd-btn {
	color: #333333;
	background: #9fa7ba;
}
.gradient-palettes,
.hover-gradient-palettes, 
.custom-gd-palettes,
.custom-bg-gd-palettes,
.bg-gradient-palettes {
	display: none;
	color: #ffffff;
}
.custom-gd-palettes button,
.custom-gd-palettes input,
.custom-bg-gd-palettes button,
.custom-bg-gd-palettes input,
.shadow-options button,
.shadow-options input {
	border: none;
}
.custom-gd-palettes button,
.custom-bg-gd-palettes button,
.shadow-options button {
	width: 20%;
	height: 30px;
	line-height: 30px;
	text-align: center;
	cursor: pointer;
	float: left;
}
.custom-gd-palettes input,
.custom-bg-gd-palettes input,
.shadow-options input {
	width: 79%;
	height: 30px;
	line-height: 30px;
	text-align: center;
}
.custom-gd-palettes .slider-container,
.custom-bg-gd-palettes .slider-container, 
.custom-gd-palettes .slider-container p, 
.custom-bg-gd-palettes .slider-container p {
	margin-bottom: -15px;
	color: #333333;
}
.color-ul {
	padding: 5px 5px;
}
.color-ul li {
	display: inline-block;
	width: 19.2px;
	height: 19.2px;
	border: 1px solid #e0e0e0;
	transition: all .2s ease-in-out;
	cursor: pointer;
}
.color-ul li:hover {
	transform: scale(1.8);
}
.trans-btn {
	background: #ffffff;
	border: 1px solid red!important;
}
.color-box {
	z-index: 999999999!important;
	background: #ffffff;
	border: 1px solid #dddddd;
	-webkit-box-shadow: 0px 0px 14px 2px rgba(0,0,0,0.75);
	-moz-box-shadow: 0px 0px 14px 2px rgba(0,0,0,0.75);
	box-shadow: 0px 0px 14px 2px rgba(0,0,0,0.75);
	border-radius: 2px 2px;
}
.color-box .sp-palette-toggle, .color-box .sp-choose
{	padding: 10px 20px;
	color: #ffffff;
	background: #0074D9;
	border: none;
	font-family: "Arial", Helvetica, sans-serif;
	font-size: 14px;
	font-weight: normal;
}
.color-box .sp-palette-toggle:focus, .color-box .sp-choose:focus
 {
	outline: none;
	border: none;
}
.color-box .sp-palette-toggle:hover, .color-box .sp-choose:hover
 {
	outline: none;
	background: #e91e63;
	border: none;
}
.color-box .sp-palette-container {
	border-right: 1px solid #30384d;
}
.color-box .sp-color,
.color-box .sp-hue,
.color-box .sp-input  {
	border: 1px solid #dddddd;
}
.color-box .sp-input {
	color: #333333;
	background: #dddddd;
}
/* Elements Library */
.layout-library .drag-main-blocks,
.element-library .drag-main-blocks {
	margin: 1.5%;
	width: 22%!important;
	float: left;
}
.layout-library img,
.element-library img {
	width: 100%;
}
.element-title {
	clear: both;
	font-size: 14px;
	font-family: "Arial", Helvetica, sans-serif;
	text-align: left;
	border-bottom: 1px solid #cccccc;
}
.element-title:not(.first-ele-title) {
	padding-top: 20px;
}
/* Scale Down main page */
.scaledown-main-content {
	position: absolute;
	top: 0;
	left: 0;
	bottom: 0;
	right: 0;
	-webkit-transform: scale(0.70);
	-moz-transform: scale(0.70);
	transform: scale(0.70);
	transform-origin: top right;
}
#scaledown-overlay {
	z-index: 9;
	position: fixed;
	top: 0;
	left: 0;
	width: 100%;
	height: 100vh;
	cursor: pointer;
}
/* Add Section Style */
#ok-db,
#save-section,
#user-section-library {
	display: none!important;
}
.empty-section {
	margin: 0 auto;
	text-align: center;
}
.empty-section-wrap {
	margin: 0 auto;
}
.empty-button,
.add-element-btn {
	width: 100%;
	color: #333333;
	background: #fafafa;
	font-family: "Arial", Helvetica, sans-serif;
}
.empty-button {
	padding: 100px 50px;
	height: 100vh;
	font-size: 50px;
	border: none!important;
}
.add-element-btn {
	padding: 50px 50px;
	font-size: 24px;
	border: 1px solid blue;
}
.add-element-btn:hover {
	color: blue;
}
.add-element-btn i {
	margin-right: 10px;
	color: blue;
}
.section-box {
	display: none;
}
.ok-section.display-none-dp {
	display: none!important;
}
.user-saved-blocks {
	font-size: 16px;
	color: #333333;
	background: #ffffff;
	border: 1px solid #dddddd;
}
.user-saved-blocks img {
	width: 100%;
}
.section-box-on {
	z-index: 99999999999;
	display: block;
	position: fixed;
	top: 0;
	left: 0;
	margin: 0 auto;
	width: 30%;
	height: 100%;
	text-align: center;
	background: rgba(0,0,0,0.7);
}
.section-box.section-box-on {
	display: block;
}
#section-block-list {
	position: relative;
	margin: 0 auto;
	width: 100%;
	text-align: left;
	background: #ffffff;
	-webkit-box-shadow: 0px 0px 14px 2px rgba(0,0,0,0.75);
	-moz-box-shadow: 0px 0px 14px 2px rgba(0,0,0,0.75);
	box-shadow: 0px 0px 14px 2px rgba(0,0,0,0.75);
	border-radius: 2px 2px;
}
.section-block-panel {
	overflow: auto;
	margin: 0 auto;
	padding: 10px 10px;
	padding-bottom: 2%;
	width: 100%;
	height: 91vh;
	background-color: #EEF2F7;
	border-top: 1px solid #dddddd;	
}
#brand-section {
	padding: 10px 10px;
	text-align: left;
	color: #ffffff;
	background-color: #3700fa;
}
#brand-section h1 {
	display: inline-block;
	margin-bottom: 0px;
	font-size: 18px;
	font-family: "Arial", Helvetica, sans-serif;
}
.main-panel-close-btn {
	font-size: 18px;
	color: #ffffff;
	background: transparent;
	border: 0px;
	outline: none;
}
#elements-switch,
#block-switch {
	color: #333333;
	background-color: #ffffff;
	font-size: 18px;
	font-family: "Arial", Helvetica, sans-serif;
	border: 0px;
	outline: none;
}
#elements-switch {
	padding-right: 20px;
	color: #3700fa;
}
#block-list-opt {
	display: none;
	border: 1px solid #dddddd;
	outline: none;
	font-family: "Arial", Helvetica, sans-serif;
}
#block-list-opt option {
	font-size: 20px;
}
.drag-main-blocks {
	margin-bottom: 10px;
	width: 100%!important;
}
.sortable-chosen {
	width: 100%!important;
	border: 5px solid #16C28E!important;
	background-color: #baecdb!important;
	cursor: move!important;
}
section.ok-section .sortable-chosen,
footer.ok-section .sortable-chosen {
	overflow: hidden;
	width: 100%!important;
	height: 5px!important;
	border: 5px solid #16C28E!important;
	background-color: #baecdb!important;
	cursor: move!important;
}
.sortable-chosen:not(.element-library .sortable-chosen, .layout-library .sortable-chosen) {
	border-radius: 10px;
}
.temp-padding {
	padding: 20px!important;
}
.drag-main-blocks {
	margin-bottom: 30px;
	max-width: 100%;
}
.section-list-wrap,
.user-save-library {
	display: none;
}
.section-list-wrap img {
	width: 100%;
	box-shadow:	0 1.8px 1.2px rgba(0, 0, 0, 0.014),
				0 2.7px 2.3px rgba(0, 0, 0, 0.028),
				0 3.5px 3px rgba(0, 0, 0, 0.03),
				0 4.3px 4.9px rgba(0, 0, 0, 0.032),
				0 5.8px 5.4px rgba(0, 0, 0, 0.046),
				0 8px 8px rgba(0, 0, 0, 0.12);
	border: solid 1px rgba(0, 0, 0, 0.1);
	border-radius: 5px;
	cursor: move;
}
#ok-section-wrap {
	position: relative;
}
#section-setting-wrap {
	z-index: 99999999;
	position: absolute;
	bottom: -1px;
	right: 1px;
	font-family: "Arial", Helvetica, sans-serif;
}
#section-setting-wrap img {
	width: 20px;
}
button.section-menu {
	margin-right: -5px;
	padding: 5px 15px;
	font-size: 18px;
	color: #333333;
	background: #ffffff;
	border: none;
	outline: none;
}
.section-menu:hover {
	background: skyBlue;
}
.conform-delete,
.conform-save {
	display: none;
}
.conform-delete-on {
	display: inline-block;
	margin: 0 auto;
	padding: 10px 20px;	
	width: auto;
	text-align: left;
	color: #ffffff;
	background: #333333;
}
.conform-delete-on p {
	margin: 5px auto;
}
.conform-delete-on input {
	margin: 10px auto;
	width: 90%;
	display: block;
}
.conform-delete-on button {
	margin: 0 5px;
	cursor: default;
}
.color-table {
	margin: 10px auto;
	padding-left: 10px!important;
	padding-right: 10px!important;
	padding-top: 10px!important;
	padding-bottom: 5px!important;
	text-align: left;
	background: #ffffff;
	border: 1px solid silver;
	border-radius: 5px 5px;
}
.main-colors-btn {
	margin: 10px 5px;
	width: 40px;
	height: 40px;
	color: #333333;
	border: 1px solid silver;
	border-radius: 50%;
	cursor: pointer;
	outline: none;
}
.main-colors-btn:hover {
	background-color: #ffffff;
	box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
	transition: all 0.3s cubic-bezier(.25,.8,.25,1);
}
.hidden-gradient, 
.global-gradient-input {
	display: none;
}
.show-gradient {
	display: inline;
}
/* Slider Style */
.left-range-box, 
.right-range-box {
	width: 50%;
	float: left;
}
.counter-wrap p {
	margin-top: -5px;
	font-weight: normal;
	color: #333333;
}
.counter-wrap span {
	color: #333333;
}
.slider-container {
    margin: 0 auto;
	text-align: left;
}
.slider-container input[type=range] {
    position: relative;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    height: 50px;
    border-radius: 3px;
    outline: 0;
    margin: 0;
    padding: 0;
    width: 100%;
	background: none!important;
}
.slider-container input[type=range]:focus {
  outline: none;
}
.slider-container input[type=range]::-webkit-slider-runnable-track {
  width: 100%;
  height: 2px;
  cursor: pointer;
  animate: 0.2s;
  box-shadow: 0px 0px 0px #000000;
  background: #f2559c;
  border-radius: 1px;
  border: 0px solid #000000;
}
.slider-container input[type=range]::-webkit-slider-thumb {
  box-shadow: 0px 0px 0px #000000;
  border: 1px solid #f2559c;
  height: 15px;
  width: 15px;
  border-radius: 25px;
  background: #fd0b86;
  cursor: pointer;
  -webkit-appearance: none;
  margin-top: -7px;
}
.slider-container input[type=range]:focus::-webkit-slider-runnable-track {
  background: #f2559c;
}
.slider-container input[type=range]::-moz-range-track {
  width: 100%;
  height: 2px;
  cursor: pointer;
  animate: 0.2s;
  box-shadow: 0px 0px 0px #000000;
  background: #f2559c;
  border-radius: 1px;
  border: 0px solid #000000;
}
.slider-container input[type=range]::-moz-range-thumb {
  box-shadow: 0px 0px 0px #000000;
  border: 1px solid #f2559c;
  height: 15px;
  width: 15px;
  border-radius: 25px;
  background: #fd0b86;
  cursor: pointer;
}
.slider-container input[type=range]::-ms-track {
  width: 100%;
  height: 2px;
  cursor: pointer;
  animate: 0.2s;
  background: transparent;
  border-color: transparent;
  color: transparent;
}
.slider-container input[type=range]::-ms-fill-lower {
  background: #f2559c;
  border: 0px solid #000000;
  border-radius: 2px;
  box-shadow: 0px 0px 0px #000000;
}
.slider-container input[type=range]::-ms-fill-upper {
  background: #f2559c;
  border: 0px solid #000000;
  border-radius: 2px;
  box-shadow: 0px 0px 0px #000000;
}
.slider-container input[type=range]::-ms-thumb {
  margin-top: 1px;
  box-shadow: 0px 0px 0px #000000;
  border: 1px solid #fd0b86;
  height: 15px;
  width: 15px;
  border-radius: 25px;
  background: #f2559c;
  cursor: pointer;
}
.slider-container input[type=range]:focus::-ms-fill-lower {
  background: #f2559c;
}
.slider-container input[type=range]:focus::-ms-fill-upper {
  background: #f2559c;
}
.slider-container.respo-alt-slider {
	margin-bottom: -10px!important;
}
.res-range-input {
	margin-top: -20px!important;
}
/* Mobile Device */
#iframe-loading {
	position: absolute;
	top: 50%;
	left: 50%;
	-webkit-transform: translate(-50%, -50%);
	-moz-transform: translate(-50%, -50%);
	-ms-transform: translate(-50%, -50%);
	-o-transform: translate(-50%, -50%);
	transform: translate(-50%, -50%);
}
#mobile-view {
	z-index: 999999999;
	display: none;
	position: fixed;
	top: 0;
	left: 0;
	margin: 0 auto;
	width: 100%;
	height: 100%;
	background: #eeeeee;
}
#mobile-view-options {
	position: fixed;
	top: 0px;
	padding: 0px;
	width: 100%;
	height: 30px;
	line-height: 25px;
	background: silver;
	border-bottom: 1px solid #dddddd;
}
#mobile-view-options button {
	margin-top: 2px;
	padding-left: 10px;
	padding-right: 10px;
	font-size: 18px!important;
}
.mob-prev {
	padding: 0px 5px;
	color: #333333;
	font-size: 14px!important;
	background: #ffffff;
	border: none;
	outline: none;
	cursor: pointer;
}
.mob-prev:hover {
	color: #ffffff;
	background: #0074D9;
}
#mobile-device {
	position: absolute;
	display: block;
	overflow: scroll;
	margin: 0 auto;
	top: 30px;
	min-width: 400px;
	height: 97%;
	left: 50%;
	-webkit-transform: translateX(-50%);
	-moz-transform: translateX(-50%);
	-ms-transform: translateX(-50%);
	-o-transform: translateX(-50%);
	transform: translateX(-50%);
	box-shadow:
  0 2.8px 2.2px rgba(0, 0, 0, 0.034),
  0 6.7px 5.3px rgba(0, 0, 0, 0.048),
  0 12.5px 10px rgba(0, 0, 0, 0.06),
  0 22.3px 17.9px rgba(0, 0, 0, 0.072),
  0 41.8px 33.4px rgba(0, 0, 0, 0.086),
  0 100px 80px rgba(0, 0, 0, 0.12)
}
.mobile-frame-close-btn {	
	padding: 0px 5px;
	color: #ffffff;
	font-size: 14px!important;
	font-family: "Arial", Helvetica, sans-serif;
	background: #ff4136;
	border: none;
	outline: none;
	cursor: pointer;
}
.mobile-frame-close-btn:hover {
	color: #ff4136;
	background: #ffffff;
}
/* Image Editor */
.jcrop-area {
	border: 5px ridge #00897B!important;
	/*background-image: url(https://manula.r.sizr.io/large/user/12518/img/grid.png);
	background-position: center center;
	background-attachment: fixed;
	background-repeat: no-repeat;
	background-size: cover;*/
}
#image-editor {
	display: none;
	z-index: 999999999;
	position: fixed;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
	background: #ffffff;
	color: #333333;
}
#image-editor p,
#image-editor button {
	font-family: "Arial", Helvetica, sans-serif!important;
}
#image-cropper {
	margin-top: 3%;
	width: 100%!important;
	border: 1px solid #cccccc;
}
#image-editor-controls {
	margin-top: 50px;
}
#image-editor-controls .slider-container p {
	margin-bottom: -20px;
}
#image-getter,
#close-image-editor {
	color: #ffffff;
	border: none;
}
#close-image-editor {
	position: absolute;
	top: 0;
	right: 0;
	font-size: 18px;
	background: #E53935;
}
#close-image-editor:hover {
	background: #EF5350;
}
#image-getter {
	margin-bottom: 20px;
	padding: 10px 20px;
	font-size: 24px;
	background: #00897B;
	border-radius: 5px;
}
#image-getter:hover {
	background: #26A69A;
}
#image-cropper-result {
	margin-top: -15px;
	border: 1px solid #cccccc;
}
/* Undo/Redo */
#ok-undo-btn {
	display: none!important;
}
#ok-undo-btn.off-undo-btn:hover {
	background: #cccccc;
	cursor: not-allowed!important;
}
/*
#ok-show-hidden-ele-btn,
#ok-hide-hidden-ele-btn {
	display: none!important;
}*/
</style>`);
document.getElementById("ok-css").innerHTML = builderCss.join("");
//END: OK Builder CSS

//CodeMirror Script
$('#cm-scripts').remove();
$(`<div id="cm-scripts">
<link rel="stylesheet" href="okcc/css/codemirror.css">
<link rel="stylesheet" href="okcc/css/dracula.css">
<link rel="stylesheet" href="okcc/css/spectrum.css">
<link rel="stylesheet" href="okcc/css/bootstrap-iconpicker.min.css">
<link rel="stylesheet" href="okcc/css/jsuites.css">
<link rel="stylesheet" href="okcc/css/jsuites.layout.css">
</div>`).insertBefore('#ok-css'); 

//First Removes Dynamic Elements If Exist
$('html, body').css('overflow', 'auto'); 
$('#dynamic-elements').remove();
$('<div id="dynamic-elements"></div>').insertAfter('#body-data');	
//Dynamic Elements
let dynamicElements = [];
dynamicElements.push(`
<!-- General -->
<div class="full-overlay"></div>
<div id="head-html"></div>
<div id="body-html"></div>

<!-- Code Editor -->
<textarea id="cleanhtml"></textarea>
<div class="modal" id="codeEditorModal" tabindex="-1" aria-labelledby="codeEditorModal" aria-hidden="true" dir="ltr">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header" style="background:#222831;color:#EEEEEE;font-family: Arial, sans-serif;border-bottom: solid 1px #393E46;">
        <h5 class="modal-title" id="exampleModalLabel">Code Editor</h5>
		<div>
        <button type="button" id="close-codeeditor" class="btn btn-secondary float-end" data-bs-dismiss="modal">Close</button>
        <button id="saveBlockCodes" type="button" class="btn btn-primary" data-bs-dismiss="modal" style="margin-right:15px">Save changes</button>
		</div>
      </div>
      <div class="modal-body p-0" id="editor-ide">
        <textarea id="blockCodeEditor"></textarea>
      </div>
    </div>
  </div>
</div>

<!-- Drop Block Classes -->
<textarea id="drop-ele-classes"></textarea>

<!-- Add Settings Panel -->
<div id="setting-panel-wrap" dir="ltr">
	<div id="setting-panel">
	</div>
</div>

<!-- Add Link Panel -->
<div id="add-link-panel" dir="ltr">
</div>

<!-- Dynamic Scripts -->
<div id="dynamic-scripts"></div>

<!-- Copy/Cut Codes -->
<div id="copy-db"></div>
<div id="copy-db-css"></div>

<!-- Main Menu DIV element draggagle: -->
<div id="main-menu-script">
</div>

<!-- Menu pervent Null -->
<div id="hide-null-object">
	<div class="navbar"></div>
	<div id="logo-a"></div>
	<div id="logo-b" class="d-none"></div>
</div>

<!-- Image Editor/Cropper -->
<div id="image-editor" dir="ltr">
<button id="close-image-editor">Close <i class="fas fa-times"></i></button>
<div class="container-fluid cw-100">
<div class='row'>
    <div class='col-8'>
        <div id='image-cropper'></div>
    </div>
    <div class='col'>
		<div id="image-editor-controls">
		<div class="slider-container">
			<p>Zoom</p>
			<input type='range' step='.05' min='0.1' max='5.45' value='1' id='zoom'>
		</div>
		<div class="slider-container">
			<p>Rotate</p>
			<input type='range' step='.05' min='0' max='5.45' value='1' id='rotate'>
		</div>
		<div class="d-flex">W: <p class="crop-width">90</p>px; H: <p class="crop-height">90</p>px</div>
        <button id='image-getter'><i class="fas fa-crop"></i> Crop Image</button>		
		<p>Cropped Image Preview</p>
		<div id='image-cropper-result'><img style='width: 100%; height: auto;'></div>
		</div>
    </div>
</div>
</div>
</div>

<!-- Download and SEO Function -->
<div id="main-menu-btn" class="ok-main-tools">
	<div id="main-menu-panel">
	<div id="main-menu-btnmenuheader">
		<button class="drag-btn ok-main-btn" title="Drag Menu"><i class="fas fa-arrows-alt"></i></button>
	</div>
	<button class="add-section ok-main-btn d-cursor" title="Add Blocks/Elements"><i class="fas fa-plus"></i></button>
	<button id="ok-undo-btn" class="ok-main-btn d-cursor" title="Undo"><i class="fas fa-undo-alt"></i></button>
	<button id="pop-upload-project-file" class="ok-main-btn d-cursor" title="Import Project File">	
		<i class="fas fa-upload"></i>
	</button>
	<button id="ok-seo-btn" class="ok-main-btn d-cursor" title="SEO"><i class="fas fa-search"></i></button>
	<button id="ok-settings-btn" class="ok-main-btn d-cursor" title="Settings"><i class="fas fa-cog"></i></button>
	<button id="show-hidden-elements" class="ok-main-btn d-cursor" title="Show hidden elements"><i class="fas fa-eye"></i></button>
	<button id="hide-hidden-elements" class="ok-main-btn d-cursor" title="Hide hidden elements"><i class="fas fa-eye-slash"></i></button>
	<button id="switch-mob" class="ok-main-btn d-cursor" title="Responsive Preview"><i class="fas fa-mobile-alt"></i></button>
	<button id="convert-file" class="ok-main-btn d-cursor" title="Save Page"><i class="fas fa-save"></i></button>
	<iframe id="fileconvert-frame" style="display:none;"></iframe>
	</div>
	<div class="ok-seo-wrap" dir="ltr">
		<span class="close-seo bgred white"><i class="fas fa-times"></i></span>
		<p class="sp"><strong>Site Meta Tags</strong></p>
		<p class="sp">Site Title (Characters left: <span class="title-characters">70</span>)</p>
		<textarea class="seo-input-style page-title page-title-input" type="text" placeholder="Enter Page Title" maxlength="70"></textarea>
		<p class="sp">Site Description (Characters left: <span class="meta-characters">160</span>)</p>
		<textarea class="seo-input-style meta-desc" type="text" placeholder="Enter Meta Description" maxlength="160"></textarea>
		<p class="sp">Site Keywords (Separate with commas)</p>
		<textarea class="seo-input-style meta-key-input" type="text" placeholder="Enter Meta Keywords"></textarea>
		<p class="sp">Site URL (For Social Media sharing)</p>
		<input type="text" id="web-url" class="input" placeholder="https://domain.com">
		<hr>
		<div class="table-box">
			<p class="sp">Site Image For Social Media sharing</p>
			<table border="0" width="100%">
				<tbody>
				<tr>
					<td width="30%">
						<p class="mb-0">From PC</p>
						<button id="add-site-sm-image" class="upload-image bg-dark white pbghover" title="Upload Image">
							<i class="fas fa-upload"></i>
						</button>
						<form class="hidden-form" method="post" action="okcc/php/image-uploader.php" enctype="multipart/form-data" target="hiddenSmFrame">
							<input id="smimage-filename" type="text" name="newfilename">
							<input type="text" name="imguser" value="`+uniqueUser+`">
							<input type="file" name="photo" id="add-main-smimage" accept=".jpg,.png">
							<input id="upload-smimage" type="submit" name="submit" value="Upload">
						</form>
					</td>
					<td width="70%">
						<p class="mb-0">By URL</p>
						<input type="text" id="web-img" class="input" placeholder="https://domain.com/img.jpg">
					</td>
				</tr>
				</tbody>
			</table>
			<img id="web-img-preview" src="" alt="">
			<!-- Submit Form without leaving page -->
			<iframe name="hiddenSmFrame" id="main-smimage-iframe" class="image-upload-iframe">
				Loading...
			</iframe>
		</div>
		<hr>
		<div class="table-box">
			<p class="sp">Site Favicon</p>
			<table border="0" width="100%">
				<tbody>
				<tr>
					<td width="30%">
						<p class="mb-0">From PC</p>
						<button id="add-site-fav-image" class="upload-image bg-dark white pbghover" title="Upload Image">
							<i class="fas fa-upload"></i>
						</button>
						<form class="hidden-form" method="post" action="okcc/php/image-uploader.php" enctype="multipart/form-data" target="hiddenFavFrame">
							<input id="favimage-filename" type="text" name="newfilename">
							<input type="text" name="imguser" value="`+uniqueUser+`">
							<input type="file" name="photo" id="add-main-favimage" accept=".jpg,.png,.svg,.gif">
							<input id="upload-favimage" type="submit" name="submit" value="Upload">
						</form>
					</td>
					<td width="70%">
						<p class="mb-0">By URL</p>
						<input type="text" id="web-fav" class="input" placeholder="https://domain.com/img.png">
					</td>
				</tr>
				</tbody>
			</table>
			<img id="fav-img-preview" src="" alt="">
			<!-- Submit Form without leaving page -->
			<iframe name="hiddenFavFrame" id="main-favimage-iframe" class="image-upload-iframe">
				Loading...
			</iframe>
		</div>
	</div>
</div>
<div class="download-popup-wrap" dir="ltr">
	<div class="download-popup-box">
		<button class="close-download-box float-right d-cursor bgred white"><i class="fas fa-times"></i></button>
		<div id="download-box-section">
		 <p><i class="fas fa-exclamation-triangle"></i> Updating these changes will overwrite the Homepage(<span class="link-to-frontpage" style="color:blue;text-decoration:underline;cursor:pointer;">`+domainName+`/`+uniqueUser+`</span>).</p>
		<form method="post" action="okcc/php/template-uploader.php" target="templateSrcFrame" enctype="multipart/form-data">		
			<textarea name="main_template_source" id="page-source"></textarea>
			<textarea name="main_project_source" id="theme-source"></textarea>
			<textarea name="custom_css_source" id="page-css-source"></textarea>
			<textarea name="custom_js_source" id="page-js-source"></textarea>
			<textarea name="contact_php_source" id="page-php-source"></textarea>
			<input name="filenamedy" id="filenamedy">
			<input name="uniqueuser" id="uniqueuser" value="`+uniqueUser+`">
			<button name="submit_project" type="submit" id="save-files">Save Changes</button>
			<button name="submit_template" type="submit" id="update-files">Update</button>
		</form>
		<iframe id="project-frame" name="templateSrcFrame"></iframe>
		</div>
		<div id="import-project-file">
		 <p>Are you sure to <strong>import</strong> the <strong>Project File</strong>, it will overwrite all the content of the editor, if any?</p>
		 <button id="upload-project-file" class="upload-project-btn d-cursor" title="Import Project File">	
			<i class="fas fa-check green"></i> <strong>YES</strong>
		</button>
		<input id="upload-file" type="file" name="file" accept=".ok">
		</div>
	</div>
</div>

<!-- Add Dynamic Sections -->
<div class="section-box section-box-on" dir="ltr">
	<div id="section-block-list">
		<div id="brand-section">
			<h1>ItsLink v0.1</h1>
			<button id="close-section" class="main-panel-close-btn button d-cursor float-right"><i class="fas fa-times"></i></button>
		</div>
		<button id="elements-switch"><i class="fas fa-puzzle-piece"></i> Elements</button>
		<button id="block-switch"><i class="fas fa-cubes"></i> Blocks</button>
		<select id="block-list-opt">
			<option value="all">All Blocks</option>
			<option id="nav-val-opt" value="nav">Navigations</option>
			<option value="header">Hero/Headers</option>
			<option value="feature">Features/Services</option>
			<option value="content">Content</option>
			<option value="gallery">Gallery</option>
			<option value="pricing">Pricing</option>
			<option value="team">Team</option>
			<option value="testimony">Testimonials & Clients</option>
			<option value="cta">Call To Action</option>
			<option value="blog">Blog</option>
			<option value="contact">Contact</option>
			<option id="footer-val-opt" value="footer">Footer</option>
			<!--<option value="status">Status</option>
			<option value="brand">Brand</option>
			<option value="newsletter">Newsletter</option>-->
		</select>
		<div class="section-block-panel">
		
		<div class="layout-library">
			<p class="element-title first-ele-title">Layout</p>
			<div class="drag-main-blocks column-element">
				<img class="temp-block-img" src="okcc/img/elements/column.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-2-element">
				<img class="temp-block-img" src="okcc/img/elements/column-2.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-3-element">
				<img class="temp-block-img" src="okcc/img/elements/column-3.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-4-element">
				<img class="temp-block-img" src="okcc/img/elements/column-4.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-5-element">
				<img class="temp-block-img" src="okcc/img/elements/column-5.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-6-element">
				<img class="temp-block-img" src="okcc/img/elements/column-6.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-7-element">
				<img class="temp-block-img" src="okcc/img/elements/column-7.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks column-8-element">
				<img class="temp-block-img" src="okcc/img/elements/column-8.svg" title="Drag and Drop" alt="">
			</div>
		</div>
		<div class="element-library">
			<p class="element-title first-ele-title">Basic Elements</p>
			<div class="drag-main-blocks h1-element">
				<img class="temp-block-img" src="okcc/img/elements/h1.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks h2-element">
				<img class="temp-block-img" src="okcc/img/elements/h2.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks text-element">
				<img class="temp-block-img" src="okcc/img/elements/text.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks image-element">
				<img class="temp-block-img" src="okcc/img/elements/image.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks button-element">
				<img class="temp-block-img" src="okcc/img/elements/button.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks icon-element">
				<img class="temp-block-img" src="okcc/img/elements/icon.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks video-element">
				<img class="temp-block-img" src="okcc/img/elements/video.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks card-element card-selector">
				<img class="temp-block-img" src="okcc/img/elements/card.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title">Heading</p>
			<div class="drag-main-blocks h3-element">
				<img class="temp-block-img" src="okcc/img/elements/h3.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks h4-element">
				<img class="temp-block-img" src="okcc/img/elements/h4.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks h5-element">
				<img class="temp-block-img" src="okcc/img/elements/h5.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks h6-element">
				<img class="temp-block-img" src="okcc/img/elements/h6.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title">Image & Video</p>
			<div class="drag-main-blocks rounded-image-element">
				<img class="temp-block-img" src="okcc/img/elements/rounded-image.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks gallery-pop-element">
				<img class="temp-block-img" src="okcc/img/elements/pop-image.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks video-button-element">
				<img class="temp-block-img" src="okcc/img/elements/video-button.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks video-image-element">
				<img class="temp-block-img" src="okcc/img/elements/video-image.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title">Container, Button, List & Custom Code</p>
			<div class="drag-main-blocks container-element">
				<img class="temp-block-img" src="okcc/img/elements/container.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks button-icon-element">
				<img class="temp-block-img" src="okcc/img/elements/button-icon.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks list-element">
				<img class="temp-block-img" src="okcc/img/elements/list.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks custom-code-element">
				<img class="temp-block-img" src="okcc/img/elements/custom-code.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title">Card</p>
			<div class="drag-main-blocks card-top-image-element card-selector">
				<img class="temp-block-img" src="okcc/img/elements/card-top-image.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks card-bottom-image-element card-selector">
				<img class="temp-block-img" src="okcc/img/elements/card-bottom-image.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks gallery-2-element">
				<img class="temp-block-img" src="okcc/img/elements/gallery2.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks card-overlay-image-element card-selector">
				<img class="temp-block-img" src="okcc/img/elements/card-overlay-image.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title">Slider</p>
			<div class="drag-main-blocks slider-1-element">
				<img class="temp-block-img" src="okcc/img/elements/slider-1.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks slider-2-element">
				<img class="temp-block-img" src="okcc/img/elements/slider-2.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks slider-4-element">
				<img class="temp-block-img" src="okcc/img/elements/slider-4.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks slider-3-element">
				<img class="temp-block-img" src="okcc/img/elements/slider-3.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title">Contact Form, Map & Subscription Form</p>
			<div class="drag-main-blocks contact-element">
				<img class="temp-block-img" src="okcc/img/elements/getintouch.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks map-element">
				<img class="temp-block-img" src="okcc/img/elements/map.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks optin-form1-element">
				<img class="temp-block-img" src="okcc/img/elements/optin-form1.svg" title="Drag and Drop" alt="">
			</div>
			<div class="drag-main-blocks optin-form2-element">
				<img class="temp-block-img" src="okcc/img/elements/optin-form2.svg" title="Drag and Drop" alt="">
			</div>
			<p class="element-title"></p>
		</div>
		
		<div class="section-list-wrap">

<div class="nav-sec drag-main-blocks block-2">
<img class="temp-block-img" src="okcc/img/section/2-nav.jpg" title="Drag and Drop" alt="">
</div>

<div class="nav-sec drag-main-blocks block-1">
<img class="temp-block-img" src="okcc/img/section/1-nav.jpg" title="Drag and Drop" alt="">
</div>

<div class="nav-sec drag-main-blocks block-3">
<img class="temp-block-img" src="okcc/img/section/3-nav.jpg" title="Drag and Drop" alt="">
</div>

<div class="nav-sec drag-main-blocks block-4">
<img class="temp-block-img" src="okcc/img/section/4-nav.jpg" title="Drag and Drop" alt="">
</div>

<div class="nav-sec drag-main-blocks block-4a">
<img class="temp-block-img" src="okcc/img/section/5-nav.jpg" title="Drag and Drop" alt="">
</div>

<div class="nav-sec drag-main-blocks block-4b">
<img class="temp-block-img" src="okcc/img/section/6-nav.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-5">
<img class="temp-block-img" src="okcc/img/section/2-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-5a">
<img class="temp-block-img" src="okcc/img/section/10-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-6">
<img class="temp-block-img" src="okcc/img/section/3-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-7">
<img class="temp-block-img" src="okcc/img/section/4-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-8">
<img class="temp-block-img" src="okcc/img/section/1-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-9">
<img class="temp-block-img" src="okcc/img/section/5-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-10">
<img class="temp-block-img" src="okcc/img/section/6-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-11">
<img class="temp-block-img" src="okcc/img/section/8-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-12">
<img class="temp-block-img" src="okcc/img/section/7-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="hero-sec drag-main-blocks block-13">
<img class="temp-block-img" src="okcc/img/section/9-hero.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-14a">
<img class="temp-block-img" src="okcc/img/section/6-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-14">
<img class="temp-block-img" src="okcc/img/section/1-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-14b">
<img class="temp-block-img" src="okcc/img/section/7-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-15">
<img class="temp-block-img" src="okcc/img/section/2-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-15a">
<img class="temp-block-img" src="okcc/img/section/8-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-16">
<img class="temp-block-img" src="okcc/img/section/3-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-17">
<img class="temp-block-img" src="okcc/img/section/4-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="features-sec drag-main-blocks block-18">
<img class="temp-block-img" src="okcc/img/section/5-features.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-19">
<img class="temp-block-img" src="okcc/img/section/1-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-20">
<img class="temp-block-img" src="okcc/img/section/2-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-21">
<img class="temp-block-img" src="okcc/img/section/3-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-22">
<img class="temp-block-img" src="okcc/img/section/4-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-23">
<img class="temp-block-img" src="okcc/img/section/5-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-24">
<img class="temp-block-img" src="okcc/img/section/6-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-25">
<img class="temp-block-img" src="okcc/img/section/7-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-25a">
<img class="temp-block-img" src="okcc/img/section/12-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-26">
<img class="temp-block-img" src="okcc/img/section/8-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-27">
<img class="temp-block-img" src="okcc/img/section/9-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-28">
<img class="temp-block-img" src="okcc/img/section/10-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="content-sec drag-main-blocks block-29">
<img class="temp-block-img" src="okcc/img/section/11-content.jpg" title="Drag and Drop" alt="">
</div>

<div class="gallery-sec drag-main-blocks block-30">
<img class="temp-block-img" src="okcc/img/section/1-gallery.jpg" title="Drag and Drop" alt="">
</div>

<div class="gallery-sec drag-main-blocks block-31">
<img class="temp-block-img" src="okcc/img/section/2-gallery.jpg" title="Drag and Drop" alt="">
</div>

<div class="gallery-sec drag-main-blocks block-32">
<img class="temp-block-img" src="okcc/img/section/3-gallery.jpg" title="Drag and Drop" alt="">
</div>

<div class="gallery-sec drag-main-blocks block-33">
<img class="temp-block-img" src="okcc/img/section/4-gallery.jpg" title="Drag and Drop" alt="">
</div>

<div class="pricing-sec drag-main-blocks block-34-c">
<img class="temp-block-img" src="okcc/img/section/4-pricing.jpg" title="Drag and Drop" alt="">
</div>

<div class="pricing-sec drag-main-blocks block-34">
<img class="temp-block-img" src="okcc/img/section/1-pricing.jpg" title="Drag and Drop" alt="">
</div>

<div class="pricing-sec drag-main-blocks block-34-a">
<img class="temp-block-img" src="okcc/img/section/2-pricing.jpg" title="Drag and Drop" alt="">
</div>

<div class="pricing-sec drag-main-blocks block-34-e">
<img class="temp-block-img" src="okcc/img/section/6-pricing.jpg" title="Drag and Drop" alt="">
</div>

<div class="pricing-sec drag-main-blocks block-34-d">
<img class="temp-block-img" src="okcc/img/section/5-pricing.jpg" title="Drag and Drop" alt="">
</div>

<div class="pricing-sec drag-main-blocks block-34-b">
<img class="temp-block-img" src="okcc/img/section/3-pricing.jpg" title="Drag and Drop" alt="">
</div>

<div class="team-sec drag-main-blocks block-35-a">
<img class="temp-block-img" src="okcc/img/section/2-team.jpg" title="Drag and Drop" alt="">
</div>

<div class="team-sec drag-main-blocks block-35">
<img class="temp-block-img" src="okcc/img/section/1-team.jpg" title="Drag and Drop" alt="">
</div>

<div class="team-sec drag-main-blocks block-35-b">
<img class="temp-block-img" src="okcc/img/section/3-team.jpg" title="Drag and Drop" alt="">
</div>

<div class="team-sec drag-main-blocks block-35-c">
<img class="temp-block-img" src="okcc/img/section/4-team.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-d">
<img class="temp-block-img" src="okcc/img/section/1-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-e">
<img class="temp-block-img" src="okcc/img/section/2-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-f">
<img class="temp-block-img" src="okcc/img/section/3-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-g">
<img class="temp-block-img" src="okcc/img/section/4-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-h">
<img class="temp-block-img" src="okcc/img/section/5-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-i">
<img class="temp-block-img" src="okcc/img/section/6-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-j">
<img class="temp-block-img" src="okcc/img/section/7-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="testimony-sec drag-main-blocks block-35-k">
<img class="temp-block-img" src="okcc/img/section/8-testimony.jpg" title="Drag and Drop" alt="">
</div>

<div class="cta-sec drag-main-blocks block-36">
<img class="temp-block-img" src="okcc/img/section/1-cta.jpg" title="Drag and Drop" alt="">
</div>

<div class="cta-sec drag-main-blocks block-36-a">
<img class="temp-block-img" src="okcc/img/section/2-cta.jpg" title="Drag and Drop" alt="">
</div>

<div class="cta-sec drag-main-blocks block-36-b">
<img class="temp-block-img" src="okcc/img/section/3-cta.jpg" title="Drag and Drop" alt="">
</div>

<div class="cta-sec drag-main-blocks block-36-c">
<img class="temp-block-img" src="okcc/img/section/4-cta.jpg" title="Drag and Drop" alt="">
</div>

<div class="cta-sec drag-main-blocks block-36-d">
<img class="temp-block-img" src="okcc/img/section/5-cta.jpg" title="Drag and Drop" alt="">
</div>

<div class="cta-sec drag-main-blocks block-36-e">
<img class="temp-block-img" src="okcc/img/section/6-cta.jpg" title="Drag and Drop" alt="">
</div>

<div class="blog-sec drag-main-blocks block-37">
<img class="temp-block-img" src="okcc/img/section/1-blog.jpg" title="Drag and Drop" alt="">
</div>

<div class="blog-sec drag-main-blocks block-37-a">
<img class="temp-block-img" src="okcc/img/section/2-blog.jpg" title="Drag and Drop" alt="">
</div>

<div class="blog-sec drag-main-blocks block-37-b">
<img class="temp-block-img" src="okcc/img/section/3-blog.jpg" title="Drag and Drop" alt="">
</div>

<div class="blog-sec drag-main-blocks block-37-c">
<img class="temp-block-img" src="okcc/img/section/4-blog.jpg" title="Drag and Drop" alt="">
</div>

<div class="blog-sec drag-main-blocks block-37-d">
<img class="temp-block-img" src="okcc/img/section/5-blog.jpg" title="Drag and Drop" alt="">
</div>

<div class="contact-sec drag-main-blocks block-38">
<img class="temp-block-img" src="okcc/img/section/1-optin.jpg" title="Drag and Drop" alt="">
</div>

<div class="contact-sec drag-main-blocks block-38-a">
<img class="temp-block-img" src="okcc/img/section/2-optin.jpg" title="Drag and Drop" alt="">
</div>

<div class="contact-sec drag-main-blocks block-38-b">
<img class="temp-block-img" src="okcc/img/section/3-optin.jpg" title="Drag and Drop" alt="">
</div>

<div class="contact-sec drag-main-blocks block-38-c">
<img class="temp-block-img" src="okcc/img/section/4-optin.jpg" title="Drag and Drop" alt="">
</div>

<div class="contact-sec drag-main-blocks block-38-d">
<img class="temp-block-img" src="okcc/img/section/5-optin.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39aa">
<img class="temp-block-img" src="okcc/img/section/5-footer.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39ab">
<img class="temp-block-img" src="okcc/img/section/6-footer.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39ac">
<img class="temp-block-img" src="okcc/img/section/7-footer.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39">
<img class="temp-block-img" src="okcc/img/section/1-footer.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39-a">
<img class="temp-block-img" src="okcc/img/section/2-footer.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39-b">
<img class="temp-block-img" src="okcc/img/section/3-footer.jpg" title="Drag and Drop" alt="">
</div>

<div class="footer-sec drag-main-blocks block-39-c">
<img class="temp-block-img" src="okcc/img/section/4-footer.jpg" title="Drag and Drop" alt="">
</div>

<!--
<div class="drag-main-blocks"> you can also add ID
<img class="temp-block-img" src="okcc/img/section/1.jpg" title="Drag and Drop" alt="">
<section class="display-none-dp">
</section>
</div>-->

</div>
		
	<div class="user-save-library">
	</div>
		</div>
	</div>
</div><!-- End Dynamic Sections -->

<!-- Overlay body on active Sections/Blocks -->
<div id="scaledown-overlay"></div>
`);
document.getElementById("dynamic-elements").innerHTML = dynamicElements.join("");
//::End Dynamic Elements

//START:: Show/Hide Hidden elements
$(document).on("click", "#ok-show-hidden-ele-btn", function(e) {
	e.stopImmediatePropagation();
	$(this).hide();
	$("#ok-hide-hidden-ele-btn").show();
	$('.ok-deleted-elements').addClass('ok-temp-show-deleted-elements');
	$('.ok-temp-show-deleted-elements').removeClass('ok-deleted-elements');
});
$(document).on("click", "#ok-hide-hidden-ele-btn", function(e) {
	e.stopImmediatePropagation();
	$(this).hide();
	$("#ok-show-hidden-ele-btn").show();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
});//END:: Show/Hide Hidden elements

//START::Remove Empty Elements
$('font, span').each(function() { 
	if($(this).html().trim() == ''){
		$(this).remove();
	} 
});//END::Remove Empty Elements	

//START::Remove BR tag 
$('#main-textinput-field').each( function(){
    let haystack = $(this).find('span').html().trim();
    let needle = '<br>'; // Tested in Chrome the `<br />` element is converted to `<br>`
    
    if (haystack.indexOf(needle) == 0) {
       $('br').remove();
    }
    else if (haystack.indexOf(needle) == (haystack.length - needle.length)) {
      $('br').remove();
 }
});//END::Remove BR tag

//START:: Add dynamic Block Elements
//mouseenter Section function
$(document).on("mouseenter", '#body-data .ok-section', function(e) {
	e.stopImmediatePropagation();
	//First Removes Dynamic Elements If Exist	
	$('#ok-section-wrap').contents().unwrap();
	$('#section-setting-wrap').remove();
	$(this).parent().children('#ok-section-wrap').contents().unwrap();
	 
	$(this).wrap('<div id="ok-section-wrap" class="ok-border"></div>');
	
	/*/Remove Tos fixed class from navigation menu	
	if($('#ok-section-wrap').find('.ok-section').hasClass('fixed-top')){
		$('#ok-section-wrap').find('.ok-section').removeClass('fixed-top');
	}else{	
		$('.navbar').addClass('fixed-top');
	}*/
	
	//On Hover show Section Toolsok-section
	if ($('#ok-section-wrap').find('.ok-section').hasClass('empty-section')) {
		//Do nothing
	}else if ($('#ok-section-wrap').find('.ok-section').hasClass('ok-header')) {
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr" style="position: absolute!important;bottom:-40px!important;">
				<button id="move-section-up" class="section-menu sbgcolor white pbghover d-cursor" title="Move Up"><i class="fas fa-arrow-up"></i></button>
				<button id="move-section-down" class="section-menu sbgcolor white pbghover d-cursor" title="Move Down"><i class="fas fa-arrow-down"></i></button>
				<!--<button class="add-section section-menu sbgcolor white pbghover d-cursor" title="Add Section"><i class="fas fa-plus"></i></button>-->
				<button id="section-setting" class="section-menu sbgcolor white pbghover d-cursor" title="Section Settings"><i class="fas fa-cog"></i></button>
				<!--<button id="sourcecode-editor" class="section-menu sbgcolor white pbghover d-cursor" title="Block Code Editor" data-bs-toggle="modal" data-bs-target="#codeEditorModal"><i class="fas fa-code"></i></button>-->
				<button id="save-section" class="section-menu sbgcolor white pbghover d-cursor" title="Save Section"><i class="fas fa-save"></i></button>
				<button id="delete-section" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<button id="delete-section-alt" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<div class="conform-delete">
				<p class="white">Are you sure you want to delete this section?</p>
				<p class="white">This item will be deleted immediately. You can't undo this action.</p>
				<button id="yes-delete" class="section-menu d-cursor"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-delete" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
				<div class="conform-save">
				<p class="white">Do you want to save this section?</p>
				<input id="user-block-name" type="text" class="input" plaseholder="Name it">
				<button id="yes-later" class="save-this-section section-menu"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-save" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
			</div>
		`);
	}else if ($('#ok-section-wrap').find('.ok-section').hasClass('ok-header-fixed')) {
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr" style="position: fixed!important;top:40px!important;background: red; height: 40px!important;">
				<button id="ok-show-hidden-ele-btn" class="section-menu sbgcolor white pbghover d-cursor" title="Show hidden elements"><i class="fas fa-eye"></i></button>
				<button id="ok-hide-hidden-ele-btn" class="section-menu sbgcolor white pbghover d-cursor" title="Hide hidden elements"><i class="fas fa-eye-slash"></i></button>
				<!--<button class="add-section section-menu sbgcolor white pbghover d-cursor" title="Add Section"><i class="fas fa-plus"></i></button>-->
				<button id="section-setting" class="section-menu sbgcolor white pbghover d-cursor" title="Section Settings"><i class="fas fa-cog"></i></button>
				<!--<button id="sourcecode-editor" class="section-menu sbgcolor white pbghover d-cursor" title="Block Code Editor" data-bs-toggle="modal" data-bs-target="#codeEditorModal"><i class="fas fa-code"></i></button>-->
				<button id="save-section" class="section-menu sbgcolor white pbghover d-cursor" title="Save Section"><i class="fas fa-save"></i></button>
				<button id="delete-section" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<button id="delete-section-alt" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<div class="conform-delete">
				<p class="white">Are you sure you want to delete this section?</p>
				<p class="white">This item will be deleted immediately. You can't undo this action.</p>
				<button id="yes-delete" class="section-menu d-cursor"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-delete" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
				<div class="conform-save">
				<p class="white">Do you want to save this section?</p>
				<input id="user-block-name" type="text" class="input" plaseholder="Name it">
				<button id="yes-later" class="save-this-section section-menu"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-save" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
			</div>
		`);		
	}else if ($('#ok-section-wrap').find('footer').hasClass('ok-section')) {
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr">
				<!--<button class="add-section section-menu sbgcolor white pbghover d-cursor" title="Add Section"><i class="fas fa-plus"></i></button>-->
				<button id="section-setting" class="section-menu sbgcolor white pbghover d-cursor" title="Section Settings"><i class="fas fa-cog"></i></button>
				<button id="sourcecode-editor" class="section-menu sbgcolor white pbghover d-cursor" title="Block Code Editor" data-bs-toggle="modal" data-bs-target="#codeEditorModal"><i class="fas fa-code"></i></button>
				<button id="save-section" class="section-menu sbgcolor white pbghover d-cursor" title="Save Section"><i class="fas fa-save"></i></button>
				<button id="delete-section" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<button id="delete-section-alt" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<div class="conform-delete">
				<p class="white">Are you sure you want to delete this section?</p>
				<p class="white">This item will be deleted immediately. You can't undo this action.</p>
				<button id="yes-delete" class="section-menu d-cursor"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-delete" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
				<div class="conform-save">
				<p class="white">Do you want to save this section?</p>
				<input id="user-block-name" type="text" class="input" plaseholder="Name it">
				<button id="yes-later" class="save-this-section section-menu"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-save" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
			</div>
		`);		
	}else if ($('#ok-section-wrap').find('.ok-section').hasClass('ok-footer')) {
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr">
				<button id="section-setting" class="section-menu sbgcolor white pbghover" title="Section Settings"><i class="fas fa-cog"></i></button>
			</div>
		`)
	}else if ($(this).hasClass('ok-hide-clone')) {
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr">
				<button id="move-section-up" class="section-menu sbgcolor white pbghover d-cursor" title="Move Up"><i class="fas fa-arrow-up"></i></button>
				<button id="move-section-down" class="section-menu sbgcolor white pbghover d-cursor" title="Move Down"><i class="fas fa-arrow-down"></i></button>
				<button class="add-section section-menu sbgcolor white pbghover d-cursor" title="Add Section"><i class="fas fa-plus"></i></button>
				<button id="section-setting" class="section-menu sbgcolor white pbghover d-cursor" title="Section Settings"><i class="fas fa-cog"></i></button>
				<button id="sourcecode-editor" class="section-menu sbgcolor white pbghover d-cursor" title="Block Code Editor" data-bs-toggle="modal" data-bs-target="#codeEditorModal"><i class="fas fa-code"></i></button>
				<button id="save-section" class="section-menu sbgcolor white pbghover d-cursor" title="Save Section"><i class="fas fa-save"></i></button>
				<button id="delete-section" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<button id="delete-section-alt" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<div class="conform-delete">
				<p class="white">Are you sure you want to delete this section?</p>
				<p class="white">This item will be deleted immediately. You can't undo this action.</p>
				<button id="yes-delete" class="section-menu d-cursor"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-delete" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
				<div class="conform-save">
				<p class="white">Do you want to save this section?</p>
				<input id="user-block-name" type="text" class="input" plaseholder="Name it">
				<button id="yes-later" class="save-this-section section-menu"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-save" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
			</div>
		`);
	}else if($(this).hasClass('bgimage-string')){
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr">
				<button id="move-section-up" class="section-menu sbgcolor white pbghover d-cursor" title="Move Up"><i class="fas fa-arrow-up"></i></button>
				<button id="move-section-down" class="section-menu sbgcolor white pbghover d-cursor" title="Move Down"><i class="fas fa-arrow-down"></i></button>
				<button class="add-section section-menu sbgcolor white pbghover d-cursor" title="Add Section"><i class="fas fa-plus"></i></button>
				<button id="section-setting" class="section-menu sbgcolor white pbghover d-cursor" title="Section Settings"><i class="fas fa-cog"></i></button>
				<button id="sourcecode-editor" class="section-menu sbgcolor white pbghover d-cursor" title="Block Code Editor" data-bs-toggle="modal" data-bs-target="#codeEditorModal"><i class="fas fa-code"></i></button>
				<button id="sec-image-cropping" title="Crop Image" class="section-menu sbgcolor white pbghover d-cursor"><i class="fas fa-crop"></i></button>
				<button id="save-section" class="section-menu sbgcolor white pbghover d-cursor" title="Save Section"><i class="fas fa-save"></i></button>
				<button id="clone-section" class="section-menu sbgcolor white pbghover d-cursor" title="Duplicate Section"><i class="fas fa-clone"></i></button>
				<button id="copy-section" title="Copy Section" class="copy-element section-menu sbgcolor white pbghover d-cursor"><i class="fas fa-clipboard"></i></button>
				<button title="Paste Element Below" class="paste-element section-menu sbgcolor white pbghover d-cursor"><i class="fas fa-paste"></i></button>
				<button id="delete-section" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<button id="delete-section-alt" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<div class="conform-delete">
				<p class="white">Are you sure you want to delete this section?</p>
				<p class="white">This item will be deleted immediately. You can't undo this action.</p>
				<button id="yes-delete" class="section-menu d-cursor"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-delete" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
				<div class="conform-save">
				<p class="white">Do you want to save this section?</p>
				<input id="user-block-name" type="text" class="input" plaseholder="Name it">
				<button id="yes-later" class="save-this-section section-menu"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-save" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
			</div>
		`);
	}else{
		$('#ok-section-wrap').prepend(`
			<div id="section-setting-wrap" dir="ltr">
				<button id="move-section-up" class="section-menu sbgcolor white pbghover d-cursor" title="Move Up"><i class="fas fa-arrow-up"></i></button>
				<button id="move-section-down" class="section-menu sbgcolor white pbghover d-cursor" title="Move Down"><i class="fas fa-arrow-down"></i></button>
				<button class="add-section section-menu sbgcolor white pbghover d-cursor" title="Add Section"><i class="fas fa-plus"></i></button>
				<button id="section-setting" class="section-menu sbgcolor white pbghover d-cursor" title="Section Settings"><i class="fas fa-cog"></i></button>
				<button id="sourcecode-editor" class="section-menu sbgcolor white pbghover d-cursor" title="Block Code Editor" data-bs-toggle="modal" data-bs-target="#codeEditorModal"><i class="fas fa-code"></i></button>
				<button id="save-section" class="section-menu sbgcolor white pbghover d-cursor" title="Save Section"><i class="fas fa-save"></i></button>
				<button id="clone-section" class="section-menu sbgcolor white pbghover d-cursor" title="Duplicate Section"><i class="fas fa-clone"></i></button>
				<button id="copy-section" title="Copy Section" class="copy-element section-menu sbgcolor white pbghover d-cursor"><i class="fas fa-clipboard"></i></button>
				<button title="Paste Element Below" class="paste-element section-menu sbgcolor white pbghover d-cursor"><i class="fas fa-paste"></i></button>
				<button id="delete-section" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<button id="delete-section-alt" class="section-menu sbgcolor white pbghover d-cursor" title="Delete Section"><i class="fas fa-trash-alt"></i></button>
				<div class="conform-delete">
				<p class="white">Are you sure you want to delete this section?</p>
				<p class="white">This item will be deleted immediately. You can't undo this action.</p>
				<button id="yes-delete" class="section-menu d-cursor"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-delete" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
				<div class="conform-save">
				<p class="white">Do you want to save this section?</p>
				<input id="user-block-name" type="text" class="input" plaseholder="Name it">
				<button id="yes-later" class="save-this-section section-menu"><i class="fas fa-check green"></i> <strong>YES</strong></button>
				<button id="cancel-save" class="section-menu d-cursor"><i class="fas fa-times red"></i> <strong>NO</strong></button>
				</div>
			</div>
		`);
	}
});

//Source code editor
$(document).on('click', '#sourcecode-editor', function() {
	//Remove Settings panel
	$('#section-setting-wrap').remove();
	//From swiper slider
	$('.swiper-notification').remove();
	$('#main-menu-panel').hide();
	$('body, html').css('overflow', 'hidden');
	
	//Replace Editor
	$('#editor-ide').html('<textarea id="blockCodeEditor"></textarea>');
	
	//Format HTML Codes
	$("#cleanhtml").val($('#ok-section-wrap').html());
	var gethtmlcode=$("#cleanhtml");
	var htmlSrcVal=$.replace_tag(gethtmlcode.minify());
	var htmlSrcEle=$("<div></div>").html(htmlSrcVal);
		$.prettify_code(htmlSrcEle);
		gethtmlcode.css('white-space', 'pre').show_code($.undo_tag(htmlSrcEle.html()));
	
	//Remove existing editor values
	let codeEditorIdk = CodeMirror.fromTextArea(
	document.getElementById("blockCodeEditor"), 
	{
		lineNumbers		: true,
		smartIndent		: true,
		lineWrapping	: true,
		indentWithTabs	: true,
		htmlMode        : true,
		mode            : 'htmlmixed',
		theme           : "dracula"	
	});
	//Set HTML to CodeMirror Editor
	codeEditorIdk.setOption("theme", "dracula");
	codeEditorIdk.setValue($("#cleanhtml").val());
					
	$(document).on('click', '#saveBlockCodes', function(){
		$('#ok-section-wrap').html(codeEditorIdk.getValue());
		$("#editor-ide").html("");
		$("#cleanhtml").val("");
		$('#main-menu-panel').show();
		$('body, html').css('overflow', 'auto');
		//Tigger on click show video popup
	if($('a').hasClass("popup-video")){
		MediaBox('.popup-video');
	}
	//For Swiper Slider 1 with loop
	if($("#ok-sortable-section .swiper-1").length>0){
		var swiperOneLoop = new Swiper('.swiper-1', {
		slidesPerView: 1,
		spaceBetween: 0, 
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
		});
	}
	//For Swiper Slider 2 with loop
	if($("#ok-sortable-section .swiper-2-no-loop").length>0){
	var swiperTwoNoLoop = new Swiper('.swiper-2-no-loop', {
		slidesPerView: 2,
		spaceBetween: 20, 
		breakpoints: {
		300: {
			slidesPerView: 1,
			spaceBetween: 10
		},
		575: {
			slidesPerView: 1,
			spaceBetween: 10
		},
		767: {
			slidesPerView: 2,
			spaceBetween: 20
		},
		991: {
			slidesPerView: 2,
			spaceBetween: 20
		},
		1199: {
			slidesPerView: 2,
			spaceBetween: 20
		},

		},
		navigation: {
		nextEl: '.swiper-ctrl-next',
		prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	//For Swiper Slider 2 without loop
	if($("#ok-sortable-section .swiper-2").length>0){
	var swiperTwo = new Swiper('.swiper-2', {
		slidesPerView: 2,
		spaceBetween: 20, 
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 2,
				spaceBetween: 20
			},	
		},
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	//For Swiper Slider 3 without loop
	if($("#ok-sortable-section .swiper-3").length>0){
	var swiperThree = new Swiper('.swiper-3', {
		slidesPerView: 3,
		spaceBetween: 20,
		// Responsive breakpoints
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 3,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 3,
				spaceBetween: 20
			},	
		},
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	//For Swiper Slider 4 without loop
	if($("#ok-sortable-section .swiper-4").length>0){
	var swiperFour = new Swiper('.swiper-4', {
		slidesPerView: 4,
		spaceBetween: 20,
		// Responsive breakpoints
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 4,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 4,
				spaceBetween: 20
			},	
		},
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	});
	codeEditorIdk.refresh();
});	
$(document).on('click', '#close-codeeditor', function(){
	$("#editor-ide").html("");
	$("#cleanhtml").val("");
	$('#main-menu-panel').show();
	$('body, html').css('overflow', 'auto');
});
//Move Section Up/Down
$(document).on('click', '#move-section-up', function(){
	$(this).parents('#ok-section-wrap').insertBefore($(this).parents('#ok-section-wrap').prev());
});
$(document).on('click', '#move-section-down', function(){
	$(this).parents('#ok-section-wrap').insertAfter($(this).parents('#ok-section-wrap').next());
});
//Remove Dynamic Elements from main block
$(document).on('mouseenter', '#section-setting-wrap', function(){ 	
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-row').removeClass('active-row row-border');
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove(); 
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();  	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
});

//Delete Section
$(document).on('click', '#delete-section-alt', function(e) {
	e.stopImmediatePropagation();
	$('#section-setting-wrap').remove(); 	 
	$('#ok-section-wrap').contents().unwrap();
});

//Copy Section
$(document).on('click', '#copy-section', function(){
	$('#copy-db').html($('#ok-section-wrap').html());
	$('#copy-db').find('.ok-section').addClass('copyed');
	$('#copy-db').find('#section-setting-wrap').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html('<style>#main-menu-panel button {background: #F50057!important;} .copy-element, #ok-section-wrap .paste-element {display: none!important;} .paste-element {display: none!important;} #ok-section-wrap #section-setting-wrap .paste-element {display: inline-block!important;}</style>');
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: block!important;}</style>');
	}
});
//Section Settings
$(document).on('click', '#section-setting', function() {
 $('#ok-section-wrap').addClass('active-section');
//Section Setting Panel
let sectionPanel = [];
sectionPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="section-setting-header">Section Settings</span>
		<span id="close-panel" class="section-setting-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: HTML SELECTOR -->
			<div id="html-selector-wrap">
			<div class="setting-title html-id">
				<p>HTML Selector</p>
			</div>	
			<div class="settings html-id">
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>HTML ID</p>
							<input id="block-id" class="input" type="text" placeholder="Block ID">
							<p>Eg. home, contact, about etc.</p>
						</td>
					</tr>
				</table>
			</div>
			</div><!-- ::END:: HTML SELECTOR -->
			<!-- ::START:: Width & Height -->
			<div id="block-wh-wrap" class="element-setting-wrap">
			<div class="ok-block-width-height-script setting-title">
				<p>Width & Height</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Width <span id="block-width-count">85</span>%</p>
								<input id="block-width" type="range" min="50" max="100" step="5" value="85" />
							</div>
						</td>
					</tr>
				</table>					
				<table border="0" width="100%" class="block-height-opt">
					<tr>
						<td width="100%">
							<hr>
							<p class="mb-10">Full Height On</p>
							<div class="select">
							<select class="block-height-selection w-100 ok-select-opt">
								<option value="">None</option>
								<option value="vh-100">Desktop Only</option>
								<option value="allvh-100">All Devices</option>
							</select>
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Width & Height -->
			<!-- ::START:: Vertical Alignment -->
			<div id="vertical-align-wrap">
			<div class="setting-title">
				<p>Vertical Alignment</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<select id="section-valign" class="ok-select-opt">
								<option value="">None</option>
								<option value="d-flex align-items-start">Top</option>
								<option value="d-flex align-items-center">Middle</option>
								<option value="d-flex align-items-end">Bottom</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Vertical Alignment -->
			<!-- ::START:: Text Typography -->
			<div id="text-typo-wrap">
			<div class="setting-title">
				<p>Text Typography</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<p>Font Style</p>
							<select class="select-font-style ok-select-opt">
								<option value="">Default</option>
								<option value="font-a">Font A</option>
								<option value="font-b">Font B</option>
							</select>
						</td>
						<td width="50%">
							<p>Font Weight</p>
							<select class="select-font-weight ok-select-opt">
								<option value="">Default</option>
								<option value="fw-normal">Normal</option>
								<option value="fw-bold">Bold</option>
								<option value="fw-bolder">Bolder</option>
								<option value="fw-lighter">Lighter</option>
								<option value="fw-100">100</option>
								<option value="fw-200">200</option>
								<option value="fw-300">300</option>
								<option value="fw-400">400</option>
								<option value="fw-500">500</option>
								<option value="fw-600">600</option>
								<option value="fw-700">700</option>
								<option value="fw-800">800</option>
								<option value="fw-900">900</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Text Color -->
			<!-- ::START:: Text Alignment and Transform -->
			<div id="text-trans-wrap">
			<div class="setting-title">
				<p>Text Transform</p>
			</div>
			<div class="settings">
				<p>Text Transform</p>
				<div class="button-25-wrap">
					<button class="main-case-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-capital-case button button-25" title="Capitalize">
						Aa
					</button>
					<button class="main-upper-case button-25" title="Uppercase">
						AA
					</button>
					<button class="main-lower-case button-25" title="Lowercase">
						aa
					</button>
				</div>
			</div>
			</div><!-- ::END:: Text Alignment and Transform -->
			<!-- ::START:: Font Size -->
			<div id="menu-fs-wrap">
			<div class="setting-title">
				<p>Font Size</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Font Size <span id="menu-fs-count">6</span>px</p>
								<input id="menu-fs" type="range" min="1" max="6" step="1" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Font Size -->
			<!-- ::START:: Padding -->
			<div id="block-padding-wrap" class="element-setting-wrap">
			<div class="ok-block-padding-script setting-title">
				<p>Padding</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Padding <span id="block-padding-count">0</span>px</p>
								<input id="block-padding" type="range" min="0" max="150" step="10" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Padding -->
			<!-- ::START:: Upload BG Image Setting -->
			<div id="section-bg-image">
			<div class="setting-title">
				<p>Background Image</p>
			</div>	
			<div class="settings">
				<div class="table-box">
					<table border="0" width="100%">
						<tr>
							<td width="30%">
								<p>From PC</p>
								<button id="add-section-image" class="upload-image sbgcolor white pbghover no-border" title="Upload Image">
									<i class="fas fa-upload"></i>
								</button>
								<form class="hidden-form" method="post" action="okcc/php/image-uploader.php" enctype="multipart/form-data" target="hiddenBgFrame">
									<input id="bgimg-filename" type="text" name="newfilename">
									<input type="text" name="imguser" value="`+uniqueUser+`">
									<input type="file" name="photo" id="add-main-bgimage" accept=".jpg,.png,.svg,.gif">
									<input id="upload-bgimg" type="submit" name="submit" value="Upload">
								</form>
							</td>
							<td width="70%">
								<p>By URL</p>
								<input class="sec-bg-img-url input" type="text" placeholder="Image by URL">
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<img id="sec-bgimage-preview" src="" alt="">
								<!-- Submit Form without leaving page -->
								<iframe name="hiddenBgFrame" id="main-bgimage-iframe" class="image-upload-iframe">
									Loading...
								</iframe>
							</td>
						</tr>
					</table>
					<div id="main-bgimage-dir" style="overflow: auto;width:100%;height:200px;"></div>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Add/Remove Parallax</p>
								<div class="select">
								<select class="parallax-select-opt w-100 ok-select-opt">
									<option value="">None</option>
									<option value="bg-parallax">Add Parallax</option>
								</select>
								</div>
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Add/Remove Overlay Color</p>
								<div class="select">
								<select class="overlay-select-opt w-100 ok-select-opt">
									<option value="0">None</option>
									<option value="1">Add Overlay</option>
								</select>
								</div>
							</td>
						</tr>
					</table>
					<div class="overlay-opt-wrap color-table table-box">
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Select Overlay Color</p>
								<button id="olay-bgcolor-none" class="global-clr-btn ban-clr-btn" title="None"></button>
								<button id="olay-bgcolor-a" class="bg-a global-clr-btn bdr-a"></button>
								<button id="olay-bgcolor-b" class="bg-b global-clr-btn bdr-b"></button>
								<button id="olay-bgcolor-c" class="bg-c global-clr-btn bdr-c"></button>
								<button id="olay-bgcolor-d" class="bg-d global-clr-btn bdr-d"></button>
								<button id="olay-bgcolor-e" class="bg-e global-clr-btn bdr-e"></button>
								<button id="olay-bgcolor-f" class="bg-f global-clr-btn bdr-f"></button>
								<button id="olay-bgcolor-g" class="bg-g global-clr-btn bdr-g"></button>
								<button id="olay-bgcolor-h" class="bg-h global-clr-btn bdr-h"></button>
								<button id="olay-bgcolor-i" class="bg-i global-clr-btn bdr-i"></button>
								<button id="olay-bgcolor-j" class="bg-j global-clr-btn bdr-j"></button>
								<button id="olay-bgcolor-k" class="bg-k global-clr-btn bdr-k"></button>
							</td>
						</tr>
					</table>				
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<div class="slider-container">
									<p>Opacity <span id="block-opacity-count">0.6</span></p>
									<input id="block-opacity" type="range" min="0" max="1" step="0.1" value="1">
								</div>
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Custom Gradient Background</p>
								<p>
									<button class="main-colors-btn olaygrad-block-a"><strong>G1</strong></button>
									<button class="main-colors-btn olaygrad-block-b"><strong>G2</strong></button>
									<input class="global-gradient-input block-olaygrad-input-a">
									<input class="global-gradient-input block-olaygrad-input-b">
								</p>
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="50%">
								<div class="slider-container">
									<p>Rotation <span class="block-olay-dimension-count">180</span>°</p>
									<input class="block-olay-dimension" type="range" min="40" max="360" step="1" value="180">
								</div>
							</td>
							<td width="50%">
								<div class="slider-container">
									<p>Location <span class="block-olaycolor-stop-count">50</span>%</p>
									<input class="block-olaycolor-stop" type="range" min="0" max="100" step="1" value="50">
								</div>
							</td>
						</tr>
					</table>
					</div>
				</div>
			</div>
			</div><!-- ::END:: Upload BG Image Setting -->
			<!-- ::START:: Background Color -->
			<div class="setting-title">
				<p>Background Color</p>
			</div>
			<div class="settings">
				<div class="color-table table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Select Background Color</p>
							<button id="sec-bgcolor-none" class="global-clr-btn ban-clr-btn" title="None"></button>
							<button id="sec-bgcolor-a" class="bg-a global-clr-btn bdr-a"></button>
							<button id="sec-bgcolor-b" class="bg-b global-clr-btn bdr-b"></button>
							<button id="sec-bgcolor-c" class="bg-c global-clr-btn bdr-c"></button>
							<button id="sec-bgcolor-d" class="bg-d global-clr-btn bdr-d"></button>
							<button id="sec-bgcolor-e" class="bg-e global-clr-btn bdr-e"></button>
							<button id="sec-bgcolor-f" class="bg-f global-clr-btn bdr-f"></button>
							<button id="sec-bgcolor-g" class="bg-g global-clr-btn bdr-g"></button>
							<button id="sec-bgcolor-h" class="bg-h global-clr-btn bdr-h"></button>
							<button id="sec-bgcolor-i" class="bg-i global-clr-btn bdr-i"></button>
							<button id="sec-bgcolor-j" class="bg-j global-clr-btn bdr-j"></button>
							<button id="sec-bgcolor-k" class="bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Custom Gradient Background</p>
								<p>
									<button class="main-colors-btn grad-block-a"><strong>G1</strong></button>
									<button class="main-colors-btn grad-block-b"><strong>G2</strong></button>
									<input class="global-gradient-input block-grad-input-a">
									<input class="global-gradient-input block-grad-input-b">
								</p>
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="50%">
								<div class="slider-container">
									<p>Rotation <span class="block-dimension-count">180</span>°</p>
									<input class="block-dimension" type="range" min="40" max="360" step="1" value="180">
								</div>
							</td>
							<td width="50%">
								<div class="slider-container">
									<p>Location <span class="block-color-stop-count">50</span>%</p>
									<input class="block-color-stop" type="range" min="0" max="100" step="1" value="50">
								</div>
							</td>
						</tr>
					</table>
				</div>
			</div><!-- ::END:: Background Color -->
			<!-- ::START:: Link Color -->
			<div id="nav-link-color-wrap">
			<div class="setting-title">
				<p>Link Color</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Select Color</p>
							<button id="drop-color-none" class="global-clr-btn ban-clr-btn" title="None"></button>
							<button id="drop-color-a" class="bg-a global-clr-btn bdr-a"></button>
							<button id="drop-color-b" class="bg-b global-clr-btn bdr-b"></button>
							<button id="drop-color-c" class="bg-c global-clr-btn bdr-c"></button>
							<button id="drop-color-d" class="bg-d global-clr-btn bdr-d"></button>
							<button id="drop-color-e" class="bg-e global-clr-btn bdr-e"></button>
							<button id="drop-color-f" class="bg-f global-clr-btn bdr-f"></button>
							<button id="drop-color-g" class="bg-g global-clr-btn bdr-g"></button>
							<button id="drop-color-h" class="bg-h global-clr-btn bdr-h"></button>
							<button id="drop-color-i" class="bg-i global-clr-btn bdr-i"></button>
							<button id="drop-color-j" class="bg-j global-clr-btn bdr-j"></button>
							<button id="drop-color-k" class="bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Hover Color</p>
							<button id="drop-hover-color-none" class="global-clr-btn ban-clr-btn" title="None"></button>
							<button id="drop-hover-color-a" class="bg-a global-clr-btn bdr-a"></button>
							<button id="drop-hover-color-b" class="bg-b global-clr-btn bdr-b"></button>
							<button id="drop-hover-color-c" class="bg-c global-clr-btn bdr-c"></button>
							<button id="drop-hover-color-d" class="bg-d global-clr-btn bdr-d"></button>
							<button id="drop-hover-color-e" class="bg-e global-clr-btn bdr-e"></button>
							<button id="drop-hover-color-f" class="bg-f global-clr-btn bdr-f"></button>
							<button id="drop-hover-color-g" class="bg-g global-clr-btn bdr-g"></button>
							<button id="drop-hover-color-h" class="bg-h global-clr-btn bdr-h"></button>
							<button id="drop-hover-color-i" class="bg-i global-clr-btn bdr-i"></button>
							<button id="drop-hover-color-j" class="bg-j global-clr-btn bdr-j"></button>
							<button id="drop-hover-color-k" class="bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Link Color -->
			<!-- ::START:: Sticky Nav Color -->
			<div id="sticky-nav-color">
			<div class="setting-title">
				<p>Sticky Menu</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="33%">
							<p>BG Color</p>
							<button id="sticky-bg" class="sticky global-clr-btn bdr-a"></button>
						</td>
						<td width="33%">
							<p>Color</p>
							<button id="sticky-color" class="global-clr-btn bdr-a"></button>
						</td>
						<td width="33%">
							<p>Hover Color</p>
							<button id="sticky-hover-color" class="global-clr-btn bdr-a"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Sticky Nav Color -->
			<!-- ::START:: Dropdown Nav Color -->
			<div id="dropdown-nav-color">
			<div class="setting-title">
				<p>Dropdown & Offcanvas Menu</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Dropdown Options</p>
							<button id="restore-dropdown" class="btn white bg-dark">Add</button> <button id="delete-dropdown" class="btn white bg-dark">Remove</button>
							<p class="dd-title">Text</p>
							<input class="input" id="dropdown-text" type="text" placeholder="Drop">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Select Background Color</p>
							<button id="drop-bgcolor-none" class="global-clr-btn ban-clr-btn" title="None"></button>
							<button id="drop-bgcolor-a" class="bg-a global-clr-btn bdr-a"></button>
							<button id="drop-bgcolor-b" class="bg-b global-clr-btn bdr-b"></button>
							<button id="drop-bgcolor-c" class="bg-c global-clr-btn bdr-c"></button>
							<button id="drop-bgcolor-d" class="bg-d global-clr-btn bdr-d"></button>
							<button id="drop-bgcolor-e" class="bg-e global-clr-btn bdr-e"></button>
							<button id="drop-bgcolor-f" class="bg-f global-clr-btn bdr-f"></button>
							<button id="drop-bgcolor-g" class="bg-g global-clr-btn bdr-g"></button>
							<button id="drop-bgcolor-h" class="bg-h global-clr-btn bdr-h"></button>
							<button id="drop-bgcolor-i" class="bg-i global-clr-btn bdr-i"></button>
							<button id="drop-bgcolor-j" class="bg-j global-clr-btn bdr-j"></button>
							<button id="drop-bgcolor-k" class="bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Dropdown Nav Color -->
			<!-- ::START:: Menu button -->
			<div id="menu-button-wrap">
			<div class="setting-title">
				<p>Menu Button</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">  
							<p>Menu Button Preview</p>
							<button class="menu-prev bg-a color-c" type="button">
								<i class="fas fa-bars"></i>
							</button>
							<hr>
							<p>Select Color</p>
							<button id="menu-color-none" class="global-clr-btn ban-clr-btn" title="None"></button>
							<button id="menu-color-a" class="bg-a global-clr-btn bdr-a"></button>
							<button id="menu-color-b" class="bg-b global-clr-btn bdr-b"></button>
							<button id="menu-color-c" class="bg-c global-clr-btn bdr-c"></button>
							<button id="menu-color-d" class="bg-d global-clr-btn bdr-d"></button>
							<button id="menu-color-e" class="bg-e global-clr-btn bdr-e"></button>
							<button id="menu-color-f" class="bg-f global-clr-btn bdr-f"></button>
							<button id="menu-color-g" class="bg-g global-clr-btn bdr-g"></button>
							<button id="menu-color-h" class="bg-h global-clr-btn bdr-h"></button>
							<button id="menu-color-i" class="bg-i global-clr-btn bdr-i"></button>
							<button id="menu-color-j" class="bg-j global-clr-btn bdr-j"></button>
							<button id="menu-color-k" class="bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button id="menu-bg-color-none" class="global-clr-btn ban-clr-btn" title="None"></button>
							<button id="menu-bg-color-a" class="bg-a global-clr-btn bdr-a"></button>
							<button id="menu-bg-color-b" class="bg-b global-clr-btn bdr-b"></button>
							<button id="menu-bg-color-c" class="bg-c global-clr-btn bdr-c"></button>
							<button id="menu-bg-color-d" class="bg-d global-clr-btn bdr-d"></button>
							<button id="menu-bg-color-e" class="bg-e global-clr-btn bdr-e"></button>
							<button id="menu-bg-color-f" class="bg-f global-clr-btn bdr-f"></button>
							<button id="menu-bg-color-g" class="bg-g global-clr-btn bdr-g"></button>
							<button id="menu-bg-color-h" class="bg-h global-clr-btn bdr-h"></button>
							<button id="menu-bg-color-i" class="bg-i global-clr-btn bdr-i"></button>
							<button id="menu-bg-color-j" class="bg-j global-clr-btn bdr-j"></button>
							<button id="menu-bg-color-k" class="bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Menu button -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = sectionPanel.join("");

//Add image from directory
$.ajax({
    url: ''+domainName+'/image-dir.php',
    success: function(html) {
       $("#main-bgimage-dir").append(html);
    }
});
$(document).on("click", "#sec-bgimage-preview, #main-bgimage-dir img", function() {
	$('#ok-section-wrap').find('.ok-section').css('background-color', ''); 
	$('#ok-section-wrap').find('.ok-section').css('background', ''); 
	$('#ok-section-wrap').find('.ok-section').removeClass('bgimage-string bg-image bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.ok-section').attr("style", 'background-image: url('+$(this).attr("src")+')');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-image');
});

//Check Parallax
if($('#ok-section-wrap').find('.ok-section').hasClass("bg-parallax")){
	$(".parallax-select-opt option[value=bg-parallax]").attr('selected','selected');
}
//Add Parallax Effect to BG image
$(".parallax-select-opt").on('change', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass("bg-parallax");
    $('#ok-section-wrap').find('.ok-section').addClass(this.value);
});

//Check Dropdown
if($('#ok-section-wrap').find('.nav-item.dropdown').hasClass("ok-deleted-elements")){
	$('#delete-dropdown').removeClass('bg-dark').addClass('bg-primary');
	$('.dd-title, #dropdown-text').hide();
}else{
	$('#restore-dropdown').removeClass('bg-dark').addClass('bg-primary');
}
//Delete Dropdown
$(document).on('click', '#delete-dropdown', function() {
	$(this).removeClass('bg-dark').addClass('bg-primary');
	$('#restore-dropdown').removeClass('bg-primary').addClass('bg-dark');
	$('.nav-item.dropdown').addClass('ok-deleted-elements');
	$('#ok-show-hidden-ele-btn').show();
	$('#ok-hide-hidden-ele-btn, .dd-title, #dropdown-text').hide();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
});
//Restore Dropdown
$(document).on('click', '#restore-dropdown', function(e) {
	e.stopImmediatePropagation();
	$(this).removeClass('bg-dark').addClass('bg-primary');
	$('#delete-dropdown').removeClass('bg-primary').addClass('bg-dark');
	$('.nav-item.dropdown').removeClass('ok-temp-show-deleted-elements ok-deleted-elements');
	$('.dd-title, #dropdown-text').show();
});

//Check Opacity Status
if($('#ok-section-wrap').find('.bg-overlay').length>0){
	$(".overlay-select-opt option[value=1]").attr('selected','selected');
	$('.overlay-opt-wrap').show();
}
//Check Opacity
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-0')){
	$("#block-opacity-count").text('0');
	$("#block-opacity").val('0');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-1')){
	$("#block-opacity-count").text('0.1');
	$("#block-opacity").val('0.1');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-2')){
	$("#block-opacity-count").text('0.2');
	$("#block-opacity").val('0.2');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-3')){
	$("#block-opacity-count").text('0.3');
	$("#block-opacity").val('0.3');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-4')){
	$("#block-opacity-count").text('0.4');
	$("#block-opacity").val('0.4');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-5')){
	$("#block-opacity-count").text('0.5');
	$("#block-opacity").val('0.5');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-6')){
	$("#block-opacity-count").text('0.6');
	$("#block-opacity").val('0.6');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-7')){
	$("#block-opacity-count").text('0.7');
	$("#block-opacity").val('0.7');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-8')){
	$("#block-opacity-count").text('0.8');
	$("#block-opacity").val('0.8');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-9')){
	$("#block-opacity-count").text('0.9');
	$("#block-opacity").val('0.9');
}
if($('#ok-section-wrap').find('.bg-overlay').hasClass('op-10')){
	$("#block-opacity-count").text('1');
	$("#block-opacity").val('1');
}
//:: Overlay BG Opacity
let overlayOpacity = document.getElementById("block-opacity");
overlayOpacity.oninput = function() {
    $("#block-opacity-count").text(this.value);
    $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
    if (this.value == 0) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-0");
    } else if (this.value == 0.1) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-1");
    } else if (this.value == 0.2) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-2");
    } else if (this.value == 0.3) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-3");
    } else if (this.value == 0.4) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-4");
    } else if (this.value == 0.5) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-5");
    } else if (this.value == 0.6) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-6");
    } else if (this.value == 0.7) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-7");
    } else if (this.value == 0.8) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-8");
    } else if (this.value == 0.9) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-9");
    } else if (this.value == 1) {
        $('#ok-section-wrap').find('.bg-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-section-wrap').find('.bg-overlay').addClass("op-10");
    }
};

//Block/Unblock some settings
if($('#ok-section-wrap').find('.navbar').length > 0){
	$("#html-selector-wrap, .block-height-opt, #vertical-align-wrap, #section-bg-image, #block-padding-wrap").hide();
	$('.section-setting-header').text('Menu Settings');
}else{
	$("#html-selector-wrap, .block-height-opt, #vertical-align-wrap, #section-bg-image").show();
	$("#text-typo-wrap, #text-trans-wrap, #menu-fs-wrap, #nav-link-color-wrap, #sticky-nav-color, #dropdown-nav-color, #menu-button-wrap").hide();
}
	
//Check default Block Container width values
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-50")){
	$('#block-width-count').text('50');
	$('#block-width').val('50');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-55")){
	$('#block-width-count').text('55');
	$('#block-width').val('55');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-60")){
	$('#block-width-count').text('60');
	$('#block-width').val('60');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-65")){
	$('#block-width-count').text('65');
	$('#block-width').val('65');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-70")){
	$('#block-width-count').text('70');
	$('#block-width').val('70');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-75")){
	$('#block-width-count').text('75');
	$('#block-width').val('75');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-80")){
	$('#block-width-count').text('80');
	$('#block-width').val('80');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-85")){
	$('#block-width-count').text('85');
	$('#block-width').val('85');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-90")){
	$('#block-width-count').text('90');
	$('#block-width').val('90');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-95")){
	$('#block-width-count').text('95');
	$('#block-width').val('95');
}
if($('#ok-section-wrap').find('.container-fluid').hasClass("cw-100")){
	$('#block-width-count').text('100');
	$('#block-width').val('100');
}
//:: Block Width
let blockWidth = document.getElementById("block-width");
blockWidth.oninput = function() {
    $("#block-width-count").text(this.value);
   $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
	if (this.value == 50) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-50");
    } else if (this.value == 55) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-55");
    } else if (this.value == 60) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-60");
    } else if (this.value == 65) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-65");
    } else if (this.value == 70) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-70");
    } else if (this.value == 75) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-75");
    } else if (this.value == 80) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-80");
    } else if (this.value == 85) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-85");
    } else if (this.value == 90) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-90");
    } else if (this.value == 95) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-95");
    } else if (this.value == 100) {
        $('#ok-section-wrap').find('.container-fluid').removeClass("cw-50 cw-55 cw-60 cw-65 cw-70 cw-75 cw-80 cw-85 cw-90 cw-95 cw-100 container");
        $('#ok-section-wrap').find('.container-fluid').addClass("cw-100");
    }
}
//Check Block Height
if($('#ok-section-wrap').find('.ok-section').hasClass('vh-100')){
	$(".block-height-selection option[value=vh-100]").attr('selected','selected');
}else if($('#ok-section-wrap').find('.ok-section').hasClass('allvh-100')){
	$(".block-height-selection option[value=allvh-100]").attr('selected','selected');
}
//Block Height
$(".block-height-selection").on('change', function() {
	$('#ok-section-wrap').find('.ok-section').removeClass('vh-100 allvh-100');
	$('#ok-section-wrap').find('.ok-section').addClass($(this).val());     
});

//Check default Block Padding values
if($('#ok-section-wrap').find('.ok-section').hasClass("py-0")){
	$('#block-padding-count').text('0');
	$('#block-padding').val('0');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-10")){
	$('#block-padding-count').text('10');
	$('#block-padding').val('10');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-20")){
	$('#block-padding-count').text('20');
	$('#block-padding').val('20');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-30")){
	$('#block-padding-count').text('30');
	$('#block-padding').val('30');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-40")){
	$('#block-padding-count').text('40');
	$('#block-padding').val('40');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-50")){
	$('#block-padding-count').text('50');
	$('#block-padding').val('50');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-60")){
	$('#block-padding-count').text('60');
	$('#block-padding').val('60');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-70")){
	$('#block-padding-count').text('70');
	$('#block-padding').val('70');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-80")){
	$('#block-padding-count').text('80');
	$('#block-padding').val('80');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-90")){
	$('#block-padding-count').text('90');
	$('#block-padding').val('90');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-100")){
	$('#block-padding-count').text('100');
	$('#block-padding').val('100');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-110")){
	$('#block-padding-count').text('110');
	$('#block-padding').val('110');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-120")){
	$('#block-padding-count').text('120');
	$('#block-padding').val('120');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-130")){
	$('#block-padding-count').text('130');
	$('#block-padding').val('130');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-140")){
	$('#block-padding-count').text('140');
	$('#block-padding').val('140');
}
if($('#ok-section-wrap').find('.ok-section').hasClass("py-150")){
	$('#block-padding-count').text('150');
	$('#block-padding').val('150');
}
//:: Block Padding
let blockPadding = document.getElementById("block-padding");
blockPadding.oninput = function() {
    $("#block-padding-count").text(this.value);
   $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
	if (this.value == 0) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-0");
    } else if (this.value == 10) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-10");
    } else if (this.value == 20) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-20");
    } else if (this.value == 30) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-30");
    } else if (this.value == 40) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-40");
    } else if (this.value == 50) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-50");
    } else if (this.value == 60) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-60");
    } else if (this.value == 70) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-70");
    } else if (this.value == 80) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-80");
    } else if (this.value == 90) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-90");
    } else if (this.value == 100) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-100");
    } else if (this.value == 110) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-110");
    } else if (this.value == 120) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-120");
    } else if (this.value == 130) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-130");
    } else if (this.value == 140) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-140");
    } else if (this.value == 150) {
        $('#ok-section-wrap').find('.ok-section').removeClass("py-0 py-10 py-20 py-30 py-40 py-50 py-60 py-70 py-80 py-90 py-100 py-110 py-120 py-130 py-140 py-150");
        $('#ok-section-wrap').find('.ok-section').addClass("py-150");
    }
}

//Check Font Style
if($('#ok-section-wrap .navbar').find('a').hasClass("font-a")){
	$(".select-font-style option[value='font-a']").attr('selected','selected');	
}
if($('#ok-section-wrap .navbar').find('a').hasClass("font-b")){
	$(".select-font-style option[value='font-b']").attr('selected','selected');	
}
	//Check Font Wwight
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-normal")){
		$(".select-font-weight option[value=fw-normal]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-bold")){
		$(".select-font-weight option[value=fw-bold]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-bolder")){
		$(".select-font-weight option[value=fw-bolder]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-lighter")){
		$(".select-font-weight option[value=fw-lighter]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-100")){
		$(".select-font-weight option[value=fw-100]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-200")){
		$(".select-font-weight option[value=fw-200]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-300")){
		$(".select-font-weight option[value=fw-300]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-400")){
		$(".select-font-weight option[value=fw-400]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-500")){
		$(".select-font-weight option[value=fw-500]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-600")){
		$(".select-font-weight option[value=fw-600]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-700")){
		$(".select-font-weight option[value=fw-700]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-800")){
		$(".select-font-weight option[value=fw-800]").attr('selected','selected');
	}
	if($('#ok-section-wrap .navbar').find('a').hasClass("fw-900")){
		$(".select-font-weight option[value=fw-900]").attr('selected','selected');
	}

//Text Font Style
$(document).on('change', '.select-font-style', function() {
	$('#ok-section-wrap .navbar').find('a').removeClass("font-a font-b");
	$('#ok-section-wrap .navbar').find('a').addClass($(this).val());
});
//Text Font Weight
$(document).on('change', '.select-font-weight', function() {
	$('#ok-section-wrap .navbar').find('a').removeClass("fw-normal fw-bold fw-bolder fw-lighter fw-100 fw-200 fw-300 fw-400 fw-500 fw-600 fw-700 fw-800 fw-900");
	$('#ok-section-wrap .navbar').find('a').addClass($(this).val());
});

//Check default Text Transform
if($('#ok-section-wrap .navbar').find('a').hasClass('text-uppercase')){
	$(".main-upper-case").addClass('bg-primary');
}else if($('#ok-section-wrap .navbar').find('a').hasClass('text-lowercase')){
	$(".main-lower-case").addClass('bg-primary');
}else if($('#ok-section-wrap .navbar').find('a').hasClass('text-capitalize')){
	$(".main-capital-case").addClass('bg-primary');
}else{
	$(".main-case-none").addClass('bg-primary');	
}
//Text Transform
$(document).on('click', '.main-case-none', function() {
    $('#ok-section-wrap .navbar').find('a').removeClass('text-lowercase text-uppercase text-capitalize');
	$(".main-upper-case, .main-lower-case, .main-capital-case").removeClass('bg-primary');	
	$(this).addClass('bg-primary');
});	
$(document).on('click', '.main-upper-case', function() {
    $('#ok-section-wrap .navbar').find('a').removeClass('text-lowercase text-uppercase text-capitalize');
    $('#ok-section-wrap .navbar').find('a').addClass('text-uppercase');
	$(".main-case-none, .main-lower-case, .main-capital-case").removeClass('bg-primary');	
	$(this).addClass('bg-primary');
});
$(document).on('click', '.main-lower-case', function() {
    $('#ok-section-wrap .navbar').find('a').removeClass('text-lowercase text-uppercase text-capitalize');
    $('#ok-section-wrap .navbar').find('a').addClass('text-lowercase');
	$(".main-upper-case, .main-case-none, .main-capital-case").removeClass('bg-primary');	
	$(this).addClass('bg-primary');
});
$(document).on('click', '.main-capital-case', function() {
    $('#ok-section-wrap .navbar').find('a').removeClass('text-lowercase text-uppercase text-capitalize');
    $('#ok-section-wrap .navbar').find('a').addClass('text-capitalize');
	$(".main-upper-case, .main-case-none, .main-lower-case").removeClass('bg-primary');	
	$(this).addClass('bg-primary');
});

//Check default menu font size
if($('#ok-section-wrap .navbar').find('a').hasClass('fs-8')){
	$("#menu-fs-count").text('8');
	$("#menu-fs").val('1');
	
}
if($('#ok-section-wrap .navbar').find('a').hasClass('fs-12')){
	$("#menu-fs-count").text('12');
	$("#menu-fs").val('2');
	
}
if($('#ok-section-wrap .navbar').find('a').hasClass('fs-14')){
	$("#menu-fs-count").text('14');
	$("#menu-fs").val('3');
	
}
if($('#ok-section-wrap .navbar').find('a').hasClass('fs-16')){
	$("#menu-fs-count").text('16');
	$("#menu-fs").val('4');
	
}
if($('#ok-section-wrap .navbar').find('a').hasClass('fs-18')){
	$("#menu-fs-count").text('18');
	$("#menu-fs").val('5');
	
}
if($('#ok-section-wrap .navbar').find('a').hasClass('fs-24')){
	$("#menu-fs-count").text('24');
	$("#menu-fs").val('6');
	
}
//::Menu Font Size
let menuFontSize = document.querySelector("#menu-fs");
menuFontSize.oninput = function() {
    $("#menu-fs-count").text(this.value);
    $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
	if (this.value == 1) {
         $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
         $('#ok-section-wrap .navbar').find('a').addClass("fs-8");
		 $("#menu-fs-count").text("8");
	} else if (this.value == 2) {
         $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
         $('#ok-section-wrap .navbar').find('a').addClass("fs-12");
		 $("#menu-fs-count").text("12");
	} else if (this.value == 3) {
         $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
         $('#ok-section-wrap .navbar').find('a').addClass("fs-14");
		 $("#menu-fs-count").text("14");
	} else if (this.value == 4) {
         $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
         $('#ok-section-wrap .navbar').find('a').addClass("fs-16");
		 $("#menu-fs-count").text("16");
	} else if (this.value == 5) {
         $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
         $('#ok-section-wrap .navbar').find('a').addClass("fs-18");
		 $("#menu-fs-count").text("18");
	} else if (this.value == 6) {
         $('#ok-section-wrap .navbar').find('a').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
         $('#ok-section-wrap .navbar').find('a').addClass("fs-24");
		 $("#menu-fs-count").text("24");
	}
}
	
//Sticky BG Color
let stickyBG = $("#sticky-bg");
let stickyPreColor;
let stickyChangeColor = false;
stickyBG.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-bg").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-bg">\n'
			+' .sticky {background: '+tinycolor+'!important;}\n '
			+' .sticky .dropdown-menu {background: '+tinycolor+'!important;}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       stickyChangeColor = false;
       stickyPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!stickyChangeColor && stickyPreColor) {
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-bg").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-bg">\n'
			+' .sticky {background: '+tinycolor+'!important;}\n '
			+' .sticky .dropdown-menu {background: '+tinycolor+'!important;}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       stickyChangeColor = true;
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-bg").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-bg">\n'
			+' .sticky {background: '+tinycolor+'!important;}\n '
			+' .sticky .dropdown-menu {background: '+tinycolor+'!important;}\n '
			+'</style>');
	}
});
//Sticky Color
let stickyColor = $("#sticky-color");
let stickyPreAncColor;
let stickyAncChangeColor = false;
stickyColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-color").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-color">\n'
			+' .sticky .navbar-nav a {color: '+tinycolor+';}\n '
			+' @media (max-width: 991.98px) {\n '
			+'	.navbar-nav a {color: '+tinycolor+';}\n '
			+'}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       stickyAncChangeColor = false;
       stickyPreAncColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!stickyAncChangeColor && stickyPreAncColor) {
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-color").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-color">\n'
			+' .sticky .navbar-nav a {color: '+tinycolor+';}\n '
			+' @media (max-width: 991.98px) {\n '
			+'	.navbar-nav a {color: '+tinycolor+';}\n '
			+'}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       stickyAncChangeColor = true;
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-color").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-color">\n'
			+' .sticky .navbar-nav a {color: '+tinycolor+';}\n '
			+' @media (max-width: 991.98px) {\n '
			+'	.navbar-nav a {color: '+tinycolor+';}\n '
			+'}\n '
			+'</style>');
	}
});
//Sticky Hover Color
let stickyHoverColor = $("#sticky-hover-color");
let stickyPreHoverColor;
let stickyHovChangeColor = false;
stickyHoverColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-hover-color").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-hover-color">\n'
			+' .sticky .navbar-nav a:hover {color: '+tinycolor+';}\n '
			+' @media (max-width: 991.98px) {\n '
			+'	.navbar-nav a:hover {color: '+tinycolor+';}\n '
			+'}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       stickyHovChangeColor = false;
       stickyPreHoverColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!stickyHovChangeColor && stickyPreHoverColor) {
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-hover-color").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-hover-color">\n'
			+' .sticky .navbar-nav a:hover {color: '+tinycolor+';}\n '
			+' @media (max-width: 991.98px) {\n '
			+'	.navbar-nav a:hover {color: '+tinycolor+';}\n '
			+'}\n '
			+'</style>');	
		}
	},
   change: function(tinycolor) {
       stickyHovChangeColor = true;
		$(this).css("background", tinycolor.toRgbString());
		$("#ok-db #db-sticky-hover-color").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-sticky-hover-color">\n'
			+' .sticky .navbar-nav a:hover {color: '+tinycolor+';}\n '
			+' @media (max-width: 991.98px) {\n '
			+'	.navbar-nav a:hover {color: '+tinycolor+';}\n '
			+'}\n '
			+'</style>');	
	}
});

//Collect Default Values
$('#block-id').val($(this).parent().parent().find('.ok-section').attr('id'));
if($('#ok-section-wrap').find('.ok-section').hasClass('bg-image')){
	$('#sec-bgimage-preview').attr('src', $(this).parent().parent().find('.ok-section').css('background-image').replace(/^url\(['"](.+)['"]\)/, '$1'));	
}else{
	$('#sec-bgimage-preview').attr('src', 'okcc/img/img.svg');
}
// Section Vertical alignment Check
if($('#ok-section-wrap').find('.ok-section').hasClass("align-items-start")){
	$("#section-valign option[value='d-flex align-items-start']").attr('selected','selected');
}else if($('#ok-section-wrap').find('.ok-section').hasClass("align-items-center")) {
	$("#section-valign option[value='d-flex align-items-center']").attr('selected','selected');	
}else if($('#ok-section-wrap').find('.ok-section').hasClass("align-items-end")){
	$("#section-valign option[value='d-flex align-items-end']").attr('selected','selected');
}else{
	$("#section-valign option[value='']").attr('selected','selected');
}
// Section Vertical alignment
$("#section-valign").change(function() {
	$('#ok-section-wrap').find('.ok-section').removeClass("d-flex align-items-start align-items-center align-items-end");
	$('#ok-section-wrap').find('.ok-section').addClass($(this).val());
});

//Add HTML Selector to the Section
$(document).on('input', '#block-id', function(){
	$("#block-id").each(function() {//Remove special characters except hyphen
		this.value = this.value.replace(/[^a-z0-9\s]/gi, '-').replace(/[_\s]/g, '-');
		//this.value = this.value.replace(/[_\s]/g, '-');
	});//Change case to Lower Case
	$("#block-id").val($("#block-id").val().toLowerCase());
    $('#ok-section-wrap').find('.ok-section').attr('id', this.value);
});
	//Add BG Image from Desktop
	$("#add-section-image").on('click', function(){
		$('#add-main-bgimage').click();
	});
	$("#add-main-bgimage").change(function(){
		$("#main-bgimage-iframe").hide();//Hide file upload messages
		$("#add-section-image").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
		let newBgFileName = 'id'+uniqueUser+(new Date()).getTime();//set unique image name
		let ymdHmsBg = document.getElementById("bgimg-filename").value = newBgFileName;
		//Get the file input element by its id 
		var bGfileInput = document.getElementById('add-main-bgimage');
		//Get the file name
		var bGfileName = bGfileInput.files[0].name;
		//Get the file Extension 
		var bGfileExtension = bGfileName.split('.').pop();
		$('#upload-bgimg').click();
		$('#main-bgimage-iframe').on('load', function() {	
			$('#ok-section-wrap').find('.ok-section').css('background-color', ''); 
			$('#ok-section-wrap').find('.ok-section').css('background', '');
			$('#ok-section-wrap').find('.ok-section').removeClass('bgimage-string bg-image bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');			
			let bgImgSrc = "url(assets/img/"+uniqueUser+"/"+ymdHmsBg+"."+bGfileExtension+")";
				$('#ok-section-wrap').find('.ok-section').css('background-image', ''+bgImgSrc+'');
			//$('#ok-section-wrap').find('.ok-section').attr("style", 'background-image: url('+domainName+'/assets/img/'+ymdHmsBg+'.'+bGfileExtension+')');
			$('#sec-bgimage-preview').attr('src', 'assets/img/'+uniqueUser+'/'+ymdHmsBg+'.'+bGfileExtension);
			$('#ok-section-wrap').find('.ok-section').addClass('bgimage-string');
			$('#ok-section-wrap').find('.ok-section').addClass('bg-image');
			
			if($("#main-bgimage-iframe").contents().find('#sucess-info').length>0){
				$("#add-section-image").html('<i class="fas fa-upload"></i>');
			}
			$("#main-bgimage-iframe").show();//Show file upload messages
		});
	});
	
//Add BG Image from URL	
$(document).on("input", ".sec-bg-img-url", function() {	
	$('#ok-section-wrap').find('.ok-section').css('background-color', ''); 
	$('#ok-section-wrap').find('.ok-section').css('background', ''); 
	$('#ok-section-wrap').find('.ok-section').removeClass('bgimage-string bg-image bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.ok-section').attr("style", 'background-image: url('+this.value+')');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-image');
	$('#sec-bgimage-preview').attr('src', this.value);
});

//Get default drop text value
$("#dropdown-text").val($('#dropdown01').text());
//Dropdown Text
$(document).on("input", "#dropdown-text", function() {
	$('#dropdown01').text(this.value);
});

//:: Block Primary Gradiant Color A
let blockOlayBgApicker = $(".olaygrad-block-a");
let previousOlayApickerСolor;
let isOlayApickerCange = false;
blockOlayBgApicker.spectrum({
    containerClassName: "color-box",
    showAlpha: true,
    showInput: true,
	showButtons: false,
    preferredFormat: "hex",
    move: function(tinycolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-olaygrad-input-a").val(tinycolor.toRgbString());

    },
    show: function(tinycolor) {
        isOlayApickerCange = false;
        previousOlayApickerСolor = tinycolor;
    },
    hide: function(tinycolor) {
        if (!isOlayApickerCange && previousOlayApickerСolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-olaygrad-input-a").val(tinycolor.toRgbString());
        }
    },
    change: function(tinycolor) {
        isOlayApickerCange = true;
        $(this).css("background", tinycolor.toRgbString());
        $(".block-olaygrad-input-a").val(tinycolor.toRgbString());
    }
});
//:: Block Gradiant Color B
let blockOlayBgBpicker = $(".olaygrad-block-b");
let previousOlayBpickerСolor;
let isOlayBpickerCange = false;
blockOlayBgBpicker.spectrum({
    containerClassName: "color-box",
    showAlpha: true,
    showInput: true,
	showButtons: false,
    preferredFormat: "hex",
    move: function(tinycolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-olaygrad-input-b").val(tinycolor.toRgbString());
    },
    show: function(tinycolor) {
        isOlayBpickerCange = false;
        previousOlayBpickerСolor = tinycolor;
    },
    hide: function(tinycolor) {
        if (!isOlayBpickerCange && previousOlayBpickerСolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-olaygrad-input-b").val(tinycolor.toRgbString());
        }
    },
    change: function(tinycolor) {
        isOlayBpickerCange = true;
        $(this).css("background", tinycolor.toRgbString());
        $(".block-olaygrad-input-b").val(tinycolor.toRgbString());
    }
});	
//:: Block Gradient Dimension
let sliderAblock = document.querySelector(".block-olay-dimension");
sliderAblock.oninput = function() {
    $(".block-olay-dimension-count").text(this.value)
};	
//:: Primary Gradient Color Stop
let sliderBblock = document.querySelector(".block-olaycolor-stop");
sliderBblock.oninput = function() {
    $(".block-olaycolor-stop-count").text(this.value)
};
//:: Set Primary Gradiant AB
let bgBlockOvlay1 = document.querySelector(".block-olaygrad-input-a");
let bgBlockOvlay2 = document.querySelector(".block-olaygrad-input-b");
let rangeBlockOvlay = document.querySelector(".block-olay-dimension");
let colorstopBlockOvlay = document.querySelector(".block-olaycolor-stop");
function updateBlockGradOlay() {
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$("#ok-section-wrap").find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$("#ok-section-wrap").find('.bg-overlay').css('background-image', `linear-gradient(${rangeBlockOvlay.value}deg, ${bgBlockOvlay1.value}, ${colorstopBlockOvlay.value}%, ${bgBlockOvlay2.value})`);
}
bgBlockOvlay1.value = "#aa66cc", 
bgBlockOvlay2.value = "#e2b5f8", 
rangeBlockOvlay.value = "180", 
colorstopBlockOvlay.value = "50%", 
bgBlockOvlay1.addEventListener("change", updateBlockGradOlay), 
bgBlockOvlay2.addEventListener("change", updateBlockGradOlay), 
rangeBlockOvlay.addEventListener("input", updateBlockGradOlay),
colorstopBlockOvlay.addEventListener("input", updateBlockGradOlay);

//:: Block Primary Gradiant Color A
let blockBgApicker = $(".grad-block-a");
let previousBlockApickerСolor;
let isBlockApickerCange = false;
blockBgApicker.spectrum({
    containerClassName: "color-box",
    showAlpha: true,
    showInput: true,
	showButtons: false,
    preferredFormat: "hex",
    move: function(tinycolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-grad-input-a").val(tinycolor.toRgbString());

    },
    show: function(tinycolor) {
        isBlockApickerCange = false;
        previousBlockApickerСolor = tinycolor;
    },
    hide: function(tinycolor) {
        if (!isBlockApickerCange && previousBlockApickerСolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-grad-input-a").val(tinycolor.toRgbString());
        }
    },
    change: function(tinycolor) {
        isBlockApickerCange = true;
        $(this).css("background", tinycolor.toRgbString());
        $(".block-grad-input-a").val(tinycolor.toRgbString());
    }
});
//:: Block Gradiant Color B
let blockBgBpicker = $(".grad-block-b");
let previousBlockBpickerСolor;
let isBlockBpickerCange = false;
blockBgBpicker.spectrum({
    containerClassName: "color-box",
    showAlpha: true,
    showInput: true,
	showButtons: false,
    preferredFormat: "hex",
    move: function(tinycolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-grad-input-b").val(tinycolor.toRgbString());
    },
    show: function(tinycolor) {
        isBlockBpickerCange = false;
        previousBlockBpickerСolor = tinycolor;
    },
    hide: function(tinycolor) {
        if (!isBlockBpickerCange && previousBlockBpickerСolor) {
        $(this).css("background", tinycolor.toRgbString());
        $(".block-grad-input-b").val(tinycolor.toRgbString());
        }
    },
    change: function(tinycolor) {
        isBlockBpickerCange = true;
        $(this).css("background", tinycolor.toRgbString());
        $(".block-grad-input-b").val(tinycolor.toRgbString());
    }
});	
//:: Block Gradient Dimension
let sliderCblock = document.querySelector(".block-dimension");
sliderCblock.oninput = function() {
    $(".block-dimension-count").text(this.value)
};	
//:: Primary Gradient Color Stop
let sliderDblock = document.querySelector(".block-color-stop");
sliderDblock.oninput = function() {
    $(".block-color-stop-count").text(this.value)
};
//:: Set Primary Gradiant AB
let bgBlock1 = document.querySelector(".block-grad-input-a");
let bgBlock2 = document.querySelector(".block-grad-input-b");
let rangeBlock = document.querySelector(".block-dimension");
let colorstopBlock = document.querySelector(".block-color-stop");
function updateBlockGrad() {
	$('#ok-section-wrap').find('.ok-section').css({'background-image': '', 'background': ''});
	$('#ok-section-wrap').find('.bg-overlay').remove();
	$('#ok-section-wrap').find('.container-fluid').removeClass('layer-2');
	$('.overlay-opt-wrap').hide();
	//Set Default Values
	$('#sec-bgimage-preview').attr('src', 'okcc/img/img.svg');
	$(".parallax-select-opt option[value='']").attr('selected','selected');
	$(".overlay-select-opt option[value=0]").attr('selected','selected');
	//Add Color
	$("#ok-section-wrap").find('.ok-section').removeClass('bgimage-string bg-parallax bg-image bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$("#ok-section-wrap").find('.ok-section').css('background-image', `linear-gradient(${rangeBlock.value}deg, ${bgBlock1.value}, ${colorstopBlock.value}%, ${bgBlock2.value})`);
}
bgBlock1.value = "#aa66cc", 
bgBlock2.value = "#e2b5f8", 
rangeBlock.value = "180", 
colorstopBlock.value = "50%", 
bgBlock1.addEventListener("change", updateBlockGrad), 
bgBlock2.addEventListener("change", updateBlockGrad), 
rangeBlock.addEventListener("input", updateBlockGrad),
colorstopBlock.addEventListener("input", updateBlockGrad);
});//End section settings

//Clone/Duplicate Section
$(document).on('click', '#clone-section', function(e){
	e.preventDefault();
	$('#ok-section-wrap').find('.ok-section').clone().insertAfter('#ok-section-wrap');
});
//Save Section Section
$(document).on('click', '#save-section', function(){
	$('.conform-save').addClass('conform-delete-on');	
	$('.conform-delete').removeClass('conform-delete-on');
	$('#sourcecode-editor, #ok-show-hidden-ele-btn, #ok-hide-hidden-ele-btn, #move-section-up, #move-section-down, #section-setting-wrap .add-section, #copy-section, #section-setting, #save-section, #clone-section, #delete-section').hide();
});
//Cancel Save Section
$(document).on('click', '#cancel-save', function(){
	$('.conform-save').removeClass('conform-delete-on');	
});
//Name save section
$(document).on('input', '#user-block-name', function(){
	if($(this).length > 0 && $(this).val() != ''){
		$('.save-this-section').addClass('d-cursor');
		$('.save-this-section').attr('id', 'yes-save');
	}else{		
		$('.save-this-section').removeClass('d-cursor');
		$('.save-this-section').attr('id', 'yes-later');
	}
});
//Save Section
$(document).on('click', '#yes-save', function(){
	var blockName = document.getElementById('user-block-name').value;
	$('<div class="drag-main-blocks user-saved-blocks"><div class="name-user-block temp-block-img" title="Drag and Drop"><img src="okcc/img/img.svg" alt=""><span class="name-wrap">'+blockName+'</span></div>'+$('#ok-section-wrap').html()+'</div>').appendTo('#user-section-library');
	$('.user-saved-blocks .ok-section').addClass('display-none-dp');
	$('.user-saved-blocks #section-setting-wrap').remove();
	$('.conform-save').removeClass('conform-delete-on');
});
//Delete Info
$(document).on('click', '#delete-section', function(){
	$('.conform-delete').addClass('conform-delete-on');		
	$('.conform-save').removeClass('conform-delete-on');
	$('#sourcecode-editor, #ok-show-hidden-ele-btn, #ok-hide-hidden-ele-btn, #move-section-up, #move-section-down, #section-setting-wrap .add-section, #copy-section, #section-setting, #save-section, #clone-section, #delete-section').hide();	
//Check for Empty Section
$(document).on("click", "#yes-delete", function() {
	// If Section is Empty
	if ($('#ok-sortable-section').html().trim() == '') {
		$('#ok-sortable-section').html(`
			<div class="ok-section empty-section" dir="ltr"> 
				<div class="empty-section-wrap">
					<button class="add-section empty-button" title="Add Section">Blank Website <br> <span style="font-size: 32px;"><i class="fas fa-plus"></i> Clck to add New Elements or Blocks</span></button>
				</div>
			</div>
		`);
	}
});
//Check for Header/Footer Blocks
$(document).on("click", "#yes-delete", function() {
	//Hide Nav if exist
	if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
		$('.nav-sec').hide();
	}else{
		$('.nav-sec').show();
	}
	//Hide Footer if exist
	if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
		$('.footer-sec').hide();
	}else{
		$('.footer-sec').show();
	}
});
});
//Cancel Delete Section
$(document).on('click', '#cancel-delete', function(){
	$('.conform-delete').removeClass('conform-delete-on');	
});
//Delete Section
$(document).on('click', '#yes-delete', function(){
	$(this).parent().parent().parent().remove();	
});//END:: Add dynamic Block Elements

//START:: Main Menu Panel
$(document).on('mouseover', '#main-menu-btn', function() {
	//First Removes Dynamic Elements If Exist	
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-row').removeClass('active-row row-border');
	$('.ok-column').removeClass('column-border ok-column-handle');
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#ok-section-wrap').contents().unwrap();
	$('#section-setting-wrap').remove();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	//Remove Draggable supporters
	$('#ok-sortable-section, #ok-sortable-section header, #ok-sortable-section section, #ok-sortable-section footer, #ok-sortable-section div, #ok-sortable-section h1, #ok-sortable-section h2, #ok-sortable-section h3, #ok-sortable-section h4, #ok-sortable-section h5, #ok-sortable-section h6, #ok-sortable-section p, #ok-sortable-section a, #ok-sortable-section img, #ok-sortable-section button, #ok-sortable-section form').removeAttr('role aria-grabbed aria-dropeffect');
});//END::  Main Menu Panel

//Add Section
$(document).on('click', '.add-section', function(){
	$('.section-box').addClass('section-box-on');
	$('#body-data').addClass('scaledown-main-content');
	$('#scaledown-overlay').show();
	//For Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();
	//Change Empty text
	if ($('#ok-sortable-section').find('.add-section.empty-button').length > 0) {
		$('.add-section.empty-button').html('Blank Website <br> <span style="font-size: 32px;">Get Started by <strong>Dragging and Dropping</strong> New Elements or Blocks</span>');
	}
	$('.user-save-library').html($('#user-section-library').html());
	//Hide Nav if exist
	if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
		$('.nav-sec').hide();
	}else{
		$('.nav-sec').show();
	}
	//Hide Footer if exist
	if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
		$('.footer-sec').hide();
	}else{
		$('.footer-sec').show();
	}
});

//Active Elements Library
$(document).on('click', '#elements-switch', function(){
	$(this).css('color', '#3700fa');
	$('#block-switch').css('color', '#333333');
	$('.layout-library, .element-library').css('display', 'inline-block');
	$('.section-list-wrap, .user-save-library, #block-list-opt').css('display', 'none');
});
//Active Premade Blocks Library
$(document).on('click', '#block-switch', function(){
	$(this).css('color', '#3700fa');
	$('#elements-switch').css('color', '#333333');
	$('.section-list-wrap, .user-save-library, #block-list-opt').css('display', 'inline-block');
	$('.layout-library, .element-library').css('display', 'none');	
	//Hide Nav if exist
	if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
		$('.nav-sec').hide();
	}else{
		$('.nav-sec').show();
	}
	//Hide Footer if exist
	if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
		$('.footer-sec').hide();
	}else{
		$('.footer-sec').show();
	}
});

//Close Section Popup Box
$(document).on('click', '#close-section, #scaledown-overlay', function(){
	$('header.ok-section').removeClass('first-section');
	$('header.ok-section').removeAttr('style');
	$('.section-box').removeClass('section-box-on');
	$('#body-data').removeClass('scaledown-main-content');	//Change Empty text
	if ($('#ok-sortable-section').find('.add-section.empty-button').length > 0) {
		$('.add-section.empty-button').html('Blank Website <br> <span style="font-size: 32px;"><i class="fas fa-plus"></i> Clck to add New Elements or Blocks</span>');
	}
	$('#scaledown-overlay').hide();
	//For Swiper Slider 1 with loop
	var swiperOneLoop = new Swiper('.swiper-1', {
	slidesPerView: 1,
	spaceBetween: 0, 
	// Navigation arrows
	navigation: {
		nextEl: '.swiper-ctrl-next',
		prevEl: '.swiper-ctrl-prev',
	}
	});
	//For Swiper Slider 2 without loop
	var swiperTwo = new Swiper('.swiper-2', {
		slidesPerView: 2,
		spaceBetween: 20, 
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 2,
				spaceBetween: 20
			},	
		},
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	//For Swiper Slider 3 without loop
	var swiperThree = new Swiper('.swiper-3', {
		slidesPerView: 3,
		spaceBetween: 20,
		// Responsive breakpoints
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 3,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 3,
				spaceBetween: 20
			},	
		},
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	//For Swiper Slider 4 without loop
	var swiperFour = new Swiper('.swiper-4', {
		slidesPerView: 4,
		spaceBetween: 20,
		// Responsive breakpoints
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 4,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 4,
				spaceBetween: 20
			},	
		},
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
});

// Main Layout Block Drag
const layoutSortable = sortable('.layout-library', {
	copy: true,
	acceptFrom: false,
    forcePlaceholderSize: true,
	items: ':not(.element-title)',
	hoverClass: 'sortable-chosen',
	placeholderClass: 'sortable-chosen',
});
layoutSortable[0].addEventListener('sortstart', function(e) {	
	$("#body-data").addClass('scaledown-main-content');
	$("#scaledown-overlay").hide();
	$('#body-data .ok-section').addClass('drag-temp-col');
	
	//Tigger Layot Drag and Drop
	const tiggerLayout = sortable('#ok-sortable-section, .ok-column, .container-fluid:not(header.navbar .container-fluid)', {
		acceptFrom: '.layout-library',
		forcePlaceholderSize: true,
		handle: '.none',
		placeholderClass: 'sortable-chosen',
	});
	
	//Add extra padding to smooth the drag and drop events
	$('.container-fluid:not(header.navbar .container-fluid), .ok-row:not(header.navbar .container-fluid)').addClass('temp-padding');
});
layoutSortable[0].addEventListener('sortstop', function(e) {
	//Remove extra padding to smooth the drag and drop events
	$('.container-fluid, .ok-row').removeClass('temp-padding');
	
	//::START:: Layout Blocks with currosponded images
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-element')){
	$('#ok-sortable-section .column-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-2-element')){
	$('#ok-sortable-section .column-2-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
		<button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
      </div>
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
		<button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-3-element')){
	$('#ok-sortable-section .column-3-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
		<div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
			<button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
		</div>
		<div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
			<button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
		</div>
		<div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 col-md-12">
			<button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
		</div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-4-element')){
	$('#ok-sortable-section .column-4-element').append(`
<section class="ok-section py-70">
   <div class="container-fluid cw-80">
      <div class="row ok-row">
         <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
      </div>
   </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-5-element')){
	$('#ok-sortable-section .column-5-element').append(`
<section class="ok-section py-70">
   <div class="container-fluid cw-80">
      <div class="row ok-row">
         <div class="ok-column col-md-6 col-sm-12 col-xl-7 col-xxl-7 col-lg-7">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xl-5 col-xxl-5 col-lg-5">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
      </div>
   </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-6-element')){
	$('#ok-sortable-section .column-6-element').append(`
<section class="ok-section py-70">
   <div class="container-fluid cw-80">
      <div class="row ok-row">
         <div class="ok-column col-md-6 col-sm-12 col-xl-5 col-xxl-5 col-lg-5">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xl-7 col-xxl-7 col-lg-7">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
      </div>
   </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-7-element')){
	$('#ok-sortable-section .column-7-element').append(`
<section class="ok-section py-70">
   <div class="container-fluid cw-80">
      <div class="row ok-row">
         <div class="ok-column col-md-6 col-sm-12 col-xl-8 col-xxl-8 col-lg-8">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
      </div>
   </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('column-8-element')){
	$('#ok-sortable-section .column-8-element').append(`
<section class="ok-section py-70">
   <div class="container-fluid cw-80">
      <div class="row ok-row">
         <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
         <div class="ok-column col-md-6 col-sm-12 col-xl-8 col-xxl-8 col-lg-8">
            <button class="add-section add-element-btn" title="Add Element"><i class="fas fa-plus"></i> Add Element</button>
         </div>
      </div>
   </div>
</section>`);
	}
	
	//Remove extra if append inside Container element
	if($('#body-data .container-fluid .drag-main-blocks').length>0){
		$('#body-data .drag-main-blocks .container-fluid').contents().unwrap();
		$('#body-data .drag-main-blocks .ok-section').contents().unwrap();
	}
	//::END:: Layout with currosponded images
	$('#body-data .ok-section').removeClass('drag-temp-col');
	$('#body-data .drag-main-blocks').each(function() { 
		if ($(this).length > 0){
			$(this).find('.temp-block-img').remove();
			$(this).find('.ok-section').removeClass('display-none-dp');
			$(this).contents().unwrap();
		} 
	});	
	
	$("#scaledown-overlay").show();	
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
	//If block is not added
	if ($('#ok-sortable-section').html().trim() == '') {
		$('#ok-sortable-section').html(`
			<div class="ok-section empty-section" dir="ltr"> 
				<div class="empty-section-wrap">
					<button class="add-section empty-button" title="Add Section">Blank Website <br> <span style="font-size: 32px;">Get Started by <strong>Dragging and Dropping</strong> New Elements or Blocks</span></button>
				</div>
			</div>
		`);
	}
	//For empty slider
	$('.swiper-wrapper').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">'
            +' <div class="card-body p-20 text-center">'
			+' 	<img src="'+domainName+'/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">'
			+'	<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>'
            +' </div>'
            +'</div>'
			+'');
		} 
	});
	//For empty column, container and others
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
	//Hide Nav if exist
	if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
		$('.nav-sec').hide();
	}
	//Hide Footer if exist
	if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
		$('.footer-sec').hide();
	}
});
layoutSortable[0].addEventListener('sortupdate', function(e) {
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
});
//Elements block Drag
const elementSortable = sortable('.element-library', {
	copy: true,
	acceptFrom: false,
    forcePlaceholderSize: true,
	items: ':not(.element-title)',
	hoverClass: 'sortable-chosen',
	placeholderClass: 'sortable-chosen',
});
elementSortable[0].addEventListener('sortstart', function(e) {	
	$("#body-data").addClass('scaledown-main-content');
	$("#scaledown-overlay").hide();
	$('#body-data .ok-section').addClass('drag-temp-col');
	//Add extra padding to smooth the drag and drop events
	$('.ok-column, .ok-card, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').addClass('temp-padding');
	
	//Set classes for block elements
	if($('.image-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='image-element';
	}else if($('.icon-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='icon-element';
	}else if($('.video-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='video-element';
	}else if($('.card-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='card-element';
	}else if($('.card-top-image-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='card-top-image-element';
	}else if($('.card-bottom-image-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='card-bottom-image-element';
	}else if($('.card-overlay-image-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='card-overlay-image-element';
	}else if($('.rounded-image-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='rounded-image-element';
	}else if($('.gallery-pop-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='gallery-pop-element';
	}else if($('.gallery-2-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='gallery-2-element';
	}else if($('.video-image-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='video-image-element';
	}else if($('.custom-code-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='custom-code-element';
	}else if($('.container-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='container-element';
	}else if($('.map-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='map-element';
	}else if($('.contact-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='contact-element';
	}else if($('.optin-form1-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='optin-form1-element';
	}else if($('.optin-form2-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='optin-form2-element';
	}else if($('.slider-1-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='slider-1-element';
	}else if($('.slider-2-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='slider-2-element';
	}else if($('.slider-4-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='slider-4-element';
	}else if($('.slider-3-element').hasClass('sortable-chosen')){
		document.getElementById('drop-ele-classes').innerHTML ='slider-3-element';
	}else{
		document.getElementById('drop-ele-classes').innerHTML ='nothing';
	}
	let dropEleClasses = document.getElementById('drop-ele-classes').innerHTML;
	//Tigger Elements Drag and Drop
	const tiggerElements = sortable('#ok-sortable-section, .ok-column, .ok-group-container, .card-body:not(.overlay-container .card-body), .card-body.card-img-overlay > div:nth-of-type(1)', {
		acceptFrom: '.element-library',
		forcePlaceholderSize: true,
		handle: '.none',
		placeholderClass: 'sortable-chosen '+dropEleClasses+'',
	});
	
	
});
elementSortable[0].addEventListener('sortstop', function(e) {
	//Remove extra padding
	$('.ok-column, .ok-card, .card-body, .ok-group-container, .card-body.card-img-overlay div:nth-of-type(1)').removeClass('temp-padding');
	//::START:: Blocks with currosponded images
	if($('#ok-sortable-section .drag-main-blocks').hasClass('h1-element')){
	$('#ok-sortable-section .h1-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<h1 class="ok-text mt-0 mb-0 color-e fs-32 fw-bold mt-5 mb-5">H1 Tag Added</h1>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('h2-element')){
	$('#ok-sortable-section .h2-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<h2 class="ok-text mt-0 mb-0 color-e fs-24 fw-bold mt-5 mb-5">H2 Tag Added</h2>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('h3-element')){
	$('#ok-sortable-section .h3-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<h3 class="ok-text mt-0 mb-0 color-e fs-18 fw-bold mt-5 mb-5">H3 Tag Added</h3>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('h4-element')){
	$('#ok-sortable-section .h4-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<h4 class="ok-text mt-0 mb-0 color-e fs-16 fw-bold mt-5 mb-5">H4 Tag Added</h4>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('h5-element')){
	$('#ok-sortable-section .h5-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<h5 class="ok-text mt-0 mb-0 color-e fs-14 fw-bold mt-5 mb-5">H5 Tag Added</h5>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('h6-element')){
	$('#ok-sortable-section .h6-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<h6 class="ok-text mt-0 mb-0 color-e fs-12 fw-bold mt-5 mb-5">H6 Tag Added</h6>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('text-element')){
	$('#ok-sortable-section .text-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<p class="ok-text lh-base fs-16 color-k mt-5 mb-5">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('image-element')){
	$('#ok-sortable-section .image-element:not(.ok-group-container .image-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<img src="`+domainName+`/assets/img/service-7.png" class="w-100 ok-image mt-5 mb-5" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('button-element')){
	$('#ok-sortable-section .button-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<a class="fs-18 lh-lg btn ok-link fw-bold rounded-0 mt-5 mb-5 ok-line bg-a hov-bg-b color-f hov-color-f" href="#">Button</a>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('icon-element')){
	$('#ok-sortable-section .icon-element:not(.ok-group-container .icon-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="hw-65 fs-32 ok-link ok-line ok-icon color-f bg-a mt-5 mb-5 rounded-circle"><i class="fas fa-lightbulb"></i></div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('video-element')){
	$('#ok-sortable-section .video-element:not(.ok-group-container .video-element):not(.card-body .video-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">		
		<div class="embed-container ok-icode w-100 ok-vimeo mt-5 mb-5" data-vidid="https://player.vimeo.com/video/640499893">
			<img src="https://vumbnail.com/640499893.jpg">
			<i class="fab fa-youtube"></i>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('card-element')){
	$('#ok-sortable-section .card-element:not(.card-body .card-element):not(.ok-group-container .card-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5 mt-5 mb-5">
			<div class="card-body p-20 bg-f">
				<h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Beautiful Websites Without Code</h5>
				<p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
			</div>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('card-top-image-element')){
	$('#ok-sortable-section .card-top-image-element:not(.card-body .card-top-image-element):not(.ok-group-container .card-top-image-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5 mt-5 mb-5">
			<img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/16-gallery.jpg" alt="">
			<div class="card-body p-20 bg-f">
				<h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Beautiful Websites Without Code</h5>
				<p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
			</div>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('card-bottom-image-element')){
	$('#ok-sortable-section .card-bottom-image-element:not(.card-body .card-bottom-image-element):not(.ok-group-container .card-bottom-image-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5 mt-5 mb-5">
			<div class="card-body p-20 bg-f">
				<h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Beautiful Websites Without Code</h5>
				<p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
			</div>
			<img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/16-gallery.jpg" alt="">
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('card-overlay-image-element')){
	$('#ok-sortable-section .card-overlay-image-element:not(.card-body .card-overlay-image-element):not(.ok-group-container .card-overlay-image-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="card ok-card no-bdr no-bg w-100 rounded-0 mt-5 mb-5">
		 <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		 <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		  <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-center">
		   <div>
				<h2 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b fs-18 mt-0 color-f text-center">Curuj Hiji Camp</h2>
				<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f text-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		   </div>
		  </div>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('rounded-image-element')){
	$('#ok-sortable-section .rounded-image-element:not(.ok-group-container .rounded-image-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<img class="hw-100 rounded-circle ok-image mt-5 mb-5" src="`+domainName+`/assets/img/client-2.jpg" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('gallery-pop-element')){
	$('#ok-sortable-section .gallery-pop-element:not(.ok-group-container .gallery-pop-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<a href="`+domainName+`/assets/img/14-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
            <img class="w-100" src="`+domainName+`/assets/img/14-gallery.jpg" alt="image">
        </a>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('gallery-2-element')){
	$('#ok-sortable-section .gallery-2-element:not(.card-body .gallery-2-element):not(.ok-group-container .gallery-2-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="card ok-card no-bdr no-bg w-100 rounded mt-5 mb-5 border bdr-j border-5">
			<a href="`+domainName+`/assets/img/14-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/14-gallery.jpg" alt="image">
            </a>
          <div class="card-body p-20 bg-f">
			<p class="ok-text lh-base fs-16 color-k mb-0 mt-10">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('video-button-element')){
	$('#ok-sortable-section .video-button-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<a class="popup-video btn-alt hw-55 rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-a color-f hov-color-f mt-5 mb-5" href="https://www.youtube.com/watch?v=VfaHkWxz1Xw"> <i class="fas fa-play"></i> </a>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('video-image-element')){
	$('#ok-sortable-section .video-image-element:not(.card-body .video-image-element):not(.ok-group-container .video-image-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="overlay-container card ok-card no-bdr no-bg w-100 mt-5 mb-5 rounded-0">
			<div class="card-body p-0">
				<img src="`+domainName+`/assets/img/service-7.png" class="ok-video-image w-100 ok-image" alt="">
				<a class="ok-video-btn popup-video btn-alt hw-55 rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-a color-f hov-color-f" href="https://www.youtube.com/watch?v=VfaHkWxz1Xw"> <i class="fas fa-play"></i></a>
			</div>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('custom-code-element')){
	$('#ok-sortable-section .custom-code-element:not(.ok-group-container .custom-code-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="ok-icode ok-code mt-5 mb-5" data-placeholder="{Empty}">
			<div><i class="fas fa-code"></i> Custom HTML Code</div>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('container-element')){
	$('#ok-sortable-section .container-element:not(.ok-group-container .container-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow">
			<a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
				<i class="fab fa-facebook-f"></i>
			</a>
			<a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
				<i class="fab fa-facebook-f"></i>
			</a>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('button-icon-element')){
	$('#ok-sortable-section .button-icon-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
			<i class="fab fa-facebook-f"></i>
		</a>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('list-element')){
	$('#ok-sortable-section .list-element').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<p class="ok-link ok-list fs-18 font-b mb-0">
          <span class="ok-list-icon pe-3 color-e"><i class="fas fa-check"></i></span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('map-element')){
	$('#ok-sortable-section .map-element:not(.ok-group-container .map-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="map-wrapper ok-icode ok-map" data-placeholder="{Empty}">
			<iframe width="100%" height="400" src="https://www.google.com/maps/embed/v1/place?key=AIzaSyA5gW9nuD43UvLZSEGkUaY0Gfrz4QCVTJ4&amp;q=Eiffel+Tower,Paris+France" title="a9mzf874" frameborder="0"></iframe>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('contact-element')){
	$('#ok-sortable-section .contact-element:not(.ok-group-container .contact-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<div class="form-wrap ok-icode ok-contact" data-placeholder="{Empty}">
          <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
            <div class="form-floating mb-20 ok-name-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="text" name="name" required="">
              <label class="ok-contact-name font-b fs-18">Full Name</label>
            </div>
            <div class="form-floating mb-20 ok-email-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="email" name="email" required="">
              <label class="ok-email-id font-b fs-18">Email address</label>
            </div>
            <div class="form-floating mb-20 ok-message-field">
              <textarea class="btn-lg font-b form-control textarea-ht rounded bdr-e border-1" name="message" required=""></textarea>
              <label class="ok-message-id font-b fs-18">Message</label>
            </div>
            <div class="ok-submit-field">
              <input type="submit" value="Send Message" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize rounded form-control bg-e hov-bg-d color-f hov-color-e">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('optin-form1-element')){
	$('#ok-sortable-section .optin-form1-element:not(.ok-group-container .optin-form1-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank" data-placeholder="{Empty}">
            <div class="d-grid gap-3">
              <div class="ok-name-field">
                <label class="visually-hidden">First Name</label>
                <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded border border-1 bdr-e" type="text" name="FNAME" placeholder="Full Name" required="">
              </div>
              <div class="ok-email-field">
                <label class="visually-hidden">Email Address</label>
                <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded border border-1 bdr-e" type="email" name="EMAIL" placeholder="Email address" required="">
              </div>
              <div class="ok-submit-field">
                <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded text-capitalize bg-e hov-bg-k color-f hov-color-f">
              </div>
            </div>
            <div class="mc-status"></div>
        </form>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('optin-form2-element')){
	$('#ok-sortable-section .optin-form2-element:not(.ok-group-container .optin-form2-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">
		<form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank" data-placeholder="{Empty}">
            <div class="ok-flex noflex-mob d-xxl-flex d-xl-flex d-lg-flex d-md-flex gap-3 justify-content-center">
              <div class="noflex-child ok-name-field ok-hide-name-field">
                <label class="visually-hidden">First Name</label>
                <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded-0 border border-1 bdr-e" type="text" name="FNAME" placeholder="Full Name" required="">
              </div>
              <div class="noflex-child ok-email-field w-100">
                <label class="visually-hidden">Email Address</label>
                <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded-0 border border-1 bdr-e" type="email" name="EMAIL" placeholder="Email address" required="">
              </div>
              <div class="ok-submit-field">
                <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded-0 color-f bg-e hov-bg-k hov-color-f">
              </div>
            </div>
            <div class="mc-status"></div>
        </form>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('slider-1-element')){
	$('#ok-sortable-section .slider-1-element:not(.card-body .slider-1-element):not(.ok-group-container .slider-1-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">		
        <div class="swiper swiper-1 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('slider-2-element')){
	$('#ok-sortable-section .slider-2-element:not(.card-body .slider-2-element):not(.ok-group-container .slider-2-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">		
        <div class="swiper swiper-1 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('slider-4-element')){
	$('#ok-sortable-section .slider-4-element:not(.card-body .slider-4-element):not(.ok-group-container .slider-4-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">		
        <div class="swiper swiper-1 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
			  <img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image ok-top-card-image" alt="">
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('slider-3-element')){
	$('#ok-sortable-section .slider-3-element:not(.card-body .slider-3-element):not(.ok-group-container .slider-3-element)').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
	<div class="row ok-row">
      <div class="ok-column col">		
        <div class="swiper swiper-1 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded-0">
		     <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		     <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		     <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-center">
		     <div>
				<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f text-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		     </div>
		     </div>
		    </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded-0">
		     <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		     <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		     <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-center">
		     <div>
				<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f text-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		     </div>
		     </div>
		    </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded-0">
		     <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		     <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		     <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-center">
		     <div>
				<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f text-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		     </div>
		     </div>
		    </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded-0">
		     <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		     <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		     <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-center">
		     <div>
				<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f text-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		     </div>
		     </div>
		    </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	
	//Remove extra if append inside column element
	if($('#body-data .ok-column .drag-main-blocks').length>0){
		$('#body-data .drag-main-blocks .ok-column').contents().unwrap();
		$('#body-data .drag-main-blocks .ok-row').contents().unwrap();
		$('#body-data .drag-main-blocks .container-fluid').contents().unwrap();
		$('#body-data .drag-main-blocks .ok-section').contents().unwrap();
	}
	//Remove Add Element Placeholder
	$('#body-data .ok-column').each(function() { 
		if($(this).find('.drag-main-blocks').length > 0) {
			$(this).find('.add-section').remove();
		}
	});
	//::END:: Blocks with currosponded images
	$('#body-data .ok-section').removeClass('drag-temp-col');
	$('#body-data .drag-main-blocks').each(function() { 
		if ($(this).length > 0){
			$(this).find('.temp-block-img').remove();
			$(this).find('.ok-section').removeClass('display-none-dp');
			$(this).contents().unwrap();
		} 
	});	
	
	$("#scaledown-overlay").show();	
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
	//If block is not added
	if ($('#ok-sortable-section').html().trim() == '') {
		$('#ok-sortable-section').html(`
			<div class="ok-section empty-section" dir="ltr"> 
				<div class="empty-section-wrap">
					<button class="add-section empty-button" title="Add Section">Blank Website <br> <span style="font-size: 32px;">Get Started by <strong>Dragging and Dropping</strong> New Elements or Blocks</span></button>
				</div>
			</div>
		`);
	}
	//For empty slider
	$('.swiper-wrapper').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">'
            +' <div class="card-body p-20 text-center">'
			+' 	<img src="'+domainName+'/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">'
			+'	<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>'
            +' </div>'
            +'</div>'
			+'');
		} 
	});
	//For empty column, container and others
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
	//Hide Nav if exist
	if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
		$('.nav-sec').hide();
	}
	//Hide Footer if exist
	if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
		$('.footer-sec').hide();
	}
});

elementSortable[0].addEventListener('sortupdate', function(e) {
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
});

// Main PreMade Block Drag
const preBlockSortable = sortable('.section-list-wrap', {
	copy: true,
	acceptFrom: false,
    forcePlaceholderSize: true,
	hoverClass: 'sortable-chosen',
	placeholderClass: 'sortable-chosen',
});
preBlockSortable[0].addEventListener('sortstart', function(e) {	
	$("#body-data").addClass('scaledown-main-content');
	$("#scaledown-overlay").hide();
	$('#body-data .ok-section').addClass('drag-temp-col');
	
	//Tigger Blocks Drag and Drop
	const tiggerPreBlocksTwo = sortable('#ok-sortable-section', {
		acceptFrom: '.section-list-wrap',
		forcePlaceholderSize: true,
		handle: '.none',
		placeholderClass: 'sortable-chosen',
	});
});
preBlockSortable[0].addEventListener('sortstop', function(e) {
	//::START:: Premade Blocks with currosponded images
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-1')){
		$('#ok-sortable-section .block-1').append(`
<header id="navbarScrollable" class="navbar navbar-expand-lg fixed-top ok-section ok-header-fixed bg-f display-none-dp">
  <div class="container-fluid cw-85">
    <a href="#" class="navbar-brand ok-link-image ok-logo text-capitalize fw-normal fs-18">
      <img id="logo-a" src="`+domainName+`/assets/img/fitness-logo.png" alt="">
      <img id="logo-b" class="d-none" src="`+domainName+`/assets/img/fitness-logo.png" alt="">
    </a>
    <button class="navbar-toggler bg-j color-e" type="button" id="navbarSideCollapse" aria-label="Toggle navigation">
      <i class="menu-bar fas fa-bars"></i>
    </button>
    <nav class="navbar-collapse offcanvas-collapse bg-f">
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link active text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Home</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Features</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Team</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Contact</a>
        </li>
        <li class="nav-item dropdown">
          <a class="font-b nav-link dropdown-toggle text-capitalize fw-normal fs-18 color-e hov-color-a" href="#" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">More</a>
          <ul class="dropdown-menu ok-link-arrow-clear bg-f" aria-labelledby="dropdown01">
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link arrow-default text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Testimonials</a>
            </li>
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Blog</a>
            </li>
          </ul>
        </li>
      </ul>
      <div class="nav-item nav-end ok-nav-cta ok-link-arrow">
        <a class="font-b btn rounded-pill ok-link ok-line text-capitalize fw-normal fs-18 color-f hov-color-f bg-a hov-bg-e" href="#">Subscribe</a>
      </div>
    </nav>
  </div>
</header>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-2')){
		$('#ok-sortable-section .block-2').append(`
<header id="navbarScrollable" class="navbar navbar-expand-lg fixed-top ok-section ok-header-fixed bg-f">
  <div class="container-fluid cw-85">
    <a href="#" class="navbar-brand ok-link-image ok-logo text-capitalize fw-normal fs-18">
      <img id="logo-a" src="`+domainName+`/assets/img/ringslab-logo-a.png" alt="">
      <img id="logo-b" class="d-none" src="`+domainName+`/assets/img/ringslab-logo-a.png" alt="">
    </a>
    <button class="navbar-toggler color-k bg-j" type="button" id="navbarSideCollapse" aria-label="Toggle navigation">
      <i class="menu-bar fas fa-bars"></i>
    </button>
    <nav class="navbar-collapse offcanvas-collapse bg-f">
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item dropdown">
          <a class="font-b nav-link dropdown-toggle text-capitalize fw-normal fs-18 color-e hov-color-b" href="#" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">Products</a>
          <ul class="dropdown-menu ok-link-arrow-clear bg-f" aria-labelledby="dropdown01">
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link arrow-default text-capitalize fw-normal fs-18 color-e hov-color-b" href="">AppLab</a>
            </li>
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link text-capitalize fw-normal fs-18 color-e hov-color-b" href="">LabApps</a>
            </li>
          </ul>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link active text-capitalize fw-normal fs-18 color-e hov-color-b" href="">Company</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-b" href="">Career</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-b" href="">Support</a>
        </li>
      </ul>
    </nav>
  </div>
</header>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-3')){
		$('#ok-sortable-section .block-3').append(`
<header id="navbarScrollable" class="navbar navbar-expand-lg fixed-top ok-section ok-header-fixed bg-f">
  <div class="container-fluid cw-85">
    <a href="#" class="navbar-brand ok-link-image ok-logo text-capitalize fw-normal fs-18">
      <img id="logo-a" src="`+domainName+`/assets/img/logo-black.png" alt="">
      <img id="logo-b" class="d-none" src="`+domainName+`/assets/img/logo-black.png" alt="">
    </a>
    <button class="navbar-toggler bg-j color-e" type="button" id="navbarSideCollapse" aria-label="Toggle navigation">
      <i class="menu-bar fas fa-bars"></i>
    </button>
    <nav class="navbar-collapse offcanvas-collapse bg-f">
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link active text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Home</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Features</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Team</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Contact</a>
        </li>
        <li class="nav-item dropdown">
          <a class="font-b nav-link dropdown-toggle text-capitalize fw-normal fs-18 color-e hov-color-a" href="#" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">More</a>
          <ul class="dropdown-menu ok-link-arrow-clear bg-f" aria-labelledby="dropdown01">
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link arrow-default text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Testimonials</a>
            </li>
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Blog</a>
            </li>
          </ul>
        </li>
      </ul>
      <div class="nav-item nav-end ok-nav-cta ok-link-arrow">
        <a class="btn-alt ok-link ok-line ok-link-icon hw-40 fs-18 rounded-circle color-f hov-color-f bg-b hov-bg-e" href="#">
          <i class="fab fa-facebook-f"></i>
        </a>
        <a class="btn-alt ok-link ok-line ok-link-icon hw-40 fs-18 rounded-circle color-f hov-color-f bg-b hov-bg-e" href="#">
          <i class="fab fa-twitter"></i>
        </a>
        <a class="btn-alt ok-link ok-line ok-link-icon hw-40 fs-18 rounded-circle color-f hov-color-f bg-b hov-bg-e" href="#">
          <i class="fab fa-youtube"></i>
        </a>
      </div>
    </nav>
  </div>
</header>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-4')){
		$('#ok-sortable-section .block-4').append(`
<header id="navbarScrollable" class="navbar navbar-expand-lg fixed-top ok-section ok-header-fixed bg-f">
  <div class="container-fluid cw-85">
    <a href="#" class="navbar-brand ok-link-image ok-logo text-capitalize fw-normal fs-18">
      <img id="logo-a" src="`+domainName+`/assets/img/ringslab-logo-a.png" alt="">
      <img id="logo-b" class="d-none" src="`+domainName+`/assets/img/ringslab-logo-a.png" alt="">
    </a>
    <button class="navbar-toggler color-e bg-j" type="button" id="navbarSideCollapse" aria-label="Toggle navigation">
      <i class="menu-bar fas fa-bars"></i>
    </button>
    <nav class="navbar-collapse offcanvas-collapse bg-f">
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link active text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Home</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Features</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Team</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Contact</a>
        </li>
        <li class="nav-item dropdown">
          <a class="font-b nav-link dropdown-toggle text-capitalize fw-normal fs-18 color-e hov-color-a" href="#" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">More</a>
          <ul class="dropdown-menu ok-link-arrow-clear bg-f" aria-labelledby="dropdown01">
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link arrow-default text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Testimonials</a>
            </li>
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Blog</a>
            </li>
          </ul>
        </li>
      </ul>
      <div class="nav-item nav-end ok-nav-cta ok-link-arrow">
        <a class="font-b btn rounded-pill ok-link ok-line text-capitalize fw-normal bg-d hov-bg-e color-e hov-color-f lh-base fs-24" href="#">Subscribe</a>
        <a class="btn-alt ok-link ok-line ok-link-icon rounded-circle bg-d hov-bg-e color-e hov-color-f fs-16 hw-45" href="#">
          <i class="fab fa-facebook-f"></i>
        </a>
      </div>
    </nav>
  </div>
</header>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-4a')){
		$('#ok-sortable-section .block-4a').append(`
<header id="navbarScrollable" class="navbar navbar-expand-lg fixed-top ok-section ok-header-fixed bg-f">
  <div class="container-fluid cw-85">
    <a href="#" class="navbar-brand ok-link-image ok-logo text-capitalize fw-normal fs-18">
      <img id="logo-a" src="`+domainName+`/assets/img/logo-black.png" alt="">
      <img id="logo-b" class="d-none" src="`+domainName+`/assets/img/logo-black.png" alt="">
    </a>
    <button class="navbar-toggler bg-j color-e" type="button" id="navbarSideCollapse" aria-label="Toggle navigation">
      <i class="menu-bar fas fa-bars"></i>
    </button>
    <nav class="navbar-collapse offcanvas-collapse bg-f">
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link active text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Home</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Features</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Pricing</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Team</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">About</a>
        </li>
        <li class="nav-item dropdown ok-deleted-elements">
          <a class="font-b nav-link dropdown-toggle text-capitalize fw-normal fs-18 color-e hov-color-a" href="#" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">More</a>
          <ul class="dropdown-menu ok-link-arrow-clear bg-f" aria-labelledby="dropdown01">
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link arrow-default text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Testimonials</a>
            </li>
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link text-capitalize fw-normal fs-18 color-e hov-color-a" href="#">Blog</a>
            </li>
          </ul>
        </li>
      </ul>
      <div class="nav-item nav-end ok-nav-cta ok-link-arrow">
        <a class="font-b btn ok-link ok-line text-capitalize fw-normal fs-18 rounded bg-f hov-bg-b border bdr-b hov-bdr-b border-3 color-b hov-color-f" href="#">Subscribe</a>
      </div>
    </nav>
  </div>
</header>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-4b')){
		$('#ok-sortable-section .block-4b').append(`
<header id="navbarScrollable" class="navbar navbar-expand-lg fixed-top ok-section ok-header-fixed bg-f">
  <div class="container-fluid cw-85">
    <a href="#" class="navbar-brand ok-link-image ok-logo text-capitalize fw-normal fs-18">
      <img id="logo-a" src="`+domainName+`/assets/img/logo-black.png" alt="">
      <img id="logo-b" class="d-none" src="`+domainName+`/assets/img/logo-black.png" alt="">
    </a>
    <button class="navbar-toggler color-e bg-j" type="button" id="navbarSideCollapse" aria-label="Toggle navigation">
      <i class="menu-bar fas fa-bars"></i>
    </button>
    <nav class="navbar-collapse offcanvas-collapse justify-content-between bg-f">
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link active text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Home</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Features</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Pricing</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Team</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Contact</a>
        </li>
        <li class="nav-item dropdown ok-deleted-elements">
          <a class="font-b nav-link dropdown-toggle text-capitalize fw-normal fs-18 hov-color-a color-e" href="#" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">More</a>
          <ul class="dropdown-menu ok-link-arrow-clear bg-f" aria-labelledby="dropdown01">
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link arrow-default text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Testimonials</a>
            </li>
            <li class="ok-link-li">
              <a class="nav-link font-b dropdown-item ok-link text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Blog</a>
            </li>
          </ul>
        </li>
      </ul>
      <ul class="navbar-nav ms-auto gap-3 ok-link-arrow">
        <li class="nav-item ok-link-li">
          <a class="font-b nav-link ok-link text-capitalize fw-normal fs-18 hov-color-a color-e" href="#">Login</a>
        </li>
        <li class="nav-item ok-link-li">
          <a class="font-b btn ok-link ok-line text-capitalize fw-normal lh-base fs-18 rounded bg-b hov-bg-h hov-color-f color-f" href="#">Register</a>
        </li>
      </ul>
    </nav>
  </div>
</header>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-5')){
		$('#ok-sortable-section .block-5').append(`
<section class="vh-100 py-20 ok-section d-flex align-items-center display-none-dp" style="background-image: linear-gradient(72deg, rgb(188, 31, 237), 34%, rgb(4, 39, 225));">
  <div class="container-fluid cw-55">
    <div class="row g-5 ok-row">
      <div class="ok-column col-sm-12 col-xxl-12 col-xl-12 col-lg-12 col-md-12 text-xl-center text-lg-center text-md-center text-sm-center">
        <h1 class="ok-text fw-bold lh-sm mb-25 text-capitalize font-b fs-64 color-f">Start Building Your Next Single Page Website</h1>
        <p class="ok-text font-b lh-base mt-35 fs-24 mb-40 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="ok-group-container ok-flex d-flex align-items-center gap-4 ok-link-arrow justify-content-xl-center justify-content-lg-center justify-content-md-center justify-content-sm-center">
          <a class="fs-18 lh-lg font-b btn ok-link ok-line text-uppercase rounded fw-normal bg-d hov-bg-e color-e hov-color-f border bdr-d hov-bdr-e border-3" href="#">Join Now</a>
          <a class="fs-18 lh-lg font-b btn ok-link ok-line text-uppercase rounded border fw-normal color-d hov-color-f hov-bg-e border-3 bdr-d hov-bdr-e" href="#">Learn Now</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-5a')){
		$('#ok-sortable-section .block-5a').append(`
<section class="ok-section py-70 bg-g">
  <div class="container-fluid cw-80">
    <div class="row ok-row align-items-end">
      <div class="ok-column col-md-6 col-sm-12 col-xl-8 col-xxl-8 col-lg-8">
        <h1 class="ok-text mt-0 mb-0 color-e fw-bold mt-5 mb-5 font-b fs-76">Design makes <i>anything</i> possible </h1>
        <p class="ok-text lh-base color-k font-b fs-24 fw-normal mb-40 mt-40">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
        <div class="row ok-row">
          <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-6 col-xsm-6">
            <a class="lh-lg btn ok-link fw-bold mt-5 mb-5 bg-a hov-bg-b color-f hov-color-f font-b fs-24 w-100 rounded-0" href="#">Get In Touch </a>
          </div>
          <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-6 col-xsm-6">
            <a class="popup-video btn-alt hw-55 rounded-circle ok-link ok-line ok-link-icon hov-bg-a hov-color-f mt-5 mb-5 bg-f color-a" href="https://www.youtube.com/watch?v=VfaHkWxz1Xw">
              <i class="fas fa-play"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
    <div class="row ok-row g-0 mt-30">
      <div class="ok-column col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mt-5 mb-5">
          <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-b op-7"></div>
          <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-start">
            <div class="">
              <h2 class="ok-text lh-base mb-0 font-b fs-18 mt-0 color-f fw-normal text-uppercase">DIGITAL MARKETING</h2>
              <p class="ok-text font-b mt-15 mb-20 color-f fw-bold fs-32 lh-sm">Boost your online Store Presence</p>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mt-5 mb-5">
          <img src="`+domainName+`/assets/img/service-4.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-a op-7"></div>
          <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-start">
            <div class="">
              <h2 class="ok-text lh-base mb-0 font-b fs-18 mt-0 color-f fw-normal text-uppercase">WEB DESIGN</h2>
              <p class="ok-text font-b mt-15 mb-20 color-f fw-bold fs-32 lh-sm">Website Design &amp; Development</p>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mt-5 mb-5">
          <img src="`+domainName+`/assets/img/service-6.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-7"></div>
          <div class="card-body p-20 card-img-overlay align-items-end d-flex justify-content-start">
            <div class="">
              <h2 class="ok-text lh-base mb-0 font-b fs-18 mt-0 color-f fw-normal text-uppercase">DIGITAL MARKETING</h2>
              <p class="ok-text font-b mt-15 mb-20 color-f fw-bold fs-32 lh-sm">Boost your online Store Presence</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-6')){
		$('#ok-sortable-section .block-6').append(`
<section class="vh-100 py-20 ok-section d-flex align-items-center bg-image bg-parallax display-none-dp" style="background-image: url(`+domainName+`/assets/img/1-wallpaper.jpg);">
  <div class="bg-overlay op-4 bg-e"></div>
  <div class="container-fluid cw-55 layer-2">
    <div class="row g-5 ok-row">
      <div class="ok-column col-sm-12 col-xxl-12 col-xl-12 col-lg-12 col-md-12 text-xl-center text-lg-center text-md-center text-sm-center">
        <p class="ok-text lh-base fs-24 font-b mt-0 mb-0 color-f">
          <i>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</i>
        </p>
        <h1 class="ok-text fw-bold lh-sm font-b text-uppercase fs-52 mt-10 mb-25 color-f">Let's build something amazing together</h1>
        <div class="ok-group-container ok-flex d-flex align-items-center gap-4 ok-link-arrow justify-content-xl-center justify-content-lg-center justify-content-md-center justify-content-sm-center">
          <a class="fs-18 lh-lg font-b btn ok-link ok-line text-uppercase fw-normal rounded-pill color-e hov-color-f bg-f hov-bg-e border bdr-f hov-bdr-e border-3" href="#">Join Now</a>
          <a class="fs-18 lh-lg font-b btn ok-link ok-line text-uppercase border border-2 fw-normal rounded-pill color-f hov-color-e hov-bg-f bdr-f hov-bdr-f" href="#">Learn Now</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-7')){
		$('#ok-sortable-section .block-7').append(`
<section class="ok-section py-100 bg-image display-none-dp" style="background-image: url(`+domainName+`/assets/img/2-wallpaper.jpg);">
  <div class="container-fluid cw-85">
    <div class="row g-5 ok-row">
      <div class="ok-column col-sm-12 col-lg-12 col-md-12 col-xl-8 col-xxl-8">
        <h1 class="ok-text fw-bold lh-sm font-b mt-0 mb-0 fs-64 color-e">We are here to be your <font color="#ec5434">product design</font> partner </h1>
        <p class="ok-text lh-base fs-24 font-b mt-20 mb-30 color-k">
          <i>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius.</i>
        </p>
        <div class="ok-group-container ok-flex d-flex align-items-center gap-4 ok-link-arrow">
          <a class="fs-18 lh-lg font-b btn ok-link ok-line text-uppercase border border-2 rounded bdr-a hov-bdr-a hov-bg-a color-a fw-bold hov-color-f" href="#">Join Now</a>
        </div>
      </div>
    </div>
    <div class="row ok-row justify-content-center g-0 mt-40 active-row">
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xl-3 col-xxl-3 col-lg-3">
        <img src="`+domainName+`/assets/img/brand-1.png" class="ok-image mb-20" alt="" width="70%">
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xl-3 col-xxl-3 col-lg-3">
        <img src="`+domainName+`/assets/img/brand-2.png" class="ok-image mb-20" alt="" width="70%">
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xl-3 col-xxl-3 col-lg-3">
        <img src="`+domainName+`/assets/img/brand-3.png" class="ok-image mb-20" alt="" width="70%">
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xl-3 col-xxl-3 col-lg-3">
        <img src="`+domainName+`/assets/img/brand-4.png" class="ok-image mb-20" alt="" width="70%">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-8')){
		$('#ok-sortable-section .block-8').append(`
<section class="vh-100 py-20 ok-section d-flex align-items-end display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-xl-5 col-xxl-5 col-lg-6 col-md-6 col-sm-12">
        <h1 class="ok-text fw-bold lh-sm mb-25 font-a text-capitalize fs-52 color-e">Keep your body fit &amp; strong</h1>
        <p class="ok-text font-b lh-base mt-35 mb-35 color-k fs-24">Our club encourages wellness by providing top-notch equipment, first-class instructors, innovative classes, and qualified staff.</p>
        <div class="ok-group-container ok-flex d-flex align-items-center gap-4 ok-link-arrow">
          <a class="fs-18 lh-lg font-b btn rounded-pill ok-link ok-line text-uppercase fw-bold bg-a color-f hov-color-a border bdr-a hov-bdr-a border-2 hov-bg-f" href="#">Join Now</a>
          <a class="popup-video btn-alt hw-55 rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-a color-f hov-color-f" href="https://www.youtube.com/watch?v=VfaHkWxz1Xw">
            <i class="fas fa-play"></i>
          </a>
        </div>
      </div>
      <div class="mx-auto ok-column col-xl-7 col-xxl-7 col-lg-6 col-md-6 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center">
        <img src="`+domainName+`/assets/img/hero-1.png" class="w-100 ok-image" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-9')){
		$('#ok-sortable-section .block-9').append(`
<section class="vh-100 py-20 ok-section d-flex align-items-center display-none-dp" style="background-image: linear-gradient(209deg, rgb(71, 227, 72), 43%, rgb(79, 175, 209));">
  <div class="container-fluid cw-55">
    <div class="row g-5 ok-row">
      <div class="ok-column col-sm-12 col-xxl-12 col-xl-12 col-lg-12 col-md-12 text-xl-center text-lg-center text-md-center text-sm-center">
        <h1 class="ok-text fw-bold lh-sm mb-25 text-capitalize font-b fs-64 color-f">Growing your business</h1>
        <p class="ok-text font-b lh-base mt-35 fs-24 mb-40 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="card ok-card w-100 rounded no-bdr no-bg">
          <div class="card-body p-10 bg-e">
            <form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank">
              <div class="ok-flex noflex-mob d-xxl-flex d-xl-flex d-lg-flex d-md-flex gap-3 justify-content-center">
                <div class="noflex-child ok-name-field ok-hide-name-field">
                  <label class="visually-hidden">First Name</label>
                  <input class="btn btn-lg text-start btn-light text-start border btn-light font-b form-control ok-contact-name rounded" type="text" name="FNAME" placeholder="Full Name" required="">
                </div>
                <div class="noflex-child ok-email-field w-100">
                  <label class="visually-hidden">Email Address</label>
                  <input class="btn btn-lg text-start btn-light text-start border btn-light font-b form-control ok-email-id rounded" type="email" name="EMAIL" placeholder="Email address" required="">
                </div>
                <div class="ok-submit-field">
                  <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded bg-d hov-bg-f color-e hov-color-e">
                </div>
              </div>
              <div class="mc-status"></div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-10')){
		$('#ok-sortable-section .block-10').append(`
<section class="ok-section py-20 d-flex align-items-center vh-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mt-0 mb-0 d-flex align-items-center">
      <div class="ok-column col-sm-12 col-xl-6 col-xxl-6 col-lg-6 col-md-6">
        <h1 class="ok-text fw-bold lh-sm font-b mt-0 mb-0 fs-52 color-e">We are here to be your <font color="#ec5434">product design</font> partner </h1>
        <p class="ok-text lh-base font-b mt-20 mb-30 fs-18 color-k">
          <i>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius.</i>
        </p>
        <p class="ok-link ok-list fs-18 font-b">
          <span class="ok-list-icon pe-3 color-a">
            <i class="fas fa-bell"></i>
          </span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
        <p class="ok-link ok-list fs-18 font-b">
          <span class="ok-list-icon pe-3 color-a">
            <i class="fas fa-cube"></i>
          </span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
        <div class="ok-group-container ok-flex d-flex align-items-center gap-4 ok-link-arrow mt-20 mb-20">
          <a class="fs-18 lh-lg font-b btn ok-link ok-line text-uppercase border border-2 rounded bdr-a hov-bdr-a hov-bg-a color-a fw-bold hov-color-f" href="#">Join Now</a>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-6 col-xxl-6 col-lg-6 col-md-6">
        <img src="`+domainName+`/assets/img/hero-2.png" class="w-100 ok-image" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-11')){
		$('#ok-sortable-section .block-11').append(`
<section class="vh-100 py-20 ok-section bg-image d-flex align-items-center display-none-dp" style="background-image: url(`+domainName+`/assets/img/3-wallpaper.jpg);">
  <div class="bg-overlay op-8 bg-b"></div>
  <div class="container-fluid cw-85 layer-2">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-7 col-xxl-7">
        <h1 class="ok-text fw-bold lh-sm mb-25 text-capitalize color-f font-b fs-64">Something Big is Happening <br>
        </h1>
        <p class="ok-text font-b lh-base mt-35 fs-24 mb-0 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
      <div class="mx-auto ok-column col-md-6 col-sm-12 text-lg-center text-md-center text-sm-center text-xl-center col-xl-5 col-xxl-5 col-lg-6">
        <div class="card ok-card no-bdr no-bg border border-2 bdr-j hov-bdr-j d-inline-block w-100 rounded">
          <div class="card-body p-50 text-end bg-f">
            <p class="ok-text font-b lh-base color-e text-start mt-0 mb-0 fs-32 fw-bold">Get Early Access</p>
            <p class="ok-text font-b color-k fs-18 lh-base text-start mt-20 mb-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank">
              <div class="d-grid gap-3">
                <div class="ok-name-field">
                  <label class="visually-hidden">First Name</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded" type="text" name="FNAME" placeholder="Full Name" required="">
                </div>
                <div class="ok-email-field">
                  <label class="visually-hidden">Email Address</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded" type="email" name="EMAIL" placeholder="Email address" required="">
                </div>
                <div class="ok-submit-field">
                  <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded text-capitalize bg-d hov-bg-e color-e hov-color-f">
                </div>
              </div>
              <div class="mc-status"></div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-12')){
		$('#ok-sortable-section .block-12').append(`
<section class="vh-100 py-20 ok-section d-flex align-items-center display-none-dp">
  <div class="container-fluid cw-70">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center col-xl-6 col-xxl-6">
        <img src="`+domainName+`/assets/img/hero-3.png" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-6 col-xxl-6">
        <div class="card ok-card no-bdr no-bg d-inline-block ok-line rounded-pill">
          <div class="card-body bg-h">
            <p class="ok-text font-b mt-0 mb-0 lh-1 fs-18 fw-bold color-b">
              <i>Free online courses</i>
            </p>
          </div>
        </div>
        <h1 class="ok-text text-capitalize color-e font-b fw-bold lh-1 mt-20 mb-50 fs-88">Let's make it happen</h1>
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
          <div class="card-body p-0">
            <form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank">
              <div class="ok-flex noflex-mob d-xxl-flex d-xl-flex d-lg-flex d-md-flex gap-3 justify-content-center">
                <div class="noflex-child ok-name-field ok-hide-name-field">
                  <label class="visually-hidden">First Name</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded-0" type="text" name="FNAME" placeholder="Full Name" required="">
                </div>
                <div class="noflex-child ok-email-field w-100">
                  <label class="visually-hidden">Email Address</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded-0" type="email" name="EMAIL" placeholder="Email address" required="">
                </div>
                <div class="ok-submit-field">
                  <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded-0 bg-b hov-bg-h color-f hov-color-b">
                </div>
              </div>
              <div class="mc-status"></div>
            </form>
          </div>
        </div>
        <p class="ok-text font-b lh-base color-k mb-0 fs-18 mt-10">
          <i>Your email is safe with us, we don't spam.</i>
        </p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-13')){
		$('#ok-sortable-section .block-13').append(`
<section class="py-20 ok-section vh-100 d-flex align-items-center display-none-dp" style="background-image: linear-gradient(60deg, rgb(237, 240, 243), 73%, rgb(248, 173, 173));">
  <div class="container-fluid cw-85">
    <div class="row ok-row flex-row-reverse g-5 d-flex align-items-start">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center p-0 col-xl-5 col-xxl-5">
        <div class="card ok-card no-bdr no-bg w-100 mb-0 border border-5 bdr-h rounded-0">
          <div class="card-body p-10 bg-f">
			<img class="ok-image w-100" src="`+domainName+`/assets/img/john-1.jpg" alt="image">
          </div>
        </div>
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 text-xl-start col-xxl-7 col-xl-7">
        <h1 class="ok-text mb-25 text-capitalize color-e fw-bold font-a fs-76 lh-sm">I am, <br>
          <font color="#f60101"> John Doe</font>
          <br>
        </h1>
        <p class="ok-text font-b lh-base mb-35 color-k fs-24 mt-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="ok-group-container ok-flex d-flex gap-3 ok-link-arrow justify-content-xl-start">
          <a class="btn-alt rounded-circle ok-link ok-line ok-link-icon bg-k hov-bg-e color-j hov-color-f hw-45 fs-18" href="#">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a class="btn-alt rounded-circle ok-link ok-line ok-link-icon bg-k hov-bg-e color-j hov-color-f hw-45 fs-18" href="#">
            <i class="fab fa-twitter"></i>
          </a>
          <a class="btn-alt rounded-circle ok-link ok-line ok-link-icon bg-k hov-bg-e color-j hov-color-f hw-45 fs-18" href="#">
            <i class="fab fa-pinterest-p"></i>
          </a>
          <a class="btn-alt rounded-circle ok-link ok-line ok-link-icon bg-k hov-bg-e color-j hov-color-f hw-45 fs-18" href="#">
            <i class="fab fa-youtube"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-14a')){
		$('#ok-sortable-section .block-14a').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
    <div class="row ok-row mb-0 mt-0 d-flex align-items-center">
      <div class="ok-column col-sm-12 col-xl-8 col-xxl-8 col-lg-8 col-md-12">
        <h1 class="ok-text mt-0 mb-0 color-e fw-bold mt-5 mb-5 font-b fs-42">Crafted For <br>
        </h1>
        <p class="ok-text lh-base color-k font-b fs-18 mb-45 mt-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="row ok-row mt-30">
          <div class="ok-column col-sm-12 col-xxl-6 col-xl-6 col-lg-6 col-md-6">
            <div class="row ok-row mt-0 mb-30">
              <div class="ok-column col-xl-3 col-xxl-3 col-lg-3 col-md-3 col-sm-3 col-xsm-3 text-xl-center text-lg-center text-md-center text-sm-center">
                <div class="hw-65 fs-32 ok-link ok-line ok-icon color-f mt-5 mb-5 rounded bg-b">
                  <i class="fas fa-lightbulb"></i>
                </div>
              </div>
              <div class="ok-column col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-xsm-9">
                <h2 class="ok-text mt-0 mb-0 color-e fs-24 fw-bold mt-5 mb-5 font-b">Startup</h2>
                <p class="ok-text lh-base fs-16 color-k mt-5 mb-5 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
          </div>
          <div class="ok-column col-sm-12 col-xxl-6 col-xl-6 col-lg-6 col-md-6">
            <div class="row ok-row mb-30">
              <div class="ok-column col-xl-3 col-xxl-3 col-lg-3 col-md-3 col-sm-3 col-xsm-3 text-xl-center text-lg-center text-md-center text-sm-center">
                <div class="hw-65 fs-32 ok-link ok-line ok-icon color-f mt-5 mb-5 rounded bg-b">
                  <i class="fab fa-html5"></i>
                </div>
              </div>
              <div class="ok-column col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-xsm-9">
                <h2 class="ok-text mt-0 mb-0 color-e fs-24 fw-bold mt-5 mb-5 font-b">App Landing <br>
                </h2>
                <p class="ok-text lh-base fs-16 color-k mt-5 mb-5 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="row ok-row mt-0">
          <div class="ok-column col-sm-12 col-xxl-6 col-xl-6 col-lg-6 col-md-6">
            <div class="row ok-row mt-0 mb-30">
              <div class="ok-column col-xl-3 col-xxl-3 col-lg-3 col-md-3 col-sm-3 col-xsm-3 text-xl-center text-lg-center text-md-center text-sm-center">
                <div class="hw-65 fs-32 ok-link ok-line ok-icon color-f mt-5 mb-5 rounded bg-b">
                  <i class="fas fa-user-shield"></i>
                </div>
              </div>
              <div class="ok-column col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-xsm-9">
                <h2 class="ok-text mt-0 mb-0 color-e fs-24 fw-bold mt-5 mb-5 font-b">Agency</h2>
                <p class="ok-text lh-base fs-16 color-k mt-5 mb-5 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
          </div>
          <div class="ok-column col-sm-12 col-xxl-6 col-xl-6 col-lg-6 col-md-6">
            <div class="row ok-row mb-30">
              <div class="ok-column col-xl-3 col-xxl-3 col-lg-3 col-md-3 col-sm-3 col-xsm-3 text-xl-center text-lg-center text-md-center text-sm-center">
                <div class="hw-65 fs-32 ok-link ok-line ok-icon color-f mt-5 mb-5 rounded bg-b">
                  <i class="fas fa-map-marker-alt"></i>
                </div>
              </div>
              <div class="ok-column col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-xsm-9">
                <h2 class="ok-text mt-0 mb-0 color-e fs-24 fw-bold mt-5 mb-5 font-b">SaaS Business <br>
                </h2>
                <p class="ok-text lh-base fs-16 color-k mt-5 mb-5 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 col-md-12">
        <img src="`+domainName+`/assets/img/yellow-green-lady.jpg" class="w-100 ok-image mt-0 mb-0" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-14')){
		$('#ok-sortable-section .block-14').append(`
<section class="py-100 ok-section bg-j display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-4 ok-row">
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-b bg-h">
              <i class="fas fa-medal"></i>
            </div>
            <h2 class="fs-24 fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-k">Highly qualified coaches</h2>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-c bg-i">
              <i class="fas fa-leaf"></i>
            </div>
            <h2 class="fs-24 fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-k">Exciting atmosphere</h2>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-a bg-g">
              <i class="fas fa-dumbbell"></i>
            </div>
            <h2 class="fs-24 fw-bold ok-text text-capitalize lh-base mb-0 mt-0 color-k">First-class equipment</h2>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-b bg-h">
              <i class="fas fa-user-check"></i>
            </div>
            <h2 class="fs-24 fw-bold ok-text lh-base mt-0 mb-0 color-k">Individual Approach</h2>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-14b')){
		$('#ok-sortable-section .block-14b').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
    <div class="row ok-row g-5 d-flex align-items-center">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mt-5 mb-5">
          <img src="`+domainName+`/assets/img/red-ribbon.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-a op-7"></div>
          <div class="card-body p-20 card-img-overlay justify-content-center d-flex align-items-center">
            <div class="">
              <h1 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 color-f font-b text-center fs-42">The future of designing starts here</h1>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-8 col-xxl-8 col-lg-8">
        <div class="row ok-row g-5">
          <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
            <div class="ok-link ok-line ok-icon mt-5 mb-5 rounded-circle color-a fs-32">
              <i class="fas fa-cube"></i>
            </div>
            <h1 class="ok-text mb-0 mb-5 font-b color-k fw-bold fs-24 mt-10">Full Documentation</h1>
            <p class="ok-text mb-5 font-b color-k fw-normal fs-18 lh-base mt-10">Built by developers for developers. Check the foundation and you will find everything inside our documentation.</p>
          </div>
          <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
            <div class="ok-link ok-line ok-icon mt-5 mb-5 rounded-circle color-a fs-32">
              <i class="fas fa-clock"></i>
            </div>
            <h1 class="ok-text mb-0 mb-5 font-b color-k fw-bold fs-24 mt-10">Save Time &amp; Money <br>
            </h1>
            <p class="ok-text mb-5 font-b color-k fw-normal fs-18 lh-base mt-10">Creating your design from scratch with dedicated designers can be very expensive. Start with our Design System.</p>
          </div>
        </div>
        <div class="row ok-row g-5 mt-0">
          <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
            <div class="ok-link ok-line ok-icon mt-5 mb-5 rounded-circle color-a fs-32">
              <i class="fas fa-box-open"></i>
            </div>
            <h1 class="ok-text mb-0 mb-5 font-b color-k fw-bold fs-24 mt-10">Bootstrap 5 Ready</h1>
            <p class="ok-text mb-5 font-b color-k fw-normal fs-18 lh-base mt-10">The world’s most popular front-end open source toolkit, featuring Sass variables and mixins.</p>
          </div>
          <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
            <div class="ok-link ok-line ok-icon mt-5 mb-5 rounded-circle color-a fs-32">
              <i class="fas fa-clone"></i>
            </div>
            <h1 class="ok-text mb-0 mb-5 font-b color-k fw-bold fs-24 mt-10">Fully Responsive</h1>
            <p class="ok-text mb-5 font-b color-k fw-normal fs-18 lh-base mt-10">Regardless of the screen size, the website content will naturally fit the given resolution.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-15')){
		$('#ok-sortable-section .block-15').append(`
<section class="py-100 ok-section bg-f display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-4 ok-row">
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-f bg-b">
              <i class="fas fa-user-clock"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">24/7 Support</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-f bg-b">
              <i class="fas fa-chess-queen"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">High Quality <br>
            </h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-f bg-b">
              <i class="fas fa-funnel-dollar"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">30 Days return</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-f bg-b">
              <i class="fas fa-shipping-fast"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Free shipping</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-15a')){
		$('#ok-sortable-section .block-15a').append(`
<section class="ok-section py-80">
  <div class="container-fluid cw-80">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h2 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b fs-18 color-a">SERVICES WE’RE PROVIDED</h2>
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Our Digital Marketing Services</h2>
      </div>
    </div>
    <div class="row ok-row mb-0">
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12 p-10">
        <div class="row ok-row bg-g d-flex align-items-end g-0 mb-0">
          <div class="ok-column col-xl-8 col-xxl-8 col-lg-8 p-30 col-xsm-9 col-md-8 col-sm-9">
            <h2 class="ok-text mt-0 mb-0 mt-5 mb-5 font-b fw-normal fs-18 color-a">MARKETING</h2>
            <h1 class="ok-text color-e fw-bold font-b fs-32 mt-20 mb-20">Content Marketing Service</h1>
            <p class="ok-text lh-base mt-5 mb-5 font-b fs-18 color-k">
              <a href="#" class="is-link color-k" target="_blank">
                <u>Learn More &gt;</u>
              </a>
            </p>
          </div>
          <div class="ok-column col-xl-4 col-xxl-4 col-lg-4 p-0 col-xsm-3 col-md-4 col-sm-3">
            <img src="`+domainName+`/assets/img/desktop-red.png" class="w-100 ok-image mt-5 mb-5" alt="">
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12 p-10">
        <div class="row ok-row d-flex align-items-end bg-i mb-0 g-0">
          <div class="ok-column col-xl-8 col-xxl-8 col-lg-8 p-30 col-xsm-9 col-md-8 col-sm-9">
            <h2 class="ok-text mt-0 mb-0 mt-5 mb-5 font-b fw-normal fs-18 color-c">PPC</h2>
            <h1 class="ok-text color-e fw-bold font-b fs-32 mt-20 mb-20">Digital Media &amp; PPC Advertising</h1>
            <p class="ok-text lh-base mt-5 mb-5 font-b fs-18 color-k">
              <a href="#" class="is-link color-k" target="_blank">
                <u>Learn More &gt;</u>
              </a>
            </p>
          </div>
          <div class="ok-column col-xl-4 col-xxl-4 col-lg-4 p-0 col-xsm-3 col-md-4 col-sm-3">
            <img src="`+domainName+`/assets/img/pigy-bank-red.png" class="w-100 ok-image mt-5 mb-5" alt="">
          </div>
        </div>
      </div>
    </div>
    <div class="row ok-row mt-0">
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12 p-10">
        <div class="row ok-row d-flex align-items-end g-0 bg-h">
          <div class="ok-column col-xl-8 col-xxl-8 col-lg-8 p-30 col-xsm-9 col-md-8 col-sm-9">
            <h2 class="ok-text mt-0 mb-0 mt-5 mb-5 font-b fw-normal fs-18 color-b">SEO</h2>
            <h1 class="ok-text color-e fw-bold font-b fs-32 mt-20 mb-20">Search Engine Optimization</h1>
            <p class="ok-text lh-base mt-5 mb-5 font-b fs-18 color-k">
              <a href="#" class="is-link color-k" target="_blank">
                <u>Learn More &gt;</u>
              </a>
            </p>
          </div>
          <div class="ok-column col-xl-4 col-xxl-4 col-lg-4 p-0 col-xsm-3 col-md-4 col-sm-3">
            <img src="`+domainName+`/assets/img/rocket-red.png" class="w-100 ok-image mt-5 mb-5" alt="">
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12 p-10">
        <div class="row ok-row d-flex align-items-end bg-g g-0">
          <div class="ok-column col-xl-8 col-xxl-8 col-lg-8 p-30 col-xsm-9 col-md-8 col-sm-9">
            <h2 class="ok-text mt-0 mb-0 mt-5 mb-5 font-b fw-normal fs-18 color-a">WEB DESIGN</h2>
            <h1 class="ok-text color-e fw-bold font-b fs-32 mt-20 mb-20">Website Design &amp; Development</h1>
            <p class="ok-text lh-base mt-5 mb-5 font-b fs-18 color-k">
              <a href="#" class="is-link color-k" target="_blank">
                <u>Learn More &gt;</u>
              </a>
            </p>
          </div>
          <div class="ok-column col-xl-4 col-xxl-4 col-lg-4 p-0 col-xsm-3 col-md-4 col-sm-3">
            <img src="`+domainName+`/assets/img/plant-red.png" class="w-100 ok-image mt-5 mb-5" alt="">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-16')){
		$('#ok-sortable-section .block-16').append(`
<section class="py-100 ok-section bg-f display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Business growth services</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row g-4 ok-row">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/service-1.png" class="ok-image mb-30 mt-20" alt="" width="50%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mb-0 color-e font-b fs-18 mt-0">Analyse your product</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/service-2.png" class="ok-image mb-30 mt-20" alt="" width="50%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Evaluate opportunities</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-md-12 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-4">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/service-3.png" class="ok-image mb-30 mt-20" alt="" width="50%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Find the influencers</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-17')){
		$('#ok-sortable-section .block-17').append(`
<section class="py-100 ok-section bg-f display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Find Popular Destinations</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row g-4 ok-row">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
		 <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		 <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		  <div class="card-body p-20 text-center card-img-overlay d-flex align-items-end">
		   <div>
			<h2 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b fs-18 mt-0 color-f">Curuj Hiji Camp</h2>
			<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		   </div>
		  </div>
		</div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
		 <img src="`+domainName+`/assets/img/service-6.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		 <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		  <div class="card-body p-20 text-center card-img-overlay d-flex align-items-end">
		   <div>
			<h2 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b fs-18 mt-0 color-f">Bintang Hill</h2>
			<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		   </div>
		  </div>
		</div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-md-12 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
		 <img src="`+domainName+`/assets/img/service-4.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
		 <div class="ok-card-overlay card-overlay bg-e op-4"></div>
		  <div class="card-body p-20 text-center card-img-overlay d-flex align-items-end">
		   <div>
			<h2 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b fs-18 mt-0 color-f">Serayu Rafting</h2>
			<p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
		   </div>
		  </div>
		</div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-18')){
		$('#ok-sortable-section .block-18').append(`
<section class="ok-section py-30 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mt-0 mb-0 g-5 d-flex align-items-center">
      <div class="ok-column col-sm-12 col-lg-6 col-md-6 col-xl-7 col-xxl-7">
        <h1 class="ok-text fw-bold lh-sm font-b mt-0 mb-0 fs-64 color-e">The future of designing starts here</h1>
        <p class="ok-text lh-base font-b mt-20 mb-30 fs-18 color-k"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius. </p>
      </div>
      <div class="ok-column col-sm-12 col-lg-6 col-md-6 col-xl-5 col-xxl-5">
        <img src="`+domainName+`/assets/img/service-7.png" class="w-100 ok-image" alt="">
      </div>
    </div>
    <div class="row g-4 ok-row mt-25 mb-50">
      <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20">
            <img src="`+domainName+`/assets/img/service-8.png" class="ok-image mb-30 mt-20" alt="" width="70%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mb-0 color-e font-b fs-18 mt-0">Product Design</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f">
            <img src="`+domainName+`/assets/img/service-9.png" class="ok-image mb-30 mt-20" alt="" width="60%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Graphics Design</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f">
            <img src="`+domainName+`/assets/img/service-10.png" class="ok-image mb-30 mt-20" alt="" width="60%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Social Media</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-3 col-xl-3 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f">
            <img src="`+domainName+`/assets/img/service-11.png" class="ok-image mb-30 mt-20" alt="" width="60%">
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">UI &amp; UX Design</h2>
            <p class="ok-text text-capitalize color-k fw-normal font-b fs-16 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-19')){
		$('#ok-sortable-section .block-19').append(`
<section class="ok-section py-70 bg-e display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row align-items-center g-5 ok-row">
      <div class="ok-column col-xl-7 col-xxl-7 col-lg-6 col-md-6 col-sm-12">
        <img src="`+domainName+`/assets/img/content-1.jpg" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-xl-5 col-lg-6 col-md-6 col-sm-12 col-xxl-5">
        <h1 class="fw-bold mb-25 ok-text fs-64 color-f font-b">Workout at home with ease</h1>
        <p class="font-b mb-35 ok-text fs-18 lh-base color-j">Long hours, demanding clients and deadlines can distract you from your health and fitness goals during work hours. Long hours, demanding clients and deadlines can distract you from your health and fitness goals during work hours.</p>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow">
          <a class="font-b btn ok-link ok-line fs-18 border bdr-f border-2 rounded-0 hov-bg-a color-f hov-color-f hov-bdr-a" href="">Get Started</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-20')){
		$('#ok-sortable-section .block-20').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row align-items-center g-5 ok-row">
      <div class="ok-column col-xl-7 col-xxl-7 col-lg-7 col-md-6 col-sm-12">
        <h1 class="fw-bold ok-text font-a fs-64 mb-40 color-e">You Provide The Vision, We Provide The Solution.</h1>
        <p class="font-b mb-35 ok-text fs-24 color-k">Clients of our gym receive not only necessary equipment for their workouts but also friendly support in achieving their number one training goal.</p>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow">
          <a class="font-b btn rounded-pill ok-link ok-line fs-24 bg-e hov-bg-d color-f hov-color-f">Get Started</a>
        </div>
      </div>
      <div class="ok-column col-xl-5 col-xxl-5 col-md-6 col-sm-12 col-lg-5">
        <img src="`+domainName+`/assets/img/content-2.jpg" class="w-100 ok-image" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-21')){
		$('#ok-sortable-section .block-21').append(`
<section class="ok-section py-70 display-none-dp">
  <div class="container-fluid cw-70">
    <div class="row g-5 ok-row flex-row-reverse d-flex align-items-center">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-5 col-xxl-5">
        <img src="`+domainName+`/assets/img/content-3.png" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-7 col-xxl-7">
        <h1 class="fw-bold mb-25 ok-text fs-64 color-e font-b">What's the best way to enhance your App? </h1>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow mt-20">
          <a class="font-b btn ok-link ok-line fs-24 lh-lg border bdr-e hov-bdr-k border-4 color-e fw-bold rounded-0 hov-color-k" href="">Meet AppLab</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-22')){
		$('#ok-sortable-section .block-22').append(`
<section class="ok-section py-70 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-5 col-xxl-5">
        <img src="`+domainName+`/assets/img/content-4.png" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-7 col-xxl-7">
        <div class="card ok-card no-bdr no-bg d-inline-block ok-line rounded-pill">
          <div class="card-body bg-e">
            <p class="ok-text font-b mt-0 mb-0 lh-1 fs-18 fw-bold color-d">
              <i>Official Android App</i>
            </p>
          </div>
        </div>
        <h1 class="fw-bold mb-25 ok-text fs-64 font-b mt-20 color-e">What's the best way to enhance your App? </h1>
        <p class="ok-text font-b lh-base color-k fs-18 mb-20 mt-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus. Pellentesque auctor tellus at nunc elementum, sit amet maximus metus eleifend. Praesent nec purus tincidunt lacus consequat commodo. Mauris rutrum enim sit amet nibh rutrum elementum.</p>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow mt-20">
          <a class="font-b btn ok-link ok-line fs-24 lh-lg border rounded border-4 bdr-k hov-bdr-e color-k hov-color-e fw-bold hov-bg-d" href="">Meet AppLab</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-23')){
		$('#ok-sortable-section .block-23').append(`
<section class="ok-section py-0 display-none-dp" style="background-image: linear-gradient(360deg, rgb(48, 109, 89), 100%, rgb(126, 205, 180));">
  <div class="container-fluid cw-100">
    <div class="row align-items-center g-5 ok-row">
      <div class="ok-column col-md-6 col-sm-12 col-xxl-6 col-xl-6 col-lg-6 p-50">
        <h1 class="fw-bold ok-text fs-52 mb-30 color-f font-b">Healthy Skin is a Reflection of Wellness</h1>
        <p class="font-b mb-35 ok-text fs-18 color-j">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas non tellus nec elit fermentum placerat vel sit amet lacus.</p>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow">
          <a class="font-b btn ok-link ok-line fs-24 rounded border border-5 bdr-j color-e bg-f hov-bg-d hov-color-e hov-bdr-d">Buy Now</a>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 p-0 col-xxl-6 col-xl-6 col-lg-6">
        <img src="`+domainName+`/assets/img/content-5.jpg" class="w-100 ok-image" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-24')){
		$('#ok-sortable-section .block-24').append(`
<section class="ok-section py-0 display-none-dp">
  <div class="container-fluid cw-100">
    <div class="row align-items-center g-5 ok-row">
      <div class="ok-column col-md-6 col-sm-12 p-0 col-xxl-6 col-xl-6 col-lg-6">
        <img src="`+domainName+`/assets/img/content-6.jpg" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-6 col-xl-6 col-lg-6 p-50">
        <h1 class="fw-bold ok-text font-a mb-20 color-e fs-24">Make Your Skin Fresh and Effective</h1>
        <p class="ok-text lh-base font-b mt-20 mb-30 fs-18 color-k">
          <i>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius.</i>
        </p>
        <p class="ok-link ok-list fs-18 font-b">
          <span class="ok-list-icon pe-3 color-e">
            <i class="fas fa-feather"></i>
          </span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
        <p class="ok-link ok-list fs-18 font-b">
          <span class="ok-list-icon pe-3 color-e">
            <i class="fas fa-air-freshener"></i>
          </span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
        <p class="ok-link ok-list fs-18 font-b">
          <span class="ok-list-icon pe-3 color-e">
            <i class="fas fa-bath"></i>
          </span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
        <p class="ok-link ok-list fs-18 font-b">
          <span class="ok-list-icon pe-3 color-e">
            <i class="fas fa-cut"></i>
          </span>
          <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
        </p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-25')){
		$('#ok-sortable-section .block-25').append(`
<section class="ok-section py-70 display-none-dp">
  <div class="container-fluid cw-80">
    <div class="row ok-row mt-0 mb-0 g-5 d-flex align-items-center">
      <div class="ok-column col-sm-12 col-lg-6 col-md-6 col-xl-7 col-xxl-7">
        <h1 class="ok-text fw-bold lh-sm font-b mt-0 mb-0 fs-64 color-e">Reliable Hosting &amp; Useful Features for Your Website</h1>
      </div>
      <div class="ok-column col-sm-12 col-lg-6 col-md-6 col-xl-5 col-xxl-5">
        <img src="`+domainName+`/assets/img/content-7.png" class="w-100 ok-image" alt="">
      </div>
    </div>
    <div class="row g-5 ok-row">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xxl-6 col-xl-6">
        <p class="ok-text lh-base font-b mb-0 fs-18 color-k mt-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus. Pellentesque auctor tellus at nunc elementum, sit amet maximus metus eleifend. Praesent nec purus tincidunt lacus consequat commodo. Mauris rutrum enim sit amet nibh rutrum elementum. Duis tristique nulla nunc. Donec porta finibus ipsum ornare posuere.</p>
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xxl-6 col-xl-6">
        <p class="ok-text lh-base font-b mb-30 fs-18 color-k mt-0"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius. </p>
        <p class="ok-text lh-base font-b mb-0 fs-18 color-k mt-0"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius. </p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-25a')){
		$('#ok-sortable-section .block-25a').append(`
<section class="ok-section py-70">
  <div class="container-fluid cw-80">
    <div class="row ok-row g-5 d-flex align-items-center">
      <div class="ok-column col-md-6 col-sm-12 col-xl-5 col-xxl-5 col-lg-5">
        <img src="`+domainName+`/assets/img/plant-woman.png" class="w-100 ok-image mt-5 mb-5" alt="">
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-7 col-xxl-7 col-lg-7">
        <h3 class="ok-text mt-0 mb-0 fs-18 mt-5 mb-5 font-b color-b">NO-CODE PLATFORM</h3>
        <h1 class="ok-text mb-0 fw-bold mb-5 font-b fs-52 mt-0 color-k">Build Your Online Presence in Minutes</h1>
        <p class="ok-text lh-base color-k font-b mt-20 mb-15 fs-24 fw-300">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="row ok-row mt-30 mb-30">
          <div class="ok-column col">
            <h2 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b fs-42 color-b">1800+</h2>
            <h4 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b text-uppercase fs-18 color-k">Projects</h4>
          </div>
          <div class="ok-column col">
            <h2 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b fs-42 color-b">500+</h2>
            <h4 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b text-uppercase fs-18 color-k">Clients</h4>
          </div>
          <div class="ok-column col">
            <h2 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b fs-42 color-b">300+</h2>
            <h4 class="ok-text mt-0 mb-0 fw-bold mt-5 mb-5 font-b text-uppercase fs-18 color-k">Coffee</h4>
          </div>
        </div>
        <a class="fs-18 lh-lg btn ok-link fw-bold mt-5 mb-5 font-b rounded w-100 hov-bg-e color-f hov-color-f text-uppercase bg-b" href="#">Contact Us</a>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-26')){
		$('#ok-sortable-section .block-26').append(`
<section class="ok-section py-70 display-none-dp">
  <div class="container-fluid cw-50">
    <div class="row ok-row mt-0 mb-0 g-5 d-flex align-items-center">
      <div class="ok-column col-sm-12 col-xxl-12 col-xl-12 col-lg-12 col-md-12">
        <h1 class="ok-text fw-bold lh-sm font-b mt-0 color-e mb-50 fs-52">Build Beautiful Websites Without Code</h1>
        <p class="ok-text lh-base font-b fs-18 color-k mt-0 mb-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus. Pellentesque auctor tellus at nunc elementum, sit amet maximus metus eleifend. Praesent nec purus tincidunt lacus consequat commodo. Mauris rutrum enim sit amet nibh rutrum elementum. Duis tristique nulla nunc. Donec porta finibus ipsum ornare posuere.</p>
        <p class="ok-text lh-base font-b fs-18 color-k mt-0 mb-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus. Pellentesque auctor tellus at nunc elementum, sit amet maximus metus eleifend. Praesent nec purus tincidunt lacus consequat commodo. Mauris rutrum enim sit amet nibh rutrum elementum. Duis tristique nulla nunc. Donec porta finibus ipsum ornare posuere.</p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-27')){
		$('#ok-sortable-section .block-27').append(`
<section class="ok-section py-100 bg-e display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-md-6 col-sm-12 col-lg-6 col-xl-6 col-xxl-6">
        <h2 class="fw-bold ok-text mb-0 font-b fs-64 color-f">Sprite Fright - Blender Open Movie</h2>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-6 col-xl-6 col-lg-6">
        <div class="embed-container ok-icode ok-vimeo w-100" data-vidid="https://player.vimeo.com/video/640499893">
          <img src="https://vumbnail.com/640499893.jpg" width="100%">
          <i class="fab fa-youtube"></i>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-28')){
		$('#ok-sortable-section .block-28').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-md-6 col-sm-12 col-lg-6 col-xl-6 col-xxl-6">
        <div class="embed-container ok-icode ok-vimeo w-100 mb-35" data-vidid="https://player.vimeo.com/video/640499893">
          <img src="https://vumbnail.com/640499893.jpg" width="100%">
          <i class="fab fa-youtube"></i>
        </div>
        <p class="font-b ok-text color-e fs-24 mb-0 mt-0">Sprite Fright - Blender Open Movie</p>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-6 col-xl-6 col-lg-6">
        <div class="embed-container ok-icode w-100 ok-vimeo mb-35" data-vidid="https://player.vimeo.com/video/217499569">
          <img src="https://vumbnail.com/217499569.jpg" width="100%">
          <i class="fab fa-youtube"></i>
        </div>
        <p class="font-b ok-text color-e fs-24 mt-0 mb-0">Agent 327: Operation Barbershop</p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-29')){
		$('#ok-sortable-section .block-29').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="ok-column col-md-6 col-sm-12 col-lg-6 col-xl-6 col-xxl-6">
        <div class="card ok-card no-bdr no-bg d-inline-block ok-line rounded-pill">
          <div class="card-body bg-j">
            <p class="ok-text font-b mt-0 mb-0 lh-1 fs-18 fw-bold color-a">
              <i>Lorem ipsum dolor sit amet</i>
            </p>
          </div>
        </div>
        <h2 class="fw-bold ok-text mb-0 font-b color-e fs-52">Sprite Fright - Blender Open Movie</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mb-20 mt-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus.</p>
        <a class="font-b btn ok-link ok-line mt-20 border rounded border-4 fw-bold lh-lg fs-18 color-f hov-color-a bdr-a hov-bdr-a bg-a hov-bg-f" href="">More Videos</a>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xxl-6 col-xl-6 col-lg-6">
        <div class="embed-container ok-icode ok-vimeo w-100" data-vidid="https://player.vimeo.com/video/640499893">
          <img src="https://vumbnail.com/640499893.jpg" width="100%">
          <i class="fab fa-youtube"></i>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-30')){
		$('#ok-sortable-section .block-30').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row g-4 ok-row d-flex align-items-center">
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-6 col-xsm-6">
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/1-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/1-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/2-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/2-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-6 col-xsm-6">
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/3-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/3-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/4-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/4-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-6 col-xsm-6">
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/5-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/5-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/6-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/6-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-lg-6 col-md-6 col-sm-6 col-xsm-6">
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/7-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/7-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card rounded ok-card no-bdr no-bg w-100 mb-25">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/8-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/8-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-31')){
		$('#ok-sortable-section .block-31').append(`
<section class="ok-section py-0 display-none-dp">
  <div class="container-fluid cw-100">
    <div class="row ok-row">
      <div class="ok-column col-xl-3 col-xxl-3 col-md-6 col-sm-6 col-xsm-6 p-0 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mb-0">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/9-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/9-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-md-6 col-sm-6 col-xsm-6 p-0 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mb-0">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/10-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/10-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-md-6 col-sm-6 col-xsm-6 p-0 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mb-0">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/11-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/11-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-xl-3 col-xxl-3 col-md-6 col-sm-6 col-xsm-6 p-0 col-lg-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mb-0">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/12-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/12-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-32')){
		$('#ok-sortable-section .block-32').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row g-0">
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-12 p-20">
        <h2 class="fw-bold ok-text mb-0 font-b color-e fs-52">Gallery with Popup Slider</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-40">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus.</p>
      </div>
      <div class="ok-column col-sm-6 col-xsm-6 col-xl-4 col-xxl-4 col-lg-4 col-md-6 p-10">
        <div class="card ok-card no-bdr no-bg w-100 mb-0 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/13-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/13-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-6 col-xsm-6 col-xxl-4 col-xl-4 p-10 col-lg-4 col-md-6">
        <div class="card ok-card no-bdr no-bg w-100 mb-20 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/14-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/14-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg w-100 mb-0 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/15-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/15-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-33')){
		$('#ok-sortable-section .block-33').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row g-0">
      <div class="ok-column col-sm-6 col-xsm-6 col-xxl-4 col-xl-4 p-10 col-lg-4 col-md-6">
        <div class="card ok-card no-bdr no-bg w-100 mb-20 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/16-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/16-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg w-100 mb-0 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/17-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/17-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-6 col-xsm-6 col-xxl-4 col-xl-4 p-10 col-lg-4 col-md-6">
        <div class="card ok-card no-bdr no-bg w-100 mb-20 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/18-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/18-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg w-100 mb-0 rounded">
          <div class="card-body p-0">
            <a href="`+domainName+`/assets/img/19-gallery.jpg" data-description="" data-type="image" data-height="auto" data-zoomable="true" class="glightbox ok-link-image">
              <img class="w-100" src="`+domainName+`/assets/img/19-gallery.jpg" alt="image">
            </a>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-12 p-20">
        <h2 class="fw-bold ok-text mb-0 font-b color-e fs-52">Gallery with Popup Slider</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-40">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus.</p>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-34')){
		$('#ok-sortable-section .block-34').append(`
<section class="py-100 ok-section bg-f display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Pricing Table</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row g-4 ok-row">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <h3 class="fw-bold ok-text lh-base font-b fs-24 color-k mt-20 mb-30 text-uppercase">Basic</h3>
            <p class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 fs-92 color-b">$6</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mt-0 mb-0">Per Month</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border border-2 fw-bold text-capitalize mb-20 mt-50 rounded-pill bdr-k color-k hov-color-e hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <h3 class="fw-bold ok-text lh-base font-b fs-24 color-k mt-20 mb-30 text-uppercase">Premium</h3>
            <p class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 fs-92 color-b">$15</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mt-0 mb-0">Per Month</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border border-2 fw-bold text-capitalize mb-20 mt-50 rounded-pill color-b hov-color-e bdr-b hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">            
            <h3 class="fw-bold ok-text lh-base font-b fs-24 color-k mt-20 mb-30 text-uppercase">Ultimate</h3>
            <p class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 fs-92 color-b">$25</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mt-0 mb-0">Per Month</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border border-2 fw-bold text-capitalize mb-20 mt-50 rounded-pill bdr-k color-k hov-color-e hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-34-a')){
		$('#ok-sortable-section .block-34-a').append(`
<section class="py-100 ok-section bg-j display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-sm-12 text-xl-center col-xxl-6 col-xl-6 col-md-12 col-lg-7">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Plans That Meet Your Needs</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row ok-row d-flex justify-content-center g-4">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 mb-30 text-uppercase color-e fw-bold">
              <u>Basic</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-a">$10</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 mb-0 color-k">Per Month</p>
            <p class="ok-text font-b lh-base color-k fs-18 mt-30 mb-35">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border border-2 fw-bold text-capitalize mb-20 rounded-0 bdr-e hov-bdr-k color-e hov-color-k mt-0" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 mb-30 text-uppercase color-e fw-bold">
              <u>Premium</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-c">$25</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 mb-0 color-k">Per Month</p>
            <p class="ok-text font-b lh-base color-k fs-18 mt-30 mb-35">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 w-100 mt-0 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-34-b')){
		$('#ok-sortable-section .block-34-b').append(`
<section class="py-100 ok-section bg-j display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b mb-0 fs-32 color-e">Pricing Table</h2>
        <p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row g-4 ok-row">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <h3 class="fw-bold ok-text lh-base font-b fs-24 text-uppercase mt-20 mb-0 color-e">Basic</h3>
            <div class="rounded-circle fs-32 ok-link ok-line ok-icon mb-0 hw-90 bg-j mt-25 color-b">
              <i class="fas fa-trophy"></i>
            </div>
            <h3 class="fw-bold ok-text lh-base font-b color-k fs-42 mt-25 mb-25">
              <b>
                <font color="#fd0055">$25</font>
              </b>
              <sub>/mo</sub>
            </h3>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">1 user</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">10 GB storage</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">Email support</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">Lifetime updates</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border fw-bold text-capitalize mb-20 rounded-pill color-f bdr-b hov-bdr-b border-3 bg-b hov-bg-f hov-color-b mt-35" href="#">Buy Now</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <h3 class="fw-bold ok-text lh-base font-b fs-24 text-uppercase mt-20 mb-0 color-e">Plus</h3>
            <div class="rounded-circle ok-link ok-line ok-icon mb-0 hw-90 mt-25 fs-52 color-f bg-d">
              <i class="fas fa-burn"></i>
            </div>
            <h3 class="fw-bold ok-text lh-base font-b color-k fs-42 mt-25 mb-25">
              <b>
                <font color="#fd0055">$45</font>
              </b>
              <sub>/mo</sub>
            </h3>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">10 users</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">50 GB storage</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">Email support</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">Lifetime updates</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border fw-bold text-capitalize mb-20 rounded-pill border-3 mt-35 color-f hov-color-d bg-d hov-bg-f bdr-d hov-bdr-d" href="#">Buy Now</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <h3 class="fw-bold ok-text lh-base font-b fs-24 text-uppercase mt-20 mb-0 color-e">Premium</h3>
            <div class="rounded-circle fs-32 ok-link ok-line ok-icon mb-0 hw-90 bg-j mt-25 color-b">
              <i class="fas fa-chess-queen"></i>
            </div>
            <h3 class="fw-bold ok-text lh-base font-b color-k fs-42 mt-25 mb-25">
              <b>
                <font color="#fd0055">$65</font>
              </b>
              <sub>/mo</sub>
            </h3>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">100 users</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">100 GB storage</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">Email support</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b color-k fs-18 mb-0 mt-10">Lifetime updates</p>
            <a class="fs-18 lh-lg font-b btn ok-link ok-line border fw-bold text-capitalize mb-20 rounded-pill color-f bdr-b hov-bdr-b border-3 bg-b hov-bg-f hov-color-b mt-35" href="#">Buy Now</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-34-c')){
		$('#ok-sortable-section .block-34-c').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-sm-12 text-xl-center col-xxl-6 col-xl-6 col-md-12 col-lg-7">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Plans That Meet Your Needs</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mt-15 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row ok-row d-flex justify-content-center g-4">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/15-gallery.jpg" class="w-100 ok-image mt-15 mb-0" alt="">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 text-uppercase color-e fw-bold mb-20">
              <u>Basic</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-c">$25</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 color-k mb-20">Per Month</p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-a">
                <i class="fas fa-times"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-a">
                <i class="fas fa-times"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 w-100 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e mt-25" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/16-gallery.jpg" class="w-100 ok-image mt-15 mb-0" alt="">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 text-uppercase color-e fw-bold mb-20">
              <u>High Class</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-c">$35</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 color-k mb-20">Per Month</p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-a">
                <i class="fas fa-times"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 w-100 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e mt-25" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/10-gallery.jpg" class="w-100 ok-image mt-15 mb-0" alt="">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 text-uppercase color-e fw-bold mb-20">
              <u>Supreme</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-c">$45</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 color-k mb-20">Per Month</p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <p class="ok-link ok-list fs-18 font-b mt-10 mb-0">
              <span class="ok-list-icon pe-3 color-c">
                <i class="fas fa-check"></i>
              </span>
              <span class="ok-list-text color-k">Lorem ipsum dolor sit amet.</span>
            </p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 w-100 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e mt-25" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-34-d')){
		$('#ok-sortable-section .block-34-d').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row justify-content-center g-4 d-flex align-items-center">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k mb-20">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon border color-k bdr-e border-1">
              <i class="fas fa-air-freshener"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Instant Solutions</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-k border border-1 bdr-k">
              <i class="fas fa-chess-knight"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Targeting Market</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k mb-20">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-k border border-1 bdr-k">
              <i class="fas fa-car-side"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">Powerful Techniques</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f text-start">
            <div class="hw-65 rounded-circle fs-32 mb-25 ok-link ok-line ok-icon color-k border border-1 bdr-k">
              <i class="fas fa-crown"></i>
            </div>
            <h2 class="fw-bold ok-text text-capitalize lh-base mt-0 mb-0 color-e font-b fs-18">100% Satisfaction</h2>
            <p class="ok-text text-capitalize mb-0 color-k fw-normal font-b fs-16 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 col-md-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded border border-1 bdr-k">
          <div class="card-body p-20 bg-f">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 mb-30 color-e fw-bold">Master Plan</h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b fs-92 lh-1 color-e mt-40">$25</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 mb-0 color-k">Per Month</p>
            <p class="ok-text font-b lh-base color-k fs-18 mt-50 mb-45">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 w-100 mt-0 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-34-e')){
		$('#ok-sortable-section .block-34-e').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center g-4">
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-12 p-20">
        <h2 class="fw-bold ok-text mb-0 font-b color-e fs-52">Plans That Meet Your Needs</h2>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-40">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus.</p>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-b">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 mb-30 text-uppercase fw-bold color-f">
              <u>Basic</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-f">$10</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 mb-0 color-f">Per Month</p>
            <p class="ok-text font-b lh-base fs-18 mt-30 mb-35 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 color-e mt-0 bg-f w-100 bdr-f hov-color-e hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-d">
            <h3 class="ok-text lh-base font-b fs-24 mt-20 mb-30 text-uppercase fw-bold color-e">
              <u>Premium</u>
            </h3>
            <p class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 fs-92 lh-1 color-e">$25</p>
            <p class="fw-bold ok-text text-capitalize lh-base font-b fs-18 mt-0 mb-0 color-e">Per Month</p>
            <p class="ok-text font-b lh-base fs-18 mt-30 mb-35 color-e">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <a class="fs-18 lh-lg font-b btn ok-link border border-2 fw-bold text-capitalize mb-20 rounded-0 w-100 mt-0 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e" href="#">Choose Plan</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35')){
		$('#ok-sortable-section .block-35').append(`
<section class="py-100 ok-section bg-j display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row align-items-center ok-row g-5">
      <div class="ok-column col-xl-4 col-xxl-4 col-lg-4 col-sm-12 col-md-12">
        <h3 class="fw-bold ok-text mb-0 font-b color-e fs-52">Professional & experienced coaches</h3>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-40">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus.</p>
      </div>
      <div class="ok-column col-xl-8 col-xxl-8 col-lg-8 col-sm-12 col-md-12">
        <div class="swiper swiper-2 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/coach-1.jpg" alt="">
              <div class="card-body p-20 text-center bg-f">
                <h2 class="fs-24 fw-bold color-a mb-5 ok-text">Neil G</h2>
                <h3 class="font-b fs-18 fw-bold mb-30 ok-text">Fitness Coach</h3>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/coach-2.jpg" alt="">
              <div class="card-body p-20 text-center bg-f">
                <h2 class="fs-24 fw-bold color-a mb-5 ok-text">Samantha Smith</h2>
                <h3 class="font-b fs-18 fw-bold mb-30 ok-text">Yoga Coach</h3>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/coach-3.jpg" alt="">
              <div class="card-body p-20 text-center bg-f">
                <h2 class="fs-24 fw-bold color-a mb-5 ok-text">Tim Abell</h2>
                <h3 class="font-b fs-18 fw-bold mb-30 ok-text">Zumba Trainer</h3>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/coach-4.jpg" alt="">
              <div class="card-body p-20 text-center bg-f">
                <h2 class="fs-24 fw-bold color-a mb-5 ok-text">Jack Mario</h2>
                <h3 class="font-b fs-18 fw-bold mb-30 ok-text">CrossFit Coach</h3>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-a')){
		$('#ok-sortable-section .block-35-a').append(`
<section class="py-100 ok-section bg-f display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex align-items-center">
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 p-50 col-md-12">
        <h3 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mt-0 mb-0 fs-64">Team</h3>
        <p class="ok-text font-b lh-base color-k fs-18 mt-20 mb-25">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <p class="ok-text font-b lh-base mb-0 color-e fs-24 fw-bold mt-0">
          <a href="#" class="is-link color-e">
            <u>Learn More</u>
          </a>
          <br>
        </p>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mb-20">
          <img src="`+domainName+`/assets/img/1-people.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-2"></div>
          <div class="card-body p-20 text-center card-img-overlay d-flex align-items-end">
            <div>
              <h3 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 color-f fs-32">Ann Johnson</h3>
              <p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 col-md-6">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0 mb-20">
          <img src="`+domainName+`/assets/img/2-people.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-2"></div>
          <div class="card-body p-20 text-center card-img-overlay d-flex align-items-end">
            <div>
              <h3 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 color-f fs-32">Marij Otte</h3>
              <p class="ok-text text-capitalize fw-normal font-b fs-16 mt-15 mb-20 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-b')){
		$('#ok-sortable-section .block-35-b').append(`
<section class="py-100 ok-section bg-e display-none-dp">
  <div class="container-fluid cw-85">
	<div class="row ok-row mb-50 d-flex justify-content-center">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
		<h2 class="ok-text fw-bold lh-sm text-capitalize font-b mb-0 fs-32 color-f">Meet Our Team</h2>
        <p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-j">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row ok-row">
      <div class="ok-column col">
        <div class="swiper swiper-3 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Neil G</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Creative Leader</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/4-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Samantha Smith</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Developer</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/5-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Tim Abell</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Designer</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">
              <div class="card-body p-20 text-center bg-f">
			  	<img src="`+domainName+`/assets/img/6-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Jack Mario</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Animator</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-c')){
		$('#ok-sortable-section .block-35-c').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 g-0">
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 col-xl-6 col-xxl-6">
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-52">Meet The Team <br>
          <u>Our </u>Professionals <br>
        </h2>
      </div>
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 col-xl-5 col-xxl-5">
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">
          <i>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</i>
        </p>
        <a class="fs-18 lh-lg font-b btn ok-link ok-line border fw-bold text-capitalize color-f bdr-b hov-bdr-b border-3 bg-b hov-bg-f hov-color-b mt-35 rounded-0 mb-0" href="#">Read More</a>
      </div>
    </div>
    <div class="row g-4 ok-row">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body bg-f p-20">
            <img src="`+domainName+`/assets/img/6-people.jpg" class="ok-image w-100 mt-0 mb-30" alt="">
            <h2 class="fw-bold ok-text lh-base mb-0 color-e font-b mt-0 fs-24 text-uppercase">Alex Greenfield</h2>
            <p class="ok-text text-capitalize font-b fs-16 mt-0 color-e fw-bold mb-30">Creative Leader</p>
            <div class="ok-group-container ok-flex d-flex gap-3 ok-link-arrow">
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-facebook-f"></i>
              </a>
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-twitter"></i>
              </a>
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-youtube"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body bg-f p-20">
            <img src="`+domainName+`/assets/img/4-people.jpg" class="ok-image w-100 mt-0 mb-30" alt="">
            <h2 class="fw-bold ok-text lh-base mb-0 color-e font-b mt-0 fs-24 text-uppercase">Roxie Swanson</h2>
            <p class="ok-text text-capitalize font-b fs-16 mt-0 color-e fw-bold mb-30">Web Designer</p>
            <div class="ok-group-container ok-flex d-flex gap-3 ok-link-arrow">
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-facebook-f"></i>
              </a>
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-twitter"></i>
              </a>
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-youtube"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded border bdr-j border-5">
          <div class="card-body bg-f p-20">
            <img src="`+domainName+`/assets/img/3-people.jpg" class="ok-image w-100 mt-0 mb-30" alt="">
            <h2 class="fw-bold ok-text lh-base mb-0 color-e font-b mt-0 fs-24 text-uppercase">Jeffry Brown</h2>
            <p class="ok-text text-capitalize font-b fs-16 mt-0 color-e fw-bold mb-30">Programming Guru</p>
            <div class="ok-group-container ok-flex d-flex gap-3 ok-link-arrow">
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-facebook-f"></i>
              </a>
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-twitter"></i>
              </a>
              <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-e hov-color-k fs-24" href="#">
                <i class="fab fa-youtube"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-d')){
		$('#ok-sortable-section .block-35-d').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 g-0 d-flex justify-content-center">
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center col-xl-8 col-xxl-8">
        <h3 class="ok-text fw-bold lh-sm font-b fs-18 text-uppercase mb-10 color-k">Testimonials <br>
        </h3>
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b mb-0 fs-52 color-c">What Clients Say <br>
        </h2>
        <p class="ok-text font-b lh-base mb-0 mt-25 fs-18 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row ok-row g-4">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
          <div class="card-body p-20 bg-j text-center">
            <div class="ok-link ok-icon rounded-0 color-k mb-0 fs-24 hw-30 mt-25">
              <i class="fas fa-quote-left"></i>
            </div>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 color-k mb-0 fs-24 hw-30">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 color-c text-capitalize mt-20">Nat Reynolds <br>
            </h2>
            <p class="ok-text text-capitalize font-b mt-0 mb-30 fw-normal fs-18 lh-base color-k">Sales Manager</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
          <div class="card-body p-20 bg-j text-center">
            <div class="ok-link ok-icon rounded-0 color-k mb-0 fs-24 hw-30 mt-25">
              <i class="fas fa-quote-left"></i>
            </div>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 color-k mb-0 fs-24 hw-30">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 color-c text-capitalize mt-20">Celia Almeda <br>
            </h2>
            <p class="ok-text text-capitalize font-b mt-0 mb-30 fw-normal fs-18 lh-base color-k">Chief Accountant</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 col-md-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded-0">
          <div class="card-body p-20 bg-j text-center">
            <div class="ok-link ok-icon rounded-0 color-k mb-0 fs-24 hw-30 mt-25">
              <i class="fas fa-quote-left"></i>
            </div>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 color-k mb-0 fs-24 hw-30">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 color-c text-capitalize mt-20">Bob Roberts <br>
            </h2>
            <p class="ok-text text-capitalize font-b mt-0 mb-30 fw-normal fs-18 lh-base color-k">Secretary</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-e')){
		$('#ok-sortable-section .block-35-e').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex align-items-center">
      <div class="ok-column col-sm-12 col-md-6 col-xl-8 col-xxl-8 col-lg-7 p-40 bg-i">
        <div class="ok-link ok-icon mb-0 mt-25 rounded-circle hw-50 fs-24 bg-f color-c">
          <i class="fas fa-quote-left"></i>
        </div>
        <p class="ok-text font-b mt-20 mb-30 lh-base fs-24 color-e"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut. Donec pellentesque fermentum felis sit amet varius. </p>
        <p class="ok-text lh-base font-a fs-42 fw-bold mb-0 mt-0 color-e">Roxie Swanson</p>
        <p class="ok-text font-b color-k fs-24 lh-base mt-0 mb-0">CEO &amp; Founder, Example LLC</p>
      </div>
      <div class="ok-column col-sm-12 col-md-6 col-xl-4 col-xxl-4 col-lg-5">
        <img src="`+domainName+`/assets/img/7-people.jpg" class="w-100 ok-image" alt="">
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-f')){
		$('#ok-sortable-section .block-35-f').append(`
<section class="py-50 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row">
	  <div class="ok-column col-xl-7 col-xxl-7 col-lg-6 col-md-6 col-sm-12">
		<h2 class="fw-bold mb-5 ok-text color-e fs-52">Over 10,000+ Happy Customers Worldwide</h2>
		<p class="ok-text font-b lh-base fs-18 color-k mt-30 mb-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus. Pellentesque auctor tellus at nunc elementum, sit amet maximus metus eleifend.</p>
	  </div>
      <div class="ok-column col-xl-5 col-lg-6 col-md-6 col-sm-12 col-xxl-5">
        <div class="swiper swiper-1 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
				<img class="hw-100 rounded-circle mb-25 ok-image" src="`+domainName+`/assets/img/client-2.jpg" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Neil G</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Creative Leader</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/client-1.jpg" class="hw-100 rounded-circle mb-25 ok-image" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Samantha Smith</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Developer</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/client-3.jpg" class="hw-100 rounded-circle mb-25 ok-image" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Tim Abell</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Designer</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/client-4.jpg" class="hw-100 rounded-circle mb-25 ok-image" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Jack Mario</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Animator</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-g')){
		$('#ok-sortable-section .block-35-g').append(`
<section class="py-50 ok-section display-none-dp">
  <div class="container-fluid cw-85">
	<div class="row ok-row mb-50 g-0 d-flex justify-content-center">
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center col-xl-8 col-xxl-8">
        <h3 class="ok-text fw-bold lh-sm font-b text-uppercase mb-10 color-e fs-32">Customer Testimonials</h3>
      </div>
    </div>
    <div class="row ok-row">
      <div class="ok-column col">
        <div class="swiper swiper-3 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center bg-j">
				<img class="hw-100 rounded-circle mb-25 ok-image" src="`+domainName+`/assets/img/client-2.jpg" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Neil G</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Creative Leader</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center bg-j">
			  	<img src="`+domainName+`/assets/img/client-1.jpg" class="hw-100 rounded-circle mb-25 ok-image" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Samantha Smith</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Developer</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center bg-j">
			  	<img src="`+domainName+`/assets/img/client-3.jpg" class="hw-100 rounded-circle mb-25 ok-image" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Tim Abell</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Designer</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center bg-j">
			  	<img src="`+domainName+`/assets/img/client-4.jpg" class="hw-100 rounded-circle mb-25 ok-image" alt="">
                <h2 class="fs-24 fw-bold mb-5 ok-text color-e">Jack Mario</h2>
                <h3 class="font-b fs-18 fw-bold ok-text mb-0 mt-0 color-k">Animator</h3>
				<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
                <div class="ok-group-container ok-flex d-flex gap-3 justify-content-center ok-link-arrow">
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-facebook-f"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-twitter"></i>
                  </a>
                  <a class="hw-40 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-f bg-k hov-bg-e" href="#">
                    <i class="fab fa-youtube"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-h')){
		$('#ok-sortable-section .block-35-h').append(`
<section class="py-100 ok-section bg-d display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 g-0 d-flex justify-content-center">
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center col-xl-8 col-xxl-8">
        <h3 class="ok-text fw-bold lh-sm font-b fs-18 text-uppercase mb-10 color-e">Testimonials</h3>
        <h2 class="ok-text fw-bold lh-sm text-capitalize font-b mb-0 fs-52 color-e">What they say about us</h2>
        <p class="ok-text font-b lh-base mb-0 mt-25 color-e fs-24">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row ok-row g-4">
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img class="hw-100 rounded-circle mb-25 ok-image" src="`+domainName+`/assets/img/client-2.jpg" alt="">
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 mb-0 fs-24 hw-30 color-d">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 text-capitalize mt-20 color-e">Nat Reynolds</h2>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 lh-base color-e mb-10">Sales Manager</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img class="hw-100 rounded-circle mb-25 ok-image" src="`+domainName+`/assets/img/client-1.jpg" alt="">
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 mb-0 fs-24 hw-30 color-d">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 text-capitalize mt-20 color-e">Celia Almeda</h2>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 lh-base color-e mb-10">Chief Accountant</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-4 col-xxl-4 col-lg-4 col-md-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img class="hw-100 rounded-circle mb-25 ok-image" src="`+domainName+`/assets/img/client-4.jpg" alt="">
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 mb-0 fs-24 hw-30 color-d">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 text-capitalize mt-20 color-e">Bob Roberts</h2>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 lh-base color-e mb-10">Secretary</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-i')){
		$('#ok-sortable-section .block-35-i').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center">
      <div class="ok-column col-sm-12 col-xxl-6 col-xl-6 col-lg-8 col-md-10 text-xl-center text-lg-center text-md-center text-sm-center">
        <h1 class="fw-bold ok-text color-e fs-42 font-b mb-0">You are in good company</h1>
        <h1 class="mb-50 ok-text font-b color-k mt-25 fw-normal fs-24">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</h1>
      </div>
    </div>
    <div class="row ok-row g-1 d-flex justify-content-center">
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body bg-f text-center p-20">
            <img src="`+domainName+`/assets/img/brand-1.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/brand-2.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/brand-3.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/brand-4.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/brand-5.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/brand-6.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
      <div class="ok-column col-md-4 col-sm-6 col-xsm-6 col-xxl-3 col-lg-3 col-xl-3">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img src="`+domainName+`/assets/img/brand-7.png" class="ok-image" alt="" width="80%">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-j')){
		$('#ok-sortable-section .block-35-j').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center g-3">
      <div class="ok-column col-sm-12 col-lg-4 col-xl-6 col-xxl-6 col-md-10">
        <h3 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mt-0 mb-0 fs-52">You are in good company</h3>
        <p class="ok-text font-b lh-base color-k fs-18 mt-20 mb-25">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <p class="ok-text font-b lh-base mb-0 color-e fs-24 fw-bold mt-0">
          <a href="#" class="is-link color-e">
            <u>Learn More</u>
          </a>
          <br>
        </p>
      </div>
      <div class="ok-column col-xsm-6 col-xxl-3 col-xl-3 col-lg-4 col-sm-4 col-md-6">
        <div class="card ok-card no-bdr no-bg d-inline-block w-100 rounded-0 mb-10">
          <div class="card-body text-center bg-j p-30">
            <img src="`+domainName+`/assets/img/brand-1.png" class="ok-image w-100" alt="">
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg d-inline-block w-100 rounded-0 mb-10">
          <div class="card-body text-center bg-j p-30">
            <img src="`+domainName+`/assets/img/brand-2.png" class="ok-image w-100" alt="">
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg d-inline-block w-100 rounded-0 mb-10">
          <div class="card-body text-center bg-j p-30">
            <img src="`+domainName+`/assets/img/brand-3.png" class="ok-image w-100" alt="">
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-6 col-xsm-6 col-xxl-3 col-xl-3 col-lg-4 col-md-6">
        <div class="card ok-card no-bdr no-bg d-inline-block w-100 rounded-0 mb-10">
          <div class="card-body text-center bg-j p-30">
            <img src="`+domainName+`/assets/img/brand-4.png" class="ok-image w-100" alt="">
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg d-inline-block w-100 rounded-0 mb-10">
          <div class="card-body text-center bg-j p-30">
            <img src="`+domainName+`/assets/img/brand-5.png" class="ok-image w-100" alt="">
          </div>
        </div>
        <div class="card ok-card no-bdr no-bg d-inline-block w-100 rounded-0 mb-10">
          <div class="card-body text-center bg-j p-30">
            <img src="`+domainName+`/assets/img/brand-7.png" class="ok-image w-100" alt="">
          </div>
        </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-35-k')){
		$('#ok-sortable-section .block-35-k').append(`
<section class="py-50 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row">
      <div class="ok-column col">
        <div class="swiper swiper-4 w-100">
          <div class="swiper-wrapper ok-card-arrow">
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
				<img src="`+domainName+`/assets/img/brand-1.png" class="ok-image" alt="" width="80%">
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/brand-2.png" class="ok-image" alt="" width="80%">
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/brand-3.png" class="ok-image" alt="" width="80%">
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/brand-4.png" class="ok-image" alt="" width="80%">
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/brand-5.png" class="ok-image" alt="" width="80%">
              </div>
            </div>
            <div class="swiper-slide card ok-card no-bdr no-bg rounded">
              <div class="card-body p-20 text-center">
			  	<img src="`+domainName+`/assets/img/brand-6.png" class="ok-image" alt="" width="80%">
              </div>
            </div>
          </div>    
          <div class="ok-swiper-btn swiper-ctrl-prev fs-24 hw-60">
            <i class="fas fa-chevron-left"></i>
          </div>
          <div class="ok-swiper-btn swiper-ctrl-next fs-24 hw-60">
            <i class="fas fa-chevron-right"></i>
          </div>		  
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-36')){
		$('#ok-sortable-section .block-36').append(`
<section class="ok-section bg-j py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row">
      <div class="ok-column col">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body text-center p-50 bg-e">
            <h4 class="fw-bold ok-text text-capitalize lh-base mb-0 color-f font-b fs-64 mt-45">Join our team!</h4>
            <a class="lh-lg font-b btn rounded-pill ok-link ok-line text-uppercase mt-25 mb-45 fw-normal fs-24 bg-d hov-bg-f hov-color-e color-e" href="#">Join Now</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-36-a')){
		$('#ok-sortable-section .block-36-a').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row g-5 d-flex align-items-center">
      <div class="ok-column col-sm-12 col-xl-5 col-xxl-5 col-lg-5 col-md-5 p-20 bg-h">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 bg-f text-center">
            <img class="hw-100 rounded-circle mb-25 ok-image" src="`+domainName+`/assets/img/client-2.jpg" alt="">
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 color-k mb-0 lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
            <div class="ok-link ok-icon rounded-0 mb-0 fs-24 hw-30 color-b">
              <i class="fas fa-quote-right"></i>
            </div>
            <h2 class="fw-bold ok-text lh-base mb-0 font-b fs-24 text-capitalize mt-20 color-e">Nat Reynolds</h2>
            <p class="ok-text text-capitalize font-b mt-0 fw-normal fs-18 lh-base color-e mb-10">Sales Manager</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xl-7 col-xxl-7 col-lg-7 col-md-7">
        <h4 class="fw-bold mb-25 ok-text font-b color-e fs-76 mt-0">Start connecting your business to one place</h4>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow mt-20">
          <a class="font-b btn ok-link ok-line fs-24 lh-lg border border-4 fw-bold color-b hov-color-f hov-bg-e bdr-b hov-bdr-e rounded-0" href="">Get Started</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-36-b')){
		$('#ok-sortable-section .block-36-b').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row">
      <div class="ok-column col">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body text-center p-50 bg-c">
            <h4 class="fw-bold ok-text text-capitalize lh-base color-f font-b fs-64 mt-0 mb-20">Subscribe our daily tips</h4>
            <form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank">
              <div class="ok-flex noflex-mob d-xxl-flex d-xl-flex d-lg-flex d-md-flex gap-3 justify-content-center">
                <div class="noflex-child ok-name-field">
                  <label class="visually-hidden">First Name</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded" type="text" name="FNAME" placeholder="Full Name" required="">
                </div>
                <div class="noflex-child ok-email-field">
                  <label class="visually-hidden">Email Address</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded" type="email" name="EMAIL" placeholder="Email address" required="">
                </div>
                <div class="ok-submit-field">
                  <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded bg-d hov-bg-f color-e hov-color-e">
                </div>
              </div>
              <div class="mc-status"></div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-36-c')){
		$('#ok-sortable-section .block-36-c').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row align-items-center d-flex justify-content-center">
      <div class="ok-column col-sm-12 col-md-6 col-xl-8 col-xxl-8 col-lg-7 p-40">
        <h4 class="ok-text fw-bold mb-0 mt-0 color-e font-b lh-sm fs-52">Start getting advance analytics of your startup</h4>
      </div>
      <div class="ok-column col-sm-12 col-md-6 col-xl-4 col-xxl-4 col-lg-5">
        <a class="font-b btn ok-link ok-line fs-24 lh-lg border border-4 fw-bold color-b hov-color-f hov-bg-e bdr-b hov-bdr-e rounded-0 mt-0" href="">Get Started Now</a>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-36-d')){
		$('#ok-sortable-section .block-36-d').append(`
<section class="ok-section bg-image py-60 display-none-dp" style="background-image: url(assets/img/3-wallpaper.jpg);">
  <div class="bg-overlay op-8 bg-b"></div>
  <div class="container-fluid cw-85 layer-2">
    <div class="row g-5 ok-row d-flex align-items-center">
      <div class="mx-auto ok-column col-md-6 col-sm-12 text-lg-center text-md-center text-sm-center text-xl-center col-xl-5 col-xxl-5 col-lg-6">
        <div class="card ok-card no-bdr no-bg border border-2 bdr-j hov-bdr-j d-inline-block w-100 rounded">
          <div class="card-body p-50 text-end bg-f">
            <h4 class="ok-text font-b lh-base color-e text-start mt-0 mb-0 fs-32 fw-bold">Get Early Access</h4>
            <p class="ok-text font-b color-k fs-18 lh-base text-start mt-20 mb-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank">
              <div class="d-grid gap-3">
                <div class="ok-name-field">
                  <label class="visually-hidden">First Name</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded" type="text" name="FNAME" placeholder="Full Name" required="">
                </div>
                <div class="ok-email-field">
                  <label class="visually-hidden">Email Address</label>
                  <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded" type="email" name="EMAIL" placeholder="Email address" required="">
                </div>
                <div class="ok-submit-field">
                  <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded text-capitalize bg-d hov-bg-e color-e hov-color-f">
                </div>
              </div>
              <div class="mc-status"></div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-36-e')){
		$('#ok-sortable-section .block-36-e').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row justify-content-center">
      <div class="ok-column text-xl-center text-lg-center text-md-center text-sm-center col-xl-6 col-xxl-6 col-lg-7 col-md-8 col-sm-12">
        <h1 class="ok-text fw-bold lh-sm text-capitalize font-b color-e fs-52 mb-0">Download The App</h1>
        <p class="ok-text font-b lh-base mb-40 color-k fs-18 mt-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="ok-group-container ok-flex d-flex align-items-center gap-4 ok-link-arrow justify-content-xl-center justify-content-lg-center justify-content-md-center justify-content-sm-center">
          <a class="fs-18 font-b btn ok-link ok-line text-uppercase rounded fw-normal border border-3 bg-e hov-bg-f color-f hov-color-e bdr-e hov-bdr-e mb-0" href="#">From App Store</a>
          <a class="fs-18 font-b btn ok-link ok-line text-uppercase rounded border fw-normal border-3 color-e hov-color-f hov-bg-e bdr-e hov-bdr-e mb-0" href="#">From Play Store</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-37')){
		$('#ok-sortable-section .block-37').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-30">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h4 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Latest blog posts</h4>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row g-4 ok-row">
      <div class="ok-column col-md-6 col-xxl-3 col-xl-3 col-lg-3 col-sm-6">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <img src="`+domainName+`/assets/img/service-5.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-4"></div>
          <div class="card-body p-20 card-img-overlay d-flex align-items-end">
            <div>
              <h5 class="fw-bold ok-text text-capitalize mb-0 font-b mt-0 color-f fs-24 lh-base">Build Beautiful Websites Without Code</h5>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <img src="`+domainName+`/assets/img/service-6.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-4"></div>
          <div class="card-body p-20 card-img-overlay d-flex align-items-end">
            <div>
              <h5 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 color-f fs-24">Build Your Online Presence in Minutes</h5>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <img src="`+domainName+`/assets/img/service-4.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-4"></div>
          <div class="card-body p-20 card-img-overlay d-flex align-items-end">
            <div>
              <h5 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 color-f fs-24">Save time and money on building your next website</h5>
            </div>
          </div>
        </div>
      </div>
      <div class="ok-column col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <img src="`+domainName+`/assets/img/1-blog.jpg" class="d-block w-100 ok-image ok-card-image-overlay" alt="">
          <div class="ok-card-overlay card-overlay bg-e op-4"></div>
          <div class="card-body p-20 card-img-overlay d-flex align-items-end">
            <div>
              <h5 class="fw-bold ok-text text-capitalize lh-base mb-0 font-b mt-0 color-f fs-24">Build Your Next Website Without Code</h5>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-37-a')){
		$('#ok-sortable-section .block-37-a').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-30">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h4 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Latest blog posts</h4>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row align-items-center ok-row g-3">
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/19-gallery.jpg" alt="">
          <div class="card-body p-20">
            <p class="fw-bold mb-5 ok-text font-b fs-18 color-b">Product</p>
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Beautiful Websites Without Code</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 24, 2022</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/16-gallery.jpg" alt="">
          <div class="card-body p-20">
            <p class="fw-bold mb-5 ok-text font-b fs-18 color-d">Article</p>
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Your Next Website Without Code</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 23, 2022</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-12">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <img class="w-100 ok-image ok-top-card-image" src="`+domainName+`/assets/img/18-gallery.jpg" alt="">
          <div class="card-body p-20">
            <p class="fw-bold mb-5 ok-text font-b fs-18 color-c">Product</p>
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Save time and money on building your next website</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 22, 2022</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-37-b')){
		$('#ok-sortable-section .block-37-b').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-30">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h4 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Latest blog posts</h4>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row align-items-center ok-row g-3">
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <div class="card-body p-20">
            <p class="fw-bold mb-5 ok-text font-b fs-18 color-b">Product</p>
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Beautiful Websites Without Code</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 24, 2022</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <div class="card-body p-20">
            <p class="fw-bold mb-5 ok-text font-b fs-18 color-d">Article</p>
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Your Next Website Without Code</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 23, 2022</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-12">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <div class="card-body p-20">
            <p class="fw-bold mb-5 ok-text font-b fs-18 color-c">Product</p>
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Save time and money on building your next website</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 22, 2022</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-37-c')){
		$('#ok-sortable-section .block-37-c').append(`
<section class="ok-section py-70 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex align-items-center g-0 mb-20 bg-e">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-5 col-xxl-5">
        <img src="`+domainName+`/assets/img/4-blog.jpg" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-7 col-xxl-7 p-20">
        <h5 class="fw-bold ok-text font-b fs-32 mt-0 mb-20 color-f">What's the best way to enhance your App? </h5>
        <p class="ok-text font-b lh-base fs-18 mt-0 mb-0 color-j">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus.</p>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow mt-20">
          <a class="font-b btn ok-link ok-line lh-lg fw-bold fs-18 color-e hov-color-e bg-d hov-bg-f rounded-0" href="">Read More</a>
        </div>
      </div>
    </div>
    <div class="row ok-row d-flex align-items-center g-0 flex-row-reverse bg-e">
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-5 col-xxl-5">
        <img src="`+domainName+`/assets/img/3-blog.jpg" class="w-100 ok-image" alt="">
      </div>
      <div class="ok-column col-lg-6 col-md-6 col-sm-12 col-xl-7 col-xxl-7 p-20">
        <h5 class="fw-bold ok-text font-b fs-32 mt-0 mb-20 color-f">What's the best way to enhance your App? </h5>
        <p class="ok-text font-b lh-base fs-18 mt-0 mb-0 color-j">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus.</p>
        <div class="ok-group-container ok-flex d-flex ok-link-arrow mt-20">
          <a class="font-b btn ok-link ok-line lh-lg fw-bold fs-18 color-e hov-color-e bg-d hov-bg-f rounded-0" href="">Read More</a>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-37-d')){
		$('#ok-sortable-section .block-37-d').append(`
<section class="py-100 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-30">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h4 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Latest blog posts</h4>
        <p class="ok-text font-b lh-base color-k fs-18 mb-0 mt-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row align-items-center ok-row g-3">
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <div class="card-body p-20">
            <img src="`+domainName+`/assets/img/6-people.jpg" class="ok-image w-100 mt-0 mb-10" alt="">
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Beautiful Websites Without Code</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 24, 2022</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <div class="card-body p-20">
            <img src="`+domainName+`/assets/img/5-people.jpg" class="ok-image w-100 mt-0 mb-10" alt="">
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Build Your Next Website Without Code</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 23, 2022</p>
          </div>
        </div>
      </div>
      <div class="ok-column col-sm-12 col-xxl-4 col-xl-4 col-lg-4 col-md-12">
        <div class="card ok-card w-100 no-bdr no-bg rounded border bdr-j border-5">
          <div class="card-body p-20">
            <img src="`+domainName+`/assets/img/4-people.jpg" class="ok-image w-100 mt-0 mb-10" alt="">
            <h5 class="font-b fw-bold ok-text mt-10 mb-20 fs-24 lh-base color-e">Save time and money on building your next website</h5>
            <p class="mb-5 ok-text color-k fs-18 font-b">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <p class="ok-text font-b fs-16 color-k mt-20 mb-0">April 22, 2022</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-38')){
		$('#ok-sortable-section .block-38').append(`
<section class="ok-section py-60 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-0">
      <div class="ok-column text-lg-center text-md-center text-sm-center col-lg-12 col-md-12 col-sm-12 text-xl-center col-xxl-6 col-xl-6">
        <h6 class="ok-text fw-bold lh-sm text-capitalize font-b color-e mb-0 fs-32">Contact Us</h6>
        <p class="ok-text font-b lh-base color-k fs-18 mt-15 mb-15">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body p-20 mt-0 mb-0 bg-j">
		  <div class="form-wrap ok-icode ok-contact">
             <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
              <div class="form-floating mb-20 ok-name-field">
                <input class="btn-lg font-b form-control rounded" type="text" name="name" required="">
                <label class="ok-contact-name font-b fs-18">Full Name</label>
              </div>
              <div class="form-floating mb-20 ok-email-field">
                <input class="btn-lg font-b form-control rounded" type="email" name="email" required="">
                <label class="ok-email-id font-b fs-18">Email address</label>
              </div>
              <div class="form-floating mb-20 ok-message-field">
                <textarea class="btn-lg font-b form-control textarea-ht rounded" name="message" required=""></textarea>
                <label class="ok-message-id font-b fs-18">Message</label>
              </div>
			  <div class="ok-submit-field">
				<input type="submit" value="Submit" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize bg-b hov-bg-e color-f hov-color-f rounded">
			  </div>
            </form>
			</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-38-a')){
		$('#ok-sortable-section .block-38-a').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row justify-content-center mb-0 g-5 d-flex align-items-end">
      <div class="ok-column col-sm-12 col-xl-6 col-xxl-6 p-30 col-md-12 col-lg-5">
        <h6 class="ok-text fw-bold lh-sm text-capitalize font-b mt-0 mb-0 fs-64 color-e">Get In Touch</h6>
        <p class="ok-text font-b lh-base mt-20 mb-25 color-e fs-24">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
        <p class="ok-text font-b lh-base color-e fs-24 mt-0 mb-10">
          <u>OFFICE ADDRESS</u>
        </p>
        <p class="ok-text font-b lh-base mb-25 color-e fs-24 mt-0">Your address line1, <br>Your address line 2, NY 23425</p>
        <p class="ok-text font-b lh-base color-e fs-24 mt-0 mb-10">
          <u>CALL US:</u>
        </p>
        <p class="ok-text font-b lh-base color-e fs-24 mt-0 mb-0">(550) 555 675 456</p>
      </div>
      <div class="ok-column col-md-12 col-sm-12 col-xxl-6 col-xl-6 col-lg-7">
        <h2 class="ok-text fw-bold lh-sm font-b color-e fs-32 mb-20">Drop us a line</h2>
        <div class="form-wrap ok-icode ok-contact">
           <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
            <div class="form-floating mb-20 ok-name-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="text" name="name" required="">
              <label class="ok-contact-name font-b fs-18">Full Name</label>
            </div>
            <div class="form-floating mb-20 ok-email-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="email" name="email" required="">
              <label class="ok-email-id font-b fs-18">Email address</label>
            </div>
            <div class="form-floating mb-20 ok-message-field">
              <textarea class="btn-lg font-b form-control textarea-ht rounded bdr-e border-1" name="message" required=""></textarea>
              <label class="ok-message-id font-b fs-18">Message</label>
            </div>
            <div class="ok-submit-field">
              <input type="submit" value="Send Message" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize rounded form-control bg-e hov-bg-d color-f hov-color-e">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-38-b')){
		$('#ok-sortable-section .block-38-b').append(`
<section class="ok-section py-60 bg-h">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-0">
      <div class="ok-column text-lg-center text-md-center text-sm-center text-xl-center col-xl-6 col-xxl-6 col-lg-6 col-md-9 col-sm-12">
        <div class="card ok-card no-bdr no-bg w-100 rounded">
          <div class="card-body mt-0 mb-0 bg-b p-40">
            <h6 class="ok-text fw-bold lh-sm text-capitalize font-b mb-0 color-f fs-42">Get in touch</h6>
            <p class="ok-text font-b lh-base mt-15 color-f fs-18 mb-25">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>
            <div class="form-wrap ok-icode ok-contact">
               <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
                <div class="form-floating mb-20 ok-name-field">
                  <input class="btn-lg font-b form-control rounded border border-4 bdr-h" type="text" name="name" required="">
                  <label class="ok-contact-name font-b fs-18">Full Name</label>
                </div>
                <div class="form-floating mb-20 ok-email-field">
                  <input class="btn-lg font-b form-control rounded border border-4 bdr-h" type="email" name="email" required="">
                  <label class="ok-email-id font-b fs-18">Email address</label>
                </div>
                <div class="form-floating mb-20 ok-message-field">
                  <textarea class="btn-lg font-b form-control textarea-ht rounded border border-4 bdr-h" name="message" required=""></textarea>
                  <label class="ok-message-id font-b fs-18">Message</label>
                </div>
                <div class="ok-submit-field">
                  <input type="submit" value="Send Message" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize rounded form-control color-e hov-color-f bg-d hov-bg-e">
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-38-c')){
		$('#ok-sortable-section .block-38-c').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row justify-content-center mb-0 g-5 d-flex align-items-end">
      <div class="ok-column col-sm-12 col-xl-6 col-xxl-6 p-30 col-md-12 col-lg-5">
        <div class="map-wrapper ok-icode ok-map">
			<iframe width="100%" height="400" src="https://www.google.com/maps/embed/v1/place?key=AIzaSyA5gW9nuD43UvLZSEGkUaY0Gfrz4QCVTJ4&amp;q=Eiffel+Tower,Paris+France" title="a9mzf874" frameborder="0"></iframe>
		</div>
      </div>
      <div class="ok-column col-md-12 col-sm-12 col-xxl-6 col-xl-6 col-lg-7">
        <h2 class="ok-text fw-bold lh-sm font-b color-e fs-32 mb-20">Drop us a line</h2>
        <div class="form-wrap ok-icode ok-contact">
           <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
            <div class="form-floating mb-20 ok-name-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="text" name="name" required="">
              <label class="ok-contact-name font-b fs-18">Full Name</label>
            </div>
            <div class="form-floating mb-20 ok-email-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="email" name="email" required="">
              <label class="ok-email-id font-b fs-18">Email address</label>
            </div>
            <div class="form-floating mb-20 ok-message-field">
              <textarea class="btn-lg font-b form-control textarea-ht rounded bdr-e border-1" name="message" required=""></textarea>
              <label class="ok-message-id font-b fs-18">Message</label>
            </div>
            <div class="ok-submit-field">
              <input type="submit" value="Send Message" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize rounded form-control bg-e hov-bg-d color-f hov-color-e">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-38-d')){
		$('#ok-sortable-section .block-38-d').append(`
<section class="ok-section py-100 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row mb-50 g-0 d-flex justify-content-center">
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 text-xl-center text-lg-center text-md-center text-sm-center col-xl-8 col-xxl-8">
        <h6 class="ok-text fw-bold lh-sm text-capitalize font-b mb-0 fs-52 color-e">Contact Us</h6>
        <p class="ok-text font-b lh-base mb-0 mt-25 color-e fs-24">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida. Pellentesque posuere odio felis, non ultrices erat pellentesque ut.</p>
      </div>
    </div>
    <div class="row ok-row justify-content-center mb-0 g-5 flex-row-reverse">
      <div class="ok-column col-sm-12 col-xl-6 col-xxl-6 p-30 col-md-12 col-lg-5">
        <div class="map-wrapper ok-icode ok-map">
          <iframe width="100%" height="400" src="https://www.google.com/maps/embed/v1/place?key=AIzaSyA5gW9nuD43UvLZSEGkUaY0Gfrz4QCVTJ4&amp;q=Eiffel+Tower,Paris+France" title="a9mzf874" frameborder="0"></iframe>
        </div>
      </div>
      <div class="ok-column col-md-12 col-sm-12 col-xxl-6 col-xl-6 col-lg-7">
        <h2 class="ok-text fw-bold lh-sm font-b color-e fs-32 mb-20">Drop us a line</h2>
        <div class="form-wrap ok-icode ok-contact">
           <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
            <div class="form-floating mb-20 ok-name-field">
              <input class="btn-lg font-b form-control rounded border bdr-j border-4" type="text" name="name" required="">
              <label class="ok-contact-name font-b fs-18">Full Name</label>
            </div>
            <div class="form-floating mb-20 ok-email-field">
              <input class="btn-lg font-b form-control rounded border bdr-j border-4" type="email" name="email" required="">
              <label class="ok-email-id font-b fs-18">Email address</label>
            </div>
            <div class="form-floating mb-20 ok-message-field">
              <textarea class="btn-lg font-b form-control textarea-ht rounded bdr-j border-4" name="message" required=""></textarea>
              <label class="ok-message-id font-b fs-18">Message</label>
            </div>
            <div class="ok-submit-field">
              <input type="submit" value="Send Message" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize rounded form-control bg-b hov-bg-e color-f hov-color-f">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39')){
		$('#ok-sortable-section .block-39').append(`
<footer class="py-30 ok-section display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row">
      <div class="ok-column text-sm-center col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 text-md-start text-lg-start text-xl-start">
        <a href="#" class="ok-link-image">
          <img src="`+domainName+`/assets/img/fitness-logo.png" alt="">
        </a>
        <p class="mt-20 mb-5 font-b ok-text">Mon-Fri: 8am – 7pm</p>
        <p class="font-b ok-text">Sat-Sun: 9am – 5pm</p>
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start">
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
            <i class="fab fa-twitter"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
            <i class="fab fa-youtube"></i>
          </a>
        </div>
      </div>
      <div class="ok-column text-lg-start text-xl-start col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 text-md-start text-sm-center">
        <h6 class="mb-20 fw-bold fs-18 ok-text mt-20">Address</h6>
        <p class="font-b mb-5 ok-text">8439 Pierce Court</p>
        <p class="font-b mb-5 ok-text">Sacramento, CA 95820</p>
        <p class="font-b ok-text">4578 Marmora Road, Glasgow</p>
      </div>
      <div class="ok-column col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 text-xl-start text-lg-start text-md-start text-sm-center">
        <h6 class="mb-20 fw-bold fs-18 ok-text mt-20">Get in touch</h6>
        <p class="font-b mb-5 ok-text">Phone <a href="tel:#"> 1-800-123-1234</a>
        </p>
        <p class="font-b ok-text">E-Mail <a href="mailto:#"> Info@demolink.org</a>
        </p>
      </div>
      <div class="ok-column col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 text-xl-start text-lg-start text-md-start text-sm-center">
        <h6 class="mb-20 fw-bold fs-18 ok-text mt-20">Download our app</h6>
          <a href="#" class="ok-link-image">
           <img src="`+domainName+`/assets/img/fitness-logo.png" alt="" class="mb-5">
		  </a>
          <a href="#" class="ok-link-image">
           <img src="`+domainName+`/assets/img/fitness-logo.png" alt="" class="mb-5">
		  </a>
      </div>
    </div>
    <div class="row mt-20 ok-row">
      <div class="text-center ok-column col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12">
        <div class="ok-group-container ok-flex mt-30 d-flex gap-4 justify-content-center">
          <p class="font-b ok-text">© 2021</p>
          <p class="font-b ok-text">
            <a href="#"> Privacy Policy</a>
          </p>
          <p class="font-b ok-text">
            <a href="#"> Terms of Use</a>
          </p>
        </div>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39aa')){
		$('#ok-sortable-section .block-39aa').append(`
<footer class="ok-section py-20 bg-f display-none-dp">
  <div class="container-fluid cw-80">
    <div class="row ok-row">
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow flex-wrap">
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">Home</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">Features</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">Terms</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">About</a>
        </div>
      </div>
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12 text-xl-end text-lg-end text-md-end text-sm-start">
        <a class="fs-18 lh-lg btn ok-link ok-line font-b fw-normal color-f hov-color-f bg-b hov-bg-e mb-0 mt-0 rounded" href="#">Contact Us</a>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39ab')){
		$('#ok-sortable-section .block-39ab').append(`
<footer class="ok-section py-20 bg-k display-none-dp">
  <div class="container-fluid cw-80">
    <div class="row ok-row">
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12">
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow flex-wrap">
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b mt-0 mb-0 color-f hov-color-j" href="#">Home</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b mt-0 mb-0 color-f hov-color-j" href="#">Features</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b mt-0 mb-0 color-f hov-color-j" href="#">Terms</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b mt-0 mb-0 color-f hov-color-j" href="#">About</a>
        </div>
      </div>
      <div class="ok-column col-xl-6 col-xxl-6 col-lg-6 col-md-6 col-sm-12 text-xl-end text-lg-end text-md-end text-sm-start">
        <p class="ok-text lh-base fs-16 mt-5 mb-5 font-b color-f">©2022. All Rights Reserved</p>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39ac')){
		$('#ok-sortable-section .block-39ac').append(`
<footer class="ok-section py-20 bg-f display-none-dp">
  <div class="container-fluid cw-80">
    <div class="row ok-row d-flex align-items-center flex-row-reverse">
      <div class="ok-column text-xl-end text-sm-start col-xl-4 col-xxl-4 col-lg-4 col-md-6 col-sm-12 text-lg-end text-md-center">
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow flex-wrap justify-content-xl-end justify-content-sm-start justify-content-lg-end justify-content-md-center">
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">Privacy</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">Terms</a>
          <a class="fs-18 lh-lg btn ok-link rounded-0 ok-line fw-normal font-b color-e hov-color-b mt-0 mb-0" href="#">About</a>
        </div>
      </div>
      <div class="ok-column text-xl-center text-lg-center text-md-center text-sm-center col-xl-4 col-xxl-4 col-lg-4 col-md-3 col-sm-6 col-xsm-6">
        <img src="`+domainName+`/assets/img/logo-black.png" class="ok-image mt-5 mb-5" alt="" width="50%">
      </div>
      <div class="ok-column text-sm-start text-xl-start text-lg-start col-xxl-4 col-xl-4 col-lg-4 col-md-3 col-sm-6 col-xsm-6 text-md-center">
        <p class="ok-text lh-base fs-16 mt-5 mb-5 color-e">© 2022</p>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39-a')){
		$('#ok-sortable-section .block-39-a').append(`
<footer class="ok-section py-30 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row d-flex justify-content-center mb-0">
      <div class="ok-column col-lg-12 col-md-12 col-sm-12 col-xxl-6 col-xl-6 text-xl-center text-lg-center text-md-center text-sm-center">
        <a href="#" class="ok-link-image">
          <img src="`+domainName+`/assets/img/logo-black.png" alt="">
        </a>
        <p class="font-b ok-text fs-24 mt-20 mb-20">Copyright 2022, LifeStyler</p>
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow justify-content-xl-center justify-content-lg-center justify-content-md-center justify-content-sm-center">
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
            <i class="fab fa-twitter"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-e hov-bg-k color-f hov-color-f" href="#">
            <i class="fab fa-youtube"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39-b')){
		$('#ok-sortable-section .block-39-b').append(`
<footer class="ok-section bg-e py-40 display-none-dp">
  <div class="container-fluid cw-85">
    <div class="row ok-row g-5">
      <div class="ok-column text-sm-center col-sm-6 text-md-start text-lg-start text-xl-start col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <a href="#" class="ok-link-image">
          <img src="`+domainName+`/assets/img/ringslab-logo-b.png" alt="" class="" width="58%">
        </a>
        <p class="ok-text font-b lh-base fs-18 mt-30 mb-30 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus.</p>
        <p class="mt-20 mb-5 font-b ok-text color-f">Mon-Fri: 8am – 7pm</p>
        <p class="font-b ok-text color-f mb-30">Sat-Sun: 9am – 5pm</p>
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start">
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon bg-a hov-bg-f color-f hov-color-e" href="#">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-e bg-a hov-bg-f" href="#">
            <i class="fab fa-twitter"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-e bg-a hov-bg-f" href="#">
            <i class="fab fa-youtube"></i>
          </a>
        </div>
      </div>
      <div class="ok-column text-lg-start text-xl-start col-sm-6 text-md-start text-sm-center col-md-6 col-xxl-3 col-xl-3 col-lg-3">
        <h6 class="fw-bold fs-18 ok-text mt-20 color-f mb-10">Address</h6>
        <p class="font-b mb-5 ok-text color-f">8439 Pierce Court</p>
        <p class="font-b mb-5 ok-text color-f">Sacramento, CA 95820</p>
        <p class="font-b ok-text color-f mb-50">4578 Marmora Road, Glasgow</p>
        <h6 class="fw-bold fs-18 ok-text color-f mt-40 mb-10">Contact</h6>
        <p class="font-b ok-text color-f mb-5">Lorem ipsum dolor sit amet</p>
        <p class="font-b ok-text color-f mb-5">Lorem ipsum dolor sit amet</p>
        <p class="font-b ok-text color-f mb-5">Lorem ipsum dolor sit amet</p>
      </div>
      <div class="ok-column text-xl-start text-lg-start text-md-start text-sm-center col-sm-12 col-md-12 col-xl-5 col-xxl-5 col-lg-5">
        <h6 class="mb-20 fw-bold fs-18 ok-text mt-20 color-f">Get in touch</h6>
        <div class="form-wrap ok-icode ok-contact">
           <form action="assets/php/`+uniqueUser+`/joinme.php" method="POST">
            <div class="form-floating mb-20 ok-name-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="text" name="name" required="">
              <label class="ok-contact-name font-b fs-18">Full Name</label>
            </div>
            <div class="form-floating mb-20 ok-email-field">
              <input class="btn-lg font-b form-control rounded border bdr-e border-1" type="email" name="email" required="">
              <label class="ok-email-id font-b fs-18">Email address</label>
            </div>
            <div class="form-floating mb-20 ok-message-field">
              <textarea class="btn-lg font-b form-control textarea-ht rounded bdr-e border-1" name="message" required=""></textarea>
              <label class="ok-message-id font-b fs-18">Message</label>
            </div>
            <div class="ok-submit-field">
              <input type="submit" value="Send Message" class="btn-lg btn ok-contact-btn font-b fs-18 fw-bold text-capitalize rounded form-control bg-a hov-bg-f color-f hov-color-e">
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="row ok-row mt-30">
      <div class="text-center ok-column col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12">
        <div class="ok-group-container ok-flex mt-30 d-flex gap-4 justify-content-center">
          <p class="font-b ok-text color-f">© 2021</p>
          <p class="font-b ok-text">
            <a href="#"> Privacy Policy</a>
          </p>
          <p class="font-b ok-text">
            <a href="#"> Terms of Use</a>
          </p>
        </div>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-39-c')){
		$('#ok-sortable-section .block-39-c').append(`
<footer class="ok-section py-40 display-none-dp" style="background-image: linear-gradient(147deg, rgb(227, 38, 38), 43%, rgb(32, 0, 232));">
  <div class="container-fluid cw-85">
    <div class="row ok-row g-5">
      <div class="ok-column text-sm-center col-sm-6 text-md-start text-lg-start text-xl-start col-xxl-4 col-xl-4 col-lg-4 col-md-6">
        <a href="#" class="ok-link-image">
          <img src="`+domainName+`/assets/img/logo-white.png" alt="" class="" width="35%">
        </a>
        <p class="ok-text font-b lh-base fs-18 mt-30 mb-30 color-f">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus.</p>
        <p class="mt-20 mb-5 font-b ok-text color-f">Mon-Fri: 8am – 7pm</p>
        <p class="font-b ok-text mb-30 color-f">Sat-Sun: 9am – 5pm</p>
      </div>
      <div class="ok-column text-lg-start text-xl-start col-sm-6 text-md-start text-sm-center col-md-6 col-xxl-3 col-xl-3 col-lg-3">
        <h6 class="fw-bold fs-18 ok-text color-f mt-20 mb-20">Address</h6>
        <p class="font-b mb-5 ok-text color-f">8439 Pierce Court</p>
        <p class="font-b mb-5 ok-text color-f">Sacramento, CA 95820</p>
        <p class="font-b ok-text color-f mb-50">4578 Marmora Road, Glasgow</p>
        <h6 class="fw-bold fs-18 ok-text color-f mt-20 mb-25">Follow us</h6>
        <div class="ok-group-container ok-flex d-flex gap-2 ok-link-arrow justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start">
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon hov-bg-f color-f hov-color-e bg-a border bdr-f border-2 hov-bdr-e" href="#">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-e bg-a hov-bg-f border bdr-f hov-bdr-e border-2" href="#">
            <i class="fab fa-twitter"></i>
          </a>
          <a class="hw-35 btn-alt rounded-circle ok-link ok-line ok-link-icon color-f hov-color-e bg-a hov-bg-f border bdr-j hov-bdr-e border-2" href="#">
            <i class="fab fa-youtube"></i>
          </a>
        </div>
      </div>
      <div class="ok-column text-xl-start text-lg-start text-md-start text-sm-center col-sm-12 col-md-12 col-xl-5 col-xxl-5 col-lg-5">
        <h6 class="mb-20 fw-bold fs-18 ok-text mt-20 color-f">Newsletter</h6>
        <p class="ok-text font-b lh-base fs-18 color-f mb-30 mt-20">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tincidunt dolor erat. Ut eget risus ligula. Donec et bibendum odio. Praesent massa enim, ultrices vitae vehicula vel, pellentesque at lacus. Nulla sed libero non neque auctor accumsan vitae ac lacus.</p>
        <form action="mailchimp.com/id" method="post" name="mc-embedded-subscribe-form" class="validate ok-icode ok-sub" target="_blank">
          <div class="ok-flex noflex-mob d-xxl-flex d-xl-flex d-lg-flex d-md-flex gap-3 justify-content-center">
            <div class="noflex-child ok-name-field ok-hide-name-field">
              <label class="visually-hidden">First Name</label>
              <input class="btn btn-lg text-start btn-light font-b form-control ok-contact-name rounded" type="text" name="FNAME" placeholder="Full Name" required="">
            </div>
            <div class="noflex-child ok-email-field w-100">
              <label class="visually-hidden">Email Address</label>
              <input class="btn btn-lg text-start btn-light font-b form-control ok-email-id rounded" type="email" name="EMAIL" placeholder="Email address" required="">
            </div>
            <div class="ok-submit-field">
              <input type="submit" value="Subscribe" name="subscribe" class="form-control btn-lg font-b btn ok-contact-btn rounded bg-d hov-bg-f color-e hov-color-e">
            </div>
          </div>
          <div class="mc-status"></div>
        </form>
      </div>
    </div>
    <div class="row ok-row mt-0">
      <div class="text-center ok-column col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12">
        <div class="ok-group-container ok-flex mt-30 d-flex gap-4 justify-content-center">
          <p class="font-b ok-text color-f">© 2021</p>
          <p class="font-b ok-text color-f">
            <a href="#">
              <font color="#fbf6f6">
                <u> Privacy Policy</u>
              </font>
            </a>
          </p>
          <p class="font-b ok-text">
            <a href="#">
              <font color="#fffdfd">
                <u> Terms of Use</u>
              </font>
            </a>
          </p>
        </div>
      </div>
    </div>
  </div>
</footer>`);
	}
	if($('#ok-sortable-section .drag-main-blocks').hasClass('block-40')){
		$('#ok-sortable-section .block-40').append(`
		`);
	}
	//::END:: Blocks with currosponded images
	$('#body-data .ok-section').removeClass('drag-temp-col');
	$('#body-data .drag-main-blocks').each(function() { 
		if ($(this).length > 0){
			$(this).find('.temp-block-img').remove();
			$(this).find('.ok-section').removeClass('display-none-dp');
			$(this).contents().unwrap();
		} 
	});	
	
	$("#scaledown-overlay").show();	
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
	//If block is not added
	if ($('#ok-sortable-section').html().trim() == '') {
		$('#ok-sortable-section').html(`
			<div class="ok-section empty-section" dir="ltr"> 
				<div class="empty-section-wrap">
					<button class="add-section empty-button" title="Add Section">Blank Website <br> <span style="font-size: 32px;">Get Started by <strong>Dragging and Dropping</strong> New Elements or Blocks</span></button>
				</div>
			</div>
		`);
	}
	//For empty slider
	$('.swiper-wrapper').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">'
            +' <div class="card-body p-20 text-center">'
			+' 	<img src="'+domainName+'/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">'
			+'	<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>'
            +' </div>'
            +'</div>'
			+'');
		} 
	});
	//For empty column, container and others
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
	//Hide Nav if exist
	if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
		$('.nav-sec').hide();
	}
	//Hide Footer if exist
	if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
		$('.footer-sec').hide();
	}
});
preBlockSortable[0].addEventListener('sortupdate', function(e) {
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
});
// Main user Saved Block Drag
const userBlockSortable = sortable('.user-save-library', {
	copy: true,
	acceptFrom: false,
    forcePlaceholderSize: true,
	hoverClass: 'sortable-chosen',
	placeholderClass: 'sortable-chosen',
});
userBlockSortable[0].addEventListener('sortstart', function(e) {	
	$("#body-data").addClass('scaledown-main-content');
	$("#scaledown-overlay").hide();
	$('#body-data .ok-section').addClass('drag-temp-col');
	
	//Tigger Blocks Drag and Drop
	const tiggerPreBlocksThree = sortable('#ok-sortable-section', {
		acceptFrom: '.user-save-library',
		forcePlaceholderSize: true,
		handle: '.none',
		placeholderClass: 'sortable-chosen',
	});
});
userBlockSortable[0].addEventListener('sortstop', function(e) {
	$('#body-data .ok-section').removeClass('drag-temp-col');
	$('#body-data .drag-main-blocks').each(function() { 
		if ($(this).length > 0){
			$(this).find('.temp-block-img').remove();
			$(this).find('.ok-section').removeClass('display-none-dp');
			$(this).contents().unwrap();
		} 
	});	
	
	$("#scaledown-overlay").show();	
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
	//If block is not added
	if ($('#ok-sortable-section').html().trim() == '') {
		$('#ok-sortable-section').html(`
			<div class="ok-section empty-section" dir="ltr"> 
				<div class="empty-section-wrap">
					<button class="add-section empty-button" title="Add Section">Blank Website <br> <span style="font-size: 32px;">Get Started by <strong>Dragging and Dropping</strong> New Elements or Blocks</span></button>
				</div>
			</div>
		`);
	}
	//For empty slider
	$('.swiper-wrapper').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">'
            +' <div class="card-body p-20 text-center">'
			+' 	<img src="'+domainName+'/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">'
			+'	<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>'
            +' </div>'
            +'</div>'
			+'');
		} 
	});
	//For empty column, container and others
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});
userBlockSortable[0].addEventListener('sortupdate', function(e) {
	$("#body-data").addClass('scaledown-main-content');
	$('.empty-section').remove();
});

//START:: Row mouseenter Event
$(document).on("mouseenter", '#body-data .ok-row', function() {
//First Remove Row if exist
$('#ok-row-wrap').contents().unwrap();
$('#row-setting-tools').remove();
//Then Add
$(this).wrap('<div id="ok-row-wrap" class="ok-row-handle row-border"></div>');
$("#ok-row-wrap").prepend(`
	<div id="row-setting-tools" class="setting-menu" dir="ltr">
		<div id="move-row-up" title="Move Up" class="setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div id="move-row-down" title="Move Down" class="setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="row-setting-menu" title="Row Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<!--<div id="shuffel-columns" title="Shuffle Columns" class="setting-menu-btn"><i class="fas fa-random"></i></div>-->
		<div id="duplicate-row" title="Duplicate Row" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-row" title="Copy Row" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-row" title="Delete Row" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
});//END:: Row mouseenter Event

//START:: Column mouseenter Event
$(document).on("mouseenter", '#body-data .ok-column', function() {
//First Remove Row if exist
$('#ok-row-wrap').contents().unwrap();
$('#row-setting-tools').remove();
//Then Add
$(this).closest('.ok-column').parent('.ok-row').wrap('<div id="ok-row-wrap" class="ok-row-handle row-border"></div>');
$("#ok-row-wrap").prepend(`
	<div id="row-setting-tools" class="setting-menu" dir="ltr">
		<div id="move-row-up" title="Move Up" class="setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div id="move-row-down" title="Move Down" class="setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="row-setting-menu" title="Row Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<!--<div id="shuffel-columns" title="Shuffle Columns" class="setting-menu-btn"><i class="fas fa-random"></i></div>-->
		<div id="duplicate-row" title="Duplicate Row" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-row" title="Copy Row" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-row" title="Delete Row" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Column if exist
$('.ok-column').removeClass('column-border ok-column-handle');	
$('#column-setting-tools').remove();
//Then Add Column Settings
$(this).closest('.ok-column').addClass('column-border ok-column-handle');
$(this).closest('.ok-column').prepend(`
	<div id="column-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Left" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-left"></i></div>
		<div title="Move Right" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-right"></i></div>
		<div id="column-setting-menu" title="Column Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-column" title="Duplicate Column" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-column" title="Copy Column" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-column" title="Delete Column" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
});//END:: Column mouseenter Event

//START:: Card mouseenter Event
$(document).on("mouseenter", '#body-data .ok-card', function() {
//First Remove Row if exist
$('#ok-row-wrap').contents().unwrap();
$('#row-setting-tools').remove();
//Then Add
$(this).closest('.ok-column').parent('.ok-row').wrap('<div id="ok-row-wrap" class="ok-row-handle row-border"></div>');
$("#ok-row-wrap").prepend(`
	<div id="row-setting-tools" class="setting-menu" dir="ltr">
		<div id="move-row-up" title="Move Up" class="setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div id="move-row-down" title="Move Down" class="setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="row-setting-menu" title="Row Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<!--<div id="shuffel-columns" title="Shuffle Columns" class="setting-menu-btn"><i class="fas fa-random"></i></div>-->
		<div id="duplicate-row" title="Duplicate Row" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-row" title="Copy Row" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-row" title="Delete Row" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Column if exist
$('.ok-column').removeClass('column-border ok-column-handle');	
$('#column-setting-tools').remove();
//Then Add Column Settings
$(this).closest('.ok-column').addClass('column-border ok-column-handle');
$(this).closest('.ok-column').prepend(`
	<div id="column-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Left" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-left"></i></div>
		<div title="Move Right" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-right"></i></div>
		<div id="column-setting-menu" title="Column Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-column" title="Duplicate Column" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-column" title="Copy Column" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-column" title="Delete Column" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Slider if exist
$('#ok-slider-wrap').contents().unwrap();
$('#slider-setting-tools').remove();
//Then Add
if($(this).closest('.ok-card').hasClass('swiper-slide')){
	$(this).closest('.swiper').wrap('<div id="ok-slider-wrap" class="ok-selector-line ok-slider-border"></div>');
}
$("#ok-slider-wrap").prepend(`
	<div id="slider-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="slider-setting-menu" title="Slider Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-slider" title="Duplicate Slider" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-slider" title="Copy Slider" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-slider" title="Delete Slider" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Card if exist
$('#ok-card-wrap').contents().unwrap();
$('#card-setting-tools').remove();
//Then Add
if($(this).closest('.ok-card').hasClass('ok-line')){
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-line ok-card-border"></div>');
}else if($(this).closest('.ok-card').hasClass('swiper-slide')){
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-line ok-card-border swiper-slide"></div>');
}else if($(this).closest('.ok-card').hasClass('h-100')){
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-block ok-card-border h-100"></div>');
}else {
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-block ok-card-border"></div>');
}
if($(this).hasClass('swiper-slide')){
$("#ok-card-wrap").prepend(`
	<div id="card-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="card-setting-menu" title="Card Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-card" title="Duplicate Card" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="delete-card" title="Delete Card" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);	
}else {
$("#ok-card-wrap").prepend(`
	<div id="card-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="card-setting-menu" title="Card Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-card" title="Duplicate Card" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-card" title="Copy Card" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-card" title="Delete Card" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
}
//Replace Up/Down arrows with Left/Right arrows
if($('.ok-card-arrow').find('.move-up-btn').length > 0){
	$('.ok-card-arrow').find('#card-setting-tools .move-up-btn').html('<i class="fas fa-arrow-left"></i>');
	$('.ok-card-arrow').find('#card-setting-tools .move-up-btn').attr('title', 'Move Left');
}
if($('.ok-card-arrow').find('.move-down-btn').length > 0){
	$('.ok-card-arrow').find('#card-setting-tools .move-down-btn').html('<i class="fas fa-arrow-right"></i>');
	$('.ok-card-arrow').find('#card-setting-tools .move-down-btn').attr('title', 'Move Right');
}
});//END:: Card mouseenter Event

//START:: Other Inner Elements mouseenter Event
$(document).on("mouseenter", '#body-data .ok-text, #body-data .ok-link-image, #body-data .ok-image, #body-data .ok-link, #body-data .ok-icode', function() {
//First Remove Row if exist
$('#ok-row-wrap').contents().unwrap();
$('#row-setting-tools').remove();
$('.ok-row').removeClass('active-row row-border');
//Then Add
$(this).closest('.ok-column').parent('.ok-row').wrap('<div id="ok-row-wrap" class="ok-row-handle row-border"></div>');
$("#ok-row-wrap").prepend(`
	<div id="row-setting-tools" class="setting-menu" dir="ltr">
		<div id="move-row-up" title="Move Up" class="setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div id="move-row-down" title="Move Down" class="setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="row-setting-menu" title="Row Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<!--<div id="shuffel-columns" title="Shuffle Columns" class="setting-menu-btn"><i class="fas fa-random"></i></div>-->
		<div id="duplicate-row" title="Duplicate Row" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-row" title="Copy Row" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-row" title="Delete Row" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Column if exist
$('.ok-column').removeClass('column-border ok-column-handle');	
$('#column-setting-tools').remove();
//Then Add Column Settings
$(this).closest('.ok-column').addClass('column-border ok-column-handle');
$(this).closest('.ok-column').prepend(`
	<div id="column-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Left" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-left"></i></div>
		<div title="Move Right" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-right"></i></div>
		<div id="column-setting-menu" title="Column Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-column" title="Duplicate Column" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-column" title="Copy Column" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-column" title="Delete Column" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Slider if exist
$('#ok-slider-wrap').contents().unwrap();
$('#slider-setting-tools').remove();
//Then Add
if($(this).closest('.ok-card').hasClass('swiper-slide')){
	$(this).closest('.swiper').wrap('<div id="ok-slider-wrap" class="ok-selector-line ok-slider-border"></div>');
}
$("#ok-slider-wrap").prepend(`
	<div id="slider-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="slider-setting-menu" title="Slider Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-slider" title="Duplicate Slider" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-slider" title="Copy Slider" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-slider" title="Delete Slider" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//First Remove Card if exist
$('#ok-card-wrap').contents().unwrap();
$('#card-setting-tools').remove();
//Then Add
if($(this).closest('.ok-card').hasClass('ok-line')){
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-line ok-card-border"></div>');
}else if($(this).closest('.ok-card').hasClass('swiper-slide')){
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-line ok-card-border swiper-slide"></div>');
}else if($(this).closest('.ok-card').hasClass('h-100')){
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-block ok-card-border h-100"></div>');
}else {
	$(this).closest('.ok-card').wrap('<div id="ok-card-wrap" class="ok-selector-block ok-card-border"></div>');
}
if($(this).closest('.ok-card').hasClass('swiper-slide')){
$("#ok-card-wrap").prepend(`
	<div id="card-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="card-setting-menu" title="Card Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-card" title="Duplicate Card" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="delete-card" title="Delete Card" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);	
}else {
$("#ok-card-wrap").prepend(`
	<div id="card-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="card-setting-menu" title="Card Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-card" title="Duplicate Card" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-card" title="Copy Card" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-card" title="Delete Card" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
}
//First Remove Container if exist
$('#ok-group-container-wrap').contents().unwrap();
$('#container-setting-tools').remove();
//Then Add
if($(this).closest('.ok-group-container').hasClass('ok-line')){
	$(this).closest('.ok-group-container').wrap('<div id="ok-group-container-wrap" class="ok-selector-line ok-border"></div>');
}else {
	$(this).closest('.ok-group-container').wrap('<div id="ok-group-container-wrap" class="ok-selector-block ok-border"></div>');
}
$('#ok-group-container-wrap').prepend(`
	<div id="container-setting-tools" class="setting-menu" dir="ltr">
		<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
		<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
		<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
		<div id="container-setting-menu" title="Container Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		<div id="duplicate-container" title="Duplicate Container" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
		<div id="copy-container" title="Copy Container" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
		<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
		<div id="delete-container" title="Delete Container" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
	</div>
`);
//Replace Up/Down arrows with Left/Right arrows
if($('.ok-card-arrow').find('.move-up-btn').length > 0){
	$('.ok-card-arrow').find('#card-setting-tools .move-up-btn').html('<i class="fas fa-arrow-left"></i>');
	$('.ok-card-arrow').find('#card-setting-tools .move-up-btn').attr('title', 'Move Left');
}
if($('.ok-card-arrow').find('.move-down-btn').length > 0){
	$('.ok-card-arrow').find('#card-setting-tools .move-down-btn').html('<i class="fas fa-arrow-right"></i>');
	$('.ok-card-arrow').find('#card-setting-tools .move-down-btn').attr('title', 'Move Right');
}
});//END:: Other Inner Elements mouseenter Event

//START: Remove Child elements of Parent elements
$(document).on("mouseenter", '#body-data #row-setting-tools', function(e) {
	e.stopImmediatePropagation();
	$('.ok-row').removeClass('active-row');
	$('#ok-row-wrap').find('.ok-row:first').addClass('active-row');
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
});
$(document).on("mouseenter", '#body-data #column-setting-tools', function(e) {
	e.stopImmediatePropagation();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
});
$(document).on("mouseenter", '#body-data #slider-setting-tools', function(e) {
	e.stopImmediatePropagation();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
});
$(document).on("mouseenter", '#body-data #card-setting-tools', function(e) {
	e.stopImmediatePropagation();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
});
$(document).on("mouseenter", '#body-data #container-setting-tools', function(e) {
	e.stopImmediatePropagation();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
});//END: Remove Child elements of Parent elements

//Row Settings
$(document).on('click', '#row-setting-menu', function() {
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
	$('#ok-row-wrap').find('.ok-row:first').addClass('active-row');
	$('#row-setting-tools').remove();
	$('#ok-row-wrap').removeClass('row-border');
//Row Setting Panel
let rowPanel = [];
rowPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="section-setting-header">Row Settings</span>
		<span id="close-panel" class="row-setting-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Columns Gap -->
			<div class="setting-title">
				<p>Columns Gap</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Gap = <span id="column-gaps-count">6</span></p>
								<input id="column-gaps" type="range" min="1" max="7" step="1" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div><!-- ::END:: Columns Gap -->
			<!-- ::START:: Reverse Columns -->
			<div class="setting-title">
				<p>Reverse Columns</p>
			</div>
			<div class="settings">
			<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<select id="reverse-main" class="ok-select-opt">
								<option value="">None</option>
								<option value="flex-row-reverse">Reverse</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<div class="table-box d-none">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Large Desktop</p>
							<select id="reverse-xxl" class="ok-select-opt">
								<option value="">None</option>
								<option value="flex-xxl-row-reverse">Reverse</option>
							</select>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Medium Desktop</p>
							<select id="reverse-xl" class="ok-select-opt">
								<option value="">None</option>
								<option value="flex-xl-row-reverse">Reverse</option>
							</select>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Small desktop / Tablet landscape</p>
							<select id="reverse-lg" class="ok-select-opt">
								<option value="">None</option>
								<option value="flex-lg-row-reverse">Reverse</option>
							</select>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Tablet Portrait</p>
							<select id="reverse-md" class="ok-select-opt">
								<option value="">None</option>
								<option value="flex-md-row-reverse">Reverse</option>
							</select>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Mobile Landscape</p>
							<select id="reverse-sm" class="ok-select-opt">
								<option value="">None</option>
								<option value="flex-sm-row-reverse">Reverse</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Reverse Columns -->
			<!-- ::START:: Vertical Alignment -->
			<div class="setting-title">
				<p>Vertical Alignment</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<select id="row-valign" class="ok-select-opt">
								<option value="">None</option>
								<option value="d-flex align-items-start">Top</option>
								<option value="d-flex align-items-center">Middle</option>
								<option value="d-flex align-items-end">Bottom</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Vertical Alignment -->
			<!-- ::START:: Horizontal Alignment -->
			<div class="setting-title">
				<p>Horizontal Alignment</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<select id="row-halign" class="ok-select-opt">
								<option value="">None</option>
								<option value="d-flex justify-content-start">Left</option>
								<option value="d-flex justify-content-center">Center</option>
								<option value="d-flex justify-content-end">Right</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Horizontal Alignment -->
			<!-- ::START:: Background Color -->
			<div class="background-control-panel">
			<div class="setting-title">
				<p>Background Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button class="main-bgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bgcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Background Hover Color</p>
							<button class="main-hobgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hobgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobgcolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Background Color -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = rowPanel.join("");

//Check default column gaps
if($('#ok-row-wrap').find('.active-row').hasClass("g-0")){
	$('#column-gaps-count').text('0rem');
	$('#column-gaps').val('2');
}else if($('#ok-row-wrap').find('.active-row').hasClass("g-1")){
	$('#column-gaps-count').text('0.25rem');
	$('#column-gaps').val('3');
}else if($('#ok-row-wrap').find('.active-row').hasClass("g-2")){
	$('#column-gaps-count').text('0.5rem');
	$('#column-gaps').val('4');
}else if($('#ok-row-wrap').find('.active-row').hasClass("g-3")){
	$('#column-gaps-count').text('1rem');
	$('#column-gaps').val('5');
}else if($('#ok-row-wrap').find('.active-row').hasClass("g-4")){
	$('#column-gaps-count').text('1.5rem');
	$('#column-gaps').val('6');
}else if($('#ok-row-wrap').find('.active-row').hasClass("g-5")){
	$('#column-gaps-count').text('3rem');
	$('#column-gaps').val('7');
}else{	
	$('#column-gaps-count').text('Default');
	$('#column-gaps').val('1');
}
//::Column Gaps
let columnGaps = document.querySelector("#column-gaps");
columnGaps.oninput = function() {
    $("#column-gaps-count").text(this.value);
    $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
	if (this.value == 1) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
		 $("#column-gaps-count").text("Default");
	}else if (this.value == 2) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
         $('#ok-row-wrap').find('.active-row').addClass("g-0");
		 $("#column-gaps-count").text("0rem");
	} else if (this.value == 3) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
         $('#ok-row-wrap').find('.active-row').addClass("g-1");
		 $("#column-gaps-count").text("0.25rem");
	} else if (this.value == 4) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
         $('#ok-row-wrap').find('.active-row').addClass("g-2");
		 $("#column-gaps-count").text("0.5rem");
	} else if (this.value == 5) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
         $('#ok-row-wrap').find('.active-row').addClass("g-3");
		 $("#column-gaps-count").text("1rem");
	} else if (this.value == 6) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
         $('#ok-row-wrap').find('.active-row').addClass("g-4");
		 $("#column-gaps-count").text("1.5rem");
	} else if (this.value == 7) {
         $('#ok-row-wrap').find('.active-row').removeClass("g-0 g-1 g-2 g-3 g-4 g-5");
         $('#ok-row-wrap').find('.active-row').addClass("g-5");
		 $("#column-gaps-count").text("3rem");
	}
}

//Check default Column Vertical alignment
if($('#ok-row-wrap').find('.active-row').hasClass("align-items-start")){
	$("#row-valign option[value='d-flex align-items-start']").attr('selected','selected');
}else if($('#ok-row-wrap').find('.active-row').hasClass("align-items-center")) {
	$("#row-valign option[value='d-flex align-items-center']").attr('selected','selected');	
}else if($('#ok-row-wrap').find('.active-row').hasClass("align-items-end")){
	$("#row-valign option[value='d-flex align-items-end']").attr('selected','selected');
}else{
	$("#row-valign option[value='']").attr('selected','selected');
}
// Column Vertical alignment
$("#row-valign").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("d-flex align-items-start align-items-center align-items-end");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});

//Check default Column Horizontal alignment
if($('#ok-row-wrap').find('.active-row').hasClass("justify-content-start")){
	$("#row-halign option[value='d-flex justify-content-start']").attr('selected','selected');
}else if($('#ok-row-wrap').find('.active-row').hasClass("justify-content-center")) {
	$("#row-halign option[value='d-flex justify-content-center']").attr('selected','selected');	
}else if($('#ok-row-wrap').find('.active-row').hasClass("justify-content-end")){
	$("#row-halign option[value='d-flex justify-content-end']").attr('selected','selected');
}else{
	$("#row-halign option[value='']").attr('selected','selected');
}
// Column Horizontal alignment
$("#row-halign").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("d-flex justify-content-start justify-content-center justify-content-end");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});

// Check Reverse
if($('#ok-row-wrap').find('.active-row').hasClass("flex-row-reverse")){
	$("#reverse-main option[value='flex-row-reverse']").attr('selected','selected');
}
if($('#ok-row-wrap').find('.active-row').hasClass("flex-xxl-row-reverse")){
	$("#reverse-xxl option[value='flex-xxl-row-reverse']").attr('selected','selected');
}
if($('#ok-row-wrap').find('.active-row').hasClass("flex-xl-row-reverse")){
	$("#reverse-xl option[value='flex-xl-row-reverse']").attr('selected','selected');
}
if($('#ok-row-wrap').find('.active-row').hasClass("flex-lg-row-reverse")){
	$("#reverse-lg option[value='flex-lg-row-reverse']").attr('selected','selected');
}
if($('#ok-row-wrap').find('.active-row').hasClass("flex-md-row-reverse")){
	$("#reverse-md option[value='flex-md-row-reverse']").attr('selected','selected');
}
if($('#ok-row-wrap').find('.active-row').hasClass("flex-sm-row-reverse")){
	$("#reverse-sm option[value='flex-sm-row-reverse']").attr('selected','selected');
}
// Reverse Columns
$("#reverse-main").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("flex-row-reverse flex-xxl-row-reverse flex-xl-row-reverse flex-lg-row-reverse flex-md-row-reverse flex-xxl-sm-reverse");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});
$("#reverse-xxl").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("flex-row-reverse flex-xxl-row-reverse");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});
$("#reverse-xl").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("flex-row-reverse flex-xl-row-reverse");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});
$("#reverse-lg").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("flex-row-reverse flex-lg-row-reverse");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});
$("#reverse-md").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("flex-row-reverse flex-md-row-reverse");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});
$("#reverse-sm").change(function() {
	$('#ok-row-wrap').find('.active-row').removeClass("flex-row-reverse flex-sm-row-reverse");
	$('#ok-row-wrap').find('.active-row').addClass($(this).val());
});

});//END:: Row settings

//Move Row Up/Down
$(document).on('click', '#move-row-up', function(){
	$(this).parents('#ok-row-wrap').insertBefore($(this).parents('#ok-row-wrap').prev());
});
$(document).on('click', '#move-row-down', function(){
	$(this).parents('#ok-row-wrap').insertAfter($(this).parents('#ok-row-wrap').next());
});
/*// Randomize Row
$(document).on('click', '#shuffel-columns', function(e) {
	e.stopImmediatePropagation();
	let parentColumn = $('#ok-row-wrap').find('.ok-row');
	let childrenColumn = parentColumn.children();
	while (childrenColumn.length) {
       parentColumn.append(childrenColumn.splice(Math.floor(Math.random() * childrenColumn.length), 1)[0]);
    }
});*/

//Copy Row
$(document).on('click', '#copy-row', function(){
	$('#copy-db').html($('#ok-row-wrap').html());
	$('#copy-db').find('.ok-row').addClass('copyed');
	$('#copy-db').find('#row-setting-tools').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html('<style>#main-menu-panel button {background: #FFB300!important;} .copy-element, #ok-section-wrap .paste-element {display: none!important;} .paste-element {display: none!important;} #ok-section-wrap #row-setting-tools .paste-element {display: inline-block!important;}</style>');
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: block!important;}</style>');
	}
});
//Duplicate Row
$(document).on('click', '#duplicate-row', function(e) {
	//e.stopImmediatePropagation();
	e.preventDefault();
	$('#ok-row-wrap').find('.active-row').clone().insertAfter('#ok-row-wrap');
	$('#row-setting-tools').remove(); 	 
	$('#ok-row-wrap').contents().unwrap();
	$('.ok-row').removeClass('active-row');
});
//Delete Row
$(document).on('click', '#delete-row', function() {  
	$('#ok-row-wrap').remove(); 	
	//Add Placeholder if container is empty
	$('.container-fluid').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="row ok-row mt-0 mb-0">'
			+'<div class="ok-column col">'
			+'	<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'</div>'
			+'</div>');
		} 
	});
	//Add Placeholder if column is empty
	$('.ok-column').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'	<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>');
		} 
	});
});

//Column Settings
$(document).on('click', '#column-setting-menu', function() {
	//First Remove Row if exist
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-row').removeClass('active-row');
	//First Remove Column if exist
	$('.ok-column').removeClass('column-border');	
	$('#column-setting-tools').remove();
//Column Setting Panel
let columnPanel = [];
columnPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="section-setting-header">Column Settings</span>
		<span id="close-panel" class="column-setting-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Responsive Column -->	
			<div id="responsive-colummn-wrap" class="element-setting-wrap">
			<div class="ok-responsive-colummn-script setting-title">
				<p>Column Width</p>
			</div>
			<div class="settings">
					<button id="default-column-size" class="btn w-100 btn-primary mb-10">Default Width</button>
					<hr>
					<p class="d-inline">Responsive Width</p>
					<hr>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Large Desktop</p>
					<p class="float-right d-inline"><span class="desk-xxl-res-col-count">Default</span></p>
					<input class="desk-xxl-res-col res-range-input" type="range" min="1" max="12" value="0">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Medium Desktop</p>
					<p class="float-right d-inline"><span class="desk-alt-res-col-count">Default</span></p>
					<input class="desk-alt-res-col res-range-input" type="range" min="1" max="12" value="0">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Small desktop / Tablet landscape</p>
					<p class="float-right d-inline"><span class="desk-res-col-count">Default</span></p>
					<input class="desk-res-col res-range-input" type="range" min="1" max="12" value="0">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Tablet Portrait</p>
					<p class="float-right d-inline"><span class="tab-res-col-count">Default</span></p>
					<input class="tab-res-col res-range-input" type="range" min="1" max="12" value="0">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Mobile Landscape</p>
					<p class="float-right d-inline"><span class="mob-res-col-count">Default</span></p>
					<input class="mob-res-col res-range-input" type="range" min="1" max="12" value="0">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Mobile Portrait</p>
					<p class="float-right d-inline"><span class="xsm-mob-col-count">Default</span></p>
					<input class="xsm-mob-col res-range-input" type="range" min="1" max="4" value="0">
				</div>
			</div>
			</div><!-- ::END:: Responsive Column -->
			<!-- ::START:: Text Alignment and Transform -->
			<div class="setting-title">
				<p>Content Alignment</p>
			</div>
			<div class="settings">
				<p>Desktop</p>
				<div class="button-25-wrap">
					<button class="desk-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="desk-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="desk-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="desk-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
				<p>Small desktop / Tablet landscape</p>
				<div class="button-25-wrap">
					<button class="small-desk-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="small-desk-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="small-desk-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="small-desk-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
				<p>Tablet Portrait</p>
				<div class="button-25-wrap">
					<button class="tab-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="tab-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="tab-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="tab-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
				<p>Mobile</p>
				<div class="button-25-wrap">
					<button class="mob-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="mob-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="mob-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="mob-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
			</div><!-- ::END:: Text Alignment and Transform -->
			<!-- ::START:: Background Color -->
			<div class="background-control-panel">
			<div class="setting-title">
				<p>Background Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button class="main-bgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bgcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Background Hover Color</p>
							<button class="main-hobgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hobgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobgcolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Background Color -->
			<!-- ::START:: Padding -->
			<div class="setting-title">
				<p>Padding</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Padding = <span id="column-padding-count">0</span></p>
								<input id="column-padding" type="range" min="0" max="6" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div><!-- ::END:: Padding -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = columnPanel.join("");

//Check For Default Column Width
if ($(".ok-column-handle").hasClass('col')) {
	$(".desk-xxl-res-col-count, .desk-alt-res-col-count, .desk-res-col-count, .tab-res-col-count, .mob-res-col-count, .xsm-mob-col-count").text("Default");
	$(".desk-xxl-res-col, .desk-alt-res-col, .desk-res-col, .tab-res-col, .mob-res-col, .xsm-mob-col").val("1");
}
//Default Column
$(document).on('click', '#default-column-size', function(){
	$(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12 col-xsm-3 col-xsm-6 col-xsm-9");
	$(".desk-xxl-res-col-count, .desk-alt-res-col-count, .desk-res-col-count, .tab-res-col-count, .mob-res-col-count, .xsm-mob-col-count").text("Default");
	$(".desk-xxl-res-col, .desk-alt-res-col, .desk-res-col, .tab-res-col, .mob-res-col, .xsm-mob-col").val("1");
	$(".ok-column-handle").addClass('col');
});
//Check Default xxl column values
if ($(".ok-column-handle").hasClass('col-xxl-1')) {
	$(".desk-xxl-res-col-count").text("8.33%");
	$(".desk-xxl-res-col").val("1");
}else if ($(".ok-column-handle").hasClass('col-xxl-2')) {
	$(".desk-xxl-res-col-count").text("16.66%");
	$(".desk-xxl-res-col").val("2");
}else if($(".ok-column-handle").hasClass('col-xxl-3')) {
	$(".desk-xxl-res-col-count").text("25%");
	$(".desk-xxl-res-col").val("3");
}else if($(".ok-column-handle").hasClass('col-xxl-4')) {
	$(".desk-xxl-res-col-count").text("33.33%");
	$(".desk-xxl-res-col").val("4");
}else if($(".ok-column-handle").hasClass('col-xxl-5')) {
	$(".desk-xxl-res-col-count").text("41.66%");
	$(".desk-xxl-res-col").val("5");
}else if($(".ok-column-handle").hasClass('col-xxl-6')) {
	$(".desk-xxl-res-col-count").text("50%");
	$(".desk-xxl-res-col").val("6");
}else if($(".ok-column-handle").hasClass('col-xxl-7')) {
	$(".desk-xxl-res-col-count").text("58.33%");
	$(".desk-xxl-res-col").val("7");
}else if($(".ok-column-handle").hasClass('col-xxl-8')) {
	$(".desk-xxl-res-col-count").text("66.66%");
	$(".desk-xxl-res-col").val("8");
}else if($(".ok-column-handle").hasClass('col-xxl-9')) {
	$(".desk-xxl-res-col-count").text("75%");
	$(".desk-xxl-res-col").val("9");
}else if($(".ok-column-handle").hasClass('col-xxl-10')) {
	$(".desk-xxl-res-col-count").text("83.33%");
	$(".desk-xxl-res-col").val("10");
}else if($(".ok-column-handle").hasClass('col-xxl-11')) {
	$(".desk-xxl-res-col-count").text("91.66%");
	$(".desk-xxl-res-col").val("11");
}else if($(".ok-column-handle").hasClass('col-xxl-12')) {
	$(".desk-xxl-res-col-count").text("100%");
	$(".desk-xxl-res-col").val("12");
}else{	
	$(".desk-xxl-res-col-count").text("Default");
	$(".desk-xxl-res-col").val("0");
}
//:: Responsive Extra Large Desktop Column
let resExtLargeDeskCol = document.querySelector(".desk-xxl-res-col");
resExtLargeDeskCol.oninput = function() {
	$(".ok-column-handle").parent().addClass('row-border');
	$(".ok-column-handle").addClass('column-border');
	if (this.value == 0) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("Default");
	} else if (this.value == 1) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("8.33%");
		$(".ok-column-handle").addClass("col-xxl-1");
	} else if (this.value == 2) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("16.66%");
		$(".ok-column-handle").addClass("col-xxl-2");
	} else if (this.value == 3) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("25%");
		$(".ok-column-handle").addClass("col-xxl-3");
	} else if (this.value == 4) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("33.33%");
		$(".ok-column-handle").addClass("col-xxl-4");
	} else if (this.value == 5) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("41.66%");
		$(".ok-column-handle").addClass("col-xxl-5");
	} else if (this.value == 6) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("50%");
		$(".ok-column-handle").addClass("col-xxl-6");
	} else if (this.value == 7) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("58.33%");
		$(".ok-column-handle").addClass("col-xxl-7");
	} else if (this.value == 8) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("66.66%");
		$(".ok-column-handle").addClass("col-xxl-8");
	} else if (this.value == 9) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("75%");
		$(".ok-column-handle").addClass("col-xxl-9");
	} else if (this.value == 10) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("83.33%");
		$(".ok-column-handle").addClass("col-xxl-10");
	} else if (this.value == 11) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("91.66%");
		$(".ok-column-handle").addClass("col-xxl-11");
	} else if (this.value == 12) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xxl-1 col-xxl-2 col-xxl-3 col-xxl-4 col-xxl-5 col-xxl-6 col-xxl-7 col-xxl-8 col-xxl-9 col-xxl-10 col-xxl-11 col-xxl-12");
		$(".desk-xxl-res-col-count").text("100%");
		$(".ok-column-handle").addClass("col-xxl-12");
	}
};
//Check Default xl column values
if ($(".ok-column-handle").hasClass('col-xl-1')) {
	$(".desk-alt-res-col-count").text("8.33%");
	$(".desk-alt-res-col").val("1");
}else if ($(".ok-column-handle").hasClass('col-xl-2')) {
	$(".desk-alt-res-col-count").text("16.66%");
	$(".desk-alt-res-col").val("2");
}else if($(".ok-column-handle").hasClass('col-xl-3')) {
	$(".desk-alt-res-col-count").text("25%");
	$(".desk-alt-res-col").val("3");
}else if($(".ok-column-handle").hasClass('col-xl-4')) {
	$(".desk-alt-res-col-count").text("33.33%");
	$(".desk-alt-res-col").val("4");
}else if($(".ok-column-handle").hasClass('col-xl-5')) {
	$(".desk-alt-res-col-count").text("41.66%");
	$(".desk-alt-res-col").val("5");
}else if($(".ok-column-handle").hasClass('col-xl-6')) {
	$(".desk-alt-res-col-count").text("50%");
	$(".desk-alt-res-col").val("6");
}else if($(".ok-column-handle").hasClass('col-xl-7')) {
	$(".desk-alt-res-col-count").text("58.33%");
	$(".desk-alt-res-col").val("7");
}else if($(".ok-column-handle").hasClass('col-xl-8')) {
	$(".desk-alt-res-col-count").text("66.66%");
	$(".desk-alt-res-col").val("8");
}else if($(".ok-column-handle").hasClass('col-xl-9')) {
	$(".desk-alt-res-col-count").text("75%");
	$(".desk-alt-res-col").val("9");
}else if($(".ok-column-handle").hasClass('col-xl-10')) {
	$(".desk-alt-res-col-count").text("83.33%");
	$(".desk-alt-res-col").val("10");
}else if($(".ok-column-handle").hasClass('col-xl-11')) {
	$(".desk-alt-res-col-count").text("91.66%");
	$(".desk-alt-res-col").val("11");
}else if($(".ok-column-handle").hasClass('col-xl-12')) {
	$(".desk-alt-res-col-count").text("100%");
	$(".desk-alt-res-col").val("12");
}else{	
	$(".desk-alt-res-col-count").text("Default");
	$(".desk-alt-res-col").val("0");
}
//:: Responsive Large Desktop Column
let resLargeDeskCol = document.querySelector(".desk-alt-res-col");
resLargeDeskCol.oninput = function() {
	$(".ok-column-handle").parent().addClass('row-border');
	$(".ok-column-handle").addClass('column-border');
	if (this.value == 0) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("Default");
	} else if (this.value == 1) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("8.33%");
		$(".ok-column-handle").addClass("col-xl-1");
	} else if (this.value == 2) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("16.66%");
		$(".ok-column-handle").addClass("col-xl-2");
	} else if (this.value == 3) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("25%");
		$(".ok-column-handle").addClass("col-xl-3");
	} else if (this.value == 4) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("33.33%");
		$(".ok-column-handle").addClass("col-xl-4");
	} else if (this.value == 5) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("41.66%");
		$(".ok-column-handle").addClass("col-xl-5");
	} else if (this.value == 6) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("50%");
		$(".ok-column-handle").addClass("col-xl-6");
	} else if (this.value == 7) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("58.33%");
		$(".ok-column-handle").addClass("col-xl-7");
	} else if (this.value == 8) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("66.66%");
		$(".ok-column-handle").addClass("col-xl-8");
	} else if (this.value == 9) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("75%");
		$(".ok-column-handle").addClass("col-xl-9");
	} else if (this.value == 10) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("83.33%");
		$(".ok-column-handle").addClass("col-xl-10");
	} else if (this.value == 11) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("91.66%");
		$(".ok-column-handle").addClass("col-xl-11");
	} else if (this.value == 12) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xl-1 col-xl-2 col-xl-3 col-xl-4 col-xl-5 col-xl-6 col-xl-7 col-xl-8 col-xl-9 col-xl-10 col-xl-11 col-xl-12");
		$(".desk-alt-res-col-count").text("100%");
		$(".ok-column-handle").addClass("col-xl-12");
	}
};
//Check Default lg column values
if ($(".ok-column-handle").hasClass('col-lg-1')) {
	$(".desk-res-col-count").text("8.33%");
	$(".desk-res-col").val("1");
}else if ($(".ok-column-handle").hasClass('col-lg-2')) {
	$(".desk-res-col-count").text("16.66%");
	$(".desk-res-col").val("2");
}else if($(".ok-column-handle").hasClass('col-lg-3')) {
	$(".desk-res-col-count").text("25%");
	$(".desk-res-col").val("3");
}else if($(".ok-column-handle").hasClass('col-lg-4')) {
	$(".desk-res-col-count").text("33.33%");
	$(".desk-res-col").val("4");
}else if($(".ok-column-handle").hasClass('col-lg-5')) {
	$(".desk-res-col-count").text("41.66%");
	$(".desk-res-col").val("5");
}else if($(".ok-column-handle").hasClass('col-lg-6')) {
	$(".desk-res-col-count").text("50%");
	$(".desk-res-col").val("6");
}else if($(".ok-column-handle").hasClass('col-lg-7')) {
	$(".desk-res-col-count").text("58.33%");
	$(".desk-res-col").val("7");
}else if($(".ok-column-handle").hasClass('col-lg-8')) {
	$(".desk-res-col-count").text("66.66%");
	$(".desk-res-col").val("8");
}else if($(".ok-column-handle").hasClass('col-lg-9')) {
	$(".desk-res-col-count").text("75%");
	$(".desk-res-col").val("9");
}else if($(".ok-column-handle").hasClass('col-lg-10')) {
	$(".desk-res-col-count").text("83.33%");
	$(".desk-res-col").val("10");
}else if($(".ok-column-handle").hasClass('col-lg-11')) {
	$(".desk-res-col-count").text("91.66%");
	$(".desk-res-col").val("11");
}else if($(".ok-column-handle").hasClass('col-lg-12')) {
	$(".desk-res-col-count").text("100%");
	$(".desk-res-col").val("12");
}else{	
	$(".desk-res-col-count").text("Default");
	$(".desk-res-col").val("0");
}
//:: Responsive Desktop Column
let resDeskCol = document.querySelector(".desk-res-col");
resDeskCol.oninput = function() {
	$(".ok-column-handle").parent().addClass('row-border');
	$(".ok-column-handle").addClass('column-border');
	if (this.value == 0) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("Default");
	} else if (this.value == 1) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("8.33%");
		$(".ok-column-handle").addClass("col-lg-1");
	} else if (this.value == 2) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("16.66%");
		$(".ok-column-handle").addClass("col-lg-2");
	} else if (this.value == 3) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("25%");
		$(".ok-column-handle").addClass("col-lg-3");
	} else if (this.value == 4) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("33.33%");
		$(".ok-column-handle").addClass("col-lg-4");
	} else if (this.value == 5) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("41.66%");
		$(".ok-column-handle").addClass("col-lg-5");
	} else if (this.value == 6) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("50%");
		$(".ok-column-handle").addClass("col-lg-6");
	} else if (this.value == 7) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("58.33%");
		$(".ok-column-handle").addClass("col-lg-7");
	} else if (this.value == 8) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("66.66%");
		$(".ok-column-handle").addClass("col-lg-8");
	} else if (this.value == 9) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("75%");
		$(".ok-column-handle").addClass("col-lg-9");
	} else if (this.value == 10) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("83.33%");
		$(".ok-column-handle").addClass("col-lg-10");
	} else if (this.value == 11) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("91.66%");
		$(".ok-column-handle").addClass("col-lg-11");
	} else if (this.value == 12) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-lg-1 col-lg-2 col-lg-3 col-lg-4 col-lg-5 col-lg-6 col-lg-7 col-lg-8 col-lg-9 col-lg-10 col-lg-11 col-lg-12");
		$(".desk-res-col-count").text("100%");
		$(".ok-column-handle").addClass("col-lg-12");
	}
};
//Check Default md column values
if ($(".ok-column-handle").hasClass('col-md-1')) {
	$(".tab-res-col-count").text("8.33%");
	$(".tab-res-col").val("1");
}else if ($(".ok-column-handle").hasClass('col-md-2')) {
	$(".tab-res-col-count").text("16.66%");
	$(".tab-res-col").val("2");
}else if($(".ok-column-handle").hasClass('col-md-3')) {
	$(".tab-res-col-count").text("25%");
	$(".tab-res-col").val("3");
}else if($(".ok-column-handle").hasClass('col-md-4')) {
	$(".tab-res-col-count").text("33.33%");
	$(".tab-res-col").val("4");
}else if($(".ok-column-handle").hasClass('col-md-5')) {
	$(".tab-res-col-count").text("41.66%");
	$(".tab-res-col").val("5");
}else if($(".ok-column-handle").hasClass('col-md-6')) {
	$(".tab-res-col-count").text("50%");
	$(".tab-res-col").val("6");
}else if($(".ok-column-handle").hasClass('col-md-7')) {
	$(".tab-res-col-count").text("58.33%");
	$(".tab-res-col").val("7");
}else if($(".ok-column-handle").hasClass('col-md-8')) {
	$(".tab-res-col-count").text("66.66%");
	$(".tab-res-col").val("8");
}else if($(".ok-column-handle").hasClass('col-md-9')) {
	$(".tab-res-col-count").text("75%");
	$(".tab-res-col").val("9");
}else if($(".ok-column-handle").hasClass('col-md-10')) {
	$(".tab-res-col-count").text("83.33%");
	$(".tab-res-col").val("10");
}else if($(".ok-column-handle").hasClass('col-md-11')) {
	$(".tab-res-col-count").text("91.66%");
	$(".tab-res-col").val("11");
}else if($(".ok-column-handle").hasClass('col-md-12')) {
	$(".tab-res-col-count").text("100%");
	$(".tab-res-col").val("12");
}else{	
	$(".tab-res-col-count").text("Default");
	$(".tab-res-col").val("0");
}
//:: Responsive Tablet Column
let resTabCol = document.querySelector(".tab-res-col");
resTabCol.oninput = function() {
	$(".ok-column-handle").parent().addClass('row-border');
	$(".ok-column-handle").addClass('column-border');
	if (this.value == 0) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("Default");
	} else if (this.value == 1) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("8.33%");
		$(".ok-column-handle").addClass("col-md-1");
	} else if (this.value == 2) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("16.66%");
		$(".ok-column-handle").addClass("col-md-2");
	} else if (this.value == 3) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("25%");
		$(".ok-column-handle").addClass("col-md-3");
	} else if (this.value == 4) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("33.33%");
		$(".ok-column-handle").addClass("col-md-4");
	} else if (this.value == 5) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("41.66%");
		$(".ok-column-handle").addClass("col-md-5");
	} else if (this.value == 6) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("50%");
		$(".ok-column-handle").addClass("col-md-6");
	} else if (this.value == 7) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("58.33%");
		$(".ok-column-handle").addClass("col-md-7");
	} else if (this.value == 8) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("66.66%");
		$(".ok-column-handle").addClass("col-md-8");
	} else if (this.value == 9) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("75%");
		$(".ok-column-handle").addClass("col-md-9");
	} else if (this.value == 10) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("83.33%");
		$(".ok-column-handle").addClass("col-md-10");
	} else if (this.value == 11) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("91.66%");
		$(".ok-column-handle").addClass("col-md-11");
	} else if (this.value == 12) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-md-1 col-md-2 col-md-3 col-md-4 col-md-5 col-md-6 col-md-7 col-md-8 col-md-9 col-md-10 col-md-11 col-md-12");
		$(".tab-res-col-count").text("100%");
		$(".ok-column-handle").addClass("col-md-12");
	}
};
//Check Default sm column values
if ($(".ok-column-handle").hasClass('col-sm-1')) {
	$(".mob-res-col-count").text("8.33%");
	$(".mob-res-col").val("1");
}else if ($(".ok-column-handle").hasClass('col-sm-2')) {
	$(".mob-res-col-count").text("16.66%");
	$(".mob-res-col").val("2");
}else if($(".ok-column-handle").hasClass('col-sm-3')) {
	$(".mob-res-col-count").text("25%");
	$(".mob-res-col").val("3");
}else if($(".ok-column-handle").hasClass('col-sm-4')) {
	$(".mob-res-col-count").text("33.33%");
	$(".mob-res-col").val("4");
}else if($(".ok-column-handle").hasClass('col-sm-5')) {
	$(".mob-res-col-count").text("41.66%");
	$(".mob-res-col").val("5");
}else if($(".ok-column-handle").hasClass('col-sm-6')) {
	$(".mob-res-col-count").text("50%");
	$(".mob-res-col").val("6");
}else if($(".ok-column-handle").hasClass('col-sm-7')) {
	$(".mob-res-col-count").text("58.33%");
	$(".mob-res-col").val("7");
}else if($(".ok-column-handle").hasClass('col-sm-8')) {
	$(".mob-res-col-count").text("66.66%");
	$(".mob-res-col").val("8");
}else if($(".ok-column-handle").hasClass('col-sm-9')) {
	$(".mob-res-col-count").text("75%");
	$(".mob-res-col").val("9");
}else if($(".ok-column-handle").hasClass('col-sm-10')) {
	$(".mob-res-col-count").text("83.33%");
	$(".mob-res-col").val("10");
}else if($(".ok-column-handle").hasClass('col-sm-11')) {
	$(".mob-res-col-count").text("91.66%");
	$(".mob-res-col").val("11");
}else if($(".ok-column-handle").hasClass('col-sm-12')) {
	$(".mob-res-col-count").text("100%");
	$(".mob-res-col").val("12");
}else{	
	$(".mob-res-col-count").text("Default");
	$(".mob-res-col").val("0");
}
//:: Responsive Mobile Column
let resMobCol = document.querySelector(".mob-res-col");
resMobCol.oninput = function() {
	$(".ok-column-handle").parent().addClass('row-border');
	$(".ok-column-handle").addClass('column-border');
	if (this.value == 0) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("Default");
	} else if (this.value == 1) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("8.33%");
		$(".ok-column-handle").addClass("col-sm-1");
	} else if (this.value == 2) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("16.66%");
		$(".ok-column-handle").addClass("col-sm-2");
	} else if (this.value == 3) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("25%");
		$(".ok-column-handle").addClass("col-sm-3");
	} else if (this.value == 4) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("33.33%");
		$(".ok-column-handle").addClass("col-sm-4");
	} else if (this.value == 5) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("41.66%");
		$(".ok-column-handle").addClass("col-sm-5");
	} else if (this.value == 6) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("50%");
		$(".ok-column-handle").addClass("col-sm-6");
	} else if (this.value == 7) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("58.33%");
		$(".ok-column-handle").addClass("col-sm-7");
	} else if (this.value == 8) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("66.66%");
		$(".ok-column-handle").addClass("col-sm-8");
	} else if (this.value == 9) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("75%");
		$(".ok-column-handle").addClass("col-sm-9");
	} else if (this.value == 10) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("83.33%");
		$(".ok-column-handle").addClass("col-sm-10");
	} else if (this.value == 11) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("91.66%");
		$(".ok-column-handle").addClass("col-sm-11");
	} else if (this.value == 12) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-sm-1 col-sm-2 col-sm-3 col-sm-4 col-sm-5 col-sm-6 col-sm-7 col-sm-8 col-sm-9 col-sm-10 col-sm-11 col-sm-12");
		$(".mob-res-col-count").text("100%");
		$(".ok-column-handle").addClass("col-sm-12");
	}
};

//Check Default xsm column values
if ($(".ok-column-handle").hasClass('col-xsm-3')) {
	$(".xsm-mob-col-count").text("25%");
	$(".xsm-mob-col").val("1");
}else if ($(".ok-column-handle").hasClass('col-xsm-6')) {
	$(".xsm-mob-col-count").text("50%");
	$(".xsm-mob-col").val("2");
}else if ($(".ok-column-handle").hasClass('col-xsm-9')) {
	$(".xsm-mob-col-count").text("75%");
	$(".xsm-mob-col").val("3");
}else{
	$(".xsm-mob-col-count").text("100%");
	$(".xsm-mob-col").val("4");
}
//:: Responsive Extra Small Mobile Column
let xsmMobCol = document.querySelector(".xsm-mob-col");
xsmMobCol.oninput = function() {
	$(".ok-column-handle").parent().addClass('row-border');
	$(".ok-column-handle").addClass('column-border');
	if (this.value == 0) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xsm-3 col-xsm-6 col-xsm-9");
		$(".xsm-mob-col-count").text("Default");
	}else if (this.value == 1) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xsm-3 col-xsm-6 col-xsm-9");
		$(".xsm-mob-col-count").text("25%");
		$(".ok-column-handle").addClass("col-xsm-3");
	}else if (this.value == 2) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xsm-3 col-xsm-6 col-xsm-9");
		$(".xsm-mob-col-count").text("50%");
		$(".ok-column-handle").addClass("col-xsm-6");
	}else if (this.value == 3) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xsm-3 col-xsm-6 col-xsm-9");
		$(".xsm-mob-col-count").text("75%");
		$(".ok-column-handle").addClass("col-xsm-9");
	}else if (this.value == 4) {
        $(".ok-column-handle").removeClass("col col-1 col-2 col-3 col-4 col-5 col-6 col-7 col-8 col-9 col-10 col-11 col-12 col-xsm-3 col-xsm-6 col-xsm-9");
		$(".xsm-mob-col-count").text("100%");
	}
}

//Check Default Column Alignments
if($('.ok-column-handle').hasClass('text-xl-start')){
	$('.desk-align-left').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-xl-center')){
	$('.desk-align-center').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-xl-end')){
	$('.desk-align-right').addClass('bg-primary');
}else{
	$('.desk-align-none').addClass('bg-primary');
}
//lg
if($('.ok-column-handle').hasClass('text-lg-start')){
	$('.small-desk-align-left').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-lg-center')){
	$('.small-desk-align-center').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-lg-end')){
	$('.small-desk-align-right').addClass('bg-primary');
}else{
	$('.small-desk-align-none').addClass('bg-primary');
}
//md
if($('.ok-column-handle').hasClass('text-md-start')){
	$('.tab-align-left').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-md-center')){
	$('.tab-align-center').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-md-end')){
	$('.tab-align-right').addClass('bg-primary');
}else{
	$('.tab-align-none').addClass('bg-primary');
}
//sm
if($('.ok-column-handle').hasClass('text-sm-start')){
	$('.mob-align-left').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-sm-center')){
	$('.mob-align-center').addClass('bg-primary');
}else if($('.ok-column-handle').hasClass('text-sm-end')){
	$('.mob-align-right').addClass('bg-primary');
}else{
	$('.mob-align-none').addClass('bg-primary');
}
//Responsive Text Alignments
$(document).on('click', '.desk-align-none', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-xl-start text-xl-center text-xl-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-xl-start justify-content-xl-center justify-content-xl-end');
});	
$(document).on('click', '.desk-align-left', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-xl-start text-xl-center text-xl-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-xl-start justify-content-xl-center justify-content-xl-end');
    $('.ok-column-handle').addClass('text-xl-start');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-xl-start');
});	
$(document).on('click', '.desk-align-center', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-xl-start text-xl-center text-xl-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-xl-start justify-content-xl-center justify-content-xl-end');
    $('.ok-column-handle').addClass('text-xl-center');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-xl-center');
});
$(document).on('click', '.desk-align-right', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-xl-start text-xl-center text-xl-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-xl-start justify-content-xl-center justify-content-xl-end');
    $('.ok-column-handle').addClass('text-xl-end');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-xl-end');
});
//lg
$(document).on('click', '.small-desk-align-none', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-lg-start text-lg-center text-lg-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-lg-start justify-content-lg-center justify-content-lg-end');
});	
$(document).on('click', '.small-desk-align-left', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-lg-start text-lg-center text-lg-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-lg-start justify-content-lg-center justify-content-lg-end');
    $('.ok-column-handle').addClass('text-lg-start');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-lg-start');
});	
$(document).on('click', '.small-desk-align-center', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-lg-start text-lg-center text-lg-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-lg-start justify-content-lg-center justify-content-lg-end');
    $('.ok-column-handle').addClass('text-lg-center');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-lg-center');
});
$(document).on('click', '.small-desk-align-right', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-lg-start text-lg-center text-lg-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-lg-start justify-content-lg-center justify-content-lg-end');
    $('.ok-column-handle').addClass('text-lg-end');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-lg-end');
});
//md
$(document).on('click', '.tab-align-none', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-md-start text-md-center text-md-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-md-start justify-content-md-center justify-content-md-end');
});	
$(document).on('click', '.tab-align-left', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-md-start text-md-center text-md-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-md-start justify-content-md-center justify-content-md-end');
    $('.ok-column-handle').addClass('text-md-start');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-md-start');
});	
$(document).on('click', '.tab-align-center', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-md-start text-md-center text-md-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-md-start justify-content-md-center justify-content-md-end');
    $('.ok-column-handle').addClass('text-md-center');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-md-center');
});
$(document).on('click', '.tab-align-right', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-md-start text-md-center text-md-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-md-start justify-content-md-center justify-content-md-end');
    $('.ok-column-handle').addClass('text-md-end');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-md-end');
});
//sm
$(document).on('click', '.mob-align-none', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-sm-start text-sm-center text-sm-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-sm-start justify-content-sm-center justify-content-sm-end');
});	
$(document).on('click', '.mob-align-left', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-sm-start text-sm-center text-sm-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-sm-start justify-content-sm-center justify-content-sm-end');
    $('.ok-column-handle').addClass('text-sm-start');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-sm-start');
});	
$(document).on('click', '.mob-align-center', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-sm-start text-sm-center text-sm-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-sm-start justify-content-sm-center justify-content-sm-end');
    $('.ok-column-handle').addClass('text-sm-center');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-sm-center');
});
$(document).on('click', '.mob-align-right', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('.ok-column-handle').removeClass('text-start text-center text-end text-justify text-sm-start text-sm-center text-sm-end');
    $('.ok-column-handle').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end justify-content-sm-start justify-content-sm-center justify-content-sm-end');
    $('.ok-column-handle').addClass('text-sm-end');
	$('.ok-column-handle').find('.ok-flex').addClass('justify-content-sm-end');
});

//Check default Column Padding values
if($('.ok-column-handle').hasClass("p-0")){
	$('#column-padding-count').text('0px');
	$('#column-padding').val('1');
}else if($('.ok-column-handle').hasClass("p-10")){
	$('#column-padding-count').text('10px');
	$('#column-padding').val('2');
}else if($('.ok-column-handle').hasClass("p-20")){
	$('#column-padding-count').text('20px');
	$('#column-padding').val('3');
}else if($('.ok-column-handle').hasClass("p-30")){
	$('#column-padding-count').text('30px');
	$('#column-padding').val('4');
}else if($('.ok-column-handle').hasClass("p-40")){
	$('#column-padding-count').text('40px');
	$('#column-padding').val('5');
}else if($('.ok-column-handle').hasClass("p-50")){
	$('#column-padding-count').text('50px');
	$('#column-padding').val('6');
}else{
	$('#column-padding-count').text('Default');
	$('#column-padding').val('0');
}
//:: Column Padding
let columnPadding = document.getElementById("column-padding");
columnPadding.oninput = function() {
   $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
	if (this.value == 0) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");        
		$("#column-padding-count").text('Default');
    } else if (this.value == 1) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('.ok-column-handle').addClass("p-0");       
		$("#column-padding-count").text('0px');
    } else if (this.value == 2) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('.ok-column-handle').addClass("p-10");       
		$("#column-padding-count").text('10px');
    } else if (this.value == 3) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('.ok-column-handle').addClass("p-20");       
		$("#column-padding-count").text('20px');
    } else if (this.value == 4) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('.ok-column-handle').addClass("p-30");       
		$("#column-padding-count").text('30px');
    } else if (this.value == 5) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('.ok-column-handle').addClass("p-40");       
		$("#column-padding-count").text('40px');
    } else if (this.value == 6) {
        $('.ok-column-handle').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('.ok-column-handle').addClass("p-50");       
		$("#column-padding-count").text('50px');
    }
}

});//END:: column settings

//Copy Column
$(document).on('click', '#copy-column', function(){
	$('#copy-db').html($('.ok-column-handle').clone());
	$('#copy-db').find('.ok-column').addClass('copyed');
	$('#copy-db').find('#column-setting-tools').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html('<style>#main-menu-panel button {background: #000000!important; color: #ffffff!important;} .copy-element, .ok-column-handle #column-setting-tools .paste-element {display: none!important;} .paste-element {display: none!important;} .ok-column-handle #column-setting-tools .paste-element {display: inline-block!important;}</style>');
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: block!important;}</style>');
	}
});
//Delete Column
$(document).on('click', '#delete-column', function() {
	$('.ok-column-handle').remove();
	//Add Placeholder if row is empty
	$('.ok-row').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="ok-column col">'
			+'	<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'</div>');
		} 
	});
});
//Duplicate Column
$(document).on('click', '#duplicate-column', function(e) {
	//e.stopImmediatePropagation();
	e.preventDefault();
	$('.ok-column-handle').clone().insertAfter('.ok-column-handle');
	$('.ok-column').removeClass('column-border ok-column-handle');
	$('#column-setting-tools').remove(); 
});

//Copy Slider
$(document).on('click', '#copy-slider', function(){
	$('#copy-db').html($('#ok-slider-wrap').html());
	$('#copy-db').find('.swiper').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			color: #ffffff!important;
			background: #0D47A1!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		#ok-card-wrap .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element,
		#card-setting-tools .paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: block!important;}</style>');
	}
});
//Delete slider
$(document).on('click', '#delete-slider', function() {
	$('#ok-slider-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});
//Duplicate slider
$(document).on('click', '#duplicate-slider', function(e) {
	e.preventDefault();
	$('#ok-slider-wrap').find('.swiper').clone().insertAfter('#ok-slider-wrap');
	$('#slider-setting-tools').remove(); 	 
	$('#ok-slider-wrap').contents().unwrap();
});

//Slide Settings
$(document).on('click', '#slider-setting-menu', function() {
	//Remove First
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').removeClass('ok-slider-border');
	$('#slider-setting-tools').hide();
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');

//Slide Setting Panel
let slidePanel = [];
slidePanel.push(`	
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="section-setting-header">Slide Settings</span>
		<span id="close-panel" class="card-setting-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Slider Numbers -->
			<div class="slider-control-panel">
			<div class="setting-title">
				<p>Number of Slides</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Slides = <span class="ele-slide-count">1</span></p>
								<input class="ele-slide" type="range" min="1" max="4" step="1" value="1" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Slider Numbers -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = slidePanel.join("");

//Default Slide numbers
if($('#ok-slider-wrap .swiper').hasClass('swiper-1')){	
	$(".ele-slide-count").text('1');
	$(".ele-slide").val('1');
}
if($('#ok-slider-wrap .swiper').hasClass('swiper-2')){	
	$(".ele-slide-count").text('2');
	$(".ele-slide").val('2');
}
if($('#ok-slider-wrap .swiper').hasClass('swiper-3')){	
	$(".ele-slide-count").text('3');
	$(".ele-slide").val('3');
}
if($('#ok-slider-wrap .swiper').hasClass('swiper-4')){	
	$(".ele-slide-count").text('4');
	$(".ele-slide").val('4');
}
//:: Slider Numbers
let eleSlide = document.querySelector(".ele-slide");
eleSlide.oninput = function() {
   $('#ok-slider-wrap .swiper').removeClass("swiper-1 swiper-2 swiper-2-no-loop swiper-3 swiper-4");
   $('#ok-slider-wrap .swiper-notification').remove();
   $('#ok-slider-wrap .swiper-slide').removeClass('swiper-slide-active swiper-slide-next');
   $('#ok-slider-wrap .swiper-slide').removeAttr('aria-label');
   $('#ok-slider-wrap .swiper-slide').attr('style', '');
   $('#ok-slider-wrap .swiper-wrapper').removeAttr('aria-live');
   $('#ok-slider-wrap .swiper-wrapper').attr('id', '');
   $('#ok-slider-wrap .swiper-wrapper').attr('style', '');
	if (this.value == 1) {
		$(".ele-slide-count").text('1');
		$('#ok-slider-wrap .swiper').removeClass("swiper-1 swiper-2 swiper-2-no-loop swiper-3 swiper-4"); 
		$('#ok-slider-wrap .swiper').addClass("swiper-1");
		$('#ok-slider-wrap .swiper-slide').attr('aria-label', '');
		//For Swiper Slider 1 with loop
		var swiperOneLoop = new Swiper('.swiper-1', {
		slidesPerView: 1,
		spaceBetween: 0, 
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
		});
    } else if (this.value == 2) {
		$(".ele-slide-count").text('2');
		$('#ok-slider-wrap .swiper').removeClass("swiper-1 swiper-2 swiper-2-no-loop swiper-3 swiper-4");   
		$('#ok-slider-wrap .swiper').addClass("swiper-2");
		$('#ok-slider-wrap .swiper-slide').attr('aria-label', '');
		//For Swiper Slider 2 without loop
		var swiperTwo = new Swiper('.swiper-2', {
			slidesPerView: 2,
			spaceBetween: 20, 
			breakpoints: {
				300: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				575: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				767: {
					slidesPerView: 2,
					spaceBetween: 20
				},
				991: {
					slidesPerView: 2,
					spaceBetween: 20
				},
				1199: {
					slidesPerView: 2,
					spaceBetween: 20
				},	
			},
			navigation: {
				nextEl: '.swiper-ctrl-next',
				prevEl: '.swiper-ctrl-prev',
			}
		});
    } else if (this.value == 3) {
		$(".ele-slide-count").text('3');
		$('#ok-slider-wrap .swiper').removeClass("swiper-1 swiper-2 swiper-2-no-loop swiper-3 swiper-4");  
		$('#ok-slider-wrap .swiper').addClass("swiper-3");
		$('#ok-slider-wrap .swiper-slide').attr('aria-label', '');
		//For Swiper Slider 3 without loop
		var swiperThree = new Swiper('.swiper-3', {
			slidesPerView: 3,
			spaceBetween: 20,
			// Responsive breakpoints
			breakpoints: {
				300: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				575: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				767: {
					slidesPerView: 2,
					spaceBetween: 20
				},
				991: {
					slidesPerView: 3,
					spaceBetween: 20
				},
				1199: {
					slidesPerView: 3,
					spaceBetween: 20
				},	
			},
			// Navigation arrows
			navigation: {
				nextEl: '.swiper-ctrl-next',
				prevEl: '.swiper-ctrl-prev',
			}
		});
    } else if (this.value == 4) {
		$(".ele-slide-count").text('4');
		$('#ok-slider-wrap .swiper').removeClass("swiper-1 swiper-2 swiper-2-no-loop swiper-3 swiper-4"); 
		$('#ok-slider-wrap .swiper').addClass("swiper-4");
		$('#ok-slider-wrap .swiper-slide').attr('aria-label', '');
		//For Swiper Slider 4 without loop
		var swiperFour = new Swiper('.swiper-4', {
			slidesPerView: 4,
			spaceBetween: 20,
			// Responsive breakpoints
			breakpoints: {
				300: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				575: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				767: {
					slidesPerView: 2,
					spaceBetween: 20
				},
				991: {
					slidesPerView: 4,
					spaceBetween: 20
				},
				1199: {
					slidesPerView: 4,
					spaceBetween: 20
				},	
			},
			// Navigation arrows
			navigation: {
				nextEl: '.swiper-ctrl-next',
				prevEl: '.swiper-ctrl-prev',
			}
		});
    }
	
}
});//END:: card settings

//Card Settings
$(document).on('click', '#card-setting-menu', function() {
	//Remove First
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').removeClass('ok-card-border');
	$('#card-setting-tools').hide();
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
	
//Card Setting Panel
let cardPanel = [];
cardPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="section-setting-header">Card Settings</span>
		<span id="close-panel" class="card-setting-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Alignment -->
			<div class="setting-title">
				<p>Alignment</p>
			</div>
			<div class="settings">
				<p>Alignment</p>
				<div class="button-25-wrap">
					<button class="card-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="card-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="card-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="card-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
			</div><!-- ::END:: Alignment -->
			<!-- ::START:: Vertical Alignment -->
			<div id="card-valign-control">
			<div class="setting-title">
				<p>Vertical Alignment</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<select id="card-valign" class="ok-select-opt">
								<option value="">None</option>
								<option value="d-flex align-items-start">Top</option>
								<option value="d-flex align-items-center">Middle</option>
								<option value="d-flex align-items-end">Bottom</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Vertical Alignment -->
			<!-- ::START:: Upload Image Setting -->
			<div id="card-image-control">
			<div class="setting-title">
				<p>Upload Image</p>
			</div>	
			<div class="settings">
				<div class="table-box">
					<table border="0" width="100%">
						<tr>
							<td width="30%">
								<p>From PC</p>
								<button id="add-card-image" class="upload-image sbgcolor pbghover" title="Upload Image">
									<i class="fas fa-upload"></i>
								</button>
								<form class="hidden-form" method="post" action="okcc/php/image-uploader.php" enctype="multipart/form-data" target="hiddenCardFrame">
									<input id="cardbgimage-filename" type="text" name="newfilename">
									<input type="text" name="imguser" value="`+uniqueUser+`">
									<input type="file" name="photo" id="add-main-cardbgimage" accept=".jpg,.png,.svg,.gif">
									<input id="upload-cardbgimage" type="submit" name="submit" value="Upload">
								</form>
							</td>
							<td width="70%">
								<p>By URL</p>
								<input class="input-card-image-overlay input" type="text" placeholder="Image by URL">
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<img id="card-image-preview" src="" alt="">
								<!-- Submit Form without leaving page -->
								<iframe name="hiddenCardFrame" id="main-cardbgimage-iframe" class="image-upload-iframe">
									Loading...
								</iframe>
							</td>
						</tr>
					</table>
					<div id="main-cardimage-dir" style="overflow: auto;width:100%;height:200px;"></div>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Alt Text</p>
								<textarea class="input-card-image-alt input" type="text" placeholder="Enter Alt Text"></textarea>
							</td>
						</tr>
					</table>
				</div>
			</div>
			</div><!-- ::END:: Upload Image Setting -->	
			<!-- ::START:: Background Color -->
			<div class="background-control-panel">
			<div class="setting-title">
				<p>Background Color</p>
			</div>
			<div class="settings">
				<div class="color-table table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button class="main-bgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bgcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr id="card-overlay-opt">
						<td width="100%">
							<div class="slider-container">
								<p>Opacity <span id="card-opacity-count">0.6</span></p>
								<input id="card-opacity" type="range" min="0" max="1" step="0.1" value="1">
							</div>
						</td>
					</tr>
					<tr id="card-hover-bg-color">
						<td width="100%">
							<p>Background Hover Color</p>
							<button class="main-hobgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hobgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobgcolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Background Color -->
			<!-- ::START:: Border -->
			<div class="border-control-panel">
			<div class="setting-title">
				<p>Border</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="border-selector ok-select-opt">
								<option value="">None</option>
								<option value="border border-1">Border</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<div class="border-color-opt color-table table-box">
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Color</p>
							<button class="main-bdrcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bdrcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bdrcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bdrcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bdrcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bdrcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bdrcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bdrcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bdrcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bdrcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bdrcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Hover Color</p>
							<button class="main-hobdrcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobdrcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobdrcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobdrcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobdrcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobdrcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobdrcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobdrcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobdrcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobdrcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobdrcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
				</table>				
				<div class="slider-container">
					<p>Border size = <span class="ele-bdr-count">0</span></p>
					<input class="ele-bdr" type="range" min="1" max="5" step="1" value="0" />
				</div>
				</div>
			</div>
			</div><!-- ::END:: Border -->
			<!-- ::START:: Border Radius -->
			<div class="border-radius-control-panel">
			<div class="setting-title">
				<p>Border Radius</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="select-border-radius ok-select-opt">
								<option value="rounded-0">None</option>
								<option value="rounded">Rounded</option>
								<option id="pill-id" value="rounded-pill">Rounded Pill</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Border Radius -->
			<!-- ::START:: Width -->
			<div class="card-width-control-panel">
			<div class="setting-title">
				<p>Width/Height</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="select-card-width ok-select-opt">
								<option value="d-inline-block ok-line">Default</option>
								<option value="w-100">Full Width</option>
								<option id="card-full-wh" value="w-100 h-100">Full Width & Height</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Width -->
			<!-- ::START:: Padding -->
			<div class="setting-title">
				<p>Padding</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Padding = <span id="card-padding-count">0</span></p>
								<input id="card-padding" type="range" min="0" max="6" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div><!-- ::END:: Padding -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = cardPanel.join("");

//Add image from directory
$.ajax({
    url: ''+domainName+'/image-dir.php',
    success: function(html) {
       $("#main-cardimage-dir").append(html);
    }
});
$(document).on("click", "#card-image-preview, #main-cardimage-dir img", function() {
	$("#ok-card-wrap").find('.ok-card-image-overlay').attr('src', $(this).attr("src"));
});

//Check slider
if($('#ok-card-wrap .ok-card').hasClass('swiper-slide')){
	$(".border-radius-control-panel, .card-width-control-panel").hide();
}else{	
	$(".border-radius-control-panel, .card-width-control-panel").show();
}

//Check default Alignments
if( $('#ok-card-wrap .card-body').hasClass('text-start')||$('#ok-card-wrap .card-body').hasClass('justify-content-start')){
	$('.card-align-left').addClass('bg-primary');
}else if( $('#ok-card-wrap .card-body').hasClass('text-center')||$('#ok-card-wrap .card-body').hasClass('justify-content-center')){
	$('.card-align-center').addClass('bg-primary');
}else if( $('#ok-card-wrap .card-body').hasClass('text-end')||$('#ok-card-wrap .card-body').hasClass('justify-content-end')){
	$('.card-align-right').addClass('bg-primary');
}else{
	$('.card-align-none').addClass('bg-primary');
}
//Alignments
$(document).on('click', '.card-align-none', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-card-wrap').find('.card-body').removeClass('d-flex text-start text-center text-end text-justify text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end');
});	
$(document).on('click', '.card-align-left', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-card-wrap').find('.card-body').removeClass('d-flex text-start text-center text-end text-justify text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').addClass('justify-content-start');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap').find('.card-body').addClass('d-flex justify-content-start');
	}else{
		$('#ok-card-wrap').find('.card-body').addClass('text-start');
	}
});	
$(document).on('click', '.card-align-right', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-card-wrap').find('.card-body').removeClass('d-flex text-start text-center text-end text-justify text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').addClass('justify-content-end');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap').find('.card-body').addClass('d-flex justify-content-end');
	}else{
		$('#ok-card-wrap').find('.card-body').addClass('text-end');
	}
});
$(document).on('click', '.card-align-center', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-card-wrap').find('.card-body').removeClass('d-flex text-start text-center text-end text-justify text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').removeClass('justify-content-start justify-content-center justify-content-end');
    $('#ok-card-wrap').find('.ok-flex').addClass('justify-content-center');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap').find('.card-body').addClass('d-flex justify-content-center');
	}else{
		$('#ok-card-wrap').find('.card-body').addClass('text-center');
	}
});

//Disable Card Opacity/Image Overlay/Vertical alignment
if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
	$("#card-overlay-opt, #card-image-control, #card-valign-control").show();
	$("#card-hover-bg-color, .card-width-control-panel").hide();
}else{
	$("#card-overlay-opt, #card-image-control, #card-valign-control").hide();
	$("#card-hover-bg-color").show();
}

//Check default Card Vertical alignment
if($('#ok-card-wrap .card-body').hasClass("align-items-start")){
	$("#card-valign option[value='d-flex align-items-start']").attr('selected','selected');
}else if($('#ok-card-wrap .card-body').hasClass("align-items-center")) {
	$("#card-valign option[value='d-flex align-items-center']").attr('selected','selected');	
}else if($('#ok-card-wrap .card-body').hasClass("align-items-end")){
	$("#card-valign option[value='d-flex align-items-end']").attr('selected','selected');
}else{
	$("#card-valign option[value='']").attr('selected','selected');
}
// Card Vertical alignment
$("#card-valign").change(function() {
	$('#ok-card-wrap .card-body').removeClass("d-flex align-items-start align-items-center align-items-end");
	$('#ok-card-wrap .card-body').addClass($(this).val());
});

//Card Width/Height
if($('#ok-card-wrap').find('.ok-card').hasClass('w-100')){
	$(".select-card-width option[value=w-100]").attr('selected','selected');
}
if($('#ok-card-wrap').find('.w-100').hasClass('h-100')){
	$(".select-card-width option[id=card-full-wh]").attr('selected','selected');
}
$(document).on('change', '.select-card-width', function(){
	$('#ok-card-wrap').removeClass('w-100 d-inline ok-line h-100');
	$('#ok-card-wrap').find('.card-body, .ok-card').removeClass('w-100 d-inline ok-line h-100');
	$('#ok-card-wrap').addClass(this.value);
	$('#ok-card-wrap').find('.card-body, .ok-card').addClass(this.value);
});

//Get Image Data
if($("#ok-card-wrap").find('.ok-card-image-overlay').length>0){
	$('#card-image-preview').attr('src', $("#ok-card-wrap .ok-card-image-overlay").attr('src'));	
}else{
	$('#card-image-preview').attr('src', 'okcc/img/img.svg');
}
//Add Image from Desktop
$("#add-card-image").on('click', function(){
	$('#add-main-cardbgimage').click();
});
$("#add-main-cardbgimage").change(function(){
	$("#main-cardbgimage-iframe").hide();//Hide file upload messages
	$("#add-card-image").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
	let newCardImgFileName = 'id'+uniqueUser+(new Date()).getTime();//set unique image name
	let ymdHmsCard = document.getElementById("cardbgimage-filename").value = newCardImgFileName;
	//Get the file input element by its id 
	var fileInputCard = document.getElementById('add-main-cardbgimage');
	//Get the file name
	var fileNameCard = fileInputCard.files[0].name;
	//Get the file Extension 
	var cardFileExtension = fileNameCard.split('.').pop();
	$('#upload-cardbgimage').click();
	
	$('#main-cardbgimage-iframe').on('load', function() {	
		$("#ok-card-wrap").find('.ok-card-image-overlay').attr('src', 'assets/img/'+uniqueUser+'/'+ymdHmsCard+'.'+cardFileExtension);
		$("#ok-card-wrap").find('.ok-card-image-overlay').addClass('image-string');
		$('#card-image-preview').attr('src', 'assets/img/'+uniqueUser+'/'+ymdHmsCard+'.'+cardFileExtension);
		
		if($("#main-cardbgimage-iframe").contents().find('#sucess-info').length>0){
			$("#add-card-image").html('<i class="fas fa-upload"></i>');
		}
		$("#main-cardbgimage-iframe").show();//Show file upload messages
	});
});	
$(".input-card-image-overlay").on("input", function() {
	$("#ok-card-wrap").find('.ok-card-image-overlay').attr('src', this.value);
	$("#ok-card-wrap").find('.ok-card-image-overlay').removeClass('image-string');
	$('#card-image-preview').attr('src', this.value);
});	
$(".input-card-image-alt").on("input", function() {
	$("#ok-card-wrap").find('.ok-card-image-overlay').attr('alt', this.value);
});

//Check Opacity
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-0')){
	$("#card-opacity-count").text('0');
	$("#card-opacity").val('0');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-1')){
	$("#card-opacity-count").text('0.1');
	$("#card-opacity").val('0.1');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-2')){
	$("#card-opacity-count").text('0.2');
	$("#card-opacity").val('0.2');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-3')){
	$("#card-opacity-count").text('0.3');
	$("#card-opacity").val('0.3');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-4')){
	$("#card-opacity-count").text('0.4');
	$("#card-opacity").val('0.4');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-5')){
	$("#card-opacity-count").text('0.5');
	$("#card-opacity").val('0.5');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-6')){
	$("#card-opacity-count").text('0.6');
	$("#card-opacity").val('0.6');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-7')){
	$("#card-opacity-count").text('0.7');
	$("#card-opacity").val('0.7');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-8')){
	$("#card-opacity-count").text('0.8');
	$("#card-opacity").val('0.8');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-9')){
	$("#card-opacity-count").text('0.9');
	$("#card-opacity").val('0.9');
}
if($('#ok-card-wrap .ok-card-overlay').hasClass('op-10')){
	$("#card-opacity-count").text('1');
	$("#card-opacity").val('1');
}

//:: Card BG Opacity
let cardOpacity = document.getElementById("card-opacity");
cardOpacity.oninput = function() {
    $("#card-opacity-count").text(this.value);
    $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
    if (this.value == 0) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-0");
    } else if (this.value == 0.1) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-1");
    } else if (this.value == 0.2) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-2");
    } else if (this.value == 0.3) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-3");
    } else if (this.value == 0.4) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-4");
    } else if (this.value == 0.5) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-5");
    } else if (this.value == 0.6) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-6");
    } else if (this.value == 0.7) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-7");
    } else if (this.value == 0.8) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-8");
    } else if (this.value == 0.9) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-9");
    } else if (this.value == 1) {
        $('#ok-card-wrap .ok-card-overlay').removeClass("op-0 op-1 op-2 op-3 op-4 op-5 op-6 op-7 op-8 op-9 op-10");
        $('#ok-card-wrap .ok-card-overlay').addClass("op-10");
    }
};

//Check default Card Padding values
if($('#ok-card-wrap').find('.card-body').hasClass("p-0")){
	$('#card-padding-count').text('0px');
	$('#card-padding').val('1');
}else if($('#ok-card-wrap').find('.card-body').hasClass("p-10")){
	$('#card-padding-count').text('10px');
	$('#card-padding').val('2');
}else if($('#ok-card-wrap').find('.card-body').hasClass("p-20")){
	$('#card-padding-count').text('20px');
	$('#card-padding').val('3');
}else if($('#ok-card-wrap').find('.card-body').hasClass("p-30")){
	$('#card-padding-count').text('30px');
	$('#card-padding').val('4');
}else if($('#ok-card-wrap').find('.card-body').hasClass("p-40")){
	$('#card-padding-count').text('40px');
	$('#card-padding').val('5');
}else if($('#ok-card-wrap').find('.card-body').hasClass("p-50")){
	$('#card-padding-count').text('50px');
	$('#card-padding').val('6');
}else{
	$('#card-padding-count').text('Default');
	$('#card-padding').val('0');
}
//:: Card Padding
let cardPadding = document.getElementById("card-padding");
cardPadding.oninput = function() {
   $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
	if (this.value == 0) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");        
		$("#card-padding-count").text('Default');
    } else if (this.value == 1) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('#ok-card-wrap').find('.card-body').addClass("p-0");       
		$("#card-padding-count").text('0px');
    } else if (this.value == 2) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('#ok-card-wrap').find('.card-body').addClass("p-10");       
		$("#card-padding-count").text('10px');
    } else if (this.value == 3) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('#ok-card-wrap').find('.card-body').addClass("p-20");       
		$("#card-padding-count").text('20px');
    } else if (this.value == 4) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('#ok-card-wrap').find('.card-body').addClass("p-30");       
		$("#card-padding-count").text('30px');
    } else if (this.value == 5) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('#ok-card-wrap').find('.card-body').addClass("p-40");       
		$("#card-padding-count").text('40px');
    } else if (this.value == 6) {
        $('#ok-card-wrap').find('.card-body').removeClass("p-0 p-10 p-20 p-30 p-40 p-50");
        $('#ok-card-wrap').find('.card-body').addClass("p-50");       
		$("#card-padding-count").text('50px');
    }
}	
});//END:: card settings

//Copy Card
$(document).on('click', '#copy-card', function(){
	$('#copy-db').html($('#ok-card-wrap').html());
	$('#copy-db').find('.ok-card').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			background: #388E3C!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		#ok-card-wrap .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element,
		#card-setting-tools .paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: block!important;}</style>');
	}
});
//Duplicate Card
$(document).on('click', '#duplicate-card', function(e) {
	e.preventDefault();
	$('#ok-card-wrap').find('.ok-card').clone().insertAfter('#ok-card-wrap');
	$('#card-setting-tools').remove(); 	 
	$('#ok-card-wrap').contents().unwrap();
});
//Delete Card
$(document).on('click', '#delete-card', function() {
	$('#ok-card-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
	//Add Card inside slider if empty box
	$('.swiper-wrapper').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<div class="swiper-slide card ok-card no-bdr no-bg rounded border bdr-j border-1">'
            +' <div class="card-body p-20 text-center">'
			+' 	<img src="'+domainName+'/assets/img/3-people.jpg" class="w-100 ok-image mt-0 mb-20" alt="">'
			+'	<p class="ok-text font-b lh-base fs-18 mt-15 mb-20 color-k">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut id magna in libero molestie gravida.</p>'
            +' </div>'
            +'</div>'
			+'');
		} 
	});
});

//Container Settings
$(document).on('click', '#container-setting-menu', function() {
	//Remove First
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').removeClass('ok-border');
	$('#container-setting-tools').hide();
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
	
//Container Setting Panel
let containerPanel = [];
containerPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="section-setting-header">Container Settings</span>
		<span id="close-panel" class="card-setting-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Gap -->
			<div class="gap-control-panel">
			<div class="setting-title">
				<p>Gap</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Gap = <span class="ele-gap-count">0</span></p>
								<input class="ele-gap" type="range" min="0" max="5" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Gap -->
			<!-- ::START:: Responsive flex Wrapping -->	
			<div id="responsive-flex-wrap" class="element-setting-wrap">
			<div class="ok-responsive-flex-script setting-title">
				<p>Wrap Elements</p>
			</div>
			<div class="settings">
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Default Wrapping</p>
					<p class="float-right d-inline"><span class="default-wrap-count">No Wrapping</span></p>
					<input class="default-wrap res-range-input" type="range" min="1" max="2">
				</div>
					<hr>
					<p class="d-inline">Responsive Wrapping</p>
					<hr>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Large Desktop</p>
					<p class="float-right d-inline"><span class="desk-xxl-wrap-count">No Wrapping</span></p>
					<input class="desk-xxl-wrap res-range-input" type="range" min="1" max="2">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Medium Desktop</p>
					<p class="float-right d-inline"><span class="desk-xl-wrap-count">No Wrapping</span></p>
					<input class="desk-xl-wrap res-range-input" type="range" min="1" max="2">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Tablet landscape</p>
					<p class="float-right d-inline"><span class="desk-lg-wrap-count">No Wrapping</span></p>
					<input class="desk-lg-wrap res-range-input" type="range" min="1" max="2">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Tablet Portrait</p>
					<p class="float-right d-inline"><span class="tab-md-wrap-count">No Wrapping</span></p>
					<input class="tab-md-wrap res-range-input" type="range" min="1" max="2">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Mobile Landscape</p>
					<p class="float-right d-inline"><span class="mob-sm-wrap-count">No Wrapping</span></p>
					<input class="mob-sm-wrap res-range-input" type="range" min="1" max="2">
				</div>
				<div class="clear-both slider-container respo-alt-slider">
					<p class="d-inline">Mobile Portrait</p>
					<p class="float-right d-inline"><span class="xsm-mob-wrap-count">No Wrapping</span></p>
					<input class="xsm-mob-wrap res-range-input" type="range" min="1" max="2">
				</div>
			</div>
			</div><!-- ::END:: Responsive flex Wrapping -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = containerPanel.join("");

// Get Default Gap
if($('#ok-group-container-wrap .ok-group-container').hasClass('gap-1')){
	$(".ele-gap-count").text('1');
	$(".ele-gap").val('1');
}else if($('#ok-group-container-wrap .ok-group-container').hasClass('gap-2')){
	$(".ele-gap-count").text('2');
	$(".ele-gap").val('2');
}else if($('#ok-group-container-wrap .ok-group-container').hasClass('gap-3')){
	$(".ele-gap-count").text('3');
	$(".ele-gap").val('3');
}else if($('#ok-group-container-wrap .ok-group-container').hasClass('gap-4')){
	$(".ele-gap-count").text('4');
	$(".ele-gap").val('4');
}else if($('#ok-group-container-wrap .ok-group-container').hasClass('gap-5')){
	$(".ele-gap-count").text('5');
	$(".ele-gap").val('5');
}else{
	$(".ele-gap-count").text('0');
	$(".ele-gap").val('0');
}
//:: Container Gap
let containerGap = document.querySelector(".ele-gap");
containerGap.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");
	if (this.value == 0) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");    
		$(".ele-gap-count").text('0');
    } else if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");
        $('#ok-group-container-wrap .ok-group-container').addClass("gap-1");
		$(".ele-gap-count").text('1');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");
        $('#ok-group-container-wrap .ok-group-container').addClass("gap-2");     
		$(".ele-gap-count").text('2');
    } else if (this.value == 3) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");
        $('#ok-group-container-wrap .ok-group-container').addClass("gap-3");      
		$(".ele-gap-count").text('3');
    } else if (this.value == 4) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");
        $('#ok-group-container-wrap .ok-group-container').addClass("gap-4");      
		$(".ele-gap-count").text('4');
    } else if (this.value == 5) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("gap-1 gap-2 gap-3 gap-4 gap-5");
        $('#ok-group-container-wrap .ok-group-container').addClass("gap-5");
		$(".ele-gap-count").text('5');
    }
}
//Get Default Wrapping Values
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-wrap')){
	$(".default-wrap-count").text('Wrapping');
	$(".default-wrap").val('2');
}else{
	$(".default-wrap-count").text('No Wrapping');
	$(".default-wrap").val('1');
}
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-xxl-wrap')){
	$(".desk-xxl-wrap-count").text('Wrapping');
	$(".desk-xxl-wrap").val('2');
}else{
	$(".desk-xxl-wrap-count").text('No Wrapping');
	$(".desk-xxl-wrap").val('1');
}
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-xl-wrap')){
	$(".desk-xl-wrap-count").text('Wrapping');
	$(".desk-xl-wrap").val('2');
}else{
	$(".desk-xl-wrap-count").text('No Wrapping');
	$(".desk-xl-wrap").val('1');
}
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-lg-wrap')){
	$(".desk-lg-wrap-count").text('Wrapping');
	$(".desk-lg-wrap").val('2');
}else{
	$(".desk-lg-wrap-count").text('No Wrapping');
	$(".desk-lg-wrap").val('1');
}
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-md-wrap')){
	$(".tab-md-wrap-count").text('Wrapping');
	$(".tab-md-wrap").val('2');
}else{
	$(".tab-md-wrap-count").text('No Wrapping');
	$(".tab-md-wrap").val('1');
}
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-sm-wrap')){
	$(".mob-sm-wrap-count").text('Wrapping');
	$(".mob-sm-wrap").val('2');
}else{
	$(".mob-sm-wrap-count").text('No Wrapping');
	$(".mob-sm-wrap").val('1');
}
if($('#ok-group-container-wrap .ok-group-container').hasClass('flex-xs-wrap')){
	$(".xsm-mob-wrap-count").text('Wrapping');
	$(".xsm-mob-wrap").val('2');
}else{
	$(".xsm-mob-wrap-count").text('No Wrapping');
	$(".xsm-mob-wrap").val('1');
}
//Flex Wrapping
let defaultFlex = document.querySelector(".default-wrap");
defaultFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xxl-wrap flex-xxl-nowrap flex-xl-wrap flex-xl-nowrap flex-lg-wrap flex-lg-nowrap flex-md-wrap flex-md-nowrap flex-sm-wrap flex-sm-nowrap flex-xs-wrap flex-xs-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xxl-wrap flex-xxl-nowrap flex-xl-wrap flex-xl-nowrap flex-lg-wrap flex-lg-nowrap flex-md-wrap flex-md-nowrap flex-sm-wrap flex-sm-nowrap flex-xs-wrap flex-xs-nowrap");   
		//$('#ok-group-container-wrap .ok-group-container').addClass("flex-nowrap");
		$(".default-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xxl-wrap flex-xxl-nowrap flex-xl-wrap flex-xl-nowrap flex-lg-wrap flex-lg-nowrap flex-md-wrap flex-md-nowrap flex-sm-wrap flex-sm-nowrap flex-xs-wrap flex-xs-nowrap");
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-wrap");
		$(".default-wrap-count").text('Wrapping');
    }
}
let xxlFlex = document.querySelector(".desk-xxl-wrap");
xxlFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xxl-wrap flex-xxl-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xxl-wrap flex-xxl-nowrap");  
		$('#ok-group-container-wrap .ok-group-container').addClass("flex-xxl-nowrap");
		$(".desk-xxl-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xxl-wrap flex-xxl-nowrap"); 
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-xxl-wrap");
		$(".desk-xxl-wrap-count").text('Wrapping');
    }
}
let xlFlex = document.querySelector(".desk-xl-wrap");
xlFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xl-wrap flex-xl-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xl-wrap flex-xl-nowrap");  
		$('#ok-group-container-wrap .ok-group-container').addClass("flex-xl-nowrap");
		$(".desk-xl-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xl-wrap flex-xl-nowrap"); 
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-xl-wrap");
		$(".desk-xl-wrap-count").text('Wrapping');
    }
}
let lgFlex = document.querySelector(".desk-lg-wrap");
lgFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-lg-wrap flex-lg-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-lg-wrap flex-lg-nowrap");  
		$('#ok-group-container-wrap .ok-group-container').addClass("flex-lg-nowrap");
		$(".desk-lg-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-lg-wrap flex-lg-nowrap"); 
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-lg-wrap");
		$(".desk-lg-wrap-count").text('Wrapping');
    }
}
let mdFlex = document.querySelector(".tab-md-wrap");
mdFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-md-wrap flex-md-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-md-wrap flex-md-nowrap");  
		$('#ok-group-container-wrap .ok-group-container').addClass("flex-md-nowrap");
		$(".tab-md-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-md-wrap flex-md-nowrap"); 
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-md-wrap");
		$(".tab-md-wrap-count").text('Wrapping');
    }
}
let smFlex = document.querySelector(".mob-sm-wrap");
smFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-sm-wrap flex-sm-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-sm-wrap flex-sm-nowrap");  
		$('#ok-group-container-wrap .ok-group-container').addClass("flex-sm-nowrap");
		$(".mob-sm-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-sm-wrap flex-sm-nowrap"); 
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-sm-wrap");
		$(".mob-sm-wrap-count").text('Wrapping');
    }
}
let xsFlex = document.querySelector(".xsm-mob-wrap");
xsFlex.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xs-wrap flex-xs-nowrap");
	if (this.value == 1) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xs-wrap flex-xs-nowrap");  
		$('#ok-group-container-wrap .ok-group-container').addClass("flex-xs-nowrap");
		$(".xsm-mob-wrap-count").text('No Wrapping');
    } else if (this.value == 2) {
		$('#ok-group-container-wrap .ok-group-container').removeClass("flex-wrap flex-nowrap flex-xs-wrap flex-xs-nowrap"); 
        $('#ok-group-container-wrap .ok-group-container').addClass("flex-xs-wrap");
		$(".xsm-mob-wrap-count").text('Wrapping');
    }
}
});//END:: Container settings

//Duplicate Container
$(document).on('click', '#duplicate-container', function(e) {
	e.preventDefault();
	$('#ok-group-container-wrap').find('.ok-group-container').clone().insertAfter('#ok-group-container-wrap');
	$('#container-setting-tools').remove(); 	 
	$('#ok-group-container-wrap').contents().unwrap();
});
//Copy Container
$(document).on('click', '#copy-container', function(){
	$('#copy-db').html($('#ok-group-container-wrap').html());
	$('#copy-db').find('.ok-group-container').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			background: #4E342E!important;
			color: #ffffff!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: inline-block!important;}</style>');
	}
});
//Delete Container
$(document).on('click', '#delete-container', function() {
	$('#ok-group-container-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});

//START:: Text
$(document).on("mouseenter", '#body-data .ok-text', function(e) {
	e.stopImmediatePropagation();
	//First Removes Text Edit Settings
	$('.null-section').addClass('ok-section');
	$('.ok-section').removeClass('null-section');
	$('.null-text').addClass('ok-text');
	$('.ok-text').removeClass('null-text');
	$('.ok-text').removeAttr('contenteditable');
	
	//Edit Text
	$(this).attr('data-placeholder', 'Type Something');
	$(this).attr('contenteditable', 'true');
	//Clear format text from clipboard script
	$('[contenteditable]').on('paste', function (e) {
		e.preventDefault();
		e.stopImmediatePropagation();
		let clearInlineText = event.clipboardData.getData('text/plain');
		document.execCommand('inserttext', false, clearInlineText);
	});
	
	//First Removes Dynamic Elements If Exist
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	
//Then Add Dynamic Element
if($(this).hasClass('ok-line')){
	$(this).wrap('<div id="ok-text-wrap" class="ok-selector-line ok-border" style="width: auto!important"></div>');
}else {
	$(this).wrap('<div id="ok-text-wrap" class="ok-selector-block ok-border" style="width: auto!important"></div>');
}
//On Hover show Text Tool
if($(this).hasClass('ok-btntext')){
	$('#ok-text-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div id="text-setting-menu" title="Text Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		</div>
	`);
}else{
	$('#ok-text-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="text-setting-menu" title="Text Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="duplicate-text" title="Duplicate Text" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
			<div id="copy-text" title="Copy Text" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-text" title="Delete Text" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}
});

//Text edit
$(document).on('input', '.ok-text', function(e) {
    e.preventDefault();
	$(this).focus();
	if($(this).html().trim() === '<br>'){
		$(this).find("br").remove();
	}
	$(this).find("div").contents().unwrap();
});
//Delete Text
$(document).on('click', '#delete-text', function() { 
	$('#ok-text-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});

//Duplicate Text
$(document).on('click', '#duplicate-text', function(e) {
	e.preventDefault();
	if($('#ok-text-wrap').parent().hasClass('ok-text-li')){
		$('#ok-text-wrap').parent().clone().insertAfter($('#ok-text-wrap').parent());
	}else{
		$('#ok-text-wrap').find('.ok-text').clone().insertAfter('#ok-text-wrap');
	}
	$('#setting-tools').remove();
	$('#ok-text-wrap').contents().unwrap();
});

//Copy Text
$(document).on('click', '#copy-text', function(){
	$('#copy-db').html($('#ok-text-wrap').html());
	$('#copy-db').find('.ok-text').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			background: #6200EA!important;
			color: #ffffff!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: inline-block!important;}</style>');
	}
});

//Text Setting	
$(document).on('click', '#text-setting-menu', function() {
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#setting-tools').remove();
	$('#ok-text-wrap').removeClass('ok-border');
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
	
//Text Setting Panel
let textPanel = [];
textPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="setting-header">Text Settings</span>
		<span id="close-panel" class="text-setting-close-btn float-right d-cursor white"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Text Input -->
			<div class="setting-title">
				<p>Edit Text</p>
			</div>
			<div class="settings">
				<div class="main-text-tools">
					<button class="button bold" title="Bold"><strong>B</strong></button>
					<button class="button italic" title="Italic"><em>I</em></button>
					<button class="button superscript" title="Superscript">X<sup>2</sup></button>
					<button class="button text-color" title="Text Color"><i class="fas fa-tint"></i></button>
					<button class="button add-url" title="Insert Link" data-role="createLink"><i class="fas fa-link"></i></button>
					<button class="button underline" title="Underline"><u>U</u></button>
					<button class="button strikethrough" title="Strikethrough"><strike>S</strike></button>
					<button class="button subscript" title="Subscript">X<sub>2</sub></button>
					<button class="button text-bgcolor" title="Background Color"><i class="fas fa-fill-drip"></i></button>
					<button class="button unlink" title="Remove Link"><i class="fas fa-unlink"></i></button>
				</div>
				<div id="main-textinput-field" spellcheck="false" contenteditable="true"></div>
			</div><!-- ::END:: Text Input -->
			<!-- ::START:: Text Typography -->
			<div class="typography-control-panel">
			<div class="setting-title">
				<p>Text Typography</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<p>Font Style</p>
							<select class="select-font-style ok-select-opt">
								<option value="">Default</option>
								<option value="font-a">Font A</option>
								<option value="font-b">Font B</option>
							</select>
						</td>
						<td width="50%">
							<p>Font Weight</p>
							<select class="select-font-weight ok-select-opt">
								<option value="">Default</option>
								<option value="fw-normal">Normal</option>
								<option value="fw-bold">Bold</option>
								<option value="fw-bolder">Bolder</option>
								<option value="fw-lighter">Lighter</option>
								<option value="fw-100">100</option>
								<option value="fw-200">200</option>
								<option value="fw-300">300</option>
								<option value="fw-400">400</option>
								<option value="fw-500">500</option>
								<option value="fw-600">600</option>
								<option value="fw-700">700</option>
								<option value="fw-800">800</option>
								<option value="fw-900">900</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<hr>
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Font size = <span class="ele-fs-count">0</span></p>
								<input class="ele-fs" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Line Height = <span class="ele-lh-count">0</span></p>
								<input class="ele-lh" type="range" min="1" max="5" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Text Typography -->
			<!-- ::START:: Text Alignment and Transform -->
			<div class="alignment-control-panel">
			<div class="setting-title">
				<p>Alignment & Transform</p>
			</div>
			<div class="settings">
				<p>Text Alignment</p>
				<div class="button-25-wrap">
					<button class="main-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="main-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="main-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
				<p>Text Transform</p>
				<div class="button-25-wrap">
					<button class="main-case-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-capital-case button button-25" title="Capitalize">
						Aa
					</button>
					<button class="main-upper-case button-25" title="Uppercase">
						AA
					</button>
					<button class="main-lower-case button-25" title="Lowercase">
						aa
					</button>
				</div>
			</div>
			</div><!-- ::END:: Text Alignment and Transform -->	
			<!-- ::START:: Text Color -->
			<div class="color-control-panel">
			<div class="setting-title">
				<p>Text Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Select Color</p>
							<button class="main-color-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-color-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-color-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-color-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-color-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-color-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-color-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-color-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-color-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-color-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-color-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-color-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Hover Color</p>
							<button class="main-hocolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hocolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hocolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hocolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hocolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hocolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hocolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hocolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hocolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hocolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hocolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hocolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Text Color -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = textPanel.join("");
	
	//Add Text From Main Text Input Field
	$('#main-textinput-field').html($('#ok-text-wrap').find('.ok-text, .ok-link-text').html());
	
	$('#main-textinput-field').on('input', function(e) {
		e.stopImmediatePropagation();
		e.preventDefault();
		if($('#main-textinput-field').html().trim() === '<br>'){
			$('#main-textinput-field').find("br").remove();
		}
		$('#ok-text-wrap').find('.ok-text, .ok-link-text').html($(this).html());
	}); 

	//Clear format text from clipboard script
	$('[contenteditable]').on('paste', function (e) {
		e.preventDefault();
		e.stopImmediatePropagation();
		let clearText = event.clipboardData.getData('text/plain');
		document.execCommand('inserttext', false, clearText);
	});

	/*//Add br tag instead of div tag on pressing Enter key	
	document.addEventListener('keydown', event => {
		if (event.key === 'Enter') {
		document.execCommand('insertLineBreak');
		event.preventDefault()
		}
	});*/
	
	$('div[contenteditable="true"]').keypress(function(event) {
		$(this).trigger('input');
		if (event.which != 13)
			return true;
		let docFragment = document.createDocumentFragment();
		//add a new line
		let newEle = document.createTextNode('\n');
		docFragment.appendChild(newEle);
		//add the br, or p, or something else
		newEle = document.createElement('br');
		docFragment.appendChild(newEle);
		//make the br replace selection
		let rangesTxt = window.getSelection().getRangeAt(0);
		rangesTxt.deleteContents();
		rangesTxt.insertNode(docFragment);
		//create a new range
		rangesTxt = document.createRange();
		rangesTxt.setStartAfter(newEle);
		rangesTxt.collapse(true);
		//make the cursor there
		let selTxt = window.getSelection();
		selTxt.removeAllRanges();
		selTxt.addRange(rangesTxt);
		return false;
	});
	// Inner Block Text Editor Tools
	$("button.bold").on("click",function(){
        document.execCommand('bold',false,true);
	});
	$("button.italic").on("click",function(){
        document.execCommand('italic',false,true);
	});
    $("button.underline").on("click",function(){
        document.execCommand('underline',false,true);
    });
    $("button.unlink").on("click",function(){
        document.execCommand('unlink',false,true);
    });
    $("button.strikethrough").on("click",function(){
        document.execCommand('strikethrough',false,true);
    });
    $("button.subscript").on("click",function(){
        document.execCommand('subscript',false,true);
    });
    $("button.superscript").on("click",function(){
        document.execCommand('superscript',false,true);
    });	
	//ADD Text Color
	$('.text-color').spectrum({
		color: '#333333',
		containerClassName: 'color-box',
		showInput: false,
		showPalette: false,
		showInitial: false,
		showButtons: true,
		showAlpha: false,
		//cancelText: ,
		chooseText: 'Apply',
		preferredFormat: "rgb",
		palette: [
				['black', 'white', 'blanchedalmond',
				'rgb(255, 128, 0);', 'hsv 100 70 50'],
				['red', 'yellow', 'green', 'blue', 'violet']
			],
		change: function(color) {
			color = color.toRgbString();
			document.execCommand('foreColor', false, color);
			//$("#text-temp-wrap").find(".ok-is-text").addClass("custom-color");
		}
	});
	//ADD Text BG Color
	$('.text-bgcolor').spectrum({
		color: '#333333',
		containerClassName: 'color-box',
		showInput: false,
		showPalette: false,
		showInitial: false,
		showButtons: true,
		showAlpha: false,
		//cancelText: ,
		chooseText: 'Apply',
		preferredFormat: "rgb",
		palette: [
				['black', 'white', 'blanchedalmond',
				'rgb(255, 128, 0);', 'hsv 100 70 50'],
				['red', 'yellow', 'green', 'blue', 'violet']
			],
		change: function(color) {
			color = color.toRgbString();
			document.execCommand('backColor', false, color);
			//$("#text-temp-wrap").find(".ok-is-text").addClass("custom-color");
		}
	});
});//END:: Add dynamic Text Element

//START:: Add dynamic IMAGE Element
$(document).on("mouseenter", '#body-data .ok-link-image', function(e) {
	e.stopImmediatePropagation();
	//First Removes Dynamic Elements If Exist	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	
//Then Add Dynamic Elements	
if($(this).hasClass('ok-line')){
	$(this).wrap('<div id="ok-img-wrap" class="ok-selector-line ok-border" style="display:inline!important;"></div>');
}else if($(this).find('img').hasClass('w-100')){
	$(this).wrap('<div id="ok-img-wrap" class="ok-selector-block ok-border"></div>');
}else{
	$(this).wrap('<div id="ok-img-wrap" class="ok-selector-line ok-border" style="display:inline!important;"></div>');
}
//On Hover show Image Tool
if($(this).hasClass('ok-logo')){
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu brand-logo" dir="ltr">
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		</div>
	`);	
}else if($(this).find('img').hasClass('image-string')){
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="lni lni-move"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div title="Crop Image" class="image-cropping setting-menu-btn"><i class="fas fa-crop"></i></div>
			<div id="duplicate-image" title="Duplicate Image" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
			<div id="copy-image" title="Copy Image" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}else if($(this).find('img').hasClass('ok-top-card-image')){
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}else{
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="lni lni-move"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="duplicate-image" title="Duplicate Image" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
			<div id="copy-image" title="Copy Image" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}
});

$(document).on("mouseenter", '#body-data .ok-image', function(e) {
	e.stopImmediatePropagation();
	//First Removes Dynamic Elements If Exist	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();

//Then Add Dynamic Element
if($(this).hasClass('ok-line')){
	$(this).wrap('<div id="ok-img-wrap" class="ok-selector-line ok-border" style="display:inline!important;"></div>');
}else if($(this).hasClass('w-100')){
	$(this).wrap('<div id="ok-img-wrap" class="ok-selector-block ok-border"></div>');
}else {
	$(this).wrap('<div id="ok-img-wrap" class="ok-selector-line ok-border" style="display:inline!important;"></div>');
}
//On Hover show Image Tool
if($(this).hasClass('ok-lightbox')){
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);
}else if($(this).hasClass('image-string')){
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div title="Crop Image" class="image-cropping setting-menu-btn"><i class="fas fa-crop"></i></div>
			<div id="duplicate-image" title="Duplicate Image" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
			<div id="copy-image" title="Copy Image" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}else if($(this).hasClass('ok-top-card-image')){
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}else{
	$('#ok-img-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="image-setting-menu" title="Image Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="duplicate-image" title="Duplicate Image" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
			<div id="copy-image" title="Copy Image" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-image" title="Delete Image" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}

//For lightbox images
if($(this).hasClass('ok-lightbox')){
	$('#image-lightbox-link').show();
	$('#desk-img-input').hide();	
}
});

//Copy Image
$(document).on('click', '#copy-image', function(){
	$('#copy-db').html($('#ok-img-wrap').html());
	$('#copy-db').find('.ok-image').addClass('copyed');
	$('#copy-db').find('.ok-link-image').removeAttr('data-description data-type data-height data-zoomable').removeClass('glightbox').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');	
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			background: #6200EA!important;
			color: #ffffff!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: inline-block!important;}</style>');
	}
});

//Delete Image
$(document).on('click', '#delete-image', function() {
	$('#ok-img-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});

//Duplicate Image
$(document).on('click', '#duplicate-image', function(e) {
	e.preventDefault();
	$('#ok-img-wrap').find('.ok-image, .ok-link-image').clone().insertAfter('#ok-img-wrap');
	$('#setting-tools').remove(); 	 
	$('#ok-img-wrap').contents().unwrap();
});

//Image Setting	
$(document).on('click', '#image-setting-menu', function() {	
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#setting-tools').remove();  	 
	$('#ok-img-wrap').removeClass('ok-border'); 
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
//Image Setting Panel
let imagePanel = [];
imagePanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="image-setting-header">Image Settings</span>
		<span id="close-panel" class="image-setting-close-btn float-right d-cursor white"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Upload Image Setting -->
			<div class="setting-title">
				<p>Upload Image</p>
			</div>	
			<div class="settings">
				<div class="table-box">
					<p class="logob-opt">Add 1st Logo</p>
					<table border="0" width="100%">
						<tr>
							<td width="30%">
								<p>From PC</p>
								<button id="add-content-image" class="upload-image sbgcolor pbghover" title="Upload Image">
									<i class="fas fa-upload"></i>
								</button>
								<form class="hidden-form" method="post" action="okcc/php/image-uploader.php" enctype="multipart/form-data" target="hiddenFrame">
									<input id="new-filename" type="text" name="newfilename">
									<input type="text" name="imguser" value="`+uniqueUser+`">
									<input type="file" name="photo" id="add-main-image" accept=".jpg,.png,.svg,.gif">
									<input id="upload-mainimg" type="submit" name="submit" value="Upload">
								</form>
							</td>
							<td width="70%">
								<p>By URL</p>
								<input class="input-img-url input" type="text" placeholder="Image by URL">
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<img id="content-image-preview" src="" alt="">
								<!-- Submit Form without leaving page -->
								<iframe name="hiddenFrame" id="main-image-iframe" class="image-upload-iframe">
									Loading...
								</iframe>
							</td>
						</tr>
					</table>
					<div id="main-image-dir" style="overflow: auto;width:100%;height:200px;"></div>
					<hr class="logob-opt" />
					<p class="logob-opt">Add 2nd Logo</p>
					<table class="logob-opt" border="0" width="100%">
						<tr>
							<td width="30%">
								<p>From PC</p>
								<button id="add-logob-image" class="upload-image sbgcolor pbghover" title="Upload Image">
									<i class="fas fa-upload"></i>
								</button>
								<form class="hidden-form" method="post" action="okcc/php/image-uploader.php" enctype="multipart/form-data" target="logobFrame">
									<input id="logob-filename" type="text" name="newfilename">
									<input type="text" name="imguser" value="`+uniqueUser+`">
									<input type="file" name="photo" id="add-logob" accept=".jpg,.png,.svg,.gif">
									<input id="upload-logob" type="submit" name="submit" value="Upload">
								</form>
							</td>
							<td width="70%">
								<p>By URL</p>
								<input class="input-logob-url input" type="text" placeholder="Image by URL">
							</td>
						</tr>
					</table>
					<table class="logob-opt" border="0" width="100%">
						<tr>
							<td width="100%">
								<img id="logob-image-preview" src="" alt="">
								<!-- Submit Form without leaving page -->
								<iframe name="logobFrame" id="logob-iframe" class="image-upload-iframe">
									Loading...
								</iframe>
							</td>
						</tr>
					</table>
					<hr class="logob-opt" />
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<p>Alt Text</p>
								<textarea class="input-img-alt input" type="text" placeholder="Enter Alt Text"></textarea>
							</td>
						</tr>
					</table>
				</div>
			</div><!-- ::END:: Upload Image Setting -->	
			<!-- ::START:: Lightbox Link -->
			<div id="image-lightbox-link">
			<div class="setting-title">
				<p>Link</p>
			</div>
			<div class="settings">
				<p>Link Text</p>
				<textarea class="link-text seo-input-style" type="text" placeholder="Edit Text"></textarea>
				<p>Link</p>
				<input class="link-linking input" type="text" placeholder="Link">
				<p>Link Title</p>
				<input class="link-linking-title input mb-10" type="text" placeholder="Title">
			</div>
			</div><!-- ::END:: Lightbox Link -->			
			<!-- ::START:: Image Gallery -->
			<div id="glightbox-desc-opt" class="ok-hide-element">
			<div class="setting-title">
				<p>Image Description</p>
			</div>
			<div class="settings">
				<div class="table-box">
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<textarea class="glightbox-desc-input" type="text" placeholder="Enter Image Description"></textarea>
							</td>
						</tr>
					</table>
				</div>
			</div>
			</div><!-- ::END:: Image Gallery -->
			<!-- ::START:: Image Linking To URL -->
			<div id="image-linking-opt" class="ok-hide-element">
			<div class="setting-title">
				<p>Image Linking To URL</p>
			</div>
			<div class="settings">
				<p>Linking to URL</p>
				<div id="link-switch" class="mb-10">
				<button id="add-imagelink" class="btn white bg-primary">Add</button>
				<button id="remove-imagelink" class="btn white bg-primary">Remove</button>
				</div>
				<div id="link-entery">
				<input class="image-linking input" type="text" placeholder="Linking to URL">
				<p>Link Title</p>
				<input class="image-linking-title input mb-10" type="text" placeholder="Title">
				</div>
			</div>
			</div><!-- ::END:: Image Linking To URL -->
			<!-- ::START:: Image Size -->
			<div id="image-size-wrap">
			<div class="setting-title">
				<p>Image Size</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<select id="image-size" class="ok-select-opt">
								<option value="w-100">Width 100%</option>
								<option value="custom">Custom Width</option>
							</select>							
							<div id="custom-image-width" class="mt-20 slider-container">
								<p>Width = <input class="image-width-value counter" type="number" min="0" max="100" step="1" value="5" oninput="(!validity.rangeOverflow||(value=100)) && (!validity.rangeUnderflow||(value=0)) && (!validity.stepMismatch||(value=parseInt(this.value)));" />%</p>
							<!--<p>Image Position</p>
							<div class="button-25-wrap">
								<button class="image-align-left button-33" title="Left">
									<i class="fas fa-align-left tools-icon"></i>
								</button>
								<button class="image-align-center button-33" title="Center">
									<i class="fas fa-align-center tools-icon"></i>
								</button>
								<button class="image-align-right button-33" title="Right">
									<i class="fas fa-align-right tools-icon"></i>
								</button>
							</div>-->
							</div>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Image Size -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
 document.getElementById("setting-panel").innerHTML = imagePanel.join("");

//Add image from directory
$.ajax({
    url: ''+domainName+'/image-dir.php',
    success: function(html) {
       $("#main-image-dir").append(html);
    }
});
$(document).on("click", "#content-image-preview, #main-image-dir img", function() {
	if($("#ok-img-wrap").find('img').attr('id') == 'logo-a'){
		$("#ok-img-wrap").find('#logo-a').attr("src", $(this).attr("src"));
	}else{
		$("#ok-img-wrap").find('img').attr("src", $(this).attr("src"));
	}
	$("#ok-img-wrap").find('.ok-link-image.glightbox').attr("href", $(this).attr("src"));
});

//For Logo Image
if($('#ok-img-wrap').find('#logo-a').length > 0){
	$('.logob-opt').show();
	$('.margin-control-panel, #image-size-wrap, #link-switch').hide();
}else {
	$('.logob-opt').hide();	
}
//For Card Image
if($('.ok-card #ok-img-wrap:not(.card-body #ok-img-wrap)').length > 0){
	$('.margin-control-panel, #image-size-wrap').hide();
}
//For Video Image
if($('#ok-img-wrap .ok-video-image').length > 0){
	$('#image-linking-opt, .margin-control-panel, #image-size-wrap').hide();
}
//For image linking
if($('#ok-img-wrap').find('.ok-link-image, .ok-image:not(.ok-video-image)').length > 0){
	$('#image-linking-opt').show();	
}
if($('#ok-img-wrap').find('.ok-link-image').length > 0){
	$('#add-imagelink').hide();	
	$('#remove-imagelink').show();
}else{	
	$('#add-imagelink').show();	
	$('#remove-imagelink, #link-entery').hide();
}
//For gLightbox Image gallery
if($('#ok-img-wrap .ok-link-image').hasClass('glightbox')){
	$('#image-linking-opt').hide();	
	$('.margin-control-panel, #image-size-wrap').hide();
	$('#glightbox-desc-opt').show();
}
//For Circular Image
if($('#ok-img-wrap').find('img').hasClass('rounded-circle')){
	$('#image-size-wrap').hide();
}
 
	$('#image-panel-setting').css('display', 'block');
	
	//Collect Default Values from Image Element
	$('#content-image-preview').attr('src', $('#ok-img-wrap').find('img').attr('src'));
	$('#logob-image-preview').attr('src', $('#ok-img-wrap').find('#logo-b').attr('src'));
	$('.image-width').val($('#ok-img-wrap').find('img').width());
	$('.image-height').val($('#ok-img-wrap').find('img').height());
	$('.input-img-alt').val($('#ok-img-wrap').find('img').attr('alt'));
	$('.image-linking').val($('#ok-img-wrap').find('a').attr('href'));
	$('.image-linking-title').val($('#ok-img-wrap').find('a').attr('title'));
	$('.link-text').val($('#ok-img-wrap').find('.ok-lightbox-link').text());
	$('.link-linking').val($('#ok-img-wrap').find('.ok-lightbox-link').attr('href'));
	$('.link-linking-title').val($('#ok-img-wrap').find('.ok-lightbox-link').attr('title'));

	//Collect Default Description
	$(".glightbox-desc-input").val($("#ok-img-wrap").find('.ok-link-image.glightbox').attr('data-description'));
	//Add Image Description
	$(".glightbox-desc-input").on('input', function(){
		$("#ok-img-wrap").find('.ok-link-image.glightbox').attr('data-description', this.value);
	});

	//Add Image from Desktop
	$("#add-content-image").on('click', function(){
		$('#add-main-image').click();
	});
	
	$("#add-main-image").change(function(){
		$("#main-image-iframe").hide();//Hide file upload messages
		$("#add-content-image").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
		let newImgFileName = 'id'+uniqueUser+(new Date()).getTime();//set unique image name
		let ymdHms = document.getElementById("new-filename").value = newImgFileName;
		//Get the file input element by its id 
		var fileInput = document.getElementById('add-main-image');
		//Get the file name
		var fileName = fileInput.files[0].name;
		//Get the file Extension 
		var fileExtension = fileName.split('.').pop();
		$('#upload-mainimg').click();

		$('#main-image-iframe').on('load', function() {	
			if($("#ok-img-wrap").find('img').attr('id') == 'logo-a'){
				$("#ok-img-wrap").find('#logo-a').attr('src', 'assets/img/'+uniqueUser+'/'+ymdHms+'.'+fileExtension);
			}else{
				$("#ok-img-wrap").find('img').attr('src', 'assets/img/'+uniqueUser+'/'+ymdHms+'.'+fileExtension);
			}
			$("#ok-img-wrap").find('img, .ok-link-image.glightbox').addClass('image-string');
			$("#ok-img-wrap").find('.ok-link-image.glightbox').attr('href', 'assets/img/'+uniqueUser+'/'+ymdHms+'.'+fileExtension);
			$('#content-image-preview').attr('src', 'assets/img/'+uniqueUser+'/'+ymdHms+'.'+fileExtension);
			
			if($("#main-image-iframe").contents().find('#sucess-info').length>0){
				$("#add-content-image").html('<i class="fas fa-upload"></i>');
			}
			$("#main-image-iframe").show();//Show file upload messages
		});
	});
	
	
	$(".input-img-url").on("input", function() {
		if($("#ok-img-wrap").find('img').attr('id') == 'logo-a'){
			$("#ok-img-wrap").find('#logo-a').attr('src', this.value);
		}else{
			$("#ok-img-wrap").find('img').attr('src', this.value);			
		}
		$("#ok-img-wrap").find('img, .ok-link-image.glightbox').removeClass('image-string');
		$("#ok-img-wrap").find('.ok-link-image.glightbox').attr('href', this.value);
		$('#content-image-preview').attr('src', this.value);
	});
	
	//Add LogoB from Desktop
	$("#add-logob-image").on('click', function(){
		$('#add-logob').click();
	});
	
	$("#add-logob").change(function(){
		$("#logob-iframe").hide();//Hide file upload messages
		$("#add-logob-image").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
		let logobName = 'id'+uniqueUser+(new Date()).getTime();//set unique image name
		let logobImgId = document.getElementById("logob-filename").value = logobName;
		//Get the file input element by its id 
		var logobfileInput = document.getElementById('add-logob');
		//Get the file name
		var logobFileName = logobfileInput.files[0].name;
		//Get the file Extension 
		var logobFileExtension = logobFileName.split('.').pop();
		$('#upload-logob').click();

		$('#logob-iframe').on('load', function() {
			$("#ok-img-wrap").find('#logo-b').attr('src', 'assets/img/'+uniqueUser+'/'+logobImgId+'.'+logobFileExtension);
			$("#ok-img-wrap").find('#logo-b').addClass('image-string');
			$('#logob-image-preview').attr('src', 'assets/img/'+uniqueUser+'/'+logobImgId+'.'+logobFileExtension);			
			if($("#logob-iframe").contents().find('#sucess-info').length>0){
				$("#add-logob-image").html('<i class="fas fa-upload"></i>');
			}
			$("#logob-iframe").show();//Show file upload messages
		});
	});
	
	$(".input-logob-url").on("input", function() {
		$("#ok-img-wrap").find('#logo-b').removeClass('image-string');
		$("#ok-img-wrap").find('#logo-b').attr('src', this.value);
		$('#logob-image-preview').attr('src', this.value);
	});
	//Add Image Alt Text
	$("#add-img-alt").on("click", function() {
		$(".image-alt-wrap").toggleClass("active-image-alt");
	});
	$(".input-img-alt").on("input", function() {
		$("#ok-img-wrap").find('img').attr('alt', this.value);
	});
	//Add Link
	$(document).on('click', '#add-imagelink', function(e){
		e.stopImmediatePropagation();
		$(this).hide();
		$('#link-entery').show();
		$('#remove-imagelink').show();
		$("#ok-img-wrap").find('img').removeClass('ok-image');
		$("#ok-img-wrap").find('img').wrap('<a href="" class="ok-link-image"></a>');
	});
	//Remove Link
	$(document).on('click', '#remove-imagelink', function(){
		$(this).hide();
		$('#link-entery').hide();
		$('#add-imagelink').show();
		$("#ok-img-wrap").find('img').addClass('ok-image');
		$("#ok-img-wrap").find('a').contents().unwrap();
		$('.image-linking, .image-linking-title').val('');
	});
	//Image Linking
	$(".image-linking").on("input", function() {
		$("#ok-img-wrap").find('a').attr('href', this.value);
	});	
	$(".image-linking-title").on("input", function() {
		$("#ok-img-wrap").find('a').attr('title', this.value);
	});	
	//Image Width/Height
	$(".full-width").on("click", function() {
		$("#ok-img-wrap").find('img').css('width', '100%');
		$("#ok-img-wrap").find('img').css('height', '');
		$('.image-width').val($('#ok-img-wrap').find('img').width());
		$('.image-height').val($('#ok-img-wrap').find('img').height());
	});	
	$(".image-width").on("input", function() {
		$("#ok-img-wrap").find('img').css('width', this.value + 'px');
	});	
	$(".image-height").on("input", function() {
		$("#ok-img-wrap").find('img').css('height', this.value + 'px');
	});	
	
	//Link Text
	$(".link-text").on("input", function() {
		$('#ok-img-wrap').find('.ok-lightbox-link').text(this.value);
	});	
	//Link
	$(".link-linking").on("input", function() {
		$('#ok-img-wrap').find('.ok-lightbox-link').attr('href', this.value);
	});	
	//Title
	$(".link-linking-title").on("input", function() {
		$('#ok-img-wrap').find('.ok-lightbox-link').attr('title', this.value);
	});	
	
//For Logo Image
if($('#ok-img-wrap').find('img.w-100').length > 0){
	$("#image-size option[value=w-100]").attr('selected','selected');
	$('#custom-image-width').hide();
}else {
	$("#image-size option[value=custom]").attr('selected','selected');
	$('#custom-image-width').show();
}	
//Image Width switch
$(document).on('change', '#image-size', function() {
	if($(this).val()==="w-100"){ 
		$('#custom-image-width').hide();
		$('#ok-img-wrap').find('img').addClass('w-100');
		$('#ok-img-wrap').find('img').removeAttr("width");
    } else {  
		$('#custom-image-width').show();
		$('#ok-img-wrap').find('img').removeClass('w-100').attr('width', '100%');
    }
});
//Image Width
$(document).on('input', '.image-width-value', function() {
	$('#ok-img-wrap').find('img').removeClass('w-100').attr("width", this.value +'%');
});
/*
//Check Image Position
if($('#ok-img-wrap').find('img').hasClass('mx-auto')){
	$('.image-align-center').addClass('bg-primary');
}else if($('#ok-img-wrap').find('img').hasClass('float-end')){
	$('.image-align-right').addClass('bg-primary');
}else{
	$('.image-align-left').addClass('bg-primary');
}
//Image Position
$(document).on('click', '.image-align-left', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-img-wrap').find('img').removeClass('float-start mx-auto d-block float-end');
	$('#ok-img-wrap').find('img').addClass('float-start');
});
$(document).on('click', '.image-align-center', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-img-wrap').find('img').removeClass('float-start mx-auto d-block float-end');
	$('#ok-img-wrap').find('img').addClass('mx-auto d-block');
});
$(document).on('click', '.image-align-right', function() {
	$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
    $('#ok-img-wrap').find('img').removeClass('float-start mx-auto d-block float-end');
	$('#ok-img-wrap').find('img').addClass('float-end');
});*/

});//END:: Add dynamic IMAGE Element

//START:: Add dynamic BG Image Element
$(document).on('dblclick', '#body-data .ok-bgimage', function(e) {
	e.stopImmediatePropagation();
	//Remove Wrapper if exist
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#bgimage-preview').attr('src', ''); 
	//First Removes Dynamic Elements If Exist	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	
	//Then Add	
	$(this).wrap('<div id="bgimg-temp-wrap"></div>');
//BG Image Setting Panel
let bgImgPanel = [];
bgImgPanel.push(`
<div id="bgimage-draggable" class="dragme-panel" dir="ltr">
	<div id="bgimage-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="image-setting-header">BG Image Settings</span>
		<span id="close-panel" class="bgimage-setting-close-btn float-right d-cursor white"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Upload BG Image Setting -->
			<div class="setting-title">
				<p>Upload BG Image</p>
			</div>	
			<div class="settings">
				<div class="table-box">
					<table border="0" width="100%">
						<tr>
							<td width="30%">
								<p>From PC</p>
								<button id="add-bgimage-alt" class="upload-image sbgcolor pbghover" title="Upload Image">
									<i class="fas fa-upload"></i>
								</button>
								<input type="file" id="add-bgimage" accept=".jpg,.png,.svg,.gif">
							</td>
							<td width="70%">
								<p>By URL</p>
								<input class="bg-img-url input" type="text" placeholder="Image by URL">
							</td>
						</tr>
					</table>
					<table border="0" width="100%">
						<tr>
							<td width="100%">
								<img id="bgimage-preview" src="" alt="">
							</td>
						</tr>
					</table>
				</div>
			</div><!-- ::END:: Upload BG Image Setting -->	
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = bgImgPanel.join("");

//Get and Set Image Preview
$('#bgimage-preview').attr('src', $('#bgimg-temp-wrap').find('.ok-inner-image').attr('src'));
	//Add BG Image from Desktop
	$("#add-bgimage-alt").on('click', function(){
		$('#add-bgimage').click();
	});
	$("#add-bgimage").change(function(){
        if (this.files && this.files[0]) {
            let bgImgReader = new FileReader();            
            bgImgReader.onload = function (e) {
				$("#bgimg-temp-wrap").find('.ok-inner-image').attr('src', e.target.result);
				$('#bgimage-preview').attr('src', e.target.result);
            }
            bgImgReader.readAsDataURL(this.files[0]);
        }
	});
	//Add BG Image from URL	
	$(document).on("input", ".bg-img-url", function() {
		$('#bgimg-temp-wrap').find('.ok-inner-image').attr('src', this.value); 
		$('#bgimage-preview').attr('src', this.value); 
	});

	//Make the BG Image Setting Panel draggagle:
    dragElement(document.getElementById("bgimage-draggable"));
    
    function dragElement(elmnt) {
      let bgpos1 = 0, bgpos2 = 0, bgpos3 = 0, bgpos4 = 0;
      if (document.getElementById(elmnt.id + "header")) {
        /* if present, the header is where you move the DIV from:*/
        document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
      } else {
        /* otherwise, move the DIV from anywhere inside the DIV:*/
        elmnt.onmousedown = dragMouseDown;
      }
    
      function dragMouseDown(e) {
        e = e || window.event;
        e.preventDefault();
        // get the mouse cursor position at startup:
        bgpos3 = e.clientX;
        bgpos4 = e.clientY;
        document.onmouseup = closeDragElement;
        // call a function whenever the cursor moves:
        document.onmousemove = elementDrag;
      }
    
      function elementDrag(e) {
        e = e || window.event;
        e.preventDefault();
        let winWbg = document.documentElement.clientWidth || document.body.clientWidth,
            winHbg = document.documentElement.clientHeight || document.body.clientHeight;
        let maxXbg = winWbg - elmnt.offsetWidth - 1,
            maxYbg = winHbg - elmnt.offsetHeight - 1;
        // calculate the new cursor position:
        bgpos1 = bgpos3 - e.clientX;
        bgpos2 = bgpos4 - e.clientY;
        bgpos3 = e.clientX;
        bgpos4 = e.clientY;
        // set the element's new position:
        //console.log((elmnt.offsetLeft - bgpos1), maxYbg, (elmnt.offsetLeft - bgpos1), maxXbg);
        if((elmnt.offsetTop - bgpos2) <= maxYbg && (elmnt.offsetTop - bgpos2) >= 0){
          elmnt.style.top = (elmnt.offsetTop - bgpos2) + "px";
        }
        if((elmnt.offsetLeft - bgpos1) <= maxXbg && (elmnt.offsetLeft - bgpos1) >= 0){
          elmnt.style.left = (elmnt.offsetLeft - bgpos1) + "px";
        }
      }
    
      function closeDragElement() {
        /* stop moving when mouse button is released:*/
        document.onmouseup = null;
        document.onmousemove = null;
      }
    }
$('.draggable-content').find('.setting-title').click(function(){
	$('.setting-title').removeClass("blue");
	$(this).toggleClass("blue");
	//Expand or collapse this panel
	$(this).next().show();	
	//Hide the other panels
	$(".settings").not($(this).next()).slideUp();
	$(".setting-title").animate({ scrollTop: 0 }, "fast");//:::SCROLL TO TOP
});
		
//Active BG Image Setting Panel		
$('#bgimage-draggable').css('display', 'block'); 
$('#bgimage-panel').addClass('active-panel');	
	//Close BG Image Setting
	$(".bgimage-setting-close-btn").on('click', function() {
		$('#bgimage-panel').removeClass('active-panel');  
		$('#bgimage-draggable').css('display', 'none');
		$('#bgimg-temp-wrap').contents().unwrap();	
	});
});//START:: Add dynamic BG Image Element

//START:: Add dynamic Anchor Element
$(document).on("mouseenter", '#body-data .ok-link', function(e) {
	e.stopImmediatePropagation();
	//First Removes Dynamic Elements If Exist	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();

//Then Add Dynamic Element
if($(this).hasClass('ok-line')){
	$(this).wrap('<div id="ok-link-wrap" class="ok-selector-line ok-border" style="width: auto!important"></div>');
}else if($(this).hasClass('ok-only-icon')){
	$(this).wrap('<div id="ok-link-wrap" class="ok-border" style="position: fixed!important; left: 95%!important; top: 95%!important"></div>');
}else {
	$(this).wrap('<div id="ok-link-wrap" class="ok-selector-block ok-border w-100" style="width: auto!important"></div>');
}


//On Hover show Image Tool
if($(this).hasClass('ok-temp-show-deleted-elements') || $('#ok-link-wrap').parent().hasClass('ok-temp-show-deleted-elements')){
	$('#ok-link-wrap').prepend(`
		<div id="setting-tools" class="setting-menu restore-btn" dir="ltr">
			<div id="restore-link" title="Restore Element" class="setting-menu-btn"><i class="fas fa-undo"></i></div>
		</div>
	`);
}else if($(this).hasClass('ok-only-icon')){
	$('#ok-link-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div id="link-setting-menu" title="Link Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
		</div>
	`);
}else{
	$('#ok-link-wrap').prepend(`
		<div id="setting-tools" class="setting-menu" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="link-setting-menu" title="Link Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="duplicate-link" title="Duplicate Element" class="duplicate-btn setting-menu-btn"><i class="fas fa-clone"></i></div>
			<div id="copy-link" title="Copy Element" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-link" title="Delete Element" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);	
}
//Replace Up/Down arrows with Left/Right arrows
if($('.ok-link-arrow').find('.move-up-btn').length > 0){
	$('.ok-link-arrow').find('.move-up-btn').html('<i class="fas fa-arrow-left"></i>');
	$('.ok-link-arrow').find('.move-up-btn').attr('title', 'Move Left');
}
if($('.ok-link-arrow').find('.move-down-btn').length > 0){
	$('.ok-link-arrow').find('.move-down-btn').html('<i class="fas fa-arrow-right"></i>');
	$('.ok-link-arrow').find('.move-down-btn').attr('title', 'Move Right');
}
//Clear Left/Right arrows
if($('.ok-link-arrow-clear').find('.move-up-btn').length > 0){
	$('.ok-link-arrow').find('.move-up-btn').html('<i class="fas fa-arrow-up"></i>');
	$('.ok-link-arrow').find('.move-up-btn').attr('title', 'Move Up');
}
if($('.ok-link-arrow-clear').find('.move-down-btn').length > 0){
	$('.ok-link-arrow').find('.move-down-btn').html('<i class="fas fa-arrow-down"></i>');
	$('.ok-link-arrow').find('.move-down-btn').attr('title', 'Move Down');
}
});

//Copy Link
$(document).on('click', '#copy-link', function(){
	$('#copy-db').html($('#ok-link-wrap').html());
	$('#copy-db').find('.ok-link').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			background: #6200EA!important;
			color: #ffffff!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: inline-block!important;}</style>');
	}
});

//Restore Link
$(document).on('click', '#restore-link', function(e) {
	e.stopImmediatePropagation();
	if($('#ok-link-wrap').parent().hasClass('ok-link-li')){
		$('#ok-link-wrap').parent().removeClass('ok-temp-show-deleted-elements ok-deleted-elements');
	}else{
		$('#ok-link-wrap').find('.ok-link').removeClass('ok-temp-show-deleted-elements ok-deleted-elements');
	}
	$('#setting-tools').remove(); 	 
	$('#ok-link-wrap').contents().unwrap();
});

//Delete Header Link
$(document).on('click', 'header.ok-section #delete-link', function() {
	if($('#ok-link-wrap').parent().hasClass('ok-link-li')){
		$('#ok-link-wrap').parent().addClass('ok-deleted-elements');
	}else{
		$('#ok-link-wrap').find('.ok-link').addClass('ok-deleted-elements');
	}
	$('#setting-tools').remove(); 	 
	$('#ok-link-wrap').contents().unwrap(); 
	$('#ok-show-hidden-ele-btn').show();
	$('#ok-hide-hidden-ele-btn').hide();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
});

//Delete Content Link
$(document).on('click', '#delete-link:not(header.ok-section #delete-link)', function() { 
	$('#ok-link-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column, .ok-group-container, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});

//Duplicate Link
$(document).on('click', '#duplicate-link', function(e) {
	if($('#ok-link-wrap').parent().hasClass('ok-link-li')){
		$('#ok-link-wrap').parent().clone().insertAfter($('#ok-link-wrap').parent());
	}else{
		$('#ok-link-wrap').find('.ok-link').clone().insertAfter('#ok-link-wrap');
	}
	$('#setting-tools').remove(); 	 
	$('#ok-link-wrap').contents().unwrap();
});

//Link Setting	
$(document).on('click', '#link-setting-menu', function() {	
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#setting-tools').remove();  
	$('#ok-link-wrap').removeClass('ok-border'); 
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
	
//Link Setting Panel
let linkBtnPanel = [];
linkBtnPanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="link-setting-header">Link Settings</span>
		<span id="close-panel" class="link-setting-close-btn float-right d-cursor white"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Link -->
			<div class="link-control-panel">
			<div class="setting-title">
				<p id="main-link-title">Link</p>
			</div>
			<div class="settings">
				<div id="link-text-wrap">
				<p id="title-info">Link Text</p>
				<textarea class="link-text seo-input-style" type="text" placeholder="Edit Text"></textarea>
				</div>
				<div id="link-inputs">
				<p>Link</p>
				<input class="link-linking input" type="text" placeholder="Link">
				<p>Link Title</p>
				<input class="link-linking-title input mb-10" type="text" placeholder="Title">
				</div>
			</div>
			</div><!-- ::END:: Link -->
			<!-- ::START:: Link Icon -->
			<div id="link-icon-wrap">
			<div class="setting-title">
				<p>Icon</p>
			</div>
			<div class="settings">
				<div class="icon-picker-selector" role="iconpicker"></div>
				<p class="brand-icon-info"><strong>Brand Icons</strong>: All brand icons are trademarks of their respective owners. Use them by following their brand guidelines.</p>
			</div>
			</div><!-- ::END:: Link Icon -->
			<!-- ::START:: Button Size -->
			<div class="button-control-panel">
			<div class="setting-title">
				<p>Button Size</p>
			</div>
			<div class="settings">								
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Size = <span class="button-size-count">0</span></p>
								<input class="button-size" type="range" min="1" max="18" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END::Button Size -->
			<!-- ::START:: Text Typography -->
			<div class="typography-control-panel">
			<div class="setting-title">
				<p>Typography</p>
			</div>
			<div class="settings">
				<div class="font-style-opt table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<p>Font Style</p>
							<select class="select-font-style ok-select-opt">
								<option value="">Default</option>
								<option value="font-a">Font A</option>
								<option value="font-b">Font B</option>
							</select>
						</td>
						<td width="50%">
							<p>Font Weight</p>
							<select class="select-font-weight ok-select-opt">
								<option value="">Default</option>
								<option value="fw-normal">Normal</option>
								<option value="fw-bold">Bold</option>
								<option value="fw-bolder">Bolder</option>
								<option value="fw-lighter">Lighter</option>
								<option value="fw-100">100</option>
								<option value="fw-200">200</option>
								<option value="fw-300">300</option>
								<option value="fw-400">400</option>
								<option value="fw-500">500</option>
								<option value="fw-600">600</option>
								<option value="fw-700">700</option>
								<option value="fw-800">800</option>
								<option value="fw-900">900</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Font size = <span class="ele-fs-count">0</span></p>
								<input class="ele-fs" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr class="line-height-opt">
						<td width="100%">
							<div class="slider-container">
								<p>Line Height = <span class="ele-lh-count">0</span></p>
								<input class="ele-lh" type="range" min="1" max="5" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Text Typography -->
			<!-- ::START:: Text Alignment and Transform -->
			<div class="alignment-control-panel">
			<div class="setting-title">
				<p>Alignment & Transform</p>
			</div>
			<div class="settings">
				<p>Text Alignment</p>
				<div class="button-25-wrap">
					<button class="main-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="main-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="main-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
				<p>Text Transform</p>
				<div class="button-25-wrap">
					<button class="main-case-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-capital-case button button-25" title="Capitalize">
						Aa
					</button>
					<button class="main-upper-case button-25" title="Uppercase">
						AA
					</button>
					<button class="main-lower-case button-25" title="Lowercase">
						aa
					</button>
				</div>
			</div>
			</div><!-- ::END:: Text Alignment and Transform -->	
			<!-- ::START:: Text Color -->
			<div class="color-control-panel">
			<div class="setting-title">
				<p>Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p id="color-opt-text">Select Color</p>
							<button class="main-color-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-color-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-color-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-color-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-color-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-color-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-color-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-color-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-color-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-color-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-color-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-color-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p id="hocolor-opt-text">Hover Color</p>
							<button class="main-hocolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hocolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hocolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hocolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hocolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hocolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hocolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hocolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hocolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hocolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hocolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hocolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Text Color -->
			<!-- ::START:: Background Color -->
			<div class="background-control-panel">
			<div class="setting-title">
				<p>Background Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button class="main-bgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bgcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Background Hover Color</p>
							<button class="main-hobgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hobgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobgcolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Background Color -->
			<!-- ::START:: Button Width -->
			<div id="button-width-control">
			<div class="setting-title">
				<p>Width</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="select-button-width ok-select-opt">
								<option value="ok-line">Default</option>
								<option value="w-100">100%</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Button Width -->
			<!-- ::START:: Border -->
			<div class="border-control-panel">
			<div class="setting-title">
				<p>Border</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="border-selector ok-select-opt">
								<option value="">None</option>
								<option value="border border-1">Border</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<div class="border-color-opt color-table table-box">
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Color</p>
							<button class="main-bdrcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bdrcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bdrcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bdrcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bdrcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bdrcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bdrcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bdrcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bdrcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bdrcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bdrcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Hover Color</p>
							<button class="main-hobdrcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobdrcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobdrcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobdrcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobdrcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobdrcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobdrcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobdrcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobdrcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobdrcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobdrcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
				</table>				
				<div class="slider-container">
					<p>Border size = <span class="ele-bdr-count">0</span></p>
					<input class="ele-bdr" type="range" min="1" max="5" step="1" value="0" />
				</div>
				</div>
			</div>
			</div><!-- ::END:: Border -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
			<!-- ::START:: Border Radius -->
			<div class="border-radius-control-panel">
			<div class="setting-title">
				<p>Border Radius</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="select-border-radius ok-select-opt">
								<option value="rounded-0">None</option>
								<option value="rounded">Rounded</option>
								<option id="pill-id" value="rounded-pill">Rounded Pill</option>
								<option id="circle-id" value="rounded-circle">Rounded Circle</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Border Radius -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = linkBtnPanel.join("");

//For Border radius in Navigation
if($('#ok-link-wrap').find('.ok-link.nav-link').length>0){
	$('.border-radius-control-panel, .border-control-panel, #button-width-control').hide();
}else{
	$('.border-radius-control-panel, .border-control-panel, #button-width-control').show();
	$('#circle-id').hide();
}
//For Video Button Link
if($('#ok-link-wrap .ok-video-btn').length>0){
	$('.margin-control-panel, #button-width-control').hide();
}
//For End Nav
if($('.nav-end').find('#ok-link-wrap').length>0){
	$('.margin-control-panel, #button-width-control').hide();
}
//For Pill radius
if($('#ok-link-wrap').find('.ok-link').hasClass('ok-icon')){
	$('#pill-id, #button-width-control').hide();
	$('#circle-id').show();
}
if($('#ok-link-wrap').find('.ok-link').hasClass('ok-link-icon')){
	$('#pill-id, #button-width-control').hide();
	$('#circle-id').show();
}
//For List
if($('#ok-link-wrap').find('.ok-link').hasClass('ok-list')){
	$('.link-text').val($('#ok-link-wrap .ok-list-text').html());
	$('#main-link-title').text('Text');
	$('#color-opt-text').text('Icon Color');
	$('#hocolor-opt-text').text('Text Color');
	$('.link-setting-header').text('Text Settings');	
	$("#link-icon-wrap").show();
	$('.button-control-panel, #button-width-control, .background-control-panel, .border-control-panel, .border-radius-control-panel, #link-inputs').hide();
}

//Check for Icon and Link
if($('#ok-link-wrap').find('.ok-link').hasClass('nav-link')){
	$("#link-icon-wrap, .button-control-panel, .typography-control-panel, .alignment-control-panel, .margin-control-panel, .background-control-panel").hide();
}else if($('#ok-link-wrap').find('.ok-link').hasClass('ok-link-icon')){
	$("#link-text-wrap, .font-style-opt, .line-height-opt, .alignment-control-panel").hide();
	$("#link-icon-wrap").show();
	$(".typography-control-panel .setting-title").html('<p>Font Size</p>');	
}else if($('#ok-link-wrap').find('.ok-link').hasClass('ok-icon')){
	$("#link-text-wrap, .link-control-panel, .font-style-opt, .line-height-opt, .alignment-control-panel").hide();
	$("#link-icon-wrap").show();
	$(".typography-control-panel .setting-title").html('<p>Font Size</p>');	
	$('.link-setting-header').html('Icon Settings');
}else if($('#ok-link-wrap').find('.ok-link').hasClass('ok-only-icon')){
	$("#button-width-control, #link-text-wrap, .link-control-panel, .font-style-opt, .line-height-opt, .alignment-control-panel, .margin-control-panel").hide();
	$("#link-icon-wrap").show();
	$(".typography-control-panel .setting-title").html('<p>Font Size</p>');	
	$('.link-setting-header').html('Icon Settings');
}else if($('#ok-link-wrap').find('.ok-link').hasClass('ok-list')){
	$("#link-icon-wrap").show();	
}else{
	$("#link-icon-wrap, .button-control-panel").hide();	
}

//Button Width
if($('#ok-link-wrap').find('.ok-link').hasClass('w-100')){
	$(".select-button-width option[value=w-100]").attr('selected','selected');
}else{
	$('.select-button-width option[value="ok-line"]').attr('selected','selected');
}
$(document).on('change', '.select-button-width', function(){
	$('#ok-link-wrap').removeClass("w-100");
	$('#ok-link-wrap').find('.ok-link').removeClass('w-100 ok-line');
	$('#ok-link-wrap').find('.ok-link').addClass(this.value);
	if($(this).val()==="w-100"){
		$('#ok-link-wrap').addClass("w-100");
	}
});

// Main Icon
$('.icon-picker-selector').iconpicker({
	cols: 6,
    rows: 5,
    search: true,
    searchText: 'Search',
    unselectedClass: ''
});
//Change Icon
$('.icon-picker-selector').on('change', function(icon) {
	if($('#ok-link-wrap').find('.ok-link').hasClass('ok-list')){
		$('#ok-link-wrap').find('.ok-list-icon').html('<i class="'+icon.icon+'"></i>');
	}else{
		$('#ok-link-wrap').find('.ok-link').html('<i class="'+icon.icon+'"></i>');
	}
}); 

//Check for Icon
if($('#ok-link-wrap').find('.ok-link').hasClass('ok-icon')||$('#ok-link-wrap').find('.ok-link').hasClass('ok-only-icon')||$('#ok-link-wrap').find('.ok-link').hasClass('ok-list')){
	//Do nothing
}else{
	$('.ok-link').attr('data-placeholder', '{Empty}');
	
	//Collect Default Values from Link Element
	$('.link-text').val($('#ok-link-wrap').find('a').html().replace(/\s+/g, ' ').trim());
	$('.link-linking').val($('#ok-link-wrap').find('a').attr('href'));
	$('.link-linking-title').val($('#ok-link-wrap').find('a').attr('title'));	
			
	//Link
	$(".link-linking").on("input", function() {
		$('#ok-link-wrap').find('a').attr('href', this.value);
	});
	//Link Title
	$(".link-linking-title").on("input", function() {
		$('#ok-link-wrap').find('a').attr('title', this.value);
	});
}
//Link Text
$(".link-text").on("input", function() {
	if($('#ok-link-wrap').find('.ok-link').hasClass('ok-list')){
		$('#ok-link-wrap').find('.ok-list-text').text(this.value);
	}else{
		$('#ok-link-wrap').find('a').html(this.value);
	}
});
});//END:: Add dynamic Anchor Element

//START:: Add dynamic iFrame/Code Element
$(document).on("mouseenter", '#body-data .ok-icode', function() {
	//First Removes Dynamic Elements If Exist	
	$('#ok-icode-wrap').contents().unwrap();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();

//Then Add Dynamic Element
if($(this).hasClass('ok-line')){
	$(this).wrap('<div id="ok-icode-wrap" class="ok-selector-line ok-border"></div>');
}else {
	$(this).wrap('<div id="ok-icode-wrap" class="ok-selector-block ok-border"></div>');
}
//On Hover show setting Tool
if($(this).hasClass('ok-code')||$(this).hasClass('embed-container')||$(this).hasClass('ok-sub')||$(this).hasClass('ok-contact')||$(this).hasClass('ok-map')){
	$('#ok-icode-wrap').prepend(`
		<div id="setting-tools" class="setting-menu icode-control" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
			<div title="Move Up" class="move-up-btn setting-menu-btn"><i class="fas fa-arrow-up"></i></div>
			<div title="Move Down" class="move-down-btn setting-menu-btn"><i class="fas fa-arrow-down"></i></div>
			<div id="icode-setting-menu" title="Element Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="copy-icode" title="Copy Element" class="copy-element setting-menu-btn"><i class="fas fa-clipboard"></i></div>
			<div title="Paste Element Below" class="paste-element setting-menu-btn"><i class="fas fa-paste"></i></div>
			<div id="delete-code" title="Delete Element" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);
}else{
	$('#ok-icode-wrap').prepend(`
		<div id="setting-tools" class="setting-menu icode-control" dir="ltr">
			<div title="Move Element" class="ok-handle setting-menu-btn"><i class="fas fa-arrows-alt"></i></div>
			<div id="icode-setting-menu" title="Element Settings" class="setting-menu-btn"><i class="fas fa-cog"></i></div>
			<div id="delete-code" title="Delete Element" class="setting-menu-btn"><i class="fas fa-trash-alt"></i></div>
		</div>
	`);
}
});

//Copy Code
$(document).on('click', '#copy-icode', function(){
	$('#copy-db').html($('#ok-icode-wrap').html());
	$('#copy-db').find('.ok-icode').addClass('copyed');
	$('#copy-db').find('.setting-menu').remove();
	$('#copy-db').addClass('has-clipboard');
	if($('#copy-db').hasClass('has-clipboard')){
		$('#copy-db-css').html(`
		<style>
		#main-menu-panel button {
			background: #6200EA!important;
			color: #ffffff!important;
		} 
		.copy-element,
		#section-setting-wrap .paste-element,
		#row-setting-tools .paste-element,
		#column-setting-tools .paste-element,
		.ok-flex .paste-element,
		header.ok-section .paste-element {display: none!important;} 
		.paste-element {display: inline-block!important;}
		</style>`);
	}else{		
		$('#copy-db-css').html('<style>.paste-element {display: none!important;} .copy-element {display: inline-block!important;}</style>');
	}
});
//Delete iCode
$(document).on('click', '#delete-code', function() {	 
	$('#ok-icode-wrap, #column-setting-tools').remove();
	//Add Placeholder if column is empty
	$('.ok-column, .card-body, .card-body.card-img-overlay div:nth-of-type(1)').each(function() { 
		if($(this).html().trim() == ''){
			$(this).html('\n'
			+'<button class="add-section add-element-btn" title="Add Section"><i class="fas fa-plus"></i> Add Element</button>'
			+'');
		} 
	});
});

//iCode Setting	
$(document).on('click', '#icode-setting-menu', function() {	
	//Remove Dynamic controls
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-column').removeClass('column-border ok-column-handle');	
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#setting-tools').remove();
	$('#ok-icode-wrap').removeClass('ok-border'); 
	$('.ok-row').removeClass('active-row');
	$('.ok-column').removeClass('ok-column-handle');
	
//iCode Setting Panel
let iCodePanel = [];
iCodePanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="icode-setting-header">iFrame/Code Settings</span>
		<span id="close-panel" class="icode-setting-close-btn float-right d-cursor white"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: iFrame/Code -->
			<div id="code-opt-wrap" class="element-setting-wrap">
				<div class="setting-title">
					<p id="code-title">iFrame/Code</p>
				</div>
				<div class="settings">
					<p id="code-text" class="mt-10">Edit/Replace Code</p>
					<textarea class="icode-input" type="text" placeholder="Edit/Replace Code"></textarea>
					<p id="icon-info-text" class="mt-10">Copy and Paste the icon from <strong>lineicons.com</strong></p>
				</div>
			</div><!-- ::END:: iFrame/Code -->
			<!-- ::START:: Video Option Setting -->
			<div id="video-opt-wrap" class="element-setting-wrap">
				<div class="ok-video-opt-script setting-title">
					<p>Video Options</p>
				</div>	
				<div class="settings">
					<div class="vid-url-wrap">
						<p class="text-left mt-20">Select Video Platform</p>
						<select class="video-selector ok-select-opt">
							<option value="ok-youtube">YouTube</option>
							<option value="ok-vimeo">Vimeo</option>
						</select>
						<p class="text-left mt-20">Video URL</p>
						<input id="yt-vid-url" class="input" type="text" placeholder="YouTube Video URL">
						<input id="vm-vid-url" class="input" type="text" placeholder="Vimeo Video URL">
						<p class="text-left mt-15"><strong>Acceptable URL formats:</strong></p>
						<p class="yt-format text-left fs-12 mt-0">https://www.youtube.com/watch?v=xxxxxx</p>
						<p class="yt-format text-left fs-12 mt-0">https://youtu.be/xxxxxx</p>
						<p class="yt-format text-left fs-12 mt-0">https://www.youtube.com/embed/xxxxxx</p>
						<p class="vimeo-format text-left fs-12">https://vimeo.com/xxxxxx</p>
					</div>
				</div>
			</div><!-- ::END:: Video Options Setting -->
			<!-- ::START:: MailChimp Form Configuration -->
			<div class="mcform-control-panel">
			<div class="setting-title">
				<p>Mailchimp Form Configuration</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Mailchimp Action URL</p>
							<input class="input mc-url-input" type="text" placeholder="Enter MailChimp Action URL">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Name placeholder text <span id="hide-name-field"><i class="fas fa-eye-slash"></i> Hide</span> <span id="show-name-field"><i class="fas fa-eye"></i> Show</span></p>
							<input class="input mc-name-placeholder" type="text" placeholder="Full Name">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Email placeholder text</p>
							<input class="input mc-email-placeholder" type="text" placeholder="Email Address">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Button text</p>
							<input class="input mc-btn-text" type="text">
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: MailChimp Form Configuration -->
			<!-- ::START:: Form Configuration -->
			<div class="form-control-panel">
			<div class="setting-title">
				<p>Form Configuration</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Email Receive At</p>
							<input class="input contact-email-input" type="text" placeholder="your@email.com">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Email Subject</p>
							<input class="input contact-sub-input" type="text" placeholder="Email Subject">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Thank you Message</p>
							<input class="input contact-success-input" type="text" placeholder="Thanks for filling out our form!">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Secondary Message/HTML text</p>
							<textarea class="input contact-notify-input" type="text" placeholder="Your submission is received and we will contact you soon."></textarea>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Form Configuration -->
			<!-- ::START:: Placeholder & Button Text -->
			<div class="field-control-panel">
			<div class="setting-title">
				<p>Placeholder & Button Text</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Name</p>
							<input class="input name-placeholder" type="text">
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Email</p>
							<input class="input email-placeholder" type="text">
						</td>
					</tr>
					<tr class="message-placeholder-wrap">
						<td width="100%">
							<p>Message</p>
							<input class="input message-placeholder" type="text">
						</td>
					</tr>
					<tr class="form-button-text-wrap">
						<td width="100%">
							<p>Button Text</p>
							<input class="input form-button-text" type="text">
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Placeholder & Button Text -->			
			<!-- ::START:: Text Typography -->
			<div class="typography-control-panel">
			<div class="setting-title">
				<p>Text Typography</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<p>Font Style</p>
							<select class="select-font-style ok-select-opt">
								<option value="">Default</option>
								<option value="font-a">Font A</option>
								<option value="font-b">Font B</option>
							</select>
						</td>
						<td width="50%">
							<p>Font Weight</p>
							<select class="select-font-weight ok-select-opt">
								<option value="">Default</option>
								<option value="fw-normal">Normal</option>
								<option value="fw-bold">Bold</option>
								<option value="fw-bolder">Bolder</option>
								<option value="fw-lighter">Lighter</option>
								<option value="fw-100">100</option>
								<option value="fw-200">200</option>
								<option value="fw-300">300</option>
								<option value="fw-400">400</option>
								<option value="fw-500">500</option>
								<option value="fw-600">600</option>
								<option value="fw-700">700</option>
								<option value="fw-800">800</option>
								<option value="fw-900">900</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<hr>
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Font size = <span class="ele-fs-count">0</span></p>
								<input class="ele-fs" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr class="lh-opt-wrap">
						<td width="100%">
							<div class="slider-container">
								<p>Line Height = <span class="ele-lh-count">0</span></p>
								<input class="ele-lh" type="range" min="1" max="5" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Text Typography -->
			<!-- ::START:: Text Alignment and Transform -->
			<div class="alignment-control-panel">
			<div class="setting-title">
				<p>Alignment & Transform</p>
			</div>
			<div class="settings">
				<p class="align-opt-wrap">Text Alignment</p>
				<div class="button-25-wrap align-opt-wrap">
					<button class="main-align-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-align-left button-25" title="Left">
						<i class="fas fa-align-left tools-icon"></i>
					</button>
					<button class="main-align-center button-25" title="Center">
						<i class="fas fa-align-center tools-icon"></i>
					</button>
					<button class="main-align-right button-25" title="Right">
						<i class="fas fa-align-right tools-icon"></i>
					</button>
				</div>
				<p>Text Transform</p>
				<div class="button-25-wrap">
					<button class="main-case-none button-25" title="None">
						<i class="fas fa-ban tools-icon"></i>
					</button>
					<button class="main-capital-case button button-25" title="Capitalize">
						Aa
					</button>
					<button class="main-upper-case button-25" title="Uppercase">
						AA
					</button>
					<button class="main-lower-case button-25" title="Lowercase">
						aa
					</button>
				</div>
			</div>
			</div><!-- ::END:: Text Alignment and Transform -->	
			<!-- ::START:: Button Text Color -->
			<div class="color-control-panel">
			<div class="setting-title">
				<p>Button Text Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Select Color</p>
							<button class="main-color-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-color-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-color-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-color-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-color-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-color-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-color-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-color-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-color-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-color-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-color-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-color-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Hover Color</p>
							<button class="main-hocolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hocolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hocolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hocolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hocolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hocolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hocolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hocolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hocolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hocolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hocolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hocolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Button Text Color -->
			<!-- ::START:: Button Background Color -->
			<div class="background-control-panel">
			<div class="setting-title">
				<p>Button Background Color</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button class="main-bgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bgcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Background Hover Color</p>
							<button class="main-hobgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-hobgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-hobgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-hobgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-hobgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-hobgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-hobgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-hobgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-hobgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-hobgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-hobgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-hobgcolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Button Background Color -->
			<!-- ::START:: Width -->
			<div class="icode-width-control-panel">
			<div class="setting-title">
				<p>Button Width</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="select-icode-width ok-select-opt">
								<option value="">Default</option>
								<option value="form-control">100%</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Width -->
			<!-- ::START:: Border -->
			<div class="border-control-panel">
			<div class="setting-title">
				<p>Field Border Settings</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="border-selector ok-select-opt">
								<option value="">None</option>
								<option value="border border-1">Border</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
				<div class="border-color-opt color-table table-box">
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Color</p>
							<button class="main-bdrcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bdrcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bdrcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bdrcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bdrcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bdrcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bdrcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bdrcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bdrcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bdrcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bdrcolor-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>				
				<div class="slider-container">
					<p>Border size = <span class="ele-bdr-count">0</span></p>
					<input class="ele-bdr" type="range" min="1" max="5" step="1" value="0" />
				</div>
				</div>
			</div>
			</div><!-- ::END:: Border -->
			<!-- ::START:: Border Radius -->
			<div class="border-radius-control-panel">
			<div class="setting-title">
				<p>Border Radius</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<select class="select-border-radius ok-select-opt">
								<option value="rounded-0">None</option>
								<option value="rounded">Rounded</option>
								<option value="rounded-pill">Rounded Pill</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Border Radius -->
			<!-- ::START:: Margin -->
			<div class="margin-control-panel">
			<div class="setting-title">
				<p>Margin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Top = <span class="ele-mt-count">0</span>px</p>
								<input class="ele-mt" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<div class="slider-container">
								<p>Margin Bottom = <span class="ele-mb-count">0</span>px</p>
								<input class="ele-mb" type="range" min="1" max="15" step="1" value="0" />
							</div>
						</td>
					</tr>
				</table>
				</div>		
			</div>
			</div><!-- ::END:: Margin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = iCodePanel.join("");

//Hide Contact Width Option
$('#icode-width-control-panel').hide();

//Has Contact Form
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-contact')){
	$(".icode-setting-header").text('Contact Form Settings');
	$('#icode-width-control-panel').show();
	$('#code-opt-wrap, .lh-opt-wrap, .align-opt-wrap, .mcform-control-panel').hide();
}

//Has Mailchimp Form
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-sub')){
	$(".icode-setting-header").text('Mailchimp Form Settings');
	$('#icode-width-control-panel').show();
	$('#code-opt-wrap, .lh-opt-wrap, .align-opt-wrap, .form-control-panel, .field-control-panel, .margin-control-panel').hide();
}

//Card Width
if($('#ok-icode-wrap').find('.ok-contact-btn').hasClass('form-control')){
	$(".select-icode-width option[value=form-control]").attr('selected','selected');
}
$(document).on('change', '.select-icode-width', function(){
	$('#ok-icode-wrap .ok-contact-btn').removeClass('form-control');
	$('#ok-icode-wrap .ok-contact-btn').addClass(this.value);
});

//Has Icon Only
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-icon')){
	$('.icode-setting-header').text('Icon Settings');
	$('#code-title').text('Icon');
	$('#code-text').text('Add Icon');
	$('#icon-info-text').show();
	$('.icode-input').css('height', '40px');
}
//For Custom Code
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-code')){
	$('.icode-setting-header').text('Custom Code Settings');
	$('#code-title').text('Code');
	$('#code-text').text('Add Custom Code');
	$('.icode-width-control-panel, .border-control-panel, .mcform-control-panel, .form-control-panel, .field-control-panel, .typography-control-panel, .alignment-control-panel, .color-control-panel, .background-control-panel, .border-radius-control-panel').hide();
}
//For Map
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-map')){
	$('.icode-setting-header').text('Map Settings');
	$('#code-title').text('Map');
	$('#code-text').text('Paste map source');
	$('.icode-width-control-panel, .border-control-panel, .mcform-control-panel, .form-control-panel, .field-control-panel, .typography-control-panel, .alignment-control-panel, .color-control-panel, .background-control-panel, .border-radius-control-panel').hide();
}
//For Videos
$(document).on('change', '.video-selector', function(){
	if($(this).val()==="ok-youtube"){
		$('#yt-vid-url, .yt-format').show();		
		$('#vm-vid-url, .vimeo-format').hide();
	}
	if($(this).val()==="ok-vimeo"){
		$('#vm-vid-url, .vimeo-format').show();		
		$('#yt-vid-url, .yt-format').hide();
	}
});

if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-youtube')){
	$('.icode-setting-header').text('Video Settings');
	$('#video-opt-wrap, #yt-vid-url, .yt-format').show();
	$(".video-selector option[value='ok-youtube']").attr('selected','selected');
	$('.icode-width-control-panel, .border-control-panel, #code-opt-wrap, #vm-vid-url, .vimeo-format, .mcform-control-panel, .form-control-panel, .field-control-panel, .typography-control-panel, .alignment-control-panel, .color-control-panel, .background-control-panel, .border-radius-control-panel').hide();
}
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-vimeo')){
	$('.icode-setting-header').text('Video Settings');
	$('#video-opt-wrap, #vm-vid-url, .vimeo-format').show();
	$(".video-selector option[value='ok-vimeo']").attr('selected','selected');
	$('.icode-width-control-panel, .border-control-panel, #code-opt-wrap, #yt-vid-url, .yt-format, .mcform-control-panel, .form-control-panel, .field-control-panel, .typography-control-panel, .alignment-control-panel, .color-control-panel, .background-control-panel, .border-radius-control-panel').hide();
}
/*
if($('#ok-icode-wrap').find('.ok-icode').hasClass('ok-vidlink')){
	$('.icode-setting-header').text('Youtube Video Settings');
	$('#code-opt-wrap, .vimeo-format').hide();
	$('#video-opt-wrap').show();
}*/

//YouTube Video URL Input
$('#yt-vid-url').on('input', function(){
    function getId(url) {
    let regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
    let match = url.match(regExp);

    if (match && match[2].length == 11) {
        return match[2];
    } else {
        return 'error';
    }
}
let videoId = $('#yt-vid-url').val();
let myId = getId(videoId);
	$('#ok-icode-wrap .ok-icode').removeClass('ok-youtube ok-vimeo');
	$('#ok-icode-wrap .ok-icode').addClass('ok-youtube');
	$('#ok-icode-wrap .ok-youtube.embed-container').attr('data-vidid', 'https://www.youtube.com/embed/'+myId);
	/*
	$('#ok-icode-wrap .ok-icode.ok-youtube').find('iframe').attr('allow', 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture');
	$('#ok-icode-wrap .ok-icode.ok-youtube').find('iframe').attr('title', 'YouTube video player');
	$('#ok-icode-wrap .ok-youtube').find('iframe').attr('src', 'https://www.youtube.com/embed/'+ myId );*/
	$('#ok-icode-wrap .ok-youtube').find('img').attr('src', 'https://img.youtube.com/vi/'+myId+'/maxresdefault.jpg');
//$('#ok-icode-wrap').find('.ok-vidlink').attr('href', 'https://www.youtube.com/embed/'+ myId );
});

//Vimeo Video URL Input
$('#vm-vid-url').on('input', function(){
	function parseUrl(url){
		let vimeoRegex = /(?:vimeo)\.com.*(?:videos|video|channels|)\/([\d]+)/i;
		let parsed = url.match(vimeoRegex);
		return "https://player.vimeo.com/video/" + parsed[1]; 
	};
	function thumbUrl(url){
		let thumbRegex = /(?:vimeo)\.com.*(?:videos|video|channels|)\/([\d]+)/i;
		let parsedThumb = url.match(thumbRegex);
		return "https://vumbnail.com/" + parsedThumb[1]+".jpg";
	};
	let vidId = document.getElementById('vm-vid-url').value;
	let vimeoId = parseUrl(vidId);
	$('#ok-icode-wrap .ok-icode').removeClass('ok-youtube ok-vimeo');
	$('#ok-icode-wrap .ok-icode').addClass('ok-vimeo');
	$('#ok-icode-wrap .ok-vimeo.embed-container').attr('data-vidid', vimeoId);
	/*
	$('#ok-icode-wrap .ok-icode.ok-vimeo').find('iframe').attr('allow', 'autoplay; fullscreen; picture-in-picture');
	$('#ok-icode-wrap .ok-icode.ok-vimeo').find('iframe').attr('title', 'Vimeo video player');
	$('#ok-icode-wrap .ok-vimeo').find('iframe').attr('src', parseUrl(vidId) );*/
	$('#ok-icode-wrap .ok-vimeo').find('img').attr('src', thumbUrl(vidId));
});


	$('.ok-icode').attr('data-placeholder', '{Empty}');
	
	//Collect Default Values from icode Element
	$('.icode-input').html($('#ok-icode-wrap').find('.ok-icode').html().replace(/\s+/g, ' ').trim());
	
	//icode-input Text
	$(".icode-input").on("input", function() {
		$('#ok-icode-wrap').find('.ok-icode').html(this.value);
	});	

//Get Default Values
$(".contact-email-input").val($("#db-contact-email").text());
//Contact Email
$(".contact-email-input").on("input", function() {				
	$("#ok-db #db-contact-email").remove();//Remove duplicate
	$("#ok-db").append('<p id="db-contact-email" class="hide-this-db">'+this.value+'</p>');
});	

//Get Default Values
$(".contact-sub-input").val($("#db-contact-subject").text());
//Contact Subject
$(".contact-sub-input").on("input", function() {				
	$("#ok-db #db-contact-subject").remove();//Remove duplicate
	$("#ok-db").append('<p id="db-contact-subject" class="hide-this-db">'+this.value+'</p>');
});

//Get Default Values
$(".contact-success-input").val($("#db-contact-success").text());
//Contact success
$(".contact-success-input").on("input", function() {				
	$("#ok-db #db-contact-success").remove();//Remove duplicate
	$("#ok-db").append('<p id="db-contact-success" class="hide-this-db">'+this.value+'</p>');
});	

//Get Default Values
$(".contact-notify-input").val($("#db-contact-notify").text());
//Contact Notify
$(".contact-notify-input").on("input", function() {				
	$("#ok-db #db-contact-notify").remove();//Remove duplicate
	$("#ok-db").append('<p id="db-contact-notify" class="hide-this-db">'+this.value+'</p>');
});	

//Get Default Values
$(".name-placeholder").val($("#ok-icode-wrap .ok-contact-name").text());
//Contact name placeholder
$(".name-placeholder").on("input", function() {				
	$("#ok-icode-wrap .ok-contact-name").text(this.value);
});	

//Get Default Values
$(".email-placeholder").val($("#ok-icode-wrap .ok-email-id").text());
//Contact email placeholder
$(".email-placeholder").on("input", function() {				
	$("#ok-icode-wrap .ok-email-id").text(this.value);
});	

//Get Default Values
$(".message-placeholder").val($("#ok-icode-wrap .ok-message-id").text());
//Contact message placeholder
$(".message-placeholder").on("input", function() {				
	$("#ok-icode-wrap .ok-message-id").text(this.value);
});	

//Get Default Values
$(".form-button-text").val($("#ok-icode-wrap .ok-contact-btn").val());
//Contact Submit btn text
$(".form-button-text").on("input", function() {				
	$("#ok-icode-wrap .ok-contact-btn").val(this.value);
});	

//Get Default Values
$(".mc-url-input").val($("#ok-icode-wrap .ok-sub").attr('action'));
//Mailchimp Action URL
$(".mc-url-input").on("input", function() {				
	$("#ok-icode-wrap .ok-sub").attr('action', this.value);
});	

//Get Default Values
$(".mc-name-placeholder").val($("#ok-icode-wrap .ok-contact-name").text());
//Contact name placeholder
$(".mc-name-placeholder").on("input", function() {				
	$("#ok-icode-wrap .ok-contact-name").attr('placeholder', this.value);
});	

//Get Default Hide/Show Values
if($('#ok-icode-wrap .ok-name-field').hasClass('ok-hide-name-field')){
	$('#hide-name-field').hide();
	$('#show-name-field').show();
	$('.mc-name-placeholder').attr('disabled', true);
}else{
	$('#show-name-field').hide();
	$('#hide-name-field').show();
	$('.mc-name-placeholder').removeAttr('disabled');
}
//Hide Name Field
$(document).on('click', '#hide-name-field', function(){
	$(this).hide();
	$('#show-name-field').show();
	$('#ok-icode-wrap .ok-name-field').addClass('ok-hide-name-field');
	$('#ok-icode-wrap .ok-email-field').addClass('w-100');
	$('.mc-name-placeholder').attr('disabled', true);
});
//Show Name Field
$(document).on('click', '#show-name-field', function(){
	$(this).hide();
	$('#hide-name-field').show();
	$('#ok-icode-wrap .ok-name-field').removeClass('ok-hide-name-field');
	$('#ok-icode-wrap .ok-email-field').removeClass('w-100');
	$('.mc-name-placeholder').removeAttr('disabled');
});

//Get Default Values
$(".mc-email-placeholder").val($("#ok-icode-wrap .ok-email-id").text());
//Mc Email placeholder
$(".mc-email-placeholder").on("input", function() {				
	$("#ok-icode-wrap .ok-email-id").attr('placeholder', this.value);
});	

//Get Default Values
$(".mc-btn-text").val($("#ok-icode-wrap .ok-contact-btn").val());
//Mc Submit btn text
$(".mc-btn-text").on("input", function() {				
	$("#ok-icode-wrap .ok-contact-btn").val(this.value);
});	
});//END:: Add dynamic iFrame/Code Element

//::START:: Project File Import
//Import Project File
$(document).on('click', '#pop-upload-project-file', function(){	
	$('body').css('overflow', 'hidden');  
	$('.download-popup-wrap').addClass('download-popup-on'); 
	$('#download-box-section').hide();
	$('#import-project-file').show();
	//For Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();
	//Animate the scroll to top
    $('html, body').animate({
        scrollTop: 0,
    }, 100);
});
//If Yes Import project file
$(document).on('click', '#upload-project-file', function(){	
	$('#upload-file').click();
});
$(document).on('change', '#upload-file', function() {
	if (!window.File || !window.FileReader || !window.FileList || !window.Blob) {
        alert('The File APIs are not fully supported in this browser.');
        return;
    }  
	var file = this.files[0];
	var FR = new FileReader();
	FR.readAsText(file);
	FR.onload = function(data) {
		var myProjectFile = data.target.result;
		//$('#uploaded-file-name').text($("#project-file").val().replace(/C:\\fakepath\\/i, ''));//Shows Uploaded file name
		//$("#html").html(myProjectFile); // $("#html").text(myProjectFile);
		if ($(myProjectFile).find("div").hasClass('ok-section')||$(myProjectFile).find("section").hasClass('ok-section')||$(myProjectFile).find("header").hasClass('ok-section')){
        	document.open();
			document.write(myProjectFile);
			document.close();
		} else {
			alert('Selected file has no valid design blocks. Please upload a valid template.');
        return;
		}	
	}
});//::END:: Project File Import

//SEO Start
$(document).on("click", '#ok-seo-btn', function() {
	//First Removes Dynamic Elements If Exist	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	
	//For Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();	
	//Hide deleted elements
	$('#ok-hide-hidden-ele-btn').hide();
	$('#ok-show-hidden-ele-btn').show();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
	
	//Get Default Values
	$(".page-title").text($('head').find('title').text());
	$(".meta-desc").text($('head').find("meta[name='description']").attr('content'));
	$(".meta-key-input").text($('head').find("meta[name='keywords']").attr('content'));
	$("#web-fav").val($('head').find("link[rel='shortcut icon']").attr('href'));
	$("#fav-img-preview").attr('src', $('head').find("link[rel='shortcut icon']").attr('href'));
	$("#web-url").val($('head').find("meta[property='og:url']").attr('content'));
	$("#web-img").val($('head').find("meta[property='og:image']").attr('content'));
	$("#web-img-preview").attr('src', $('head').find("meta[property='og:image']").attr('content'));
	
	$('.ok-seo-wrap').toggleClass('ok-seo-wrap-on');
	$('.ok-main-tools').css('width', '300px');
	$('body').css('overflow', 'auto');
	$('#main-menu-btnmenuheader, .ok-main-btn, #ok-seo-btn, #convert-file').hide();
	
//Page Title character counter
var titleLength = 70;
$('.page-title').on('input', function() {
  var length = $(this).val().length;
  var length = titleLength-length;
  $('.title-characters').text(length);
});
//Meta Description character counter
var descLength = 160;
$('.meta-desc').on('input', function() {
  var length = $(this).val().length;
  var length = descLength-length;
  $('.meta-characters').text(length);
});
//Add Page Title
$(".page-title").on("input", function() {
	$('title').text(this.value);
	if($("meta[name='title']").length > 0){
		$("meta[name='title']").attr('content', this.value);
	}else {
		$('\n<meta name="title" content="'+this.value+'">\n').insertAfter('title');
	}
	if($("meta[property='og:title']").length > 0){
		$("meta[property='og:title']").attr('content', this.value);
	}else {
		$('\n<meta property="og:title" content="'+this.value+'">\n').insertAfter('title');
	}
	if($("meta[property='twitter:title']").length > 0){
		$("meta[property='twitter:title']").attr('content', this.value);
	}else {
		$('\n<meta property="twitter:title" content="'+this.value+'">\n').insertAfter('title');
	}
});
//Add Meta Description
$(".meta-desc").on("input", function() {
	if($("meta[name='description']").length > 0){
		$("meta[name='description']").attr('content', this.value);
	}else {
		$('\n<meta name="description" content="'+this.value+'">\n').insertAfter('title');
	}
	if($("meta[property='og:description']").length > 0){
		$("meta[property='og:description']").attr('content', this.value);
	}else {
		$('\n<meta property="og:description" content="'+this.value+'">\n').insertAfter('title');
	}
	if($("meta[property='twitter:description']").length > 0){
		$("meta[property='twitter:description']").attr('content', this.value);
	}else {
		$('\n<meta property="twitter:description" content="'+this.value+'">\n').insertAfter('title');
	}
});
//Add Meta Keywords
$(".meta-key-input").on("input", function() {
	if($("meta[name='keywords']").length > 0){
		$("meta[name='keywords']").attr('content', this.value);
	}else {
		$('\n<meta name="keywords" content="'+this.value+'">\n').insertAfter('title');
	}
});
//Add OG Web URL Meta Tag
$("#web-url").on("input", function() {
	if($("meta[property='og:url']").length > 0){
		$("meta[property='og:url']").attr('content', this.value);
	}else {
		$('\n<meta property="og:url" content="'+this.value+'">\n').insertAfter('title');
	}
	if($("meta[property='twitter:url']").length > 0){
		$("meta[property='twitter:url']").attr('content', this.value);
	}else {
		$('\n<meta property="twitter:url" content="'+this.value+'">\n').insertAfter('title');
	}
});
//START:: OG/Fav Image
//Add OG Web Image from Desktop
$("#add-site-sm-image").on('click', function(){
	$('#add-main-smimage').click();
});
$("#add-main-smimage").change(function(){
	$("#main-smimage-iframe").hide();//Hide file upload messages
	$("#add-site-sm-image").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
	let newSmImgFileName = 'id'+uniqueUser+(new Date()).getTime();//set unique image name
	let ymdHmsSm = document.getElementById("smimage-filename").value = newSmImgFileName;
	//Get the file input element by its id 
	var fileInputSm = document.getElementById('add-main-smimage');
	//Get the file name
	var fileNameSm = fileInputSm.files[0].name;
	//Get the file Extension 
	var fileExtensionSm = fileNameSm.split('.').pop();
	$('#upload-smimage').click();
	
	$('#main-smimage-iframe').on('load', function() {	
		$("#web-img-preview").attr('src', 'assets/img/'+uniqueUser+'/'+ymdHmsSm+'.'+fileExtensionSm);
		if($("meta[property='og:image']").length > 0){
			$("meta[property='og:image']").attr('content', 'assets/img/'+uniqueUser+'/'+ymdHmsSm+'.'+fileExtensionSm);
			$("meta[property='og:image']").attr('class', 'og-image');
		}else {
			$('\n<meta property="og:image" class="og-image" content="assets/img/'+uniqueUser+'/'+ymdHmsSm+'.'+fileExtensionSm+'">\n').insertAfter('title');
		}
		if($("meta[property='twitter:image']").length > 0){
			$("meta[property='twitter:image']").attr('content', 'assets/img/'+uniqueUser+'/'+ymdHmsSm+'.'+fileExtensionSm);
			$("meta[property='og:image']").attr('class', 'og-image');
		}else {
			$('\n<meta property="twitter:image" class="og-image" content="assets/img/'+uniqueUser+'/'+ymdHmsSm+'.'+fileExtensionSm+'">\n').insertAfter('title');
		}
		if($("#main-smimage-iframe").contents().find('#sucess-info').length>0){
			$("#add-site-sm-image").html('<i class="fas fa-upload"></i>');
		}
		$("#main-smimage-iframe").show();//Show file upload messages
	});
});
$("#web-img").on("input", function() {
	$("#web-img-preview").attr('src', this.value);
	if($("meta[property='og:image']").length > 0){
		$("meta[property='og:image']").attr('content', this.value);
		$("meta[property='og:image']").removeAttr('class');
	}else {
		$('\n<meta property="og:image" content="'+this.value+'">\n').insertAfter('title');
	}
	if($("meta[property='twitter:image']").length > 0){
		$("meta[property='twitter:image']").attr('content', this.value);
		$("meta[property='twitter:image']").removeAttr('class');
	}else {
		$('\n<meta property="twitter:image" content="'+this.value+'">\n').insertAfter('title');
	}
});
//Add Web Favicon
$("#add-site-fav-image").on('click', function(){
	$('#add-main-favimage').click();
});
$("#add-main-favimage").change(function(){
	$("#main-image-iframe").hide();//Hide file upload messages
	$("#add-site-fav-image").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
	let newFavFileName = 'id'+uniqueUser+(new Date()).getTime();//set unique image name
	let ymdHmsFav = document.getElementById("favimage-filename").value = newFavFileName;
	//Get the file input element by its id 
	var fileInputFav = document.getElementById('add-main-favimage');
	//Get the file name
	var fileNameFav = fileInputFav.files[0].name;
	//Get the file Extension 
	var fileExtensionFav = fileNameFav.split('.').pop();
	$('#upload-favimage').click();
	
	$('#main-favimage-iframe').on('load', function() {	
		$("#fav-img-preview").attr('src', 'assets/img/'+uniqueUser+'/'+ymdHmsFav+'.'+fileExtensionFav);	
		if($("link[rel='shortcut icon']").length > 0){
			$("link[rel='shortcut icon']").attr('href', 'assets/img/'+uniqueUser+'/'+ymdHmsFav+'.'+fileExtensionFav);
			$("link[rel='shortcut icon']").attr('class', 'fav-image');
		}else {
			$('\n<link rel="shortcut icon" class="fav-image" href="assets/img/'+uniqueUser+'/'+ymdHmsFav+'.'+fileExtensionFav+'" type="image/x-icon">\n').insertAfter('title');
		}
		
		
		if($("#main-favimage-iframe").contents().find('#sucess-info').length>0){
			$("#add-site-fav-image").html('<i class="fas fa-upload"></i>');
		}
		
		$("#main-favimage-iframe").show();//Show file upload messages
	});
});
$("#web-fav").on("input", function() {
	$("#fav-img-preview").attr('src', this.value);
	if($("link[rel='shortcut icon']").length > 0){
		$("link[rel='shortcut icon']").attr('href', this.value);
		$("link[rel='shortcut icon']").removeAttr('class');
	}else {
		$('\n<link rel="shortcut icon" href="'+this.value+'" type="image/x-icon">\n').insertAfter('title');
	}
});//END:: OG/Fav Image
//Close Seo Box
$(document).on("click", '.close-seo', function() {
	$('.ok-seo-wrap').removeClass('ok-seo-wrap-on');
	$('.ok-main-tools').css('width', 'auto');
	$('#main-menu-btnmenuheader, .ok-main-btn, #ok-seo-btn, #convert-file').show();
	$('#ok-hide-hidden-ele-btn').hide();
});
});//END:: Download and SEO Function

//START:: Main Menu DIV element draggagle:
$(document).on("mouseenter", '.drag-btn', function(e) {
	e.stopImmediatePropagation();
$("#main-menu-script").html(`
<script>
    dragElement(document.getElementById("main-menu-btn"));
    function dragElement(elmnt) {
      var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
      if (document.getElementById(elmnt.id + "menuheader")) {
        /* if present, the header is where you move the DIV from:*/
        document.getElementById(elmnt.id + "menuheader").onmousedown = dragMouseDown;
      } else {
        /* otherwise, move the DIV from anywhere inside the DIV:*/
        elmnt.onmousedown = dragMouseDown;
      }
    
      function dragMouseDown(e) {
        e = e || window.event;
        e.preventDefault();
        // get the mouse cursor position at startup:
        pos3 = e.clientX;
        pos4 = e.clientY;
        document.onmouseup = closeDragElement;
        // call a function whenever the cursor moves:
        document.onmousemove = elementDrag;
      }
    
      function elementDrag(e) {
        e = e || window.event;
        e.preventDefault();
        var winW = document.documentElement.clientWidth || document.body.clientWidth,
            winH = document.documentElement.clientHeight || document.body.clientHeight;
            maxX = winW - elmnt.offsetWidth - 1,
            maxY = winH - elmnt.offsetHeight - 1;
        // calculate the new cursor position:
        pos1 = pos3 - e.clientX;
        pos2 = pos4 - e.clientY;
        pos3 = e.clientX;
        pos4 = e.clientY;
        // set the element's new position:
        //console.log((elmnt.offsetLeft - pos1), maxY, (elmnt.offsetLeft - pos1), maxX);
        if((elmnt.offsetTop - pos2) <= maxY && (elmnt.offsetTop - pos2) >= 0){
          elmnt.style.top = (elmnt.offsetTop - pos2) + "px";
        }
        if((elmnt.offsetLeft - pos1) <= maxX && (elmnt.offsetLeft - pos1) >= 0){
          elmnt.style.left = (elmnt.offsetLeft - pos1) + "px";
        }
      }
    
      function closeDragElement() {
        /* stop moving when mouse button is released:*/
        document.onmouseup = null;
        document.onmousemove = null;
      }
    }
</script>`);
});//END:: DIV element draggagle:
	
//Move Row Up/Down
$(document).on('click', '.move-up-btn', function(){
	$(this).parent().parent().insertBefore($(this).parent().parent().prev());
});
$(document).on('click', '.move-down-btn', function(){
	$(this).parent().parent().insertAfter($(this).parent().parent().next());
});
$(document).on('click', '.ok-link-li .move-up-btn', function(){
	$(this).parents('.ok-link-li').insertBefore($(this).parents('.ok-link-li').prev());
});
$(document).on('click', '.ok-link-li .move-down-btn', function(){
	$(this).parents('.ok-link-li').insertAfter($(this).parents('.ok-link-li').next());
});
$(document).on('click', '.ok-text-li .move-up-btn', function(){
	$(this).parents('.ok-text-li').insertBefore($(this).parents('.ok-text-li').prev());
});
$(document).on('click', '.ok-text-li .move-down-btn', function(){
	$(this).parents('.ok-text-li').insertAfter($(this).parents('.ok-text-li').next());
});


//START:: Site Integrations
 $(document).on('click', '#ok-settings-btn', function(){
	//For Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();
	
	//Hide hidden options
	$('body').append('<style id="hide-ele-opt-on-global-settings">#hidden-element-panel{display:none!important;}</style>');
	//Hide deleted elements
	$('#ok-hide-hidden-ele-btn').hide();
	$('#ok-show-hidden-ele-btn').show();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
//Main Site Panel
let mainSitePanel = [];
mainSitePanel.push(`
<div id="setting-draggable" class="dragme-panel" dir="ltr">
	<div id="setting-draggableheader" class="dragme-header">
		<p class="dht"><i class="fas fa-cog"></i> &nbsp;&nbsp;<span class="setting-header">Global Settings</span>
		<span id="close-panel" class="integrations-close-btn float-right d-cursor"><i class="fas fa-times"></i></span></p>
	</div>
	<div class="draggable-wrap">
		<div class="draggable-content">
			<!-- ::START:: Global Colors -->
			<div class="setting-title">
				<p>Global Colors</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Set Colors</p>
							<center>
							<button id="gb-clra" class="bg-a global-clr-btn bdr-a" title="Main Color"></button>
							<button id="gb-clrb" class="bg-b global-clr-btn bdr-b"></button>
							<button id="gb-clrc" class="bg-c global-clr-btn bdr-c"></button>
							<button id="gb-clrd" class="bg-d global-clr-btn bdr-d"></button>
							<button id="gb-clre" class="bg-e global-clr-btn bdr-e"></button>
							<button id="gb-clrf" class="bg-f global-clr-btn bdr-f"></button>
							<button id="gb-clrg" class="bg-g global-clr-btn bdr-g"></button>
							<button id="gb-clrh" class="bg-h global-clr-btn bdr-h"></button>
							<button id="gb-clri" class="bg-i global-clr-btn bdr-i"></button>
							<button id="gb-clrj" class="bg-j global-clr-btn bdr-j"></button>
							<button id="gb-clrk" class="bg-k global-clr-btn bdr-k"></button>
							</center>
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Global Colors -->
			<!-- ::START:: Font Family -->
			<div class="setting-title">
				<p>Font Family</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="50%">
							<p class="font-a">Font A</p>
							<select id="font-style-a" class="ok-select-opt">
								<option value="1">Andada Pro</option>
								<option value="2">Anton</option>
								<option value="3">Archivo</option>
								<option value="4">BioRhyme</option>
								<option value="5">Concert One</option>
								<option value="6">Cormorant</option>
								<option value="7">Encode Sans</option>
								<option value="8">Epilogue</option>
								<option value="9">Hahmlet</option>
								<option value="10">Inter</option>
								<option value="11">JetBrains Mono</option>
								<option value="12">Lato</option>
								<option value="13">Lora</option>
								<option value="14">Manrope</option>
								<option value="15">Montserrat</option>
								<option value="16">Nunito</option>
								<option value="17">Old Standard TT</option>
								<option value="18">Open Sans</option>
								<option value="19">Oswald</option>
								<option value="20">Oxygen</option>
								<option value="21">Playfair Display</option>
								<option value="22">Poppins</option>
								<option value="23">Raleway</option>
								<option value="24">Roboto</option>
								<option value="25">Roboto Mono</option>
								<option value="26">Sora</option>
								<option value="27">Source Code Pro</option>
								<option value="28">Source Sans Pro</option>
								<option value="29">Spectral</option>
								<option value="30">Work Sans</option>
							</select>
						</td>
						<td width="50%">
							<p class="font-b">Font B</p>
							<select id="font-style-b" class="ok-select-opt">
								<option value="1">Andada Pro</option>
								<option value="2">Anton</option>
								<option value="3">Archivo</option>
								<option value="4">BioRhyme</option>
								<option value="5">Concert One</option>
								<option value="6">Cormorant</option>
								<option value="7">Encode Sans</option>
								<option value="8">Epilogue</option>
								<option value="9">Hahmlet</option>
								<option value="10">Inter</option>
								<option value="11">JetBrains Mono</option>
								<option value="12">Lato</option>
								<option value="13">Lora</option>
								<option value="14">Manrope</option>
								<option value="15">Montserrat</option>
								<option value="16">Nunito</option>
								<option value="17">Old Standard TT</option>
								<option value="18">Open Sans</option>
								<option value="19">Oswald</option>
								<option value="20">Oxygen</option>
								<option value="21">Playfair Display</option>
								<option value="22">Poppins</option>
								<option value="23">Raleway</option>
								<option value="24">Roboto</option>
								<option value="25">Roboto Mono</option>
								<option value="26">Sora</option>
								<option value="27">Source Code Pro</option>
								<option value="28">Source Sans Pro</option>
								<option value="29">Spectral</option>
								<option value="30">Work Sans</option>
							</select>
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Font Family -->
			<!-- ::START:: Preloading Settings -->
			<div class="preloading-control-panel">
			<div class="setting-title">
				<p>Preloading Settings</p>
			</div>
			<div class="settings">
				<div class="table-box color-table">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Preloader Preview</p>
							<div class="preloader-pre bg-b p-20">
								<div class="preloader-body">
									<div class="preloader-container">
									<div class="preloader-wheel bdr-a"></div>
									</div>
								</div>
							</div>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Background Color</p>
							<button class="main-bgcolor-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bgcolor-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bgcolor-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bgcolor-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bgcolor-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bgcolor-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bgcolor-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bgcolor-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bgcolor-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bgcolor-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bgcolor-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bgcolor-k bg-k global-clr-btn bdr-k"></button>
							<hr>
						</td>
					</tr>
					<tr>
						<td width="100%">
							<p>Ring Line Color</p>
							<button class="main-bdr-none global-clr-btn ban-clr-btn" title="None"></button>
							<button class="main-bdr-a bg-a global-clr-btn bdr-a"></button>
							<button class="main-bdr-b bg-b global-clr-btn bdr-b"></button>
							<button class="main-bdr-c bg-c global-clr-btn bdr-c"></button>
							<button class="main-bdr-d bg-d global-clr-btn bdr-d"></button>
							<button class="main-bdr-e bg-e global-clr-btn bdr-e"></button>
							<button class="main-bdr-f bg-f global-clr-btn bdr-f"></button>
							<button class="main-bdr-g bg-g global-clr-btn bdr-g"></button>
							<button class="main-bdr-h bg-h global-clr-btn bdr-h"></button>
							<button class="main-bdr-i bg-i global-clr-btn bdr-i"></button>
							<button class="main-bdr-j bg-j global-clr-btn bdr-j"></button>
							<button class="main-bdr-k bg-k global-clr-btn bdr-k"></button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: Preloading Settings -->
			<!-- ::START::Animation -->
			<div class="setting-title">
				<p>Animation</p>
			</div>
			<div class="settings">
				<div class="table-box" id="reveal-ani-switch">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Reveal Animation On Scroll</p>
							<button id="luge-on-btn" class="button-50">ON</button>
							<button id="luge-off-btn" class="button-50">OFF</button>
						</td>
					</tr>
				</table>
				</div>
				<div class="table-box" id="aos-ani-switch">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Animation On Scroll</p>
							<button id="aos-on-btn" class="button-50">ON</button>
							<button id="aos-off-btn" class="button-50">OFF</button>
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Animation -->
			<!-- ::START:: LTR/RTL -->
			<div id="ltr-rtl-panel">
			<div class="setting-title">
				<p>LTR/RTL Layout</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>LTR/RTL</p>
							<button id="ltr-on-btn" class="button-50">LTR</button>
							<button id="rtl-on-btn" class="button-50">RTL</button>
						</td>
					</tr>
				</table>
				</div>
			</div>
			</div><!-- ::END:: LTR/RTL -->
			<!-- ::START:: Analytics -->
			<div class="setting-title">
				<p>Google Analytics</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Google Analytics ID</p>
							<input class="input" id="google-analytics" type="text" placeholder="UA-XXXXXXXXX-X">
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Analytics -->
			<!-- ::START:: Facebook Chat Plugin -->
			<div class="setting-title">
				<p>Messenger Chat Plugin</p>
			</div>
			<div class="settings">
				<div class="table-box">					
				<table border="0" width="100%">
					<tr>
						<td width="100%">
							<p>Facebook Page ID</p>
							<input class="input" id="fb-messanger" type="text" placeholder="10XXXXXXXXXX88">
						</td>
					</tr>
				</table>
				</div>
			</div><!-- ::END:: Facebook Chat Plugin -->
		</div>
	</div>
</div>`);
document.getElementById("setting-panel").innerHTML = mainSitePanel.join("");

//For Preloading
if($("#body-data .ok-preloader").length>0){
	$('.preloading-control-panel').show();
}else{
	$('.preloading-control-panel').hide();	
}

//Check Reveal Luge
if($('body').hasClass('luge-on')){
	$('#luge-on-btn').addClass('bg-primary white');
	$('#aos-ani-switch').hide();
}else{
	$('#luge-off-btn').addClass('bg-primary white');
	$('#aos-ani-switch').show();
}
//For Reveal Luge
$(document).on('click', '#luge-on-btn', function() {
	$(this).addClass('bg-primary white');
	$('body').addClass('luge-on');
	$('#luge-off-btn').removeClass('bg-primary white');
	$('#aos-ani-switch').hide();
});
$(document).on('click', '#luge-off-btn', function() {
	$(this).addClass('bg-primary white');
	$('body').removeClass('luge-on');
	$('#luge-on-btn').removeClass('bg-primary white');
	$('#aos-ani-switch').show();
});

//Check AOS
if($('body').hasClass('aos-on')){
	$('#aos-on-btn').addClass('bg-primary white');
	$('#reveal-ani-switch').hide();
}else{
	$('#aos-off-btn').addClass('bg-primary white');
	$('#reveal-ani-switch').show();
}
//For AOS
$(document).on('click', '#aos-on-btn', function() {
	$(this).addClass('bg-primary white');
	$('body').addClass('aos-on');
	$('#aos-off-btn').removeClass('bg-primary white');
	$('#reveal-ani-switch').hide();
});
$(document).on('click', '#aos-off-btn', function() {
	$(this).addClass('bg-primary white');
	$('body').removeClass('aos-on');
	$('#aos-on-btn').removeClass('bg-primary white');
	$('#reveal-ani-switch').show();
});

//Check LTR/RTL
if($('body').hasClass('rtl-on')){
	$('#rtl-on-btn').addClass('bg-primary white');
}else{
	$('#ltr-on-btn').addClass('bg-primary white');
}
//For LTR/RTL
$(document).on('click', '#ltr-on-btn', function() {
	$(this).addClass('bg-primary white');
	$('body').removeClass('rtl-on');
	$('#rtl-on-btn').removeClass('bg-primary white');
	$('#bootstrap-css').remove();
	$('<link id="bootstrap-css" href="assets/css/bootstrap.min.css" rel="stylesheet">').insertAfter('title');
	$('html').attr('lang', 'en');
	$('html').removeAttr('dir');
});
$(document).on('click', '#rtl-on-btn', function() {
	$(this).addClass('bg-primary white');
	$('body').addClass('rtl-on');
	$('#ltr-on-btn').removeClass('bg-primary white');
	$('#bootstrap-css').remove();
	$('<link id="bootstrap-css" href="assets/css/bootstrap.rtl.min.css" rel="stylesheet">').insertAfter('title');
	$('html').attr('lang', 'ar');
	$('html').attr('dir', 'rtl');
	//$('.ok-column').removeClass('text-start text-center text-end text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end');
});

//Check Font A Style
if($("#font-a-db").attr('data-fa-value') == '1'){
	$("#font-style-a option[value=1]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '2'){
	$("#font-style-a option[value=2]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '3'){
	$("#font-style-a option[value=3]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '4'){
	$("#font-style-a option[value=4]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '5'){
	$("#font-style-a option[value=5]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '6'){
	$("#font-style-a option[value=6]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '7'){
	$("#font-style-a option[value=7]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '8'){
	$("#font-style-a option[value=8]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '9'){
	$("#font-style-a option[value=9]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '10'){
	$("#font-style-a option[value=10]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '11'){
	$("#font-style-a option[value=11]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '12'){
	$("#font-style-a option[value=12]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '13'){
	$("#font-style-a option[value=13]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '14'){
	$("#font-style-a option[value=14]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '15'){
	$("#font-style-a option[value=15]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '16'){
	$("#font-style-a option[value=16]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '17'){
	$("#font-style-a option[value=17]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '18'){
	$("#font-style-a option[value=18]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '19'){
	$("#font-style-a option[value=19]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '20'){
	$("#font-style-a option[value=20]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '21'){
	$("#font-style-a option[value=21]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '22'){
	$("#font-style-a option[value=22]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '23'){
	$("#font-style-a option[value=23]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '24'){
	$("#font-style-a option[value=24]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '25'){
	$("#font-style-a option[value=25]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '26'){
	$("#font-style-a option[value=26]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '27'){
	$("#font-style-a option[value=27]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '28'){
	$("#font-style-a option[value=28]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '29'){
	$("#font-style-a option[value=29]").attr('selected','selected');
}
if($("#font-a-db").attr('data-fa-value') == '30'){
	$("#font-style-a option[value=30]").attr('selected','selected');
}
//Check Font B Style
if($("#font-b-db").attr('data-fb-value') == '1'){
	$("#font-style-b option[value=1]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '2'){
	$("#font-style-b option[value=2]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '3'){
	$("#font-style-b option[value=3]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '4'){
	$("#font-style-b option[value=4]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '5'){
	$("#font-style-b option[value=5]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '6'){
	$("#font-style-b option[value=6]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '7'){
	$("#font-style-b option[value=7]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '8'){
	$("#font-style-b option[value=8]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '9'){
	$("#font-style-b option[value=9]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '10'){
	$("#font-style-b option[value=10]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '11'){
	$("#font-style-b option[value=11]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '12'){
	$("#font-style-b option[value=12]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '13'){
	$("#font-style-b option[value=13]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '14'){
	$("#font-style-b option[value=14]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '15'){
	$("#font-style-b option[value=15]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '16'){
	$("#font-style-b option[value=16]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '17'){
	$("#font-style-b option[value=17]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '18'){
	$("#font-style-b option[value=18]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '19'){
	$("#font-style-b option[value=19]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '20'){
	$("#font-style-b option[value=20]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '21'){
	$("#font-style-b option[value=21]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '22'){
	$("#font-style-b option[value=22]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '23'){
	$("#font-style-b option[value=23]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '24'){
	$("#font-style-b option[value=24]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '25'){
	$("#font-style-b option[value=25]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '26'){
	$("#font-style-b option[value=26]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '27'){
	$("#font-style-b option[value=27]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '28'){
	$("#font-style-b option[value=28]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '29'){
	$("#font-style-b option[value=29]").attr('selected','selected');
}
if($("#font-b-db").attr('data-fb-value') == '30'){
	$("#font-style-b option[value=30]").attr('selected','selected');
}

//Clear format text from clipboard script
$('[contenteditable]').on('paste', function (e) {
    e.preventDefault();
	e.stopImmediatePropagation();
   let clearTextFormat = event.clipboardData.getData('text/plain');
	document.execCommand('inserttext', false, clearTextFormat);
});
//Get default GA value
$('#google-analytics').val($('#google-analytics-id').text());
//Get Google Analytics ID
$(document).on('input', '#google-analytics', function() {
	$('#ok-db #google-analytics-id').remove();
	$('#ok-db').append('<p id="google-analytics-id" class="hide-this-db">'+this.value+'</p>');
});
//Get default FB Chat value
$('#fb-messanger').val($('#fb-messanger-id').text());
//Get FB Chat ID
$(document).on('input', '#fb-messanger', function() {
	$('#ok-db #fb-messanger-id').remove();
	$('#ok-db').append('<p id="fb-messanger-id" class="hide-this-db">'+this.value+'</p>');
});
//Global Color A
let aGlobalColor = $("#gb-clra");
let aPreColor;
let aChangeColor = false;
aGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-a").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-a">\n' 
			+'::selection {background: '+tinycolor+'; color: #ffffff;}\n '
			+'::-moz-selection {background: '+tinycolor+'; color: #ffffff;}\n '
			+' a {color: '+tinycolor+';}\n '
			+' .active {color: '+tinycolor+'!important;}\n '
			+' .sticky .active {color: '+tinycolor+'!important;}\n '
			+' .color-a {color: '+tinycolor+';}\n '
			+' .bg-a {background: '+tinycolor+';}\n '
			+' .bg-a.open {background: '+tinycolor+';}\n '
			+' .bdr-a {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-a:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-a:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-a:hover {background: '+tinycolor+';}\n '
			+' .ds-a {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-a:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	},
   show: function(tinycolor) {
       aChangeColor = false;
       aPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!aChangeColor && aPreColor) {		
		$("#ok-db #db-clr-a").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-a">\n' 
			+'::selection {background: '+tinycolor+'; color: #ffffff;}\n '
			+'::-moz-selection {background: '+tinycolor+'; color: #ffffff;}\n '
			+' a {color: '+tinycolor+';}\n '
			+' .active {color: '+tinycolor+'!important;}\n '
			+' .sticky .active {color: '+tinycolor+'!important;}\n '
			+' .color-a {color: '+tinycolor+';}\n '
			+' .bg-a {background: '+tinycolor+';}\n '
			+' .bg-a.open {background: '+tinycolor+';}\n '
			+' .bdr-a {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-a:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-a:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-a:hover {background: '+tinycolor+';}\n '
			+' .ds-a {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-a:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       aChangeColor = true;		
		$("#ok-db #db-clr-a").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-a">\n' 
			+'::selection {background: '+tinycolor+'; color: #ffffff;}\n '
			+'::-moz-selection {background: '+tinycolor+'; color: #ffffff;}\n '
			+' a {color: '+tinycolor+';}\n '
			+' .active {color: '+tinycolor+'!important;}\n '
			+' .sticky .active {color: '+tinycolor+'!important;}\n '
			+' .color-a {color: '+tinycolor+';}\n '
			+' .bg-a {background: '+tinycolor+';}\n '
			+' .bg-a.open {background: '+tinycolor+';}\n '
			+' .bdr-a {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-a:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-a:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-a:hover {background: '+tinycolor+';}\n '
			+' .ds-a {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-a:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color B
let bGlobalColor = $("#gb-clrb");
let bPreColor;
let bChangeColor = false;
bGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-b").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-b">\n'
			+' .color-b {color: '+tinycolor+';}\n '
			+' .bg-b {background: '+tinycolor+';}\n '
			+' .bg-b.open {background: '+tinycolor+';}\n '
			+' .bdr-b {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-b:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-b:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-b:hover {background: '+tinycolor+';}\n '
			+' .ds-b {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-b:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       bChangeColor = false;
       bPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!bChangeColor && bPreColor) {		
		$("#ok-db #db-clr-b").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-b">\n'
			+' .color-b {color: '+tinycolor+';}\n '
			+' .bg-b {background: '+tinycolor+';}\n '
			+' .bg-b.open {background: '+tinycolor+';}\n '
			+' .bdr-b {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-b:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-b:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-b:hover {background: '+tinycolor+';}\n '
			+' .ds-b {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-b:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       bChangeColor = true;		
		$("#ok-db #db-clr-b").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-b">\n'
			+' .color-b {color: '+tinycolor+';}\n '
			+' .bg-b {background: '+tinycolor+';}\n '
			+' .bg-b.open {background: '+tinycolor+';}\n '
			+' .bdr-b {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-b:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-b:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-b:hover {background: '+tinycolor+';}\n '
			+' .ds-b {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-b:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color C
let cGlobalColor = $("#gb-clrc");
let cPreColor;
let cChangeColor = false;
cGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-c").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-c">\n'
			+' .color-c {color: '+tinycolor+';}\n '
			+' .bg-c {background: '+tinycolor+';}\n '
			+' .bg-c.open {background: '+tinycolor+';}\n '
			+' .bdr-c {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-c:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-c:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-c:hover {background: '+tinycolor+';}\n '
			+' .ds-c {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-c:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       cChangeColor = false;
       cPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!cChangeColor && cPreColor) {		
		$("#ok-db #db-clr-c").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-c">\n'
			+' .color-c {color: '+tinycolor+';}\n '
			+' .bg-c {background: '+tinycolor+';}\n '
			+' .bg-c.open {background: '+tinycolor+';}\n '
			+' .bdr-c {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-c:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-c:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-c:hover {background: '+tinycolor+';}\n '
			+' .ds-c {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-c:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       cChangeColor = true;		
		$("#ok-db #db-clr-c").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-c">\n'
			+' .color-c {color: '+tinycolor+';}\n '
			+' .bg-c {background: '+tinycolor+';}\n '
			+' .bg-c.open {background: '+tinycolor+';}\n '
			+' .bdr-c {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-c:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-c:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-c:hover {background: '+tinycolor+';}\n '
			+' .ds-c {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-c:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color D
let dGlobalColor = $("#gb-clrd");
let dPreColor;
let dChangeColor = false;
dGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-d").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-d">\n'
			+' .color-d {color: '+tinycolor+';}\n '
			+' .bg-d {background: '+tinycolor+';}\n '
			+' .bg-d.open {background: '+tinycolor+';}\n '
			+' .bdr-d {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-d:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-d:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-d:hover {background: '+tinycolor+';}\n '
			+' .ds-d {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-d:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       dChangeColor = false;
       dPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!dChangeColor && dPreColor) {		
		$("#ok-db #db-clr-d").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-d">\n'
			+' .color-d {color: '+tinycolor+';}\n '
			+' .bg-d {background: '+tinycolor+';}\n '
			+' .bg-d.open {background: '+tinycolor+';}\n '
			+' .bdr-d {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-d:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-d:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-d:hover {background: '+tinycolor+';}\n '
			+' .ds-d {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-d:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       dChangeColor = true;		
		$("#ok-db #db-clr-d").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-d">\n'
			+' .color-d {color: '+tinycolor+';}\n '
			+' .bg-d {background: '+tinycolor+';}\n '
			+' .bg-d.open {background: '+tinycolor+';}\n '
			+' .bdr-d {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-d:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-d:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-d:hover {background: '+tinycolor+';}\n '
			+' .ds-d {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-d:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color E
let eGlobalColor = $("#gb-clre");
let ePreColor;
let eChangeColor = false;
eGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-e").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-e">\n'
			+' .color-e {color: '+tinycolor+';}\n '
			+' .bg-e {background: '+tinycolor+';}\n '
			+' .bg-e.open {background: '+tinycolor+';}\n '
			+' .bdr-e {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-e:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-e:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-e:hover {background: '+tinycolor+';}\n '
			+' .ds-e {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-e:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       eChangeColor = false;
       ePreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!eChangeColor && ePreColor) {		
		$("#ok-db #db-clr-e").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-e">\n'
			+' .color-e {color: '+tinycolor+';}\n '
			+' .bg-e {background: '+tinycolor+';}\n '
			+' .bg-e.open {background: '+tinycolor+';}\n '
			+' .bdr-e {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-e:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-e:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-e:hover {background: '+tinycolor+';}\n '
			+' .ds-e {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-e:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');	
		}
	},
   change: function(tinycolor) {
       eChangeColor = true;		
		$("#ok-db #db-clr-e").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-e">\n'
			+' .color-e {color: '+tinycolor+';}\n '
			+' .bg-e {background: '+tinycolor+';}\n '
			+' .bg-e.open {background: '+tinycolor+';}\n '
			+' .bdr-e {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-e:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-e:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-e:hover {background: '+tinycolor+';}\n '
			+' .ds-e {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-e:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');	
	}
});
//Global Color F
let fGlobalColor = $("#gb-clrf");
let fPreColor;
let fChangeColor = false;
fGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-f").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-f">\n'
			+' .color-f {color: '+tinycolor+';}\n '
			+' .bg-f {background: '+tinycolor+';}\n '
			+' .bg-f.open {background: '+tinycolor+';}\n '
			+' .bdr-f {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-f:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-f:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-f:hover {background: '+tinycolor+';}\n '
			+' .ds-f {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-f:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       fChangeColor = false;
       fPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!fChangeColor && fPreColor) {		
		$("#ok-db #db-clr-f").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-f">\n'
			+' .color-f {color: '+tinycolor+';}\n '
			+' .bg-f {background: '+tinycolor+';}\n '
			+' .bg-f.open {background: '+tinycolor+';}\n '
			+' .bdr-f {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-f:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-f:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-f:hover {background: '+tinycolor+';}\n '
			+' .ds-f {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-f:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');	
		}
	},
   change: function(tinycolor) {
       fChangeColor = true;		
		$("#ok-db #db-clr-f").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-f">\n'
			+' .color-f {color: '+tinycolor+';}\n '
			+' .bg-f {background: '+tinycolor+';}\n '
			+' .bg-f.open {background: '+tinycolor+';}\n '
			+' .bdr-f {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-f:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-f:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-f:hover {background: '+tinycolor+';}\n '
			+' .ds-f {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-f:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');	
	}
});
//Global Color G
let gGlobalColor = $("#gb-clrg");
let gPreColor;
let gChangeColor = false;
gGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-g").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-g">\n'
			+' .color-g {color: '+tinycolor+';}\n '
			+' .bg-g {background: '+tinycolor+';}\n '
			+' .bg-g.open {background: '+tinycolor+';}\n '
			+' .bdr-g {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-g:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-g:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-g:hover {background: '+tinycolor+';}\n '
			+' .ds-g {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-g:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       gChangeColor = false;
       gPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!gChangeColor && gPreColor) {		
		$("#ok-db #db-clr-g").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-g">\n'
			+' .color-g {color: '+tinycolor+';}\n '
			+' .bg-g {background: '+tinycolor+';}\n '
			+' .bg-g.open {background: '+tinycolor+';}\n '
			+' .bdr-g {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-g:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-g:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-g:hover {background: '+tinycolor+';}\n '
			+' .ds-g {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-g:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       gChangeColor = true;		
		$("#ok-db #db-clr-g").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-g">\n'
			+' .color-g {color: '+tinycolor+';}\n '
			+' .bg-g {background: '+tinycolor+';}\n '
			+' .bg-g.open {background: '+tinycolor+';}\n '
			+' .bdr-g {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-g:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-g:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-g:hover {background: '+tinycolor+';}\n '
			+' .ds-g {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-g:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color H
let hGlobalColor = $("#gb-clrh");
let hPreColor;
let hChangeColor = false;
hGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-h").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-h">\n'
			+' .color-h {color: '+tinycolor+';}\n '
			+' .bg-h {background: '+tinycolor+';}\n '
			+' .bg-h.open {background: '+tinycolor+';}\n '
			+' .bdr-h {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-h:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-h:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-h:hover {background: '+tinycolor+';}\n '
			+' .ds-h {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-h:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       hChangeColor = false;
       hPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!hChangeColor && hPreColor) {		
		$("#ok-db #db-clr-h").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-h">\n'
			+' .color-h {color: '+tinycolor+';}\n '
			+' .bg-h {background: '+tinycolor+';}\n '
			+' .bg-h.open {background: '+tinycolor+';}\n '
			+' .bdr-h {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-h:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-h:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-h:hover {background: '+tinycolor+';}\n '
			+' .ds-h {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-h:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       hChangeColor = true;		
		$("#ok-db #db-clr-h").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-h">\n'
			+' .color-h {color: '+tinycolor+';}\n '
			+' .bg-h {background: '+tinycolor+';}\n '
			+' .bg-h.open {background: '+tinycolor+';}\n '
			+' .bdr-h {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-h:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-h:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-h:hover {background: '+tinycolor+';}\n '
			+' .ds-h {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-h:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color I
let iGlobalColor = $("#gb-clri");
let iPreColor;
let iChangeColor = false;
iGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-i").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-i">\n'
			+' .color-i {color: '+tinycolor+';}\n '
			+' .bg-i {background: '+tinycolor+';}\n '
			+' .bg-i.open {background: '+tinycolor+';}\n '
			+' .bdr-i {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-i:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-i:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-i:hover {background: '+tinycolor+';}\n '
			+' .ds-i {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-i:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       iChangeColor = false;
       iPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!iChangeColor && iPreColor) {		
		$("#ok-db #db-clr-i").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-i">\n'
			+' .color-i {color: '+tinycolor+';}\n '
			+' .bg-i {background: '+tinycolor+';}\n '
			+' .bg-i.open {background: '+tinycolor+';}\n '
			+' .bdr-i {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-i:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-i:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-i:hover {background: '+tinycolor+';}\n '
			+' .ds-i {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-i:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       iChangeColor = true;		
		$("#ok-db #db-clr-i").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-i">\n'
			+' .color-i {color: '+tinycolor+';}\n '
			+' .bg-i {background: '+tinycolor+';}\n '
			+' .bg-i.open {background: '+tinycolor+';}\n '
			+' .bdr-i {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-i:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-i:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-i:hover {background: '+tinycolor+';}\n '
			+' .ds-i {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-i:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color J
let jGlobalColor = $("#gb-clrj");
let jPreColor;
let jChangeColor = false;
jGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-j").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-j">\n'
			+' .color-j {color: '+tinycolor+';}\n '
			+' .bg-j {background: '+tinycolor+';}\n '
			+' .bg-j.open {background: '+tinycolor+';}\n '
			+' .bdr-j {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-j:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-j:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-j:hover {background: '+tinycolor+';}\n '
			+' .ds-j {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-j:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       jChangeColor = false;
       jPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!jChangeColor && jPreColor) {		
		$("#ok-db #db-clr-j").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-j">\n'
			+' .color-j {color: '+tinycolor+';}\n '
			+' .bg-j {background: '+tinycolor+';}\n '
			+' .bg-j.open {background: '+tinycolor+';}\n '
			+' .bdr-j {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-j:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-j:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-j:hover {background: '+tinycolor+';}\n '
			+' .ds-j {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-j:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       jChangeColor = true;		
		$("#ok-db #db-clr-j").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-j">\n'
			+' .color-j {color: '+tinycolor+';}\n '
			+' .bg-j {background: '+tinycolor+';}\n '
			+' .bg-j.open {background: '+tinycolor+';}\n '
			+' .bdr-j {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-j:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-j:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-j:hover {background: '+tinycolor+';}\n '
			+' .ds-j {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-j:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});
//Global Color K
let kGlobalColor = $("#gb-clrk");
let kPreColor;
let kChangeColor = false;
kGlobalColor.spectrum({
	containerClassName: "color-box",
	showAlpha: true,
	showInput: true,
	showButtons: false,
	preferredFormat: "hex",
	move: function(tinycolor) {		
		$("#ok-db #db-clr-k").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-k">\n'
			+' .color-k {color: '+tinycolor+';}\n '
			+' .bg-k {background: '+tinycolor+';}\n '
			+' .bg-k.open {background: '+tinycolor+';}\n '
			+' .bdr-k {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-k:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-k:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-k:hover {background: '+tinycolor+';}\n '
			+' .ds-k {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-k:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');		
	},
   show: function(tinycolor) {
       kChangeColor = false;
       kPreColor = tinycolor;
   },
   hide: function(tinycolor) {
       if (!kChangeColor && kPreColor) {		
		$("#ok-db #db-clr-k").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-k">\n'
			+' .color-k {color: '+tinycolor+';}\n '
			+' .bg-k {background: '+tinycolor+';}\n '
			+' .bg-k.open {background: '+tinycolor+';}\n '
			+' .bdr-k {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-k:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-k:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-k:hover {background: '+tinycolor+';}\n '
			+' .ds-k {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-k:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
		}
	},
   change: function(tinycolor) {
       kChangeColor = true;		
		$("#ok-db #db-clr-k").remove();//Remove duplicate
		$("#ok-db").append(''
			+' <style id="db-clr-k">\n'
			+' .color-k {color: '+tinycolor+';}\n '
			+' .bg-k {background: '+tinycolor+';}\n '
			+' .bg-k.open {background: '+tinycolor+';}\n '
			+' .bdr-k {border-color: '+tinycolor+'!important;} \n'
			+' .hov-bdr-k:hover {border-color: '+tinycolor+'!important;} \n'
			+' .hov-color-k:hover {color: '+tinycolor+';}\n '
			+' .hov-bg-k:hover {background: '+tinycolor+';}\n '
			+' .ds-k {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+' .hov-ds-k:hover {filter: drop-shadow(0px 0px 5px '+tinycolor+');}\n '
			+'</style>');
	}
});

//Set Font Style A
$(document).on('change', '#font-style-a', function(){
	$('head').find('#font-a').remove();
	$('#ok-db').find('#font-a-db').remove();
	if (this.value === "1") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Andada+Pro:ital,wght@0,400;0,500;0,600;0,700;0,800;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="1">
		 body, .font-a {font-family: 'Andada Pro', serif!important;}
		</style>`);
	}
	if (this.value === "2") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Anton&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="2">
		 body, .font-a {font-family: 'Anton', sans-serif!important;}
		</style>`);
	}
	if (this.value === "3") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Archivo:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="3">
		 body, .font-a {font-family: 'Archivo', sans-serif!important;}
		</style>`);
	}
	if (this.value === "4") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=BioRhyme:wght@200;300;400;700;800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="4">
		 body, .font-a {font-family: 'BioRhyme', serif!important;}
		</style>`);
	}
	if (this.value === "5") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Concert+One&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="5">
		 body, .font-a {font-family: 'Concert One', cursive!important;}
		</style>`);
	}
	if (this.value === "6") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Cormorant:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="6">
		 body, .font-a {font-family: 'Cormorant', serif!important;}
		</style>`);
	}
	if (this.value === "7") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="7">
		 body, .font-a {font-family: 'Encode Sans', sans-serif!important;}
		</style>`);
	}
	if (this.value === "8") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Epilogue:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="8">
		 body, .font-a {font-family: 'Epilogue', sans-serif!important;}
		</style>`);
	}
	if (this.value === "9") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Hahmlet:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="9">
		 body, .font-a {font-family: 'Hahmlet', serif!important;}
		</style>`);
	}
	if (this.value === "10") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="10">
		 body, .font-a {font-family: 'Inter', sans-serif!important;}
		</style>`);
	}
	if (this.value === "11") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="11">
		 body, .font-a {font-family: 'JetBrains Mono', monospace!important;}
		</style>`);
	}
	if (this.value === "12") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="12">
		 body, .font-a {font-family: 'Lato', sans-serif!important;}
		</style>`);
	}
	if (this.value === "13") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="13">
		 body, .font-a {font-family: 'Lora', serif!important;}
		</style>`);
	}
	if (this.value === "14") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Manrope:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="14">
		 body, .font-a {font-family: 'Manrope', sans-serif!important;}
		</style>`);
	}
	if (this.value === "15") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="15">
		 body, .font-a {font-family: 'Montserrat', sans-serif!important;}
		</style>`);
	}
	if (this.value === "16") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200;0,300;0,400;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="16">
		 body, .font-a {font-family: 'Nunito', sans-serif!important;}
		</style>`);
	}
	if (this.value === "17") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:ital,wght@0,400;0,700;1,400&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="17">
		 body, .font-a {font-family: 'Old Standard TT', serif!important;}
		</style>`);
	}
	if (this.value === "18") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="18">
		 body, .font-a {font-family: 'Open Sans', sans-serif!important;}
		</style>`);
	}
	if (this.value === "19") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Oswald:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="19">
		 body, .font-a {font-family: 'Oswald', sans-serif!important;}
		</style>`);
	}
	if (this.value === "20") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Oxygen:wght@300;400;700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="20">
		 body, .font-a {font-family: 'Oxygen', sans-serif!important;}
		</style>`);
	}
	if (this.value === "21") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="21">
		 body, .font-a {font-family: 'Playfair Display', serif!important;}
		</style>`);
	}
	if (this.value === "22") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="22">
		 body, .font-a {font-family: 'Poppins', sans-serif!important;}
		</style>`);
	}
	if (this.value === "23") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="23">
		 body, .font-a {font-family: 'Raleway', sans-serif!important;}
		</style>`);
	}
	if (this.value === "24") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="24">
		 body, .font-a {font-family: 'Roboto', sans-serif!important;}
		</style>`);
	}
	if (this.value === "25") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Roboto+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="25">
		 body, .font-a {font-family: 'Roboto Mono', monospace!important;}
		</style>`);
	}
	if (this.value === "26") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Sora:wght@100;200;300;400;500;600;700;800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="26">
		 body, .font-a {font-family: 'Sora', sans-serif!important;}
		</style>`);
	}
	if (this.value === "27") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="27">
		 body, .font-a {font-family: 'Source Code Pro', monospace!important;}
		</style>`);
	}
	if (this.value === "28") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="28">
		 body, .font-a {font-family: 'Source Sans Pro', sans-serif!important;}
		</style>`);
	}
	if (this.value === "29") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Spectral:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="29">
		 body, .font-a {font-family: 'Spectral', serif!important;}
		</style>`);
	}
	if (this.value === "30") {
		$('head').append('<link id="font-a" href="https://fonts.googleapis.com/css2?family=Work+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-a-db" data-fa-value="30">
		 body, .font-a {font-family: 'Work Sans', sans-serif!important;}
		</style>`);
	}
});

//Set Font Style B
$(document).on('change', '#font-style-b', function(){
	$('head').find('#font-b').remove();
	$('#ok-db').find('#font-b-db').remove();
	if (this.value === "1") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Andada+Pro:ital,wght@0,400;0,500;0,600;0,700;0,800;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="1">
		 .font-b {font-family: 'Andada Pro', serif!important;}
		</style>`);
	}
	if (this.value === "2") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Anton&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="2">
		 .font-b {font-family: 'Anton', sans-serif!important;}
		</style>`);
	}
	if (this.value === "3") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Archivo:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="3">
		 .font-b {font-family: 'Archivo', sans-serif!important;}
		</style>`);
	}
	if (this.value === "4") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=BioRhyme:wght@200;300;400;700;800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="4">
		 .font-b {font-family: 'BioRhyme', serif!important;}
		</style>`);
	}
	if (this.value === "5") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Concert+One&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="5">
		 .font-b {font-family: 'Concert One', cursive!important;}
		</style>`);
	}
	if (this.value === "6") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Cormorant:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="6">
		 .font-b {font-family: 'Cormorant', serif!important;}
		</style>`);
	}
	if (this.value === "7") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="7">
		 .font-b {font-family: 'Encode Sans', sans-serif!important;}
		</style>`);
	}
	if (this.value === "8") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Epilogue:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="8">
		 .font-b {font-family: 'Epilogue', sans-serif!important;}
		</style>`);
	}
	if (this.value === "9") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Hahmlet:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="9">
		 .font-b {font-family: 'Hahmlet', serif!important;}
		</style>`);
	}
	if (this.value === "10") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="10">
		 .font-b {font-family: 'Inter', sans-serif!important;}
		</style>`);
	}
	if (this.value === "11") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="11">
		 .font-b {font-family: 'JetBrains Mono', monospace!important;}
		</style>`);
	}
	if (this.value === "12") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="12">
		 .font-b {font-family: 'Lato', sans-serif!important;}
		</style>`);
	}
	if (this.value === "13") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="13">
		 .font-b {font-family: 'Lora', serif!important;}
		</style>`);
	}
	if (this.value === "14") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Manrope:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="14">
		 .font-b {font-family: 'Manrope', sans-serif!important;}
		</style>`);
	}
	if (this.value === "15") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="15">
		 .font-b {font-family: 'Montserrat', sans-serif!important;}
		</style>`);
	}
	if (this.value === "16") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200;0,300;0,400;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="16">
		 .font-b {font-family: 'Nunito', sans-serif!important;}
		</style>`);
	}
	if (this.value === "17") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Old+Standard+TT:ital,wght@0,400;0,700;1,400&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="17">
		 .font-b {font-family: 'Old Standard TT', serif!important;}
		</style>`);
	}
	if (this.value === "18") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="18">
		 .font-b {font-family: 'Open Sans', sans-serif!important;}
		</style>`);
	}
	if (this.value === "19") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Oswald:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="19">
		 .font-b {font-family: 'Oswald', sans-serif!important;}
		</style>`);
	}
	if (this.value === "20") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Oxygen:wght@300;400;700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="20">
		 .font-b {font-family: 'Oxygen', sans-serif!important;}
		</style>`);
	}
	if (this.value === "21") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="21">
		 .font-b {font-family: 'Playfair Display', serif!important;}
		</style>`);
	}
	if (this.value === "22") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="22">
		 .font-b {font-family: 'Poppins', sans-serif!important;}
		</style>`);
	}
	if (this.value === "23") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="23">
		 .font-b {font-family: 'Raleway', sans-serif!important;}
		</style>`);
	}
	if (this.value === "24") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="24">
		 .font-b {font-family: 'Roboto', sans-serif!important;}
		</style>`);
	}
	if (this.value === "25") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Roboto+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="25">
		 .font-b {font-family: 'Roboto Mono', monospace!important;}
		</style>`);
	}
	if (this.value === "26") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Sora:wght@100;200;300;400;500;600;700;800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="26">
		 .font-b {font-family: 'Sora', sans-serif!important;}
		</style>`);
	}
	if (this.value === "27") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="27">
		 .font-b {font-family: 'Source Code Pro', monospace!important;}
		</style>`);
	}
	if (this.value === "28") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="28">
		 .font-b {font-family: 'Source Sans Pro', sans-serif!important;}
		</style>`);
	}
	if (this.value === "29") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Spectral:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="29">
		 .font-b {font-family: 'Spectral', serif!important;}
		</style>`);
	}
	if (this.value === "30") {
		$('head').append('<link id="font-b" href="https://fonts.googleapis.com/css2?family=Work+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">\n');
		$('#ok-db').append(`
		<style id="font-b-db" data-fb-value="30">
		 .font-b {font-family: 'Work Sans', sans-serif!important;}
		</style>`);
	}
});

});//END:: Site Integrations

//Nav Link Color Settings
$(document).on('click', '#drop-color-none', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
});
$(document).on('click', '#drop-color-a', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-a');
});
$(document).on('click', '#drop-color-b', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-b');
});
$(document).on('click', '#drop-color-c', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-c');
});
$(document).on('click', '#drop-color-d', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-d');
});
$(document).on('click', '#drop-color-e', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-e');
});
$(document).on('click', '#drop-color-f', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-f');
});
$(document).on('click', '#drop-color-g', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-g');
});
$(document).on('click', '#drop-color-h', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-h');
});
$(document).on('click', '#drop-color-i', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-i');
});
$(document).on('click', '#drop-color-j', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-j');
});
$(document).on('click', '#drop-color-k', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('color-k');
});
//Nav Link Hover Color Settings
$(document).on('click', '#drop-hover-color-none', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
});
$(document).on('click', '#drop-hover-color-a', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-a');
});
$(document).on('click', '#drop-hover-color-b', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-b');
});
$(document).on('click', '#drop-hover-color-c', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-c');
});
$(document).on('click', '#drop-hover-color-d', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-d');
});
$(document).on('click', '#drop-hover-color-e', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-e');
});
$(document).on('click', '#drop-hover-color-f', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-f');
});
$(document).on('click', '#drop-hover-color-g', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-g');
});
$(document).on('click', '#drop-hover-color-h', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-h');
});
$(document).on('click', '#drop-hover-color-i', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-i');
});
$(document).on('click', '#drop-hover-color-j', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-j');
});
$(document).on('click', '#drop-hover-color-k', function(){
	$('#ok-section-wrap .navbar-nav').find('a').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	$('#ok-section-wrap .navbar-nav').find('a').addClass('hov-color-k');
});
//Dropdown and Offcanvas Background Color Settings
$(document).on('click', '#drop-bgcolor-none', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
});
$(document).on('click', '#drop-bgcolor-a', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-a');
});
$(document).on('click', '#drop-bgcolor-b', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-b');
});
$(document).on('click', '#drop-bgcolor-c', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-c');
});
$(document).on('click', '#drop-bgcolor-d', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-d');
});
$(document).on('click', '#drop-bgcolor-e', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-e');
});
$(document).on('click', '#drop-bgcolor-f', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-f');
});
$(document).on('click', '#drop-bgcolor-g', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-g');
});
$(document).on('click', '#drop-bgcolor-h', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-h');
});
$(document).on('click', '#drop-bgcolor-i', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-i');
});
$(document).on('click', '#drop-bgcolor-j', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-j');
});
$(document).on('click', '#drop-bgcolor-k', function(){
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.dropdown-menu, .offcanvas-collapse').addClass('bg-k');
});
//Menu Button Color Settings
$(document).on('click', '#menu-color-none', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
});
$(document).on('click', '#menu-color-a', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-a');
});
$(document).on('click', '#menu-color-b', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-b');
});
$(document).on('click', '#menu-color-c', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-c');
});
$(document).on('click', '#menu-color-d', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-d');
});
$(document).on('click', '#menu-color-e', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-e');
});
$(document).on('click', '#menu-color-f', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-f');
});
$(document).on('click', '#menu-color-g', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-g');
});
$(document).on('click', '#menu-color-h', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-h');
});
$(document).on('click', '#menu-color-i', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-i');
});
$(document).on('click', '#menu-color-j', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-j');
});
$(document).on('click', '#menu-color-k', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('color-k');
});
//Menu Button Background Color Settings
$(document).on('click', '#menu-bg-color-none', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
});
$(document).on('click', '#menu-bg-color-a', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-a');
});
$(document).on('click', '#menu-bg-color-b', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-b');
});
$(document).on('click', '#menu-bg-color-c', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-c');
});
$(document).on('click', '#menu-bg-color-d', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-d');
});
$(document).on('click', '#menu-bg-color-e', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-e');
});
$(document).on('click', '#menu-bg-color-f', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-f');
});
$(document).on('click', '#menu-bg-color-g', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-g');
});
$(document).on('click', '#menu-bg-color-h', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-h');
});
$(document).on('click', '#menu-bg-color-i', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-i');
});
$(document).on('click', '#menu-bg-color-j', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-j');
});
$(document).on('click', '#menu-bg-color-k', function(){
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap, #menu-button-wrap').find('.navbar-toggler, .menu-prev').addClass('bg-k');
});

//Border Radius
$(document).on('click', '.border-radius-control-panel', function(){
	if($('#ok-card-wrap, #ok-link-wrap, #ok-icode-wrap').find('.ok-card, .ok-link, .form-control').hasClass('rounded-0')){
		$(".select-border-radius option[value=rounded-0]").attr('selected','selected');
	}else if($('#ok-card-wrap, #ok-link-wrap, #ok-icode-wrap').find('.ok-card, .ok-link, .form-control').hasClass('rounded')){
		$(".select-border-radius option[value=rounded]").attr('selected','selected');
	}else if($('#ok-card-wrap, #ok-link-wrap, #ok-icode-wrap').find('.ok-card, .ok-link, .form-control').hasClass('rounded-pill')){
		$(".select-border-radius option[value=rounded-pill]").attr('selected','selected');
	}else{
		$(".select-border-radius option[value=rounded-circle]").attr('selected','selected');
	}
});
$(document).on('change', '.select-border-radius', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap .form-control, #ok-icode-wrap .ok-contact-btn').removeClass('rounded-0 rounded rounded-pill rounded-circle');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap .form-control, #ok-icode-wrap .ok-contact-btn').addClass(this.value);
});

//Border Color
$(document).on('click', '.border-control-panel', function(){
	if($('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').hasClass('border')){
		$(".border-selector option[value='border border-1']").attr('selected','selected');
		$('.border-color-opt').show();
	}else{
		$('.border-color-opt').hide();
	}
	//Check Border Size
	if($('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').hasClass('border-1')){
		$(".ele-bdr").val('1');
		$(".ele-bdr-count").text('1');
	}
	if($('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').hasClass('border-2')){
		$(".ele-bdr").val('2');
		$(".ele-bdr-count").text('2');
	}
	if($('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').hasClass('border-3')){
		$(".ele-bdr").val('3');
		$(".ele-bdr-count").text('3');
	}
	if($('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').hasClass('border-4')){
		$(".ele-bdr").val('4');
		$(".ele-bdr-count").text('4');
	}
	if($('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').hasClass('border-5')){
		$(".ele-bdr").val('5');
		$(".ele-bdr-count").text('5');
	}
});
$(document).on('change', '.border-selector', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('border border-1 border-2 border-3 border-4 border-5');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass(this.value);
	if($(this).val()===""){
		$('.border-color-opt').hide();	
		$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('border bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k border border-1 border-2 border-3 border-4 border-5');
	}else{
		$('.border-color-opt').show();
	}
});
$(document).on('input', '.ele-bdr', function(){
    $(".ele-bdr-count").text(this.value);
    $('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass("border-1 border-2 border-3 border-4 border-5");
	if (this.value == 1) {
		$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass("border-1");
	}else if (this.value == 2) {
		$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass("border-2");
	}else if (this.value == 3) {
		$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass("border-3");
	}else if (this.value == 4) {
		$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass("border-4");
	}else if (this.value == 5) {
		$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass("border-5");
	}
});
$(document).on('click', '.main-bdrcolor-a', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-a');
});
$(document).on('click', '.main-bdrcolor-b', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-b');
});
$(document).on('click', '.main-bdrcolor-c', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-c');
});
$(document).on('click', '.main-bdrcolor-d', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-d');
});
$(document).on('click', '.main-bdrcolor-e', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-e');
});
$(document).on('click', '.main-bdrcolor-f', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-f');
});
$(document).on('click', '.main-bdrcolor-g', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-g');
});
$(document).on('click', '.main-bdrcolor-h', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-h');
});
$(document).on('click', '.main-bdrcolor-i', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-i');
});
$(document).on('click', '.main-bdrcolor-j', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-j');
});
$(document).on('click', '.main-bdrcolor-k', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link, #ok-icode-wrap input:not(.ok-contact-btn), #ok-icode-wrap textarea').addClass('bdr-k');
});
//Border Hover Color Settings
$(document).on('click', '.main-hobdrcolor-a', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-a');
});
$(document).on('click', '.main-hobdrcolor-b', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-b');
});
$(document).on('click', '.main-hobdrcolor-c', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-c');
});
$(document).on('click', '.main-hobdrcolor-d', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-d');
});
$(document).on('click', '.main-hobdrcolor-e', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-e');
});
$(document).on('click', '.main-hobdrcolor-f', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-f');
});
$(document).on('click', '.main-hobdrcolor-g', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-g');
});
$(document).on('click', '.main-hobdrcolor-h', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-h');
});
$(document).on('click', '.main-hobdrcolor-i', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-i');
});
$(document).on('click', '.main-hobdrcolor-j', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-j');
});
$(document).on('click', '.main-hobdrcolor-k', function(){
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').removeClass('hov-bdr-a hov-bdr-b hov-bdr-c hov-bdr-d hov-bdr-e hov-bdr-f hov-bdr-g hov-bdr-h hov-bdr-i hov-bdr-j hov-bdr-k');
	$('#ok-card-wrap .ok-card, #ok-link-wrap .ok-link').addClass('hov-bdr-k');
});

//Background Overlay Color
$(document).on('change', '.overlay-select-opt', function() {
	if($(this).val()==="1"){ 
		$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
		$('#ok-section-wrap').find('.ok-section').prepend('<div class="bg-overlay"></div>');
		$('#ok-section-wrap').find('.container-fluid').addClass('layer-2');
		$('.overlay-opt-wrap').show();
	}else {
		$('#ok-section-wrap').find('.bg-overlay').remove();
		$('#ok-section-wrap').find('.container-fluid').removeClass('layer-2');
		$('.overlay-opt-wrap').hide();		
	}
});

//Section Overlay Color Settings
$(document).on('click', '#olay-bgcolor-none', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
});
$(document).on('click', '#olay-bgcolor-a', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-a');
});
$(document).on('click', '#olay-bgcolor-b', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-b');
});
$(document).on('click', '#olay-bgcolor-c', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-c');
});
$(document).on('click', '#olay-bgcolor-d', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-d');
});
$(document).on('click', '#olay-bgcolor-e', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-e');
});
$(document).on('click', '#olay-bgcolor-f', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-f');
});
$(document).on('click', '#olay-bgcolor-g', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-g');
});
$(document).on('click', '#olay-bgcolor-h', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-h');
});
$(document).on('click', '#olay-bgcolor-i', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-i');
});
$(document).on('click', '#olay-bgcolor-j', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-j');
});
$(document).on('click', '#olay-bgcolor-k', function(){
	$("#ok-section-wrap").find('.ok-section').css({'background-color': ''});
	$("#ok-section-wrap").find('.bg-overlay').removeAttr('style');
	$('#ok-section-wrap').find('.bg-overlay').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k');
	$('#ok-section-wrap').find('.bg-overlay').addClass('bg-k');
});

//Section Background Color Settings
$(document).on('click', '#sec-bgcolor-none', function(){
	$('#ok-section-wrap').find('.ok-section').css({'background-image': '', 'background': ''});
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
});
$(document).on('click', '#sec-bgcolor-a', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-a');
});
$(document).on('click', '#sec-bgcolor-b', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-b');
});
$(document).on('click', '#sec-bgcolor-c', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-c');
});
$(document).on('click', '#sec-bgcolor-d', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-d');
});
$(document).on('click', '#sec-bgcolor-e', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-e');
});
$(document).on('click', '#sec-bgcolor-f', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-f');
});
$(document).on('click', '#sec-bgcolor-g', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-g');
});
$(document).on('click', '#sec-bgcolor-h', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-h');
});
$(document).on('click', '#sec-bgcolor-i', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-i');
});
$(document).on('click', '#sec-bgcolor-j', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-j');
});
$(document).on('click', '#sec-bgcolor-k', function(){
	$('#ok-section-wrap').find('.ok-section').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image bgimage-string bg-parallax');
	$('#ok-section-wrap').find('.ok-section').addClass('bg-k');
});

$(document).on('click', '#sec-bgcolor-none, #sec-bgcolor-a, #sec-bgcolor-b, #sec-bgcolor-c, #sec-bgcolor-d, #sec-bgcolor-e, #sec-bgcolor-f, #sec-bgcolor-g, #sec-bgcolor-h, #sec-bgcolor-i, #sec-bgcolor-j, #sec-bgcolor-k', function(){
	$('#ok-section-wrap').find('.ok-section').css({'background-image': '', 'background': ''});
	$('#ok-section-wrap').find('.bg-overlay').remove();
	$('#ok-section-wrap').find('.container-fluid').removeClass('layer-2');
	$('.overlay-opt-wrap').hide();
	//Set Default Values
	$('#sec-bgimage-preview').attr('src', 'okcc/img/img.svg');
	$(".parallax-select-opt option[value='']").attr('selected','selected');
	$(".overlay-select-opt option[value=0]").attr('selected','selected');
});
//Link Color Settings
$(document).on('click', '#link-color-a', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-color-a ok-color-b ok-color-c ok-color-d ok-color-e ok-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-color-a');
});
$(document).on('click', '#link-color-b', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-color-a ok-color-b ok-color-c ok-color-d ok-color-e ok-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-color-b');
});
$(document).on('click', '#link-color-c', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-color-a ok-color-b ok-color-c ok-color-d ok-color-e ok-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-color-c');
});
$(document).on('click', '#link-color-d', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-color-a ok-color-b ok-color-c ok-color-d ok-color-e ok-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-color-d');
});
$(document).on('click', '#link-color-e', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-color-a ok-color-b ok-color-c ok-color-d ok-color-e ok-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-color-e');
});
$(document).on('click', '#link-color-f', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-color-a ok-color-b ok-color-c ok-color-d ok-color-e ok-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-color-f');
});
//Link Hover Color Settings
$(document).on('click', '#link-hover-color-a', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-color-a ok-hover-color-b ok-hover-color-c ok-hover-color-d ok-hover-color-e ok-hover-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-color-a');
});
$(document).on('click', '#link-hover-color-b', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-color-a ok-hover-color-b ok-hover-color-c ok-hover-color-d ok-hover-color-e ok-hover-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-color-b');
});
$(document).on('click', '#link-hover-color-c', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-color-a ok-hover-color-b ok-hover-color-c ok-hover-color-d ok-hover-color-e ok-hover-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-color-c');
});
$(document).on('click', '#link-hover-color-d', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-color-a ok-hover-color-b ok-hover-color-c ok-hover-color-d ok-hover-color-e ok-hover-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-color-d');
});
$(document).on('click', '#link-hover-color-e', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-color-a ok-hover-color-b ok-hover-color-c ok-hover-color-d ok-hover-color-e ok-hover-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-color-e');
});
$(document).on('click', '#link-hover-color-f', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-color-a ok-hover-color-b ok-hover-color-c ok-hover-color-d ok-hover-color-e ok-hover-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-color-f');
});
//Link Background Color Settings
$(document).on('click', '#link-bgcolor-a', function(){
	$('#ok-link-wrap').find('.ok-link').css({'background-image': '', 'background-repeat': '', 'background-size': '', 'background-position': ''});
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-bg-color-a ok-bg-color-b ok-bg-color-c ok-bg-color-d ok-bg-color-e ok-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-bg-color-a');
});
$(document).on('click', '#link-bgcolor-b', function(){
	$('#ok-link-wrap').find('.ok-link').css({'background-image': '', 'background-repeat': '', 'background-size': '', 'background-position': ''});
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-bg-color-a ok-bg-color-b ok-bg-color-c ok-bg-color-d ok-bg-color-e ok-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-bg-color-b');
});
$(document).on('click', '#link-bgcolor-c', function(){
	$('#ok-link-wrap').find('.ok-link').css({'background-image': '', 'background-repeat': '', 'background-size': '', 'background-position': ''});
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-bg-color-a ok-bg-color-b ok-bg-color-c ok-bg-color-d ok-bg-color-e ok-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-bg-color-c');
});
$(document).on('click', '#link-bgcolor-d', function(){
	$('#ok-link-wrap').find('.ok-link').css({'background-image': '', 'background-repeat': '', 'background-size': '', 'background-position': ''});
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-bg-color-a ok-bg-color-b ok-bg-color-c ok-bg-color-d ok-bg-color-e ok-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-bg-color-d');
});
$(document).on('click', '#link-bgcolor-e', function(){
	$('#ok-link-wrap').find('.ok-link').css({'background-image': '', 'background-repeat': '', 'background-size': '', 'background-position': ''});
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-bg-color-a ok-bg-color-b ok-bg-color-c ok-bg-color-d ok-bg-color-e ok-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-bg-color-e');
});
$(document).on('click', '#link-bgcolor-f', function(){
	$('#ok-link-wrap').find('.ok-link').css({'background-image': '', 'background-repeat': '', 'background-size': '', 'background-position': ''});
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-bg-color-a ok-bg-color-b ok-bg-color-c ok-bg-color-d ok-bg-color-e ok-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-bg-color-f');
});
//Link Background Hover Color Settings
$(document).on('click', '#link-hover-bgcolor-a', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-bg-color-a ok-hover-bg-color-b ok-hover-bg-color-c ok-hover-bg-color-d ok-hover-bg-color-e ok-hover-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-bg-color-a');
});
$(document).on('click', '#link-hover-bgcolor-b', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-bg-color-a ok-hover-bg-color-b ok-hover-bg-color-c ok-hover-bg-color-d ok-hover-bg-color-e ok-hover-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-bg-color-b');
});
$(document).on('click', '#link-hover-bgcolor-c', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-bg-color-a ok-hover-bg-color-b ok-hover-bg-color-c ok-hover-bg-color-d ok-hover-bg-color-e ok-hover-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-bg-color-c');
});
$(document).on('click', '#link-hover-bgcolor-d', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-bg-color-a ok-hover-bg-color-b ok-hover-bg-color-c ok-hover-bg-color-d ok-hover-bg-color-e ok-hover-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-bg-color-d');
});
$(document).on('click', '#link-hover-bgcolor-e', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-bg-color-a ok-hover-bg-color-b ok-hover-bg-color-c ok-hover-bg-color-d ok-hover-bg-color-e ok-hover-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-bg-color-e');
});
$(document).on('click', '#link-hover-bgcolor-f', function(){
	$('#ok-link-wrap').find('.ok-link').removeClass('ok-hover-bg-color-a ok-hover-bg-color-b ok-hover-bg-color-c ok-hover-bg-color-d ok-hover-bg-color-e ok-hover-bg-color-f');
	$('#ok-link-wrap').find('.ok-link').addClass('ok-hover-bg-color-f');
});

//If Draggable Settings is Clicked or Active
$(document).on('click', '#section-setting, #row-setting-menu, #column-setting-menu, #slider-setting-menu, #card-setting-menu, #container-setting-menu, #text-setting-menu, #image-setting-menu, #link-setting-menu, #icode-setting-menu, #ok-settings-btn', function() {		
	//Active Draggable Setting Panel		
	$('#setting-draggable').css('display', 'block'); 
	$('#setting-panel').addClass('active-panel');
	//Make the DIV element draggagle:
    dragElement(document.getElementById("setting-draggable"));    
    function dragElement(elmnt) {
      let pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
      if (document.getElementById(elmnt.id + "header")) {
        /* if present, the header is where you move the DIV from:*/
        document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
      } else {
        /* otherwise, move the DIV from anywhere inside the DIV:*/
        elmnt.onmousedown = dragMouseDown;
      }    
      function dragMouseDown(e) {
        e = e || window.event;
        e.preventDefault();
        // get the mouse cursor position at startup:
        pos3 = e.clientX;
        pos4 = e.clientY;
        document.onmouseup = closeDragElement;
        // call a function whenever the cursor moves:
        document.onmousemove = elementDrag;
      }    
      function elementDrag(e) {
        e = e || window.event;
        e.preventDefault();
        let winW = document.documentElement.clientWidth || document.body.clientWidth,
            winH = document.documentElement.clientHeight || document.body.clientHeight;
        let maxX = winW - elmnt.offsetWidth - 1,
            maxY = winH - elmnt.offsetHeight - 1;
        // calculate the new cursor position:
        pos1 = pos3 - e.clientX;
        pos2 = pos4 - e.clientY;
        pos3 = e.clientX;
        pos4 = e.clientY;
        // set the element's new position:
        //console.log((elmnt.offsetLeft - pos1), maxY, (elmnt.offsetLeft - pos1), maxX);
        if((elmnt.offsetTop - pos2) <= maxY && (elmnt.offsetTop - pos2) >= 0){
          elmnt.style.top = (elmnt.offsetTop - pos2) + "px";
        }
        if((elmnt.offsetLeft - pos1) <= maxX && (elmnt.offsetLeft - pos1) >= 0){
          elmnt.style.left = (elmnt.offsetLeft - pos1) + "px";
        }
      }    
      function closeDragElement() {
        /* stop moving when mouse button is released:*/
        document.onmouseup = null;
        document.onmousemove = null;
      }
    }
	
	//Hidden Elements
	if($('#ok-link-wrap').find('#scroll-top').length>0){
	}else if($('#ok-row-wrap').find('.ok-row').length>0){
	}else{
	$('.draggable-content').append(`
		<!-- ::START:: Hidden Elements -->
		<div id="hidden-element-panel">
		<div class="setting-title">
			<p>Hide on</p>
		</div>
		<div class="settings">
			<div class="table-box">					
			<table border="0" width="100%">
				<tr>
					<td width="100%">
						<select id="hidden-ele" class="ok-select-opt">
							<option value="">None</option>
							<option id="ele-mob-hidden" value="ok-hide-mob d-none d-sm-block d-sm-none d-md-block">Mobile</option>
							<option id="ele-tab-hidden" value="ok-hide-tab d-md-none d-lg-block d-lg-none d-xl-block">Tablet</option>
							<option id="ele-desk-hidden" value="ok-hide-desk d-xl-none d-xxl-block d-xxl-none">Desktop</option>
							<option id="ele-mobtab-hidden" value="ok-hide-mobtab d-none d-sm-block d-sm-none d-md-block d-md-none d-lg-block d-lg-none d-xl-block">Mobile & Tablet</option>
							<option id="ele-mobdesk-hidden" value="ok-hide-mobdesk d-none d-sm-block d-sm-none d-md-block d-xl-none d-xxl-block d-xxl-none">Mobile & Desktop</option>
							<option id="ele-tabdesk-hidden" value="ok-hide-tabdesk d-md-none d-lg-block d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none">Tablet & Desktop</option>
						</select>
					</td>
				</tr>
			</table>
			</div>
		</div>
		</div><!-- ::END:: Hidden Elements -->`);
	}
		
	//::START:: Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();
	$(document).on('click', '#hidden-element-panel', function(){
		//Check Visibility
		if($('#ok-link-wrap').parent().hasClass('ok-hide-mob')){
			$("#hidden-ele option[id=ele-mob-hidden]").attr('selected','selected');
		}else if($(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").hasClass('ok-hide-mob')){
			$("#hidden-ele option[id=ele-mob-hidden]").attr('selected','selected');
		}
		if($('#ok-link-wrap').parent().hasClass('ok-hide-tab')){
			$("#hidden-ele option[id=ele-tab-hidden]").attr('selected','selected');
		}else if($(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").hasClass('ok-hide-tab')){
			$("#hidden-ele option[id=ele-tab-hidden]").attr('selected','selected');
		}
		if($('#ok-link-wrap').parent().hasClass('ok-hide-desk')){
			$("#hidden-ele option[id=ele-desk-hidden]").attr('selected','selected');
		}else if($(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").hasClass('ok-hide-desk')){
			$("#hidden-ele option[id=ele-desk-hidden]").attr('selected','selected');
		}
		if($('#ok-link-wrap').parent().hasClass('ok-hide-mobtab')){
			$("#hidden-ele option[id=ele-mobtab-hidden]").attr('selected','selected');
		}else if($(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").hasClass('ok-hide-mobtab')){
			$("#hidden-ele option[id=ele-mobtab-hidden]").attr('selected','selected');
		}
		if($('#ok-link-wrap').parent().hasClass('ok-hide-mobdesk')){
			$("#hidden-ele option[id=ele-mobdesk-hidden]").attr('selected','selected');
		}else if($(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").hasClass('ok-hide-mobdesk')){
			$("#hidden-ele option[id=ele-mobdesk-hidden]").attr('selected','selected');
		}
		if($('#ok-link-wrap').parent().hasClass('ok-hide-tabdesk')){
			$("#hidden-ele option[id=ele-tabdesk-hidden]").attr('selected','selected');
		}else if($(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").hasClass('ok-hide-tabdesk')){
			$("#hidden-ele option[id=ele-tabdesk-hidden]").attr('selected','selected');
		}
		//Add Hide value for devices
		$("#hidden-ele").on('change', function() {
			$(".ok-link-li, .active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").removeClass("ok-hide-mob ok-hide-tab ok-hide-desk ok-hide-mobtab ok-hide-mobdesk ok-hide-tabdesk d-none d-sm-block d-sm-none d-md-block d-md-none d-lg-block d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none");
			
			if($('#ok-link-wrap').parent().hasClass('ok-link-li')){
				$('#ok-link-wrap').parent().removeClass("ok-hide-mob ok-hide-tab ok-hide-desk ok-hide-mobtab ok-hide-mobdesk ok-hide-tabdesk d-none d-sm-block d-sm-none d-md-block d-md-none d-lg-block d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none");
				$('#ok-link-wrap').parent().addClass($(this).val());
			}else if($('#ok-img-wrap .ok-link-image').length>0){
				$('#ok-img-wrap .ok-link-image').removeClass("ok-hide-mob ok-hide-tab ok-hide-desk ok-hide-mobtab ok-hide-mobdesk ok-hide-tabdesk d-none d-sm-block d-sm-none d-md-block d-md-none d-lg-block d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none");
				$('#ok-img-wrap .ok-link-image').addClass($(this).val());
			}else if($('#ok-img-wrap, #ok-link-wrap').parent().find('.ok-video-image, .ok-video-btn').length>0){
				$('#ok-img-wrap, #ok-link-wrap').parent().parent().removeClass("ok-hide-mob ok-hide-tab ok-hide-desk ok-hide-mobtab ok-hide-mobdesk ok-hide-tabdesk d-none d-sm-block d-sm-none d-md-block d-md-none d-lg-block d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none");
				$('#ok-img-wrap, #ok-link-wrap').parent().parent().addClass($(this).val());
			}else{	
				$(".active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").addClass($(this).val());
			}
			if($(this).val()===""){ 
			$(".ok-link-li, .active-section .ok-section, #ok-row-wrap .active-row, .ok-column-handle, #ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link").removeClass("ok-hide-mob ok-hide-tab ok-hide-desk ok-hide-mobtab ok-hide-mobdesk ok-hide-tabdesk d-none d-sm-block d-sm-none d-md-block d-md-none d-lg-block d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none");
			}

			$('#show-hidden-elements').show();
		});	//Add Hide value for devices
	});//::END:: Responsive Hidden	
		
	$(document).on('click', '.draggable-content .setting-title', function(){
		$('.setting-title').removeClass("blue");
		$(this).toggleClass("blue");
		//Expand or collapse this panel
		$(this).next().show();	
		//Hide the other panels
		$(".settings").not($(this).next()).slideUp();
		$(".setting-title").animate({ scrollTop: 0 }, "fast");//:::SCROLL TO TOP
	});  
});
//Close Draggable Setting panel
$(document).on('click', '#close-panel', function() {
	$('#setting-panel').removeClass('active-panel');  
	$('#setting-draggable').css('display', 'none');	
	$('#setting-panel').html('');
	$('#ok-section-wrap').removeClass('active-section');
	//Remove hidden ele options
	$('#hide-ele-opt-on-global-settings').remove();
	//For Column
	$('.ok-column').removeClass('column-border');	
	//$(".ok-column-handle").parent().removeClass('row-border');	
});

//Remove all on mouseover elements Wrapper
$(document).on('click', '.add-section, #close-panel', function() {
	//First Removes Dynamic Elements If Exist	
	$('#ok-row-wrap').contents().unwrap();
	$('#row-setting-tools').remove();
	$('.ok-row').removeClass('active-row row-border');
	$('.ok-column').removeClass('column-border ok-column-handle');
	$('#column-setting-tools').remove();
	$('#ok-slider-wrap').contents().unwrap();
	$('#slider-setting-tools').remove();
	$('#ok-card-wrap').contents().unwrap();
	$('#card-setting-tools').remove();
	$('#ok-group-container-wrap').contents().unwrap();
	$('#container-setting-tools').remove();
	$('#ok-section-wrap').contents().unwrap();
	$('#section-setting-wrap').remove();
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	//Remove Draggable supporters
	$('#ok-sortable-section, #ok-sortable-section header, #ok-sortable-section section, #ok-sortable-section footer, #ok-sortable-section div, #ok-sortable-section h1, #ok-sortable-section h2, #ok-sortable-section h3, #ok-sortable-section h4, #ok-sortable-section h5, #ok-sortable-section h6, #ok-sortable-section p, #ok-sortable-section a, #ok-sortable-section img, #ok-sortable-section button, #ok-sortable-section form').removeAttr('role aria-grabbed aria-dropeffect');
});

//START:: Link Panel
$(document).on('click', '#text-setting-menu', function() {
//Text Link panel
let textLinkPanel = [];
textLinkPanel.push(`
<div class="urlbox-wrap"> 
	<div class="urlbox">
	<form class="urlForm" name="urlForm">
		<p>Linking to:<span class="close-link-modal float-right d-cursor red">Close <i class="fas fa-times red"></i></span></p>
		<button id="link-web-tab" class="button d-cursor">Web Address</button>
		<button id="link-email-tab" class="button d-cursor">Email</button>
		<input class="url input" type="text" placeholder="Enter web URL">
		<p class="link-title-value ok-hide-element"></p>
		<div class="link-option-wrap">
			<div id="link-web-options">
				<p>Linking to URL:</p>
				<input id="web-link-input" class="input" type="text" placeholder="Eg. https://domain.com">
				
				<p class="mt-20">Title:</p>
				<input class="link-title-input input" type="text" placeholder="Title">
				<p class="mt-20">Link target:</p>
				<div class="ok-select">
					<select class="userInputTarget">
					<option value="">The same window</option>
					<option value="target=_blank">New Window (_blank)</option>
					</select>
				</div>
				<p class="mt-20">Rel attribute:</p>
				<div class="ok-select">
					<select class="rel-link-option">
						<option value="">Keep as is</option>
						<option value="">Follow</option>
						<option value="rel=nofollow">Nofollow</option>
						<option value="rel=sponsored">Sponsored</option>
						<option value="rel=ugc">UGC</option>
					</select>
				</div>
			</div>
			<div id="link-email-options">
				<input id="email-link-input" class="input" type="text" placeholder="Enter Email Address">
				<p>Eg. email@domain.com</p>
			</div>	
			<div class="insert-url-wrap">
				<input class="insert-url button" type="submit" value="Insert Link">
			</div>
		</div>
	</form>
	</div>
</div>
`);
document.getElementById("add-link-panel").innerHTML = textLinkPanel.join("");

Array.prototype.map.call(document.querySelectorAll('button:not([data-role="createLink"])'), (action) => {
	action.addEventListener("click", () => {
		//e.preventDefault(); this causing saving error
		document.execCommand(action.dataset.role, false, action.dataset.value);
	});
});
// Handle the link urlbox
let urlbox = document.querySelector('.urlbox');
let closeModal = () => {
	urlbox.classList.remove('visible');
}
let closeButton = document.querySelector('.insert-url');
closeButton.addEventListener('click', closeModal);
let closeModalButton = document.querySelector('.close-link-modal');
closeModalButton.addEventListener('click', closeModal);
document.addEventListener('keyup', function(e) {
	if (e.keyCode == 27) {
		closeModal();
	}
});
const anchorLink = document.querySelector('button[data-role="createLink"]');
let urlForm = document.querySelector('.urlForm');
urlForm.addEventListener('submit',(e) => {
	let urlValue = urlForm.querySelector('.url').value;
	restoreSelection(window.savedSel);
	let userInputTarget = document.querySelector('.userInputTarget').value;
	let getTarget = userInputTarget;
	let userInputRel = document.querySelector('.rel-link-option').value;
	let getRel = userInputRel;
	let userInputTitle = document.querySelector('.link-title-value').innerText;
	let getLinkTitle = userInputTitle;
	let selection = document.getSelection();
  	//document.execCommand("CreateLink", false, urlValue);
	document.execCommand('insertHTML',false,'<a href="'+urlValue+'" class="is-link" '+getLinkTitle+' '+getTarget+' '+getRel+'>'+selection+'</a>');
	//selection.anchorNode.parentElement.target = target;	
	//selection.anchorNode.parentElement.classList.add("is-link");

	closeModal();
	e.preventDefault();
});
let otherClicks = (event) => {
	if (document.querySelector('.urlbox').contains(event.target)) {
		return false;
	} else {
		closeModal();
		window.removeEventListener('click', otherClicks);
	}
};
window.addEventListener('click', otherClicks);
anchorLink.addEventListener('click', () => {
	urlbox.classList.add('visible');
	window.savedSel = saveSelection();
	$('.urlForm').find('.input').val('');
	$('.urlForm').find('.input').focus();
	//document.urlForm.urlField.value="";
	//document.urlForm.urlField.focus();
});
// Save selected text when URL urlbox opens. From http://stackoverflow.com/questions/5605401/insert-link-in-contenteditable-element
function saveSelection() {
    if (window.getSelection) {
       var sel = window.getSelection();
        if (sel.getRangeAt && sel.rangeCount) {
            let ranges = [];
            for (let i = 0, len = sel.rangeCount; i < len; ++i) {
                ranges.push(sel.getRangeAt(i));
            }
            return ranges;
        }
    } else if (document.selection && document.selection.createRange) {
        return document.selection.createRange();
    }
    return null;
}
function restoreSelection(savedSel) {
    if (savedSel) {
        if (window.getSelection) {
            var sel = window.getSelection();
            sel.removeAllRanges();
            for (let i = 0, len = savedSel.length; i < len; ++i) {
                sel.addRange(savedSel[i]);
            }
        } else if (document.selection && savedSel.select) {
            savedSel.select();
        }
    }
}
function getSelectionParentElement() {
    let parentEl = null, sel;
    if (window.getSelection) {
        sel = window.getSelection();
        if (sel.rangeCount) {
            parentEl = sel.getRangeAt(0).commonAncestorContainer;
            if (parentEl.nodeType != 1) {
                parentEl = parentEl.parentNode;
            }
        }
    } else if ( (sel = document.selection) && sel.type != "Control") {
        parentEl = sel.createRange().parentElement();
    }
    return parentEl;
}
//URL Function
$(".add-url").on("click", function() {
    $(".urlbox-wrap").toggleClass("active-urlbox");
	$('.url, #web-link-input, #email-link-input').val('');
	$('html, body').css('overflow', 'hidden');
	$("#link-web-tab").css({"color": "#ffffff", "background": "skyBlue"});
	$('#link-web-options').css({"display": "block"});
	$('#link-email-options').css({"display": "none"});
	$('#link-email-tab').css({"color": "#333333", "background": "#ffffff"})
// Enable Web Link options
$("#link-web-tab").click( function(){
	$(this).css({"color": "#ffffff", "background": "skyBlue"});
	$('#link-web-options').css({"display": "block"});
	$('#link-email-options').css({"display": "none"});
	$('#link-email-tab').css({"color": "#333333", "background": "#ffffff"})
});	
// Enable Email Link options
$("#link-email-tab").click( function(){
	$(this).css({"color": "#ffffff", "background": "skyBlue"});
	$('#link-email-options').css({"display": "block"});
	$('#link-web-options').css({"display": "none"});
	$('#link-web-tab').css({"color": "#333333", "background": "#ffffff"});
});	
});//URL Function end
//Link to Web address
$("#web-link-input").on("input",function(){
	$(".url").val(this.value);	
});
//Link to Email
$("#email-link-input").on("input",function(){
	$(".url").val('mailto:' + this.value);	
});
//Link Title
$(".link-title-input").on("input",function(){
	$(".link-title-value").text('title="'+this.value+'"');	
});
//Text Linking
$(".text-linking").on("input", function() {
	$("#ok-text-wrap").find('a').attr('href', this.value);
});	
$(".text-linking-title").on("input", function() {
	$("#ok-text-wrap").find('a').attr('title', this.value);
});	
//Insert Link
$(".insert-url").on("click", function() {    
    $(".urlbox-wrap").toggleClass("active-urlbox");
	$('html, body').css({"overflow": "auto"});
});
//Close Link Box
$(".close-link-modal").click(function() {
    $(".urlbox-wrap").toggleClass("active-urlbox");
	$('html, body').css({"overflow": "auto"});
});
});//END:: Link Panel

//For Mediabox close popup video
$(document).on('click', '#mediabox-esc', function(){
	$('.mediabox-wrap').remove();
});
//Button Size
$(document).on('click', '.button-control-panel', function(){
//Check Default Button Size
if($('#ok-link-wrap .ok-link').hasClass("hw-20")){
	$(".button-size-count").text('20px');
	$(".button-size").val('2');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-25")){
	$(".button-size-count").text('25px');
	$(".button-size").val('3');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-30")){
	$(".button-size-count").text('30px');
	$(".button-size").val('4');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-35")){
	$(".button-size-count").text('35px');
	$(".button-size").val('5');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-40")){
	$(".button-size-count").text('40px');
	$(".button-size").val('6');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-45")){
	$(".button-size-count").text('45px');
	$(".button-size").val('7');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-50")){
	$(".button-size-count").text('50px');
	$(".button-size").val('8');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-55")){
	$(".button-size-count").text('55px');
	$(".button-size").val('9');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-60")){
	$(".button-size-count").text('60px');
	$(".button-size").val('10');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-65")){
	$(".button-size-count").text('65px');
	$(".button-size").val('11');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-70")){
	$(".button-size-count").text('70px');
	$(".button-size").val('12');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-75")){
	$(".button-size-count").text('75px');
	$(".button-size").val('13');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-80")){
	$(".button-size-count").text('80px');
	$(".button-size").val('14');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-85")){
	$(".button-size-count").text('85px');
	$(".button-size").val('15');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-90")){
	$(".button-size-count").text('90px');
	$(".button-size").val('16');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-95")){
	$(".button-size-count").text('95px');
	$(".button-size").val('17');
}else if($('#ok-link-wrap .ok-link').hasClass("hw-100")){
	$(".button-size-count").text('100px');
	$(".button-size").val('18');
}else{
	$(".button-size-count").text('Default');
	$(".button-size").val('1');
}
//:: Button Size
let eleButtonSize = document.querySelector(".button-size");
eleButtonSize.oninput = function() {
   $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
	if (this.value == 1) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");     
		$(".button-size-count").text('Default');
    } else if (this.value == 2) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-20");       
		$(".button-size-count").text('20px');
    } else if (this.value == 3) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-25");       
		$(".button-size-count").text('25px');
    } else if (this.value == 4) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-30");       
		$(".button-size-count").text('30px');
    } else if (this.value == 5) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-35");       
		$(".button-size-count").text('35px');
    } else if (this.value == 6) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-40");       
		$(".button-size-count").text('40px');
    } else if (this.value == 7) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-45");       
		$(".button-size-count").text('45px');
    } else if (this.value == 8) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-50");       
		$(".button-size-count").text('50px');
    } else if (this.value == 9) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-55");       
		$(".button-size-count").text('55px');
    } else if (this.value == 10) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-60");       
		$(".button-size-count").text('60px');
    } else if (this.value == 11) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-65");       
		$(".button-size-count").text('65px');
    } else if (this.value == 12) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-70");       
		$(".button-size-count").text('70px');
    } else if (this.value == 13) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-75");       
		$(".button-size-count").text('75px');
    } else if (this.value == 14) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-80");       
		$(".button-size-count").text('80px');
    } else if (this.value == 15) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-85");       
		$(".button-size-count").text('85px');
    } else if (this.value == 16) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-90");       
		$(".button-size-count").text('90px');
    } else if (this.value == 17) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-95");       
		$(".button-size-count").text('95px');
    } else if (this.value == 18) {
        $('#ok-link-wrap .ok-link').removeClass("hw-20 hw-25 hw-30 hw-35 hw-40 hw-45 hw-50 hw-55 hw-60 hw-65 hw-70 hw-75 hw-80 hw-85 hw-90 hw-95 hw-100");
        $('#ok-link-wrap .ok-link').addClass("hw-100");       
		$(".button-size-count").text('100px');
    }
}
});
//Tex Typography
$(document).on('click', '.typography-control-panel', function(){
//Check Font Style
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("font-a")){
	$(".select-font-style option[value='font-a']").attr('selected','selected');	
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("font-b")){
	$(".select-font-style option[value='font-b']").attr('selected','selected');	
}
//Check Font Wwight
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-normal")){
	$(".select-font-weight option[value=fw-normal]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-bold")){
	$(".select-font-weight option[value=fw-bold]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-bolder")){
	$(".select-font-weight option[value=fw-bolder]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-lighter")){
	$(".select-font-weight option[value=fw-lighter]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-100")){
	$(".select-font-weight option[value=fw-100]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-200")){
	$(".select-font-weight option[value=fw-200]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-300")){
	$(".select-font-weight option[value=fw-300]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-400")){
	$(".select-font-weight option[value=fw-400]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-500")){
	$(".select-font-weight option[value=fw-500]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-600")){
	$(".select-font-weight option[value=fw-600]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-700")){
	$(".select-font-weight option[value=fw-700]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-800")){
	$(".select-font-weight option[value=fw-800]").attr('selected','selected');
}
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fw-900")){
	$(".select-font-weight option[value=fw-900]").attr('selected','selected');
}
//Font Size
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-8")){
	$(".ele-fs-count").text('8px');
	$(".ele-fs").val('2');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-12")){
	$(".ele-fs-count").text('12px');
	$(".ele-fs").val('3');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-14")){
	$(".ele-fs-count").text('14px');
	$(".ele-fs").val('4');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-16")){
	$(".ele-fs-count").text('16px');
	$(".ele-fs").val('5');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-18")){
	$(".ele-fs-count").text('18px');
	$(".ele-fs").val('6');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-24")){
	$(".ele-fs-count").text('24px');
	$(".ele-fs").val('7');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-32")){
	$(".ele-fs-count").text('32px');
	$(".ele-fs").val('8');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-42")){
	$(".ele-fs-count").text('42px');
	$(".ele-fs").val('9');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-52")){
	$(".ele-fs-count").text('52px');
	$(".ele-fs").val('10');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-64")){
	$(".ele-fs-count").text('64px');
	$(".ele-fs").val('11');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-76")){
	$(".ele-fs-count").text('76px');
	$(".ele-fs").val('12');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-88")){
	$(".ele-fs-count").text('88px');
	$(".ele-fs").val('13');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-92")){
	$(".ele-fs-count").text('92px');
	$(".ele-fs").val('14');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass("fs-120")){
	$(".ele-fs-count").text('120px');
	$(".ele-fs").val('15');
}else{
	$(".ele-fs-count").text('Default');
	$(".ele-fs").val('1');
}
//Line Height
if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass("lh-1")){
	$(".ele-lh-count").text('1');
	$(".ele-lh").val('2');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass("lh-sm")){
	$(".ele-lh-count").text('1.25');
	$(".ele-lh").val('3');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass("lh-base")){
	$(".ele-lh-count").text('1.5');
	$(".ele-lh").val('4');
}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass("lh-lg")){
	$(".ele-lh-count").text('2');
	$(".ele-lh").val('5');
}else{
	$(".ele-lh-count").text('Default');
	$(".ele-lh").val('1');	
}
//Text Font Style
$(document).on('change', '.select-font-style', function() {
	$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("font-a font-b");
	$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass($(this).val());
});
//Text Font Weight
$(document).on('change', '.select-font-weight', function() {
	$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass("fw-normal fw-bold fw-bolder fw-lighter fw-100 fw-200 fw-300 fw-400 fw-500 fw-600 fw-700 fw-800 fw-900");
	$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass($(this).val());
});
//:: Font Size
let eleFontSize = document.querySelector(".ele-fs");
eleFontSize.oninput = function() {
   $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
	if (this.value == 1) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");     
		$(".ele-fs-count").text('Default');
    } else if (this.value == 2) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-8");       
		$(".ele-fs-count").text('8px');
    } else if (this.value == 3) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-12");       
		$(".ele-fs-count").text('12px');
    } else if (this.value == 4) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-14");       
		$(".ele-fs-count").text('14px');
    } else if (this.value == 5) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-16");       
		$(".ele-fs-count").text('16px');
    } else if (this.value == 6) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-18");       
		$(".ele-fs-count").text('18px');
    } else if (this.value == 7) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-24");       
		$(".ele-fs-count").text('24px');
    } else if (this.value == 8) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-32");       
		$(".ele-fs-count").text('32px');
    } else if (this.value == 9) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-42");       
		$(".ele-fs-count").text('42px');
    } else if (this.value == 10) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-52");       
		$(".ele-fs-count").text('52px');
    } else if (this.value == 11) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-64");       
		$(".ele-fs-count").text('64px');
    } else if (this.value == 12) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-76");       
		$(".ele-fs-count").text('76px');
    } else if (this.value == 13) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-88");       
		$(".ele-fs-count").text('88px');
    } else if (this.value == 14) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-92");       
		$(".ele-fs-count").text('92px');
    } else if (this.value == 15) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').removeClass("fs-8 fs-12 fs-14 fs-16 fs-18 fs-24 fs-32 fs-42 fs-52 fs-64 fs-76 fs-88 fs-92 fs-120");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, #ok-icode-wrap .ok-contact-name, #ok-icode-wrap .ok-email-id, #ok-icode-wrap .ok-message-id').addClass("fs-120");       
		$(".ele-fs-count").text('120px');
    }
}
//:: Line Height
let eleLineHeight = document.querySelector(".ele-lh");
eleLineHeight.oninput = function() {
   $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("lh-1 lh-sm lh-base lh-lg");
	if (this.value == 1) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("lh-1 lh-sm lh-base lh-lg");     
		$(".ele-lh-count").text('Default');
    } else if (this.value == 2) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("lh-1 lh-sm lh-base lh-lg");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("lh-1");       
		$(".ele-lh-count").text('1');
    } else if (this.value == 3) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("lh-1 lh-sm lh-base lh-lg");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("lh-sm");       
		$(".ele-lh-count").text('1.25');
    } else if (this.value == 4) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("lh-1 lh-sm lh-base lh-lg");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("lh-base");       
		$(".ele-lh-count").text('1.5');
    } else if (this.value == 5) {
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("lh-1 lh-sm lh-base lh-lg");
        $('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("lh-lg");       
		$(".ele-lh-count").text('2');
    }
}
});

//Text Alignment and Transform 
$(document).on('click', '.alignment-control-panel', function(){
	//Check Default Alignment values
	if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('text-start')){
		$('.main-align-left').addClass('bg-primary');		
	}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('text-end')){
		$('.main-align-right').addClass('bg-primary');		
	}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('text-center')){
		$('.main-align-center').addClass('bg-primary');		
	}else{
		$('.main-align-none').addClass('bg-primary');
	}
	//Check Default Transform values
	if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass('text-uppercase')){
		$('.main-upper-case').addClass('bg-primary');		
	}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass('text-lowercase')){
		$('.main-lower-case').addClass('bg-primary');		
	}else if($('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').hasClass('text-capitalize')){
		$('.main-capital-case').addClass('bg-primary');		
	}else{
		$('.main-case-none').addClass('bg-primary');
	}
	//Text Alignments
	$(document).on('click', '.main-align-none', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass('text-start text-center text-end text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end');
	});	
	$(document).on('click', '.main-align-left', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass('text-start text-center text-end text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass('text-start');
	});	
	$(document).on('click', '.main-align-right', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass('text-start text-center text-end text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass('text-end');
	});
	$(document).on('click', '.main-align-center', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass('text-start text-center text-end text-sm-start text-md-start text-lg-start text-xl-start text-sm-center text-md-center text-lg-center text-xl-center text-sm-end text-md-end text-lg-end text-xl-end');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass('text-center');
	});
	//Text Transform
	$(document).on('click', '.main-case-none', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('text-lowercase text-uppercase text-capitalize');
	});	
	$(document).on('click', '.main-upper-case', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('text-lowercase text-uppercase text-capitalize');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('text-uppercase');
	});
	$(document).on('click', '.main-lower-case', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('text-lowercase text-uppercase text-capitalize');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('text-lowercase');
	});
	$(document).on('click', '.main-capital-case', function() {
		$(this).addClass('bg-primary').siblings().removeClass('bg-primary');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('text-lowercase text-uppercase text-capitalize');
		$('#ok-text-wrap .ok-text, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('text-capitalize');
	});
});

//Margin
$(document).on('click', '.margin-control-panel', function(){
//Check Default Margin top Values
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-0')){
	$(".ele-mt-count").text('0');
	$(".ele-mt").val('1');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-5')){
	$(".ele-mt-count").text('5');
	$(".ele-mt").val('2');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-10')){
	$(".ele-mt-count").text('10');
	$(".ele-mt").val('3');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-15')){
	$(".ele-mt-count").text('15');
	$(".ele-mt").val('4');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-20')){
	$(".ele-mt-count").text('20');
	$(".ele-mt").val('5');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-25')){
	$(".ele-mt-count").text('25');
	$(".ele-mt").val('6');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-30')){
	$(".ele-mt-count").text('30');
	$(".ele-mt").val('7');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-35')){
	$(".ele-mt-count").text('35');
	$(".ele-mt").val('8');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-40')){
	$(".ele-mt-count").text('40');
	$(".ele-mt").val('9');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-45')){
	$(".ele-mt-count").text('45');
	$(".ele-mt").val('10');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-50')){
	$(".ele-mt-count").text('50');
	$(".ele-mt").val('11');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-55')){
	$(".ele-mt-count").text('55');
	$(".ele-mt").val('12');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-60')){
	$(".ele-mt-count").text('60');
	$(".ele-mt").val('13');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-65')){
	$(".ele-mt-count").text('65');
	$(".ele-mt").val('14');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mt-70')){
	$(".ele-mt-count").text('70');
	$(".ele-mt").val('15');
}
//Check Default Margin bottom Values
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-0')){
	$(".ele-mb-count").text('0');
	$(".ele-mb").val('1');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-5')){
	$(".ele-mb-count").text('5');
	$(".ele-mb").val('2');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-10')){
	$(".ele-mb-count").text('10');
	$(".ele-mb").val('3');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-15')){
	$(".ele-mb-count").text('15');
	$(".ele-mb").val('4');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-20')){
	$(".ele-mb-count").text('20');
	$(".ele-mb").val('5');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-25')){
	$(".ele-mb-count").text('25');
	$(".ele-mb").val('6');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-30')){
	$(".ele-mb-count").text('30');
	$(".ele-mb").val('7');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-35')){
	$(".ele-mb-count").text('35');
	$(".ele-mb").val('8');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-40')){
	$(".ele-mb-count").text('40');
	$(".ele-mb").val('9');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-45')){
	$(".ele-mb-count").text('45');
	$(".ele-mb").val('10');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-50')){
	$(".ele-mb-count").text('50');
	$(".ele-mb").val('11');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-55')){
	$(".ele-mb-count").text('55');
	$(".ele-mb").val('12');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-60')){
	$(".ele-mb-count").text('60');
	$(".ele-mb").val('13');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-65')){
	$(".ele-mb-count").text('65');
	$(".ele-mb").val('14');
}
if( $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').hasClass('mb-70')){
	$(".ele-mb-count").text('70');
	$(".ele-mb").val('15');
}
//:: Margin Top Element
let eleMarginTop = document.querySelector(".ele-mt");
eleMarginTop.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
	if (this.value == 1) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-0");       
		$(".ele-mt-count").text('0');
    } else if (this.value == 2) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-5");       
		$(".ele-mt-count").text('5');
    } else if (this.value == 3) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-10");       
		$(".ele-mt-count").text('10');
    } else if (this.value == 4) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-15");       
		$(".ele-mt-count").text('15');
    } else if (this.value == 5) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-20");       
		$(".ele-mt-count").text('20');
    } else if (this.value == 6) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-25");       
		$(".ele-mt-count").text('25');
    } else if (this.value == 7) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-30");       
		$(".ele-mt-count").text('30');
    } else if (this.value == 8) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-35");       
		$(".ele-mt-count").text('35');
    } else if (this.value == 9) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-40");       
		$(".ele-mt-count").text('40');
    } else if (this.value == 10) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-45");       
		$(".ele-mt-count").text('45');
    } else if (this.value == 11) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-50");       
		$(".ele-mt-count").text('50');
    } else if (this.value == 12) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-55");       
		$(".ele-mt-count").text('55');
    } else if (this.value == 13) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-60");       
		$(".ele-mt-count").text('60');
    } else if (this.value == 14) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-65");       
		$(".ele-mt-count").text('65');
    } else if (this.value == 15) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mt-0 mt-5 mt-10 mt-15 mt-20 mt-25 mt-30 mt-35 mt-40 mt-45 mt-50 mt-55 mt-60 mt-65 mt-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mt-70");       
		$(".ele-mt-count").text('70');
    }
}
//:: Element Margin Bottom
let eleMarginBottom = document.querySelector(".ele-mb");
eleMarginBottom.oninput = function() {
   $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
	if (this.value == 1) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-0");       
		$(".ele-mb-count").text('0');
    } else if (this.value == 2) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-5");       
		$(".ele-mb-count").text('5');
    } else if (this.value == 3) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-10");       
		$(".ele-mb-count").text('10');
    } else if (this.value == 4) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-15");       
		$(".ele-mb-count").text('15');
    } else if (this.value == 5) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-20");       
		$(".ele-mb-count").text('20');
    } else if (this.value == 6) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-25");       
		$(".ele-mb-count").text('25');
    } else if (this.value == 7) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-30");       
		$(".ele-mb-count").text('30');
    } else if (this.value == 8) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-35");       
		$(".ele-mb-count").text('35');
    } else if (this.value == 9) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-40");       
		$(".ele-mb-count").text('40');
    } else if (this.value == 10) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-45");       
		$(".ele-mb-count").text('45');
    } else if (this.value == 11) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-50");       
		$(".ele-mb-count").text('50');
    } else if (this.value == 12) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-55");       
		$(".ele-mb-count").text('55');
    } else if (this.value == 13) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-60");       
		$(".ele-mb-count").text('60');
    } else if (this.value == 14) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-65");       
		$(".ele-mb-count").text('65');
    } else if (this.value == 15) {
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').removeClass("mb-0 mb-5 mb-10 mb-15 mb-20 mb-25 mb-30 mb-35 mb-40 mb-45 mb-50 mb-55 mb-60 mb-65 mb-70");
        $('#ok-group-container-wrap .ok-group-container, #ok-slider-wrap .swiper, #ok-icode-wrap .ok-icode, #ok-row-wrap .active-row, #ok-img-wrap img, #ok-card-wrap .ok-card, #ok-text-wrap .ok-text, #ok-link-wrap .ok-link').addClass("mb-70");       
		$(".ele-mb-count").text('70');
    }
}
});
//Background Color Settings
$(document).on('click', '.main-bgcolor-none', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
});
$(document).on('click', '.main-bgcolor-a', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-a');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-a');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-a');
	}
});
$(document).on('click', '.main-bgcolor-b', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-b');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-b');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-b');
	}
});
$(document).on('click', '.main-bgcolor-c', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-c');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-c');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-c');
	}
});
$(document).on('click', '.main-bgcolor-d', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-d');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-d');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-d');
	}
});
$(document).on('click', '.main-bgcolor-e', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-e');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-e');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-e');
	}
});
$(document).on('click', '.main-bgcolor-f', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-f');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-f');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-f');
	}
});
$(document).on('click', '.main-bgcolor-g', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-g');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-g');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-g');
	}
});
$(document).on('click', '.main-bgcolor-h', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-h');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-h');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-h');
	}
});
$(document).on('click', '.main-bgcolor-i', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-i');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-i');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-i');
	}
});
$(document).on('click', '.main-bgcolor-j', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-j');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-j');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-j');
	}
});
$(document).on('click', '.main-bgcolor-k', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').removeClass('bg-a bg-b bg-c bg-d bg-e bg-f bg-g bg-h bg-i bg-j bg-k bg-image');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn, .ok-preloader, .preloader-pre').addClass('bg-k');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('bg-k');
	}else{
		$('#ok-card-wrap .card-body').addClass('bg-k');
	}
});
//Background Hover Color Settings
$(document).on('click', '.main-hobgcolor-none', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
});
$(document).on('click', '.main-hobgcolor-a', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-a');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-a');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-a');
	}
});
$(document).on('click', '.main-hobgcolor-b', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-b');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-b');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-b');
	}
});
$(document).on('click', '.main-hobgcolor-c', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-c');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-c');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-c');
	}
});
$(document).on('click', '.main-hobgcolor-d', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-d');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-d');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-d');
	}
});
$(document).on('click', '.main-hobgcolor-e', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-e');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-e');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-e');
	}
});
$(document).on('click', '.main-hobgcolor-f', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-f');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-f');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-f');
	}
});
$(document).on('click', '.main-hobgcolor-g', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-g');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-g');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-g');
	}
});
$(document).on('click', '.main-hobgcolor-h', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-h');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-h');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-h');
	}
});
$(document).on('click', '.main-hobgcolor-i', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-i');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-i');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-i');
	}
});
$(document).on('click', '.main-hobgcolor-j', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-j');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-j');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-j');
	}
});
$(document).on('click', '.main-hobgcolor-k', function(){
	$('.active-row, .ok-column-handle, #ok-card-wrap .ok-card-overlay, #ok-card-wrap .card-body, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-bg-a hov-bg-b hov-bg-c hov-bg-d hov-bg-e hov-bg-f hov-bg-g hov-bg-h hov-bg-i hov-bg-j hov-bg-k');
	$('.active-row, .ok-column-handle, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-bg-k');
	if($('#ok-card-wrap').find('.ok-card-overlay').length>0){
		$('#ok-card-wrap .ok-card-overlay').addClass('hov-bg-k');
	}else{
		$('#ok-card-wrap .card-body').addClass('hov-bg-k');
	}
});

//Main Color Settings
$(document).on('click', '.main-color-none', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
	}
});
$(document).on('click', '.main-color-a', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-a');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-a');
	}
});
$(document).on('click', '.main-color-b', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-b');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-b');
	}
});
$(document).on('click', '.main-color-c', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-c');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-c');
	}
});
$(document).on('click', '.main-color-d', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-d');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-d');
	}
});
$(document).on('click', '.main-color-e', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-e');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-e');
	}
});
$(document).on('click', '.main-color-f', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-f');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-f');
	}
});
$(document).on('click', '.main-color-g', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-g');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-g');
	}
});
$(document).on('click', '.main-color-h', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-h');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-h');
	}
});
$(document).on('click', '.main-color-i', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-i');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-i');
	}
});
$(document).on('click', '.main-color-j', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-j');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-j');
	}
});
$(document).on('click', '.main-color-k', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-icon').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-icon').addClass('color-k');	
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('color-k');
	}
});

//Main Hover Color Settings
$(document).on('click', '.main-hocolor-none', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
	}
});
$(document).on('click', '.main-hocolor-a', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-a');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-a');
	}
});
$(document).on('click', '.main-hocolor-b', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-b');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-b');
	}
});
$(document).on('click', '.main-hocolor-c', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-c');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-c');
	}
});
$(document).on('click', '.main-hocolor-d', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-d');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-d');
	}
});
$(document).on('click', '.main-hocolor-e', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-e');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-e');
	}
});
$(document).on('click', '.main-hocolor-f', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-f');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-f');
	}
});
$(document).on('click', '.main-hocolor-g', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-g');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-g');
	}
});
$(document).on('click', '.main-hocolor-h', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-h');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-h');
	}
});
$(document).on('click', '.main-hocolor-i', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-i');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-i');
	}
});
$(document).on('click', '.main-hocolor-j', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-j');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-j');
	}
});
$(document).on('click', '.main-hocolor-k', function(){
	if($('#ok-link-wrap .ok-link').hasClass('ok-list')){
		$('#ok-link-wrap .ok-list-text').removeClass('color-a color-b color-c color-d color-e color-f color-g color-h color-i color-j color-k');
		$('#ok-link-wrap .ok-list-text').addClass('color-k');		
	}else{
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').removeClass('hov-color-a hov-color-b hov-color-c hov-color-d hov-color-e hov-color-f hov-color-g hov-color-h hov-color-i hov-color-j hov-color-k');
		$('#ok-text-wrap .ok-text, #ok-text-wrap .is-link, #ok-link-wrap .ok-link, #ok-icode-wrap .ok-contact-btn').addClass('hov-color-k');
	}
});
//Border Color Settings
$(document).on('click', '.main-bdr-none', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
});
$(document).on('click', '.main-bdr-a', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-a');
});
$(document).on('click', '.main-bdr-b', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-b');
});
$(document).on('click', '.main-bdr-c', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-c');
});
$(document).on('click', '.main-bdr-d', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-d');
});
$(document).on('click', '.main-bdr-e', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-e');
});
$(document).on('click', '.main-bdr-f', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-f');
});
$(document).on('click', '.main-bdr-g', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-g');
});
$(document).on('click', '.main-bdr-h', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-h');
});
$(document).on('click', '.main-bdr-i', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-i');
});
$(document).on('click', '.main-bdr-j', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-j');
});
$(document).on('click', '.main-bdr-k', function(){
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').removeClass('bdr-a bdr-b bdr-c bdr-d bdr-e bdr-f bdr-g bdr-h bdr-i bdr-j bdr-k');
	$('.ok-preloader .preloader-wheel, .preloader-pre .preloader-wheel').addClass('bdr-k');
});

//START:: Dropdown Menu
$(document).on('click', '#dropdown01', function(){
	$('.dropdown-menu').toggleClass('show');
});//END:: Dropdown Menu

//START:: Show/Hide Blocks
$("#block-list-opt").on('change', function() {
	$(".section-block-panel").animate({ scrollTop: 0 }, 600);
	if($(this).val()==="all"){ 
		$('.hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec').show();
		//Hide Nav if exist
		if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
			$('.nav-sec').hide();
		}else{
			$('.nav-sec').show();
		}
		//Hide Footer if exist
		if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
			$('.footer-sec .temp-block-img').hide();
		}else{
			$('.footer-sec').show();
		}		
	}
	if($(this).val()==="nav"){ 
		$('.hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		//Hide Nav if exist
		if ($('#ok-sortable-section').find('header.ok-section').length > 0) {
			$('.nav-sec').hide();
		}else{
			$('.nav-sec').show();
		}
	}
	if($(this).val()==="header"){ 
		$('.nav-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.hero-sec').show();
	}
	if($(this).val()==="feature"){ 
		$('.nav-sec, .hero-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.features-sec').show();
	}
	if($(this).val()==="content"){ 
		$('.nav-sec, .hero-sec, .features-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.content-sec').show();
	}
	if($(this).val()==="gallery"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.gallery-sec').show();
	}
	if($(this).val()==="pricing"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.pricing-sec').show();
	}
	if($(this).val()==="team"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.team-sec').show();
	}
	if($(this).val()==="status"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.status-sec').show();
	}
	if($(this).val()==="contact"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.contact-sec').show();
	}
	if($(this).val()==="testimony"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.testimony-sec').show();
	}
	if($(this).val()==="brand"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .cta-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.brand-sec').show();
	}
	if($(this).val()==="cta"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .blog-sec, .newsletter-sec, .footer-sec').hide();
		$('.cta-sec').show();
	}
	if($(this).val()==="blog"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .newsletter-sec, .footer-sec').hide();
		$('.blog-sec').show();
	}
	if($(this).val()==="newsletter"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .footer-sec').hide();
		$('.newsletter-sec').show();
	}
	if($(this).val()==="footer"){ 
		$('.nav-sec, .hero-sec, .features-sec, .content-sec, .gallery-sec, .pricing-sec, .team-sec, .status-sec, .contact-sec, .testimony-sec, .brand-sec, .cta-sec, .blog-sec, .newsletter-sec').hide();
		//Hide Footer if exist
		if ($('#ok-sortable-section').find('footer.ok-section').length > 0) {
			$('.footer-sec').hide();
			$('.footer-sec').addClass('hide-footer');
		}else{
			$('.footer-sec').show();
			$('.footer-sec').removeClass('hide-footer');
		}
	}
});
//END:: Show/Hide Blocks

//START:: Image Cropping/Editing
$(document).on('click', '#sec-image-cropping', function(){
	var imgCropSrc =  $('#ok-section-wrap').find('.ok-section.bgimage-string').css('background-image').replace(/^url\(['"](.+)['"]\)/, '$1');
	var crop = jSuites.crop(document.getElementById('image-cropper'), {
		//area: [ 1920, 1080 ],
		crop: [ 100, 100 ],
		value: ''+imgCropSrc+'',
	});
	document.getElementById('rotate').oninput = function() {
		document.getElementById('image-cropper').crop.rotate(this.value);
	}
	document.getElementById('zoom').oninput = function() {
		document.getElementById('image-cropper').crop.zoom(this.value);
	}
	document.getElementById('image-getter').onclick = function() {
		document.getElementById('image-cropper-result').children[0].src = document.getElementById('image-cropper').crop.getCroppedImage().src;
		//document.getElementById('ok-img-wrap').children[1].src = document.getElementById('image-cropper').crop.getCroppedImage().src; 
		$('#ok-section-wrap').find('.ok-section.bgimage-string').css('background-image', 'url('+document.getElementById('image-cropper').crop.getCroppedImage().src+')');
	}
	$('#image-editor').show();
});
//START:: Image Cropping/Editing
$(document).on('click', '.image-cropping', function(){
	//var imgCropSrc = document.getElementById('ok-img-wrap').children[1].src;
	var imgCropSrc = $('#ok-img-wrap').find('.image-string:not(.ok-link-image.image-string)').attr('src');
	var crop = jSuites.crop(document.getElementById('image-cropper'), {
		//area: [ 1920, 1080 ],
		crop: [ 100, 100 ],
		value: ''+imgCropSrc+'',
	});
	document.getElementById('rotate').oninput = function() {
		document.getElementById('image-cropper').crop.rotate(this.value);
	}
	document.getElementById('zoom').oninput = function() {
		document.getElementById('image-cropper').crop.zoom(this.value);
	}
	document.getElementById('image-getter').onclick = function() {
		document.getElementById('image-cropper-result').children[0].src = document.getElementById('image-cropper').crop.getCroppedImage().src;
		$('#ok-img-wrap').find('a.image-string').attr('href', document.getElementById('image-cropper').crop.getCroppedImage().src);
		$('#ok-img-wrap').find('.image-string:not(a.image-string)').attr('src', document.getElementById('image-cropper').crop.getCroppedImage().src);
	}
	$('#image-editor').show();
	
	//Get Crop size
	$(document).on('click','.jcrop-area', function(){
		$('.crop-height').text($('.jcrop-area').height());
		$('.crop-width').text($('.jcrop-area').width());
	});
});
$(document).on('click', '#close-image-editor', function(){
	$('#image-editor').hide();
});//END:: Image Cropping/Editing 

//START:: Paste Element
$(document).on('click', '.paste-element', function(){
	if($('#copy-db').find('.ok-column.copyed').length>0){
		$($('#copy-db').html()).insertAfter('.ok-column-handle');
	}else{
		$($('#copy-db').html()).insertAfter($(this).parent().next());
	}
	$('#copy-db').html('');
	$('#copy-db').removeClass('has-clipboard');
	$('#copy-db-css').html('');
	$('.copyed').removeClass('copyed');
});//END:: Paste Element

/*////////////////////////////////////////////////////////////
					MULTIPLE CONTROLS
//////////////////////////////////////////////////////////*/
//For Dynamic Updates/Tigger
$(document).on('click', '#saveBlockCodes, .paste-element, #ltr-on-btn, #rtl-on-btn, #move-section-up, #move-section-down, #yes-delete, #switch-mob, #close-section, #scaledown-overlay, #clone-section, #duplicate-row, #duplicate-column', function(){
	//Extra space/lines
	$('#body-data').html().replace(/^\s*[\r\n]/gm, '');
	//For first-section offset
	$('.ok-section').css('padding-top', '');
	if($('#ok-sortable-section .fixed-top').length>0){
		$('.ok-section').removeClass('first-section');
		$('.ok-section').eq(1).addClass('first-section');
	}
	//Remove from Header
	$('header.ok-section').removeClass('first-section');
	$('header.ok-section').removeAttr('style');
	//For extra padding	
	if(document.querySelector(".first-section")) {
		if(document.querySelector("#navbarScrollable")) {
			let menuHeight = document.querySelector('#navbarScrollable').clientHeight;
			let totalHeight = menuHeight * 2;
			let getFirstSection = document.querySelector('.first-section');
			getFirstSection.style.paddingTop = totalHeight+'px';
		}
	}
	//Move Main Navigation Menu to topmost section
	$('#ok-sortable-section').prepend($('#ok-sortable-section #navbarScrollable:not(#ok-section-wrap #navbarScrollable)'));
	//Move Main Footer Section to last of all sections
	$('#ok-sortable-section').append($('#ok-sortable-section footer.ok-section:not(#ok-section-wrap footer.ok-section)'));
	
	
	//Tigger on click show video popup
	if($('a').hasClass("popup-video")){
		MediaBox('.popup-video');
	}
	//For Swiper Slider 1 with loop
	if($("#ok-sortable-section .swiper-1").length>0){
		var swiperOneLoop = new Swiper('.swiper-1', {
		slidesPerView: 1,
		spaceBetween: 0, 
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
		});
	}
	//For Swiper Slider 2 with loop
	if($("#ok-sortable-section .swiper-2-no-loop").length>0){
	var swiperTwoNoLoop = new Swiper('.swiper-2-no-loop', {
		slidesPerView: 2,
		spaceBetween: 20, 
		breakpoints: {
		300: {
			slidesPerView: 1,
			spaceBetween: 10
		},
		575: {
			slidesPerView: 1,
			spaceBetween: 10
		},
		767: {
			slidesPerView: 2,
			spaceBetween: 20
		},
		991: {
			slidesPerView: 2,
			spaceBetween: 20
		},
		1199: {
			slidesPerView: 2,
			spaceBetween: 20
		},

		},
		navigation: {
		nextEl: '.swiper-ctrl-next',
		prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	//For Swiper Slider 2 without loop
	if($("#ok-sortable-section .swiper-2").length>0){
	var swiperTwo = new Swiper('.swiper-2', {
		slidesPerView: 2,
		spaceBetween: 20, 
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 2,
				spaceBetween: 20
			},	
		},
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	//For Swiper Slider 3 without loop
	if($("#ok-sortable-section .swiper-3").length>0){
	var swiperThree = new Swiper('.swiper-3', {
		slidesPerView: 3,
		spaceBetween: 20,
		// Responsive breakpoints
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 3,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 3,
				spaceBetween: 20
			},	
		},
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	}
	//For Swiper Slider 4 without loop
	if($("#ok-sortable-section .swiper-4").length>0){
	var swiperFour = new Swiper('.swiper-4', {
		slidesPerView: 4,
		spaceBetween: 20,
		// Responsive breakpoints
		breakpoints: {
			300: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			575: {
				slidesPerView: 1,
				spaceBetween: 10
			},
			767: {
				slidesPerView: 2,
				spaceBetween: 20
			},
			991: {
				slidesPerView: 4,
				spaceBetween: 20
			},
			1199: {
				slidesPerView: 4,
				spaceBetween: 20
			},	
		},
		// Navigation arrows
		navigation: {
			nextEl: '.swiper-ctrl-next',
			prevEl: '.swiper-ctrl-prev',
		}
	});
	}
});

//START: SHOW/HIDE Responsive Hidden Elements
$(document).on('click', '#show-hidden-elements', function() {
	$(this).hide();
	$('#hide-hidden-elements').show();
	$(".d-xxl-none").addClass('ok-display-block');
});
$(document).on('click', '#hide-hidden-elements', function() {
	$(this).hide();
	$('#show-hidden-elements').show();
	$(".d-xxl-none").removeClass('ok-display-block');
});//END: SHOW/HIDE Responsive Hidden Elements

//START:: Responsive Check
 $(document).on('click', '#switch-mob', function(){
	//For mobile preview
	$('<div id="mobile-view" dir="ltr"></div>').insertAfter('#body-data');
	$("#mobile-view").css("display", "block");
	$("html, body").css("overflow", "hidden");
	//For Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();
	//Hide deleted elements
	$('#ok-hide-hidden-ele-btn').hide();
	$('#ok-show-hidden-ele-btn').show();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
	$('#mobile-view').html(`
	<div id="mobile-frame">
		<div id="mobile-view-options">
			<button class="desktop-alt-opt mob-prev" title="Large desktop"><i class="fas fa-tv"></i></button>
			<button class="desktop-view-opt mob-prev" title="Medium desktop"><i class="fas fa-desktop"></i></button>
			<button class="tablet-alt-opt mob-prev" title="Tablet landscape"><i class="fas fa-tablet-alt fa-rotate-270"></i></button>
			<button class="tablet-view-opt mob-prev" title="Tablet portrait"><i class="fas fa-tablet-alt"></i></button>
			<button class="mobile-alt-opt mob-prev" title="Mobile landscape"><i class="fas fa-mobile-alt fa-rotate-270"></i></button>
			<button class="mobile-view-opt mob-prev" title="Mobile portrait"><i class="fas fa-mobile-alt"></i></button>
			<button class="mobile-frame-close-btn float-right">Close</button>
		</div>
		<div id="iframe-loading"><img class="hw-45" src="okcc/img/progress-image.gif" alt=""></div>
		<iframe id="mobile-device">
		</iframe>
	</div>`);
	$('.mob-prev').removeClass('white bg-blue');
	$('.mobile-view-opt').addClass('white bg-blue');
//Load Dynamic iFrame Opera
$("#mobile-device").ready( function(){
	let mobHead = $("#mobile-device").contents().find("head");
		mobHead.html($('head').html());
	let deviceMobPreview = $("#mobile-device").contents().find("body");
	deviceMobPreview.html($('#body-data').html());
	//Remove text attr
	deviceMobPreview.find('.ok-text').removeAttr('data-placeholder contenteditable');
	deviceMobPreview.append($('#ok-db').html());
	deviceMobPreview.append(`
	<style>
		html {
			display: block;
		}
		.hide-this-db,
		.ok-hide-name-field,
		.ok-deleted-elements {
			display: none!important;
		}
		a {
			pointer-events: none;
		}
		/* For Empty element button	*/
		.add-element-btn {
			padding: 50px 50px;
			width: 100%;
			color: #333333;
			background: #fafafa;
			font-family: "Arial", Helvetica, sans-serif;
			font-size: 24px;
			border: 1px solid blue;
		}
		.add-element-btn:hover {
			color: blue;
		}
		.add-element-btn i {
			margin-right: 10px;
			color: blue;
		}
	<\/style>
	<script type="text/javascript" src="okcc/js/jquery-min.js"><\/script>
	<script type="text/javascript"> 
		$("#mobile-device").contents().find("a").each(function(index) {
			$(this).on("click", function(event) {
				event.preventDefault();
				event.stopPropagation();
				alert("Click action is disabled in the Preview mode.");
			});
		});
		
	<\/script>`);
	// Set Video iframe
	deviceMobPreview.find('.embed-container').each(function() {
		let getVidIdFrame1 = $(this).attr('data-vidid');
		if($(this).hasClass('ok-youtube')){
			$(this).append('<iframe width="560" height="315" src="'+getVidIdFrame1+'" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"></iframe>');
		}
		if($(this).hasClass('ok-vimeo')){
			$(this).append('<iframe width="560" height="315" src="'+getVidIdFrame1+'" title="Vimeo video player" frameborder="0" allow="autoplay; fullscreen; picture-in-picture"></iframe>');
		}
	});
	//Hide preloading
	$('#iframe-loading').hide();
});
//Load Dynamic iFrame Chrome and FF
$("#mobile-device").on('load', function(){
	let mobileHead = $("#mobile-device").contents().find("head");
		mobileHead.html($('head').html());
	let deviceMobilePreview = $("#mobile-device").contents().find("body");
	deviceMobilePreview.html($('#body-data').html());
	//Remove text attr
	deviceMobilePreview.find('.ok-text').removeAttr('data-placeholder contenteditable');
	deviceMobilePreview.append($('#ok-db').html());
	deviceMobilePreview.append(`
	<style>
		html {
			display: block;
		}
		.hide-this-db,
		.ok-hide-name-field,
		.ok-deleted-elements {
			display: none!important;
		}
		a {
			pointer-events: none;
		}
		/* For Empty element button	*/
		.add-element-btn {
			padding: 50px 50px;
			width: 100%;
			color: #333333;
			background: #fafafa;
			font-family: "Arial", Helvetica, sans-serif;
			font-size: 24px;
			border: 1px solid blue;
		}
		.add-element-btn:hover {
			color: blue;
		}
		.add-element-btn i {
			margin-right: 10px;
			color: blue;
		}
	<\/style>
	<script type="text/javascript" src="okcc/js/jquery-min.js"><\/script>
	<script type="text/javascript">
		$("#mobile-device").contents().find("a").each(function(index) {
			$(this).on("click", function(event) {
				event.preventDefault();
				event.stopPropagation();
				alert("Click action is disabled in the Preview mode.");
			});
		});
	<\/script>`); 
	// Set Video iframe
	deviceMobilePreview.find('.embed-container').each(function() {
		let getVidIdFrame2 = $(this).attr('data-vidid');
		if($(this).hasClass('ok-youtube')){
			$(this).append('<iframe width="560" height="315" src="'+getVidIdFrame2+'" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"></iframe>');
		}
		if($(this).hasClass('ok-vimeo')){
			$(this).append('<iframe width="560" height="315" src="'+getVidIdFrame2+'" title="Vimeo video player" frameborder="0" allow="autoplay; fullscreen; picture-in-picture"></iframe>');
		}
	});
	//Hide preloading
	$('#iframe-loading').hide();
});

//Check LTR/RTL
if($('body').hasClass('rtl-on')){
	$("#mobile-device").contents().find("html").attr('lang', 'ar');
	$("#mobile-device").contents().find("html").attr('dir', 'rtl');
}
//Device switch
$(".desktop-alt-opt").click(function(){
	$('.mob-prev').removeClass('white bg-blue');
	$(this).addClass('white bg-blue');
	$('#mobile-device').css('min-width', '1400px');
});
$(".desktop-view-opt").click(function(){
	$('.mob-prev').removeClass('white bg-blue');
	$(this).addClass('white bg-blue');
	$('#mobile-device').css('min-width', '1200px');
});
$(".tablet-alt-opt").click(function(){
	$('.mob-prev').removeClass('white bg-blue');
	$(this).addClass('white bg-blue');
	$('#mobile-device').css('min-width', '992px');
});
$(".tablet-view-opt").click(function(){
	$('.mob-prev').removeClass('white bg-blue');
	$(this).addClass('white bg-blue');
	$('#mobile-device').css('min-width', '768px');
});
$(".mobile-alt-opt").click(function(){
	$('.mob-prev').removeClass('white bg-blue');
	$(this).addClass('white bg-blue');
	$('#mobile-device').css('min-width', '576px');
});
$(".mobile-view-opt").click(function(){
	$('.mob-prev').removeClass('white bg-blue');
	$(this).addClass('white bg-blue');
	$('#mobile-device').css('min-width', '400px');
});
$(".mobile-frame-close-btn").click(function(){
	//Add class to first Section for Mobile Hero
	$('.section:first').removeClass('mobile-hero');
    $("#switch-mob").css("display", "block");
	$("#mobile-view").css("display", "none");
	$("html").css("overflow-y", "scroll");
	$('#mobile-view').remove();
});	
});//END:: Responsive Check

//START::  Download Function
//Convert File for Download
$(document).on('click', '#convert-file', function(e) {
e.preventDefault();
$("#convert-file").html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
//START:: Code iFrame Load
let $iframe = $('#fileconvert-frame');
	$iframe.ready(function() {
    $iframe.contents().find("body").append('<p id="fileconvert-updated" style="display:none;"></p>');
//If Code iFrame Load
if($("#fileconvert-frame").contents().find('#fileconvert-updated').length>0){
	$("#save-files").html('Save Changes');
	$("#update-files").html('Update');
	$("#project-frame").hide();
		
	//First Removes Dynamic Elements If Exist	
	$('#ok-text-wrap').contents().unwrap();
	$('#setting-tools').remove();	
	$('#ok-img-wrap').contents().unwrap();
	$('#bgimage-temp-wrap').contents().unwrap();
	$('#ok-link-wrap').contents().unwrap();
	$('#ok-icode-wrap').contents().unwrap();
	
	//For Responsive Hidden
	$(".d-xxl-none").removeClass('ok-display-block');
	$('#hide-hidden-elements').hide();
	$('#show-hidden-elements').show();
	//Hide deleted elements
	$('#ok-hide-hidden-ele-btn').hide();
	$('#ok-show-hidden-ele-btn').show();
	$('.ok-temp-show-deleted-elements').addClass('ok-deleted-elements');
	$('.ok-deleted-elements').removeClass('ok-temp-show-deleted-elements');
	$('.download-popup-wrap').addClass('download-popup-on'); 
	$('#download-box-section').show();
	$('#import-project-file').hide();
	//Animate the scroll to top
    $('html, body').animate({
        scrollTop: 0,
    }, 100); 
	//Remove Classes from Navigation bar
	$('.navbar.fixed-top').removeClass('sticky');
	$('#logo-a').removeClass('d-none');
	$('#logo-b').removeClass('d-block');
	
	//Head Content to head-html
	$('#head-html').html($('head').html());
	
	//For Preloader
	$('.ok-preloader').removeAttr('style');
	
	//Body Content to body-html
	$('#body-html').html($('#body-data').html());
	$('#body-html .ok-deleted-elements').remove();	
	
	//////////Active used Source Files////////////
	//For main app css
	$('#head-html').find('#appcss').remove();
	
	//For Fontawesome
	if($("#body-html i.fas, #body-html i.fab, #body-html i").length>0){
		$('#head-html').find('#fontawesome').remove();
		$('<link id="fontawesome" href="assets/css/fontawesome.min.css" rel="stylesheet">').insertAfter('#head-html #bootstrap-css');
		$('#head-html').find('#fontawesome').removeAttr('id');
	}else{
		$('#head-html').find('#fontawesome').remove();
	}
	
	//For Swiper
	if($("#body-html .swiper-1, #body-html .swiper-2, #body-html .swiper-3, #body-html .swiper-4, #body-html .swiper-2-no-loop").length>0){
		$('#head-html').find('#swiper-css').remove();
		$('#body-html').find('#swiper-js').remove();
		$('<link id="swiper-css" href="assets/css/swiper-bundle.css" rel="stylesheet">').insertAfter('#head-html #bootstrap-css');
		$('<script id="swiper-js" src="assets/js/swiper-bundle.min.js"></script>').insertAfter('#body-html #bootstrap-js');
		$('#head-html').find('#swiper-css').removeAttr('id');
		$('#body-html').find('#swiper-js').removeAttr('id');
	}else{
		$('#head-html').find('#swiper-css').remove();
		$('#body-html').find('#swiper-js').remove();
	}
	//For Model popup video
	if($('#body-html a').hasClass("popup-video")){
		$('#head-html').find('#mediabox-css').remove();
		$('#body-html').find('#mediabox-js').remove();
		$('<link id="mediabox-css" href="assets/css/mediabox.min.css" rel="stylesheet">').insertAfter('#head-html #bootstrap-css');
		$('<script id="mediabox-js" src="assets/js/mediabox.min.js"></script>').insertAfter('#body-html #bootstrap-js');
		$('#head-html').find('#mediabox-css').removeAttr('id');
		$('#body-html').find('#mediabox-js').removeAttr('id');
	}else{
		$('#head-html').find('#mediabox-css').remove();
		$('#body-html').find('#mediabox-js').remove();
	}
	//Removes Empty Attr
	$('#body-html .ok-text, #body-html .ok-link-text, #body-html .ok-link, #body-html .ok-icode').removeAttr('data-placeholder');
	
	//START:: AOS
	if($('body').hasClass('aos-on')){
		$('#body-html .ok-row').each(function() { 
			//No. of column is 1
			if($(this).find('.ok-column').length ==1){
				//Column
				$(this).find('.ok-column:not(footer .ok-column)').attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').attr('data-aos-duration', '1000');
				//Text
				$(this).find('.ok-text:not(footer .ok-text), .ok-card:not(footer .ok-card), .ok-image:not(footer .ok-image), .ok-link:not(footer .ok-link), form:not(footer form)').attr('data-aos', 'fade-up');
				$(this).find('.ok-text:not(footer .ok-text), .ok-card:not(footer .ok-card), .ok-image:not(footer .ok-image), .ok-link:not(footer .ok-link), form:not(footer form)').attr('data-aos-delay', '500');
				$(this).find('.ok-text:not(footer .ok-text), .ok-card:not(footer .ok-card), .ok-image:not(footer .ok-image), .ok-link:not(footer .ok-link), form:not(footer form)').attr('data-aos-duration', '1000');
			}else
			//AOS for 2 Columns
			if($(this).find('.ok-column').length ==2){
				//First Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos', 'fade-right');
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos-duration', '1000');
				//Third Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos', 'fade-left');
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos-duration', '1000');
			}else
			//No. of column is 3
			if($(this).find('.ok-column').length ==3){
				//First Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos', 'fade-right');
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos-duration', '1000');
				//Second Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos-duration', '1000');
				//Third Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(2).attr('data-aos', 'fade-left');
				$(this).find('.ok-column:not(footer .ok-column)').eq(2).attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').eq(2).attr('data-aos-duration', '1000');
			}else
			//No. of column is 4
			if($(this).find('.ok-column').length ==4){
				//First Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').eq(0).attr('data-aos-duration', '1000');
				//Second Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos-delay', '600');
				$(this).find('.ok-column:not(footer .ok-column)').eq(1).attr('data-aos-duration', '1000');
				//Third Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(2).attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').eq(2).attr('data-aos-delay', '700');
				$(this).find('.ok-column:not(footer .ok-column)').eq(2).attr('data-aos-duration', '1000');
				//Fourth Column
				$(this).find('.ok-column:not(footer .ok-column)').eq(3).attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').eq(3).attr('data-aos-delay', '800');
				$(this).find('.ok-column:not(footer .ok-column)').eq(3).attr('data-aos-duration', '1000');
			}else {
				$(this).find('.ok-column:not(footer .ok-column)').attr('data-aos', 'fade-up');
				$(this).find('.ok-column:not(footer .ok-column)').attr('data-aos-delay', '500');
				$(this).find('.ok-column:not(footer .ok-column)').attr('data-aos-duration', '1000');		
			}
		});
		$('#head-html').find('#aos-css').remove();
		$('#body-html').find('#aos-js').remove();
		$('<link id="aos-css" href="assets/css/aos.css" rel="stylesheet">').insertAfter('#head-html #bootstrap-css');
		$('<script id="aos-js" src="assets/js/aos.js"></script>').insertAfter('#body-html #bootstrap-js');
		$('#head-html').find('#aos-css').removeAttr('id');
		$('#body-html').find('#aos-js').removeAttr('id');
	}//END:: AOS
	
	//START:: Luge Animation
	if($('body').hasClass('luge-on')){
		$('#body-html .ok-row').each(function() { 
			//Column
			$(this).find('.ok-column:not(footer .ok-column), .card-body:not(footer .card-body)').attr('data-lg-reveal', 'fade-to-top');
			$(this).find('.ok-column:not(footer .ok-column), .card-body:not(footer .card-body)').attr('data-lg-reveal-stagger', '0.3');
		});
		$('#head-html').find('#luge-css').remove();
		$('#body-html').find('#lugejs-js').remove();
		$('<link id="luge-css" href="assets/css/luge.css" rel="stylesheet">').insertAfter('#head-html #bootstrap-css');
		$('<script id="lugejs-js" src="assets/js/luge.js"></script>').insertAfter('#body-html #bootstrap-js');
		$('#head-html').find('#luge-css').removeAttr('id');
		$('#body-html').find('#lugejs-js').removeAttr('id');
		//Wrap all sections
		$("#body-html .ok-section:not(#body-html header.ok-section)").wrapAll('<div data-lg-smooth ></div>');
	}//END:: Luge Animation
	
	//Remove gLightbox Gallery attr
	$('#body-html a.image-string').removeAttr('data-imgid');
	$('#body-html a.image-string').removeClass('image-string');
	
	//Add gLightbox Gallery
	if($('#body-html a').hasClass('glightbox')){
		$('#head-html').find('#glightbox-css').remove();
		$('#head-html').find('#glightbox-js').remove();
		$('<link id="glightbox-css" href="assets/css/glightbox.min.css" rel="stylesheet">').insertAfter('#head-html #bootstrap-css');
		$('<script id="glightbox-js" src="assets/js/glightbox.min.js"></script>').insertAfter('#body-html #bootstrap-js');
		$('#head-html').find('#glightbox-css').removeAttr('id');
		$('#body-html').find('#glightbox-js').removeAttr('id');
	}

	//For Empty Nav List
	if ($('#body-html .navbar-nav').length> 0){
		if ($('#body-html .navbar-nav').html().trim() == ''){
			$('#body-html .navbar-nav').remove();
			$('#body-html .navbar').removeAttr('id');
			$('#body-html .ok-nav-cta').addClass('ms-auto');
		}
	}
	//For Empty Nav CTA List
	if ($('#body-html .ok-nav-cta').length> 0){
		if ($('#body-html .ok-nav-cta').html().trim() == ''){
			$('#body-html .ok-nav-cta').remove();
		}
	}	
	
	//For Toggle Button
	if ($('#body-html .offcanvas-collapse').length> 0){
		if ($('#body-html .offcanvas-collapse').html().trim() == ''){
			$('#body-html .offcanvas-collapse, #body-html #navbarSideCollapse, #body-html .back-overlay').remove();
			var offCanvPanel = '';
		}else{
			var offCanvPanel = `
//For Offcanvas Menu
 document.querySelector('#navbarSideCollapse').addEventListener('click', function () {
    document.querySelector('.offcanvas-collapse').classList.toggle('open');
    document.querySelector('.menu-bar').classList.toggle('fa-times');
    document.querySelector('.back-overlay').classList.toggle('back-overlay-active');
	document.body.scrollTop = 0;
	document.documentElement.scrollTop = 0;
});

let navLink = document.querySelectorAll(".navbar-collapse a:not(.dropdown-toggle), .back-overlay");
let menuHeight = document.querySelector('.navbar').clientHeight;
let getSection = document.querySelectorAll('section:not(.vh-100):not(.first-section)');
let totalHeight = menuHeight * 2;
for (let i = 0; i < navLink.length; i++) {
	navLink[i].addEventListener("click", () => {
	document.querySelector(".offcanvas-collapse").classList.remove("open");
    document.querySelector('.menu-bar').classList.remove('fa-times');
    document.querySelector('.back-overlay').classList.remove('back-overlay-active');
	//For Offset Height
	getSection.forEach(x=>x.style.cssText += 'padding-top:'+totalHeight+'px !important; padding-bottom:'+menuHeight+'px !important;');
	});
}
//On MouseWheel Scroll
document.addEventListener("mousewheel", function(event){
  if(event.wheelDelta >= 0){
    getSection.forEach(x=>x.style.removeProperty('padding-top'));
    getSection.forEach(y=>y.style.removeProperty('padding-bottom'));
  }else{   
    getSection.forEach(x=>x.style.removeProperty('padding-top'));
    getSection.forEach(y=>y.style.removeProperty('padding-bottom'));
  }
});
//For First Section
document.addEventListener("DOMContentLoaded", function(){
  let getFirstSection = document.querySelector('.first-section');
  getFirstSection.style.cssText += 'padding-top: '+totalHeight+'px!important';
});\n`;
		}
	}else {		
		var offCanvPanel = '';
	}

//For Google Analytics
if($("#ok-db #google-analytics-id").length > 0){
	var googleAnalyticID = document.getElementById("google-analytics-id").innerHTML;
	var googleAnalyticCode = ''
	+'// Google Analytics\n'
	+'window.dataLayer = window.dataLayer || [];\n'
	+'function gtag(){dataLayer.push(arguments);}\n'
	+"gtag('js', new Date());\n"
	+"gtag('config', '"+googleAnalyticID+"');\n";
	removejscssfile("https://www.googletagmanager.com/gtag/js?id="+googleAnalyticID, "js"); //remove duplicate source
	$('#body-html').find('#analytics-src').remove();
	$('<script id="analytics-src" async src="https://www.googletagmanager.com/gtag/js?id='+googleAnalyticID+'"></script>').insertAfter('#body-html #bootstrap-js');
	$('#body-html').find('#analytics-src').removeAttr('id');
} else {
	var googleAnalyticID = '';
	var googleAnalyticCode = '';
}

//For Facebook Messanger Chat
if($("#ok-db #fb-messanger-id").length > 0){
	var fbMessangerID = document.getElementById("fb-messanger-id").innerHTML;
	var fbMessangerCode = ''
	+'// Messenger Chat Plugin Code\n'		
	+"var chatbox = document.getElementById('fb-customer-chat');\n"
	+'chatbox.setAttribute("page_id", "'+fbMessangerID+'");\n'
	+'chatbox.setAttribute("attribution", "biz_inbox");\n'
	+'window.fbAsyncInit = function() {\n'
	+'  FB.init({\n'
	+'    xfbml            : true,\n'
	+"    version          : 'v12.0'\n"
	+'  });\n'
	+'};\n'
	+'(function(d, s, id) {\n'
	+'  var js, fjs = d.getElementsByTagName(s)[0];\n'
	+'  if (d.getElementById(id)) return;\n'
	+'  js = d.createElement(s); js.id = id;\n'
	+"  js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';\n"
	+'  fjs.parentNode.insertBefore(js, fjs);\n'
	+"}(document, 'script', 'facebook-jssdk'));\n";
$(`
<!-- Messenger Chat Plugin Code -->
<div id="fb-root"></div>
<!-- Your Chat Plugin code -->
<div id="fb-customer-chat" class="fb-customerchat">
</div>\n`).insertBefore('#body-html #bootstrap-js');
} else {
	var fbMessangerID = '';
	var fbMessangerCode = '';
}

// Set Video iframe
$('#body-html .embed-container').each(function() {
	let getVidId = $(this).attr('data-vidid');
	if($(this).hasClass('ok-youtube')){
		$(this).append('<iframe width="560" height="315" src="'+getVidId+'" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"></iframe>');
	}
	if($(this).hasClass('ok-vimeo')){
		$(this).append('<iframe width="560" height="315" src="'+getVidId+'" title="Vimeo video player" frameborder="0" allow="autoplay; fullscreen; picture-in-picture"></iframe>');
	}
});

	////////////////////Removes Classes//////////////
	//Remove empty DIVs
	$('#body-html .ok-flex, #body-html .ok-card .card-body').each(function() { 
		if ($(this).html().trim() == ''){
			$(this).remove();
		}
	});
	//For text element
	$('#body-html .ok-text, #body-html .ok-link').removeAttr('contenteditable');
	//For All Elements
	$('#body-html input, #body-html form, #body-html footer, #body-html main, #body-html label, #body-html p, #body-html div, #body-html section, #body-html button, #body-html img, #body-html a, #body-html span, #body-html h1, #body-html h2, #body-html h3, #body-html h4, #body-html h5, #body-html h6, #body-html ul, #body-html li, #body-html figure, #body-html nav, #body-html header, #body-html body, #body-html i, #body-html aside, #body-html main').each(function () {
		$(this).removeClass('ok-display-block ok-hide-mob ok-hide-tab ok-hide-desk ok-hide-mobtab ok-hide-mobdesk ok-hide-tabdesk ok-group-container ok-code ok-video-image ok-video-btn ok-list ok-list-icon ok-list-text ok-flex ok-name-field ok-email-field ok-message-field ok-submit-field ok-swiper-btn ok-top-card-image ok-nav-cta ok-preloader ok-sub ok-only-icon ok-link-icon ok-contact ok-contact-name ok-email-id ok-message-id ok-contact-btn ok-link-icon ok-link-arrow-clear ok-header-fixed ok-header ok-column ok-column-handle ok-section ok-footer ok-text ok-link-text ok-bgimage ok-card-arrow ok-link-arrow ok-link-li ok-text-li ok-logo ok-nav-sortable ok-row ok-col-sortable ok-card ok-card-sortable ok-link-li ok-text-li ok-icode ok-icon ok-link ok-row-sortable ok-column-bg ok-card-bg ok-line ok-hide-clone ok-image ok-carousel-item ok-imglink ok-only-text ok-lightbox ok-lightbox-image ok-lightbox-link ok-link-image ok-map ok-youtube ok-vimeo ok-header ok-vidlink');
		//Removes AOS
		if ($(this).attr('data-aos')) { 
			$(this).removeClass('aos-init aos-animate'); 
		}
        if ($(this).attr('data-placeholder')) { 
			$(this).removeAttr('data-placeholder'); 
		}	
        if ($(this).attr('draggable')) { 
			$(this).removeAttr('draggable'); 
		}
		//Removes Empty Class selector
		if ($(this).attr('cla