<?php
require ("core.php"); 
$validation->login_check();
if(isset($_GET['logout'])){
  $validation->logout();
}
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta property="og:title" content="ItsLink - Dashboard">
    <meta name="description" content="ItsLink - Dashboard">
    <meta property="og:description" content="ItsLink - Dashboard">
    <meta property="og:url" content="">
    <meta name="twitter:card" content="summary_large_image">
    <title>ItsLink - Dashboard</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/app.css" rel="stylesheet">
    <link rel="shortcut icon" href="assets/img/favicon.svg">
    <style>
	  html {
		display : none;
	  }
      body {
        background-color: #f6f6f6;
      }
	  .box-shadow { box-shadow: 0 .25rem .75rem rgba(0, 0, 0, .05); }
    </style>
  </head>
  <body>
	
<section class="py-50">
  <div class="container-fluid cw-85">
	<div class="row g-4 d-flex justify-content-center">
		<div style="width: 50%; float: left; text-align: left;">
			<img src="assets/img/itslink-logo.png" alt="itslink logo" style="height: 30px;">
		</div>
		<div style="width: 50%; float: right; text-align: right; padding-right: 10px;">
          <a href="dashboard.php?logout=yes">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-box-arrow-right" viewBox="0 0 16 16">
  <path fill-rule="evenodd" d="M10 12.5a.5.5 0 0 1-.5.5h-8a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5h8a.5.5 0 0 1 .5.5v2a.5.5 0 0 0 1 0v-2A1.5 1.5 0 0 0 9.5 2h-8A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h8a1.5 1.5 0 0 0 1.5-1.5v-2a.5.5 0 0 0-1 0v2z"/>
  <path fill-rule="evenodd" d="M15.854 8.354a.5.5 0 0 0 0-.708l-3-3a.5.5 0 0 0-.708.708L14.293 7.5H5.5a.5.5 0 0 0 0 1h8.793l-2.147 2.146a.5.5 0 0 0 .708.708l3-3z"/>
</svg> <strong>Logout</strong>
          </a>
		</div>
	  
      <div class="col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
		<div class="card w-100 rounded border box-shadow mt-20">
			<div class="card-body p-20">
				<h2 class="text-muted">QR Code</h2>
				<p class="text-muted mb-20">Right-click on the image to save/download.</p>
				<div id="qrcode"></div>
			</div>
        </div>
      </div>
	  
      <div class="col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
		<div class="card w-100 rounded border box-shadow mt-20">
			<div class="card-body p-20">
				<h2 class="text-muted">Your Site</h2>
				<h6 class="text-muted mb-20"><?php echo "https://".$_SERVER['SERVER_NAME']."/".$_SESSION['username'];?></h6>
<a target="_blank" href="<?php echo $_SESSION['username'];?>" class="btn btn-primary my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
  <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
  <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
</svg> Preview</a>
				<a target="_blank" href="<?php echo 'edit-'.$_SESSION['username'].'.php';?>" class="btn btn-success my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
  <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
  <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
</svg> Edit Site</a>
<hr class="divider">

<h2 class="text-muted">Site for clients</h2>
<p class="text-muted">Create and download a static website with our page builder to share with your clients or host them on your desired server/hosting.</p>


<?php
        $payment = json_decode(file_get_contents('db.php'),TRUE)[$_SESSION['username']]['payment'];
        if($payment != 1){
        ?>
            <button class="btn btn-secondary" disabled><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-richtext" viewBox="0 0 16 16">
  <path d="M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5L14 4.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5h-2z"/>
  <path d="M4.5 12.5A.5.5 0 0 1 5 12h3a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5zm0-2A.5.5 0 0 1 5 10h6a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5zm1.639-3.708 1.33.886 1.854-1.855a.25.25 0 0 1 .289-.047l1.888.974V8.5a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V8s1.54-1.274 1.639-1.208zM6.25 6a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5z"/>
</svg> Page Builder</button>
  <?php }else{
	  ?>
	  
            <a href="https://itslink.me/app/editor.php" class="btn btn-secondary" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-richtext" viewBox="0 0 16 16">
  <path d="M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5L14 4.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5h-2z"/>
  <path d="M4.5 12.5A.5.5 0 0 1 5 12h3a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5zm0-2A.5.5 0 0 1 5 10h6a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5zm1.639-3.708 1.33.886 1.854-1.855a.25.25 0 0 1 .289-.047l1.888.974V8.5a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V8s1.54-1.274 1.639-1.208zM6.25 6a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5z"/>
</svg> Page Builder</a>
<p class="text-danger mb-0">* Become an ItsLink subscriber to use this feature.</p>
	<?php } ?>
	
			</div>
        </div>
		
      </div>
	  
      <div class="col-sm-12 col-xl-4 col-xxl-4 col-md-12 col-lg-4">

        <?php
        $payment = json_decode(file_get_contents('db.php'),TRUE)[$_SESSION['username']]['payment'];
        if($payment != 1){
        ?>
		
		<div class="card w-100 rounded border box-shadow mt-20">
			<div class="card-body p-20">
				<h2>Pricing: <span class="text-muted">$</span><span class="text-danger fw-bold">20</span><span class="fs-14 text-muted">/year</span></h2>
				<p class="mt-15 text-muted">Become an <strong>ItsLink</strong> subscriber to continue using your site.</p>
				<a href="" target="_blank" class="btn btn-success my-2">Subscribe on Gumroad</a>
				<a href="" target="_blank" class="btn btn-dark my-2">Subscribe on PayPal</a>
				<p class="mt-15 text-muted"><strong>Indian</strong> and <strong>Nepali</strong> users can contact us for other payment options.</p>
				<p class="text-danger mb-0">* After making the payment, please send us an email at birjuxz@gmail.com along with your username.</p>
			</div>
        </div>
		
        <?php } ?>
      </div>
	  
    </div>
	<h1 class="mt-30 text-muted fs-24">Select Templates</h1>
	<hr class="divider">
	<div class="row g-4 d-flex justify-content-center">
      <div class="col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
		<div class="card w-100 rounded border box-shadow mt-50">
			<div class="card-body p-20">
				<h2 class="fs-18">Demo Template</h2>
			</div>
			<div class="card-footer no-bdr bg-white p-20">
			<a target="_blank" href="<?php echo $_SESSION['username'];?>" class="btn btn-primary my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
  <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
  <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
</svg> Preview</a>
				<a target="_blank" href="<?php echo 'edit-template.php';?>" class="btn btn-success my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
  <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
  <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
</svg> Use this Template</a>
			</div>
        </div>
		</div>
      <div class="col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
		<div class="card w-100 rounded border box-shadow mt-50">
			<div class="card-body p-20">
				<h2 class="fs-18">Demo Template</h2>
			</div>
			<div class="card-footer no-bdr bg-white p-20">
			<a target="_blank" href="<?php echo $_SESSION['username'];?>" class="btn btn-primary my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
  <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
  <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
</svg> Preview</a>
				<a target="_blank" href="<?php echo 'edit-template.php';?>" class="btn btn-success my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
  <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
  <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
</svg> Use this Template</a>
			</div>
        </div>
		</div>
      <div class="col-md-6 col-sm-12 col-xl-4 col-xxl-4 col-lg-4">
		<div class="card w-100 rounded border box-shadow mt-50">
			<div class="card-body p-20">
				<h2 class="fs-18">Demo Template</h2>
			</div>
			<div class="card-footer no-bdr bg-white p-20">
			<a target="_blank" href="<?php echo $_SESSION['username'];?>" class="btn btn-primary my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
  <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
  <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
</svg> Preview</a>
				<a target="_blank" href="<?php echo 'edit-template.php';?>" class="btn btn-success my-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
  <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
  <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
</svg> Use this Template</a>
			</div>
        </div>
		</div>
		
		<p class="mt-30 text-center fs-12"><a href="privacy-policy.php" target="_blank">Privacy Policy</a> | <a href="terms-of-service" target="_blank">Terms of Service</a></p>
    </div>
  </div>
</section>

<!-- Messenger Chat Plugin Code -->
    <div id="fb-root"></div>

    <!-- Your Chat Plugin code -->
    <div id="fb-customer-chat" class="fb-customerchat">
    </div>

    <script>
      var chatbox = document.getElementById('fb-customer-chat');
      chatbox.setAttribute("page_id", "107611955325757");
      chatbox.setAttribute("attribution", "biz_inbox");
    </script>

    <!-- Your SDK code -->
    <script>
      window.fbAsyncInit = function() {
        FB.init({
          xfbml            : true,
          version          : 'v14.0'
        });
      };

      (function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) return;
        js = d.createElement(s); js.id = id;
        js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';
        fjs.parentNode.insertBefore(js, fjs);
      }(document, 'script', 'facebook-jssdk'));
    </script>

<script src="okcc/js/easy.qrcode.min.js"></script>
<script>
var qrcode = new QRCode(document.getElementById("qrcode"), {
    text: "<?php echo "https://".$_SERVER['SERVER_NAME']."/".$_SESSION['username'];?>",
	width: 240,
	height: 240,
});
</script>
<script>
  if (self == top) {
    // Everything checks out, show the page.
    document.documentElement.style.display = 'block';
  } else {
    // Break out of the frame.
    top.location = self.location;
  }
</script>
  </body>
</html>