<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta property="og:title" content="ItsLink - Sign Up Page">
    <meta name="description" content="Sign Up Page">
    <meta property="og:description" content="Sign Up Page">
    <meta property="og:url" content="">
    <meta name="twitter:card" content="summary_large_image">
    <title>ItsLink - Sign Up Page</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/app.css" rel="stylesheet">
    <link rel="shortcut icon" href="assets/img/favicon.svg">
    <script src="okcc/js/jquery-min.js"></script>

    <script>
      $(function () {

        $('#username').on('input', function (e) {
		  $("#username").val($("#username").val().toLowerCase());
		  
          var usernamed = document.getElementById('username').value;
		 
		  //For check
		  var regexp = /^[a-z0-9@_-]+$/;
		  var checkuser = ""+usernamed+"";
          if (checkuser.search(regexp) === -1)
            { //alert('invalid'); 
				$("#valid-info").html('<span style="color: red;"><style>#signup{display:none;}#signup-off{display:block;}</style>Sorry, you can use only letters, digits and @ - _ without space.</span>');
			}else{ //alert('valid'); 
				$("#valid-info").html('');
			}
		  
          e.preventDefault();
          $.ajax({
            type: 'post',
            url: 'core.php',
            data: 'username='+usernamed,
            success: function (data) {
              $('#userres').html(data);
            }
          });

        });

      });
    </script>

    <style>
	  html {
		display : none;
	  }
      body {
        background-color: #3949AB;
      }

      .row {
        background-color: #ffffff;
      }
	  input {
		  padding: 10px 20px!important;
		  margin-bottom: 25px;
	  }
      .form-control:focus {
        background-color: #F4F5F3;
      }
	  #signup-off { 
	      display:none;
	  }
	  @media screen and (min-width:501px) and (max-width:1200px) {
		/* Tablet styles */
		 .container-fluid { width: 80%!important;}
		}
	  @media screen and (max-width:500px) {
		/* Mobile styles */
		 .container-fluid { width: 90%!important;}
		}
    </style>
  </head>
  <body>
  
  <section class="py-80">
      <div class="container-fluid" style="width:40%">
        <div class="row g-0 shadow rounded d-flex align-items-center">
          <div class="col p-30">
			<div style="width: 90%; float: left">
				<h1 class="fs-32">Sign Up</h1>
				<p class="text-muted">Create your free one-page site.</p>
			</div>
			<div style="width: 10%; float: left">
				<img class="w-100" src="assets/img/favicon.svg" alt="itslink logo">
			</div>
			<div class="p-10" style="clear: both;"></div>
            <form method="POST" action="core.php">
              <div class="mb-3" style="position: relative; margin-bottom: 45px!important;">
				<span style="position: absolute; top: 11px; padding-left: 20px; color: #512DA8;">itslink.me/</span>
                <!--<input style="padding-left: 100px!important;" type="text" onkeydown="return /^[a-z0-9@_-]+$/i.test(event.key)" name="username" id="username" placeholder="username" autofocus="autofocus" autocomplete="off" class="form-control btn-lg" required>-->
                <input style="padding-left: 100px!important;" type="text" name="username" id="username" placeholder="username" autofocus="autofocus" autocomplete="off" class="form-control btn-lg" required>
              <div style="margin-top: -20px;">
			  <span id="userres"></span>
			  <span id="valid-info"></span>
			  </div>
			  </div>
              <div class="mb-3">
                <input type="email" name="email" id="email" placeholder="Enter Email..." autofocus="autofocus" autocomplete="off" class="form-control btn-lg" required>
              </div>
              <div class="mb-3">
                <input type="password" name="password" id="password" placeholder="Enter Password..." autocomplete="off" class="form-control btn-lg" required>
              </div>             
              <input type="submit" name="register" id="signup" value="Sign up" class="btn btn-primary w-100 btn-lg">
			  <input type="submit" id="signup-off" value="Sign up" class="btn btn-danger w-100 btn-lg" disabled>  
            </form>
			<p class="mt-10 text-center fs-12">By clicking Sign Up, you agree to ItsLink's <a href="privacy-policy" target="_blank">Privacy Policy</a> & <a href="terms-of-service" target="_blank">TOS</a>.</p>
			<h5 class="mt-30 text-center">Have an account? <a href="login">Log In</a></h5>
          </div>
        </div>
      </div>
    </section>
<script>
  if (self == top) {
    // Everything checks out, show the page.
    document.documentElement.style.display = 'block';
  } else {
    // Break out of the frame.
    top.location = self.location;
  }
</script>
  </body>
</html>