<?php
//----------------------WOOCOMMERCE SHOP PAGE LAYOUT-----------------------------------
$wp_customize->add_setting('complete[woo_shop_page_layout_id]', array(
		'type' => 'option',
		'default'           => 'wooshop_layout3',
		'sanitize_callback' => 'sanitize_key',
	)
);

// Add the heaeder layout control.
$wp_customize->add_control('woo_shop_page_layout_id',array(
			'type' => 'select',
			'label'    => esc_html__( 'Woo Shop Page Layout *', 'complete' ),
			'section'  => 'wooshoplayout_section',
			'settings' => 'complete[woo_shop_page_layout_id]',
			'choices'  => array(
				'wooshop_layout1' => __('Shop Page Right Sidebar', 'complete'), 
				'wooshop_layout2' => __('Shop Page Left Sidebar', 'complete'),
				'wooshop_layout3' => __('Shop Page Full Width', 'complete'),
		  )
  ) );
  
//----------------------WOOCOMMERCE SINGLE PRODUCT LAYOUT-----------------------------------
$wp_customize->add_setting('complete[woo_single_product_layout_id]', array(
		'type' => 'option',
		'default'           => 'woosingle_layout3',
		'sanitize_callback' => 'sanitize_key',
	)
);

// Add the heaeder layout control.
$wp_customize->add_control('woo_single_product_layout_id',array(
			'type' => 'select',
			'label'    => esc_html__( 'Woo Single Product Layout *', 'complete' ),
			'section'  => 'woosinglelayout_section',
			'settings' => 'complete[woo_single_product_layout_id]',
			'choices'  => array(
				'woosingle_layout1' => __('Single Product Right Sidebar', 'complete'), 
				'woosingle_layout2' => __('Single Product Left Sidebar', 'complete'),
				'woosingle_layout3' => __('Single Product Full Width', 'complete'),
		  )
  ) );
//----------------------SINGLE POST LAYOUT-----------------------------------
$wp_customize->add_setting('complete[single_post_layout_id]', array(
		'type' => 'option',
		'default'           => 'single_layout1',
		'sanitize_callback' => 'sanitize_key',
	)
);

// Add the heaeder layout control.
$wp_customize->add_control('single_post_layout_id',array(
			'type' => 'select',
			'label'    => esc_html__( 'Single Post Layout *', 'complete' ),
			'section'  => 'singlelayout_section',
			'settings' => 'complete[single_post_layout_id]',
			'choices'  => array(
				'single_layout1' => __('Single Post Right Sidebar', 'complete'), 
				'single_layout2' => __('Single Post Left Sidebar', 'complete'),
				'single_layout3' => __('Single Post Full Width', 'complete'),
				'single_layout4' => __('Single Post No Sidebar', 'complete'),
		  )
  ) );

//----------------------SINGLE POST SECTION----------------------------------


//Single Post Meta
$wp_customize->add_setting('complete[post_info_id]', array(
	'type' => 'option',
	'default' => '1',
	'sanitize_callback' => 'complete_sanitize_checkbox',
	'transport' => 'postMessage',
) );
 
			$wp_customize->add_control( new complete_Controls_Toggle_Control( $wp_customize, 'post_info_id', array(
				'label' => __('Show Post Info','complete'),
				'section' => 'singlepost_section',
				'settings' => 'complete[post_info_id]',
			)) );


//NEXT/PREVIOUS Posts
$wp_customize->add_setting('complete[post_nextprev_id]', array(
	'type' => 'option',
	'default' => '1',
	'sanitize_callback' => 'complete_sanitize_checkbox',
	'transport' => 'postMessage',
) );
 
			$wp_customize->add_control( new complete_Controls_Toggle_Control( $wp_customize, 'post_nextprev_id', array(
				'label' => __('Next and Previous Posts','complete'),
				'description'  => __('Display Next and Previous Posts Under Single Post', 'complete' ),
				'section' => 'singlepost_section',
				'settings' => 'complete[post_nextprev_id]',
			)) );


///Show Comments
$wp_customize->add_setting('complete[post_comments_id]', array(
	'type' => 'option',
	'default' => '1',
	'sanitize_callback' => 'complete_sanitize_checkbox',
	'transport' => 'postMessage',
) );
 
			$wp_customize->add_control( new complete_Controls_Toggle_Control( $wp_customize, 'post_comments_id', array(
				'label' => __('Comments','complete'),
				'description'  => __('Show/Hide Comments in Posts and Pages', 'complete' ),
				'section' => 'singlepost_section',
				'settings' => 'complete[post_comments_id]',
			)) );



//----------------------PAGE HEADER SECTION----------------------------------

//Page Header Default Background color
$wp_customize->add_setting( 'complete[page_header_color]', array(
	'type' => 'option',
	'default' => '#545556',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'page_header_color', array(
				'label' => __('Page Header Background','complete'),
				'section' => 'pageheader_section',
				'settings' => 'complete[page_header_color]',
			) ) );
			
// Page Header Background Image
	$wp_customize->add_setting( 'complete[pageheader_bg_image]',array( 
		'type' => 'option',
		'default' => ''.get_template_directory_uri().'/images/default-header-img.jpg',
		'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pageheader_bg_image',array(
			'label'       => __( 'Page Header Background Image', 'complete' ),
			'section'     => 'pageheader_section',
			'settings'    => 'complete[pageheader_bg_image]'
				)
			)
	);
	
// Hide Page Header
	$wp_customize->add_setting('complete[hide_pageheader]',array(
			'type' => 'option',
			'default' => '',
			'sanitize_callback' => 'complete_sanitize_checkbox',
			'transport' => 'postMessage',
	));	 

	$wp_customize->add_control( new complete_Controls_Toggle_Control( $wp_customize, 'hide_pageheader', array(
		'label' => __('Hide Page Header','complete'),
		'section' => 'pageheader_section',
		'settings' => 'complete[hide_pageheader]',
	)) );
	
//----------------------POST HEADER SECTION----------------------------------

//Post Header Default Background color
$wp_customize->add_setting( 'complete[post_header_color]', array(
	'type' => 'option',
	'default' => '#545556',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_header_color', array(
				'label' => __('Post Header Background','complete'),
				'section' => 'postheader_section',
				'settings' => 'complete[post_header_color]',
			) ) );
			
// Post Header Background Image
	$wp_customize->add_setting( 'complete[postheader_bg_image]',array( 
		'type' => 'option',
		'default' => ''.get_template_directory_uri().'/images/default-header-img.jpg',
		'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'postheader_bg_image',array(
			'label'       => __( 'Posts Header Background Image', 'complete' ),
			'section'     => 'postheader_section',
			'settings'    => 'complete[postheader_bg_image]'
				)
			)
	);
	
// Hide Post Header
	$wp_customize->add_setting('complete[hide_postheader]',array(
			'type' => 'option',
			'default' => '',
			'sanitize_callback' => 'complete_sanitize_checkbox',
			'transport' => 'postMessage',
	));	 

	$wp_customize->add_control( new complete_Controls_Toggle_Control( $wp_customize, 'hide_postheader', array(
		'label' => __('Hide Post Header','complete'),
		'section' => 'postheader_section',
		'settings' => 'complete[hide_postheader]',
	)) );	
	
// Post Title Color
$wp_customize->add_setting( 'complete[post_box_title_color]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_box_title_color', array(
				'label' => __('Post Title Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_box_title_color]',
			) ) );			

// Post Title Hover Color
$wp_customize->add_setting( 'complete[post_box_title_hover_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_box_title_hover_color', array(
				'label' => __('Post Title Hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_box_title_hover_color]',
			) ) );			

// Post Meta Color
$wp_customize->add_setting( 'complete[post_box_meta_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_box_meta_color', array(
				'label' => __('Post Meta Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_box_meta_color]',
			) ) );			


// Post Date Color
$wp_customize->add_setting( 'complete[post_box_date_color]', array(
	'type' => 'option',
	'default' => '#292929',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_box_date_color', array(
				'label' => __('Post Date Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_box_date_color]',
			) ) );			


// Post Date Border Color
$wp_customize->add_setting( 'complete[post_box_date_border_color]', array(
	'type' => 'option',
	'default' => '#e9e9e9',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_box_date_border_color', array(
				'label' => __('Post Date Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_box_date_border_color]',
			) ) );	

////////////////////////////////
					
//----------------------BLOG PAGE SECTION----------------------------------


/*GET LIST OF CATEGORIES*/
$layercats = get_categories(); 
$newList = array();
foreach($layercats as $category) {
	$newList[$category->term_id] = $category->cat_name;
}	
//BLOG CATEGORY SELECT
//Page Header Default Text color
$wp_customize->add_setting( 'complete[blog_cat_id]', array(
	'type' => 'option',
	'default' => '',
	'sanitize_callback' => 'complete_sanitize_multicheck'
) );

$wp_customize->add_control( new complete_Multicheck_Control( $wp_customize, 'blog_cat_id', array(
        'type' => 'multicheck',
        'label' => __('Display Blog Posts from selected Categories *','complete'),
        'section' => 'blogpage_section',
        'choices' =>$newList,
		'settings'    => 'complete[blog_cat_id]'
)) );

//Blog Page Post Count
$wp_customize->add_setting('complete[blog_num_id]', array(
	'type' => 'option',
	'default' => '9',
	'sanitize_callback' => 'complete_sanitize_number',
) );
			$wp_customize->add_control('blog_num_id', array(
				'type' => 'text',
				'label' => __('Blog Page Posts Count *','complete'),
				'section' => 'blogpage_section',
				'settings' => 'complete[blog_num_id]',
							'input_attrs'	=> array(
								'class'	=> 'mini_control',
							)
			) );

///Blog Page Thumbnails
$wp_customize->add_setting('complete[show_blog_thumb]', array(
	'type' => 'option',
	'default' => '1',
	'sanitize_callback' => 'complete_sanitize_checkbox',
) );
 
				$wp_customize->add_control( new complete_Controls_Toggle_Control( $wp_customize, 'show_blog_thumb', array(
					'label' => __('Blog Page Thumbnails *','complete'),
					'section' => 'blogpage_section',
					'settings' => 'complete[show_blog_thumb]',
				)) );



//---------Post & Page Color SETTINGS---------------------	

//Post Title Color
$wp_customize->add_setting( 'complete[title_txt_color_id]', array(
	'type' => 'option',
	'default' => '#666666',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'title_txt_color_id', array(
				'label' => __('Single Post All Heading Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[title_txt_color_id]',
			) ) );
//---------SIDEBAR & WIDGET Color SETTINGS---------------------	

//Sidebar Widgets Background Color
$wp_customize->add_setting( 'complete[sidebar_color_id]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_color_id', array(
				'label' => __('Sidebar Widgets Background','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[sidebar_color_id]',
			) ) );
			
//Sidebar Widgets Border Color
$wp_customize->add_setting( 'complete[sidebarborder_color_id]', array(
	'type' => 'option',
	'default' => '#eeeff5',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebarborder_color_id', array(
				'label' => __('Sidebar Widgets Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[sidebarborder_color_id]',
			) ) );			


//Sidebar Widget Title Color
$wp_customize->add_setting( 'complete[sidebar_tt_color_id]', array(
	'type' => 'option',
	'default' => '#666666',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_tt_color_id', array(
				'label' => __('Sidebar Widget Title Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[sidebar_tt_color_id]',
			) ) );


//Sidebar Widget Text Color
$wp_customize->add_setting( 'complete[sidebartxt_color_id]', array(
	'type' => 'option',
	'default' => '#999999',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebartxt_color_id', array(
				'label' => __('Sidebar Widget Text Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[sidebartxt_color_id]',
			) ) );
			
//Sidebar Widget Link Color
$wp_customize->add_setting( 'complete[sidebarlink_color_id]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebarlink_color_id', array(
				'label' => __('Sidebar Widget Link Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[sidebarlink_color_id]',
			) ) );		
			
//Sidebar Widget Link Hover Color
$wp_customize->add_setting( 'complete[sidebarlink_hover_color_id]', array(
	'type' => 'option',
	'default' => '#999999',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebarlink_hover_color_id', array(
				'label' => __('Sidebar Widget Link Hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[sidebarlink_hover_color_id]',
			) ) );	
			
// Flipbox Front Bg Color
$wp_customize->add_setting( 'complete[flipbg_front_color_id]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'flipbg_front_color_id', array(
				'label' => __('Flip Box Front Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[flipbg_front_color_id]',
			) ) );
			
// Flipbox Back Bg Color
$wp_customize->add_setting( 'complete[flipbg_back_color_id]', array(
	'type' => 'option',
	'default' => '#f7f7f7',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'flipbg_back_color_id', array(
				'label' => __('Flip Box Back Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[flipbg_back_color_id]',
			) ) );
			
// Flipbox Front Border Color
$wp_customize->add_setting( 'complete[flipborder_front_color_id]', array(
	'type' => 'option',
	'default' => '#e0e0e0',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'flipborder_front_color_id', array(
				'label' => __('Flip Box Front Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[flipborder_front_color_id]',
			) ) );		
			
// Flipbox Back Border Color
$wp_customize->add_setting( 'complete[flipborder_back_color_id]', array(
	'type' => 'option',
	'default' => '#000000',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'flipborder_back_color_id', array(
				'label' => __('Flip Box Back Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[flipborder_back_color_id]',
			) ) );		
 
// Divider Color
$wp_customize->add_setting( 'complete[divider_color_id]', array(
	'type' => 'option',
	'default' => '#8c8b8b',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'divider_color_id', array(
				'label' => __('Divider Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[divider_color_id]',
			) ) );	
			
// Timeline Box Bg
$wp_customize->add_setting( 'complete[timebox_color_id]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'timebox_color_id', array(
				'label' => __('Timeline Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[timebox_color_id]',
			) ) );	
			
// Timeline Box Border
$wp_customize->add_setting( 'complete[timeboxborder_color_id]', array(
	'type' => 'option',
	'default' => '#dedede',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'timeboxborder_color_id', array(
				'label' => __('Timeline Box Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[timeboxborder_color_id]',
			) ) );		
			
//////////////////
// Grid Box Bg
$wp_customize->add_setting( 'complete[gridbox_color_id]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gridbox_color_id', array(
				'label' => __('Grid Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[gridbox_color_id]',
			) ) );	
			
// Grid Box Border
$wp_customize->add_setting( 'complete[gridboxborder_color_id]', array(
	'type' => 'option',
	'default' => '#cccccc',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gridboxborder_color_id', array(
				'label' => __('Grid Box Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[gridboxborder_color_id]',
			) ) );														
					
// Team Expand Box Background Color
$wp_customize->add_setting( 'complete[expand_bg_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expand_bg_color', array(
				'label' => __('Team Expand Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[expand_bg_color]',
			) ) );	
			
// Square Box Background Color
$wp_customize->add_setting( 'complete[square_bg_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'square_bg_color', array(
				'label' => __('Square Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[square_bg_color]',
			) ) );		
			
// Square Box Background Hover Color
$wp_customize->add_setting( 'complete[square_bg_hover_color]', array(
	'type' => 'option',
	'default' => '#79ab9f',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'square_bg_hover_color', array(
				'label' => __('Square Box Background Hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[square_bg_hover_color]',
			) ) );	
			
// Square Box Title Color
$wp_customize->add_setting( 'complete[square_title_color]', array(
	'type' => 'option',
	'default' => '#000000',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'square_title_color', array(
				'label' => __('Square Box Title Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[square_title_color]',
			) ) );		

// Post Style 3 Box Background Color
$wp_customize->add_setting( 'complete[style3_bg_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style3_bg_color', array(
				'label' => __('Post Style 3 Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[style3_bg_color]',
			) ) );	
			
// Post Style 3 Box Hover Background Color
$wp_customize->add_setting( 'complete[style3_hover_bg_color]', array(
	'type' => 'option',
	'default' => '#f1f1f1',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style3_hover_bg_color', array(
				'label' => __('Post Style 3 Box Hover Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[style3_hover_bg_color]',
			) ) );		
			
// Post Style 3 Box Border Color
$wp_customize->add_setting( 'complete[style3_border_color]', array(
	'type' => 'option',
	'default' => '#eaeaea',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style3_border_color', array(
				'label' => __('Post Style 3 Box Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[style3_border_color]',
			) ) );	

/*Post Style 4 COlor Setting*/		
// Post Style 4 Box Background Color
$wp_customize->add_setting( 'complete[style4_bg_box_color]', array(
	'type' => 'option',
	'default' => '#f0f3f6',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_bg_box_color', array(
	'label' => __('Post Style 4 Box Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_bg_box_color]',
)) );
// Post Style 4 Title Color
$wp_customize->add_setting( 'complete[style4_title_color]', array(
	'type' => 'option',
	'default' => '#1c1c1c',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_title_color', array(
	'label' => __('Post Style 4 Title Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_title_color]',
)) );
// Post Style 4 Title Hover Color
$wp_customize->add_setting( 'complete[style4_title_hvr_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_title_hvr_color', array(
	'label' => __('Post Style 4 Title Hover Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_title_hvr_color]',
)) );
// Post Style 4 Meta Info Color
$wp_customize->add_setting( 'complete[style4_info_color]', array(
	'type' => 'option',
	'default' => '#1c1c1c',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_info_color', array(
	'label' => __('Post Style 4 Meta Info Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_info_color]',
)) );
// Post Style 4 Hover Image Background Color
$wp_customize->add_setting( 'complete[style4_imghvr_bgcolor]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_imghvr_bgcolor', array(
	'label' => __('Post Style 4 Hover Image Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_imghvr_bgcolor]',
)) );
// Post Style 4 Hover Image Icon Color
$wp_customize->add_setting( 'complete[style4_imghvr_bgcolor]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_imghvr_bgcolor', array(
	'label' => __('Post Style 4 Hover Image Icon Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_imghvr_bgcolor]',
)) );
// Post Style 4 First Post Title Color
$wp_customize->add_setting( 'complete[style4_frstpost_title_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_frstpost_title_color', array(
	'label' => __('Post Style 4 First Post Title Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_frstpost_title_color]',
)) );
// Post Style 4 First Post Title Hover Color
$wp_customize->add_setting( 'complete[style4_frstpost_title_hvr_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_frstpost_title_hvr_color', array(
	'label' => __('Post Style 4 First Post Title Hover Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_frstpost_title_hvr_color]',
)) );
// Post Style 4 First Post Meta Info Color
$wp_customize->add_setting( 'complete[style4_frstpost_meta_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'style4_frstpost_meta_color', array(
	'label' => __('Post Style 4 First Post Meta Info Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[style4_frstpost_meta_color]',
)) );
/////

/*Home Post Color Setting*/
// Post Box Background Color
$wp_customize->add_setting( 'complete[post_box_bgcolor]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_box_bgcolor', array(
				'label' => __('Post Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_box_bgcolor]',
			) ) );
			
// Post Title Color
$wp_customize->add_setting( 'complete[post_title_color]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_title_color', array(
				'label' => __('Post Title Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_title_color]',
			) ) );

// Post Meta Color
$wp_customize->add_setting( 'complete[post_meta_color]', array(
	'type' => 'option',
	'default' => '#6a6a6a',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_meta_color', array(
				'label' => __('Post Meta Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_meta_color]',
			) ) );

// Post Readmore Color
$wp_customize->add_setting( 'complete[post_readmore_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_readmore_color', array(
				'label' => __('Post Readmore Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_readmore_color]',
			) ) );
			
// Post Readmore Hover Color
$wp_customize->add_setting( 'complete[post_readmore_hvrcolor]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_readmore_hvrcolor', array(
				'label' => __('Post Readmore Hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[post_readmore_hvrcolor]',
			) ) );
///////

// Perfect Box Background Color
$wp_customize->add_setting( 'complete[perfect_bg_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'perfect_bg_color', array(
				'label' => __('Perfect Box Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[perfect_bg_color]',
			) ) );		
			
// Perfect Box Border Color
$wp_customize->add_setting( 'complete[perfect_border_color]', array(
	'type' => 'option',
	'default' => '#eaeaea',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'perfect_border_color', array(
				'label' => __('Perfect Box Border Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[perfect_border_color]',
			) ) );	
			
// Perfect Box Hover Border Color
$wp_customize->add_setting( 'complete[perfect_hover_border_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'perfect_hover_border_color', array(
				'label' => __('Perfect Box Border Hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[perfect_hover_border_color]',
			) ) );	
			
// Heading Seprator Color
$wp_customize->add_setting( 'complete[h_seprator_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'h_seprator_color', array(
				'label' => __('Heading Seprator Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[h_seprator_color]',
			) ) );	
			
// Heading Seprator Text Color
$wp_customize->add_setting( 'complete[h_seprator_text_color]', array(
	'type' => 'option',
	'default' => '#000000',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'h_seprator_text_color', array(
				'label' => __('Heading Seprator Text Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[h_seprator_text_color]',
			) ) );

// Post Background Color
$wp_customize->add_setting( 'complete[homepost_box_bgcolor]', array(
	'type' => 'option',
	'default' => '#f8f8f8',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'homepost_box_bgcolor', array(
				'label' => __('Post Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[homepost_box_bgcolor]',
			) ) );
			
/*Team Color Setting*/
// Team Title Color
$wp_customize->add_setting( 'complete[team_title_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'team_title_color', array(
	'label' => __('Team Title Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[team_title_color]',
)) );
// Team Title Hover Color
$wp_customize->add_setting( 'complete[team_title_hvrcolor]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'team_title_hvrcolor', array(
	'label' => __('Team Title Hover Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[team_title_hvrcolor]',
)) );
// Team Designation Color
$wp_customize->add_setting( 'complete[team_designation_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'team_designation_color', array(
	'label' => __('Team Designation Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[team_designation_color]',
)) );
// Team Box Hover Background Color
$wp_customize->add_setting( 'complete[teambox_hvr_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'teambox_hvr_color', array(
	'label' => __('Team Box Hover Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[teambox_hvr_color]',
)) );
/*Testimonial Colors*/
// SKT Testimonial Slider Box Background Color
$wp_customize->add_setting( 'complete[skt_testimonial_box_bg_color]', array(
  'type' => 'option',
  'default' => '#ffffff',
  'sanitize_callback' => 'sanitize_hex_color',
  'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'skt_testimonial_box_bg_color', array(
  'label' => __('Testimonial Slider Box Background Color','complete'),
  'section' => 'general_color_section',
  'settings' => 'complete[skt_testimonial_box_bg_color]',
)) );

// SKT Testimonial Slider Title Color
$wp_customize->add_setting( 'complete[skt_testimonial_box_title_color]', array(
  'type' => 'option',
  'default' => '#1c1c1c',
  'sanitize_callback' => 'sanitize_hex_color',
  'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'skt_testimonial_box_title_color', array(
  'label' => __('Testimonial Slider Title Color','complete'),
  'section' => 'general_color_section',
  'settings' => 'complete[skt_testimonial_box_title_color]',
)) );

// SKT Testimonial Slider Text Color
$wp_customize->add_setting( 'complete[skt_testimonial_box_text_color]', array(
  'type' => 'option',
  'default' => '#1c1c1c',
  'sanitize_callback' => 'sanitize_hex_color',
  'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'skt_testimonial_box_text_color', array(
  'label' => __('Testimonial Slider Text Color','complete'),
  'section' => 'general_color_section',
  'settings' => 'complete[skt_testimonial_box_text_color]',
)) );

// SKT Testimonial Slider Pager Color
$wp_customize->add_setting( 'complete[skt_testimonial_pager_color]', array(
  'type' => 'option',
  'default' => '#ff7366',
  'sanitize_callback' => 'sanitize_hex_color',
  'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'skt_testimonial_pager_color', array(
  'label' => __('Testimonial Slider Pager Color','complete'),
  'section' => 'general_color_section',
  'settings' => 'complete[skt_testimonial_pager_color]',
)) );

// SKT Testimonial Slider Active Pager Color
$wp_customize->add_setting( 'complete[skt_testimonial_active_pager_color]', array(
  'type' => 'option',
  'default' => '#1c1c1c',
  'sanitize_callback' => 'sanitize_hex_color',
  'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'skt_testimonial_active_pager_color', array(
  'label' => __('Testimonial Slider Active Pager Color','complete'),
  'section' => 'general_color_section',
  'settings' => 'complete[skt_testimonial_active_pager_color]',
)) );

/*Shop Category*/
// Shop Category Box BG Color
$wp_customize->add_setting( 'complete[shop_category_box_bgcolor]', array(
	'type' => 'option',
	'default' => '#f8f8f8',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_bgcolor', array(
	'label' => __('Shop Category Box Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_bgcolor]',
)) );
// Shop Category Box Hover BG Color
$wp_customize->add_setting( 'complete[shop_category_box_hover_bgcolor]', array(
	'type' => 'option',
	'default' => '#edecec',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_hover_bgcolor', array(
	'label' => __('Shop Category Box Hover Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_hover_bgcolor]',
)) );	
// Shop Category Box Border Color
$wp_customize->add_setting( 'complete[shop_category_box_border_color]', array(
	'type' => 'option',
	'default' => '#e9e8e8',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_border_color', array(
	'label' => __('Shop Category Box Border Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_border_color]',
)) );
// Shop Category Box Title Color
$wp_customize->add_setting( 'complete[shop_category_box_title_color]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_title_color', array(
	'label' => __('Shop Category Box Title Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_title_color]',
)) );
// Shop Category Box Button BG Color
$wp_customize->add_setting( 'complete[shop_category_box_btn_bgcolor]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_btn_bgcolor', array(
	'label' => __('Shop Category Box Button Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_btn_bgcolor]',
)) );
// Shop Category Box Button Color
$wp_customize->add_setting( 'complete[shop_category_box_btn_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_btn_color', array(
	'label' => __('Shop Category Box Button Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_btn_color]',
)) );	
// Shop Category Box Button Hover BG Color
$wp_customize->add_setting( 'complete[shop_category_box_hvrbtn_bgcolor]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_hvrbtn_bgcolor', array(
	'label' => __('Shop Category Box Button Hover Background Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_hvrbtn_bgcolor]',
)) );
// Shop Category Box Button Color
$wp_customize->add_setting( 'complete[shop_category_box_hvrbtn_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'shop_category_box_hvrbtn_color', array(
	'label' => __('Shop Category Box Button Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[shop_category_box_hvrbtn_color]',
)) );

/*Product Slider*/
// Product Slider Title Color
$wp_customize->add_setting( 'complete[product_slider_title_color]', array(
	'type' => 'option',
	'default' => '#252525',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_slider_title_color', array(
	'label' => __('Product Slider Title Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[product_slider_title_color]',
)) );
// Product Slider Title Hover Color
$wp_customize->add_setting( 'complete[product_slider_title_hvr_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_slider_title_hvr_color', array(
	'label' => __('Product Slider Title Hover Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[product_slider_title_hvr_color]',
)) );
// Product Slider Arrow Color
$wp_customize->add_setting( 'complete[product_slider_arrow_color]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_slider_arrow_color', array(
	'label' => __('Product Slider Arrow Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[product_slider_arrow_color]',
)) );
// Product Slider Arrow Hover Color
$wp_customize->add_setting( 'complete[product_slider_arrow_hvr_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_slider_arrow_hvr_color', array(
	'label' => __('Product Slider Arrow Hover Color','complete'),
	'section' => 'general_color_section',
	'settings' => 'complete[product_slider_arrow_hvr_color]',
)) );

// Product Title Color
$wp_customize->add_setting( 'complete[product_title_color]', array(
	'type' => 'option',
	'default' => '#222222',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_title_color', array(
				'label' => __('Product Title Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[product_title_color]',
			) ) );


// Product Title hover Color
$wp_customize->add_setting( 'complete[product_title_hover_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_title_hover_color', array(
				'label' => __('Product Title hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[product_title_hover_color]',
			) ) );

// Product Price Color
$wp_customize->add_setting( 'complete[product_price_color]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_price_color', array(
				'label' => __('Product Price Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[product_price_color]',
			) ) );

// Product Button Bg Color
$wp_customize->add_setting( 'complete[product_button_bg_color]', array(
	'type' => 'option',
	'default' => '#ff7366 ',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_button_bg_color', array(
				'label' => __('Product Button Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[product_button_bg_color]',
			) ) );

// Product Button Text Color
$wp_customize->add_setting( 'complete[product_button_text_color]', array(
	'type' => 'option',
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_button_text_color', array(
				'label' => __('Product Button Text Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[product_button_text_color]',
			) ) );

// Product Button Bg Color
$wp_customize->add_setting( 'complete[product_button_hover_bg_color]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'product_button_hover_bg_color', array(
				'label' => __('Product Button Background Hover Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[product_button_hover_bg_color]',
			) ) );	
			
// WooCommerce Button Text Color
$wp_customize->add_setting( 'complete[woocom_button_text_color]', array(
	'type' => 'option',
	'default' => '#fff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'woocom_button_text_color', array(
				'label' => __('WooCommerce Button Text Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[woocom_button_text_color]',
			) ) );

// WooCommerce Button BG Color
$wp_customize->add_setting( 'complete[woocom_button_bg]', array(
	'type' => 'option',
	'default' => '#ff7366',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'woocom_button_bg', array(
				'label' => __('WooCommerce Button Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[woocom_button_bg]',
			) ) );

// WooCommerce Button Hover Text Color
$wp_customize->add_setting( 'complete[woocom_button_text_hover_color]', array(
	'type' => 'option',
	'default' => '#fff',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'woocom_button_text_hover_color', array(
				'label' => __('WooCommerce Button Hover Text Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[woocom_button_text_hover_color]',
			) ) );

// WooCommerce Button Hover BG Color
$wp_customize->add_setting( 'complete[woocom_hover_button_bg]', array(
	'type' => 'option',
	'default' => '#282828',
	'sanitize_callback' => 'sanitize_hex_color',
	'transport' => 'postMessage',
) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'woocom_hover_button_bg', array(
				'label' => __('WooCommerce Button Hover Background Color','complete'),
				'section' => 'general_color_section',
				'settings' => 'complete[woocom_hover_button_bg]',
			) ) );																			

//Sidebar Widget Title Font Size
$wp_customize->add_setting('complete[wgttitle_size_id]', array(
	'type' => 'option',
	'default' => '16px',
	'sanitize_callback' => 'sanitize_text_field',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control('wgttitle_size_id', array(
				'type' => 'text',
				'label' => __('Sidebar Widget Title Font Size','complete'),
				'section' => 'postpage_color_section',
				'settings' => 'complete[wgttitle_size_id]',
			) );
			
			
//============================ Contact Page =================================

//Contact Title
$wp_customize->add_setting('complete[contact_title]', array(
	'type' => 'option',
	'default' => __('Contact Info','complete'),
	'sanitize_callback' => 'wp_kses_post',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control(	new WP_Customize_Text_Control( $wp_customize, 'contact_title', array( 
				'type' => 'text',
				'label' => __('Contact Title','complete'), 
				'section' => 'contactpage_section',
				'settings' => 'complete[contact_title]',
			)) );	
			
//Contact Address
$wp_customize->add_setting('complete[contact_address]', array(
	'type' => 'option',
	'default' => __('Donec ultricies mattis nulla Australia','complete'),
	'sanitize_callback' => 'wp_kses_post',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control(	new WP_Customize_Textarea_Control( $wp_customize, 'contact_address', array( 
				'type' => 'textarea',
				'label' => __('Company Address','complete'),  
				'section' => 'contactpage_section',
				'settings' => 'complete[contact_address]',
			)) );
			
//Contact Phone
$wp_customize->add_setting('complete[contact_phone]', array(
	'type' => 'option',
	'default' => __('0789 256 321','complete'),
	'sanitize_callback' => 'wp_kses_post',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control(	new WP_Customize_Text_Control( $wp_customize, 'contact_phone', array( 
				'type' => 'text',
				'label' => __('Phone Number','complete'), 
				'section' => 'contactpage_section',
				'settings' => 'complete[contact_phone]',
			)) );	
			
//Contact Email
$wp_customize->add_setting('complete[contact_email]', array(
	'type' => 'option',
	'default' => __('info@companyname.com','complete'),
	'sanitize_callback' => 'wp_kses_post',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control(	new WP_Customize_Text_Control( $wp_customize, 'contact_email', array( 
				'type' => 'text',
				'label' => __('Email Address','complete'), 
				'section' => 'contactpage_section',
				'settings' => 'complete[contact_email]',
			)) );	
			
//Company URL
$wp_customize->add_setting('complete[contact_company_url]', array(
	'type' => 'option',
	'default' => __('','complete'),
	'sanitize_callback' => 'wp_kses_post',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control(	new WP_Customize_Text_Control( $wp_customize, 'contact_company_url', array( 
				'type' => 'text',
				'label' => __('Company URL with http://','complete'), 
				'section' => 'contactpage_section',
				'settings' => 'complete[contact_company_url]',
			)) );		
			
//Google Map
$wp_customize->add_setting('complete[contact_google_map]', array(
	'type' => 'option',
	'default' => __('https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d336003.6066860609!2d2.349634820486094!3d48.8576730786213!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e1f06e2b70f%3A0x040b82c3688c9460!2sParis%2C+France!5e0!3m2!1sen!2sin!4v1433482358672','complete'),
	'sanitize_callback' => 'wp_kses_post',
	'transport' => 'postMessage',
) );
			$wp_customize->add_control(	new WP_Customize_Textarea_Control( $wp_customize, 'contact_google_map', array( 
				'type' => 'textarea',
				'label' => __('Google Map','complete'),  
				'section' => 'contactpage_section',
				'settings' => 'complete[contact_google_map]',
			)) );														